use common::sense; use open qw/:std :utf8/;  use Carp qw//; use File::Basename qw//; use File::Slurper qw//; use File::Spec qw//; use File::Path qw//; use Scalar::Util qw//;  use Test::More 0.98;  BEGIN {     $SIG{__DIE__} = sub {         my ($s) = @_;         if(ref $s) {             $s->{STACKTRACE} = Carp::longmess "?" if "HASH" eq Scalar::Util::reftype $s;             die $s;         } else {             die Carp::longmess defined($s)? $s: "undef"         }     };      my $t = File::Slurper::read_text(__FILE__);     my $s =  '/tmp/.liveman/perl-config/config'    ;     File::Path::rmtree($s) if -e $s;     File::Path::mkpath($s);     chdir $s or die "chdir $s: $!";      while($t =~ /^#\@> (.*)\n((#>> .*\n)*)#\@< EOF\n/gm) {         my ($file, $code) = ($1, $2);         $code =~ s/^#>> //mg;         File::Path::mkpath(File::Basename::dirname($file));         File::Slurper::write_text($file, $code);     }  } # 
# # NAME
# 
# config - Конфигуратор констант Perl-модуля
# 
# # VERSION
# 
# 1.4.2
# 
# # SYNOPSIS
# 
# Файл lib/Weapons.pm:
#@> lib/Weapons.pm
#>> package Weapons;
#>> 
#>> use config DAGGER => "mizericordia";
#>> 
#>> 1;
#@< EOF
# 
# Файл .config.pm:
#@> .config.pm
#>> package config;
#>> 
#>> config Weapons => (
#>>     DAGGER => "horn",
#>> );
#>> 
#>> 1;
#@< EOF
# 
# Что должно получиться:
subtest 'SYNOPSIS' => sub { 
use lib 'lib';
use Weapons;

::is scalar do {Weapons::DAGGER}, "horn", 'Weapons::DAGGER # => horn';

# 
# # DESCRIPTION
# 
# `use config` создаёт константу так же как `use constant`, но берёт значение из локального конфиг-файла проекта, если она там указана.
# 
# Файл конфига **./.config.pm** находится в корневой директории проекта.
# 
# Текущая директория в проекте должна соответствовать корню проекта.
# 
# Так как модуль прагмы `config.pm` перекрыт на <metacpan.org> файлом `config.pod` из пакета `WordNet-Similarity`, то используется этот мануал ([config::Manual](blob/master/lib/config/Manual.md)).
# 
# # AUTHOR
# 
# Yaroslav O. Kosmina <dart@cpan.org>
# 
# # LICENSE
# 
# ⚖ **Perl5**
# 
# # COPYRIGHT
# 
# The config module is copyright (c) 2023 Yaroslav O. Kosmina. Rusland. All rights reserved.
	done_testing;
};

done_testing;
