use warnings;
use strict;
use feature 'say';
use Data::Dumper;
use List::Util qw/max min/;

use Optimization::NSGAII qw/ f_Optim_NSGAII /;

# decomment only one case and then execute

my $case = 'CONSTR';
#my $case = 'FON';
#my $case = 'KUR';
#my $case = 'SCH';
#my $case = 'TNK';
#my $case = 'ZDT1';
#my $case = 'ZDT2';
#my $case = 'ZDT3';
#my $case = 'ZDT4';
#my $case = 'ZDT6';
#my $case = 'mono-objective';

# set work directory 'filesDir'
# 'filesDir' work directory can also be defined in ram by giving for example 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs' and then using /mnt/tmpfs
my $workdir = '/tmp';

##############################################################################################

my $pi = 3.14159265;
my $a_Gaussian_distrib = [-0.126552767332602,-0.124184833892298,-0.123850245771661,-0.123059544908239,-0.108536045218461,-0.108490455873466,-0.100265321848112,-0.099336861185447,-0.099020119889618,-0.097238287101082,-0.096818240899097,-0.094121589836443,-0.093926985711317,-0.092836016023371,-0.092005499073065,-0.090215050273506,-0.089677613720452,-0.088006114910809,-0.087918364584143,-0.087384053714757,-0.083186250872599,-0.082947584866554,-0.081915340273467,-0.081674777995713,-0.081125825339507,-0.08018331770188,-0.07958176315598,-0.078763373586161,-0.076361874452213,-0.0758039128666,-0.075192767348595,-0.074828584393573,-0.07385478581639,-0.073417462315762,-0.073326919291812,-0.072410437760289,-0.072369450238867,-0.06822533133922,-0.067541282136129,-0.067027294848943,-0.065569305652918,-0.064946825958067,-0.064492645582761,-0.06431612552763,-0.06408430645047,-0.062512196791939,-0.061465862704217,-0.060771119433615,-0.059890953447754,-0.058587354337482,-0.058343831506988,-0.056130122802563,-0.055368448755907,-0.055140324409331,-0.054366965848978,-0.053969474966137,-0.052065856301153,-0.051960539343234,-0.051300323988468,-0.049732894124879,-0.049208789753907,-0.047766599250157,-0.047261085380438,-0.047094056448582,-0.047073697340933,-0.046679472166131,-0.046257186406462,-0.046224260521509,-0.045824679055949,-0.045051810509039,-0.044934699317466,-0.043915684840997,-0.043733328847816,-0.043306080618606,-0.042880687853995,-0.042558234779959,-0.041122692795902,-0.041028937023039,-0.040359013677161,-0.040339456866299,-0.037540815139332,-0.036326388785047,-0.036154701123524,-0.035889131920911,-0.035293390707607,-0.035137908154844,-0.034975414916706,-0.034458451137207,-0.034320348658017,-0.033729313312596,-0.033579638436086,-0.033488635126438,-0.033258638680425,-0.032865500317595,-0.032472794171676,-0.032223021650734,-0.031795607280537,-0.03162967124853,-0.031603252577906,-0.031435979151288,-0.030110699598099,-0.030029891332627,-0.029813320893966,-0.029341470064056,-0.029317397868644,-0.028859849755164,-0.028562634283549,-0.028171884333171,-0.027726542897015,-0.026923498537139,-0.02687105086103,-0.02669067119419,-0.026639027594616,-0.026623510692149,-0.026502217613141,-0.026306892902042,-0.025101973658881,-0.024829369039305,-0.024278033931223,-0.024055052989489,-0.023728083921173,-0.023431362574378,-0.023155865499278,-0.022494970304758,-0.021543313608726,-0.021408819633352,-0.02098663205144,-0.020509810901131,-0.019023702471009,-0.018886087393564,-0.018739723640119,-0.018563218371704,-0.01744610641705,-0.016901964535819,-0.015737597055677,-0.015115245398499,-0.015011329715041,-0.01490831686522,-0.01471321691377,-0.014704066082059,-0.01461092580066,-0.014438912423706,-0.014173117529125,-0.013722385184909,-0.013286202663347,-0.013083249502008,-0.012370076456976,-0.012256121525491,-0.01220152954189,-0.011974222430743,-0.011730953678111,-0.011653508611607,-0.011542180090791,-0.011246147846662,-0.01121509171997,-0.011146425764757,-0.010430351637167,-0.010400116315859,-0.010363820661031,-0.010332748135793,-0.010289307037594,-0.010214055388945,-0.009123998038235,-0.009054588437119,-0.008922621949386,-0.00863689614146,-0.008627377190595,-0.008335160688962,-0.008225726563662,-0.008014807693791,-0.007830033795929,-0.007480743874798,-0.006987534600174,-0.006082833887047,-0.005108443344733,-0.0043945259487,-0.004068547148139,-0.004056744499422,-0.003932258136843,-0.003920738275934,-0.003711643644404,-0.003253942969145,-0.002938732845359,-0.002364058167866,-0.001740845557155,-0.001706638860694,-0.001493607232092,-0.000929642670667,-0.000723588319652,-0.000651096023908,-0.000407115136405,-0.000151750412256,0.000360514102346,0.0008125076205,0.001261696768208,0.001598075392741,0.001745782068555,0.001761983773867,0.00176385404844,0.002287067219997,0.002583977608041,0.002947038321649,0.003125948779926,0.003601954230342,0.003669329444394,0.004210211632231,0.004241282341812,0.004838606598222,0.005259196695278,0.005394712958512,0.005716152018998,0.005745520979105,0.006244151916441,0.006277431443008,0.00629180643632,0.006341452145487,0.006585875625817,0.006730699593953,0.006867108831871,0.006926920765286,0.007083786320345,0.007231309715251,0.007836460077933,0.008029331223673,0.008047877789025,0.008266905524803,0.008551462176534,0.008655529713479,0.008913570234672,0.009109808414259,0.009288069344839,0.009373924856012,0.009527004348714,0.009650605726431,0.009779481630216,0.009785932899812,0.009834865506333,0.009859716090185,0.010001493843748,0.010283575641002,0.010653989341186,0.010956721890687,0.011528221759694,0.011825325305054,0.011913811462871,0.012001378561667,0.012959636485778,0.013623233975225,0.013636051226599,0.013711909023028,0.014464230868162,0.014545565027191,0.01544590172161,0.016270438884019,0.016328069275395,0.0163289398519,0.01724830810307,0.017565368874886,0.018384504295601,0.018537570276765,0.018810485072031,0.019211736935688,0.019367698135116,0.019405328958307,0.019827779418084,0.02009875229213,0.020293282441949,0.020338791467675,0.02054759602326,0.020774481692277,0.020964409638549,0.021219942043821,0.021452636477171,0.021669437362338,0.021767740078823,0.021852083779092,0.022444790583506,0.022811121102747,0.022826636898226,0.024089649754241,0.024874137853445,0.024933176283471,0.025202449966997,0.025827699455891,0.025886814537976,0.025948958167712,0.026054888875697,0.026461759632617,0.02681388228252,0.026857035593157,0.027167104791521,0.028055102078254,0.028506726616058,0.028534450298026,0.029036887603686,0.03008698516978,0.030469285437896,0.030571574388609,0.031232723820284,0.031495309095002,0.03211064048744,0.033510768880711,0.034071107814156,0.034101256838084,0.034513701897125,0.034903465178378,0.034986850148737,0.035905801204883,0.036039233881749,0.036051033747065,0.036301119973675,0.03698215211072,0.037034412329232,0.037312034373806,0.037925631401787,0.038053824822622,0.038368836918606,0.038575826963115,0.038805245836416,0.039049512972094,0.039414141315165,0.039935221711919,0.039953996631094,0.040025912352534,0.040066590602892,0.041867814064641,0.043730222758929,0.044007715456773,0.04402211657695,0.046224801244642,0.046490243405544,0.046511533594137,0.049380735360799,0.049569131814962,0.050019693491479,0.050731407129425,0.053909618975122,0.053933024350625,0.05407467428704,0.054773573920382,0.055316496094078,0.05569480912706,0.056420129942627,0.057053691894873,0.057244637431286,0.057775523208997,0.058316606967604,0.059879575628524,0.060139634546388,0.060221661348568,0.061029243809417,0.061122463490992,0.061208424274151,0.061754568938803,0.062036181620534,0.062461486894532,0.063899301761217,0.064105636033852,0.064243598168751,0.06536093944066,0.065795676268663,0.066006068294641,0.067048533923457,0.068160124558617,0.069459327771045,0.070314642067638,0.07106976991784,0.071100174949561,0.072231543182124,0.072997823733677,0.073417802173528,0.073944609778083,0.074013073478014,0.074542896774372,0.075382507959084,0.076659108649154,0.080224085115224,0.081903607151747,0.08335771765952,0.083473450783315,0.083943996778105,0.084826479674205,0.085684736492997,0.085705453827743,0.086447372731017,0.086451998946279,0.092325829703238,0.092964559115019,0.094058969063154,0.095631069024163,0.099152806647037,0.099393399610832,0.099650078834012,0.100255269978864,0.101434675278627,0.101563960521336,0.102570374909497,0.106455929135734,0.117071961882639,0.150905025116288];

##############################################################################################
if ($case eq 'CONSTR'){

sub f_CONSTR {
	
	my $x = shift;
	
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	my $f2 = (1 + $x->[1])/$x->[0];
	
	my $out = [$f1,$f2];
	
	return $out;
}

my sub f_ineq {
	my $x =shift;
	
	# equation >= 0 
	my @errs = 
		(
		 $x->[1] + 9*$x->[0] - 6 ,
		-$x->[1] + 9*$x->[0] -1 
		);
		
	return \@errs;
}

my $bounds = [[0.1,1],[0,5]];

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 100,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_CONSTR,
		'f_ineq' 		=> \&f_ineq, 
		'nProc'			=> 1,
		'filesDir'		=> $workdir,                          
        'verboseFinal'  => 1,
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0.1,1],
		'ylim'		=> [0,10],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'FON'){

sub f_FON {
	
	my $x = shift;
	
	my $n = scalar(@$x);
	
	my $sum = 0;	
	for my $i(0..$n-1){ $sum += -($x->[$i] - 1/sqrt(3))**2 } ;	
	my $f1 = 1 - exp($sum);
	
	$sum = 0;	
	for my $i(0..$n-1){ $sum += -($x->[$i] + 1/sqrt(3))**2 } ;	
	my $f2 = 1 - exp($sum);

	my $out = [$f1,$f2];
	
	return $out;
};

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> [[-$pi,$pi],[-$pi,$pi],[-$pi,$pi]],
		'function' 		=> \&f_FON,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [0,1],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'KUR'){

sub f_KUR {
	
	my $x = shift;
	
	my $n = scalar(@$x);
	
	my $f1 = 0;
	map {$f1 += -10*exp(-0.2*sqrt( ($x->[$_])**2 + ($x->[$_+1])**2 ))} 0..$n-2;
	my $f2 = 0;
	map {$f2 += (abs($x->[$_]))**0.8 + 5*(sin(($x->[$_])**3)) } 0..$n-1;
	
	my $out = [$f1,$f2];
	
	return $out;
}

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> [[-5,5],[-5,5],[-5,5]],
		'function' 		=> \&f_KUR,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,		
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [-20,-14],
		'ylim'		=> [-12,2],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'SCH'){

sub f_SCH {
	
	my $x = shift;
	
	my $f1 = ($x->[0])**2;
	my $f2 = ($x->[0]-2)**2;
	
	my $out = [$f1,$f2];
	
	return $out;
}

f_Optim_NSGAII(
	{	
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> [[-1000,1000]],
		'function' 		=> \&f_SCH,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	}, 
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,4],
		'ylim'		=> [0,4],
		'nfun'		=> [0,1],
	}	
);
}
##############################################################################################
if ($case eq 'TNK'){

sub f_TNK {
	
	my $x = shift;
	
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	my $f2 = $x->[1];
	
	my $out = [$f1,$f2];
	
	return $out;
}

my sub f_ineq {
	my $x =shift;
	
	# equation >= 0 
	my @errs = 
		(
		$x->[0]**2 + $x->[1]**2 -1 - 0.1*cos(16*atan2($x->[0],$x->[1])),
		-($x->[0] - 0.5)**2 - ($x->[1] - 0.5)**2 + 0.5
		);
		
	return \@errs;
}

my $bounds = [[0,$pi],[0,$pi]];

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_TNK,
		'f_ineq' 		=> \&f_ineq, 
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1.4],
		'ylim'		=> [0,1.4],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'ZDT1'){

sub f_ZDT1 {
	
	my $x = shift;
		
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	
	my $sum = 0;	
	for (1..$n-1){$sum += $x->[$_]} ; # ZTD 1 2
	
	my $g  = 1 + 9*$sum/($n-1); # ZDT 1 2
	my $f2 = $g*(1-sqrt($x->[0]/$g)); # ZDT 1 4
	
	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..30){
	push @$bounds, [0,1];
}
	
f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT1,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,
        'verboseFinal'  => 1,
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [0,1],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'ZDT2'){

sub f_ZDT2 {
	
	my $x = shift;

	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	
	my $sum = 0;	
	for (1..$n-1){$sum += $x->[$_]} ; # ZTD 1 2

	my $g  = 1 + 9*$sum/($n-1); # ZDT 1 2
	my $f2 = $g*(1-(($x->[0])/$g)**2); # ZDT 2

	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..30){
	push @$bounds, [0,1];
}
	
f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT2,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,
        'verboseFinal'  => 1,
        'distrib'       => $a_Gaussian_distrib,
        #'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [0,1],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'ZDT3'){

sub f_ZDT3 {
	
	my $x = shift;
	
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	
	my $sum = 0;	
	for my $i(1..$n-1){$sum += $x->[$i]} ; 
	my $g = 1+ 9*$sum/($n - 1);

	my $f2 = $g*(1 - sqrt($x->[0]/$g) - $x->[0]/$g*sin(10*$pi*$x->[0])); 

	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..30){
	push @$bounds, [0,1];
}
	
f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT3,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,
        'verboseFinal'  => 1,
        'distrib'       => $a_Gaussian_distrib,
#        'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [-1,1],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'ZDT4'){

sub f_ZDT4 {
	
	my $x = shift;
		
	my $n = scalar(@$x);
	
	my $f1 = $x->[0];
	
	my $sum = 0;	
	for my $i(1..$n-1){$sum += ($x->[$i])**2 - 10*cos(4*3.14159265*$x->[$i])} ; # ZTD 4
	
	my $g  = 1 + 10*($n-1) + $sum; # ZDT 4
	my $f2 = $g*(1-sqrt($x->[0]/$g)); # ZDT 1 4
	
	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..10){
	push @$bounds, [-5,5];
}
$bounds->[0] = [0,1];

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT4,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
        #'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1],
		'scaleDistrib' => 0.05,
		'percentMut'   => 5
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0,1],
		'ylim'		=> [0,2],
		'nfun'		=> [0,1],
	}		
);
}
##############################################################################################
if ($case eq 'ZDT6'){

sub f_ZDT6 {
	
	my $x = shift;
		
	my $n = scalar(@$x);
	
	my $f1 = 1 - exp(-4*$x->[0])*(sin(6*3.14159265*$x->[0]))**6;
	
	my $sum = 0;	
	for my $i(1..$n-1){ $sum += ($x->[$i]) } ;

	my $g  = 1 + 9 * ($sum/($n-1))**0.25; 
	my $f2 = $g * ( 1 - ($f1/$g)**2 ); 

	my $out = [$f1,$f2];
	
	return $out;
}

my $bounds = [];
for (1..10){
	push @$bounds, [0,1];
}

f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 250,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_ZDT6,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
        #'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [0.2,1],
		'ylim'		=> [0,1.8],
		'nfun'		=> [0,1],
	}		
);
}

##############################################################################################
if ($case eq 'mono-objective'){

sub f_simple {
	
	my $x = shift;
		
	my $f1 = ($x->[0]-0.5)**2+0.5;
	
	my $out = [$f1];

	return $out;
}

my $bounds = [[-2,2]];


f_Optim_NSGAII(
	{
		'nPop' 			=> 50,
		'nGen'  		=> 50,
		'bounds' 		=> $bounds,
		'function' 		=> \&f_simple,
		'nProc'			=> 1,
        # here a temp work directory has to be provided, to work in ram one can do 'sudo mount -o size=1% -t tmpfs none /mnt/tmpfs'
		'filesDir'		=> $workdir,	
        'verboseFinal'  => 1,	
        'distrib'       => $a_Gaussian_distrib,
        #'distrib'       => [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.1],
		'scaleDistrib' => 0.05,
	},
	{
		'dx'		=> 100,
		'dy'		=> 40,
		'xlabel'	=> 'stiffness [N/mm]',
		'ylabel'	=> 'mass [kg]',
		'xlim'		=> [-2,2],
		'ylim'		=> [0,2],
		'nfun'		=> [0,0],
	}		
);
}
