# This Makefile.PL for Rex was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.012005;
use ExtUtils::MakeMaker 7.1101;

if ( $^O eq 'MSWin32' ) {
  my ( undef, $major, $minor ) = Win32::GetOSVersion();

  if ( $major < 6 ) {
    die 'OS unsupported';
  }
  elsif ( $major == 6 && $minor < 2 ) {
    die 'OS unsupported';
  }
}

use File::ShareDir::Install;
$File::ShareDir::Install::INCLUDE_DOTFILES = 1;
$File::ShareDir::Install::INCLUDE_DOTDIRS = 1;
install_share dist => "share";

my %WriteMakefileArgs = (
  "ABSTRACT" => "the friendly automation framework",
  "AUTHOR" => "Jan Gehring <jfried\@rexify.org>",
  "CONFIGURE_REQUIRES" => {
    "CPAN::Meta::Requirements" => "2.120620",
    "ExtUtils::MakeMaker" => "7.1101",
    "File::ShareDir::Install" => "0.06",
    "Module::Metadata" => 0
  },
  "DISTNAME" => "Rex",
  "EXE_FILES" => [
    "bin/rex",
    "bin/rexify"
  ],
  "LICENSE" => "apache",
  "MIN_PERL_VERSION" => "5.012005",
  "NAME" => "Rex",
  "PREREQ_PM" => {
    "AWS::Signature4" => 0,
    "Carp" => 0,
    "Cwd" => 0,
    "Data::Dumper" => 0,
    "Data::Validate::IP" => 0,
    "Devel::Caller" => 0,
    "Digest::HMAC_SHA1" => 0,
    "Digest::MD5" => 0,
    "English" => 0,
    "Exporter" => 0,
    "Fcntl" => 0,
    "File::Basename" => 0,
    "File::Spec" => 0,
    "File::Spec::Unix" => 0,
    "File::Spec::Win32" => 0,
    "FindBin" => 0,
    "HTTP::Request" => 0,
    "HTTP::Request::Common" => 0,
    "Hash::Merge" => 0,
    "IO::File" => 0,
    "IO::Select" => 0,
    "IO::Socket" => 0,
    "IPC::Open3" => 0,
    "JSON::MaybeXS" => 0,
    "LWP::UserAgent" => 0,
    "List::Util" => "1.45",
    "MIME::Base64" => 0,
    "Module::Load::Conditional" => 0,
    "Net::OpenSSH::ShellQuoter" => 0,
    "POSIX" => 0,
    "Scalar::Util" => 0,
    "Sort::Naturally" => 0,
    "Storable" => 0,
    "Symbol" => 0,
    "Term::ANSIColor" => 0,
    "Term::ReadKey" => 0,
    "Test::Builder::Module" => 0,
    "Text::Glob" => 0,
    "Text::Wrap" => 0,
    "Time::HiRes" => 0,
    "UNIVERSAL" => 0,
    "URI" => 0,
    "URI::QueryParam" => 0,
    "XML::Simple" => 0,
    "YAML" => ">= 0, != 1.25",
    "attributes" => 0,
    "base" => 0,
    "constant" => 0,
    "if" => 0,
    "lib" => 0,
    "overload" => 0,
    "strict" => 0,
    "vars" => 0,
    "version" => 0,
    "warnings" => 0
  },
  "TEST_REQUIRES" => {
    "File::Find" => 0,
    "File::Temp" => 0,
    "String::Escape" => 0,
    "Sub::Override" => 0,
    "Test::Deep" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0,
    "Test::Output" => 0,
    "Test::UseAllModules" => 0,
    "Test::Warnings" => 0,
    "autodie" => 0,
    "utf8" => 0
  },
  "VERSION" => "1.14.3.1",
  "test" => {
    "TESTS" => "t/*.t t/commands/*.t t/issue/*.t t/scm/*.t"
  }
);

my %FallbackPrereqs = (
  "AWS::Signature4" => 0,
  "Carp" => 0,
  "Cwd" => 0,
  "Data::Dumper" => 0,
  "Data::Validate::IP" => 0,
  "Devel::Caller" => 0,
  "Digest::HMAC_SHA1" => 0,
  "Digest::MD5" => 0,
  "English" => 0,
  "Exporter" => 0,
  "Fcntl" => 0,
  "File::Basename" => 0,
  "File::Find" => 0,
  "File::Spec" => 0,
  "File::Spec::Unix" => 0,
  "File::Spec::Win32" => 0,
  "File::Temp" => 0,
  "FindBin" => 0,
  "HTTP::Request" => 0,
  "HTTP::Request::Common" => 0,
  "Hash::Merge" => 0,
  "IO::File" => 0,
  "IO::Select" => 0,
  "IO::Socket" => 0,
  "IPC::Open3" => 0,
  "JSON::MaybeXS" => 0,
  "LWP::UserAgent" => 0,
  "List::Util" => "1.45",
  "MIME::Base64" => 0,
  "Module::Load::Conditional" => 0,
  "Net::OpenSSH::ShellQuoter" => 0,
  "POSIX" => 0,
  "Scalar::Util" => 0,
  "Sort::Naturally" => 0,
  "Storable" => 0,
  "String::Escape" => 0,
  "Sub::Override" => 0,
  "Symbol" => 0,
  "Term::ANSIColor" => 0,
  "Term::ReadKey" => 0,
  "Test::Builder::Module" => 0,
  "Test::Deep" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "Test::Output" => 0,
  "Test::UseAllModules" => 0,
  "Test::Warnings" => 0,
  "Text::Glob" => 0,
  "Text::Wrap" => 0,
  "Time::HiRes" => 0,
  "UNIVERSAL" => 0,
  "URI" => 0,
  "URI::QueryParam" => 0,
  "XML::Simple" => 0,
  "YAML" => ">= 0, != 1.25",
  "attributes" => 0,
  "autodie" => 0,
  "base" => 0,
  "constant" => 0,
  "if" => 0,
  "lib" => 0,
  "overload" => 0,
  "strict" => 0,
  "utf8" => 0,
  "vars" => 0,
  "version" => 0,
  "warnings" => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.040
requires('IPC::Shareable')
  if has_module('IPC::Shareable')
    || prompt('install Support custom output formatters? [y/N]', 'N') =~ /^y/i;
requires('DBI')
  if has_module('DBI')
    || prompt('install Support database tasks and describing host groups in a database? [y/N]', 'N') =~ /^y/i;
requires('XML::LibXML')
  if has_module('XML::LibXML')
    || prompt('install Support describing host groups in XML format? [y/N]', 'N') =~ /^y/i;

requires('Expect')
  if has_module('Expect')
    || prompt('install Support rsync tasks? [y/N]', 'N') =~ /^y/i;

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

if ( $^O !~ /MSWin/i ) {
	$WriteMakefileArgs{PREREQ_PM}{'IO::Pty'} = $FallbackPrereqs{'IO::Pty'} = '0';
	$WriteMakefileArgs{PREREQ_PM}{'Net::OpenSSH'} = $FallbackPrereqs{'Net::OpenSSH'} = '0';
	$WriteMakefileArgs{PREREQ_PM}{'Net::SFTP::Foreign'} = $FallbackPrereqs{'Net::SFTP::Foreign'} = '0';
}

if ( $^O =~ /MSWin/i ) {
	$WriteMakefileArgs{PREREQ_PM}{'Net::SSH2'} = $FallbackPrereqs{'Net::SSH2'} = '0';
	$WriteMakefileArgs{PREREQ_PM}{'Win32::Console::ANSI'} = $FallbackPrereqs{'Win32::Console::ANSI'} = '0';
}

if ( $^O eq 'darwin' ) {
	$WriteMakefileArgs{PREREQ_PM}{'IO::Pty'} = $FallbackPrereqs{'IO::Pty'} = '!= 1.18';
}

WriteMakefile(%WriteMakefileArgs);

{
package
MY;
use File::ShareDir::Install qw(postamble);
}

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.040
sub _add_prereq {
  my ($mm_key, $module, $version_or_range) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
      and $WriteMakefileArgs{$mm_key}{$module} ne '0'
      and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
        and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub has_module {
  my ($module, $version_or_range) = @_;
  require Module::Metadata;
  my $mmd = Module::Metadata->new_from_module($module);
  return undef if not $mmd;
  return $mmd->version($module) if not defined $version_or_range;

  require CPAN::Meta::Requirements;
  my $req = CPAN::Meta::Requirements->new;
  $req->add_string_requirement($module => $version_or_range);
  return 1 if $req->accepts_module($module => $mmd->version($module));
  return 0;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ($module, $version_or_range) = @_;
  _add_prereq(PREREQ_PM => $module, $version_or_range);
}
