
unit class Console::Blackjack::Card;

class Card is export {
  my Array @.faces = [
    [ 'A♠', 'A♥', 'A♣', 'A♦' ],
    [ '2♠', '2♥', '2♣', '2♦' ],
    [ '3♠', '3♥', '3♣', '3♦' ],
    [ '4♠', '4♥', '4♣', '4♦' ],
    [ '5♠', '5♥', '5♣', '5♦' ],
    [ '6♠', '6♥', '6♣', '6♦' ],
    [ '7♠', '7♥', '7♣', '7♦' ],
    [ '8♠', '8♥', '8♣', '8♦' ],
    [ '9♠', '9♥', '9♣', '9♦' ],
    [ 'T♠', 'T♥', 'T♣', 'T♦' ],
    [ 'J♠', 'J♥', 'J♣', 'J♦' ],
    [ 'Q♠', 'Q♥', 'Q♣', 'Q♦' ],
    [ 'K♠', 'K♥', 'K♣', 'K♦' ],
    ['??']
  ];
  my Array @.faces2 = [
    ['🂡', '🂱', '🃁', '🃑'],
    ['🂢', '🂲', '🃂', '🃒'],
    ['🂣', '🂳', '🃃', '🃓'],
    ['🂤', '🂴', '🃄', '🃔'],
    ['🂥', '🂵', '🃅', '🃕'],
    ['🂦', '🂶', '🃆', '🃖'],
    ['🂧', '🂷', '🃇', '🃗'],
    ['🂨', '🂸', '🃈', '🃘'],
    ['🂩', '🂹', '🃉', '🃙'],
    ['🂪', '🂺', '🃊', '🃚'],
    ['🂫', '🂻', '🃋', '🃛'],
    ['🂭', '🂽', '🃍', '🃝'],
    ['🂮', '🂾', '🃎', '🃞'],
    ['🂠', '', '', '']];

  has Int $.value;
  has Int $!suit;
  my $.face-type;

  submethod BUILD(:$!value, :$!suit) {}

  method is-ace(--> Bool) {
    $!value == 0;
  }

  method is-ten(--> Bool) {
    $!value > 8;
  }

  method draw(--> Str) {
    return Card.faces2[$!value][$!suit] if Card.face-type == 2;
    Card.faces[$!value][$!suit];
  }
}
