package App::Manoc::View::TT::Plugin::JSON;
#ABSTRACT: Template::Plugin::JSON - Adds a .json vmethod to TT values.
use strict;
use warnings;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use Template::Plugin;
use base 'Template::Plugin';
use JSON;



sub json {
    my $self = shift;
    my $o    = shift;
    return JSON->new->convert_blessed(1)->encode($o);
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::View::TT::Plugin::JSON - Template::Plugin::JSON - Adds a .json vmethod to TT values.

=head1 VERSION

version 2.99.2

=head1 DESCRIPTION

This plugin provides a C<.json> vmethod to all value types when loaded.

=head1 METHODS

=head2 json

The C<.json> vmethod.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
