package App::Manoc::DB::Result::Mat;
#ABSTRACT: A model object for port-macaddress associations

use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use parent 'App::Manoc::DB::Result';

__PACKAGE__->load_components(
    qw/
        +App::Manoc::DB::Helper::Row::TupleArchive
        /
);

__PACKAGE__->table('mat');

__PACKAGE__->add_columns(
    'macaddr' => {
        data_type   => 'varchar',
        is_nullable => 0,
        size        => 17
    },
    'device_id' => {
        data_type      => 'int',
        is_nullable    => 0,
        is_foreign_key => 1,
    },
    'interface' => {
        data_type   => 'varchar',
        is_nullable => 0,
        size        => 64,
    },
    # firstseen, lastseen, archived added by TupleArchive

    'vlan' => {
        data_type     => 'int',
        default_value => 1,
        is_nullable   => 0,
        size          => 11
    },
);

__PACKAGE__->set_tuple_archive_columns( 'macaddr', 'device_id', 'interface', 'vlan' );

__PACKAGE__->set_primary_key( 'macaddr', 'device_id', 'firstseen', 'vlan' );

__PACKAGE__->belongs_to(
    'device' => 'App::Manoc::DB::Result::Device',
    { 'foreign.id' => 'self.device_id' }
);

__PACKAGE__->resultset_class('App::Manoc::DB::ResultSet::Mat');


sub sqlt_deploy_hook {
    my ( $self, $sqlt_schema ) = @_;

    $sqlt_schema->add_index( name => 'idx_mat_device',  fields => ['device_id'] );
    $sqlt_schema->add_index( name => 'idx_mat_macaddr', fields => ['macaddr'] );

    $sqlt_schema->add_index(
        name   => 'idx_mat_dev_iface',
        fields => [ 'device_id', 'interface' ]
    );

}

1;

__END__

=pod

=head1 NAME

App::Manoc::DB::Result::Mat - A model object for port-macaddress associations

=head1 VERSION

version 2.99.3

=for Pod::Coverage sqlt_deploy_hook

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
