package App::Manoc::Controller::APIv1::WinLogon;
#ABSTRACT: Controller for WinLogon APIs

use Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use namespace::autoclean;

BEGIN { extends 'App::Manoc::ControllerBase::APIv1' }


sub base : Chained('deserialize') PathPart('winlogon') CaptureArgs(0) {
    return;
}


sub winlogon_post : Chained('base') PathPart('') Args(0) POST {
    my ( $self, $c ) = @_;

    $c->stash(
        api_validate => {
            type  => 'hash',
            items => {
                user => {
                    type     => 'scalar',
                    required => 1,
                },
                ipaddr => {
                    type     => 'scalar',
                    required => 1,
                },
            }
        }
    );
    $c->forward('validate') or return;

    my $req_data = $c->stash->{api_request_data};

    my $user   = $req_data->{user};
    my $ipaddr = $req_data->{ipaddr};

    if ( !check_addr($ipaddr) ) {
        $c->stash( api_field_errors => [ { ipaddr => "Not a valid address" } ] );
        return;
    }
    $ipaddr = App::Manoc::IPAddress::IPv4->new($ipaddr);

    my $rs;
    if ( $user =~ /([^\$]+)\$$/ ) {
        $user = $1;
        $rs   = $c->model('ManocDB::WinHostname');
    }
    else {
        $rs = $c->model('ManocDB::WinLogon');
    }

    $rs->register_tuple(
        user   => lc($user),
        ipaddr => $ipaddr,
    );
    my $data = { message => "entry registered", };
    $c->stash( api_response_data => $data );
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Controller::APIv1::WinLogon - Controller for WinLogon APIs

=head1 VERSION

version 2.99.4

=head1 ACTIONS

=head2 base

=head2 winlogon_post

POST api/v1/winlogon

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
