package App::Manoc::DB::ResultSet::WorkstationHW;
#ABSTRACT: ResultSet class for WorkstationHW

use strict;
use warnings;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';

use App::Manoc::DB::Result::HWAsset;


sub unused {
    my ($self) = @_;

    my $used_asset_ids = $self->result_source->schema->resultset('Workstation')->search(
        {
            'subquery.decommissioned'   => 0,
            'subquery.workstationhw_id' => { -is_not => undef }
        },
        {
            alias => 'subquery',
        }
    )->get_column('workstationhw_id');

    my $me     = $self->current_source_alias;
    my $assets = $self->search(
        {
            'hwasset.location' =>
                { '!=' => App::Manoc::DB::Result::HWAsset::LOCATION_DECOMMISSIONED },
            "$me.id" => {
                -not_in => $used_asset_ids->as_query,
            }
        },
        {
            join => 'hwasset',
        }
    );

    return $assets;
}


1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::WorkstationHW - ResultSet class for WorkstationHW

=head1 VERSION

version 2.99.4

=head1 METHODS

=head2 unused

Resultset containing WorkstationHW which are not decommissioned and
are not in use by any Workstation

=head1 SEE ALSO

L<DBIx::Class::ResultSet>

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
