package App::Manoc::Form::Base;

use HTML::FormHandler::Moose;

our $VERSION = '2.99.4'; ##TRIAL VERSION

extends 'HTML::FormHandler';
with
    'App::Manoc::Form::TraitFor::Theme',
    'App::Manoc::Form::TraitFor::CSRF';

# with 'HTML::FormHandlerX::Form::JQueryValidator';

#required for CSRF
has '+ctx'      => ( required => 1, );
has '+is_html5' => ( default  => 1 );

# has_field validation_json => ( type => 'Hidden',  element_attr => { disabled => 'disabled' } );
# sub default_validation_json { shift->as_escaped_json }

sub html_attributes {
    my ( $self, $field, $type, $attr ) = @_;
    if ( $type eq 'label' && $field->{required} ) {
        # highlight required fields
        push @{ $attr->{class} }, 'required-label';
    }
    return $attr;
}

__PACKAGE__->meta->make_immutable;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::Base

=head1 VERSION

version 2.99.4

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
