#!/usr/bin/perl -w

=head1 NAME

Quizzer::FrontEnd::Gtk - gtk FrontEnd

=cut

=head1 DESCRIPTION

This FrontEnd is a user interface based on Gtk. It is styled on the
same lines as the Wizards in Microsoft Windows. (Be afraid..)

=cut

=head1 METHODS

=cut

package Quizzer::FrontEnd::Gtk;
use Quizzer::FrontEnd;
use Gtk;
use Gtk::Atoms;
use vars qw(@ISA);
@ISA=qw(Quizzer::FrontEnd);

my $VERSION='0.01';

use strict;

=head2 new

Creates and returns a new FrontEnd::Gtk object.

=cut

sub new {
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = bless $proto->SUPER::new(@_), $class;

	$self->{interactive}=1;
	$self->{capb} = 'backup';

	# create the window. If display isn't set, this dies with 
	# an untrappable error. So first test that and exit sanely, so
	# it can be caught and fallbacks work.
	Gtk->init_check() || return;
	set_locale Gtk;
	init Gtk;

	my $window = new Gtk::Window('toplevel');
	$window->set_title("Quizzer - Copyright (C) 2002 Stefano Corsi, Mlx S.r.l -
Madeinlinux");
	$window->set_name("main window");
	$window->set_uposition(20,20);
	$window->set_usize(500,250);

	$window->signal_connect("destroy" => \&Gtk::main_quit);
	$window->signal_connect("delete_event" => \&Gtk::false);

	realize $window;

	# divide into three vertical sections: main, vert bar, buttons
	my $vbox = new Gtk::VBox(0,0);
	$window->add($vbox);
	$vbox->show();

	# first section is two horizontal sections: a piccie, and questions
	my $hbox = new Gtk::HBox(0,0);
	$vbox->pack_start($hbox, 1, 1, 5);
	$hbox->show;

	# the piccie has an aligned frame around it
	my $align = new Gtk::Alignment(0.5,0,0,0);
	$hbox->pack_start($align,0,0,5);
	$align->show();

	my $frame = new Gtk::Frame;
	$frame->set_shadow_type("in");

	$align->add($frame);
	$frame->show;

	# process the xpm that's in the DATA section at the end of this file.
	my @mlxlogo_xpm=();
	my $pos=tell DATA;
	<DATA>;
	<DATA>;
	while (<DATA>) {
		chomp;
		s/^\"//;
		s/"};$//;
		s/",$//;
		push @mlxlogo_xpm, $_;
	}
	seek DATA, 0, $pos;
	my ($mlxlogo, $mlxlogo_mask) = 
		Gtk::Gdk::Pixmap->create_from_xpm_d(
			$window->window,
			Gtk::Widget->get_default_style->bg('normal'),
			@mlxlogo_xpm
		);

	my $pixmap = new Gtk::Pixmap($mlxlogo, $mlxlogo_mask);
	$frame->add($pixmap);
	show $pixmap;

	# the question frame is next
	my $questionframe = new Gtk::Frame;
	$questionframe->set_shadow_type("none");
	$hbox->pack_start($questionframe, 1, 1, 5);
	$questionframe->show();

	# okay, now we're onto the horizontal separator
	my $buttsep = new Gtk::HSeparator();
	$vbox->pack_start($buttsep, 0, 1, 0);
	$buttsep->show();

	# then the buttons at the bottom
	my $buttbox = new Gtk::HBox(0,1);
	$vbox->pack_start($buttbox, 0, 0, 5);
	$buttbox->show();

	my @butts = (new Gtk::Button("Cancel"),
	             new Gtk::Button("Next"),
	             new Gtk::Button("Back"));
	($buttbox->pack_end($_,0,0,5), $_->show) foreach (@butts);
	$butts[0]->signal_connect("clicked", sub { $self->Cancel; });
	$butts[1]->signal_connect("clicked", sub { $self->Next; });
	$butts[2]->signal_connect("clicked", sub { $self->Back; });

	$self->{window} = $window;
	$self->{questionframe} = $questionframe;
	$self->{result} = "uninitialized";

	return $self;
}

=head2 newques

=cut

sub newques {
	my $self = shift;
	my $newtitle = shift; # string
	my $newchild = shift; # Gtk widget

	$self->{window}->show unless $self->{window_showing};
	$self->{window_showing}=1;

	$self->{questionframe}->remove($self->{child})
		if (defined $self->{child});

	$self->{questionframe}->add($newchild);
	$newchild->show();
	$self->{child} = $newchild;

	$self->{questionframe}->realize;

	$self->{window}->set_title("Quizzer - Copyright (C) 2002 Stefano Corsi, Mlx S.r.l -
Madeinlinux -- $newtitle");

	Gtk->gc;
	Gtk->main;

	return $self->{result};
}

=head2 maketext

=cut

sub maketext {
	my $self = shift;
	my $output = shift;

	my $text = new Gtk::Text(undef,undef);
	$text->insert(undef,undef,undef, "$output");
	$text->set_word_wrap(1);

	my $vscroller = new Gtk::VScrollbar($text->vadj);

	my $hbox = new Gtk::HBox(0,0);
	$hbox->pack_start($text, 1,1,0);
	$hbox->pack_start($vscroller, 0,1,0);
	$text->show();
	$vscroller->show();

	return $hbox;
}

sub Cancel {
	my $self = shift;
	Gtk->main_quit;
	exit 1;
}

sub Back {
	my $self = shift;
	$self->{result} = "backup";
	$self->backup(1);
	Gtk->main_quit;
}

sub Next {
	my $self = shift;
	$self->{result} = "";
	Gtk->main_quit;
}

=head1 AUTHOR

Anthony Towns <aj@azure.humbug.org.au>

=cut

1

__DATA__
/* XPM */
static char * mlxlogo_xpm[] = {
"200 200 69 1",
" 	c None",
".	c #FFFFFF",
"+	c #AFC7D5",
"@	c #6090AD",
"#	c #9FBBCD",
"$	c #5084A5",
"%	c #004D7C",
"&	c #CFDDE6",
"*	c #105884",
"=	c #EFF3F6",
"-	c #20638C",
";	c #DFE8EE",
">	c #709BB5",
",	c #1E628C",
"'	c #598DAB",
")	c #80AABF",
"!	c #145B86",
"~	c #457FA0",
"{	c #9EBFCF",
"]	c #286A91",
"^	c #6D9BB5",
"/	c #7FA5BD",
"(	c #0A5481",
"_	c #3B789B",
":	c #8AB1C5",
"<	c #BFD2DE",
"[	c #4F86A6",
"}	c #94B8CA",
"|	c #8FB0C5",
"1	c #77A3BA",
"2	c #306E94",
"3	c #6394B0",
"4	c #40799C",
"5	c #317196",
"6	c #B6CFDB",
"7	c #BCD3DE",
"8	c #CFDFE7",
"9	c #A4C3D2",
"0	c #C2D7E1",
"a	c #DBE7ED",
"b	c #EDF3F6",
"c	c #AAC7D5",
"d	c #E1EBF0",
"e	c #F3F7F9",
"f	c #D5E3EA",
"g	c #B0CBD8",
"h	c #C8DBE4",
"i	c #E7EFF3",
"j	c #F9FBFC",
"k	c #9FBCCE",
"l	c #BFD3DE",
"m	c #407A9D",
"n	c #DFE9EF",
"o	c #9BBBCC",
"p	c #306E95",
"q	c #80A6BE",
"r	c #AFC7D6",
"s	c #5085A5",
"t	c #CFDEE6",
"u	c #8FB1C6",
"v	c #EFF4F7",
"w	c #7BA4BC",
"x	c #C7D9E3",
"y	c #BFD4DF",
"z	c #3A769A",
"A	c #6F9CB6",
"B	c #A1BFCF",
"C	c #C9DAE3",
"D	c #EFF4F6",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"..........................................................................=<#/>44-%%%%%%%%%%%%%44$/|<;..................................................................................................",
".....................................................................;#>4*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4@|<.............................................................................................",
".................................................................&|$*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4/<.........................................................................................",
"..............................................................+@-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$#;.....................................................................................",
"...........................................................#$%%%%%%%%%%%%%%%%%%,]][[[[[[[[[[[[5]]%%%%%%%%%%%%%%%%%%2|;..................................................................................",
"........................................................&@*%%%%%%%%%%%%%!][31}{{{{{{{{{{{{{{{{{{{{{1^[5,%%%%%%%%%%%%%%$#................................................................................",
".....................................................=#-%%%%%%%%%%%%][^}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{1[5(%%%%%%%%%%%*>;.............................................................................",
"...................................................;>*%%%%%%%%%%!~^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)[,%%%%%%%%%%%$<...........................................................................",
".................................................;@%%%%%%%%%%,'){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}35%%%%%%%%%%4<.........................................................................",
"...............................................;@%%%%%%%%%!~){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}',%%%%%%%%%4<.......................................................................",
".............................................=>%%%%%%%%%]^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)_(%%%%%%%%4&.....................................................................",
"............................................/*%%%%%%%(_:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}[!%%%%%%%%@=...................................................................",
"..........................................<-%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3!%%%%%%%*|..................................................................",
"........................................=@%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3!%%%%%%%2&................................................................",
".......................................+*%%%%%%%_}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%%%/...............................................................",
".....................................=$%%%%%%%]:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}~%%%%%%%2&.............................................................",
"....................................&-%%%%%%!^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:]%%%%%%*|............................................................",
"...................................|%%%%%%%~}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%%$=..........................................................",
".................................=$%%%%%%!1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%%2&.........................................................",
"................................&2%%%%%%~}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%*+........................................................",
"...............................&*%%%%%(^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{),%%%%%%|.......................................................",
"..............................#%%%%%%,:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}_%%%%%%@......................................................",
".............................#%%%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%%%$=....................................................",
"............................@%%%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)(%%%%%2=...................................................",
"...........................@%%%%%(^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:,%%%%%2=..................................................",
"..........................@%%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{},%%%%%2=.................................................",
".........................@%%%%%,){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}_%%%%%2=................................................",
"........................@%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{678888888876{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%2=...............................................",
".......................#%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{90ab..............ba0c{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%$...............................................",
"......................#%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{90d......................efg{{{{{{{{{{{{{{{{{{{{{{_%%%%%@..............................................",
".....................&%%%%%!}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6a............................eh9{{{{{{{{{{{{{{{{{{{{_%%%%%/.............................................",
"....................;*%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0b.........if8766666h8db...........ac{{{{{{{{{{{{{{{{{{},%%%%%#............................................",
"...................=2%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0e.......ef6{{{{{{{{{{{{{{{68b.........ac{{{{{{{{{{{{{{{{{},%%%%*&...........................................",
"...................@%%%%%^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6e......jag{{{{{{{{{{{{{{{{{{{{{90i........ac{{{{{{{{{{{{{{{{:(%%%%-=..........................................",
"..................|%%%%%'{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{ci......e09{{{{{{{{{{{{{{{{{{{{{{{{{{c8e.......89{{{{{{{{{{{{{{{)(%%%%$..........................................",
".................&%%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{hj.....e0{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0e......e7{{{{{{{{{{{{{{{3%%%%%|.........................................",
"................=2%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9i.....e0{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6i......d9{{{{{{{{{{{{{{~%%%%%&........................................",
"................>%%%%(:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6j.....89{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0e.....j7{{{{{{{{{{{{{{,%%%%2=.......................................",
"...............<%%%%%^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0.....bg{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{hj.....d9{{{{{{{{{{{{:(%%%%>.......................................",
"..............=-%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{f.....8{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9a.....eg{{{{{{{{{{{{^%%%%%<......................................",
"..............>%%%%!}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{a....j6{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6e.....0{{{{{{{{{{{{5%%%%-......................................",
".............<%%%%%1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{a....bc{{{{{{{{{{{{{{{{{{{{{{{{)^[[]]]]_[[1:{{{{{{{{{{{{{{9f.....a{{{{{{{{{{{}(%%%%/.....................................",
".............2%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{a....b9{{{{{{{{{{{{{{{{{{{{{}35(%%%%%%%%%%%%%%][1{{{{{{{{{{{{6j....b9{{{{{{{{{{^%%%%*;....................................",
"............#%%%%(}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{8....b9{{{{{{{{{{{{{{{{{{{{35%%%%%%%%%%%%%%%%%%%%%(_^{{{{{{{{{{9i....eg{{{{{{{{{{5%%%%$....................................",
"...........=*%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0....b9{{{{{{{{{{{{{{{{{{:~(%%%%%%%%%%%%%%%%%%%%%%%%%%(~:{{{{{{{{{8....j6{{{{{{{{{:(%%%%<...................................",
".........../%%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{g....b9{{{{{{{{{{{{{{{{{:_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%51{{{{{{{{6j....0{{{{{{{{{[%%%%4...................................",
"..........=*%%%%){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9e...b9{{{{{{{{{{{{{{{{:_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{cb....0{{{{{{{{}!%%%%#..................................",
"..........@%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{d...jg{{{{{{{{{{{{{{{}[%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{9i....8{{{{{{{{3%%%%-..................................",
".........;%%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{h....7{{{{{{{{{{{{{{{1!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%]:{{{{{{a....a{{{{{{{{,%%%%#.................................",
".........>%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{gj...8{{{{{{{{{{{{{{}~%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%[}{{{{{8....a{{{{{{{1%%%%-.................................",
"........=*%%%(}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{i...b{{{{{{{{{{{{{{),%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!1{{{{{0....a{{{{{{{]%%%%#................................",
"......../%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{h...jc{{{{{{{{{{{{{^(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5}{{{{0....a{{{{{{1%%%%4................................",
"........*%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{cj...h{{{{{{{{{{{{{3%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(1{{{{0....h{{{{{{!%%%%<...............................",
".......#%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{d...i{{{{{{{{{{{{{~%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~{{{{0....0{{{{{3%%%%@...............................",
".......4%%%%){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6....g{{{{{{{{{{{{_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,:{{{0....0{{{{{(%%%%=..............................",
"......;%%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{e...8{{{{{{{{{{{{~%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(^{{{0....6{{{{[%%%%|..............................",
"......>%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{h...e9{{{{{{{{{{{3%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~{{{0...jg{{{:%%%%-..............................",
"......-%%%({{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9j...0{{{{{{{{{{{^%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%5}{{0...j9{{{5%%%%&.............................",
".....+%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{f...i{{{{{{{{{{{)(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,){{a...b9{{^%%%%>.............................",
".....@%%%%){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{c....6{{{{{{{{{{},%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(){{a...a{{{(%%%-.............................",
".....*%%%!{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{d...a{{{{{{{{{{{_%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(3{9b...8{{_%%%%&............................",
"....<%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6...jc{{{{{{{{{{^%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%3{9e...0{^%%%%>............................",
"....>%%%%){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{b...8{{{{{{{{{{:(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'{gj..jg{(%%%-............................",
"....-%%%!{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0...j9{{{{{{{{{{]%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_{0...b9_%%%%;...........................",
"...;%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9j...0{{{{{{{{{{^%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_{f...d3%%%%#...........................",
"...#%%%%^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{f...b{{{{{{{{{{}(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_{i...y%%%%$...........................",
"...@%%%%}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{g....6{{{{{{{{{{~%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_9j...z%%%*...........................",
"...-%%%,{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{b...a{{{{{{{{{{)%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_6...t%%%%;..........................",
"..=%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{8...j9{{{{{{{{{{]%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%~8...%%%%#..........................",
"..+%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6....7{{{{{{{{{{^%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%3b..p%%%>..........................",
"../%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{cj...d{{{{{{{{{{{!%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pm>qqqlllrqqqsm%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%Aj.@%%%4..........................",
"..4%%%({{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9b...e9{{{{{{{{{{[%%%%%%%%%%%%%%%%%%%%%%%%%*sqln.................nrqm%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%B.q%%%%..........................",
"..-%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9b....g{{{{{{{{{{}(%%%%%%%%%%%%%%%%%%%%%*skn...........................r@*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(Cl%%%%&.........................",
"..%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9b....0{{{{{{{{{{{~%%%%%%%%%%%%%%%%%%%->l..................................r@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-n%%%%+.........................",
".<%%%%'{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9b....f{{{{{{{{{{{:%%%%%%%%%%%%%%%%%->t.......................................nq*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%>*%%%/.........................",
".+%%%%1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6j....a{{{{{{{{{{{{]%%%%%%%%%%%%%%*@l...............trq>mm-%%%%%-mmqulv..........vk-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%@.........................",
"./%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{ca.....a{{{{{{{{{{{{1%%%%%%%%%%%%%pkv............nk>m%%%%%%%%%%%%%%%%%%%%p>r.........vq*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4.........................",
"./%%%%{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{ca......0{{{{{{{{{{{{{!%%%%%%%%%%%@t...........vr@-%%%%%%%%%%%%%%%%%%%%%%%%%%%%sr........v>%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-.........................",
".4%%%!{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6d......eg{{{{{{{{{{{{{[%%%%%%%%%*qv..........vks%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*>n.......tp%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.........................",
".4%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0e.......f9{{{{{{{{{{{{{:%%%%%%%%-k..........vks%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%@n.......q%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.........................",
".2%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{0e.......ac{{{{{{{{{{{{{{{]%%%%%%mr..........r@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%@n......tp%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&........................",
".%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6b......jfc{{{{{{{{{{{{{{{{[%%%%%ml.........nq-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%qv.....v>%%%%%%%%%%%%%%%%%%%%%%%%%%%%#........................",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9d......e09{{{{{{{{{{{{{{{{{)%%%%ml.........rs%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-r......k*%%%%%%%%%%%%%%%%%%%%%%%%%%*;.......................",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{hj.....e0{{{{{{{{{{{{{{{{{{{}!%%ml........vu-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sv.....tp%%%%%%%%%%%%%%%%%%%%%%%%%%4.......................",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{9d.....j8{{{{{{{{{{{{{{{{{{{{{,%ml........n>*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*l.....vm%%%%%%%%%%%%%%%%%%%%%%%%%%|......................",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{6j.....dc{{{{{{{{{{{{{{{{{{{{{_ml........l@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!]['11{{{{{{{{}1^[5!%%%%%%%%%%%%>......u*%%%%%%%%%%%%%%%%%%%%%%%%%#..............</$44..",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{{h.....j7{{{{{{{{{{{{{{{{{{{{{{wl........lm%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%][1}{{{{{{{{{{{{{{{{{{{{:35%%%%%%%%%%pv.....tp%%%%%%%%%%%%%%%%%%%%%%%%%$;.........+@*%%%%-..",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{{{a.....i9{{{{{{{{{{{{{{{{{{{{{cx........kp%%%%%%%%%%%%%%%%%%%%%%%%%%%%%,[1{{{{{{{{{{{{{{{{{{{{{{{{{{{{}3,%%%%%%%%*t......q*%%%%%%%%%%%%%%%%%%%%%%%%%4/<<<</$*%%%%%%%$..",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{{9a.....8{{{{{{{{{{{{{{{{{{{{{ca........k-%%%%%%%%%%%%%%%%%%%%%%%%%%%%53}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)_%%%%%%%%k......nm%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%|..",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{9b....j0{{{{{{{{{{{{{{{{{{{{9f........k-%%%%%%%%%%%%%%%%%%%%%%%%%%%53}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:_%%%%%%%@v......r-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%&..",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{{b....jg{{{{{{{{{{{{{{{{{{{98j.......k-%%%%%%%%%%%%%%%%%%%%%%%%%%,3}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{1]%%%%%%pt......vq%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%...",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{{a....jg{{{{{{{{{{{{{{{{{{{hj.......k-%%%%%%%%%%%%%%%%%%%%%%%%%(~:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3(%%%%%*u.......n@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4...",
".%%%%[{{{{{{{{{{{{{{{{{{{{{{{f....jg{{{{{{{{{{{{{{{{{{0e.......k-%%%%%%%%%%%%%%%%%%%%%%%%%]3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%%sv.......n@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%/...",
".%%%%~{{{{{{{{{{{{{{{{{{{{{{0....jg{{{{{{{{{{{{{{{{{6e.......k-%%%%%%%%%%%%%%%%%%%%%%%%%_){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^(%%%%%*u........n@%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%+...",
".2%%%]{{{{{{{{{{{{{{{{{{{{{gj...jg{{{{{{{{{{{{{{{{6i.......k-%%%%%%%%%%%%%%%%%%%%%%%%![}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%%mn........nq*%%%%%%%%%%%%%%%%%%%%%%%%%%%=...",
".4%%%]{{{{{{{{{{{{{{{{{{{{9b....0{{{{{{{{{{{{{{{gi.......k-%%%%%%%%%%%%%%%%%%%%%%%%!3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%%>v.........rs%%%%%%%%%%%%%%%%%%%%%%%%2....",
".4%%%!{{{{{{{{{{{{{{{{{{{{f....f{{{{{{{{{{{{{{ca.......k-%%%%%%%%%%%%%%%%%%%%%%%%]^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{),%%%%%%*qv.........vk@*%%%%%%%%%%%%%%%%%%%%@....",
"./%%%%{{{{{{{{{{{{{{{{{{{g....i{{{{{{{{{{{{{ca.......k-%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}_%%%%%%%*qv...........tu@p%%%%%%%%%%%%%%%%#....",
"./%%%%:{{{{{{{{{{{{{{{{{{i...jc{{{{{{{{{{{98.......k-%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^(%%%%%%%*@n..............lrq>mm-%%%%%%%%;....",
".+%%%%1{{{{{{{{{{{{{{{{{0....7{{{{{{{{{{98j......lm%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:,%%%%%%%%%pun.....................llluq.....",
".<%%%%'{{{{{{{{{{{{{{{{{e...i{{{{{{{{{98j......lm%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{~%%%%%%%%%%%put............................",
"..%%%%~{{{{{{{{{{{{{{{{0....c{{{{{{{98j......lm%%%%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{1(%%%%%%%%%%%%*mqrt.......................",
"..-%%%]{{{{{{{{{{{{{{{{b...8{{{{{{98j......lm%%%%%%%%%%%%%%%%%%%%%%%%!^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%%%%%%%%%%%%%-m@qqkllln......D.....",
"..4%%%({{{{{{{{{{{{{{{g...j9{{{{98j......lm%%%%%%%%%%%%%%%%%%%%%%%%!3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^(%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%......",
"../%%%%:{{{{{{{{{{{{{{a...8{{{98j......nm%%%%%%%%%%%%%%%%%%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4......",
"..+%%%%3{{{{{{{{{{{{{{j..j9{98j......n@%%%%%%%%%%%%%%%%%%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^!%%%%%%%%%%%%%%%%%%%%%%%%%%%/......",
"..=%%%%~{{{{{{{{{{{{{6...acaj......eo%%%%%%%%%%%%%%%%%%%%%%%%%_:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}[%%%%%%%%%%%%%%%%%%%%%%%%%%<......",
"...-%%%,{{{{{{{{{{{{{f...b.......e0:(%%%%%%%%%%%%%%%%%%%%%%%_:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:,%%%%%%%%%%%%%%%%%%%%%%%%=......",
"...@%%%%}{{{{{{{{{{{{i.........e0{{]%%%%%%%%%%%%%%%%%%%%%%]){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{,%%%%%%%%%%%%%%%%%%%%%%%2.......",
"...#%%%%3{{{{{{{{{{{{........e0{{{'%%%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}%%%%-%%%%%%%%%%%%%%%%%%%>.......",
"...;%%%%_{{{{{{{{{{{c......e0{{{{:(%%%%%%%%%%%%%%%%%%%]1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%#;@%%%%%%%%%%%%%%%%%+.......",
"....-%%%({{{{{{{{{{{0....e0{{{{{{_%%%%%%%%%%%%%%%%%%!3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%;..=|2%%%%%%%%%%%%%%=.......",
"....>%%%%){{{{{{{{{{f..e0{{{{{{{1%%%%%%%%%%%%%%%%%!3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{(%%%2......;|4%%%%%%%%%%2........",
"....<%%%%~{{{{{{{{{{ib0{{{{{{{{{]%%%%%%%%%%%%%%%!3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^%%%%>..........</@44%%%%>........",
".....*%%%!{{{{{{{{{{9{{{{{{{{{{)%%%%%%%%%%%%%%([{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%&.................;<;........",
".....@%%%%){{{{{{{{{{{{{{{{{{{{_%%%%%%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{(%%%-.............................",
".....+%%%%_{{{{{{{{{{{{{{{{{{{}%%%%%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^%%%%>.............................",
"......-%%%({{{{{{{{{{{{{{{{{{{'%%%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{5%%%%&.............................",
"......>%%%%3{{{{{{{{{{{{{{{{{{]%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:%%%%2..............................",
"......;%%%%,{{{{{{{{{{{{{{{{{}%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{[%%%%|..............................",
".......4%%%%){{{{{{{{{{{{{{{{^%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{(%%%%=..............................",
".......#%%%%_{{{{{{{{{{{{{{{{[%%![}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%@...............................",
"........-%%%%:{{{{{{{{{{{{{{{],3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{!%%%%&...............................",
"......../%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^%%%%4................................",
"........=*%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{]%%%%+................................",
".........>%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{1%%%%-.................................",
".........;%%%%%:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{,%%%%#.................................",
"..........@%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%-..................................",
"..........=*%%%%){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}!%%%%#..................................",
".........../%%%%]{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{[%%%%4...................................",
"...........=*%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:(%%%%<...................................",
"............#%%%%(}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{]%%%%$....................................",
".............2%%%%~{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{^%%%%*;....................................",
".............<%%%%%1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}(%%%%/.....................................",
"..............>%%%%!}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{5%%%%2......................................",
"..............=-%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%%<......................................",
"...............<%%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:(%%%%>.......................................",
"................>%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{,%%%%2=.......................................",
"................=2%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%&........................................",
".................&%%%%%_{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%%|.........................................",
"..................|%%%%%'{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)%%%%%$..........................................",
"...................@%%%%%3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:(%%%%-=..........................................",
"...................=2%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{},%%%%*&...........................................",
"....................;*%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{},%%%%%#............................................",
".....................&%%%%%!}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%/.............................................",
"......................#%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%@..............................................",
".......................#%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%$...............................................",
"........................@%%%%%,}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{_%%%%%2=...............................................",
".........................@%%%%%!){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}5%%%%%2=................................................",
"..........................@%%%%%(){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{},%%%%%2=.................................................",
"...........................@%%%%%(^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:,%%%%%2=..................................................",
"............................@%%%%%%'{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)(%%%%%2=...................................................",
".............................#%%%%%%_}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3%%%%%%$=....................................................",
"..............................#%%%%%%,:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}_%%%%%%@......................................................",
"...............................&*%%%%%(^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{),%%%%%%|.......................................................",
"................................&2%%%%%%~}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%*+........................................................",
".................................=$%%%%%%!1{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:]%%%%%%2&.........................................................",
"...................................|%%%%%%%~}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%%$=..........................................................",
"....................................&-%%%%%%!^{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)]%%%%%%*|............................................................",
".....................................=@%%%%%%%]:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}~%%%%%%%2&.............................................................",
".......................................+*%%%%%%%_}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{'(%%%%%%%/...............................................................",
"........................................=@%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3!%%%%%%%2&................................................................",
"..........................................<-%%%%%%%([}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{3!%%%%%%%*|..................................................................",
"............................................/*%%%%%%%%_:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}[!%%%%%%%%@=...................................................................",
".............................................=>%%%%%%%%%]3{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{)_%%%%%%%%%4&.....................................................................",
"...............................................;@%%%%%%%%%(~){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:',%%%%%%%%%4<.......................................................................",
".................................................;@%%%%%%%%%%!~){{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{:35%%%%%%%%%%4<.........................................................................",
"...................................................;>*%%%%%%%%%%!~^}{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{1[,%%%%%%%%%%%@<...........................................................................",
".....................................................=#-%%%%%%%%%%%%,~^:{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{{}1[5(%%%%%%%%%%%*>;.............................................................................",
"........................................................&@*%%%%%%%%%%%%%(][31}{{{{{{{{{{{{{{{{{{{{{1^[5!%%%%%%%%%%%%%%$#................................................................................",
"...........................................................+$%%%%%%%%%%%%%%%%%%!]]~[[[[[[[[[[[]]]%%%%%%%%%%%%%%%%%%2|=..................................................................................",
"..............................................................+@-%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%$#;.....................................................................................",
".................................................................&|$*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4/<.........................................................................................",
".....................................................................;#>4*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%4@|<.............................................................................................",
"..........................................................................=<#/>44-%%%%%%%%%%%%%44$/|<;..................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................",
"........................................................................................................................................................................................................"};

