#############################################################
# This file was automatically generated on 2022-05-11.      #
#                                                           #
# Perl Bindings Version 2.1.31                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletPTC - Reads temperatures from Pt100 und Pt1000 sensors

=cut

package Tinkerforge::BrickletPTC;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a PTC Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 226;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a PTC Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'PTC Bricklet';

=item CALLBACK_TEMPERATURE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE callback.

=cut

use constant CALLBACK_TEMPERATURE => 13;

=item CALLBACK_TEMPERATURE_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_TEMPERATURE_REACHED callback.

=cut

use constant CALLBACK_TEMPERATURE_REACHED => 14;

=item CALLBACK_RESISTANCE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_RESISTANCE callback.

=cut

use constant CALLBACK_RESISTANCE => 15;

=item CALLBACK_RESISTANCE_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_RESISTANCE_REACHED callback.

=cut

use constant CALLBACK_RESISTANCE_REACHED => 16;

=item CALLBACK_SENSOR_CONNECTED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_SENSOR_CONNECTED callback.

=cut

use constant CALLBACK_SENSOR_CONNECTED => 24;

=item FUNCTION_GET_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE => 1;

=item FUNCTION_GET_RESISTANCE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RESISTANCE => 2;

=item FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD => 3;

=item FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD => 4;

=item FUNCTION_SET_RESISTANCE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_RESISTANCE_CALLBACK_PERIOD => 5;

=item FUNCTION_GET_RESISTANCE_CALLBACK_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RESISTANCE_CALLBACK_PERIOD => 6;

=item FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD => 7;

=item FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD => 8;

=item FUNCTION_SET_RESISTANCE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_RESISTANCE_CALLBACK_THRESHOLD => 9;

=item FUNCTION_GET_RESISTANCE_CALLBACK_THRESHOLD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_RESISTANCE_CALLBACK_THRESHOLD => 10;

=item FUNCTION_SET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DEBOUNCE_PERIOD => 11;

=item FUNCTION_GET_DEBOUNCE_PERIOD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DEBOUNCE_PERIOD => 12;

=item FUNCTION_SET_NOISE_REJECTION_FILTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_NOISE_REJECTION_FILTER => 17;

=item FUNCTION_GET_NOISE_REJECTION_FILTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_NOISE_REJECTION_FILTER => 18;

=item FUNCTION_IS_SENSOR_CONNECTED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_IS_SENSOR_CONNECTED => 19;

=item FUNCTION_SET_WIRE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WIRE_MODE => 20;

=item FUNCTION_GET_WIRE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_WIRE_MODE => 21;

=item FUNCTION_SET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION => 22;

=item FUNCTION_GET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION => 23;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant THRESHOLD_OPTION_OFF => 'x';
use constant THRESHOLD_OPTION_OUTSIDE => 'o';
use constant THRESHOLD_OPTION_INSIDE => 'i';
use constant THRESHOLD_OPTION_SMALLER => '<';
use constant THRESHOLD_OPTION_GREATER => '>';
use constant FILTER_OPTION_50HZ => 0;
use constant FILTER_OPTION_60HZ => 1;
use constant WIRE_MODE_2 => 2;
use constant WIRE_MODE_3 => 3;
use constant WIRE_MODE_4 => 4;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 1], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_RESISTANCE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_RESISTANCE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_RESISTANCE_CALLBACK_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_RESISTANCE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_RESISTANCE_CALLBACK_THRESHOLD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_DEBOUNCE_PERIOD} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_NOISE_REJECTION_FILTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_NOISE_REJECTION_FILTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_IS_SENSOR_CONNECTED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WIRE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_WIRE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_TEMPERATURE} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_TEMPERATURE_REACHED} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_RESISTANCE} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_RESISTANCE_REACHED} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_SENSOR_CONNECTED} = shared_clone([9, '?']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item get_temperature()

Returns the temperature of connected sensor.

If you want to get the temperature periodically, it is recommended
to use the :cb:`Temperature` callback and set the period with
:func:`Set Temperature Callback Period`.

=cut

sub get_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE, [], '', 12, 'l');
}

=item get_resistance()

Returns the value as measured by the MAX31865 precision delta-sigma ADC.

The value can be converted with the following formulas:

* Pt100:  resistance = (value * 390) / 32768
* Pt1000: resistance = (value * 3900) / 32768

If you want to get the resistance periodically, it is recommended
to use the :cb:`Resistance` callback and set the period with
:func:`Set Resistance Callback Period`.

=cut

sub get_resistance
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_RESISTANCE, [], '', 12, 'l');
}

=item set_temperature_callback_period()

Sets the period with which the :cb:`Temperature` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Temperature` callback is only triggered if the temperature has
changed since the last triggering.

=cut

sub set_temperature_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_temperature_callback_period()

Returns the period as set by :func:`Set Temperature Callback Period`.

=cut

sub get_temperature_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_resistance_callback_period()

Sets the period with which the :cb:`Resistance` callback is triggered
periodically. A value of 0 turns the callback off.

The :cb:`Resistance` callback is only triggered if the resistance has changed
since the last triggering.

=cut

sub set_resistance_callback_period
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_RESISTANCE_CALLBACK_PERIOD, [$period], 'L', 0, '');
}

=item get_resistance_callback_period()

Returns the period as set by :func:`Set Resistance Callback Period`.

=cut

sub get_resistance_callback_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_RESISTANCE_CALLBACK_PERIOD, [], '', 12, 'L');
}

=item set_temperature_callback_threshold()

Sets the thresholds for the :cb:`Temperature Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the temperature is *outside* the min and max values"
 "'i'",    "Callback is triggered when the temperature is *inside* the min and max values"
 "'<'",    "Callback is triggered when the temperature is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the temperature is greater than the min value (max is ignored)"

=cut

sub set_temperature_callback_threshold
{
	my ($self, $option, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TEMPERATURE_CALLBACK_THRESHOLD, [$option, $min, $max], 'a l l', 0, '');
}

=item get_temperature_callback_threshold()

Returns the threshold as set by :func:`Set Temperature Callback Threshold`.

=cut

sub get_temperature_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TEMPERATURE_CALLBACK_THRESHOLD, [], '', 17, 'a l l');
}

=item set_resistance_callback_threshold()

Sets the thresholds for the :cb:`Resistance Reached` callback.

The following options are possible:

.. csv-table::
 :header: "Option", "Description"
 :widths: 10, 100

 "'x'",    "Callback is turned off"
 "'o'",    "Callback is triggered when the temperature is *outside* the min and max values"
 "'i'",    "Callback is triggered when the temperature is *inside* the min and max values"
 "'<'",    "Callback is triggered when the temperature is smaller than the min value (max is ignored)"
 "'>'",    "Callback is triggered when the temperature is greater than the min value (max is ignored)"

=cut

sub set_resistance_callback_threshold
{
	my ($self, $option, $min, $max) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_RESISTANCE_CALLBACK_THRESHOLD, [$option, $min, $max], 'a l l', 0, '');
}

=item get_resistance_callback_threshold()

Returns the threshold as set by :func:`Set Resistance Callback Threshold`.

=cut

sub get_resistance_callback_threshold
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_RESISTANCE_CALLBACK_THRESHOLD, [], '', 17, 'a l l');
}

=item set_debounce_period()

Sets the period with which the threshold callback

* :cb:`Temperature Reached`,
* :cb:`Resistance Reached`

is triggered, if the threshold

* :func:`Set Temperature Callback Threshold`,
* :func:`Set Resistance Callback Threshold`

keeps being reached.

=cut

sub set_debounce_period
{
	my ($self, $debounce) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DEBOUNCE_PERIOD, [$debounce], 'L', 0, '');
}

=item get_debounce_period()

Returns the debounce period as set by :func:`Set Debounce Period`.

=cut

sub get_debounce_period
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DEBOUNCE_PERIOD, [], '', 12, 'L');
}

=item set_noise_rejection_filter()

Sets the noise rejection filter to either 50Hz (0) or 60Hz (1).
Noise from 50Hz or 60Hz power sources (including
harmonics of the AC power's fundamental frequency) is
attenuated by 82dB.

=cut

sub set_noise_rejection_filter
{
	my ($self, $filter) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_NOISE_REJECTION_FILTER, [$filter], 'C', 0, '');
}

=item get_noise_rejection_filter()

Returns the noise rejection filter option as set by
:func:`Set Noise Rejection Filter`

=cut

sub get_noise_rejection_filter
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_NOISE_REJECTION_FILTER, [], '', 9, 'C');
}

=item is_sensor_connected()

Returns *true* if the sensor is connected correctly.

If this function
returns *false*, there is either no Pt100 or Pt1000 sensor connected,
the sensor is connected incorrectly or the sensor itself is faulty.

=cut

sub is_sensor_connected
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_IS_SENSOR_CONNECTED, [], '', 9, '?');
}

=item set_wire_mode()

Sets the wire mode of the sensor. Possible values are 2, 3 and 4 which
correspond to 2-, 3- and 4-wire sensors. The value has to match the jumper
configuration on the Bricklet.

=cut

sub set_wire_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WIRE_MODE, [$mode], 'C', 0, '');
}

=item get_wire_mode()

Returns the wire mode as set by :func:`Set Wire Mode`

=cut

sub get_wire_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_WIRE_MODE, [], '', 9, 'C');
}

=item set_sensor_connected_callback_configuration()

If you enable this callback, the :cb:`Sensor Connected` callback is triggered
every time a Pt sensor is connected/disconnected.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub set_sensor_connected_callback_configuration
{
	my ($self, $enabled) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION, [$enabled], '?', 0, '');
}

=item get_sensor_connected_callback_configuration()

Returns the configuration as set by :func:`Set Sensor Connected Callback Configuration`.

.. versionadded:: 2.0.2$nbsp;(Plugin)

=cut

sub get_sensor_connected_callback_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SENSOR_CONNECTED_CALLBACK_CONFIGURATION, [], '', 9, '?');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
