/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.utils;

import com.javonet.utils.JType;
import java.lang.reflect.Type;

public class TypesConverter {
    public static int convertTypeToJType(Type type) {
        if (type == Boolean.class || type == Boolean.TYPE) {
            return JType.BOOLEAN.ordinal();
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return JType.BYTE.ordinal();
        }
        if (type == Character.class || type == Character.TYPE) {
            return JType.CHAR.ordinal();
        }
        if (type == Float.class || type == Float.TYPE) {
            return JType.FLOAT.ordinal();
        }
        if (type == Double.class || type == Double.TYPE) {
            return JType.DOUBLE.ordinal();
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return JType.INTEGER.ordinal();
        }
        if (type == Long.class || type == Long.TYPE) {
            return JType.LONG.ordinal();
        }
        if (type == String.class) {
            return JType.STRING.ordinal();
        }
        if (type == Void.TYPE) {
            return JType.NULL.ordinal();
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    public static Type convertJTypeToType(JType type) {
        switch (type) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case CHAR: {
                return Character.class;
            }
            case FLOAT: {
                return Float.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case INTEGER: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case STRING: {
                return String.class;
            }
            case UNSIGNED_INTEGER: {
                return Integer.class;
            }
            case UNSIGNED_LONG_LONG: {
                return Long.class;
            }
            case NULL: {
                return Void.TYPE;
            }
        }
        throw new IllegalArgumentException("Unsupported JType: " + (Object)((Object)type));
    }
}

