/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.sdk.tools;

import com.javonet.sdk.Javonet;
import com.javonet.sdk.tools.ActivationHelper;
import com.javonet.sdk.tools.HttpConnection;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class SdkMessageHelper {
    private static SdkMessageHelper instance = null;
    private static final String address = "https://dc.services.visualstudio.com/v2/track";
    private static final String instrumentationKey = "2c751560-90c8-40e9-b5dd-534566514723";
    private static final String callingRuntimeName = "Jvm";
    private static final String javonetVersion = SdkMessageHelper.getJavonetVersion();
    private static final String nodeName = SdkMessageHelper.getHostName();
    private static final String osName = SdkMessageHelper.getOsName();
    static HttpConnection connection;

    private SdkMessageHelper() {
        connection = new HttpConnection(address);
    }

    public static SdkMessageHelper GetInstance() {
        if (instance == null) {
            instance = new SdkMessageHelper();
        }
        return instance;
    }

    public Future<Integer> sendMessageToAppInsights(String operationName, String message) {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Integer> future = executor.submit(() -> {
            try {
                String licenseKey = ActivationHelper.getLicenseKey();
                if (message.contains("BinariesUnloader exception") && licenseKey.equals("javonet-functional-tests-key")) {
                    return 0;
                }
                ZonedDateTime nowGMT = ZonedDateTime.now(ZoneId.of("GMT"));
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");
                String formattedDateTime = nowGMT.format(formatter);
                String jsonPayload = String.format("{\"name\":\"AppEvents\",\"time\":\"%s\",\"iKey\":\"%s\",\"tags\":{\"ai.application.ver\":\"%s\",\"ai.cloud.roleInstance\":\"%s\",\"ai.operation.id\":\"0\",\"ai.operation.parentId\":\"0\",\"ai.operation.name\":\"%s\",\"ai.internal.sdkVersion\":\"javonet:2\",\"ai.internal.nodeName\":\"%s\"},\"data\":{\"baseType\":\"EventData\",\"baseData\":{\"ver\":2,\"name\":\"%s\",\"properties\":{\"OperatingSystem\":\"%s\",\"LicenseKey\":\"%s\",\"CallingTechnology\":\"%s\"}}}}", formattedDateTime, instrumentationKey, javonetVersion, nodeName, operationName, nodeName, message, osName, licenseKey, callingRuntimeName);
                int responseCode = connection.send(jsonPayload);
                return responseCode;
            }
            catch (Exception ex) {
                return -1;
            }
        });
        executor.shutdown();
        return future;
    }

    private static String getJavonetVersion() {
        return Javonet.class.getPackage().getImplementationVersion();
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "Unknown Host";
        }
    }

    private static String getOsName() {
        return System.getProperty("os.name");
    }
}

