use v6.d;
use LibraryMake;
use Shell::Command;

my constant LIB = 'cast5';

class Build {
    method build($dir) {
        my %vars = get-vars($dir);
        %vars{LIB} = $*VM.platform-library-name(LIB.IO);
        mkdir "$dir/resources" unless "$dir/resources".IO.e;
        mkdir "$dir/resources/libraries" unless "$dir/resources/libraries".IO.e;
        process-makefile($dir, %vars);
        my $goback = $*CWD;
        chdir($dir);
        shell(%vars<MAKE>);
        chdir($goback);
    }
}
