package Monitoring::GLPlugin::SNMP::MibsAndOids::WLSXWLANMIB;

$Monitoring::GLPlugin::SNMP::MibsAndOids::origin->{'WLSX-WLAN-MIB'} = {
  url => '',
  name => 'WLSX-WLAN-MIB',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::mib_ids->{'WLSX-WLAN-MIB'} = 
  '1.3.6.1.4.1.14823.2.2.1.5';

$Monitoring::GLPlugin::SNMP::MibsAndOids::mibs_and_oids->{'WLSX-WLAN-MIB'} = {
  'wlsxWlanMIB' => '1.3.6.1.4.1.14823.2.2.1.5',
  'wlsxWlanConfigGroup' => '1.3.6.1.4.1.14823.2.2.1.5.1',
  'wlsxWlanStateGroup' => '1.3.6.1.4.1.14823.2.2.1.5.2',
  'wlsxWlanAccessPointInfoGroup' => '1.3.6.1.4.1.14823.2.2.1.5.2.1',
  'wlsxWlanTotalNumAccessPoints' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.1',
  'wlsxWlanTotalNumStationsAssociated' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.2',
  'wlsxWlanAPGroupTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.3',
  'wlsxWlanAPGroupEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.3.1',
  'wlanAPGroup' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.3.1.1',
  'wlanAPNumAps' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.3.1.2',
  'wlsxWlanAPTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4',
  'wlsxWlanAPEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1',
  'wlanAPMacAddress' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.1',
  'wlanAPIpAddress' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.2',
  'wlanAPName' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.3',
  'wlanAPGroupName' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.4',
  'wlanAPModel' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.5',
  'wlanAPSerialNumber' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.6',
  'wlanAPdot11aAntennaGain' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.7',
  'wlanAPdot11gAntennaGain' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.8',
  'wlanAPNumRadios' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.9',
  'wlanAPEnet1Mode' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.10',
  'wlanAPIpsecMode' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.11',
  'wlanAPUpTime' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.12',
  'wlanAPModelName' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.13',
  'wlanAPLocation' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.14',
  'wlanAPBuilding' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.15',
  'wlanAPFloor' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.16',
  'wlanAPLoc' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.17',
  'wlanAPExternalAntenna' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.18',
  'wlanAPStatus' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.19',
  'wlanAPStatusDefinition' => {
    '1' => 'up',
    '2' => 'down',
  },
  'wlanAPNumBootstraps' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.20',
  'wlanAPNumReboots' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.21',
  'wlanAPUnprovisioned' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.22',
  'wlanAPMonitorMode' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.23',
  'wlanAPFQLNBuilding' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.24',
  'wlanAPFQLNFloor' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.25',
  'wlanAPFQLN' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.26',
  'wlanAPFQLNCampus' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.4.1.27',
  'wlsxWlanRadioTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5',
  'wlsxWlanRadioEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1',
  'wlanAPRadioNumber' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.1',
  'wlanAPRadioType' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.2',
  'wlanAPRadioChannel' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.3',
  'wlanAPRadioTransmitPower' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.4',
  'wlanAPRadioMode' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.5',
  'wlanAPRadioUtilization' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.6',
  'wlanAPRadioNumAssociatedClients' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.7',
  'wlanAPRadioNumMonitoredClients' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.8',
  'wlanAPRadioNumActiveBSSIDs' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.9',
  'wlanAPRadioNumMonitoredBSSIDs' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.5.1.10',
  'wlsxWlanAPBssidTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7',
  'wlsxWlanAPBssidEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1',
  'wlanAPBSSID' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.1',
  'wlanAPESSID' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.2',
  'wlanAPBssidSlot' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.3',
  'wlanAPBssidPort' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.4',
  'wlanAPBssidPhyType' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.5',
  'wlanAPBssidRogueType' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.6',
  'wlanAPBssidMode' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.7',
  'wlanAPBssidModeDefinition' => 'WLSX-WLAN-MIB::wlanAPBssidMode',
  'wlanAPBssidChannel' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.8',
  'wlanAPBssidUpTime' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.9',
  'wlanAPBssidInactiveTime' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.10',
  'wlanAPBssidLoadBalancing' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.11',
  'wlanAPBssidNumAssociatedStations' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.12',
  'wlanAPBssidAPMacAddress' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.13',
  'wlanAPBssidPhyNumber' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.7.1.14',
  'wlsxWlanESSIDTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8',
  'wlsxWlanESSIDEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1',
  'wlanESSID' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1.1',
  'wlanESSIDNumStations' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1.2',
  'wlanESSIDNumAccessPointsUp' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1.3',
  'wlanESSIDNumAccessPointsDown' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1.4',
  'wlanESSIDEncryptionType' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.8.1.5',
  'wlsxWlanESSIDVlanPoolTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.9',
  'wlsxWlanESSIDVlanPoolEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.9.1',
  'wlanESSIDVlanId' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.9.1.1',
  'wlanESSIDVlanPoolStatus' => '1.3.6.1.4.1.14823.2.2.1.5.2.1.9.1.2',
  'wlsxWlanStationInfoGroup' => '1.3.6.1.4.1.14823.2.2.1.5.2.2',
  'wlsxWlanStationTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1',
  'wlsxWlanStationEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1',
  'wlanStaPhyAddress' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.1',
  'wlanStaApBssid' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.2',
  'wlanStaPhyType' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.3',
  'wlanStaIsAuthenticated' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.4',
  'wlanStaIsAssociated' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.5',
  'wlanStaChannel' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.6',
  'wlanStaVlanId' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.7',
  'wlanStaVOIPState' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.8',
  'wlanStaVOIPProtocol' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.9',
  'wlanStaTransmitRate' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.10',
  'wlanStaAssociationID' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.11',
  'wlanStaAccessPointESSID' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.12',
  'wlanStaPhyNumber' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.13',
  'wlanStaRSSI' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.14',
  'wlanStaUpTime' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.1.1.15',
  'wlsxWlanStaAssociationFailureTable' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2',
  'wlsxWlanStaAssociationFailureEntry' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1',
  'wlanStaAssocFailureApName' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.1',
  'wlanStaAssocFailureApEssid' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.2',
  'wlanStaAssocFailurePhyNum' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.3',
  'wlanStaAssocFailurePhyType' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.4',
  'wlanStaAssocFailureElapsedTime' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.5',
  'wlanStaAssocFailureReason' => '1.3.6.1.4.1.14823.2.2.1.5.2.2.2.1.6',
  'wlsxWlanAssociationInfoGroup' => '1.3.6.1.4.1.14823.2.2.1.5.2.3',
  'wlsxWlanStatsGroup' => '1.3.6.1.4.1.14823.2.2.1.5.3',
  'wlsxWlanAccessPointStatsGroup' => '1.3.6.1.4.1.14823.2.2.1.5.3.1',
  'wlsxWlanAPStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1',
  'wlsxWlanAPStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1',
  'wlanAPCurrentChannel' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.1',
  'wlanAPNumClients' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.2',
  'wlanAPTxPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.3',
  'wlanAPTxBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.4',
  'wlanAPRxPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.5',
  'wlanAPRxBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.6',
  'wlanAPTxDeauthentications' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.7',
  'wlanAPRxDeauthentications' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.8',
  'wlanAPChannelThroughput' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.9',
  'wlanAPFrameRetryRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.10',
  'wlanAPFrameLowSpeedRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.11',
  'wlanAPFrameNonUnicastRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.12',
  'wlanAPFrameFragmentationRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.13',
  'wlanAPFrameBandwidthRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.14',
  'wlanAPFrameRetryErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.15',
  'wlanAPChannelErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.16',
  'wlanAPFrameReceiveErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.17',
  'wlanAPRxDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.18',
  'wlanAPRxDataBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.19',
  'wlanAPTxDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.20',
  'wlanAPTxDataBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.21',
  'wlanAPRxDataPkts64' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.22',
  'wlanAPRxDataBytes64' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.23',
  'wlanAPTxDataPkts64' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.24',
  'wlanAPTxDataBytes64' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.1.1.25',
  'wlsxWlanAPRateStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2',
  'wlsxWlanAPRateStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1',
  'wlanAPStatsTotPktsAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.1',
  'wlanAPStatsTotBytesAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.2',
  'wlanAPStatsTotPktsAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.3',
  'wlanAPStatsTotBytesAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.4',
  'wlanAPStatsTotPktsAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.5',
  'wlanAPStatsTotBytesAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.6',
  'wlanAPStatsTotPktsAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.7',
  'wlanAPStatsTotBytesAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.8',
  'wlanAPStatsTotPktsAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.9',
  'wlanAPStatsTotBytesAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.10',
  'wlanAPStatsTotPktsAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.11',
  'wlanAPStatsTotBytesAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.12',
  'wlanAPStatsTotPktsAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.13',
  'wlanAPStatsTotBytesAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.14',
  'wlanAPStatsTotPktsAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.15',
  'wlanAPStatsTotBytesAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.16',
  'wlanAPStatsTotPktsAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.17',
  'wlanAPStatsTotBytesAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.18',
  'wlanAPStatsTotPktsAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.19',
  'wlanAPStatsTotBytesAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.20',
  'wlanAPStatsTotPktsAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.21',
  'wlanAPStatsTotBytesAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.22',
  'wlanAPStatsTotPktsAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.23',
  'wlanAPStatsTotBytesAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.2.1.24',
  'wlsxWlanAPDATypeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3',
  'wlsxWlanAPDATypeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1',
  'wlanAPStatsTotDABroadcastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.1',
  'wlanAPStatsTotDABroadcastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.2',
  'wlanAPStatsTotDAMulticastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.3',
  'wlanAPStatsTotDAMulticastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.4',
  'wlanAPStatsTotDAUnicastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.5',
  'wlanAPStatsTotDAUnicastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.3.1.6',
  'wlsxWlanAPFrameTypeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4',
  'wlsxWlanAPFrameTypeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1',
  'wlanAPStatsTotMgmtPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.1',
  'wlanAPStatsTotMgmtBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.2',
  'wlanAPStatsTotCtrlPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.3',
  'wlanAPStatsTotCtrlBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.4',
  'wlanAPStatsTotDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.5',
  'wlanAPStatsTotDataBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.4.1.6',
  'wlsxWlanAPPktSizeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5',
  'wlsxWlanAPPktSizeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1',
  'wlanAPStatsPkts63Bytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.1',
  'wlanAPStatsPkts64To127' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.2',
  'wlanAPStatsPkts128To255' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.3',
  'wlanAPStatsPkts256To511' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.4',
  'wlanAPStatsPkts512To1023' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.5',
  'wlanAPStatsPkts1024To1518' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.5.1.6',
  'wlsxWlanAPChStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6',
  'wlsxWlanAPChStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1',
  'wlanAPChannelNumber' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.1',
  'wlanAPChNumStations' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.2',
  'wlanAPChTotPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.3',
  'wlanAPChTotBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.4',
  'wlanAPChTotRetryPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.5',
  'wlanAPChTotFragmentedPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.6',
  'wlanAPChTotPhyErrPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.7',
  'wlanAPChTotMacErrPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.8',
  'wlanAPChNoise' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.9',
  'wlanAPChCoverageIndex' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.10',
  'wlanAPChInterferenceIndex' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.11',
  'wlanAPChFrameRetryRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.12',
  'wlanAPChFrameLowSpeedRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.13',
  'wlanAPChFrameNonUnicastRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.14',
  'wlanAPChFrameFragmentationRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.15',
  'wlanAPChFrameBandwidthRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.16',
  'wlanAPChFrameRetryErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.17',
  'wlanAPChBusyRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.18',
  'wlanAPChNumAPs' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.19',
  'wlanAPChFrameReceiveErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.1.6.1.20',
  'wlsxWlanStationStatsGroup' => '1.3.6.1.4.1.14823.2.2.1.5.3.2',
  'wlsxWlanStationStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1',
  'wlsxWlanStationStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1',
  'wlanStaChannelNum' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.1',
  'wlanStaTxPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.2',
  'wlanStaTxBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.3',
  'wlanStaRxPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.4',
  'wlanStaRxBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.5',
  'wlanStaTxBCastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.6',
  'wlanStaRxBCastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.7',
  'wlanStaTxMCastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.8',
  'wlanStaRxMCastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.9',
  'wlanStaDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.10',
  'wlanStaCtrlPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.11',
  'wlanStaNumAssocRequests' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.12',
  'wlanStaNumAuthRequests' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.13',
  'wlanStaTxDeauthentications' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.14',
  'wlanStaRxDeauthentications' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.15',
  'wlanStaFrameRetryRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.16',
  'wlanStaFrameLowSpeedRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.17',
  'wlanStaFrameNonUnicastRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.18',
  'wlanStaFrameFragmentationRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.19',
  'wlanStaFrameBandwidthRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.20',
  'wlanStaFrameRetryErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.21',
  'wlanStaFrameReceiveErrorRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.22',
  'wlanStaTxBCastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.23',
  'wlanStaTxMCastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.1.1.24',
  'wlsxWlanStaRateStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2',
  'wlsxWlanStaRateStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1',
  'wlanStaTxPktsAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.1',
  'wlanStaTxBytesAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.2',
  'wlanStaTxPktsAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.3',
  'wlanStaTxBytesAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.4',
  'wlanStaTxPktsAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.5',
  'wlanStaTxBytesAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.6',
  'wlanStaTxPktsAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.7',
  'wlanStaTxBytesAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.8',
  'wlanStaTxPktsAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.9',
  'wlanStaTxBytesAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.10',
  'wlanStaTxPktsAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.11',
  'wlanStaTxBytesAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.12',
  'wlanStaTxPktsAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.13',
  'wlanStaTxBytesAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.14',
  'wlanStaTxPktsAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.15',
  'wlanStaTxBytesAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.16',
  'wlanStaTxPktsAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.17',
  'wlanStaTxBytesAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.18',
  'wlanStaTxPktsAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.19',
  'wlanStaTxBytesAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.20',
  'wlanStaTxPktsAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.21',
  'wlanStaTxBytesAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.22',
  'wlanStaRxPktsAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.23',
  'wlanStaRxBytesAt1Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.24',
  'wlanStaRxPktsAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.25',
  'wlanStaRxBytesAt2Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.26',
  'wlanStaRxPktsAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.27',
  'wlanStaRxBytesAt5Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.28',
  'wlanStaRxPktsAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.29',
  'wlanStaRxBytesAt11Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.30',
  'wlanStaRxPktsAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.31',
  'wlanStaRxBytesAt6Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.32',
  'wlanStaRxPktsAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.33',
  'wlanStaRxBytesAt12Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.34',
  'wlanStaRxPktsAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.35',
  'wlanStaRxBytesAt18Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.36',
  'wlanStaRxPktsAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.37',
  'wlanStaRxBytesAt24Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.38',
  'wlanStaRxPktsAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.39',
  'wlanStaRxBytesAt36Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.40',
  'wlanStaRxPktsAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.41',
  'wlanStaRxBytesAt48Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.42',
  'wlanStaRxPktsAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.43',
  'wlanStaRxBytesAt54Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.44',
  'wlanStaTxPktsAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.45',
  'wlanStaTxBytesAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.46',
  'wlanStaRxPktsAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.47',
  'wlanStaRxBytesAt9Mbps' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.2.1.48',
  'wlsxWlanStaDATypeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3',
  'wlsxWlanStaDATypeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1',
  'wlanStaTxDABroadcastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.1',
  'wlanStaTxDABroadcastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.2',
  'wlanStaTxDAMulticastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.3',
  'wlanStaTxDAMulticastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.4',
  'wlanStaTxDAUnicastPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.5',
  'wlanStaTxDAUnicastBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.3.1.6',
  'wlsxWlanStaFrameTypeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4',
  'wlsxWlanStaFrameTypeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1',
  'wlanStaTxMgmtPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.1',
  'wlanStaTxMgmtBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.2',
  'wlanStaTxCtrlPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.3',
  'wlanStaTxCtrlBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.4',
  'wlanStaTxDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.5',
  'wlanStaTxDataBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.6',
  'wlanStaRxMgmtPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.7',
  'wlanStaRxMgmtBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.8',
  'wlanStaRxCtrlPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.9',
  'wlanStaRxCtrlBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.10',
  'wlanStaRxDataPkts' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.11',
  'wlanStaRxDataBytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.4.1.12',
  'wlsxWlanStaPktSizeStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5',
  'wlsxWlanStaPktSizeStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1',
  'wlanStaTxPkts63Bytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.1',
  'wlanStaTxPkts64To127' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.2',
  'wlanStaTxPkts128To255' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.3',
  'wlanStaTxPkts256To511' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.4',
  'wlanStaTxPkts512To1023' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.5',
  'wlanStaTxPkts1024To1518' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.6',
  'wlanStaRxPkts63Bytes' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.7',
  'wlanStaRxPkts64To127' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.8',
  'wlanStaRxPkts128To255' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.9',
  'wlanStaRxPkts256To511' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.10',
  'wlanStaRxPkts512To1023' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.11',
  'wlanStaRxPkts1024To1518' => '1.3.6.1.4.1.14823.2.2.1.5.3.2.5.1.12',
  'wlsxWlanSwitchStatsGroup' => '1.3.6.1.4.1.14823.2.2.1.5.3.3',
  'wlsxWlanEthStatsTable' => '1.3.6.1.4.1.14823.2.2.1.5.3.3.2',
  'wlsxWlanEthStatsEntry' => '1.3.6.1.4.1.14823.2.2.1.5.3.3.2.1',
  'wlanEthRxRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.3.2.1.1',
  'wlanEthTxRate' => '1.3.6.1.4.1.14823.2.2.1.5.3.3.2.1.2',
};

$Monitoring::GLPlugin::SNMP::MibsAndOids::definitions->{'WLSX-WLAN-MIB'} = {
  'wlanAPBssidMode' => {
    '1' => 'ap',
    '2' => 'am',
  },
};

1;

__END__
