#!/usr/bin/env perl 
#
# Before `make install' is performed this script should be runnable with
# `make test'.
# After `make install' it should work as `perl 270_Slurm-SAUser-echo.t'
use strict;
use warnings;

use Test::More;
use Cwd qw(abs_path);
use File::Basename qw(dirname);

use Slurm::Sacctmgr;
use Slurm::Sacctmgr::User;

my $testDir = dirname(abs_path($0));
our $num_tests_run = 0;

require "$testDir/helpers/echo-help.pl";

my $sa = Slurm::Sacctmgr->new(sacctmgr=>"${testDir}/helpers/echo_cmdline");
my $sauser = 'Slurm::Sacctmgr::User';

my $results;
my $args;
my $err;
my $argstr;
my (@temp, @temp2);
my ($temp, $temp2);

#Test various commands with echo sacctmgr

my @listtmp1 = ( 'list', 'user', 'format=adminlevel,defaultaccount,user' );
my @listtmp2 = ( '--parsable2', '--noheader', '--readonly' );
@temp = ( name=>'payerle', );
$results = $sauser->sacctmgr_list($sa,@temp);
$results = $sauser->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single user');

@temp = ( cluster => 'yottascale', account=>'topsecret'  );
$results = $sauser->sacctmgr_list($sa,@temp);
$results = $sauser->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist_lexical(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list user multi-fields');


@temp = ( defaultaccount=>'special', cluster=>'yottascale', account=>'abc124', name=>'payerle', );
$results = $sauser->sacctmgr_add($sa,@temp);
$results = $sauser->_ebadddel_last_raw_output;
$args = [ '-i', 'add', 'user', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_add user');

note('Ignore output to stderr about return value from sacctmgr_modify');
@temp = ( cluster=>'yottascale', account=>'abc124', name=>'payerle', );
@temp2 = ( defaultaccount=>'secret', rawusage=>0 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $sauser->sacctmgr_modify($sa,$temp, $temp2);
$results = $sauser->_ebmod_last_raw_output;
$args = [ '-i', 'modify', 'user', 'where',  hash_to_arglist_lexical(@temp), 'set', hash_to_arglist_lexical(@temp2) ];
check_results($args, $results, 'sacctmgr_modify user');

@temp = ( cluster=>'yottascale', account=>'abc124', name=>'payerle', );
$results = $sauser->sacctmgr_delete($sa,@temp);
$results = $sauser->_ebadddel_last_raw_output;
$args = [ '-i', 'delete', 'user', 'where', hash_to_arglist_lexical(@temp) ];
check_results($args, $results, 'sacctmgr_delete user');


#Now verify that nothing is run when we are in debug mode
note('The remaining tests generate [DRYRUN] lines, which you can ignore');
note('We just want to make sure they dont actually _do_ anything');
$sa->dryrun(1);

@temp = ( defaultaccount=>'special', cluster=>'yottascale', account=>'abc124', name=>'payerle', );
$temp = $sauser->_ebadddel_last_raw_output;
$results = $sauser->sacctmgr_add($sa,@temp);
$results =$sauser->_ebadddel_last_raw_output; 
is_deeply( $results, [], "sacctmgr_add user (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale', account=>'abc124', name=>'payerle', );
@temp2 = ( defaultaccount=>'secret', rawusage=>0 );
$temp = { @temp }; 
$temp2 = { @temp2 };
$results = $sauser->sacctmgr_modify($sa,$temp, $temp2);
$results = $sauser->_ebmod_last_raw_output;
is_deeply( $results, [], "sacctmgr_modify user (dryrun mode)");
$num_tests_run++;

@temp = ( cluster=>'yottascale', account=>'abc124', name=>'payerle', );
$results = $sauser->sacctmgr_delete($sa,@temp);
$results = $sauser->_ebadddel_last_raw_output;
is_deeply( $results, [], "sacctmgr_delete user (dryrun mode)");
$num_tests_run++;

#This one actually _should_ run, as is just a list
@temp = ( name=>'payerle', );
$results = $sauser->sacctmgr_list($sa,@temp);
$results = $sauser->_eblist_last_raw_output;
$args = [ @listtmp1, hash_to_arglist(@temp), @listtmp2 ];
check_results($args, $results, 'sacctmgr_list single user (dryrun mode)');

done_testing($num_tests_run);

