<!-- DO NOT EDIT: File generated by docs/Generate.sh -->

NAME
====

Net::Packet::IPv4_addr

SYNOPSIS
========

    use IPv4_addr :short;

    my $buf = Buf.new([0, 11, 22, 33, 44, 55]);
    my $ip  = IPv4_addr.unpack($buf, 1); # Starts unpacking at $buf[1].

    say $ip.Str; '11.22.33.44'

EXPORTS
=======

    Net::Packet::IPv4_addr;

:short traits adds export:

    constant IPv4_addr ::= Net::Packet::IPv4_addr;

DESCRIPTION
===========



class Net::Packet::IPv4_addr
----------------------------

### Attributes

     $.addr  is rw is Int
       Address

### Methods

    .new(Int $addr) returns IPv4_addr
    .new(Str $addr) returns IPv4_addr
      Constructor, takes $addr as:
       - Int;
       - Str in the form of '1.222.33.44'.

    .unpack($buf, Int $i) returns IPv4_addr
      Constructor, unpacks address from buffer $buf starting at position $i.
      $buf can be of builtin type Buf or C_Buf from Net::Pcap.

    .octets() returns Array
      Returns the address represented by an Array of 4 Ints (one for each byte of
      the address).

    .Int() returns Int
      Returns the address as Int.

    .Str() returns Str
      Returns the address as string in the form of '11.22.33.44'.

    .Buf() returns Buf
      Returns the address as a byte string.
