package xzip; 

use IO::File; 
use Archive::Zip qw(:CONSTANTS :ERROR_CODES); 

#global zip object 
my ($Zip, $ErrorLog, $ZipLog) = (); 



sub ZipCallBack
{
   
   my ($Object, $DirFlag) = @_ ; 
   if($DirFlag)
   {
	  $Zip->addDirectory($Object);  
   }
   else
   {
	  my $member = $Zip->addFile($Object); 
	  $member->desiredCompressionMethod( COMPRESSION_DEFLATED );
   }
}

sub ZipErrorHandler
{
}

sub BrowseDirectoryTree 
{ 
  if($#_ != 1)
  {
     print("Script Error: Number of arguments to the BrowseDirectoryTree is less than 2, exitting...");
     return -1; 
  }
  
  my ($root_folder, $function) = @_;
  unless(-d $root_folder)
  {
     print("$root_folder is not present\n exitting..."); 
     return -1;
  }
  
  sub Browse
  {
      my $dir = $_[0];
	  my $_function = $_[1]; 
      unless (opendir(DIR,$dir))
      {
         print("Error: Failed to open dir $dir\n"); 
         return; 
      }
      my($dir_item,@dirs); 
      foreach $dir_item(readdir(DIR))
      {
         if($dir_item eq "." || $dir_item eq "..")
         {
            next; 
         }
		 
         $complete_path = "$dir\\$dir_item";
         if(-d $complete_path)
         {
            push(@dirs,$complete_path); 
			&$_function($complete_path,1); #callback 
         }
		 else
		 {
			&$_function($complete_path,0); #callback 
		 }
      }
      
      close(DIR);
      $dir_item = ""; 
      foreach $dir_item (@dirs)
      {
          Browse($dir_item,$_function); 
      }
  }
  
  Browse($root_folder,$function);
}

sub ZipTree
{
   my ($ZipFile, $RootFolder) = @_; 
   unless( -d $RootFolder)
   {
	  return; 
   }
   
   $Zip = Archive::Zip->new(); 
   if(undef == $Zip)
   {
	  print("Error: Zip file- $ZipFile cant be created, Exiting...\n"); 
	  return; 
   }
   
   #open error log file 
   my $ErrorLogFile = $ZipFile =~ m/^(.*)\./.".log"; 
   
   $ErrorLog = new IO::File; 
   unless ($ErrorLog->open(">$ErrorLogFile"))
   {
	  print("Error: ErrorLog - $ErrorLogFile can't be created, Exiting...\n"); 
	  return; 
   }
   
   #open zip log file
   my $ZipLogFile = $ZipFile =~ m/^(.*)\./.".log"; 
   $ZipLog = new IO::File; 
   unless($ZipLog->open(">$ZipLog"))
   {
	  $ErrorLog->close(); 
	  print("Error: Ziplog - $ZipLogFile can't be created, Exitting...\n"); 
	  return; 
   } 	  
   
   Archive::Zip::setErrorHandler(\&ZipErrorHandler);
   
   #Browse directory tree and zip 
   BrowseDirectoryTree($RootFolder,\&ZipCallBack); 
   
   sub WriteErrorCode
   {
	  my ($ZipErrorCode, $Obj) = @_; 
	  if($ZipErrorCode == AZ_OK)
	  {
		 print ($ZipLog "$Obj added to zip file\n"); 
	  }
	  elsif($ZipErrorCode == AZ_STREAM_END)
	  {
		 print ($ErrorLog "$Obj - Stream End error\n"); 
	  }
	  elsif($ZipErrorCode == AZ_ERROR)
	  {
		 print ($ErrorLog "$Obj - Zipping Error\n"); 
	  }
	  elsif($ZipErrorCode == AZ_IO_ERROR)
	  {
		 print ($ErrorLog "$Obj - IO Error\n"); 
	  }
	  else
	  {
		 print ($ErrorLog "$Obj - Unknown Error\n"); 
	  }
   }
   
   #write to zip file 
   my $ret_val_t = $Zip->writeToFileNamed($ZipFile);
   WriteErrorCode($ret_val_t);
   
   
   $ErrorLog->close(); 
}

1; 

__END__
=head1 NAME

lib - manipulate @INC at compile time

=head1 SYNOPSIS

    use lib LIST;

    no lib LIST;

=head1 DESCRIPTION

This is a small simple module which simplifies the manipulation of @INC
at compile time.

It is typically used to add extra directories to perl's search path so
that later C<use> or C<require> statements will find modules which are
not located on perl's default search path.

=head2 Adding directories to @INC

The parameters to C<use lib> are added to the start of the perl search
path. Saying

    use lib LIST;

is I<almost> the same as saying

    BEGIN { unshift(@INC, LIST) }

For each directory in LIST (called $dir here) the lib module also
checks to see if a directory called $dir/$archname/auto exists.
If so the $dir/$archname directory is assumed to be a corresponding
architecture specific directory and is added to @INC in front of $dir.

To avoid memory leaks, all trailing duplicate entries in @INC are
removed.

=head2 Deleting directories from @INC

You should normally only add directories to @INC.  If you need to
delete directories from @INC take care to only delete those which you
added yourself or which you are certain are not needed by other modules
in your script.  Other modules may have added directories which they
need for correct operation.

The C<no lib> statement deletes all instances of each named directory
from @INC.

For each directory in LIST (called $dir here) the lib module also
checks to see if a directory called $dir/$archname/auto exists.
If so the $dir/$archname directory is assumed to be a corresponding
architecture specific directory and is also deleted from @INC.

=head2 Restoring original @INC

When the lib module is first loaded it records the current value of @INC
in an array C<@lib::ORIG_INC>. To restore @INC to that value you
can say

    @INC = @lib::ORIG_INC;


=head1 SEE ALSO

FindBin - optional module which deals with paths relative to the source file.

=head1 AUTHOR

Sanjit Rath, December 2005 

=cut
