#!/usr/bin/perl

package eBay::API::XML::DataType::HistogramEntryType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. HistogramEntryType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::HistogramEntryType

=head1 DESCRIPTION

A generic histogram entry type.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::HistogramEntryType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'Count', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( [ 'id', 'xs:string', '', '', '' ]
	, [ 'name', 'xs:string', '', '', '' ]
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCount()

For GetProducts, the number of products found in the domain
(characteristic set or attribute set). If a product is mapped
to more than one domain, it will be counted separately for each
domain. (For example, if the same product can be found in both
Children's Books and Fiction Books, the count for both of these
domains will include that product.)
Furthermore, when a product is mapped to more than one domain,
Product.AttributeSetID only returns the most applicable domain,
as determined by eBay.

#    Argument: 'xs:int'

=cut

sub setCount {
  my $self = shift;
  $self->{'Count'} = shift
}

=head2 getCount()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getCount {
  my $self = shift;
  return $self->{'Count'};
}




=head2 setId()

For GetProducts, this is the domain ID (attribute set ID or
characteristic set ID).

#    Argument: 'xs:string'

=cut

sub setId {
  my $self = shift;
  $self->{'id'} = shift
}

=head2 getId()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getId {
  my $self = shift;
  return $self->{'id'};
}


=head2 setName()

For GetProducts, this is the domain name (attribute set name
or characteristic set name). A domain is like a high-level category.

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'name'} = shift
}

=head2 getName()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'name'};
}



##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
