# Testing Random::Skew

use strict;
use warnings;

use English qw(-no_match_vars);
use Error::Pure::Utils qw(clean);

use Random::Skew;

use Test::More;
use Test::NoWarnings 'had_no_warnings';



my $g;
eval {
    $g = Random::Skew::GRAIN( 'xxx' );
};
ok($EVAL_ERROR =~ /GRAIN must be a positive integer/,"Noninteger GRAIN gripe 1");

clean();



eval {
    $g = Random::Skew::GRAIN( 33.3 );
};
ok($EVAL_ERROR =~ /GRAIN must be a positive integer/,"Noninteger GRAIN gripe 2");

clean();



eval {
    $g = Random::Skew::GRAIN( 1 );
};
ok($EVAL_ERROR =~ /GRAIN must be >= 2/,"Insufficient GRAIN gripe");

clean();


$g = Random::Skew::GRAIN( 33 );
is($Random::Skew::GRAIN,33,"Grain is set");



had_no_warnings;
done_testing( 5 );
