# Do not remove the following line; MakeMaker relies on it to identify
# this file as a template for defsubs.h
# Extracting defsubs.h (with variable substitutions)
#!perl -w
use File::Spec;
my @(_, $headerpath) =  @ARGV;
my @($out) = @: __FILE__ =~ m/(^.*)\.PL/i;
$out =~ s/_h$/.h/;
unlink $out if -l $out;
open(my $out_fh,">","$out") || die "Cannot open $out:$^OS_ERROR";
print $^STDOUT, "Extracting $out...\n";
print $out_fh, <<"END";
/*
 !!! Don't modify this file - it's autogenerated from $^PROGRAM_NAME !!!
 */
END

foreach my $const (qw(
		      CVf_ANON
		      CVf_CLONE
		      CVf_CLONED
		      CVf_CONST
		      CVf_NODEBUG
		      CVf_UNIQUE
		      GVf_IMPORTED_AV
		      GVf_IMPORTED_CV
		      GVf_IMPORTED_HV
		      GVf_IMPORTED_SV
		      HEf_SVKEY
		      SVTYPEMASK
		      SVf_FAKE
		      SVf_IOK
		      SVf_IVisUV
		      SVf_NOK
		      SVf_POK
		      SVf_READONLY
		      SVf_ROK
		      SVp_IOK
		      SVp_NOK
		      SVp_POK
		      SVpad_OUR
		      SVs_RMG
		      SVs_SMG
		      SVt_PVGV
		      SVt_PVHV
		      PAD_FAKELEX_ANON
		      PAD_FAKELEX_MULTI
                      PAD_NAME_START_INDEX
		      ))
 {
  doconst($const);
 }

doconst('CVf_ISXSUB');

foreach my $tuple (@(\@('op.h'),\@('cop.h'),\@('regexp.h','RXf_')))
 {
  my $file = $tuple->[0];
  my $pfx = $tuple->[?1] || '';
  my $path = File::Spec->catfile($headerpath, $file);
  open(my $oph,"<","$path") || die "Cannot open $path:$^OS_ERROR";
  while ( ~< $oph)
   {  
    doconst($1) if (m/#define\s+($pfx\w+)\s+([\(\)\|\dx]+)\s*(?:$|\/\*)/);
   }  
  close($oph);
 }
close($out_fh);
               
sub doconst
{
 my $sym = shift;
 my $l = length($sym);
 print $out_fh, <<"END";
 ENTER;
 SAVESPTR(PL_curstash);
 HVcpREPLACE(PL_curstash, stash);
 newCONSTSUB("$sym",newSViv($sym)); 
 av_push(export_ok,newSVpvn("$sym",$l));
 LEAVE;
END
}
