#! /usr/bin/env perl6

use v6.d;

use Grammar::TodoTxt;
use Test;

my $input = q:to/EOF/;
x (A) 2016-05-20 2016-04-30 measure space for @context +chapelShelving @chapel due:2016-05-30

EOF

plan $input.lines.elems - 1;

my $todo = Grammar::TodoTxt.parse($input);

subtest 'Example 1', {
	plan 2;

	my $record = $todo<records>[0];

	subtest 'Existence', {
		plan 7;

		ok $record<completion-marker>, 'Completion marker set';
		ok $record<priority>, 'Priority is set';
		ok $record<completion>, 'Completion date is set';
		ok $record<creation>, 'Creation date is set';
		ok $record<description><projects>, 'Projects are set';
		ok $record<description><contexts>, 'Contexts are set';
		ok $record<description><labels>, 'Labels are set';
	}

	subtest 'Correctness', {
		plan 6;

		is ~$record<priority>, 'A', 'Priority is correct';
		is ~$record<completion>, '2016-05-20', 'Completion date is correct';
		is ~$record<creation>, '2016-04-30', 'Creation date is correct';

		subtest 'Projects', {
			plan 2;

			my @projects = $record<description><projects>.map(*.Str);

			is @projects.elems, 1, '1 project found';
			is ~@projects[0], 'chapelShelving', 'chapelShelving project found';
		}

		subtest 'Contexts', {
			plan 3;

			my @contexts = $record<description><contexts>.map(*.Str).sort;

			is @contexts.elems, 2, '2 contexts found';
			is @contexts[0], 'chapel', 'chapel context found';
			is @contexts[1], 'context', 'context context found';
		}

		subtest 'Labels', {
			plan 3;

			my %labels = $record<description><labels>.map({ ~$_<key> => ~$_<value> });

			is %labels.elems, 1, '1 label found';
			ok %labels<due>:exists, 'due label found';
			is %labels<due>, '2016-05-30', 'due value is correct';
		}
	}
}

# vim: ft=perl6 noet
