#! /usr/bin/env perl6

use v6.d;

use Grammar::TodoTxt;
use Test;

my $input = q:to/EOF/;
(A) Call Mom
Really gotta call Mom (A) @phone @someday
(b) Get back to the boss
(B)->Submit TPS report
EOF

plan $input.lines.elems;

my $todo = Grammar::TodoTxt.parse($input);

subtest 'Line 1', {
	plan 2;

	my $priority = $todo<records>[0]<priority>;

	ok $priority, 'There is a priority';
	is $todo<records>[0]<priority>, 'A', 'The priority is correct';
}

subtest 'Line 2', {
	plan 1;

	nok $todo<records>[1]<priority>, 'Line 2 has no priority';
}

subtest 'Line 3', {
	plan 1;

	nok $todo<records>[2]<priority>, 'Line 3 has no priority';
}

subtest 'Line 4', {
	plan 1;

	nok $todo<records>[3]<priority>, 'Line 4 has no priority';
}

# vim: ft=perl6 noet
