package Microsoft::AdCenter::V8::ReportingService::AdExtensionByAdsReportColumn;
# Copyright (C) 2012 Xerxes Tsang
# This program is free software; you can redistribute it and/or modify it
# under the terms of Perl Artistic License.

use strict;
use warnings;

=head1 NAME

Microsoft::AdCenter::V8::ReportingService::AdExtensionByAdsReportColumn - Represents "AdExtensionByAdsReportColumn" in Microsoft AdCenter Reporting Service.

=head1 SYNOPSIS

See L<http://msdn.microsoft.com/en-us/library/ee730327.aspx> for documentation of the various data objects.

=head1 ENUMERATION VALUES

    AccountId
    AccountName
    AccountNumber
    AdExtensionId
    AdExtensionType
    AdExtensionVersion
    AdGroupId
    AdGroupName
    AdId
    AdTitle
    AverageCpc
    CampaignId
    CampaignName
    Clicks
    ConversionRate
    Conversions
    Ctr
    DeviceOS
    DeviceType
    Impressions
    Spend
    TimePeriod
    TotalClicks

=cut

sub AccountId {
    return 'AccountId';
}

sub AccountName {
    return 'AccountName';
}

sub AccountNumber {
    return 'AccountNumber';
}

sub AdExtensionId {
    return 'AdExtensionId';
}

sub AdExtensionType {
    return 'AdExtensionType';
}

sub AdExtensionVersion {
    return 'AdExtensionVersion';
}

sub AdGroupId {
    return 'AdGroupId';
}

sub AdGroupName {
    return 'AdGroupName';
}

sub AdId {
    return 'AdId';
}

sub AdTitle {
    return 'AdTitle';
}

sub AverageCpc {
    return 'AverageCpc';
}

sub CampaignId {
    return 'CampaignId';
}

sub CampaignName {
    return 'CampaignName';
}

sub Clicks {
    return 'Clicks';
}

sub ConversionRate {
    return 'ConversionRate';
}

sub Conversions {
    return 'Conversions';
}

sub Ctr {
    return 'Ctr';
}

sub DeviceOS {
    return 'DeviceOS';
}

sub DeviceType {
    return 'DeviceType';
}

sub Impressions {
    return 'Impressions';
}

sub Spend {
    return 'Spend';
}

sub TimePeriod {
    return 'TimePeriod';
}

sub TotalClicks {
    return 'TotalClicks';
}

1;
