
package Paws::AccessAnalyzer::StartPolicyGeneration;
  use Moose;
  has ClientToken => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'clientToken');
  has CloudTrailDetails => (is => 'ro', isa => 'Paws::AccessAnalyzer::CloudTrailDetails', traits => ['NameInRequest'], request_name => 'cloudTrailDetails');
  has PolicyGenerationDetails => (is => 'ro', isa => 'Paws::AccessAnalyzer::PolicyGenerationDetails', traits => ['NameInRequest'], request_name => 'policyGenerationDetails', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'StartPolicyGeneration');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/policy/generation');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'PUT');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::AccessAnalyzer::StartPolicyGenerationResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::StartPolicyGeneration - Arguments for method StartPolicyGeneration on L<Paws::AccessAnalyzer>

=head1 DESCRIPTION

This class represents the parameters used for calling the method StartPolicyGeneration on the
L<Access Analyzer|Paws::AccessAnalyzer> service. Use the attributes of this class
as arguments to method StartPolicyGeneration.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to StartPolicyGeneration.

=head1 SYNOPSIS

    my $access-analyzer = Paws->service('AccessAnalyzer');
    my $StartPolicyGenerationResponse =
      $access -analyzer->StartPolicyGeneration(
      PolicyGenerationDetails => {
        PrincipalArn => 'MyPrincipalArn',

      },
      ClientToken       => 'MyString',    # OPTIONAL
      CloudTrailDetails => {
        AccessRole => 'MyRoleArn',
        StartTime  => '1970-01-01T01:00:00',
        Trails     => [
          {
            CloudTrailArn => 'MyCloudTrailArn',
            AllRegions    => 1,                      # OPTIONAL
            Regions       => [ 'MyString', ... ],    # OPTIONAL
          },
          ...
        ],
        EndTime => '1970-01-01T01:00:00',
      },    # OPTIONAL
      );

    # Results:
    my $JobId = $StartPolicyGenerationResponse->JobId;

    # Returns a L<Paws::AccessAnalyzer::StartPolicyGenerationResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/access-analyzer/StartPolicyGeneration>

=head1 ATTRIBUTES


=head2 ClientToken => Str

A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original
request completes successfully, the subsequent retries with the same
client token return the result from the original successful request and
they have no additional effect.

If you do not specify a client token, one is automatically generated by
the AWS SDK.



=head2 CloudTrailDetails => L<Paws::AccessAnalyzer::CloudTrailDetails>

A C<CloudTrailDetails> object that contains details about a C<Trail>
that you want to analyze to generate policies.



=head2 B<REQUIRED> PolicyGenerationDetails => L<Paws::AccessAnalyzer::PolicyGenerationDetails>

Contains the ARN of the IAM entity (user or role) for which you are
generating a policy.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method StartPolicyGeneration in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

