package # hide from PAUSE
    DateTime::Conflicts;

use strict;
use warnings;

# this module was generated with Dist::Zilla::Plugin::Conflicts 0.20

use Dist::CheckConflicts
    -dist      => 'DateTime',
    -conflicts => {
        'DateTime::Format::Mail' => '0.402',
    },
    -also => [ qw(
        Carp
        DateTime::Locale
        DateTime::TimeZone
        Dist::CheckConflicts
        POSIX
        Params::ValidationCompiler
        Scalar::Util
        Specio
        Specio::Declare
        Specio::Exporter
        Specio::Library::Builtins
        Specio::Library::Numeric
        Specio::Library::String
        Specio::Subs
        Try::Tiny
        XSLoader
        integer
        namespace::autoclean
        overload
        parent
        strict
        warnings
        warnings::register
    ) ],

;

1;

# ABSTRACT: Check for conflicts between DateTime and installed packages
# Dist::Zilla: -PodWeaver

__END__

=pod

=for Pod::Coverage *EVERYTHING*

=head1 NAME

DateTime::Conflicts - Check for conflicts between DateTime and installed packages

=head1 DESCRIPTION

This module contains information about conflicts between this distribution and
other CPAN distributions. It does not have any user-facing parts.

This module was generated by Dist::Zilla::Plugin::Conflicts 0.20.

=cut
