# Generated by default/object.tt
package Paws::Transcribe::MedicalTranscriptionJob;
  use Moose;
  has CompletionTime => (is => 'ro', isa => 'Str');
  has ContentIdentificationType => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has FailureReason => (is => 'ro', isa => 'Str');
  has LanguageCode => (is => 'ro', isa => 'Str');
  has Media => (is => 'ro', isa => 'Paws::Transcribe::Media');
  has MediaFormat => (is => 'ro', isa => 'Str');
  has MediaSampleRateHertz => (is => 'ro', isa => 'Int');
  has MedicalTranscriptionJobName => (is => 'ro', isa => 'Str');
  has Settings => (is => 'ro', isa => 'Paws::Transcribe::MedicalTranscriptionSetting');
  has Specialty => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');
  has Transcript => (is => 'ro', isa => 'Paws::Transcribe::MedicalTranscript');
  has TranscriptionJobStatus => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transcribe::MedicalTranscriptionJob

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transcribe::MedicalTranscriptionJob object:

  $service_obj->Method(Att1 => { CompletionTime => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transcribe::MedicalTranscriptionJob object:

  $result = $service_obj->Method(...);
  $result->Att1->CompletionTime

=head1 DESCRIPTION

The data structure that contains the information for a medical
transcription job.

=head1 ATTRIBUTES


=head2 CompletionTime => Str

A timestamp that shows when the job was completed.


=head2 ContentIdentificationType => Str

Shows the type of content that you've configured Amazon Transcribe
Medical to identify in a transcription job. If the value is C<PHI>,
you've configured the job to identify personal health information (PHI)
in the transcription output.


=head2 CreationTime => Str

A timestamp that shows when the job was created.


=head2 FailureReason => Str

If the C<TranscriptionJobStatus> field is C<FAILED>, this field
contains information about why the job failed.

The C<FailureReason> field contains one of the following values:

=over

=item *

C<Unsupported media format>- The media format specified in the
C<MediaFormat> field of the request isn't valid. See the description of
the C<MediaFormat> field for a list of valid values.

=item *

C<The media format provided does not match the detected media format>-
The media format of the audio file doesn't match the format specified
in the C<MediaFormat> field in the request. Check the media format of
your media file and make sure the two values match.

=item *

C<Invalid sample rate for audio file>- The sample rate specified in the
C<MediaSampleRateHertz> of the request isn't valid. The sample rate
must be between 8000 and 48000 Hertz.

=item *

C<The sample rate provided does not match the detected sample rate>-
The sample rate in the audio file doesn't match the sample rate
specified in the C<MediaSampleRateHertz> field in the request. Check
the sample rate of your media file and make sure that the two values
match.

=item *

C<Invalid file size: file size too large>- The size of your audio file
is larger than what Amazon Transcribe Medical can process. For more
information, see Guidelines and Quotas
(https://docs.aws.amazon.com/transcribe/latest/dg/limits-guidelines.html#limits)
in the I<Amazon Transcribe Medical Guide>

=item *

C<Invalid number of channels: number of channels too large>- Your audio
contains more channels than Amazon Transcribe Medical is configured to
process. To request additional channels, see Amazon Transcribe Medical
Endpoints and Quotas
(https://docs.aws.amazon.com/general/latest/gr/transcribe-medical.html)
in the I<Amazon Web Services General Reference>

=back



=head2 LanguageCode => Str

The language code for the language spoken in the source audio file. US
English (en-US) is the only supported language for medical
transcriptions. Any other value you enter for language code results in
a C<BadRequestException> error.


=head2 Media => L<Paws::Transcribe::Media>




=head2 MediaFormat => Str

The format of the input media file.


=head2 MediaSampleRateHertz => Int

The sample rate, in Hertz, of the source audio containing medical
information.

If you don't specify the sample rate, Amazon Transcribe Medical
determines it for you. If you choose to specify the sample rate, it
must match the rate detected by Amazon Transcribe Medical. In most
cases, you should leave the C<MediaSampleHertz> blank and let Amazon
Transcribe Medical determine the sample rate.


=head2 MedicalTranscriptionJobName => Str

The name for a given medical transcription job.


=head2 Settings => L<Paws::Transcribe::MedicalTranscriptionSetting>

Object that contains object.


=head2 Specialty => Str

The medical specialty of any clinicians providing a dictation or having
a conversation. C<PRIMARYCARE> is the only available setting for this
object. This specialty enables you to generate transcriptions for the
following medical fields:

=over

=item *

Family Medicine

=back



=head2 StartTime => Str

A timestamp that shows when the job started processing.


=head2 Transcript => L<Paws::Transcribe::MedicalTranscript>

An object that contains the C<MedicalTranscript>. The
C<MedicalTranscript> contains the C<TranscriptFileUri>.


=head2 TranscriptionJobStatus => Str

The completion status of a medical transcription job.


=head2 Type => Str

The type of speech in the transcription job. C<CONVERSATION> is
generally used for patient-physician dialogues. C<DICTATION> is the
setting for physicians speaking their notes after seeing a patient. For
more information, see how-it-works-med



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transcribe>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

