How to start work with the project:

	eval `make setenv`

How to deploy project:

	cpanm -v -n --installdeps -L ./local DB-Hooks-0.01_07.tar.gz
	cpanm -v -n -L ./local DB-Hooks-0.01_07.tar.gz
	cpanm -L ./local Carton
	carton install --deployment

Create the new table/apply migration:

	Define table inside lib/Schema/Result/Table.pm
	Define helpers if required inside lib/Schema/ResultSet/Table.pm
	Increment $VERSION inside lib/Schema.pm
	make dbprepare
	make dbup

Create controllers for the new table:

	cat << EOF > lib/<Project>/Controller/<Table>.pm
	package <Project>::Controller::<Table>;
	use Mojo::Base '<Project>::Resource::OpenAPI3';
	1;
	EOF

Provide OpenAPI schema for the new table:

	script/<project> gen-schema Table
	copy corresponding sections PATHS, COMPONENT, RESPONSE into public/<project>/api-v1.yaml file

How to connect to database and run arbitrary SQL from file:

	make dbshell
	=> \i ./tmp.sql
	=> \? # Show help

How to run tests:

	make test
	prove t/example/*.t --shuffle      # Run tests in random order:
	prove t/example/*.t --state=last   # Run the same tests as the last time the state was saved
	prove --norc -Ilib -Ilocal/lib/perl5 -It/lib t/example/*.t

How to run individual test under debugger:

	perl -d -Ilib -Ilocal/lib/perl5 -It/lib t/example/db.t

Transactions inside program:

	my $atomic =  D::txn;
	# >>
	...
	# <<
	$atomic->commit;

	Or:
	D::db->txn_begin;
	...
	$result   or D::db->txn_rollback;
	D::db->txn_commit;

	The difference is that for the first case we can not explicitly rollback. And when the scope
	is finished a warning is issued that 'went out of scope without explicit commit'. This is a
	bit ambigious to see during tests. Thus we use explicit txn_begin/rollback in tests.
