# Generated by default/object.tt
package Paws::Honeycode::DelimitedTextImportOptions;
  use Moose;
  has DataCharacterEncoding => (is => 'ro', isa => 'Str', request_name => 'dataCharacterEncoding', traits => ['NameInRequest']);
  has Delimiter => (is => 'ro', isa => 'Str', request_name => 'delimiter', traits => ['NameInRequest'], required => 1);
  has HasHeaderRow => (is => 'ro', isa => 'Bool', request_name => 'hasHeaderRow', traits => ['NameInRequest']);
  has IgnoreEmptyRows => (is => 'ro', isa => 'Bool', request_name => 'ignoreEmptyRows', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Honeycode::DelimitedTextImportOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Honeycode::DelimitedTextImportOptions object:

  $service_obj->Method(Att1 => { DataCharacterEncoding => $value, ..., IgnoreEmptyRows => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Honeycode::DelimitedTextImportOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->DataCharacterEncoding

=head1 DESCRIPTION

An object that contains the options relating to parsing delimited text
as part of an import request.

=head1 ATTRIBUTES


=head2 DataCharacterEncoding => Str

The encoding of the data in the input file.


=head2 B<REQUIRED> Delimiter => Str

The delimiter to use for separating columns in a single row of the
input.


=head2 HasHeaderRow => Bool

Indicates whether the input file has a header row at the top containing
the column names.


=head2 IgnoreEmptyRows => Bool

A parameter to indicate whether empty rows should be ignored or be
included in the import.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Honeycode>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

