#!/usr/bin/perl

package eBay::API::XML::DataType::CrossPromotionPreferencesType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CrossPromotionPreferencesType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CrossPromotionPreferencesType

=head1 DESCRIPTION

Contains preferences describing how items similar to the one the user is
presently viewing are promoted.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CrossPromotionPreferencesType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::Enum::GallerySortFilterCodeType;
use eBay::API::XML::DataType::Enum::ItemFormatSortFilterCodeType;
use eBay::API::XML::DataType::Enum::ItemSortFilterCodeType;


my @gaProperties = ( [ 'CrossPromotionEnabled', 'xs:boolean', '', '', '' ]
	, [ 'CrossSellGallerySortFilter', 'ns:GallerySortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GallerySortFilterCodeType', '' ]
	, [ 'CrossSellItemFormatSortFilter', 'ns:ItemFormatSortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemFormatSortFilterCodeType', '' ]
	, [ 'CrossSellItemSortFilter', 'ns:ItemSortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSortFilterCodeType', '' ]
	, [ 'UpSellGallerySortFilter', 'ns:GallerySortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::GallerySortFilterCodeType', '' ]
	, [ 'UpSellItemFormatSortFilter', 'ns:ItemFormatSortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemFormatSortFilterCodeType', '' ]
	, [ 'UpSellItemSortFilter', 'ns:ItemSortFilterCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::ItemSortFilterCodeType', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCrossPromotionEnabled()

(For eBay store owners only)
Specifies whether cross-promotions are enabled for the seller's listings.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'xs:boolean'

=cut

sub setCrossPromotionEnabled {
  my $self = shift;
  $self->{'CrossPromotionEnabled'} = shift
}

=head2 isCrossPromotionEnabled()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'xs:boolean'

=cut

sub isCrossPromotionEnabled {
  my $self = shift;
  return $self->{'CrossPromotionEnabled'};
}


=head2 setCrossSellGallerySortFilter()

(For eBay store owners only) Specifies whether to display only items with
gallery images and whether they should precede other items in cross-sell
promotions.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:GallerySortFilterCodeType'

=cut

sub setCrossSellGallerySortFilter {
  my $self = shift;
  $self->{'CrossSellGallerySortFilter'} = shift
}

=head2 getCrossSellGallerySortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:GallerySortFilterCodeType'

=cut

sub getCrossSellGallerySortFilter {
  my $self = shift;
  return $self->{'CrossSellGallerySortFilter'};
}


=head2 setCrossSellItemFormatSortFilter()

(For eBay store owners only) Specifies which items should be shown
in cross-sell promotions (such as Buy It Now or Store Inventory items) and 
in which sequence.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:ItemFormatSortFilterCodeType'

=cut

sub setCrossSellItemFormatSortFilter {
  my $self = shift;
  $self->{'CrossSellItemFormatSortFilter'} = shift
}

=head2 getCrossSellItemFormatSortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:ItemFormatSortFilterCodeType'

=cut

sub getCrossSellItemFormatSortFilter {
  my $self = shift;
  return $self->{'CrossSellItemFormatSortFilter'};
}


=head2 setCrossSellItemSortFilter()

(For eBay store owners only) Specifies how to sort items displayed in 
a cross-sell promotion.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:ItemSortFilterCodeType'

=cut

sub setCrossSellItemSortFilter {
  my $self = shift;
  $self->{'CrossSellItemSortFilter'} = shift
}

=head2 getCrossSellItemSortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:ItemSortFilterCodeType'

=cut

sub getCrossSellItemSortFilter {
  my $self = shift;
  return $self->{'CrossSellItemSortFilter'};
}


=head2 setUpSellGallerySortFilter()

(For eBay store owners only) Specifies whether to display only items with
gallery images in upsell promotions and whether they should precede other items.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:GallerySortFilterCodeType'

=cut

sub setUpSellGallerySortFilter {
  my $self = shift;
  $self->{'UpSellGallerySortFilter'} = shift
}

=head2 getUpSellGallerySortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:GallerySortFilterCodeType'

=cut

sub getUpSellGallerySortFilter {
  my $self = shift;
  return $self->{'UpSellGallerySortFilter'};
}


=head2 setUpSellItemFormatSortFilter()

(For eBay store owners only) Specifies which items (such as Buy It Now or
Store Inventory items) should be shown in upsell promotions and in which
sequence.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:ItemFormatSortFilterCodeType'

=cut

sub setUpSellItemFormatSortFilter {
  my $self = shift;
  $self->{'UpSellItemFormatSortFilter'} = shift
}

=head2 getUpSellItemFormatSortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:ItemFormatSortFilterCodeType'

=cut

sub getUpSellItemFormatSortFilter {
  my $self = shift;
  return $self->{'UpSellItemFormatSortFilter'};
}


=head2 setUpSellItemSortFilter()

(For eBay store owners only) Specifies how to sort items used in an upsell promotion.

  Calls: SetUserPreferences
  RequiredInput: No

#    Argument: 'ns:ItemSortFilterCodeType'

=cut

sub setUpSellItemSortFilter {
  my $self = shift;
  $self->{'UpSellItemSortFilter'} = shift
}

=head2 getUpSellItemSortFilter()

  Calls: GetUserPreferences
  Returned: Conditionally

#    Returns: 'ns:ItemSortFilterCodeType'

=cut

sub getUpSellItemSortFilter {
  my $self = shift;
  return $self->{'UpSellItemSortFilter'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
