package DateTime::Event::NameDay::slovakia;

use DateTime;

sub nameday_data {
    
    # This site http://privatewww.essex.ac.uk/~kent/calisto/guide/changes.htm
    # has the reform dates as: 7-16 Jan 1584, 23 Jan-1 Feb 1584, 22-31 Oct 1587
    # we are going with 7-16 Jan 1584 since that is the same as the Czech and Austrian 
    # dates and Slovakia was part of the Austrian empire at the time
    return(DateTime->new( year => 1754, month => 1, day => 16), 
           <<"EOF;");
# From:       http://www.sl.sinet.sk/vtipy/mes01.htm
#             http://www.slovensko.com/slovakia.faq/edre/1
#             http://www.slovakian.info/cgi-bin/calendar.pl
# Country:    Slovakia
# ReformDate: 1753/02/28

1: # January
  1 *NovÃ½ rok, *De? vzniku SR # New Year's day, Independence day (1993)
  2 Alexandra
  3 Daniela
  4 Drahoslav
  5 Andrea
  6 AntÃ³nia, *Zjavenie PÃ¡na, *Traja KrÃ¡li # Epiphany
  7 Bohuslava
  8 SeverÃ­n
  9 Alexej
 10 Da\x{0161}a
 11 MalvÃ­na
 12 Ernest
 13 Rastislav
 14 Radovan
 15 Dobroslav
 16 KristÃ­na
 17 Nata\x{0161}a
 18 Bohdana
 19 DrahomÃ­ra
 20 Dalibor
 21 Vincent
 22 Zora
 23 Milo\x{0105}
 24 Timotej
 25 Gejza
 26 Tamara
 27 Bohu\x{0161}
 28 Alfonz
 29 Ga\x{0161}par
 30 Ema
 31 Emil

2: # February
  1 Tatiana
  2 Erik, Erika, *Hromnice
  3 Bla\x{017e}ej
  4 Veronika
  5 AgÃ¡ta
  6 Dorota
  7 Vanda
  8 Zoja
  9 Zdenko
 10 Gabriela
 11 Dezider
 12 Perla
 13 ArpÃ¡d
 14 ValentÃ­n
 15 Pravoslav
 16 Ida
 17 Miloslava
 18 JaromÃ­r
 19 Vlasta
 20 LÃ­via
 21 EleonÃ³ra
 22 Etela
 23 Roman, Romana
 24 Matej
 25 Frederik, Frederika
 26 Viktor
 27 Alexander
 28 Zlatica

3: # March
  1 AlbÃ­n
  2 Ane\x{017e}ka
  3 Bohumil, Bohumila
  4 KazimÃ­r
  5 Fridrich
  6 Radoslav
  7 TomÃ¡${scar}
  8 Alan, Alana
  9 Franti$scar}ka
 10 Branislav, Bruno
 11 Angela, Angelika
 12 Gregor
 13 Vlastimil
 14 Matilda
 15 Svetlana
 16 Boleslav
 17 \x{013D}ubica
 18 Eduard
 19 Jozef
 20 VÃ­\x{0165}azoslav
 21 Blahoslav
 22 Be\x{0148}adik
 23 AdriÃ¡n
 24 Gabriel
 25 MariÃ¡n
 26 Emanuel
 27 Alena
 28 So\x{0148}a, *Ve\x{013E}kÃ½ piatok
 29 Miroslav
 30 Vieroslava, *Ve\x{013E}kono\x{010D}nÃ¡ nede\x{013E}a
 31 BenjamÃ­n, *Ve\x{013E}kono\x{010D}nÃ½ pondelok

4: # April
  1 Hugo
  2 Zita
  3 Richard
  4 Izidor
  5 Miroslava
  6 Irena
  7 ZoltÃ¡n
  8 Albert
  9 Milena
 10 Igor
 11 JÃºlius
 12 Estera
 13 Ale\x{0161}
 14 JustÃ­na
 15 Fedor
 16 Dana, Danica
 17 Rudolf
 18 ValÃ©r
 19 Jela
 20 Marcel
 21 ErvÃ­n
 22 SlavomÃ­r
 23 Vojtech
 24 Juraj
 25 Marek
 26 Jaroslava
 27 Jaroslav
 28 Jarmila
 29 Lea
 30 AnastÃ¡zia

5: # May
  1 *Sviatok prÃ¡ce
  2 \x{017D}igmund
  3 Galina
  4 FloriÃ¡n
  5 Lesana, Lesia
  6 HermÃ­na
  7 Monika
  8 Ingrida
  9 Roland
 10 ViktÃ³ria
 11 Bla\x{017E}ena
 12 PankrÃ¡c
 13 ServÃ¡c
 14 BonifÃ¡c
 15 \x{017D}ofia
 16 SvetozÃ¡r
 17 Gizela
 18 Viola
 19 GertrÃºda
 20 Bernard
 21 Zina
 22 JÃºlia, JuliÃ¡na
 23 \x{017D}elmÃ­ra
 24 Ela
 25 Urban
 26 Du\x{0161}an
 27 Iveta
 28 Viliam
 29 Vilma
 30 Ferdinand
 31 Petronela, Petrana

6: # June
  1 Z\x{017D}aneta
  2 XÃ©nia
  3 KarolÃ­na
  4 Lenka
  5 Laura
  6 NÃ³rbert
  7 RÃ³bert
  8 Medard
  9 Stanislava
 10 MargarÃ©ta
 11 Dobroslava
 12 Zlatko
 13 Anton
 14 Vasil
 15 VÃ­t
 16 Blanka
 17 Adolf
 18 Vratislav
 19 AlfrÃ©d
 20 ValÃ©ria
 21 Alojz
 22 PaulÃ­na
 23 SidÃ³nia
 24 JÃ¡n
 25 TadeÃ¡\x{0161}, OlÃ­via
 26 AdriÃ¡na
 27 Ladislav, Ladislava
 28 BeÃ¡ta
 29 Pavol, Peter, Petra
 30 MelÃ¡nia

7: # July
  1 Diana
  2 Berta
  3 Miloslav
  4 Prokop
  5 Cyril, Metod, *Sviatok sv. Cyrila a sv.Metoda
  6 PatrÃ­cia, Patrik
  7 Oliver
  8 Ivan
  9 Lujza
 10 AmÃ¡lia
 11 Milota
 12 Nina
 13 Margita
 14 Kamil
 15 Henrich
 16 DrahomÃ­r
 17 Bohuslav
 18 Kamila
 19 Du\x{0161}ana
 20 I\x{013E}ja, EliÃ¡\x{0161}
 21 Daniel
 22 MagdalÃ©na
 23 O\x{013E}ga
 24 VladimÃ­r
 25 Jakub
 26 Anna, Hana
 27 Bo\x{017E}ena
 28 Kri\x{0161}tof
 29 Marta
 30 Libu\x{0161}a
 31 IgnÃ¡c

8: # August
  1 Bo\x{017E}idara
  2 GustÃ¡v
  3 Jergu\x{0161}
  4 Dominik, Dominika
  5 Hortenzia
  6 JozefÃ­na
  7 \x{0160}tefÃ¡nia
  8 OskÃ¡r
  9 \x{013D}ubomÃ­ra
 10 Vavrinec
 11 Zuzana
 12 Darina
 13 \x{013D}ubomÃ­r
 14 MojmÃ­r
 15 Marcela
 16 Leonard
 17 Milica
 18 Elena, Helena
 19 LÃ½dia
 20 Anabela
 21 Jana
 22 TichomÃ­r
 23 Filip
 24 Bartolomej
 25 \x{013D}udovÃ­t
 26 Samuel
 27 Silvia
 28 AugustÃ­n
 29 Nikola, *VÃ½ro\x{010D}ie SNP
 30 Ru\x{017E}ena
 31 Nora

9: # September
  1 Drahoslava, *De\x{0148} Ãstavy SR
  2 Linda
  3 Belo
  4 RozÃ¡lia
  5 RegÃ­na
  6 Alica
  7 Marianna
  8 Miriama
  9 Martina
 10 Oleg
 11 BystrÃ­k
 12 MÃ¡ria
 13 Ctibor
 14 \x{013D}udomil
 15 Jolana, *SedembolestnÃ¡ Panna MÃ¡ria
 16 \x{013D}udmila
 17 Olympia
 18 EugÃ©nia
 19 Kon\x{0161}tantÃ­n
 20 \x{013D}uboslav, \x{013D}uboslava
 21 MatÃº\x{0161}
 22 MÃ³ric
 23 Zdenka
 24 \x{013D}ubo\x{0161}
 25 \x{013D}ubor
 26 Edita
 27 CypriÃ¡n
 28 VÃ¡clav
 29 Michal, chaela
 30 JarolÃ­m

10: # October
  1 Arnold
  2 Levoslav
  3 Stela
  4 Franti\x{0161}ek
  5 Viera
  6 NatÃ¡lia
  7 Eli\x{0161}ka
  8 Brigita
  9 DionÃ½z
 10 SlavomÃ­ra
 11 ValentÃ­na
 12 MaximiliÃ¡n
 13 Koloman
 14 Boris
 15 TerÃ©zia
 16 VladimÃ­ra
 17 Hedviga
 18 LukÃ¡\x{0161}
 19 KristiÃ¡n
 20 VendelÃ­n
 21 Ur\x{0161}u\x{013E}a
 22 Sergej
 23 Alojzia
 24 Kvetoslava
 25 Aurel
 26 Demeter
 27 SabÃ­na
 28 Dobromila
 29 KlÃ¡ra
 30 \x{0160}imon, Simona
 31 AurÃ©lia

11: # November
  1 Denisa, Denis, *Sviatok v\x{0161}etkÃ½ch svÃ¤tÃ½ch
  2 *Pamiatka zosnulÃ½ch
  3 Hubert
  4 Karol
  5 Imrich
  6 RenÃ¡ta
  7 RenÃ©
  8 BohumÃ­r
  9 Teodor
 10 Tibor
 11 Martin, Maro\x{0161}
 12 SvÃ¤topluk
 13 Stanislav
 14 Irma
 15 Leopold
 16 Agnesa
 17 Klaudia
 18 Eugen
 19 Al\x{017E}beta
 20 FÃ©lix
 21 ElvÃ­ra
 22 CecÃ­lia
 23 Klement
 24 EmÃ­lia
 25 KatarÃ­na
 26 Kornel
 27 Milan
 28 Henrieta
 29 Vratko
 30 Ondrej, Andrej

12: # December
  1 Edmund
  2 BibiÃ¡na
  3 Oldrich
  4 Barbora
  5 Oto
  6 MikulÃ¡\x{0161}
  7 AmbrÃ³z
  8 MarÃ­na
  9 Izabela
 10 RadÃºz
 11 Hilda
 12 OtÃ­lia
 13 Lucia
 14 Branislava, Bronislava
 15 Ivica
 16 AlbÃ­na
 17 KornÃ©lia
 18 SlÃ¡vka, SlÃ¡va
 19 Judita
 20 Dagmara
 21 Bohdan
 22 Adela
 23 Nade\x{017E}da
 24 Adam, Eva, *\x{0160}tedrÃ½ de\x{0148}
 25 *1. sv. viano\x{010D}nÃ½
 26 \x{0160}tefan, *2. sv. viano\x{010D}nÃ½
 27 FilomÃ©na
 28 Ivana, Ivona
 29 Milada
 30 DÃ¡vid
 31 Silvester
EOF;
}

1;
