use strict;
use warnings;

use Test::More tests => 663;
use Crypt::PK::ECC;

my $data = [
  {CURVE=>'secp112r1',PRI_FILE=>'key_secp112r1-1.pri.pem',PUB_FILE=>'key_secp112r1-1.pub.pem',PRI=>'9c8c2a0cd14052e0a802e965ea77',PUB=>'0411f09ba3f913b142b38585d19fc48c928f2b6026bc15b98157f2fb9d',PUBC=>'0311f09ba3f913b142b38585d19fc4',ECDSA_SHA1=>'3020020e194733eb7aea5031db4cf273e84e020e12bef575d5a9a78391f421d7c607',ECDSA_SHA256=>'3021020f00a81637ea3744d65335e2870aefd6020e514a4b4c7d7b25b257276ab476f9'},
  {CURVE=>'secp112r2',PRI_FILE=>'key_secp112r2-1.pri.pem',PUB_FILE=>'key_secp112r2-1.pub.pem',PRI=>'2dad629912f1ef7acd7ff55a6072',PUB=>'047d8cb70beab422d22880c79fe117d0392c404dc974831c5f26c506a3',PUBC=>'037d8cb70beab422d22880c79fe117',ECDSA_SHA1=>'3020020e115b7759e0bc13dbbb77db756850020e09d74cc8e9d70f7def749bc59759',ECDSA_SHA256=>'3020020e10eb5ca8badd470e4794c1a108db020e02de4d6532d666f6f08b64e89b30'},
  {CURVE=>'secp128r1',PRI_FILE=>'key_secp128r1-1.pri.pem',PUB_FILE=>'key_secp128r1-1.pub.pem',PRI=>'5c5e30ef79639baa2ddd0e41637384ae',PUB=>'04dedf05d521119c98a0b91f081401ac7c3e359793e5ff70f2ee31324d263e9f61',PUBC=>'03dedf05d521119c98a0b91f081401ac7c',ECDSA_SHA1=>'3026021100d366e9dac9a3bc43576b38962c9afba9021100acffead8c8440c5b4c288a2869919b2f',ECDSA_SHA256=>'30250210674badb9584429bacf8ad1ff6819f4c1021100c2621e5cb97206474177d50b3d1c0145'},
  {CURVE=>'secp128r2',PRI_FILE=>'key_secp128r2-1.pri.pem',PUB_FILE=>'key_secp128r2-1.pub.pem',PRI=>'31739a3d53459d7df41e3134d8c3cf1b',PUB=>'042b294c16752327dd9be5311d70561fd1f0c75e6b6cb69fcc152670777eec89ab',PUBC=>'032b294c16752327dd9be5311d70561fd1',ECDSA_SHA1=>'302402102697263886c57d8de361afec554f29e7021011d091dab40603a4e7d8dffbcdc1ed0f',ECDSA_SHA256=>'302402101e3dd1147131625b9ad5bbf114d1bc0d02103d82b9a394054844e9d353565c50ff99'},
  {CURVE=>'secp160k1',PRI_FILE=>'key_secp160k1-1.pri.pem',PUB_FILE=>'key_secp160k1-1.pub.pem',PRI=>'14b70aec3aa250e66c5eedbf4363a27b4b27231f',PUB=>'048d448a89c0290d646b4e0a4592c0eafe51bfae0174462140df8839784b02683088f3eae3dbd77ccb',PUBC=>'038d448a89c0290d646b4e0a4592c0eafe51bfae01',ECDSA_SHA1=>'302e021500ed2e2adac4a5145a6408211c1d47d98ffd6c5b89021500a6ebc3897cf5163bd3f842b50d7facb307fc0f3d',ECDSA_SHA256=>'302d021500bd3ed4ceca917b49ac2faec87a91378a81e6172c02146017099013c0adb4bceb08b8e6cbcfdbb494b6b6'},
  {CURVE=>'secp160r1',PRI_FILE=>'key_secp160r1-1.pri.pem',PUB_FILE=>'key_secp160r1-1.pub.pem',PRI=>'4f3ff1d85f36dda2930ce4fd6e50fbe66830042d',PUB=>'04a497c25340df2b80aef1e26ed45ea179dd5f6f52d017a07f00b5a40ac2c76bb2aaec555d4bc08a1f',PUBC=>'03a497c25340df2b80aef1e26ed45ea179dd5f6f52',ECDSA_SHA1=>'302c021453e1ba4695646e93ac5db45933d59c4a2b64d3f902142a383226907d5952af829765645d5ae34a15ab5f',ECDSA_SHA256=>'302d021500a559a68611e26d4acfe0eaa59e9e4956ad080b9902147730150c0a79f7500f23953bdc84577111d9f4bf'},
  {CURVE=>'secp160r2',PRI_FILE=>'key_secp160r2-1.pri.pem',PUB_FILE=>'key_secp160r2-1.pub.pem',PRI=>'999e25723cd7baf003b110e1d3e719396b0486e3',PUB=>'04fed95dd2b94579147d09c7cf1fff0a2156fad1b48e6dd96ca660ef55097589f4d75dbcae1553c9a1',PUBC=>'03fed95dd2b94579147d09c7cf1fff0a2156fad1b4',ECDSA_SHA1=>'302d021500f58ff53a28bd1e41bed2b214aeb2672852276f4c02141d088051ad977dcaa44a68994ff35ac447cc4848',ECDSA_SHA256=>'302c021478385546c27950308485c44a5ed2b3cabfd4d65602144fe588beecb3f1a42a3eefa1d74b9382fa066f96'},
  {CURVE=>'secp192k1',PRI_FILE=>'key_secp192k1-1.pri.pem',PUB_FILE=>'key_secp192k1-1.pub.pem',PRI=>'a98043d5c9cff228846613d2557d83747249666420f66a28',PUB=>'04581e261bb2fce5f6c5306cf5b5952a548c72e591baf73d8621569c4311490499db5b6e2969bd5965aad628f99c996183',PUBC=>'03581e261bb2fce5f6c5306cf5b5952a548c72e591baf73d86',ECDSA_SHA1=>'3035021900d36a2d3a3702f954b4364aad125bf710f5f772cc2d06da200218389da6af997dfedb713858e4d415aedfc0235d59453a3a5e',ECDSA_SHA256=>'3036021900f3a48ae6f34dc434e7605ddd2edc3363116a076bafbbefc0021900f08e144406402eed1297d309e40caa7107f8ec2e0e7e8b75'},
  {CURVE=>'secp224k1',PRI_FILE=>'key_secp224k1-1.pri.pem',PUB_FILE=>'key_secp224k1-1.pub.pem',PRI=>'230e41b86eec5b958d5f2959bc4b392aa27fa3f7e3fdf9915db47da7',PUB=>'046adc2b376d687aabb7b05bb00bbe03822f32711512e054510ee89be429eb839d41fa5ad6a6f70f274850d477e1049e08c9e6098d2d1208a7',PUBC=>'036adc2b376d687aabb7b05bb00bbe03822f32711512e054510ee89be4',ECDSA_SHA1=>'303d021c1f58bfc8684e3f333433cd0fa3c66892c06727ddd8b1a4913f2b152d021d00d518957f96b59789f8ecf3e3b963d2aa3466152571775e93462c10ea',ECDSA_SHA256=>'303c021c74a28d855453e3a8c93cf520e367e12659d254d64c2248fb3060d02a021c03340c2b4d88018ad203f01f6f6ff072d22a653d7379b139ca5b86c3'},
  {CURVE=>'secp224r1',PRI_FILE=>'key_secp224r1-1.pri.pem',PUB_FILE=>'key_secp224r1-1.pub.pem',PRI=>'fe892ab148f432be15645766bc969487197bc84dd92e4e2ef00c1a86',PUB=>'0467ebe5a5aef2c7cf7752970ccca9c6bb29f5420dff40d003dbf3e5d57f910b1174d0b9507107c55c4e9b386b0358a07b24c49ee219b3a52f',PUBC=>'0367ebe5a5aef2c7cf7752970ccca9c6bb29f5420dff40d003dbf3e5d5',ECDSA_SHA1=>'303e021d00bb0d2991ed5c73c0b61685a6e81b578c31a3d72bb4ede6d8d0534d74021d00f24f418c3105ee6299dd6de2f3f866c9e71213c5a144c40440fdb3c9',ECDSA_SHA256=>'303e021d008467a633a2682253bd99285e40040cf7b0c7f528f1418aeade8318fe021d00dbd009aba53c06fc09293caf1a4ac0dc6dc38dc2c126c2ef306f67e7'},
  {CURVE=>'secp256k1',PRI_FILE=>'key_secp256k1-1.pri.pem',PUB_FILE=>'key_secp256k1-1.pub.pem',PRI=>'4b03aa0b55fb2911a54a708d900a95ada33fd76306f03268fa388b63d0aefb43',PUB=>'0422af1a552f83cccce76d197c55d3c7d8ad8cb68dc3042c227984211b0a78aa7f153768dc1fd47239ba4fccb73e3c2d1285560eb809a2a84a12371c2915d59af9',PUBC=>'0322af1a552f83cccce76d197c55d3c7d8ad8cb68dc3042c227984211b0a78aa7f',ECDSA_SHA1=>'3045022100de6548db95f7c10e6dfd3241dbef8f0b5fb350932c0a2f209f4aab95aaddf08e022006caa0150bd1c1355574e3164c2a1287e8e77d7bd1b272f4d286f40f281004e3',ECDSA_SHA256=>'3044022060595de7d992adb52f68e1b6a5aa4fed88d8e31f73a4aafce3345997b7d72f560220408e8d7f9d5f7111cab83853a5f5e3667bd20c0a707d53f02c5b36052b750549'},
  {CURVE=>'secp384r1',PRI_FILE=>'key_secp384r1-1.pri.pem',PUB_FILE=>'key_secp384r1-1.pub.pem',PRI=>'2705f8a76c216172157b6187a466852a8127e7670188448444452ae2e3404155fcfdcdfbd014753ae9e5156b1b57db69',PUB=>'04cd738a8ebc08734a0fcfaf68b9123075a05d0c4b2a387da1c8ca378402abac23a87fd5c4fdffab91127bc61fbc8d69f57ca9e3aafed7698ce75b9116235e749d7b6f29c91d2123112289426dbe174f42022924ed9752e94d5037ceddd007473c',PUBC=>'02cd738a8ebc08734a0fcfaf68b9123075a05d0c4b2a387da1c8ca378402abac23a87fd5c4fdffab91127bc61fbc8d69f5',ECDSA_SHA1=>'306602310092acb263c179af269bdea79361a1a6b71ac53a5496fb3a04955493882725b5210c9c2f59ba315f53e61c254986b1f844023100d9872b751d26660ae5dc43161b6f6527b254cf1fc2e59a07ed76b39d7698f06d40abcec14848dab97362cbf475184268',ECDSA_SHA256=>'30650231009eb92d03cf786e936c0dbe0d710d2b55e92415b4133ee9272acb1af4529b53bfa573f5c6683b9a89072c34c2a7fc98650230062d798914ee0fba4bebe73f6efdf694299aafac7680744187f3f9bfcbcfd56790b9cbcf7b0fb8a9968bebf2ac6970a7'},
  {CURVE=>'secp521r1',PRI_FILE=>'key_secp521r1-1.pri.pem',PUB_FILE=>'key_secp521r1-1.pub.pem',PRI=>'013cc69064c1be4f387df1cbb9481e6182ef91c2db8b099ade5ac1241e634d8bd419f5766131b00bbc0c8b136cdbc01658cdbfefbf08ddb78030fdfe3b877c61ca0f',PUB=>'04006d71a3ba5519119aa9352a156ce8a55fe5f9c2a8380697132619802581e597cf7c05a363d0a0fdee4e4a2296350090cef05f6ee6fb3ad1d8d300108ddcd7d13410014599a7509db9ca78804c8ee96a36101020649ae13b3890f35a72a05229c4247fbfea322cdb939617aee52fe491f911ac11dca100e105d6b7b9043384b33100077b',PUBC=>'03006d71a3ba5519119aa9352a156ce8a55fe5f9c2a8380697132619802581e597cf7c05a363d0a0fdee4e4a2296350090cef05f6ee6fb3ad1d8d300108ddcd7d13410',ECDSA_SHA1=>'308187024133ac3eb5173908318f71aab17f39f3a9a608e9b8117b7896f76a875e671fbfc386f2de6b288f4314b41f1d97a1fcd43e380226d0908af28dfd7b0cad33ba689d20024201aa82692b8ab235faf3f0a801d25dd226d1e4ca06913415d9194ac457e5a6ed114725caa490fdba9d8b9e05513978dc29f5c6b59fe26e3019e9b3fe09d66b7d7517',ECDSA_SHA256=>'308188024201216ee0ed86caad32a443c592e64bd573f71f42d89cd41bdab291554331af9cf62f3619913fa1e3954d565f2bfbe8020f4ede97ea67f3915bf9984013cfbb83a159024200a59d3ffa95564849ec9b1382aef9165f9dbc473bc6ef41cdaaa5c2beda03e863ec298e84c16a25fc034d3975e0b91c2f882478ab0d4892ee70d4390d923852ddee'},
  {CURVE=>'prime192v1',PRI_FILE=>'key_prime192v1-1.pri.pem',PUB_FILE=>'key_prime192v1-1.pub.pem',PRI=>'bcadb48540afbf1f994030949e8bf180e58f4f82f23e337f',PUB=>'04dc06d31d9ccc7e0d453727f870c2ef8ff751c04a1c225d729d16255ae82522536cdd979cec71c7af8ddbdbe8073bd18f',PUBC=>'03dc06d31d9ccc7e0d453727f870c2ef8ff751c04a1c225d72',ECDSA_SHA1=>'3035021862ab2dbb184e1bab8e4286fc53cd0e7d556e11dccd7f4f28021900dcfe136e14be8993c87aadf4b21225a0c1664bc71fad1916',ECDSA_SHA256=>'3034021873d9d19eb128b21bab27292f83f1c7a1afccbae9ddfc2c1d0218296f9823316f98449293c3fdde89f328fd49d4a5e92d9c25'},
  {CURVE=>'prime192v2',PRI_FILE=>'key_prime192v2-1.pri.pem',PUB_FILE=>'key_prime192v2-1.pub.pem',PRI=>'e76be718c514a9bc3a293b1a5058a16ec61023e596118aad',PUB=>'047450c16d9975711cf80dc60743427321e3d218be9e59b1d546bbc49500904c8e19740611ff85670c163646e19c81943b',PUBC=>'037450c16d9975711cf80dc60743427321e3d218be9e59b1d5',ECDSA_SHA1=>'3035021818d6f73595b8e384a7149dc85296c8666f8d2474b8dbc436021900e9e2781a2c78747ef03c7ee91eee5017dd88b0a088a4cdd1',ECDSA_SHA256=>'3036021900a868c241a3b265b1a5f14a1159e65b2d7674d614a1261fb2021900f25c9af9b2a30188f5899e8af96a28d9fbc1d4424566f734'},
  {CURVE=>'prime192v3',PRI_FILE=>'key_prime192v3-1.pri.pem',PUB_FILE=>'key_prime192v3-1.pub.pem',PRI=>'648e23d8d716b1df186359698827d52cc708c17f0a8b2a43',PUB=>'0428986b5a7a2b25f8f6ed245e1ceb5c7ab9809f666678a31f50f7ea09b7ddea56af39317425ba1ec600f06d2497dad527',PUBC=>'0328986b5a7a2b25f8f6ed245e1ceb5c7ab9809f666678a31f',ECDSA_SHA1=>'3036021900caf7c9f8015999e1b8c412f5740f12eb5f43a1c1f69f56550219009de8beb76045131000a8049abbea025cc6c2e8767c0adfca',ECDSA_SHA256=>'30340218364fd7612789f6ef38a431d7a68a16fe3b4ea5d6f231fe9e0218360da0b99234285196a18d707e8721b641239ac41195716e'},
  {CURVE=>'prime239v1',PRI_FILE=>'key_prime239v1-1.pri.pem',PUB_FILE=>'key_prime239v1-1.pub.pem',PRI=>'3a8dc3010097c31c7badfb2bf9d609ec697f1811f2d744ad0557984fe8b9',PUB=>'046d4c619ce0f8550c1c480740f9e441ccaddc67a3a3b4d5585e11c8882d2e36df87f6b2f964c4def52105234eac2e3ff9753c4f8e6da5e331a68a2409',PUBC=>'036d4c619ce0f8550c1c480740f9e441ccaddc67a3a3b4d5585e11c8882d2e',ECDSA_SHA1=>'3040021e323f05efea814b067583c06ae373c7285293ccfabb4ce2e57ec14d66a677021e1f1defc99fecc9d684f3a388dee309311af73a1ec3f156bb6e3584f5def4',ECDSA_SHA256=>'3040021e6b9d25707ffdc1f80fda1e698a72cb2229591a4031bcb88719ab9321a65e021e2f72ac85bb20053173dc35338bf3a18aac47b3fd7a152154e2d77d3b945a'},
  {CURVE=>'prime239v2',PRI_FILE=>'key_prime239v2-1.pri.pem',PUB_FILE=>'key_prime239v2-1.pub.pem',PRI=>'56d2b5b6929413702756f0eab763ed439dac7ff458298d9b2e4017fc9909',PUB=>'040c545af1fa000b4ae404e915efa2ae4e66f5f00c493f00f06d1449038657760786628e9d1b0be3d184caa45c53c9b2e9c940709409ef531e01d6f8a4',PUBC=>'020c545af1fa000b4ae404e915efa2ae4e66f5f00c493f00f06d1449038657',ECDSA_SHA1=>'3040021e63d489be144e5bf005179b4c72e82d9a5fcb91dddab247ee2829685cf075021e0c2bf212b80c86bd7e5d3224694ee968519e8bab17b18615b5dc41cd02d1',ECDSA_SHA256=>'3040021e58400e9b4b36380d8b053c7ea7a301dddf5fa5ce4fbdc3d8122ef7c3ebc6021e2f009f726bd9809e7ef9f9a3d89571c044143e19e5c1214d27a409ed346c'},
  {CURVE=>'prime239v3',PRI_FILE=>'key_prime239v3-1.pri.pem',PUB_FILE=>'key_prime239v3-1.pub.pem',PRI=>'33810cfd9a7332f57c4a3c10269df7ef04313e101da1de843ebf10c5db45',PUB=>'0445ea95ec167f4f059915bc6edf8801315ad057ff4121729345ce1b5c60e208960be1c5ceeb08d7ad23cdc5dbe4d2a890df710ec845d0966a36dcdec6',PUBC=>'0245ea95ec167f4f059915bc6edf8801315ad057ff4121729345ce1b5c60e2',ECDSA_SHA1=>'3040021e12b35c822cbf04bd254f8e65437514987427ef1be09c092ebaac80020af2021e2507686d483701f43859c8e8d15523d85d5717b7b144a16b930feadf2e19',ECDSA_SHA256=>'3040021e29db586a8c429a3a13c914b6e424ed3261c19d05736d4bf131825de73dcd021e655362728f9d039c62f07a09e5817b48e59794fa5be03ecec3567cba3905'},
  {CURVE=>'prime256v1',PRI_FILE=>'key_prime256v1-1.pri.pem',PUB_FILE=>'key_prime256v1-1.pub.pem',PRI=>'be1a6a95799d80c63e671c1c7df3c55ab17398acb4a1e86048a902d2a0177359',PUB=>'04c513e40a8a1acbb660e56aceb0c814a9e73750059c2ffc355c0117143d02e9557672ae5fe192f5ab270eab920daeba57b1281da53bfcba91070c894082d745d3',PUBC=>'03c513e40a8a1acbb660e56aceb0c814a9e73750059c2ffc355c0117143d02e955',ECDSA_SHA1=>'3046022100b5d61020541bdc9fb4f45edcc51d7d3e1398b394ada7ed94b227733b552442ce022100d76b73bd24d71b75cf4ecd11f9840c901d9e30b5a4a56bae7040a541d5c31082',ECDSA_SHA256=>'3043022037b324cba8f288a9c6befa49065dce22a6e60c28b04d7ed4cdca986033509b78021f44225fe81e5a4f6ac78b2b56c7187b8b31837ad30add379c780b125e3ff533'},
  {CURVE=>'secp112r1',PRI_FILE=>'key_secp112r1-2.pri.pem',PUB_FILE=>'key_secp112r1-2.pub.pem',PRI=>'8e5fbe3aebddc8a13f4d438cd170',PUB=>'045bfd38feda320a73e8bfcd804d3351272055e00eb139c6d5635c784e',PUBC=>'025bfd38feda320a73e8bfcd804d33',ECDSA_SHA1=>'3020020e62608296f33ecbe6ab204c5363dc020e289acb64e5f41fc11dea1295dfe3',ECDSA_SHA256=>'3022020f00902b45f5c263486633ac52e6f651020f00b8aa90c885a11ca76843db7d8937'},
  {CURVE=>'secp112r2',PRI_FILE=>'key_secp112r2-2.pri.pem',PUB_FILE=>'key_secp112r2-2.pub.pem',PRI=>'094a8840454dd75a9633026622ca',PUB=>'04147cfe973288ff633c7a57228fc179d08a91ba4703304f63b1a16d51',PUBC=>'03147cfe973288ff633c7a57228fc1',ECDSA_SHA1=>'3020020e135c91a6b875e35fab2ff1916f45020e05d85149bd8a5fc007091cc31ea9',ECDSA_SHA256=>'3020020e0f4f6ff485ffbc027c84d4793597020e037e1dfec72c665384c77ca8ebb9'},
  {CURVE=>'secp128r1',PRI_FILE=>'key_secp128r1-2.pri.pem',PUB_FILE=>'key_secp128r1-2.pub.pem',PRI=>'d8108a2ba9817e63aa251a1c7e6b5f08',PUB=>'04c1bce4bd65cdb84c67a15f5a46445a68ae5d2dd02477ce42c2a0da5a80b94be9',PUBC=>'03c1bce4bd65cdb84c67a15f5a46445a68',ECDSA_SHA1=>'302502102693e1ee12b6575e6bcaa80ed3ef8d98021100bcbb082a9be6040e32c79cc64a50d5e8',ECDSA_SHA256=>'302502103c1a1e95c3ef7c8a8fac8c111f5e293b021100dba18950be1f5bed4a554cc0dfdf79c8'},
  {CURVE=>'secp128r2',PRI_FILE=>'key_secp128r2-2.pri.pem',PUB_FILE=>'key_secp128r2-2.pub.pem',PRI=>'3ff23cebb55a74409042e2a9eb750d57',PUB=>'04cb2d66b60721e0f0d97b7c98af40247e54ec27097f08468a820eb9849aec2d3b',PUBC=>'03cb2d66b60721e0f0d97b7c98af40247e',ECDSA_SHA1=>'30240210296e7edd2551b28086d0870778d9690402101b3fdb29f6619c1545b97dcb4d861d61',ECDSA_SHA256=>'302402101cbf75997ef81010142794150cc19c5b021037504f952172552593ab384c8e1f36f6'},
  {CURVE=>'secp160k1',PRI_FILE=>'key_secp160k1-2.pri.pem',PUB_FILE=>'key_secp160k1-2.pub.pem',PRI=>'f337ddafec2746fe7dc9da27447eb341df179d6a',PUB=>'045678d69216c722bc84753a0216a71316fcac81b3e2f074eb9269dcd09351ade008faea4c66e62d92',PUBC=>'025678d69216c722bc84753a0216a71316fcac81b3',ECDSA_SHA1=>'302e021500968ed51e956e8c7099d43188da98ac2cd7859520021500c91dece0f7e8dd3c5f303c9a7d3d17f025963a3a',ECDSA_SHA256=>'302d0214094116423bb12bb3b9ffa3f4abaf8de7f47055a102150094b9baf8434c6cb49a6125a634b0a9e8f2cfeabb'},
  {CURVE=>'secp160r1',PRI_FILE=>'key_secp160r1-2.pri.pem',PUB_FILE=>'key_secp160r1-2.pub.pem',PRI=>'3d6ebb5fde1043333948b72ed440726160bbb13c',PUB=>'04a7b54fb28c8275d9667adbe63e4dfe84b387e9eea16d67505274d51ac808d4b436c93e9aeb02956d',PUBC=>'03a7b54fb28c8275d9667adbe63e4dfe84b387e9ee',ECDSA_SHA1=>'302c02145d57a2bbcf49841f80562285aad853d171a71c5f0214530e8338ba0754531f9c1a46df5c8a555beed5e4',ECDSA_SHA256=>'302e021500a6972031ba74c43385072d42b090730982b69129021500a11478df762c506c3832f42b26815d9f88e4dda4'},
  {CURVE=>'secp160r2',PRI_FILE=>'key_secp160r2-2.pri.pem',PUB_FILE=>'key_secp160r2-2.pub.pem',PRI=>'6e21d1f56b4aa5a4acc70cf872668cb2f3e67d8c',PUB=>'04c39963ee5bc371c9c1fdbbae426517ddcbb42e362891dd49d52582a6e56b3572e87717fd1f80d4f5',PUBC=>'03c39963ee5bc371c9c1fdbbae426517ddcbb42e36',ECDSA_SHA1=>'302e0215009fcad076515550c9c0cdf7e22889d955279c3bca021500892a8436a33a99d5e36dcb38bb2a659ba92a2ee6',ECDSA_SHA256=>'302d021500fedf83d3d70c02c9e2f7fcf72b99c7855ecb8dfc02143ffe07b330c2a8a36a62156bf1a940b342f514cf'},
  {CURVE=>'secp192k1',PRI_FILE=>'key_secp192k1-2.pri.pem',PUB_FILE=>'key_secp192k1-2.pub.pem',PRI=>'bb4412db119fab036e42eb8028ce4552188e5fd12cab1bc5',PUB=>'04f3ecb98a3c0c5715a5425a08e99b092caf166a457da770d2d56111a007faf45c6ec5f38849b94f5011b90151ada2df78',PUBC=>'02f3ecb98a3c0c5715a5425a08e99b092caf166a457da770d2',ECDSA_SHA1=>'303502182a806106c98d2e3131f4eedd35fae93421b4ea3362e56511021900c501bdedae0c3e2fc1bfc74727b17a1d8e8234ce5e8c0551',ECDSA_SHA256=>'3034021823f499904af5aa3cacf41b559202a89510bf4238399af7d1021854a24fe0050e810d4b12313e341c74d0c67b85997ab81abd'},
  {CURVE=>'secp224k1',PRI_FILE=>'key_secp224k1-2.pri.pem',PUB_FILE=>'key_secp224k1-2.pub.pem',PRI=>'504e3418a6f2bec9b61b82818cfae14360e9c523224b010976494ae4',PUB=>'04a2c7ad145b9323d9cbbdb0989d1294338ae89808f805666ef09913282c47712e7a8ff702bfbfafc624d07e84d34d52ab4f5a025224bf7e53',PUBC=>'03a2c7ad145b9323d9cbbdb0989d1294338ae89808f805666ef0991328',ECDSA_SHA1=>'303d021d00a5c69f06a247cd5155e62244f9cb0b01645ed1872b86e977433ccb35021c1c7b36e14f36764906d64d78305cd131bce4ca4f576fbd55120bfcd5',ECDSA_SHA256=>'303d021d00eb13832d8736ba2305d8d52621ea3be465d56286f8d93f54d8b07388021c1a34e39ceb48e7caaf4b4554127ac5ca56361d5cb22e139c34f70f4a'},
  {CURVE=>'secp224r1',PRI_FILE=>'key_secp224r1-2.pri.pem',PUB_FILE=>'key_secp224r1-2.pub.pem',PRI=>'5f037dbc728b0c912f33f79748ad9e13c531aabfb1a6f36c52871de3',PUB=>'04ed81d7d9b0185ad27a09c231e97253983af2435019cb5d20bf838e9ea78f4153eba00627a93dcbf26d16b765e43899f22416a0e9fb210fe0',PUBC=>'02ed81d7d9b0185ad27a09c231e97253983af2435019cb5d20bf838e9e',ECDSA_SHA1=>'303d021d00da725b75f0798ab2b35c981f539bf32e0be4b630094b0f602d246b3e021c419900df5a076f7eedfbb4fb6db996f9284ec3cfae2b563eeff24900',ECDSA_SHA256=>'303d021d00f1b6b3505010b9f9f285dd5304a593e217114644ffe789b71e16542d021c7f33a2703e633885738844c164189eefcb6fdfc41244efcd600cf425'},
  {CURVE=>'secp256k1',PRI_FILE=>'key_secp256k1-2.pri.pem',PUB_FILE=>'key_secp256k1-2.pub.pem',PRI=>'91d44bd72c399f23f1423c750eec025e007d1d9fbb372a4a0cf5813a35a1ba42',PUB=>'04d5f31fd4a14bf567d93b1f9b1e17b1c10ab53127dfdcede6eaf4915f0f0f675e7f26378ad406fd4f9499c1453c655262733c26c0e7df31b6f414734e04c72c02',PUBC=>'02d5f31fd4a14bf567d93b1f9b1e17b1c10ab53127dfdcede6eaf4915f0f0f675e',ECDSA_SHA1=>'3046022100abd606d9332a56e50e7312c7f62575267966fb5d61feea9564c136222282eddf022100b415ee5c718bbec1db767e24f47427fe6d4fa778637fbc2af053ecf64e78a6d9',ECDSA_SHA256=>'30440220495590030cb410f2b15f25fb6508866b94c32fba01a08527d119468db80d0c9202204074b2f994b345742e55c52f5edc5543e97e975fad73934dae9fb5f42ba0a91a'},
  {CURVE=>'secp384r1',PRI_FILE=>'key_secp384r1-2.pri.pem',PUB_FILE=>'key_secp384r1-2.pub.pem',PRI=>'56973b2fca72e7edf50efda16a3ed1191b9b04a8701849965afbef82639b3fc533af184e35097efc2947f34075963652',PUB=>'04e7175772defa198cf0fbbdf2fe4658551678d6b982c2a5e9a5c07652f5534dd5be12fbbfab701fbde3fc140d3f666f2b39f9a93f136c8c8b6857a70126e97cc893d6831c2f7a4356b2dd896fb9864d436989b4618191b14b4579a8961c3801fd',PUBC=>'03e7175772defa198cf0fbbdf2fe4658551678d6b982c2a5e9a5c07652f5534dd5be12fbbfab701fbde3fc140d3f666f2b',ECDSA_SHA1=>'3064023017f1d5e1987978315138ec211f10a93a9272d9ccdf5b40d25576e7256964af43f40b47d02b7f88a573241e46f88275af02305ce504f4c18601dda24f0b4fbc68d1f4ee28b09524882c37babea5c6091164642dcba21b8f7cb0f6f7ed63ebbea641f4',ECDSA_SHA256=>'3065023100f3571b35f8d5a37ff773bd48f1f366c5680b9331765078fa642f4a0e07fa6e60b7581b7175372092a914d7bbd4ff825a02305d42ac2c0e596900685d2d7a900d626cbd26128f8b8d225d2c2222214f9b2d98dcf12439f87bf647aeeaf1d991fc8269'},
  {CURVE=>'secp521r1',PRI_FILE=>'key_secp521r1-2.pri.pem',PUB_FILE=>'key_secp521r1-2.pub.pem',PRI=>'0175ba2b79d6fd589da82df79c5d05fafd80e25ba28e0735d3563ea5eb2cba0be36799ea4b5db067cecd8129456d552d556049d404afbb3f1a07fdb7e77b22716c47',PUB=>'0401f0761f84de1a2a48986fff480f0186ae2c2283b429c2c9c89e124138bd580a9414a4438036d80d40156a14ecec290cd4321075dfb7a130c85e8a5f1a9f025245730152eea2a0bf7ce57a1374f6f5b3be85d42619654bd341c3b54834ece5f09e28e4b4f200059c8d305fb5bac6353d4abc4ce8b599d64c457154cc2d382ce958fa8f5e',PUBC=>'0201f0761f84de1a2a48986fff480f0186ae2c2283b429c2c9c89e124138bd580a9414a4438036d80d40156a14ecec290cd4321075dfb7a130c85e8a5f1a9f02524573',ECDSA_SHA1=>'30818702416065101e06016a4b6a9c33939a60a135029d75bbe63632dd211de90e612c8b6c70eb82fb3e3ff93a3f7bf99833f3d2ce1a09386219031524475998105e076804db024200875bafb63e370157cc05f01a5aeeb20e123c7f030ef603119341bd85d1faf10993bc96e3c23f10c284834acc38b288a72b886539774b71aa231697eadf761d0206',ECDSA_SHA256=>'3081880242019a8a0d0f32c72209e918ab6c64049a397127f40957321c051ed2865d9f103d271dc1a3489887fb4f7b6089d91cc2797b05c45795a92876d9639ee7c8a9ae6006db0242016f9fd8f5d799a6085b42aa8c7ff131afdbc12d017b5563384f9c83bffefcba72c38a151cadb337d9ea35bbbba9082ae0e3eebec6570eaed7d25268a12e607f6033'},
  {CURVE=>'prime192v1',PRI_FILE=>'key_prime192v1-2.pri.pem',PUB_FILE=>'key_prime192v1-2.pub.pem',PRI=>'71ac6f0ae6aa7fe4c12073291e4a26242f7877732ea7ae42',PUB=>'04be75fe89acac6396e72fd9488f036a0f45574f0d5a528a9e1f3485f4477d328f082331fc529f26918510cacac28b6980',PUBC=>'02be75fe89acac6396e72fd9488f036a0f45574f0d5a528a9e',ECDSA_SHA1=>'3034021866a002530fb1feaf300e06a45d7c034e8fffc21b77594893021801c8b0a27cb0e901d151cae47c0c99df9560118a2565a814',ECDSA_SHA256=>'3035021900eac516c8c76282a6adaf7013e4984b04a6e4bea8b3fdba2f02180d76b408f2dd457015b923a7580c10655f855e9b36dc61f4'},
  {CURVE=>'prime192v2',PRI_FILE=>'key_prime192v2-2.pri.pem',PUB_FILE=>'key_prime192v2-2.pub.pem',PRI=>'bc6532fb8adc6fa22da85e99d49024769c7c0c56869e238f',PUB=>'04acc0985af3bf8e31f0af0b3838ef7a0c626657c9b5ca3e436aa8dec02391bb465099ab50bc89f193d5759f8b4f242685',PUBC=>'03acc0985af3bf8e31f0af0b3838ef7a0c626657c9b5ca3e43',ECDSA_SHA1=>'3036021900809a8999cabd8cd4112524fff6fbb6daf8f459e91fbfd693021900f5608819d4cba9d5e574e65265d61a19649bea696838c148',ECDSA_SHA256=>'303502190084a289c87df7219ae5c0bd5a3cb6a622eeda328468ed76a3021816c5701f707db1c263670d670bbba401ca278aa93c3e536b'},
  {CURVE=>'prime192v3',PRI_FILE=>'key_prime192v3-2.pri.pem',PUB_FILE=>'key_prime192v3-2.pub.pem',PRI=>'8494aebbe0d99d40240ddb354e3b7a52ade08cc692e3fd06',PUB=>'040ad7d2cff956a360c9cd80486f6cc6da080eb6bba14f637cc21db492d38007fc894f685edaf2d6d8361a376e0b359c74',PUBC=>'020ad7d2cff956a360c9cd80486f6cc6da080eb6bba14f637c',ECDSA_SHA1=>'3036021900bc3384edd8302ac6c3535fcdce339952aa37e2dad1b2ae78021900d5b0a106b65c384185147f5a13b172426dc30d3f84e7e4af',ECDSA_SHA256=>'30360219008e507ad0476d149bad832f1b06301e90ae881838a83fd392021900b9986def1c09c5a35bb0f922658891dd13719ae0844c3105'},
  {CURVE=>'prime239v1',PRI_FILE=>'key_prime239v1-2.pri.pem',PUB_FILE=>'key_prime239v1-2.pub.pem',PRI=>'5193b61d599160d1272ecfe4f7a5ad010dbe3b77a15c56bedcc1232bc7bc',PUB=>'0473003b786b391df8bfee506d3c8ef06ba6abe797dfbd83d56c1c77fa4fa35bcb925515f3b443d85993fc40f71e82ce6a528b2083637e1cc43a0e541b',PUBC=>'0373003b786b391df8bfee506d3c8ef06ba6abe797dfbd83d56c1c77fa4fa3',ECDSA_SHA1=>'3040021e34a760575935aad189d1fd58d0b84740f25cb91e829a605e02d3d78da526021e6669d3b4d56edff4d95310bc59ec443e306aba3443efbe6356153f3d2d3a',ECDSA_SHA256=>'3040021e42392d20a54b930870df319b4ff2b401d73d028e1a0aff73eee6f9bb1f04021e6a688a6eee784c86cb7a80a74e2ac7936c54f203bc5b7e38a3e8339ce02e'},
  {CURVE=>'prime239v2',PRI_FILE=>'key_prime239v2-2.pri.pem',PUB_FILE=>'key_prime239v2-2.pub.pem',PRI=>'420d695063758fd46b007badcefa22031d1544c81e6179ba211cab1f4870',PUB=>'04706eaf62b820e6982b6b77604d58640c14f2e6d9d500a25c5af132bde7342ea7caa1edc98513c48fffe799615ecc5ca27316b748a7cf1d61a36093d5',PUBC=>'03706eaf62b820e6982b6b77604d58640c14f2e6d9d500a25c5af132bde734',ECDSA_SHA1=>'3040021e3dc9786d2909e492b79e0829dec995094bce0fa72aa2f5792ed1e49c94f6021e033ec9cd8d9b53d6365e54fad6ff92c029636f4f1d05d8309c5908940cdf',ECDSA_SHA256=>'3040021e371a500289437979ac9e9ba3544589bbdddfca5cc4f11d8b9d2220b81929021e710f645cee7d7939d5bd35dfef8fcfc8f46e4bfc2ca7875e1fae52a258e7'},
  {CURVE=>'prime239v3',PRI_FILE=>'key_prime239v3-2.pri.pem',PUB_FILE=>'key_prime239v3-2.pub.pem',PRI=>'659e95f77dade42c7d9110ea4e4515bb8f02d8f5e3626aacf6d105121747',PUB=>'0429bc5929ae9da6f71a4f3616f90a4f4ef0268db5f11699d35da37218f1a32cf63dc7c17e2e2bc5d14298e168b745bdc142eeb5fcb94c47f646fcfbb7',PUBC=>'0329bc5929ae9da6f71a4f3616f90a4f4ef0268db5f11699d35da37218f1a3',ECDSA_SHA1=>'3040021e291cb5e727a422ae3594d8a39795355107dd3100935e7084589666179085021e7a5ee8a8e84cee4f818f4893b87003f02f5f1f7bd8d8db7d382ee24255d7',ECDSA_SHA256=>'3040021e478e0c7becb16f197b8491c16cd01a26a5623ea2b29a7f1b13ab240fdcd0021e60996413db68c035ff740476ef5eef859243a6daae5e94485dc486efdc0a'},
  {CURVE=>'prime256v1',PRI_FILE=>'key_prime256v1-2.pri.pem',PUB_FILE=>'key_prime256v1-2.pub.pem',PRI=>'40c961ba75e7e7bb72cf3a70164bd91697e99ab0436668031e17ec9306f4a418',PUB=>'04c4e24a83f54c2dd5b3c826b9bdcf1771d2e0ad164a4e91b6658f746cf8949a5938d8e727e08f54b8403acc4c5882fda0b1001692215a098e35df5aa22d4dccb4',PUBC=>'02c4e24a83f54c2dd5b3c826b9bdcf1771d2e0ad164a4e91b6658f746cf8949a59',ECDSA_SHA1=>'3045022063b6370e207f3611b2f4a2f56b7f31cf9aa0049b91d347bbfa48da1a07c600060221008784387f01b1cfa7951caa20bca1fa81e49b812661a8512513615a44dabd2772',ECDSA_SHA256=>'3046022100d21eb03d217c9545c82eb0cece3d5c9b0a5540f8350e5b200bec17509bacad86022100de403a528f8c4fcd2b6bcc6ec5131ffa830ae75827d1b7b828fc44fee7fefdf9'},
  {CURVE=>'secp112r1',PRI_FILE=>'key_secp112r1-3.pri.pem',PUB_FILE=>'key_secp112r1-3.pub.pem',PRI=>'99dac1a9d673f1495db2b80ee5f6',PUB=>'041d02fae808bccb57ca565c312cae0abaadaadf6a46d12ccaf7d12c95',PUBC=>'031d02fae808bccb57ca565c312cae',ECDSA_SHA1=>'3020020e1d29a37d02f2a35edd287f9bf894020e7b646f073a8f260095427ed24456',ECDSA_SHA256=>'3020020e603f37bb2c02c86716537630572a020e2af1fbd9760dcdbde41374307638'},
  {CURVE=>'secp112r2',PRI_FILE=>'key_secp112r2-3.pri.pem',PUB_FILE=>'key_secp112r2-3.pub.pem',PRI=>'013e4250b66bef1fe4bebfb2ae4d',PUB=>'04246c25c0a706d4b66062b75522e53922c012d5fc6b6c1b4a5e303e13',PUBC=>'03246c25c0a706d4b66062b75522e5',ECDSA_SHA1=>'3020020e16185a3bdbb6f1b0580ce4a9ffab020e182b89aaea76c1a7ac67a170174d',ECDSA_SHA256=>'3020020e26232f75db40434bfc8750402edb020e2cb40a523f9b157238696f11e49f'},
  {CURVE=>'secp128r1',PRI_FILE=>'key_secp128r1-3.pri.pem',PUB_FILE=>'key_secp128r1-3.pub.pem',PRI=>'16de36667a6aed4dfd0b6c589333862a',PUB=>'0415f6582df158fd71655e4b30d79a34a63635d644d8fc95efb53df1f9ef26ceba',PUBC=>'0215f6582df158fd71655e4b30d79a34a6',ECDSA_SHA1=>'30260211008da8921c9f3622e1b0e0b1c9b62348d7021100e1bc3b9a759fe65d52edcaa1faf35d08',ECDSA_SHA256=>'302402101a84782f46201fb5f8f48929670d173802104e4eea5f3010a169dbac27bbe86d6b1d'},
  {CURVE=>'secp128r2',PRI_FILE=>'key_secp128r2-3.pri.pem',PUB_FILE=>'key_secp128r2-3.pub.pem',PRI=>'0e8511b4ca37715cce554c75d93a0717',PUB=>'048127262ecb6d260ad2b531700e53873cd3e36bad4a35ae9a8cf0f46fa7153257',PUBC=>'038127262ecb6d260ad2b531700e53873c',ECDSA_SHA1=>'3024021000eb393148856af9d9c8a85dbc1c2b960210279019c29f1b9affebab711b73fbbed7',ECDSA_SHA256=>'3024021030f8c03c69cd3681152bfcb47baedd3602100146958b926d985bbe0f2f326f8b2c40'},
  {CURVE=>'secp160k1',PRI_FILE=>'key_secp160k1-3.pri.pem',PUB_FILE=>'key_secp160k1-3.pub.pem',PRI=>'de18c665d4ead6391e6d865a1f437ad41a63fe99',PUB=>'04a9cb746bbcd7fcf9df839e516816d11867322a0a3f589dcc639e3e37575c20e19f1d78e1734451b7',PUBC=>'03a9cb746bbcd7fcf9df839e516816d11867322a0a',ECDSA_SHA1=>'302e021500897668859cb3a0afc961c6622b8362bd1db9cd45021500ac8ecb94e4c2fc0b36064c75aecdceda4be95243',ECDSA_SHA256=>'302e021500e26e12f798ff67d292986f42c1700f867dfaed46021500ebaac751bf8953ea7b18bf7765b8d40320d78409'},
  {CURVE=>'secp160r1',PRI_FILE=>'key_secp160r1-3.pri.pem',PUB_FILE=>'key_secp160r1-3.pub.pem',PRI=>'4c3c347ce986c9c9af2d978a4f520d309f53a32c',PUB=>'044ef02c65cc01e27355e82839dd939c1d907569ff9b24bcb72962f24a5434989a8a494cdc982e272c',PUBC=>'024ef02c65cc01e27355e82839dd939c1d907569ff',ECDSA_SHA1=>'302e021500d83981a07ee6bfaafab87746d8ada8774bfce737021500d88aa07b13f7c8ca9110f83217da200cdf84e40a',ECDSA_SHA256=>'302e02150095e2b46af8171a27b5005096be62d86f09212240021500b6899293eca3af7ac8f2651ee9b294fdbb4915c7'},
  {CURVE=>'secp160r2',PRI_FILE=>'key_secp160r2-3.pri.pem',PUB_FILE=>'key_secp160r2-3.pub.pem',PRI=>'c7b1c191ccee2c0e1d691719350e7c6761c02e4f',PUB=>'04c6810cc1ed89788e9581fa85edfff774ddee38d9f01a87c51b748750f7a9b15ee83e620cdc4c3f46',PUBC=>'02c6810cc1ed89788e9581fa85edfff774ddee38d9',ECDSA_SHA1=>'302e021500b349b13cc377b37ca63a91fb2fe0219dd9e4b886021500a10e071c02762443ab4e8b2315a8acf456c9b911',ECDSA_SHA256=>'302d0214374915221f383798358bee6fde43a6a7cf431438021500ba3b6f5e9af136addb05d8acd0134462151a72d5'},
  {CURVE=>'secp192k1',PRI_FILE=>'key_secp192k1-3.pri.pem',PUB_FILE=>'key_secp192k1-3.pub.pem',PRI=>'1476eb7512b0f85d3e4824da18912335f5abc74e50ca3deb',PUB=>'04b20094e3df79dfcdef5ea044e9ee85457910379d939683a6c372ca525b543270c712d10260a58f21ad583383e9887568',PUBC=>'02b20094e3df79dfcdef5ea044e9ee85457910379d939683a6',ECDSA_SHA1=>'3035021900c5c2ae75f2106d5f4dfccf2f76a41f6f0bd587ebe8344e5d021852d7aa70f1f6cc73f50e9459252b68707995c90005844c9f',ECDSA_SHA256=>'303402181d7a041cdaa6ad34ba834fd7b53c6e260a1c6ccfe2638f7402183d7ef9e11953bf1fbdc7bb5cf7fd2701d28a64402f5925b5'},
  {CURVE=>'secp224k1',PRI_FILE=>'key_secp224k1-3.pri.pem',PUB_FILE=>'key_secp224k1-3.pub.pem',PRI=>'1709f944da01983d28b96777782e5a78e40e08c54212b19840f84006',PUB=>'04b56fdf57979beb9267a57e2ff9f5752dbf77c41c9ee12b8aa1e769802866f41bbfb4159b19659c42a95e40ff1c667eee4ab250b66cfe775d',PUBC=>'03b56fdf57979beb9267a57e2ff9f5752dbf77c41c9ee12b8aa1e76980',ECDSA_SHA1=>'303d021d0093e0b6edf75e3c2109caa6fa2dd79f2099081238c01cb0ad0ec09f2d021c404ea31d975290d58f03906293630913fea5a0a0839030f30828db75',ECDSA_SHA256=>'303c021c2118c6c3e8926ce2d1239e111da1a2979d14176c8ab144367121dd48021c376d49e2f4a212d274963c44bc72bea6249fb733f3445fb913bc85f5'},
  {CURVE=>'secp224r1',PRI_FILE=>'key_secp224r1-3.pri.pem',PUB_FILE=>'key_secp224r1-3.pub.pem',PRI=>'53dfaeffd502ac4d6c7942a2f7ff2367a016b20b1b350635f8c820eb',PUB=>'04b1fb44ffa8e4f655c060074e380900675b84cace46fd1fcada9b3d9b44cef8598e4caa8861bd10d81052606a3fe4a2cbfd1344287952837b',PUBC=>'03b1fb44ffa8e4f655c060074e380900675b84cace46fd1fcada9b3d9b',ECDSA_SHA1=>'303d021c2cbf83ae5138d0a4ea7aa0284a7195aefec5e12e2e3fe2dcd72926da021d00cd74475d258fe3070ba43a7b4e8653d1daaa18252a56a563d0c8062a',ECDSA_SHA256=>'303c021c094487a847116fdc95d77b981dfa8eb4363dbb33c42c1e9ce145b932021c5dcd1325cfa137f0d1b9076b49b2c29a91fbb3d9ca5fa32a8d3a350c'},
  {CURVE=>'secp256k1',PRI_FILE=>'key_secp256k1-3.pri.pem',PUB_FILE=>'key_secp256k1-3.pub.pem',PRI=>'20a12fab9d4a13fb06e1146ef6c715f6b663037336a5d59c2027b613d016eaeb',PUB=>'04275b2c4783e4ee1c22d0862b804ce97aa7c74631ad8f599fa94884ab366e44bc8f7bec169298abf6af998195cf47965e6c7426baac71653941b02942f50a4dc9',PUBC=>'03275b2c4783e4ee1c22d0862b804ce97aa7c74631ad8f599fa94884ab366e44bc',ECDSA_SHA1=>'3045022100a366fdf8d18bd322966a38834b5594080f19558af75e2216c637f048903e81f302201435b36c9ec5a864435af3c492216162357157a3b18a7c5811e4183b6263d662',ECDSA_SHA256=>'3046022100d0abdee98a71dd2a931266ce68b8937bfc6dbc74bde97919fbeeddc201e0fbf1022100e1db50da1e9e5c4adcb3fe1271d4dd32f3946659ea9a2d93eae6ac18eb02c26a'},
  {CURVE=>'secp384r1',PRI_FILE=>'key_secp384r1-3.pri.pem',PUB_FILE=>'key_secp384r1-3.pub.pem',PRI=>'1730392b33dac04f9f5e689308ea7c17cfe764a5f2208f598ba897c82317e469db16fe42457a68139b3e56c0a30fb983',PUB=>'0408353a2bb4dba518ad6a2c2cec3dfa9a17fc3440628cb03635749100bc46accd0ee6477ef0b018cae45f660f2134298e8a1b68fb2b8a9f9be8e6bfd09175923f4cd1efc459a7a6f233f5bae751333c4b318a32cd8834a9654bd72975a2fc82a7',PUBC=>'0308353a2bb4dba518ad6a2c2cec3dfa9a17fc3440628cb03635749100bc46accd0ee6477ef0b018cae45f660f2134298e',ECDSA_SHA1=>'3066023100d5a1649ebb113acc2f640316fb6798ff1d4532dd5fbd8744d821bcea8e15223e7d15b3fa2dcbe89e776f2f477a681791023100d0a60af9620eaa62a68830e0b717442e9c12e677da652705326da9c0e9766d1b654d94a2c3c11bdd98fa620764b3e143',ECDSA_SHA256=>'306502303b7a750e8b7e9007d4bd6f4a25a75cdf706cd75c6acb8c7543b06a72ba56ec5df629e51141c173459edb9c7e96212e71023100e5a98ee967460796fcf90c27009f485dd2dc066eb31bfe99ed0a2647a56a1206cdd28c7c9911896a74466b98363c668a'},
  {CURVE=>'secp521r1',PRI_FILE=>'key_secp521r1-3.pri.pem',PUB_FILE=>'key_secp521r1-3.pub.pem',PRI=>'01f2baec33a3d20b041c4ee883d457306e03f4e54b1285e0180e97d246461826a56dc49f8c6261e44c5e37de393fc467f505ec254d5380e6d82ace0335af5b4f8d15',PUB=>'0400b7f08eee478a92ba8e682286add2ca686409213662795632703c0ee39964af94188d133b793b4a9e6e354e6755f24d9d77018d77bb20238732147c9459b75eb50b000f099e980ee1cbb8ca4e1029b12a57083c300e8bb7240a23e0e8e5914010eb4c65b032e499570c59ee6d506501dfab6a4e3a957950437cba1495314af2c2863d98',PUBC=>'0200b7f08eee478a92ba8e682286add2ca686409213662795632703c0ee39964af94188d133b793b4a9e6e354e6755f24d9d77018d77bb20238732147c9459b75eb50b',ECDSA_SHA1=>'30818702412b146ccf45b99f845473b001765e875f69fa17cecdbe4f50189f75cce4d4910f24932e31cc5784fd56b817e6763afe78f3c793cb5796f121c044ab6dfc1ed01a8a024201cedad9d70fcbbb3c7c0677dc9a16b4b0bc8522fd3eac63cb7dd94452e375f66e56ff32a94c036e388367b5935482c50d4660e27b08d16f99b004855e4690929ce2',ECDSA_SHA256=>'308188024201c4f42125a4b3a51fba577722541d618139b01052d7ac866f411e22ff710cd3df0e3df9dbf89f70775911e6067024dc4b300dfa1146b0f13418946fd2e90d3646ff0242017275db4bad078310dd163a60c48cc805bb43b022be881b58d0a66d46762e380eee32735cd7fe1f0caed6eb57ed1af12cf5bff8f8bc66bb4a47313dd0e9bab2895f'},
  {CURVE=>'prime192v1',PRI_FILE=>'key_prime192v1-3.pri.pem',PUB_FILE=>'key_prime192v1-3.pub.pem',PRI=>'eb566f88950fd765e3d1f757e7293bd040b5a038812fc7bb',PUB=>'0404aef826969cfb139810d6bfe286917ec14e378730ea0707912480112d723d1eb50f129edb9367fda59fdd4867a0e0d8',PUBC=>'0204aef826969cfb139810d6bfe286917ec14e378730ea0707',ECDSA_SHA1=>'3036021900d88f65003cc149dbd2b7b30a86ad378f0298621a981b8b2f021900e618e0cae3b3d79886ba6a12deeb7fcb81dc74bbea7c3838',ECDSA_SHA256=>'3035021900fea28b7e0140628e06ed3946cbcc4cde7af87b3452e15b62021846ef2b4e550b954ac08798e5707770c78b8c4b71800ba486'},
  {CURVE=>'prime192v2',PRI_FILE=>'key_prime192v2-3.pri.pem',PUB_FILE=>'key_prime192v2-3.pub.pem',PRI=>'ec2af2777a78eacff5e4057925c8f4c3f1f4134492ce6e97',PUB=>'0423abfde9a835f43a1bbbb8ee413a24070b358af447b958997b8f2000089556a0128dd5252c5fb6ffb9532059f559846e',PUBC=>'0223abfde9a835f43a1bbbb8ee413a24070b358af447b95899',ECDSA_SHA1=>'303502184c83e052e376a1aa8ad731b197a51cb064b8cc426508653c0219008dfafacf06139e4982b7bedfd106c19ff320409809c17f23',ECDSA_SHA256=>'3035021814308b29608456cf4531f9cc107f077f5140f1e96865b0ff021900b372c4d61e8d24ccf76ed94dd8830aefdfaf0135cb582e37'},
  {CURVE=>'prime192v3',PRI_FILE=>'key_prime192v3-3.pri.pem',PUB_FILE=>'key_prime192v3-3.pub.pem',PRI=>'f721088da7d09e79a0f44e6bd6e92c27c68c6bf97242d3f5',PUB=>'04d93470443f8713e656a4509468c3706ef40b6a2ef86043fb181e6ca5eaffc54f7874b86b9ffad5f5b1a8f2703c121096',PUBC=>'02d93470443f8713e656a4509468c3706ef40b6a2ef86043fb',ECDSA_SHA1=>'3036021900c9cbf98af8853554b6c5012943d2f08c77b759bff7c719ee021900bc9534db2e4f40b8ffc7284a1f0c5bc0fa35bee52b56c699',ECDSA_SHA256=>'3034021810b340e088be8c6f50be9697e054780438f7e95f62f5302b021818cb8f834fdf26d23ead0f612171b5e0a66393633f647c46'},
  {CURVE=>'prime239v1',PRI_FILE=>'key_prime239v1-3.pri.pem',PUB_FILE=>'key_prime239v1-3.pub.pem',PRI=>'7b4521bca9b02ef8b57d9e2d6193a732d138b39d8abc741e96e146b01e3c',PUB=>'042c30f53413f4ea8a794724d02f1824ed9412a2b7cb02792f7e6ef06a93b130d45b9b4cde3e4b178921e0aa0c310e550a39f4d67800932466583f3690',PUBC=>'022c30f53413f4ea8a794724d02f1824ed9412a2b7cb02792f7e6ef06a93b1',ECDSA_SHA1=>'3040021e4165b85d1f2709847a739c3009adca605b7957eee86002461c92c8895b01021e7bcc9b21701e6b290b7032cba2ba87c8e0565c965db2190e9baa1152c372',ECDSA_SHA256=>'3040021e601b96746a533f378fafc2c12ee980a04857c6e56c36fcadb290ba0d0370021e312662f498a75da7506da87567a68e169d79f335cf743ce90516da562aff'},
  {CURVE=>'prime239v2',PRI_FILE=>'key_prime239v2-3.pri.pem',PUB_FILE=>'key_prime239v2-3.pub.pem',PRI=>'1da296ea5305b60c16824671f792118e585b65d564ed627371f3031765bc',PUB=>'04333d12e0faf83df27d7af2767f3196bfa2c7b758c8f7e394298b5d892aac7832609b6fb037ac1059cd471e3bece6784a39263a13979af094c00baf37',PUBC=>'03333d12e0faf83df27d7af2767f3196bfa2c7b758c8f7e394298b5d892aac',ECDSA_SHA1=>'3040021e6ba7fb1fe0ced3a2e221800817906de9e95035bf6970745792a3e46badcc021e5c4f8bc42973ad07509813c020d076972992a8294bd3b084a779e2a18cff',ECDSA_SHA256=>'3040021e6610ea72b2f451e5f801d6c81ecc416ccc0c6614adae2c51f5cf8d01d332021e2694f4086968d8552cbf9508a248967ece6a2e75e1a91caea584bd460656'},
  {CURVE=>'prime239v3',PRI_FILE=>'key_prime239v3-3.pri.pem',PUB_FILE=>'key_prime239v3-3.pub.pem',PRI=>'2c33bab3e10be173c9a98c8bda253f929569c4c53b8c26ebdea5202fbc3f',PUB=>'040bc536b07d27c9c138875e9d03f3cc1ce4d4bcd9a5fcfc0dcb6e9b539b9e126747a584397c8c9e29fc7c60205be6d018e16cc6a0ee4e9e014d87aa3a',PUBC=>'020bc536b07d27c9c138875e9d03f3cc1ce4d4bcd9a5fcfc0dcb6e9b539b9e',ECDSA_SHA1=>'3040021e04e94698eb31a90baaa8f9b578ec307f8d1f83edc85fd90c14652b520408021e3fbcf91f4dfa164ece8765bdbc70f72ced1e0c6aa919483fdefe3e75cbfe',ECDSA_SHA256=>'3040021e4c1e0fa1474a4bdfe5ad4ebdaf76e8eccb4d3288997ccda97cb8ac5e1771021e2a821fd377761401de5302f4dc99bc25705273967bf78e46068450a07328'},
  {CURVE=>'prime256v1',PRI_FILE=>'key_prime256v1-3.pri.pem',PUB_FILE=>'key_prime256v1-3.pub.pem',PRI=>'e6e3680400f2d4ee67577cec2819bf920fcfdf69fce549e5b603778b5b8f2894',PUB=>'0407ff8b133730ccdc19eb24bddd7931459488829e458e77ad5d5620f90ba61224ad599d9d436ec8fbcbc883e8342e14847f97fb37ff71e898d800574ab6a9e03f',PUBC=>'0307ff8b133730ccdc19eb24bddd7931459488829e458e77ad5d5620f90ba61224',ECDSA_SHA1=>'3045022100def3eba30349fe165c36da726f22579ad3ccfb853f6edf26ef8707b7e09332c40220076bcf2b5855b8485a460a5b96f211c7ea538b18fe3a4c54711bb53f9dfe18a4',ECDSA_SHA256=>'3045022100b4197fb9426cebae0204d63f250b1ba82d96a246369e56eef9196bcfd2f4b006022057131c64a5bd9c32f0c7cecaa1562f68f04c8390cdee81bd59d62551b87f9142'},
];

#diag("samples_count=". @$data);

for my $h (@$data) {
  ok( length($h->{PUB}) == 2 * length($h->{PRI})+2, "$h->{PRI_FILE}/length test PUB");
  ok( length($h->{PUBC}) == length($h->{PRI})+2,    "$h->{PRI_FILE}/length test PUBC");
}

for my $h (@$data) {
  my $ec_pri  = Crypt::PK::ECC->new->import_key_raw(pack("H*",$h->{PRI}),  $h->{CURVE});
  my $ec_pub  = Crypt::PK::ECC->new->import_key_raw(pack("H*",$h->{PUB}),  $h->{CURVE});
  my $ec_pubc = Crypt::PK::ECC->new->import_key_raw(pack("H*",$h->{PUBC}), $h->{CURVE});
  is( unpack("H*", $ec_pub ->export_key_raw('public_compressed')), $h->{PUBC}, "$h->{PRI_FILE}/ec_pub  public compressed");
  is( unpack("H*", $ec_pub ->export_key_raw('public'))           , $h->{PUB},  "$h->{PRI_FILE}/ec_pub  public uncompressed");
  is( unpack("H*", $ec_pubc->export_key_raw('public_compressed')), $h->{PUBC}, "$h->{PRI_FILE}/ec_pubc public compressed");
  is( unpack("H*", $ec_pubc->export_key_raw('public'))           , $h->{PUB},  "$h->{PRI_FILE}/ec_pubc public uncompressed");
  is( unpack("H*", $ec_pri ->export_key_raw('public_compressed')), $h->{PUBC}, "$h->{PRI_FILE}/ec_pri  public compressed");
  is( unpack("H*", $ec_pri ->export_key_raw('public'))           , $h->{PUB},  "$h->{PRI_FILE}/ec_pri  public uncompressed");
  is( unpack("H*", $ec_pri ->export_key_raw('private'))          , $h->{PRI},  "$h->{PRI_FILE}/ec_pri  private");
  ok( $ec_pub->verify_message(pack("H*", $h->{ECDSA_SHA1}), 'test-data', 'SHA1'), "$h->{PRI_FILE}/ECDSA_SHA1");
  ok( $ec_pub->verify_message(pack("H*", $h->{ECDSA_SHA256}), 'test-data', 'SHA256'), "$h->{PRI_FILE}/ECDSA_SHA256");
}

### ecc_set_key bug
{
  my $der = pack("H*", "3081be020101041500c78b055db0706fd86b5a15e14b9e51f0043d18f9a074307202010130200607".
                       "2a8648ce3d0101021500fffffffffffffffffffffffffffffffeffffac7330060401000401070429".
                       "043b4c382ce37aa192a4019e763036f4f5dd4d7ebb938cf935318fdced6bc28286531733c3f03c4f".
                       "ee02150100000000000000000001b8fa16dfab9aca16b6b3020101a12c032a00040ca9f03d79907c".
                       "97538177a3027970abefa351073a73120e1b5d2dab02dde37c118a44f8cb267b56");
  my $pk = Crypt::PK::ECC->new(\$der);
  ok($pk->is_private, "ecc_set_key bug");
}

### der_length_custom_type bug:
{
  my $der = pack("H*", "3081a8020101040e20df177a6f7e4bb9fecbd2d75b57a07f307d020101301a06072a8648ce3d0101".
                       "020f00db7c2abf62e35e668076bead208b3037040edb7c2abf62e35e668076bead2088040e659ef8".
                       "ba043916eede8911702b2203150000f50b028e4d696e676875615175290472783fb1040f02094872".
                       "39995a5ee76b55f9c2f098020f00db7c2abf62e35e7628dfac6561c5020101a11203100003a63510".
                       "5c5717812580408a3fd5ac");
  my $pk = Crypt::PK::ECC->new(\$der);
  ok($pk->is_private, "der_length_custom_type bug");
}

### ecc_import_pkcs8 bug
{
  my $der = pack("H*", "308193020100301306072a8648ce3d020106082a8648ce3d030107047930770201010420052f2b26".
                       "1d38522126f6a49cbdb958d5af85ed2c9e8cfebff85c44f20fe89a0fa00a06082a8648ce3d030107".
                       "a144034200043998011b129539269423f531808ed0854bef5b93d00aad8438742c1d272c24ca8649".
                       "e07f17da47c07453183fe35b68d069b700c38cc61dd5d98eb92dc474b573");
  my $pk = Crypt::PK::ECC->new(\$der);
  ok($pk->is_private, "ecc_import_pkcs8 bug");
}
