/*    DecimalFormatSymbols.xs
 *
 *    $Id: DecimalFormatSymbols.xs,v 1.6 2002/01/20 21:02:25 bstell Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "picu/picu_debug.h"
#include  "picu/picu_utf8.h"
#include  "picu/picu_util.h"
#include  "picu/DecimalFormatSymbols.h"
#include  "picu/Locale.h"
#include  "unicode/dcfmtsym.h"

char *DecimalFormatSymbols_class_string = "ICU::DecimalFormatSymbols";
static int debugLevel = 0;

static IV
constant_iv(char *name, int arg)
{
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        break;
#endif
    case 'k':
        if (!(*(name+1))) {
            goto not_there;
        }
        switch (*(name+1)) {
            case 'C':
                if (strEQ(name, "kCurrencySymbol"))
                    return DecimalFormatSymbols::kCurrencySymbol;
                break;
            case 'D':
                if (strEQ(name, "kDecimalSeparatorSymbol"))
                    return DecimalFormatSymbols::kDecimalSeparatorSymbol;
                if (strEQ(name, "kDigitSymbol"))
                    return DecimalFormatSymbols::kDigitSymbol;
                break;
            case 'E':
                if (strEQ(name, "kExponentialSymbol"))
                    return DecimalFormatSymbols::kExponentialSymbol;
                break;
            case 'F':
                if (strEQ(name, "kFormatSymbolCount"))
                    return DecimalFormatSymbols::kFormatSymbolCount;
                break;
            case 'G':
                if (strEQ(name, "kGroupingSeparatorSymbol"))
                    return DecimalFormatSymbols::kGroupingSeparatorSymbol;
                break;
            case 'I':
                if (strEQ(name, "kIntlCurrencySymbol"))
                    return DecimalFormatSymbols::kIntlCurrencySymbol;
                if (strEQ(name, "kInfinitySymbol"))
                    return DecimalFormatSymbols::kInfinitySymbol;
                break;
            case 'M':
                if (strEQ(name, "kMinusSignSymbol"))
                    return DecimalFormatSymbols::kMinusSignSymbol;
                if (strEQ(name, "kMonetarySeparatorSymbol"))
                    return DecimalFormatSymbols::kMonetarySeparatorSymbol;
                break;
            case 'N':
                if (strEQ(name, "kNaNSymbol"))
                    return DecimalFormatSymbols::kNaNSymbol;
                break;                             
            case 'P':
                if (strEQ(name, "kPatternSeparatorSymbol"))
                    return DecimalFormatSymbols::kPatternSeparatorSymbol;
                if (strEQ(name, "kPercentSymbol"))
                    return DecimalFormatSymbols::kPercentSymbol;
                if (strEQ(name, "kPlusSignSymbol"))
                    return DecimalFormatSymbols::kPlusSignSymbol;
                if (strEQ(name, "kPermillSymbol"))
                    return DecimalFormatSymbols::kPerMillSymbol;
                if (strEQ(name, "kPadEscapeSymbol"))
                    return DecimalFormatSymbols::kPadEscapeSymbol;
                break;
            case 'Z':
                if (strEQ(name, "kZeroDigitSymbol"))
                    return DecimalFormatSymbols::kZeroDigitSymbol;
                break;
        }
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

typedef enum DecimalFormatSymbols::ENumberFormatSymbol DecimalFormatSymbols__ENumberFormatSymbol;


MODULE = ICU::DecimalFormatSymbols    PACKAGE = ICU::DecimalFormatSymbols  

# This requires xsubpp version 1.925 or greater
REQUIRE: 1.925

IV
constant_iv(name, arg)
    char *name
    int arg

void
DecimalFormatSymbols::DESTROY()
    CODE:
        DEBUG100("DecimalFormatSymbols::DESTROY()");
        delete THIS;
        DEBUG100("DecimalFormatSymbols::DESTROY()");

void
DecimalFormatSymbols::getSymbol(symbol)
     DecimalFormatSymbols__ENumberFormatSymbol symbol;
    PREINIT:
      U8 *u8str;
      uint32_t u8len;
      UnicodeString symbol_val;
    CODE:
       symbol_val = THIS->getSymbol(symbol);
       u8str = UnicodeStringToU8String(symbol_val, &u8len);
       ST(0) = sv_newmortal();
       sv_usepvn(ST(0), (char*)u8str, u8len);
     OUTPUT:


void
DecimalFormatSymbols::setSymbol(symbol, val)    
        DecimalFormatSymbols__ENumberFormatSymbol symbol;
        const char* val;
    PREINIT:
        UnicodeString uni_val(val, "UTF-8");
     CODE:
        THIS->setSymbol(symbol, uni_val);


DecimalFormatSymbols*
DecimalFormatSymbols::new(...)
    PREINIT:
        Picu_Locale *locale = NULL;                                 
        UErrorCode status = U_ZERO_ERROR;
        SV *sv_status = NULL;
        const DecimalFormatSymbols *dfs = NULL;
        int locale_index = 0;
        int status_index = 0;
    CODE:
        if ((items < 1) || (items > 3)) {
            Perl_croak(aTHX_ 
            "Usage: new ICU::DecimalFormatSymbols([\\$status])\n"
            "   or: new ICU::DecimalFormatSymbols($locale [, \\$status])"
            "   or: new ICU::DecimalFormatSymbols($decimalFormatSymbols)");
        }
        //
        // distinguish between a locale object and a DecimalFormatObject
        // ie: figure out what the parameters we have 
        //
        DEBUG100("items = %d", items);
        if (items == 3) {
            locale_index = 1;
            status_index = 2;
        }
        else if (items == 2) {
            if ((sv_isobject(ST(1))) && 
                (IS_LOCALE_OBJECT(ST(1)))) {
                DEBUG100("param 1 is Locale object");
                locale_index = 1;
            }
            else if ((sv_isobject(ST(1))) && 
                (IS_DECIMALFORMATSYMBOLS_OBJECT(ST(1)))) {
                DEBUG100("param 1 is DecimalFormatSymbols object");
                dfs = (DecimalFormatSymbols *)SvIV((SV*)SvRV(ST(1)));
            }
            else {
                // we will check if it is a status ref later
                status_index = 1;
            }
        }

        //
        // get the args
        //
        if (locale_index) {
            if ((!sv_isobject(ST(locale_index))) 
                || (!IS_LOCALE_OBJECT(ST(locale_index)))) {
               Perl_croak(aTHX_ "param %d is not a Locale", locale_index);
            }
            DEBUG100("param %d is a locale", locale_index);
            locale = (Picu_Locale *)SvIV((SV*)SvRV(ST(locale_index)));
        }
        if (status_index) {
            if (!SVIsIntRef(ST(status_index))) {
                Perl_croak(aTHX_ "param %d is not an integer reference", 
                                 status_index);
            }
            DEBUG100("param %d is a status ref", status_index);
            sv_status = SvRV(ST(status_index));
            status = (UErrorCode)SvIV(sv_status);
            if (U_FAILURE(status)) {
                DEBUG100("status input = %d", status);
                XSRETURN_UNDEF;
            }
        }

        //
        // Call the ICU function
        // 
        if (dfs != NULL) {
            RETVAL = new DecimalFormatSymbols(*dfs);
        }
        else if (locale != NULL) {
            RETVAL = new DecimalFormatSymbols(*locale->getIcuLocale(), status);
        }
        else {
            RETVAL = new DecimalFormatSymbols(status);
        }
        if (U_FAILURE(status)) {
            DEBUG90("status output = %d", status);
        }
        DEBUG100("status output = %d", status);
        if (sv_status) {
            sv_setiv(sv_status, (IV)status);
        }
     OUTPUT:
        RETVAL

int
setDebugLevel(...)
    CODE:
        RETVAL = debugLevel; // return old value
        if (items > 1) {
            Perl_croak(aTHX_ "Usage: ICU::DecimalFormatSymbols::setDebugLevel([new_debug_level])");
        }
        else if (items == 1) {
            debugLevel = SvIV(ST(0));
        }
        DEBUG100("debugLevel = %d", debugLevel);
    OUTPUT:
        RETVAL

