use strict;
use warnings;
use Test::More tests => 68;
use Digest::BLAKE qw(blake_224 blake_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BLAKE->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(
            blake_224_hex($data), $digest,
            "blake_224_hex: $len bits of $msg"
        );
        ok(
            blake_224($data) eq pack('H*', $digest),
            "blake_224: $len bits of $msg"
        );
    }

    my $md = Digest::BLAKE->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|53F6633363B0CF3D4253963628555B5E8961339D39F057FC3782471B
00|C759365F39996CDD61F1B8AD7F7CF3CC388DA3CE9B31D951D6229D10
C0|EF0261E8CE8281D352A4EA8AAFF929DD5B217C2C8E74B926A011DB0C
C0|552A93069A4F344DC22447E78180614292AFF901411CA6801A9A42CA
80|D60A728550673EE99607286CA4E93CDEE5E3DD0BAA57FEBC8CD9B73C
48|8DC64D6114AFF925540B2EB45190305DCAE3EE268F9C17B269A7F80A
50|82AF3E035AA92B44F337FCB70B1BF5DB26FAF840111DB5B116845228
98|A0F5CC089A5AA6C9B4F3C579A2A3BBA7D0CD26D03BF6DEFFAB26EEC1
CC|4EBF21F9AC208F41B061282CCFC8C266D3162C7B56A2176B55FF6815
9800|836D5EC085F9419BB45F8050DD7D4BFE8AEA0773899097CF15178AAF
9D40|FB53197B7293ABF4B506623137FC682AB32B593A8850F3C3AAE5AD56
AA80|FBD3EF738D0265B45DCAE1FD794864246D2EC2F4B4485F76E7CA060A
9830|2E149B800AB36F7773B51A80F3447677903E0AE575C7E13814FD5178
5030|3CFD66C0023203ADC21C720FDFC038C47F69A62F160AA957B97AE2DC
4D24|C4AE79B829816E3C557675C2CA74CD1F9CE645A969890179EC94DDE8
CBDE|9A60A3C8178BE4554E9EB8C8C37CFC3CE23386F51417D836BC5A94A5
41FB|4A665A229316A0374677FFE016BF7A4B6876CFB0680D9DE40CD7D610
4FF400|167A25F1D196B2238256245DBEC6283C9858E63DDF85E6ED73FAD985
FD0440|1F43C23CA682B1B978608D957B501F6D9F3757C4FC633FE9404DB58E
424D00|6612A2FB9F3FAAD2155F79F21C066B5FC8929882658466246CF75F15
3FDEE0|1C87B9C44E7BB439CB605B94E5F810414426DB3DCB31BF724BC0ACA3
335768|32DC3022D675A9B41BE7781C01734C6AC714959CE455985052E67108
051E7C|E025CB6134C993EA4A6FF9BC82C0BCF7BECFC7DE616231A016562AD5
717F8C|CA7D5780FAC867501C3E2CBDA8B87AA69D7D3E8F18CC32B306F2387F
1F877C|070E1CA0B8441E165AE6C83333D914AFD203724A4ED62E825DE702E0
EB35CF80|1C14AFE8FA7BEF458AFDCEC1540FB823D0929D5BB639995C64690C28
B406C480|3CFBF22438D3F5955F70CFFE8EE48531F87EA783B356733B44521366
CEE88040|E5C9F85EE79A6CB49DA8702031B304C9F65AB7626117246C3425D967
C584DB70|19D6B0131659F20A9BEC2D203CA1439F90C078D718FA019C1FE9450A
53587BC8|9DB83B094A7D157FF7F6708EE6A42D21C10C72000C735345F9853F6D
69A305B0|B8C45D3E6D091B12EF62525967A2B44C7F4708DD5A106F31674684B3
C9375ECE|7B99341929421C383E1651BB4AB85D8D83B302158781DC79219741BC
C1ECFDFC|B3366E6BB5B7FF1A397410FAC04F3CA19DFA8E9E41C1FD0D59BF2B55
8D73E8A280|81AACA147A8CFB3124A1F036F4A7D9DC8ED971BB436B30FB6356137B
06F2522080|56C11245D1FFA492E013A5F1E034EF26760582F68F1E79D05DF63133
3EF6C36F20|3F15A027678DF543318B3F39AFA6226C6284EE7ACC61BE84E62D1362
0127A1D340|D85B84B267A7D757F3129727CE01AC61B51BEC03BA6AF6D79E71EEC4
6A6AB6C210|DD10FC1A89C67AD93C8C08F9C47977363983398611260AEDCA752076
AF3175E160|9C44E8BC78FF90B23BE2631DEC8625DD2F603BFEE061DDB1B22AC446
B66609ED86|7FF3BB1CB7892D5A0546101F5F9656882F194BE92766ECD9741728C0
21F134AC57|3DDFA3FE64638503486711678F60ED84B8A0FA7DBDA69AC9B961F15B
3DC2AADFFC80|D578F4A818A8709F491D433764C4C27B5D1EBB70778CBF63BDA4F848
9202736D2240|1AE5DFCFF28379DBA805FAFA1089611FE5159BA3EE0F7AC01038DEB8
F219BD629820|45720B393F72C4A0066404A777D7FA369E9D38F73E252EE037757DF5
F3511EE2C4B0|0F1BCC78F8567EFF4C26FD693D784D652A6992529DDEA95E5DC401DA
3ECAB6BF7720|FFAFB0E19924E31E80BAEC4351D61850801F39A098D1B6D91D2E4BB9
CD62F688F498|92960083E1CF41776C242786A9AC478076F04091CE251FBA995398F0
C2CBAA33A9F8|485BE8842DE784FA784B3C4D72CA1DA8B1390CC871D1E5B510A6C900
C6F50BB74E29|6F6CD597A9C8FB980A86022582051669D3FE6104A711DD2AA0359A9A
79F1B4CCC62A00|26CE2A93D10A1451665A029C3E1AA38E7D4FCB7964C8F4AA8C71F66E
