use strict;
use warnings;
use Test::More tests => 68;
use Digest::BMW qw(bmw_224 bmw_224_hex);

my $len = 0;

while (my $line = <DATA>) {
    chomp $line;
    my ($msg, $digest) = split '\|', $line, 2;
    my $data = pack 'H*', $msg;
    $digest = lc $digest;

    if ($len and not $len % 8) {
        my $md = Digest::BMW->new(224)->add($data)->hexdigest;
        is($md, $digest, "new/add/hexdigest: $len bits of $msg");
        is(bmw_224_hex($data), $digest, "bmw_224_hex: $len bits of $msg");
        ok(
            bmw_224($data) eq pack('H*', $digest),
            "bmw_224: $len bits of $msg"
        );
    }

    my $md = Digest::BMW->new(224)->add_bits($data, $len)->hexdigest;
    is($md, $digest, "new/add_bits/hexdigest: $len bits of $msg");
}
continue { $len++ }

__DATA__
00|E57C183DA7E2CD3E90258CA04499B222420F9B6797BBAB131B4D286E
00|FBFE1125D0A9D15853B66AADAFC3CF073836DAD7E09E5EB80160F7D7
C0|F9626381785C20F6A74188408BBA686E58F94AE6DDB1335CF5E092EA
C0|F6C67CAC2357D74D8DF96D56F3E848E066C897C21A56A5C10738E74E
80|4017788082025D8E18C40502206C0AFF2A1ED404F1CD3B9C7A111015
48|E821C9CD3BE5F449F096D2B46F1ADD6480E10F1E5B058AF36DFB012A
50|01DDBFA514F18B5D786969DFC8760013D734A0B244C2FC2AD75062DB
98|45AB70E7F1B24951D0A38B95446670F7C930F66CDED72455D071279F
CC|6CF1F720CC1A79EB0A5462BF13EFD47499CA52179C6F575147217577
9800|AD4386D8815D7084354FCE70B00B2EDE27CC8FDA3BD075FAB0D35FEB
9D40|3A6C9285397E10C4859B5A2CA50FD5481945E6E606BF19C8743A469A
AA80|42E4FFEFC767635B693451B7567746554B4341A8E846A97807355A7F
9830|BB72D23C0090252ED4985D2474A48F76B69D8F3BA5D46FEAAAB9199D
5030|8FD9D7D34E251B62926095CDAD0A12CF5D7FD95D1B7C686EED27E2C8
4D24|C34ABF3429522BD73BC4850EDF80DB7FCD03D9229B7FCC968FAA5B01
CBDE|262DDA8745237E06001C34E6AD2A4B85B40F5AD382EA9436B589407B
41FB|6F60C745033EFAC6E7CC1686CB218B01F17305CF4ADB57621185FF17
4FF400|661484DBC5C569AB2862842766595B5CA2508E9F3C55F0BC2BD79BEF
FD0440|0394509CA0705F937128DAB607714C4F459A1F589A44B7BE13B27740
424D00|5A0D1A51C8F82E47B98F07927BABBF20B64422733B637BA87325B32B
3FDEE0|F84E51C64BD5CD41E89873A3B971BCAEBA3449D09204FDC93AB5F2C2
335768|C84A14D058DEFD84367D5D19C23A20190D4A2C99C236ADC5ED8A5574
051E7C|66E06474C750786D894855B793BB6FEEF2DDCE61D576A4A81A11E240
717F8C|B8C5561990C53D2E32911F2358BF3F5B1B73A0D7D99D56A67951A86E
1F877C|D94D4E14316300D08F1D34CC6D9D68311B727312BE18B0FE5642607C
EB35CF80|794E816ED61844B3BEB6E694CEE19A9830469120ED34B9740971EAE3
B406C480|64B3FDC33C232F038ACA0496726FBA57F41E4D4B52C88BB7766FDD7A
CEE88040|62C1AE3F28BE396B1AC91DC9EB2E4ADE7301DBDB72999BAAA02F5389
C584DB70|8C4690F6EA78993726AA55B10463C1D0E27080DB62848982A0E52108
53587BC8|3DBC9FC1A864014055C4124739E8C972C587B63BCAF0EA62AC581560
69A305B0|3313F9B89CF6D178B5F3839E67061014ADA89735443721CDB9C038B1
C9375ECE|1D74548407BC0D78C7C67985D5FAD81274ABFDF8E51B819FBA6DEBBA
C1ECFDFC|11008BAAA758782B229E094253336F9CDC5545CC6A0235A7E713B8A3
8D73E8A280|BD96FB46F46E93AB479F89CC866763F0B2087A7D4B14A426BEFE874F
06F2522080|6C4C4D2063C6DB35C64994276B10E1F5FC838AB604FA1F6C0F9E4725
3EF6C36F20|BFDD36F28EB0C5695E36EA8AE8834ADD0F75D87EACA283FEF9C090C8
0127A1D340|C8E8819C11FD36EEABC22F6003F18CA6CA6068A7091EA0FDAC79F11A
6A6AB6C210|CA22671FCC83BF9FF4323570297E2E3546CEF73431A55F286D77EFC7
AF3175E160|7B55D645AA145049625AD11F7551C54DA87DB62AD96FF381EAC68FE5
B66609ED86|74D46F994AD9AAA8720B1784BF3DAEE8F673789C56875AD2B013E62D
21F134AC57|3D659888C5FE96C76F92B44D9BD01E44AB9809FE7AFB129751A5B197
3DC2AADFFC80|9841D31E015ADC9E584E1D2B6662DAE6835AF4BD395C0916B378974C
9202736D2240|FA3DCED24A25E6F3765C508BD18F95E6AB0E937A86B5E14499EA4AE6
F219BD629820|EC0F6526E4A634DB4670FE6F92E44DBB8D11337A017D49ED79AAEAC7
F3511EE2C4B0|C3CF261099177F49D4B0C37E8872C9519BCFB064ABBA13611B399B73
3ECAB6BF7720|E64FAC3E3FF514BB036939AAC4CBA749EE3191E0A43CD2CC77264B19
CD62F688F498|CCEB517802FE989F58AC8157435FED035ADB407DBB1B10BE81A828B0
C2CBAA33A9F8|E6CE57DCD973FA1ABE4837AEDF0A820FF7D28CC5157EB2B262FAB2C5
C6F50BB74E29|11B61FC5798F8E17CAE36EBD44432513D46EF838C80AE15B338BACC8
79F1B4CCC62A00|7E14A851830ABFB93CB7DD27BE192242931A052DC97849E6C91DE986
