package App::cpanminus::fatscript;
#
# This is a pre-compiled source code for the cpanm (cpanminus) program.
# For more details about how to install cpanm, go to the following URL:
#
#   https://github.com/miyagawa/cpanminus
#
# Quickstart: Run the following command and it will install itself for
# you. You might want to run it as a root with sudo if you want to install
# to places like /usr/local/bin.
#
#   % curl -L https://cpanmin.us | perl - App::cpanminus
#
# If you don't have curl but wget, replace `curl -L` with `wget -O -`.

# DO NOT EDIT -- this is an auto generated file

# This chunk of stuff was generated by App::FatPacker. To find the original
# file's code, look for the end of this BEGIN block or the string 'FATPACK'
BEGIN {
my %fatpacked;

$fatpacked{"Algorithm/C3.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'ALGORITHM_C3';
  
  package Algorithm::C3;
  
  use strict;
  use warnings;
  
  use Carp 'confess';
  
  our $VERSION = '0.10';
  
  sub merge {
      my ($root, $parent_fetcher, $cache) = @_;
  
      $cache ||= {};
  
      my @STACK; # stack for simulating recursion
  
      my $pfetcher_is_coderef = ref($parent_fetcher) eq 'CODE';
  
      unless ($pfetcher_is_coderef or $root->can($parent_fetcher)) {
          confess "Could not find method $parent_fetcher in $root";
      }
  
      my $current_root = $root;
      my $current_parents = [ $root->$parent_fetcher ];
      my $recurse_mergeout = [];
      my $i = 0;
      my %seen = ( $root => 1 );
  
      my ($new_root, $mergeout, %tails);
      while(1) {
          if($i < @$current_parents) {
              $new_root = $current_parents->[$i++];
  
              if($seen{$new_root}) {
                  my @isastack;
                  my $reached;
                  for(my $i = 0; $i < $#STACK; $i += 4) {
                      if($reached || ($reached = ($STACK[$i] eq $new_root))) {
                          push(@isastack, $STACK[$i]);
                      }
                  }
                  my $isastack = join(q{ -> }, @isastack, $current_root, $new_root);
                  die "Infinite loop detected in parents of '$root': $isastack";
              }
              $seen{$new_root} = 1;
  
              unless ($pfetcher_is_coderef or $new_root->can($parent_fetcher)) {
                  confess "Could not find method $parent_fetcher in $new_root";
              }
  
              push(@STACK, $current_root, $current_parents, $recurse_mergeout, $i);
  
              $current_root = $new_root;
              $current_parents = $cache->{pfetch}->{$current_root} ||= [ $current_root->$parent_fetcher ];
              $recurse_mergeout = [];
              $i = 0;
              next;
          }
  
          $seen{$current_root} = 0;
  
          $mergeout = $cache->{merge}->{$current_root} ||= do {
  
              # This do-block is the code formerly known as the function
              # that was a perl-port of the python code at
              # http://www.python.org/2.3/mro.html :)
  
              # Initial set (make sure everything is copied - it will be modded)
              my @seqs = map { [@$_] } @$recurse_mergeout;
              push(@seqs, [@$current_parents]) if @$current_parents;
  
              # Construct the tail-checking hash (actually, it's cheaper and still
              #   correct to re-use it throughout this function)
              foreach my $seq (@seqs) {
                  $tails{$seq->[$_]}++ for (1..$#$seq);
              }
  
              my @res = ( $current_root );
              while (1) {
                  my $cand;
                  my $winner;
                  foreach (@seqs) {
                      next if !@$_;
                      if(!$winner) {              # looking for a winner
                          $cand = $_->[0];        # seq head is candidate
                          next if $tails{$cand};  # he loses if in %tails
  
                          # Handy warn to give a output like the ones on
                          # http://www.python.org/download/releases/2.3/mro/
                          #warn " = " . join(' + ', @res) . "  + merge([" . join('] [',  map { join(', ', @$_) } grep { @$_ } @seqs) . "])\n";
                          push @res => $winner = $cand;
                          shift @$_;                # strip off our winner
                          $tails{$_->[0]}-- if @$_; # keep %tails sane
                      }
                      elsif($_->[0] eq $winner) {
                          shift @$_;                # strip off our winner
                          $tails{$_->[0]}-- if @$_; # keep %tails sane
                      }
                  }
  
                  # Handy warn to give a output like the ones on
                  # http://www.python.org/download/releases/2.3/mro/
                  #warn " = " . join(' + ', @res) . "\n" if !$cand;
  
                  last if !$cand;
                  die q{Inconsistent hierarchy found while merging '}
                      . $current_root . qq{':\n\t}
                      . qq{current merge results [\n\t\t}
                      . (join ",\n\t\t" => @res)
                      . qq{\n\t]\n\t} . qq{merging failed on '$cand'\n}
                    if !$winner;
              }
              \@res;
          };
  
          return @$mergeout if !@STACK;
  
          $i = pop(@STACK);
          $recurse_mergeout = pop(@STACK);
          $current_parents = pop(@STACK);
          $current_root = pop(@STACK);
  
          push(@$recurse_mergeout, $mergeout);
      }
  }
  
  1;
  
  __END__
  
  =pod
  
  =head1 NAME
  
  Algorithm::C3 - A module for merging hierarchies using the C3 algorithm
  
  =head1 SYNOPSIS
  
    use Algorithm::C3;
  
    # merging a classic diamond
    # inheritance graph like this:
    #
    #    <A>
    #   /   \
    # <B>   <C>
    #   \   /
    #    <D>
  
    my @merged = Algorithm::C3::merge(
        'D',
        sub {
            # extract the ISA array
            # from the package
            no strict 'refs';
            @{$_[0] . '::ISA'};
        }
    );
  
    print join ", " => @merged; # prints D, B, C, A
  
  =head1 DESCRIPTION
  
  This module implements the C3 algorithm. I have broken this out
  into it's own module because I found myself copying and pasting
  it way too often for various needs. Most of the uses I have for
  C3 revolve around class building and metamodels, but it could
  also be used for things like dependency resolution as well since
  it tends to do such a nice job of preserving local precedence
  orderings.
  
  Below is a brief explanation of C3 taken from the L<Class::C3>
  module. For more detailed information, see the L<SEE ALSO> section
  and the links there.
  
  =head2 What is C3?
  
  C3 is the name of an algorithm which aims to provide a sane method
  resolution order under multiple inheritance. It was first introduced
  in the language Dylan (see links in the L<SEE ALSO> section), and
  then later adopted as the preferred MRO (Method Resolution Order)
  for the new-style classes in Python 2.3. Most recently it has been
  adopted as the 'canonical' MRO for Perl 6 classes, and the default
  MRO for Parrot objects as well.
  
  =head2 How does C3 work.
  
  C3 works by always preserving local precedence ordering. This
  essentially means that no class will appear before any of it's
  subclasses. Take the classic diamond inheritance pattern for
  instance:
  
       <A>
      /   \
    <B>   <C>
      \   /
       <D>
  
  The standard Perl 5 MRO would be (D, B, A, C). The result being that
  B<A> appears before B<C>, even though B<C> is the subclass of B<A>.
  The C3 MRO algorithm however, produces the following MRO (D, B, C, A),
  which does not have this same issue.
  
  This example is fairly trivial, for more complex examples and a deeper
  explanation, see the links in the L<SEE ALSO> section.
  
  =head1 FUNCTION
  
  =over 4
  
  =item B<merge ($root, $func_to_fetch_parent, $cache)>
  
  This takes a C<$root> node, which can be anything really it
  is up to you. Then it takes a C<$func_to_fetch_parent> which
  can be either a CODE reference (see L<SYNOPSIS> above for an
  example), or a string containing a method name to be called
  on all the items being linearized. An example of how this
  might look is below:
  
    {
        package A;
  
        sub supers {
            no strict 'refs';
            @{$_[0] . '::ISA'};
        }
  
        package C;
        our @ISA = ('A');
        package B;
        our @ISA = ('A');
        package D;
        our @ISA = ('B', 'C');
    }
  
    print join ", " => Algorithm::C3::merge('D', 'supers');
  
  The purpose of C<$func_to_fetch_parent> is to provide a way
  for C<merge> to extract the parents of C<$root>. This is
  needed for C3 to be able to do it's work.
  
  The C<$cache> parameter is an entirely optional performance
  measure, and should not change behavior.
  
  If supplied, it should be a hashref that merge can use as a
  private cache between runs to speed things up.  Generally
  speaking, if you will be calling merge many times on related
  things, and the parent fetching function will return constant
  results given the same arguments during all of these calls,
  you can and should reuse the same shared cache hash for all
  of the calls.  Example:
  
    sub do_some_merging {
        my %merge_cache;
        my @foo_mro = Algorithm::C3::Merge('Foo', \&get_supers, \%merge_cache);
        my @bar_mro = Algorithm::C3::Merge('Bar', \&get_supers, \%merge_cache);
        my @baz_mro = Algorithm::C3::Merge('Baz', \&get_supers, \%merge_cache);
        my @quux_mro = Algorithm::C3::Merge('Quux', \&get_supers, \%merge_cache);
        # ...
    }
  
  =back
  
  =head1 CODE COVERAGE
  
  I use B<Devel::Cover> to test the code coverage of my tests, below
  is the B<Devel::Cover> report on this module's test suite.
  
   ------------------------ ------ ------ ------ ------ ------ ------ ------
   File                       stmt   bran   cond    sub    pod   time  total
   ------------------------ ------ ------ ------ ------ ------ ------ ------
   Algorithm/C3.pm           100.0  100.0  100.0  100.0  100.0  100.0  100.0
   ------------------------ ------ ------ ------ ------ ------ ------ ------
   Total                     100.0  100.0  100.0  100.0  100.0  100.0  100.0
   ------------------------ ------ ------ ------ ------ ------ ------ ------
  
  =head1 SEE ALSO
  
  =head2 The original Dylan paper
  
  =over 4
  
  =item L<http://www.webcom.com/haahr/dylan/linearization-oopsla96.html>
  
  =back
  
  =head2 The prototype Perl 6 Object Model uses C3
  
  =over 4
  
  =item L<http://svn.openfoundry.org/pugs/perl5/Perl6-MetaModel/>
  
  =back
  
  =head2 Parrot now uses C3
  
  =over 4
  
  =item L<http://aspn.activestate.com/ASPN/Mail/Message/perl6-internals/2746631>
  
  =item L<http://use.perl.org/~autrijus/journal/25768>
  
  =back
  
  =head2 Python 2.3 MRO related links
  
  =over 4
  
  =item L<http://www.python.org/2.3/mro.html>
  
  =item L<http://www.python.org/2.2.2/descrintro.html#mro>
  
  =back
  
  =head2 C3 for TinyCLOS
  
  =over 4
  
  =item L<http://www.call-with-current-continuation.org/eggs/c3.html>
  
  =back
  
  =head1 AUTHORS
  
  Stevan Little, E<lt>stevan@iinteractive.comE<gt>
  
  Brandon L. Black, E<lt>blblack@gmail.comE<gt>
  
  =head1 COPYRIGHT AND LICENSE
  
  Copyright 2006 by Infinity Interactive, Inc.
  
  L<http://www.iinteractive.com>
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself.
  
  =cut
ALGORITHM_C3

$fatpacked{"App/cpanminus.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'APP_CPANMINUS';
  package App::cpanminus;
  our $VERSION = "1.7905";
  
  =encoding utf8
  
  =head1 NAME
  
  App::cpanminus - get, unpack, build and install modules from CPAN
  
  =head1 SYNOPSIS
  
      cpanm Module
  
  Run C<cpanm -h> or C<perldoc cpanm> for more options.
  
  =head1 DESCRIPTION
  
  cpanminus is a script to get, unpack, build and install modules from
  CPAN and does nothing else.
  
  It's dependency free (can bootstrap itself), requires zero
  configuration, and stands alone. When running, it requires only 10MB
  of RAM.
  
  =head1 INSTALLATION
  
  There are several ways to install cpanminus to your system.
  
  =head2 Package management system
  
  There are Debian packages, RPMs, FreeBSD ports, and packages for other
  operation systems available. If you want to use the package management system,
  search for cpanminus and use the appropriate command to install. This makes it
  easy to install C<cpanm> to your system without thinking about where to
  install, and later upgrade.
  
  =head2 Installing to system perl
  
  You can also use the latest cpanminus to install cpanminus itself:
  
      curl -L https://cpanmin.us | perl - --sudo App::cpanminus
  
  This will install C<cpanm> to your bin directory like
  C</usr/local/bin> and you'll need the C<--sudo> option to write to
  the directory, unless you configured C<INSTALL_BASE> with L<local::lib>.
  
  =head2 Installing to local perl (perlbrew, plenv etc.)
  
  If you have perl in your home directory, which is the case if you use
  tools like L<perlbrew> or plenv, you don't need the C<--sudo> option, since
  you're most likely to have a write permission to the perl's library
  path. You can just do:
  
      curl -L https://cpanmin.us | perl - App::cpanminus
  
  to install the C<cpanm> executable to the perl's bin path, like
  C<~/perl5/perlbrew/bin/cpanm>.
  
  =head2 Downloading the standalone executable
  
  You can also copy the standalone executable to whatever location you'd like.
  
      cd ~/bin
      curl -L https://cpanmin.us/ -o cpanm
      chmod +x cpanm
  
  This just works, but be sure to grab the new version manually when you
  upgrade because C<--self-upgrade> might not work with this installation setup.
  
  =head2 Troubleshoot: HTTPS warnings
  
  When you run C<curl> commands above, you may encounter SSL handshake
  errors or certification warnings. This is due to your HTTP client
  (curl) being old, or SSL certificates installed on your system needs
  to be updated.
  
  You're recommended to update the software or system if you can. If
  that is impossible or difficult, use the C<-k> option with curl.
  
  =head1 DEPENDENCIES
  
  perl 5.8.1 or later.
  
  =over 4
  
  =item *
  
  'tar' executable (bsdtar or GNU tar version 1.22 are recommended) or Archive::Tar to unpack files.
  
  =item *
  
  C compiler, if you want to build XS modules.
  
  =item *
  
  make
  
  =item *
  
  Module::Build (core in 5.10)
  
  =back
  
  =head1 QUESTIONS
  
  =head2 How does cpanm get/parse/update the CPAN index?
  
  It queries the CPAN Meta DB site at L<http://cpanmetadb.plackperl.org/>.
  The site is updated at least every hour to reflect the latest changes
  from fast syncing mirrors. The script then also falls back to query the
  module at L<http://metacpan.org/> using its search API.
  
  Upon calling these API hosts, cpanm (1.6004 or later) will send the
  local perl versions to the server in User-Agent string by default. You
  can turn it off with C<--no-report-perl-version> option. Read more
  about the option with L<cpanm>, and read more about the privacy policy
  about this data collection at L<http://cpanmetadb.plackperl.org/#privacy>
  
  Fetched files are unpacked in C<~/.cpanm> and automatically cleaned up
  periodically.  You can configure the location of this with the
  C<PERL_CPANM_HOME> environment variable.
  
  =head2 Where does this install modules to? Do I need root access?
  
  It installs to wherever ExtUtils::MakeMaker and Module::Build are
  configured to (via C<PERL_MM_OPT> and C<PERL_MB_OPT>).
  
  By default, it installs to the site_perl directory that belongs to
  your perl. You can see the locations for that by running C<perl -V>
  and it will be likely something under C</opt/local/perl/...> if you're
  using system perl, or under your home directory if you have built perl
  yourself using perlbrew or plenv.
  
  If you've already configured local::lib on your shell, cpanm respects
  that settings and modules will be installed to your local perl5
  directory.
  
  At a boot time, cpanminus checks whether you have already configured
  local::lib, or have a permission to install modules to the site_perl
  directory.  If neither, i.e. you're using system perl and do not run
  cpanm as a root, it automatically sets up local::lib compatible
  installation path in a C<perl5> directory under your home
  directory.
  
  To avoid this, run C<cpanm> either as a root user, with C<--sudo>
  option, or with C<--local-lib> option.
  
  =head2 cpanminus can't install the module XYZ. Is it a bug?
  
  It is more likely a problem with the distribution itself. cpanminus
  doesn't support or may have issues with distributions such as follows:
  
  =over 4
  
  =item *
  
  Tests that require input from STDIN.
  
  =item *
  
  Build.PL or Makefile.PL that prompts for input even when
  C<PERL_MM_USE_DEFAULT> is enabled.
  
  =item *
  
  Modules that have invalid numeric values as VERSION (such as C<1.1a>)
  
  =back
  
  These failures can be reported back to the author of the module so
  that they can fix it accordingly, rather than to cpanminus.
  
  =head2 Does cpanm support the feature XYZ of L<CPAN> and L<CPANPLUS>?
  
  Most likely not. Here are the things that cpanm doesn't do by
  itself.
  
  If you need these features, use L<CPAN>, L<CPANPLUS> or the standalone
  tools that are mentioned.
  
  =over 4
  
  =item *
  
  CPAN testers reporting. See L<App::cpanminus::reporter>
  
  =item *
  
  Building RPM packages from CPAN modules
  
  =item *
  
  Listing the outdated modules that needs upgrading. See L<App::cpanoutdated>
  
  =item *
  
  Showing the changes of the modules you're about to upgrade. See L<cpan-listchanges>
  
  =item *
  
  Patching CPAN modules with distroprefs.
  
  =back
  
  See L<cpanm> or C<cpanm -h> to see what cpanminus I<can> do :)
  
  =head1 COPYRIGHT
  
  Copyright 2010- Tatsuhiko Miyagawa
  
  The standalone executable contains the following modules embedded.
  
  =over 4
  
  =item L<CPAN::DistnameInfo> Copyright 2003 Graham Barr
  
  =item L<local::lib> Copyright 2007-2009 Matt S Trout
  
  =item L<HTTP::Tiny> Copyright 2011 Christian Hansen
  
  =item L<Module::Metadata> Copyright 2001-2006 Ken Williams. 2010 Matt S Trout
  
  =item L<version> Copyright 2004-2010 John Peacock
  
  =item L<JSON::PP> Copyright 2007-2011 by Makamaka Hannyaharamitu
  
  =item L<CPAN::Meta>, L<CPAN::Meta::Requirements> Copyright (c) 2010 by David Golden and Ricardo Signes
  
  =item L<CPAN::Meta::YAML> Copyright 2010 Adam Kennedy
  
  =item L<CPAN::Meta::Check> Copyright (c) 2012 by Leon Timmermans
  
  =item L<File::pushd> Copyright 2012 David Golden
  
  =item L<parent> Copyright (c) 2007-10 Max Maischein
  
  =item L<Parse::PMFile> Copyright 1995 - 2013 by Andreas Koenig, Copyright 2013 by Kenichi Ishigaki
  
  =item L<String::ShellQuote> by Roderick Schertler
  
  
  =back
  
  =head1 LICENSE
  
  This software is licensed under the same terms as Perl.
  
  =head1 CREDITS
  
  =head2 CONTRIBUTORS
  
  Patches and code improvements were contributed by:
  
  Goro Fuji, Kazuhiro Osawa, Tokuhiro Matsuno, Kenichi Ishigaki, Ian
  Wells, Pedro Melo, Masayoshi Sekimura, Matt S Trout (mst), squeeky,
  horus and Ingy dot Net.
  
  =head2 ACKNOWLEDGEMENTS
  
  Bug reports, suggestions and feedbacks were sent by, or general
  acknowledgement goes to:
  
  Jesse Vincent, David Golden, Andreas Koenig, Jos Boumans, Chris
  Williams, Adam Kennedy, Audrey Tang, J. Shirley, Chris Prather, Jesse
  Luehrs, Marcus Ramberg, Shawn M Moore, chocolateboy, Chirs Nehren,
  Jonathan Rockway, Leon Brocard, Simon Elliott, Ricardo Signes, AEvar
  Arnfjord Bjarmason, Eric Wilhelm, Florian Ragwitz and xaicron.
  
  =head1 COMMUNITY
  
  =over 4
  
  =item L<http://github.com/miyagawa/cpanminus> - source code repository, issue tracker
  
  =item L<irc://irc.perl.org/#cpanm> - discussions about cpanm and its related tools
  
  =back
  
  =head1 NO WARRANTY
  
  This software is provided "as-is," without any express or implied
  warranty. In no event shall the author be held liable for any damages
  arising from the use of the software.
  
  =head1 SEE ALSO
  
  L<CPAN> L<CPANPLUS> L<pip>
  
  =cut
  
  1;
APP_CPANMINUS

$fatpacked{"CPAN/Common/Index.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_COMMON_INDEX';
  use 5.008001;
  use strict;
  use warnings;
  
  package CPAN::Common::Index;
  # ABSTRACT: Common library for searching CPAN modules, authors and distributions
  
  our $VERSION = '0.010';
  
  use Carp ();
  
  use Class::Tiny;
  
  #--------------------------------------------------------------------------#
  # Document abstract methods
  #--------------------------------------------------------------------------#
  
  #pod =method search_packages (ABSTRACT)
  #pod
  #pod     $result = $index->search_packages( { package => "Moose" });
  #pod     @result = $index->search_packages( \%advanced_query );
  #pod
  #pod Searches the index for a package such as listed in the CPAN
  #pod F<02packages.details.txt> file.  The query must be provided as a hash
  #pod reference.  Valid keys are
  #pod
  #pod =for :list
  #pod * package -- a string, regular expression or code reference
  #pod * version -- a version number or code reference
  #pod * dist -- a string, regular expression or code reference
  #pod
  #pod If the query term is a string or version number, the query will be for an exact
  #pod match.  If a code reference, the code will be called with the value of the
  #pod field for each potential match.  It should return true if it matches.
  #pod
  #pod Not all backends will implement support for all fields or all types of queries.
  #pod If it does not implement either, it should "decline" the query with an empty
  #pod return.
  #pod
  #pod The return should be context aware, returning either a
  #pod single result or a list of results.
  #pod
  #pod The result must be formed as follows:
  #pod
  #pod     {
  #pod       package => 'MOOSE',
  #pod       version => '2.0802',
  #pod       uri     => "cpan:///distfile/ETHER/Moose-2.0802.tar.gz"
  #pod     }
  #pod
  #pod The C<uri> field should be a valid URI.  It may be a L<URI::cpan> or any other
  #pod URI.  (It is up to a client to do something useful with any given URI scheme.)
  #pod
  #pod =method search_authors (ABSTRACT)
  #pod
  #pod     $result = $index->search_authors( { id => "DAGOLDEN" });
  #pod     @result = $index->search_authors( \%advanced_query );
  #pod
  #pod Searches the index for author data such as from the CPAN F<01mailrc.txt> file.
  #pod The query must be provided as a hash reference.  Valid keys are
  #pod
  #pod =for :list
  #pod * id -- a string, regular expression or code reference
  #pod * fullname -- a string, regular expression or code reference
  #pod * email -- a string, regular expression or code reference
  #pod
  #pod If the query term is a string, the query will be for an exact match.  If a code
  #pod reference, the code will be called with the value of the field for each
  #pod potential match.  It should return true if it matches.
  #pod
  #pod Not all backends will implement support for all fields or all types of queries.
  #pod If it does not implement either, it should "decline" the query with an empty
  #pod return.
  #pod
  #pod The return should be context aware, returning either a single result or a list
  #pod of results.
  #pod
  #pod The result must be formed as follows:
  #pod
  #pod     {
  #pod         id       => 'DAGOLDEN',
  #pod         fullname => 'David Golden',
  #pod         email    => 'dagolden@cpan.org',
  #pod     }
  #pod
  #pod The C<email> field may not reflect an actual email address.  The 01mailrc file
  #pod on CPAN often shows "CENSORED" when email addresses are concealed.
  #pod
  #pod =cut
  
  #--------------------------------------------------------------------------#
  # stub methods
  #--------------------------------------------------------------------------#
  
  #pod =method index_age
  #pod
  #pod     $epoch = $index->index_age;
  #pod
  #pod Returns the modification time of the index in epoch seconds.  This may not make sense
  #pod for some backends.  By default it returns the current time.
  #pod
  #pod =cut
  
  sub index_age { time }
  
  #pod =method refresh_index
  #pod
  #pod     $index->refresh_index;
  #pod
  #pod This ensures the index source is up to date.  For example, a remote
  #pod mirror file would be re-downloaded.  By default, it does nothing.
  #pod
  #pod =cut
  
  sub refresh_index { 1 }
  
  #pod =method attributes
  #pod
  #pod Return attributes and default values as a hash reference.  By default
  #pod returns an empty hash reference.
  #pod
  #pod =cut
  
  sub attributes { {} }
  
  #pod =method validate_attributes
  #pod
  #pod     $self->validate_attributes;
  #pod
  #pod This is called by the constructor to validate any arguments.  Subclasses
  #pod should override the default one to perform validation.  It should not be
  #pod called by application code.  By default, it does nothing.
  #pod
  #pod =cut
  
  sub validate_attributes { 1 }
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Common::Index - Common library for searching CPAN modules, authors and distributions
  
  =head1 VERSION
  
  version 0.010
  
  =head1 SYNOPSIS
  
      use CPAN::Common::Index::Mux::Ordered;
      use Data::Dumper;
  
      $index = CPAN::Common::Index::Mux::Ordered->assemble(
          MetaDB => {},
          Mirror => { mirror => "http://cpan.cpantesters.org" },
      );
  
      $result = $index->search_packages( { package => "Moose" } );
  
      print Dumper($result);
  
      # {
      #   package => 'MOOSE',
      #   version => '2.0802',
      #   uri     => "cpan:///distfile/ETHER/Moose-2.0802.tar.gz"
      # }
  
  =head1 DESCRIPTION
  
  This module provides a common library for working with a variety of CPAN index
  services.  It is intentionally minimalist, trying to use as few non-core
  modules as possible.
  
  The C<CPAN::Common::Index> module is an abstract base class that defines a
  common API.  Individual backends deliver the API for a particular index.
  
  As shown in the SYNOPSIS, one interesting application is multiplexing -- using
  different index backends, querying each in turn, and returning the first
  result.
  
  =head1 METHODS
  
  =head2 search_packages (ABSTRACT)
  
      $result = $index->search_packages( { package => "Moose" });
      @result = $index->search_packages( \%advanced_query );
  
  Searches the index for a package such as listed in the CPAN
  F<02packages.details.txt> file.  The query must be provided as a hash
  reference.  Valid keys are
  
  =over 4
  
  =item *
  
  package -- a string, regular expression or code reference
  
  =item *
  
  version -- a version number or code reference
  
  =item *
  
  dist -- a string, regular expression or code reference
  
  =back
  
  If the query term is a string or version number, the query will be for an exact
  match.  If a code reference, the code will be called with the value of the
  field for each potential match.  It should return true if it matches.
  
  Not all backends will implement support for all fields or all types of queries.
  If it does not implement either, it should "decline" the query with an empty
  return.
  
  The return should be context aware, returning either a
  single result or a list of results.
  
  The result must be formed as follows:
  
      {
        package => 'MOOSE',
        version => '2.0802',
        uri     => "cpan:///distfile/ETHER/Moose-2.0802.tar.gz"
      }
  
  The C<uri> field should be a valid URI.  It may be a L<URI::cpan> or any other
  URI.  (It is up to a client to do something useful with any given URI scheme.)
  
  =head2 search_authors (ABSTRACT)
  
      $result = $index->search_authors( { id => "DAGOLDEN" });
      @result = $index->search_authors( \%advanced_query );
  
  Searches the index for author data such as from the CPAN F<01mailrc.txt> file.
  The query must be provided as a hash reference.  Valid keys are
  
  =over 4
  
  =item *
  
  id -- a string, regular expression or code reference
  
  =item *
  
  fullname -- a string, regular expression or code reference
  
  =item *
  
  email -- a string, regular expression or code reference
  
  =back
  
  If the query term is a string, the query will be for an exact match.  If a code
  reference, the code will be called with the value of the field for each
  potential match.  It should return true if it matches.
  
  Not all backends will implement support for all fields or all types of queries.
  If it does not implement either, it should "decline" the query with an empty
  return.
  
  The return should be context aware, returning either a single result or a list
  of results.
  
  The result must be formed as follows:
  
      {
          id       => 'DAGOLDEN',
          fullname => 'David Golden',
          email    => 'dagolden@cpan.org',
      }
  
  The C<email> field may not reflect an actual email address.  The 01mailrc file
  on CPAN often shows "CENSORED" when email addresses are concealed.
  
  =head2 index_age
  
      $epoch = $index->index_age;
  
  Returns the modification time of the index in epoch seconds.  This may not make sense
  for some backends.  By default it returns the current time.
  
  =head2 refresh_index
  
      $index->refresh_index;
  
  This ensures the index source is up to date.  For example, a remote
  mirror file would be re-downloaded.  By default, it does nothing.
  
  =head2 attributes
  
  Return attributes and default values as a hash reference.  By default
  returns an empty hash reference.
  
  =head2 validate_attributes
  
      $self->validate_attributes;
  
  This is called by the constructor to validate any arguments.  Subclasses
  should override the default one to perform validation.  It should not be
  called by application code.  By default, it does nothing.
  
  =for Pod::Coverage method_names_here
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/Perl-Toolchain-Gang/CPAN-Common-Index/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/Perl-Toolchain-Gang/CPAN-Common-Index>
  
    git clone https://github.com/Perl-Toolchain-Gang/CPAN-Common-Index.git
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 CONTRIBUTORS
  
  =for stopwords David Golden Helmut Wollmersdorfer Kenichi Ishigaki Shoichi Kaji Tatsuhiko Miyagawa
  
  =over 4
  
  =item *
  
  David Golden <xdg@xdg.me>
  
  =item *
  
  Helmut Wollmersdorfer <helmut@wollmersdorfer.at>
  
  =item *
  
  Kenichi Ishigaki <ishigaki@cpan.org>
  
  =item *
  
  Shoichi Kaji <skaji@cpan.org>
  
  =item *
  
  Tatsuhiko Miyagawa <miyagawa@bulknews.net>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CPAN_COMMON_INDEX

$fatpacked{"CPAN/Common/Index/LocalPackage.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_COMMON_INDEX_LOCALPACKAGE';
  use 5.008001;
  use strict;
  use warnings;
  
  package CPAN::Common::Index::LocalPackage;
  # ABSTRACT: Search index via custom local CPAN package flatfile
  
  our $VERSION = '0.010';
  
  use parent 'CPAN::Common::Index::Mirror';
  
  use Class::Tiny qw/source/;
  
  use Carp;
  use File::Basename ();
  use File::Copy ();
  use File::Spec;
  use File::stat ();
  
  #pod =attr source (REQUIRED)
  #pod
  #pod Path to a local file in the form of 02packages.details.txt.  It may
  #pod be compressed with a ".gz" suffix or it may be uncompressed.
  #pod
  #pod =attr cache
  #pod
  #pod Path to a local directory to store a (possibly uncompressed) copy
  #pod of the source index.  Defaults to a temporary directory if not
  #pod specified.
  #pod
  #pod =cut
  
  sub BUILD {
      my $self = shift;
  
      my $file = $self->source;
      if ( !defined $file ) {
          Carp::croak("'source' parameter must be provided");
      }
      elsif ( !-f $file ) {
          Carp::croak("index file '$file' does not exist");
      }
  
      return;
  }
  
  sub cached_package {
      my ($self) = @_;
      my $package = File::Spec->catfile(
          $self->cache, File::Basename::basename($self->source)
      );
      $package =~ s/\.gz$//;
      $self->refresh_index unless -r $package;
      return $package;
  }
  
  sub refresh_index {
      my ($self) = @_;
      my $source = $self->source;
      my $basename = File::Basename::basename($source);
      if ( $source =~ /\.gz$/ ) {
          Carp::croak "can't load gz source files without IO::Uncompress::Gunzip\n"
            unless $CPAN::Common::Index::Mirror::HAS_IO_UNCOMPRESS_GUNZIP;
          ( my $uncompressed = $basename ) =~ s/\.gz$//;
          $uncompressed = File::Spec->catfile( $self->cache, $uncompressed );
          if ( !-f $uncompressed
                or File::stat::stat($source)->mtime > File::stat::stat($uncompressed)->mtime ) {
              no warnings 'once';
              IO::Uncompress::Gunzip::gunzip( map { "$_" } $source, $uncompressed )
                or Carp::croak "gunzip failed: $IO::Uncompress::Gunzip::GunzipError\n";
          }
      }
      else {
          my $dest = File::Spec->catfile( $self->cache, $basename );
          File::Copy::copy($source, $dest)
            if !-e $dest || File::stat::stat($source)->mtime > File::stat::stat($dest)->mtime;
      }
      return 1;
  }
  
  sub search_authors { return }; # this package handles packages only
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Common::Index::LocalPackage - Search index via custom local CPAN package flatfile
  
  =head1 VERSION
  
  version 0.010
  
  =head1 SYNOPSIS
  
    use CPAN::Common::Index::LocalPackage;
  
    $index = CPAN::Common::Index::LocalPackage->new(
      { source => "mypackages.details.txt" }
    );
  
  =head1 DESCRIPTION
  
  This module implements a CPAN::Common::Index that searches for packages in a local
  index file in the same form as the CPAN 02packages.details.txt file.
  
  There is no support for searching on authors.
  
  =head1 ATTRIBUTES
  
  =head2 source (REQUIRED)
  
  Path to a local file in the form of 02packages.details.txt.  It may
  be compressed with a ".gz" suffix or it may be uncompressed.
  
  =head2 cache
  
  Path to a local directory to store a (possibly uncompressed) copy
  of the source index.  Defaults to a temporary directory if not
  specified.
  
  =for Pod::Coverage attributes validate_attributes search_packages search_authors
  cached_package BUILD
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CPAN_COMMON_INDEX_LOCALPACKAGE

$fatpacked{"CPAN/Common/Index/MetaDB.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_COMMON_INDEX_METADB';
  use 5.008001;
  use strict;
  use warnings;
  
  package CPAN::Common::Index::MetaDB;
  # ABSTRACT: Search index via CPAN MetaDB
  
  our $VERSION = '0.010';
  
  use parent 'CPAN::Common::Index';
  
  use Class::Tiny qw/uri/;
  
  use Carp;
  use CPAN::Meta::YAML;
  use HTTP::Tiny;
  
  #pod =attr uri
  #pod
  #pod A URI for the endpoint of a CPAN MetaDB server. The
  #pod default is L<http://cpanmetadb.plackperl.org/v1.0/>.
  #pod
  #pod =cut
  
  sub BUILD {
      my $self = shift;
      my $uri  = $self->uri;
      $uri = "http://cpanmetadb.plackperl.org/v1.0/"
        unless defined $uri;
      # ensure URI ends in '/'
      $uri =~ s{/?$}{/};
      $self->uri($uri);
      return;
  }
  
  sub search_packages {
      my ( $self, $args ) = @_;
      Carp::croak("Argument to search_packages must be hash reference")
        unless ref $args eq 'HASH';
  
      # only support direct package query
      return
        unless keys %$args == 1 && exists $args->{package} && ref $args->{package} eq '';
  
      my $mod = $args->{package};
      my $res = HTTP::Tiny->new->get( $self->uri . "package/$mod" );
      return unless $res->{success};
  
      if ( my $yaml = CPAN::Meta::YAML->read_string( $res->{content} ) ) {
          my $meta = $yaml->[0];
          if ( $meta && $meta->{distfile} ) {
              my $file = $meta->{distfile};
              $file =~ s{^./../}{}; # strip leading
              return {
                  package => $mod,
                  version => $meta->{version},
                  uri     => "cpan:///distfile/$file",
              };
          }
      }
  
      return;
  }
  
  sub index_age { return time };    # pretend always current
  
  sub search_authors { return };    # not supported
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Common::Index::MetaDB - Search index via CPAN MetaDB
  
  =head1 VERSION
  
  version 0.010
  
  =head1 SYNOPSIS
  
    use CPAN::Common::Index::MetaDB;
  
    $index = CPAN::Common::Index::MetaDB->new;
  
  =head1 DESCRIPTION
  
  This module implements a CPAN::Common::Index that searches for packages against
  the same CPAN MetaDB API used by L<cpanminus>.
  
  There is no support for advanced package queries or searching authors.  It just
  takes a package name and returns the corresponding version and distribution.
  
  =head1 ATTRIBUTES
  
  =head2 uri
  
  A URI for the endpoint of a CPAN MetaDB server. The
  default is L<http://cpanmetadb.plackperl.org/v1.0/>.
  
  =for Pod::Coverage attributes validate_attributes search_packages search_authors BUILD
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CPAN_COMMON_INDEX_METADB

$fatpacked{"CPAN/Common/Index/Mirror.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_COMMON_INDEX_MIRROR';
  use 5.008001;
  use strict;
  use warnings;
  
  package CPAN::Common::Index::Mirror;
  # ABSTRACT: Search index via CPAN mirror flatfiles
  
  our $VERSION = '0.010';
  
  use parent 'CPAN::Common::Index';
  
  use Class::Tiny qw/cache mirror/;
  
  use Carp;
  use CPAN::DistnameInfo;
  use File::Basename ();
  use File::Fetch;
  use File::Temp 0.19; # newdir
  use Search::Dict 1.07;
  use Tie::Handle::SkipHeader;
  use URI;
  
  our $HAS_IO_UNCOMPRESS_GUNZIP = eval { require IO::Uncompress::Gunzip };
  
  #pod =attr mirror
  #pod
  #pod URI to a CPAN mirror.  Defaults to C<http://www.cpan.org/>.
  #pod
  #pod =attr cache
  #pod
  #pod Path to a local directory to store copies of the source indices.  Defaults to a
  #pod temporary directory if not specified.
  #pod
  #pod =cut
  
  sub BUILD {
      my $self = shift;
  
      # cache directory needs to exist
      my $cache = $self->cache;
      $cache = File::Temp->newdir
        unless defined $cache;
      if ( !-d $cache ) {
          Carp::croak("Cache directory '$cache' does not exist");
      }
      $self->cache($cache);
  
      # ensure mirror URL ends in '/'
      my $mirror = $self->mirror;
      $mirror = "http://www.cpan.org/"
        unless defined $mirror;
      $mirror =~ s{/?$}{/};
      $self->mirror($mirror);
  
      return;
  }
  
  my %INDICES = (
      mailrc   => 'authors/01mailrc.txt.gz',
      packages => 'modules/02packages.details.txt.gz',
  );
  
  # XXX refactor out from subs below
  my %TEST_GENERATORS = (
      regexp_nocase => sub {
          my $arg = shift;
          my $re = ref $arg eq 'Regexp' ? $arg : qr/\A\Q$arg\E\z/i;
          return sub { $_[0] =~ $re };
      },
      regexp => sub {
          my $arg = shift;
          my $re = ref $arg eq 'Regexp' ? $arg : qr/\A\Q$arg\E\z/;
          return sub { $_[0] =~ $re };
      },
      version => sub {
          my $arg = shift;
          my $v   = version->parse($arg);
          return sub {
              eval { version->parse( $_[0] ) == $v };
          };
      },
  );
  
  my %QUERY_TYPES = (
      # package search
      package => 'regexp',
      version => 'version',
      dist    => 'regexp',
  
      # author search
      id       => 'regexp_nocase', # XXX need to add "alias " first
      fullname => 'regexp_nocase',
      email    => 'regexp_nocase',
  );
  
  sub cached_package {
      my ($self) = @_;
      my $package = File::Spec->catfile( $self->cache,
          File::Basename::basename( $INDICES{packages} ) );
      $package =~ s/\.gz$//;
      $self->refresh_index unless -r $package;
      return $package;
  }
  
  sub cached_mailrc {
      my ($self) = @_;
      my $mailrc =
        File::Spec->catfile( $self->cache, File::Basename::basename( $INDICES{mailrc} ) );
      $mailrc =~ s/\.gz$//;
      $self->refresh_index unless -r $mailrc;
      return $mailrc;
  }
  
  sub refresh_index {
      my ($self) = @_;
      for my $file ( values %INDICES ) {
          my $remote = URI->new_abs( $file, $self->mirror );
          $remote =~ s/\.gz$//
            unless $HAS_IO_UNCOMPRESS_GUNZIP;
          my $ff = File::Fetch->new( uri => $remote );
          my $where = $ff->fetch( to => $self->cache )
            or Carp::croak( $ff->error );
          if ($HAS_IO_UNCOMPRESS_GUNZIP) {
              ( my $uncompressed = $where ) =~ s/\.gz$//;
              no warnings 'once';
              IO::Uncompress::Gunzip::gunzip( $where, $uncompressed )
                or Carp::croak "gunzip failed: $IO::Uncompress::Gunzip::GunzipError\n";
          }
      }
      return 1;
  }
  
  # epoch secs
  sub index_age {
      my ($self) = @_;
      my $package = $self->cached_package;
      return ( -r $package ? ( stat($package) )[9] : 0 ); # mtime if readable
  }
  
  sub search_packages {
      my ( $self, $args ) = @_;
      Carp::croak("Argument to search_packages must be hash reference")
        unless ref $args eq 'HASH';
  
      my $index_path = $self->cached_package;
      die "Can't read $index_path" unless -r $index_path;
  
      my $fh = IO::Handle->new;
      tie *$fh, 'Tie::Handle::SkipHeader', "<", $index_path
        or die "Can't tie $index_path: $!";
  
      # Convert scalars or regexps to subs
      my $rules;
      while ( my ( $k, $v ) = each %$args ) {
          $rules->{$k} = _rulify( $k, $v );
      }
  
      my @found;
      if ( $args->{package} and ref $args->{package} eq '' ) {
          # binary search 02packages on package
          my $pos = look $fh, $args->{package}, { xfrm => \&_xform_package, fold => 1 };
          return if $pos == -1;
          # loop over any case-insensitive matching lines
          LINE: while ( my $line = <$fh> ) {
              last unless $line =~ /\A\Q$args->{package}\E\s+/i;
              push @found, _match_package_line( $line, $rules );
          }
      }
      else {
          # iterate all lines looking for match
          LINE: while ( my $line = <$fh> ) {
              push @found, _match_package_line( $line, $rules );
          }
      }
      return wantarray ? @found : $found[0];
  }
  
  sub search_authors {
      my ( $self, $args ) = @_;
      Carp::croak("Argument to search_authors must be hash reference")
        unless ref $args eq 'HASH';
  
      my $index_path = $self->cached_mailrc;
      die "Can't read $index_path" unless -r $index_path;
      open my $fh, $index_path or die "Can't open $index_path: $!";
  
      # Convert scalars or regexps to subs
      my $rules;
      while ( my ( $k, $v ) = each %$args ) {
          $rules->{$k} = _rulify( $k, $v );
      }
  
      my @found;
      if ( $args->{id} and ref $args->{id} eq '' ) {
          # binary search mailrec on package
          my $pos = look $fh, $args->{id}, { xfrm => \&_xform_mailrc, fold => 1 };
          return if $pos == -1;
          my $line = <$fh>;
          push @found, _match_mailrc_line( $line, $rules );
      }
      else {
          # iterate all lines looking for match
          LINE: while ( my $line = <$fh> ) {
              push @found, _match_mailrc_line( $line, $rules );
          }
      }
      return wantarray ? @found : $found[0];
  }
  
  sub _rulify {
      my ( $key, $arg ) = @_;
      return $arg if ref($arg) eq 'CODE';
      return $TEST_GENERATORS{ $QUERY_TYPES{$key} }->($arg);
  }
  
  sub _xform_package {
      my @fields = split " ", $_[0], 2;
      return $fields[0];
  }
  
  sub _xform_mailrc {
      my @fields = split " ", $_[0], 3;
      return $fields[1];
  }
  
  sub _match_package_line {
      my ( $line, $rules ) = @_;
      return unless defined $line;
      my ( $mod, $version, $dist, $comment ) = split " ", $line, 4;
      if ( $rules->{package} ) {
          return unless $rules->{package}->($mod);
      }
      if ( $rules->{version} ) {
          return unless $rules->{version}->($version);
      }
      if ( $rules->{dist} ) {
          return unless $rules->{dist}->($dist);
      }
      $dist =~ s{\A./../}{};
      return {
          package => $mod,
          version => $version,
          uri     => "cpan:///distfile/$dist",
      };
  }
  
  sub _match_mailrc_line {
      my ( $line, $rules ) = @_;
      return unless defined $line;
      my ( $id,       $address ) = $line =~ m{\Aalias\s+(\S+)\s+"(.*)"};
      my ( $fullname, $email )   = $address =~ m{([^<]+)<([^>]+)>};
      $fullname =~ s/\s*$//;
      if ( $rules->{id} ) {
          return unless $rules->{id}->($id);
      }
      if ( $rules->{fullname} ) {
          return unless $rules->{fullname}->($fullname);
      }
      if ( $rules->{email} ) {
          return unless $rules->{email}->($email);
      }
      return {
          id       => $id,
          fullname => $fullname,
          email    => $email,
      };
  }
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Common::Index::Mirror - Search index via CPAN mirror flatfiles
  
  =head1 VERSION
  
  version 0.010
  
  =head1 SYNOPSIS
  
    use CPAN::Common::Index::Mirror;
  
    # default mirror is http://www.cpan.org/
    $index = CPAN::Common::Index::Mirror->new;
  
    # custom mirror
    $index = CPAN::Common::Index::Mirror->new(
      { mirror => "http://cpan.cpantesters.org" }
    );
  
  =head1 DESCRIPTION
  
  This module implements a CPAN::Common::Index that retrieves and searches
  02packages.details.txt and 01mailrc.txt indices.
  
  The default mirror is L<http://www.cpan.org/>.  This is a globally balanced
  fast mirror and is a great choice if you don't have a local fast mirror.
  
  =head1 ATTRIBUTES
  
  =head2 mirror
  
  URI to a CPAN mirror.  Defaults to C<http://www.cpan.org/>.
  
  =head2 cache
  
  Path to a local directory to store copies of the source indices.  Defaults to a
  temporary directory if not specified.
  
  =for Pod::Coverage attributes validate_attributes search_packages search_authors
  cached_package cached_mailrc BUILD
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CPAN_COMMON_INDEX_MIRROR

$fatpacked{"CPAN/Common/Index/Mux/Ordered.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_COMMON_INDEX_MUX_ORDERED';
  use 5.008001;
  use strict;
  use warnings;
  
  package CPAN::Common::Index::Mux::Ordered;
  # ABSTRACT: Consult indices in order and return the first result
  
  our $VERSION = '0.010';
  
  use parent 'CPAN::Common::Index';
  
  use Class::Tiny qw/resolvers/;
  
  use Module::Load ();
  
  #pod =attr resolvers
  #pod
  #pod     An array reference of CPAN::Common::Index::* objects
  #pod
  #pod =cut
  
  sub BUILD {
      my $self = shift;
  
      my $resolvers = $self->resolvers;
      $resolvers = [] unless defined $resolvers;
      if ( ref $resolvers ne 'ARRAY' ) {
          Carp::croak("The 'resolvers' argument must be an array reference");
      }
      for my $r (@$resolvers) {
          if ( !eval { $r->isa("CPAN::Common::Index") } ) {
              Carp::croak("Resolver '$r' is not a CPAN::Common::Index object");
          }
      }
      $self->resolvers($resolvers);
  
      return;
  }
  
  #pod =method assemble
  #pod
  #pod     $index = CPAN::Common::Index::Mux::Ordered->assemble(
  #pod         MetaDB => {},
  #pod         Mirror => { mirror => "http://www.cpan.org" },
  #pod     );
  #pod
  #pod This class method provides a shorthand for constructing a multiplexer.
  #pod The arguments must be pairs of subclass suffixes and arguments.  For
  #pod example, "MetaDB" means to use "CPAN::Common::Index::MetaDB".  Empty
  #pod arguments must be given as an empty hash reference.
  #pod
  #pod =cut
  
  sub assemble {
      my ( $class, @backends ) = @_;
  
      my @resolvers;
  
      while (@backends) {
          my ( $subclass, $config ) = splice @backends, 0, 2;
          my $full_class = "CPAN::Common::Index::${subclass}";
          eval { Module::Load::load($full_class); 1 }
            or Carp::croak($@);
          my $object = $full_class->new($config);
          push @resolvers, $object;
      }
  
      return $class->new( { resolvers => \@resolvers } );
  }
  
  sub validate_attributes {
      my ($self) = @_;
      my $resolvers = $self->resolvers;
      return 1;
  }
  
  # have to think carefully about the sematics of regex search when indices
  # are stacked; only one result for any given package (or package/version)
  sub search_packages {
      my ( $self, $args ) = @_;
      Carp::croak("Argument to search_packages must be hash reference")
        unless ref $args eq 'HASH';
      my @found;
      if ( $args->{name} and ref $args->{name} eq '' ) {
          # looking for exact match, so we just want the first hit
          for my $source ( @{ $self->resolvers } ) {
              if ( my @result = $source->search_packages($args) ) {
                  # XXX double check against remaining $args
                  push @found, @result;
                  last;
              }
          }
      }
      else {
          # accumulate results from all resolvers
          my %seen;
          for my $source ( @{ $self->resolvers } ) {
              my @result = $source->search_packages($args);
              push @found, grep { !$seen{ $_->{package} }++ } @result;
          }
      }
      return wantarray ? @found : $found[0];
  }
  
  # have to think carefully about the sematics of regex search when indices
  # are stacked; only one result for any given package (or package/version)
  sub search_authors {
      my ( $self, $args ) = @_;
      Carp::croak("Argument to search_authors must be hash reference")
        unless ref $args eq 'HASH';
      my @found;
      if ( $args->{name} and ref $args->{name} eq '' ) {
          # looking for exact match, so we just want the first hit
          for my $source ( @{ $self->resolvers } ) {
              if ( my @result = $source->search_authors($args) ) {
                  # XXX double check against remaining $args
                  push @found, @result;
                  last;
              }
          }
      }
      else {
          # accumulate results from all resolvers
          my %seen;
          for my $source ( @{ $self->resolvers } ) {
              my @result = $source->search_authors($args);
              push @found, grep { !$seen{ $_->{package} }++ } @result;
          }
      }
      return wantarray ? @found : $found[0];
  }
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Common::Index::Mux::Ordered - Consult indices in order and return the first result
  
  =head1 VERSION
  
  version 0.010
  
  =head1 SYNOPSIS
  
      use CPAN::Common::Index::Mux::Ordered;
      use Data::Dumper;
  
      $index = CPAN::Common::Index::Mux::Ordered->assemble(
          MetaDB => {},
          Mirror => { mirror => "http://cpan.cpantesters.org" },
      );
  
  =head1 DESCRIPTION
  
  This module multiplexes multiple CPAN::Common::Index objects, returning
  results in order.
  
  For exact match queries, the first result is returned. For search queries,
  results from each index object are concatenated.
  
  =head1 ATTRIBUTES
  
  =head2 resolvers
  
      An array reference of CPAN::Common::Index::* objects
  
  =head1 METHODS
  
  =head2 assemble
  
      $index = CPAN::Common::Index::Mux::Ordered->assemble(
          MetaDB => {},
          Mirror => { mirror => "http://www.cpan.org" },
      );
  
  This class method provides a shorthand for constructing a multiplexer.
  The arguments must be pairs of subclass suffixes and arguments.  For
  example, "MetaDB" means to use "CPAN::Common::Index::MetaDB".  Empty
  arguments must be given as an empty hash reference.
  
  =for Pod::Coverage attributes validate_attributes search_packages search_authors BUILD
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CPAN_COMMON_INDEX_MUX_ORDERED

$fatpacked{"CPAN/DistnameInfo.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_DISTNAMEINFO';
  
  package CPAN::DistnameInfo;
  
  $VERSION = "0.12";
  use strict;
  
  sub distname_info {
    my $file = shift or return;
  
    my ($dist, $version) = $file =~ /^
      ((?:[-+.]*(?:[A-Za-z0-9]+|(?<=\D)_|_(?=\D))*
       (?:
  	[A-Za-z](?=[^A-Za-z]|$)
  	|
  	\d(?=-)
       )(?<![._-][vV])
      )+)(.*)
    $/xs or return ($file,undef,undef);
  
    if ($dist =~ /-undef\z/ and ! length $version) {
      $dist =~ s/-undef\z//;
    }
  
    # Remove potential -withoutworldwriteables suffix
    $version =~ s/-withoutworldwriteables$//;
  
    if ($version =~ /^(-[Vv].*)-(\d.*)/) {
     
      # Catch names like Unicode-Collate-Standard-V3_1_1-0.1
      # where the V3_1_1 is part of the distname
      $dist .= $1;
      $version = $2;
    }
  
    if ($version =~ /(.+_.*)-(\d.*)/) {
        # Catch names like Task-Deprecations5_14-1.00.tar.gz where the 5_14 is
        # part of the distname. However, names like libao-perl_0.03-1.tar.gz
        # should still have 0.03-1 as their version.
        $dist .= $1;
        $version = $2;
    }
  
    # Normalize the Dist.pm-1.23 convention which CGI.pm and
    # a few others use.
    $dist =~ s{\.pm$}{};
  
    $version = $1
      if !length $version and $dist =~ s/-(\d+\w)$//;
  
    $version = $1 . $version
      if $version =~ /^\d+$/ and $dist =~ s/-(\w+)$//;
  
    if ($version =~ /\d\.\d/) {
      $version =~ s/^[-_.]+//;
    }
    else {
      $version =~ s/^[-_]+//;
    }
  
    my $dev;
    if (length $version) {
      if ($file =~ /^perl-?\d+\.(\d+)(?:\D(\d+))?(-(?:TRIAL|RC)\d+)?$/) {
        $dev = 1 if (($1 > 6 and $1 & 1) or ($2 and $2 >= 50)) or $3;
      }
      elsif ($version =~ /\d\D\d+_\d/ or $version =~ /-TRIAL/) {
        $dev = 1;
      }
    }
    else {
      $version = undef;
    }
  
    ($dist, $version, $dev);
  }
  
  sub new {
    my $class = shift;
    my $distfile = shift;
  
    $distfile =~ s,//+,/,g;
  
    my %info = ( pathname => $distfile );
  
    ($info{filename} = $distfile) =~ s,^(((.*?/)?authors/)?id/)?([A-Z])/(\4[A-Z])/(\5[-A-Z0-9]*)/,,
      and $info{cpanid} = $6;
  
    if ($distfile =~ m,([^/]+)\.(tar\.(?:g?z|bz2)|zip|tgz)$,i) { # support more ?
      $info{distvname} = $1;
      $info{extension} = $2;
    }
  
    @info{qw(dist version beta)} = distname_info($info{distvname});
    $info{maturity} = delete $info{beta} ? 'developer' : 'released';
  
    return bless \%info, $class;
  }
  
  sub dist      { shift->{dist} }
  sub version   { shift->{version} }
  sub maturity  { shift->{maturity} }
  sub filename  { shift->{filename} }
  sub cpanid    { shift->{cpanid} }
  sub distvname { shift->{distvname} }
  sub extension { shift->{extension} }
  sub pathname  { shift->{pathname} }
  
  sub properties { %{ $_[0] } }
  
  1;
  
  __END__
  
  =head1 NAME
  
  CPAN::DistnameInfo - Extract distribution name and version from a distribution filename
  
  =head1 SYNOPSIS
  
    my $pathname = "authors/id/G/GB/GBARR/CPAN-DistnameInfo-0.02.tar.gz";
  
    my $d = CPAN::DistnameInfo->new($pathname);
  
    my $dist      = $d->dist;      # "CPAN-DistnameInfo"
    my $version   = $d->version;   # "0.02"
    my $maturity  = $d->maturity;  # "released"
    my $filename  = $d->filename;  # "CPAN-DistnameInfo-0.02.tar.gz"
    my $cpanid    = $d->cpanid;    # "GBARR"
    my $distvname = $d->distvname; # "CPAN-DistnameInfo-0.02"
    my $extension = $d->extension; # "tar.gz"
    my $pathname  = $d->pathname;  # "authors/id/G/GB/GBARR/..."
  
    my %prop = $d->properties;
  
  =head1 DESCRIPTION
  
  Many online services that are centered around CPAN attempt to
  associate multiple uploads by extracting a distribution name from
  the filename of the upload. For most distributions this is easy as
  they have used ExtUtils::MakeMaker or Module::Build to create the
  distribution, which results in a uniform name. But sadly not all
  uploads are created in this way.
  
  C<CPAN::DistnameInfo> uses heuristics that have been learnt by
  L<http://search.cpan.org/> to extract the distribution name and
  version from filenames and also report if the version is to be
  treated as a developer release
  
  The constructor takes a single pathname, returning an object with the following methods
  
  =over
  
  =item cpanid
  
  If the path given looked like a CPAN authors directory path, then this will be the
  the CPAN id of the author.
  
  =item dist
  
  The name of the distribution
  
  =item distvname
  
  The file name with any suffix and leading directory names removed
  
  =item filename
  
  If the path given looked like a CPAN authors directory path, then this will be the
  path to the file relative to the detected CPAN author directory. Otherwise it is the path
  that was passed in.
  
  =item maturity
  
  The maturity of the distribution. This will be either C<released> or C<developer>
  
  =item extension
  
  The extension of the distribution, often used to denote the archive type (e.g. 'tar.gz')
  
  =item pathname
  
  The pathname that was passed to the constructor when creating the object.
  
  =item properties
  
  This will return a list of key-value pairs, suitable for assigning to a hash,
  for the known properties.
  
  =item version
  
  The extracted version
  
  =back
  
  =head1 AUTHOR
  
  Graham Barr <gbarr@pobox.com>
  
  =head1 COPYRIGHT 
  
  Copyright (c) 2003 Graham Barr. All rights reserved. This program is
  free software; you can redistribute it and/or modify it under the same
  terms as Perl itself.
  
  =cut
  
CPAN_DISTNAMEINFO

$fatpacked{"CPAN/Meta.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META';
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta;
  
  our $VERSION = '2.150010';
  
  #pod =head1 SYNOPSIS
  #pod
  #pod     use v5.10;
  #pod     use strict;
  #pod     use warnings;
  #pod     use CPAN::Meta;
  #pod     use Module::Load;
  #pod
  #pod     my $meta = CPAN::Meta->load_file('META.json');
  #pod
  #pod     printf "testing requirements for %s version %s\n",
  #pod     $meta->name,
  #pod     $meta->version;
  #pod
  #pod     my $prereqs = $meta->effective_prereqs;
  #pod
  #pod     for my $phase ( qw/configure runtime build test/ ) {
  #pod         say "Requirements for $phase:";
  #pod         my $reqs = $prereqs->requirements_for($phase, "requires");
  #pod         for my $module ( sort $reqs->required_modules ) {
  #pod             my $status;
  #pod             if ( eval { load $module unless $module eq 'perl'; 1 } ) {
  #pod                 my $version = $module eq 'perl' ? $] : $module->VERSION;
  #pod                 $status = $reqs->accepts_module($module, $version)
  #pod                         ? "$version ok" : "$version not ok";
  #pod             } else {
  #pod                 $status = "missing"
  #pod             };
  #pod             say "  $module ($status)";
  #pod         }
  #pod     }
  #pod
  #pod =head1 DESCRIPTION
  #pod
  #pod Software distributions released to the CPAN include a F<META.json> or, for
  #pod older distributions, F<META.yml>, which describes the distribution, its
  #pod contents, and the requirements for building and installing the distribution.
  #pod The data structure stored in the F<META.json> file is described in
  #pod L<CPAN::Meta::Spec>.
  #pod
  #pod CPAN::Meta provides a simple class to represent this distribution metadata (or
  #pod I<distmeta>), along with some helpful methods for interrogating that data.
  #pod
  #pod The documentation below is only for the methods of the CPAN::Meta object.  For
  #pod information on the meaning of individual fields, consult the spec.
  #pod
  #pod =cut
  
  use Carp qw(carp croak);
  use CPAN::Meta::Feature;
  use CPAN::Meta::Prereqs;
  use CPAN::Meta::Converter;
  use CPAN::Meta::Validator;
  use Parse::CPAN::Meta 1.4414 ();
  
  BEGIN { *_dclone = \&CPAN::Meta::Converter::_dclone }
  
  #pod =head1 STRING DATA
  #pod
  #pod The following methods return a single value, which is the value for the
  #pod corresponding entry in the distmeta structure.  Values should be either undef
  #pod or strings.
  #pod
  #pod =for :list
  #pod * abstract
  #pod * description
  #pod * dynamic_config
  #pod * generated_by
  #pod * name
  #pod * release_status
  #pod * version
  #pod
  #pod =cut
  
  BEGIN {
    my @STRING_READERS = qw(
      abstract
      description
      dynamic_config
      generated_by
      name
      release_status
      version
    );
  
    no strict 'refs';
    for my $attr (@STRING_READERS) {
      *$attr = sub { $_[0]{ $attr } };
    }
  }
  
  #pod =head1 LIST DATA
  #pod
  #pod These methods return lists of string values, which might be represented in the
  #pod distmeta structure as arrayrefs or scalars:
  #pod
  #pod =for :list
  #pod * authors
  #pod * keywords
  #pod * licenses
  #pod
  #pod The C<authors> and C<licenses> methods may also be called as C<author> and
  #pod C<license>, respectively, to match the field name in the distmeta structure.
  #pod
  #pod =cut
  
  BEGIN {
    my @LIST_READERS = qw(
      author
      keywords
      license
    );
  
    no strict 'refs';
    for my $attr (@LIST_READERS) {
      *$attr = sub {
        my $value = $_[0]{ $attr };
        croak "$attr must be called in list context"
          unless wantarray;
        return @{ _dclone($value) } if ref $value;
        return $value;
      };
    }
  }
  
  sub authors  { $_[0]->author }
  sub licenses { $_[0]->license }
  
  #pod =head1 MAP DATA
  #pod
  #pod These readers return hashrefs of arbitrary unblessed data structures, each
  #pod described more fully in the specification:
  #pod
  #pod =for :list
  #pod * meta_spec
  #pod * resources
  #pod * provides
  #pod * no_index
  #pod * prereqs
  #pod * optional_features
  #pod
  #pod =cut
  
  BEGIN {
    my @MAP_READERS = qw(
      meta-spec
      resources
      provides
      no_index
  
      prereqs
      optional_features
    );
  
    no strict 'refs';
    for my $attr (@MAP_READERS) {
      (my $subname = $attr) =~ s/-/_/;
      *$subname = sub {
        my $value = $_[0]{ $attr };
        return _dclone($value) if $value;
        return {};
      };
    }
  }
  
  #pod =head1 CUSTOM DATA
  #pod
  #pod A list of custom keys are available from the C<custom_keys> method and
  #pod particular keys may be retrieved with the C<custom> method.
  #pod
  #pod   say $meta->custom($_) for $meta->custom_keys;
  #pod
  #pod If a custom key refers to a data structure, a deep clone is returned.
  #pod
  #pod =cut
  
  sub custom_keys {
    return grep { /^x_/i } keys %{$_[0]};
  }
  
  sub custom {
    my ($self, $attr) = @_;
    my $value = $self->{$attr};
    return _dclone($value) if ref $value;
    return $value;
  }
  
  #pod =method new
  #pod
  #pod   my $meta = CPAN::Meta->new($distmeta_struct, \%options);
  #pod
  #pod Returns a valid CPAN::Meta object or dies if the supplied metadata hash
  #pod reference fails to validate.  Older-format metadata will be up-converted to
  #pod version 2 if they validate against the original stated specification.
  #pod
  #pod It takes an optional hashref of options. Valid options include:
  #pod
  #pod =over
  #pod
  #pod =item *
  #pod
  #pod lazy_validation -- if true, new will attempt to convert the given metadata
  #pod to version 2 before attempting to validate it.  This means than any
  #pod fixable errors will be handled by CPAN::Meta::Converter before validation.
  #pod (Note that this might result in invalid optional data being silently
  #pod dropped.)  The default is false.
  #pod
  #pod =back
  #pod
  #pod =cut
  
  sub _new {
    my ($class, $struct, $options) = @_;
    my $self;
  
    if ( $options->{lazy_validation} ) {
      # try to convert to a valid structure; if succeeds, then return it
      my $cmc = CPAN::Meta::Converter->new( $struct );
      $self = $cmc->convert( version => 2 ); # valid or dies
      return bless $self, $class;
    }
    else {
      # validate original struct
      my $cmv = CPAN::Meta::Validator->new( $struct );
      unless ( $cmv->is_valid) {
        die "Invalid metadata structure. Errors: "
          . join(", ", $cmv->errors) . "\n";
      }
    }
  
    # up-convert older spec versions
    my $version = $struct->{'meta-spec'}{version} || '1.0';
    if ( $version == 2 ) {
      $self = $struct;
    }
    else {
      my $cmc = CPAN::Meta::Converter->new( $struct );
      $self = $cmc->convert( version => 2 );
    }
  
    return bless $self, $class;
  }
  
  sub new {
    my ($class, $struct, $options) = @_;
    my $self = eval { $class->_new($struct, $options) };
    croak($@) if $@;
    return $self;
  }
  
  #pod =method create
  #pod
  #pod   my $meta = CPAN::Meta->create($distmeta_struct, \%options);
  #pod
  #pod This is same as C<new()>, except that C<generated_by> and C<meta-spec> fields
  #pod will be generated if not provided.  This means the metadata structure is
  #pod assumed to otherwise follow the latest L<CPAN::Meta::Spec>.
  #pod
  #pod =cut
  
  sub create {
    my ($class, $struct, $options) = @_;
    my $version = __PACKAGE__->VERSION || 2;
    $struct->{generated_by} ||= __PACKAGE__ . " version $version" ;
    $struct->{'meta-spec'}{version} ||= int($version);
    my $self = eval { $class->_new($struct, $options) };
    croak ($@) if $@;
    return $self;
  }
  
  #pod =method load_file
  #pod
  #pod   my $meta = CPAN::Meta->load_file($distmeta_file, \%options);
  #pod
  #pod Given a pathname to a file containing metadata, this deserializes the file
  #pod according to its file suffix and constructs a new C<CPAN::Meta> object, just
  #pod like C<new()>.  It will die if the deserialized version fails to validate
  #pod against its stated specification version.
  #pod
  #pod It takes the same options as C<new()> but C<lazy_validation> defaults to
  #pod true.
  #pod
  #pod =cut
  
  sub load_file {
    my ($class, $file, $options) = @_;
    $options->{lazy_validation} = 1 unless exists $options->{lazy_validation};
  
    croak "load_file() requires a valid, readable filename"
      unless -r $file;
  
    my $self;
    eval {
      my $struct = Parse::CPAN::Meta->load_file( $file );
      $self = $class->_new($struct, $options);
    };
    croak($@) if $@;
    return $self;
  }
  
  #pod =method load_yaml_string
  #pod
  #pod   my $meta = CPAN::Meta->load_yaml_string($yaml, \%options);
  #pod
  #pod This method returns a new CPAN::Meta object using the first document in the
  #pod given YAML string.  In other respects it is identical to C<load_file()>.
  #pod
  #pod =cut
  
  sub load_yaml_string {
    my ($class, $yaml, $options) = @_;
    $options->{lazy_validation} = 1 unless exists $options->{lazy_validation};
  
    my $self;
    eval {
      my ($struct) = Parse::CPAN::Meta->load_yaml_string( $yaml );
      $self = $class->_new($struct, $options);
    };
    croak($@) if $@;
    return $self;
  }
  
  #pod =method load_json_string
  #pod
  #pod   my $meta = CPAN::Meta->load_json_string($json, \%options);
  #pod
  #pod This method returns a new CPAN::Meta object using the structure represented by
  #pod the given JSON string.  In other respects it is identical to C<load_file()>.
  #pod
  #pod =cut
  
  sub load_json_string {
    my ($class, $json, $options) = @_;
    $options->{lazy_validation} = 1 unless exists $options->{lazy_validation};
  
    my $self;
    eval {
      my $struct = Parse::CPAN::Meta->load_json_string( $json );
      $self = $class->_new($struct, $options);
    };
    croak($@) if $@;
    return $self;
  }
  
  #pod =method load_string
  #pod
  #pod   my $meta = CPAN::Meta->load_string($string, \%options);
  #pod
  #pod If you don't know if a string contains YAML or JSON, this method will use
  #pod L<Parse::CPAN::Meta> to guess.  In other respects it is identical to
  #pod C<load_file()>.
  #pod
  #pod =cut
  
  sub load_string {
    my ($class, $string, $options) = @_;
    $options->{lazy_validation} = 1 unless exists $options->{lazy_validation};
  
    my $self;
    eval {
      my $struct = Parse::CPAN::Meta->load_string( $string );
      $self = $class->_new($struct, $options);
    };
    croak($@) if $@;
    return $self;
  }
  
  #pod =method save
  #pod
  #pod   $meta->save($distmeta_file, \%options);
  #pod
  #pod Serializes the object as JSON and writes it to the given file.  The only valid
  #pod option is C<version>, which defaults to '2'. On Perl 5.8.1 or later, the file
  #pod is saved with UTF-8 encoding.
  #pod
  #pod For C<version> 2 (or higher), the filename should end in '.json'.  L<JSON::PP>
  #pod is the default JSON backend. Using another JSON backend requires L<JSON> 2.5 or
  #pod later and you must set the C<$ENV{PERL_JSON_BACKEND}> to a supported alternate
  #pod backend like L<JSON::XS>.
  #pod
  #pod For C<version> less than 2, the filename should end in '.yml'.
  #pod L<CPAN::Meta::Converter> is used to generate an older metadata structure, which
  #pod is serialized to YAML.  CPAN::Meta::YAML is the default YAML backend.  You may
  #pod set the C<$ENV{PERL_YAML_BACKEND}> to a supported alternative backend, though
  #pod this is not recommended due to subtle incompatibilities between YAML parsers on
  #pod CPAN.
  #pod
  #pod =cut
  
  sub save {
    my ($self, $file, $options) = @_;
  
    my $version = $options->{version} || '2';
    my $layer = $] ge '5.008001' ? ':utf8' : '';
  
    if ( $version ge '2' ) {
      carp "'$file' should end in '.json'"
        unless $file =~ m{\.json$};
    }
    else {
      carp "'$file' should end in '.yml'"
        unless $file =~ m{\.yml$};
    }
  
    my $data = $self->as_string( $options );
    open my $fh, ">$layer", $file
      or die "Error opening '$file' for writing: $!\n";
  
    print {$fh} $data;
    close $fh
      or die "Error closing '$file': $!\n";
  
    return 1;
  }
  
  #pod =method meta_spec_version
  #pod
  #pod This method returns the version part of the C<meta_spec> entry in the distmeta
  #pod structure.  It is equivalent to:
  #pod
  #pod   $meta->meta_spec->{version};
  #pod
  #pod =cut
  
  sub meta_spec_version {
    my ($self) = @_;
    return $self->meta_spec->{version};
  }
  
  #pod =method effective_prereqs
  #pod
  #pod   my $prereqs = $meta->effective_prereqs;
  #pod
  #pod   my $prereqs = $meta->effective_prereqs( \@feature_identifiers );
  #pod
  #pod This method returns a L<CPAN::Meta::Prereqs> object describing all the
  #pod prereqs for the distribution.  If an arrayref of feature identifiers is given,
  #pod the prereqs for the identified features are merged together with the
  #pod distribution's core prereqs before the CPAN::Meta::Prereqs object is returned.
  #pod
  #pod =cut
  
  sub effective_prereqs {
    my ($self, $features) = @_;
    $features ||= [];
  
    my $prereq = CPAN::Meta::Prereqs->new($self->prereqs);
  
    return $prereq unless @$features;
  
    my @other = map {; $self->feature($_)->prereqs } @$features;
  
    return $prereq->with_merged_prereqs(\@other);
  }
  
  #pod =method should_index_file
  #pod
  #pod   ... if $meta->should_index_file( $filename );
  #pod
  #pod This method returns true if the given file should be indexed.  It decides this
  #pod by checking the C<file> and C<directory> keys in the C<no_index> property of
  #pod the distmeta structure. Note that neither the version format nor
  #pod C<release_status> are considered.
  #pod
  #pod C<$filename> should be given in unix format.
  #pod
  #pod =cut
  
  sub should_index_file {
    my ($self, $filename) = @_;
  
    for my $no_index_file (@{ $self->no_index->{file} || [] }) {
      return if $filename eq $no_index_file;
    }
  
    for my $no_index_dir (@{ $self->no_index->{directory} }) {
      $no_index_dir =~ s{$}{/} unless $no_index_dir =~ m{/\z};
      return if index($filename, $no_index_dir) == 0;
    }
  
    return 1;
  }
  
  #pod =method should_index_package
  #pod
  #pod   ... if $meta->should_index_package( $package );
  #pod
  #pod This method returns true if the given package should be indexed.  It decides
  #pod this by checking the C<package> and C<namespace> keys in the C<no_index>
  #pod property of the distmeta structure. Note that neither the version format nor
  #pod C<release_status> are considered.
  #pod
  #pod =cut
  
  sub should_index_package {
    my ($self, $package) = @_;
  
    for my $no_index_pkg (@{ $self->no_index->{package} || [] }) {
      return if $package eq $no_index_pkg;
    }
  
    for my $no_index_ns (@{ $self->no_index->{namespace} }) {
      return if index($package, "${no_index_ns}::") == 0;
    }
  
    return 1;
  }
  
  #pod =method features
  #pod
  #pod   my @feature_objects = $meta->features;
  #pod
  #pod This method returns a list of L<CPAN::Meta::Feature> objects, one for each
  #pod optional feature described by the distribution's metadata.
  #pod
  #pod =cut
  
  sub features {
    my ($self) = @_;
  
    my $opt_f = $self->optional_features;
    my @features = map {; CPAN::Meta::Feature->new($_ => $opt_f->{ $_ }) }
                   keys %$opt_f;
  
    return @features;
  }
  
  #pod =method feature
  #pod
  #pod   my $feature_object = $meta->feature( $identifier );
  #pod
  #pod This method returns a L<CPAN::Meta::Feature> object for the optional feature
  #pod with the given identifier.  If no feature with that identifier exists, an
  #pod exception will be raised.
  #pod
  #pod =cut
  
  sub feature {
    my ($self, $ident) = @_;
  
    croak "no feature named $ident"
      unless my $f = $self->optional_features->{ $ident };
  
    return CPAN::Meta::Feature->new($ident, $f);
  }
  
  #pod =method as_struct
  #pod
  #pod   my $copy = $meta->as_struct( \%options );
  #pod
  #pod This method returns a deep copy of the object's metadata as an unblessed hash
  #pod reference.  It takes an optional hashref of options.  If the hashref contains
  #pod a C<version> argument, the copied metadata will be converted to the version
  #pod of the specification and returned.  For example:
  #pod
  #pod   my $old_spec = $meta->as_struct( {version => "1.4"} );
  #pod
  #pod =cut
  
  sub as_struct {
    my ($self, $options) = @_;
    my $struct = _dclone($self);
    if ( $options->{version} ) {
      my $cmc = CPAN::Meta::Converter->new( $struct );
      $struct = $cmc->convert( version => $options->{version} );
    }
    return $struct;
  }
  
  #pod =method as_string
  #pod
  #pod   my $string = $meta->as_string( \%options );
  #pod
  #pod This method returns a serialized copy of the object's metadata as a character
  #pod string.  (The strings are B<not> UTF-8 encoded.)  It takes an optional hashref
  #pod of options.  If the hashref contains a C<version> argument, the copied metadata
  #pod will be converted to the version of the specification and returned.  For
  #pod example:
  #pod
  #pod   my $string = $meta->as_string( {version => "1.4"} );
  #pod
  #pod For C<version> greater than or equal to 2, the string will be serialized as
  #pod JSON.  For C<version> less than 2, the string will be serialized as YAML.  In
  #pod both cases, the same rules are followed as in the C<save()> method for choosing
  #pod a serialization backend.
  #pod
  #pod The serialized structure will include a C<x_serialization_backend> entry giving
  #pod the package and version used to serialize.  Any existing key in the given
  #pod C<$meta> object will be clobbered.
  #pod
  #pod =cut
  
  sub as_string {
    my ($self, $options) = @_;
  
    my $version = $options->{version} || '2';
  
    my $struct;
    if ( $self->meta_spec_version ne $version ) {
      my $cmc = CPAN::Meta::Converter->new( $self->as_struct );
      $struct = $cmc->convert( version => $version );
    }
    else {
      $struct = $self->as_struct;
    }
  
    my ($data, $backend);
    if ( $version ge '2' ) {
      $backend = Parse::CPAN::Meta->json_backend();
      local $struct->{x_serialization_backend} = sprintf '%s version %s',
        $backend, $backend->VERSION;
      $data = $backend->new->pretty->canonical->encode($struct);
    }
    else {
      $backend = Parse::CPAN::Meta->yaml_backend();
      local $struct->{x_serialization_backend} = sprintf '%s version %s',
        $backend, $backend->VERSION;
      $data = eval { no strict 'refs'; &{"$backend\::Dump"}($struct) };
      if ( $@ ) {
        croak $backend->can('errstr') ? $backend->errstr : $@
      }
    }
  
    return $data;
  }
  
  # Used by JSON::PP, etc. for "convert_blessed"
  sub TO_JSON {
    return { %{ $_[0] } };
  }
  
  1;
  
  # ABSTRACT: the distribution metadata for a CPAN dist
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta - the distribution metadata for a CPAN dist
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 SYNOPSIS
  
      use v5.10;
      use strict;
      use warnings;
      use CPAN::Meta;
      use Module::Load;
  
      my $meta = CPAN::Meta->load_file('META.json');
  
      printf "testing requirements for %s version %s\n",
      $meta->name,
      $meta->version;
  
      my $prereqs = $meta->effective_prereqs;
  
      for my $phase ( qw/configure runtime build test/ ) {
          say "Requirements for $phase:";
          my $reqs = $prereqs->requirements_for($phase, "requires");
          for my $module ( sort $reqs->required_modules ) {
              my $status;
              if ( eval { load $module unless $module eq 'perl'; 1 } ) {
                  my $version = $module eq 'perl' ? $] : $module->VERSION;
                  $status = $reqs->accepts_module($module, $version)
                          ? "$version ok" : "$version not ok";
              } else {
                  $status = "missing"
              };
              say "  $module ($status)";
          }
      }
  
  =head1 DESCRIPTION
  
  Software distributions released to the CPAN include a F<META.json> or, for
  older distributions, F<META.yml>, which describes the distribution, its
  contents, and the requirements for building and installing the distribution.
  The data structure stored in the F<META.json> file is described in
  L<CPAN::Meta::Spec>.
  
  CPAN::Meta provides a simple class to represent this distribution metadata (or
  I<distmeta>), along with some helpful methods for interrogating that data.
  
  The documentation below is only for the methods of the CPAN::Meta object.  For
  information on the meaning of individual fields, consult the spec.
  
  =head1 METHODS
  
  =head2 new
  
    my $meta = CPAN::Meta->new($distmeta_struct, \%options);
  
  Returns a valid CPAN::Meta object or dies if the supplied metadata hash
  reference fails to validate.  Older-format metadata will be up-converted to
  version 2 if they validate against the original stated specification.
  
  It takes an optional hashref of options. Valid options include:
  
  =over
  
  =item *
  
  lazy_validation -- if true, new will attempt to convert the given metadata
  to version 2 before attempting to validate it.  This means than any
  fixable errors will be handled by CPAN::Meta::Converter before validation.
  (Note that this might result in invalid optional data being silently
  dropped.)  The default is false.
  
  =back
  
  =head2 create
  
    my $meta = CPAN::Meta->create($distmeta_struct, \%options);
  
  This is same as C<new()>, except that C<generated_by> and C<meta-spec> fields
  will be generated if not provided.  This means the metadata structure is
  assumed to otherwise follow the latest L<CPAN::Meta::Spec>.
  
  =head2 load_file
  
    my $meta = CPAN::Meta->load_file($distmeta_file, \%options);
  
  Given a pathname to a file containing metadata, this deserializes the file
  according to its file suffix and constructs a new C<CPAN::Meta> object, just
  like C<new()>.  It will die if the deserialized version fails to validate
  against its stated specification version.
  
  It takes the same options as C<new()> but C<lazy_validation> defaults to
  true.
  
  =head2 load_yaml_string
  
    my $meta = CPAN::Meta->load_yaml_string($yaml, \%options);
  
  This method returns a new CPAN::Meta object using the first document in the
  given YAML string.  In other respects it is identical to C<load_file()>.
  
  =head2 load_json_string
  
    my $meta = CPAN::Meta->load_json_string($json, \%options);
  
  This method returns a new CPAN::Meta object using the structure represented by
  the given JSON string.  In other respects it is identical to C<load_file()>.
  
  =head2 load_string
  
    my $meta = CPAN::Meta->load_string($string, \%options);
  
  If you don't know if a string contains YAML or JSON, this method will use
  L<Parse::CPAN::Meta> to guess.  In other respects it is identical to
  C<load_file()>.
  
  =head2 save
  
    $meta->save($distmeta_file, \%options);
  
  Serializes the object as JSON and writes it to the given file.  The only valid
  option is C<version>, which defaults to '2'. On Perl 5.8.1 or later, the file
  is saved with UTF-8 encoding.
  
  For C<version> 2 (or higher), the filename should end in '.json'.  L<JSON::PP>
  is the default JSON backend. Using another JSON backend requires L<JSON> 2.5 or
  later and you must set the C<$ENV{PERL_JSON_BACKEND}> to a supported alternate
  backend like L<JSON::XS>.
  
  For C<version> less than 2, the filename should end in '.yml'.
  L<CPAN::Meta::Converter> is used to generate an older metadata structure, which
  is serialized to YAML.  CPAN::Meta::YAML is the default YAML backend.  You may
  set the C<$ENV{PERL_YAML_BACKEND}> to a supported alternative backend, though
  this is not recommended due to subtle incompatibilities between YAML parsers on
  CPAN.
  
  =head2 meta_spec_version
  
  This method returns the version part of the C<meta_spec> entry in the distmeta
  structure.  It is equivalent to:
  
    $meta->meta_spec->{version};
  
  =head2 effective_prereqs
  
    my $prereqs = $meta->effective_prereqs;
  
    my $prereqs = $meta->effective_prereqs( \@feature_identifiers );
  
  This method returns a L<CPAN::Meta::Prereqs> object describing all the
  prereqs for the distribution.  If an arrayref of feature identifiers is given,
  the prereqs for the identified features are merged together with the
  distribution's core prereqs before the CPAN::Meta::Prereqs object is returned.
  
  =head2 should_index_file
  
    ... if $meta->should_index_file( $filename );
  
  This method returns true if the given file should be indexed.  It decides this
  by checking the C<file> and C<directory> keys in the C<no_index> property of
  the distmeta structure. Note that neither the version format nor
  C<release_status> are considered.
  
  C<$filename> should be given in unix format.
  
  =head2 should_index_package
  
    ... if $meta->should_index_package( $package );
  
  This method returns true if the given package should be indexed.  It decides
  this by checking the C<package> and C<namespace> keys in the C<no_index>
  property of the distmeta structure. Note that neither the version format nor
  C<release_status> are considered.
  
  =head2 features
  
    my @feature_objects = $meta->features;
  
  This method returns a list of L<CPAN::Meta::Feature> objects, one for each
  optional feature described by the distribution's metadata.
  
  =head2 feature
  
    my $feature_object = $meta->feature( $identifier );
  
  This method returns a L<CPAN::Meta::Feature> object for the optional feature
  with the given identifier.  If no feature with that identifier exists, an
  exception will be raised.
  
  =head2 as_struct
  
    my $copy = $meta->as_struct( \%options );
  
  This method returns a deep copy of the object's metadata as an unblessed hash
  reference.  It takes an optional hashref of options.  If the hashref contains
  a C<version> argument, the copied metadata will be converted to the version
  of the specification and returned.  For example:
  
    my $old_spec = $meta->as_struct( {version => "1.4"} );
  
  =head2 as_string
  
    my $string = $meta->as_string( \%options );
  
  This method returns a serialized copy of the object's metadata as a character
  string.  (The strings are B<not> UTF-8 encoded.)  It takes an optional hashref
  of options.  If the hashref contains a C<version> argument, the copied metadata
  will be converted to the version of the specification and returned.  For
  example:
  
    my $string = $meta->as_string( {version => "1.4"} );
  
  For C<version> greater than or equal to 2, the string will be serialized as
  JSON.  For C<version> less than 2, the string will be serialized as YAML.  In
  both cases, the same rules are followed as in the C<save()> method for choosing
  a serialization backend.
  
  The serialized structure will include a C<x_serialization_backend> entry giving
  the package and version used to serialize.  Any existing key in the given
  C<$meta> object will be clobbered.
  
  =head1 STRING DATA
  
  The following methods return a single value, which is the value for the
  corresponding entry in the distmeta structure.  Values should be either undef
  or strings.
  
  =over 4
  
  =item *
  
  abstract
  
  =item *
  
  description
  
  =item *
  
  dynamic_config
  
  =item *
  
  generated_by
  
  =item *
  
  name
  
  =item *
  
  release_status
  
  =item *
  
  version
  
  =back
  
  =head1 LIST DATA
  
  These methods return lists of string values, which might be represented in the
  distmeta structure as arrayrefs or scalars:
  
  =over 4
  
  =item *
  
  authors
  
  =item *
  
  keywords
  
  =item *
  
  licenses
  
  =back
  
  The C<authors> and C<licenses> methods may also be called as C<author> and
  C<license>, respectively, to match the field name in the distmeta structure.
  
  =head1 MAP DATA
  
  These readers return hashrefs of arbitrary unblessed data structures, each
  described more fully in the specification:
  
  =over 4
  
  =item *
  
  meta_spec
  
  =item *
  
  resources
  
  =item *
  
  provides
  
  =item *
  
  no_index
  
  =item *
  
  prereqs
  
  =item *
  
  optional_features
  
  =back
  
  =head1 CUSTOM DATA
  
  A list of custom keys are available from the C<custom_keys> method and
  particular keys may be retrieved with the C<custom> method.
  
    say $meta->custom($_) for $meta->custom_keys;
  
  If a custom key refers to a data structure, a deep clone is returned.
  
  =for Pod::Coverage TO_JSON abstract author authors custom custom_keys description dynamic_config
  generated_by keywords license licenses meta_spec name no_index
  optional_features prereqs provides release_status resources version
  
  =head1 BUGS
  
  Please report any bugs or feature using the CPAN Request Tracker.
  Bugs can be submitted through the web interface at
  L<http://rt.cpan.org/Dist/Display.html?Queue=CPAN-Meta>
  
  When submitting a bug or request, please include a test-file or a patch to an
  existing test-file that illustrates the bug or desired feature.
  
  =head1 SEE ALSO
  
  =over 4
  
  =item *
  
  L<CPAN::Meta::Converter>
  
  =item *
  
  L<CPAN::Meta::Validator>
  
  =back
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/Perl-Toolchain-Gang/CPAN-Meta/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/Perl-Toolchain-Gang/CPAN-Meta>
  
    git clone https://github.com/Perl-Toolchain-Gang/CPAN-Meta.git
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 CONTRIBUTORS
  
  =for stopwords Ansgar Burchardt Avar Arnfjord Bjarmason Benjamin Noggle Christopher J. Madsen Chuck Adams Cory G Watson Damyan Ivanov David Golden Eric Wilhelm Graham Knop Gregor Hermann Karen Etheridge Kenichi Ishigaki Kent Fredric Ken Williams Lars Dieckow Leon Timmermans majensen Mark Fowler Matt S Trout Michael G. Schwern Mohammad Anwar mohawk2 moznion Niko Tyni Olaf Alders Olivier Mengué Randy Sims Tomohiro Hosaka
  
  =over 4
  
  =item *
  
  Ansgar Burchardt <ansgar@cpan.org>
  
  =item *
  
  Avar Arnfjord Bjarmason <avar@cpan.org>
  
  =item *
  
  Benjamin Noggle <agwind@users.noreply.github.com>
  
  =item *
  
  Christopher J. Madsen <cjm@cpan.org>
  
  =item *
  
  Chuck Adams <cja987@gmail.com>
  
  =item *
  
  Cory G Watson <gphat@cpan.org>
  
  =item *
  
  Damyan Ivanov <dam@cpan.org>
  
  =item *
  
  David Golden <xdg@xdg.me>
  
  =item *
  
  Eric Wilhelm <ewilhelm@cpan.org>
  
  =item *
  
  Graham Knop <haarg@haarg.org>
  
  =item *
  
  Gregor Hermann <gregoa@debian.org>
  
  =item *
  
  Karen Etheridge <ether@cpan.org>
  
  =item *
  
  Kenichi Ishigaki <ishigaki@cpan.org>
  
  =item *
  
  Kent Fredric <kentfredric@gmail.com>
  
  =item *
  
  Ken Williams <kwilliams@cpan.org>
  
  =item *
  
  Lars Dieckow <daxim@cpan.org>
  
  =item *
  
  Leon Timmermans <leont@cpan.org>
  
  =item *
  
  majensen <maj@fortinbras.us>
  
  =item *
  
  Mark Fowler <markf@cpan.org>
  
  =item *
  
  Matt S Trout <mst@shadowcat.co.uk>
  
  =item *
  
  Michael G. Schwern <mschwern@cpan.org>
  
  =item *
  
  Mohammad S Anwar <mohammad.anwar@yahoo.com>
  
  =item *
  
  mohawk2 <mohawk2@users.noreply.github.com>
  
  =item *
  
  moznion <moznion@gmail.com>
  
  =item *
  
  Niko Tyni <ntyni@debian.org>
  
  =item *
  
  Olaf Alders <olaf@wundersolutions.com>
  
  =item *
  
  Olivier Mengué <dolmen@cpan.org>
  
  =item *
  
  Randy Sims <randys@thepierianspring.org>
  
  =item *
  
  Tomohiro Hosaka <bokutin@bokut.in>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # vim: ts=2 sts=2 sw=2 et :
CPAN_META

$fatpacked{"CPAN/Meta/Check.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_CHECK';
  package CPAN::Meta::Check;
  $CPAN::Meta::Check::VERSION = '0.014';
  use strict;
  use warnings;
  
  use base 'Exporter';
  our @EXPORT = qw//;
  our @EXPORT_OK = qw/check_requirements requirements_for verify_dependencies/;
  our %EXPORT_TAGS = (all => [ @EXPORT, @EXPORT_OK ] );
  
  use CPAN::Meta::Prereqs '2.132830';
  use CPAN::Meta::Requirements 2.121;
  use Module::Metadata 1.000023;
  
  sub _check_dep {
  	my ($reqs, $module, $dirs) = @_;
  
  	$module eq 'perl' and return ($reqs->accepts_module($module, $]) ? () : sprintf "Your Perl (%s) is not in the range '%s'", $], $reqs->requirements_for_module($module));
  
  	my $metadata = Module::Metadata->new_from_module($module, inc => $dirs);
  	return "Module '$module' is not installed" if not defined $metadata;
  
  	my $version = eval { $metadata->version };
  	return sprintf 'Installed version (%s) of %s is not in range \'%s\'',
  			(defined $version ? $version : 'undef'), $module, $reqs->requirements_for_module($module)
  		if not $reqs->accepts_module($module, $version || 0);
  	return;
  }
  
  sub _check_conflict {
  	my ($reqs, $module, $dirs) = @_;
  	my $metadata = Module::Metadata->new_from_module($module, inc => $dirs);
  	return if not defined $metadata;
  
  	my $version = eval { $metadata->version };
  	return sprintf 'Installed version (%s) of %s is in range \'%s\'',
  			(defined $version ? $version : 'undef'), $module, $reqs->requirements_for_module($module)
  		if $reqs->accepts_module($module, $version);
  	return;
  }
  
  sub requirements_for {
  	my ($meta, $phases, $type) = @_;
  	my $prereqs = ref($meta) eq 'CPAN::Meta' ? $meta->effective_prereqs : $meta;
  	return $prereqs->merged_requirements(ref($phases) ? $phases : [ $phases ], [ $type ]);
  }
  
  sub check_requirements {
  	my ($reqs, $type, $dirs) = @_;
  
  	return +{
  		map {
  			$_ => $type ne 'conflicts'
  				? scalar _check_dep($reqs, $_, $dirs)
  				: scalar _check_conflict($reqs, $_, $dirs)
  		} $reqs->required_modules
  	};
  }
  
  sub verify_dependencies {
  	my ($meta, $phases, $type, $dirs) = @_;
  	my $reqs = requirements_for($meta, $phases, $type);
  	my $issues = check_requirements($reqs, $type, $dirs);
  	return grep { defined } values %{ $issues };
  }
  
  1;
  
  #ABSTRACT: Verify requirements in a CPAN::Meta object
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Check - Verify requirements in a CPAN::Meta object
  
  =head1 VERSION
  
  version 0.014
  
  =head1 SYNOPSIS
  
   warn "$_\n" for verify_dependencies($meta, [qw/runtime build test/], 'requires');
  
  =head1 DESCRIPTION
  
  This module verifies if requirements described in a CPAN::Meta object are present.
  
  =head1 FUNCTIONS
  
  =head2 check_requirements($reqs, $type, $incdirs)
  
  This function checks if all dependencies in C<$reqs> (a L<CPAN::Meta::Requirements|CPAN::Meta::Requirements> object) are met, taking into account that 'conflicts' dependencies have to be checked in reverse. It returns a hash with the modules as keys and any problems as values; the value for a successfully found module will be undef. Modules are searched for in C<@$incdirs>, defaulting to C<@INC>.
  
  =head2 verify_dependencies($meta, $phases, $types, $incdirs)
  
  Check all requirements in C<$meta> for phases C<$phases> and type C<$type>. Modules are searched for in C<@$incdirs>, defaulting to C<@INC>. C<$meta> should be a L<CPAN::Meta::Prereqs> or L<CPAN::Meta> object.
  
  =head2 requirements_for($meta, $phases, $types)
  
  B<< This function is deprecated and may be removed at some point in the future, please use CPAN::Meta::Prereqs->merged_requirements instead. >>
  
  This function returns a unified L<CPAN::Meta::Requirements|CPAN::Meta::Requirements> object for all C<$type> requirements for C<$phases>. C<$phases> may be either one (scalar) value or an arrayref of valid values as defined by the L<CPAN::Meta spec|CPAN::Meta::Spec>. C<$type> must be a relationship as defined by the same spec. C<$meta> should be a L<CPAN::Meta::Prereqs> or L<CPAN::Meta> object.
  
  =head1 SEE ALSO
  
  =over 4
  
  =item * L<Test::CheckDeps|Test::CheckDeps>
  
  =item * L<CPAN::Meta|CPAN::Meta>
  
  =for comment # vi:noet:sts=2:sw=2:ts=2
  
  =back
  
  =head1 AUTHOR
  
  Leon Timmermans <leont@cpan.org>
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2012 by Leon Timmermans.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
CPAN_META_CHECK

$fatpacked{"CPAN/Meta/Converter.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_CONVERTER';
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::Converter;
  
  our $VERSION = '2.150010';
  
  #pod =head1 SYNOPSIS
  #pod
  #pod   my $struct = decode_json_file('META.json');
  #pod
  #pod   my $cmc = CPAN::Meta::Converter->new( $struct );
  #pod
  #pod   my $new_struct = $cmc->convert( version => "2" );
  #pod
  #pod =head1 DESCRIPTION
  #pod
  #pod This module converts CPAN Meta structures from one form to another.  The
  #pod primary use is to convert older structures to the most modern version of
  #pod the specification, but other transformations may be implemented in the
  #pod future as needed.  (E.g. stripping all custom fields or stripping all
  #pod optional fields.)
  #pod
  #pod =cut
  
  use CPAN::Meta::Validator;
  use CPAN::Meta::Requirements;
  use Parse::CPAN::Meta 1.4400 ();
  
  # To help ExtUtils::MakeMaker bootstrap CPAN::Meta::Requirements on perls
  # before 5.10, we fall back to the EUMM bundled compatibility version module if
  # that's the only thing available.  This shouldn't ever happen in a normal CPAN
  # install of CPAN::Meta::Requirements, as version.pm will be picked up from
  # prereqs and be available at runtime.
  
  BEGIN {
    eval "use version ()"; ## no critic
    if ( my $err = $@ ) {
      eval "use ExtUtils::MakeMaker::version" or die $err; ## no critic
    }
  }
  
  # Perl 5.10.0 didn't have "is_qv" in version.pm
  *_is_qv = version->can('is_qv') ? sub { $_[0]->is_qv } : sub { exists $_[0]->{qv} };
  
  # We limit cloning to a maximum depth to bail out on circular data
  # structures.  While actual cycle detection might be technically better,
  # we expect circularity in META data structures to be rare and generally
  # the result of user error.  Therefore, a depth counter is lower overhead.
  our $DCLONE_MAXDEPTH = 1024;
  our $_CLONE_DEPTH;
  
  sub _dclone {
    my ( $ref  ) = @_;
    return $ref unless my $reftype = ref $ref;
  
    local $_CLONE_DEPTH = defined $_CLONE_DEPTH ? $_CLONE_DEPTH - 1 : $DCLONE_MAXDEPTH;
    die "Depth Limit $DCLONE_MAXDEPTH Exceeded" if $_CLONE_DEPTH == 0;
  
    return [ map { _dclone( $_ ) } @{$ref} ] if 'ARRAY' eq $reftype;
    return { map { $_ => _dclone( $ref->{$_} ) } keys %{$ref} } if 'HASH' eq $reftype;
  
    if ( 'SCALAR' eq $reftype ) {
      my $new = _dclone(${$ref});
      return \$new;
    }
  
    # We can't know if TO_JSON gives us cloned data, so refs must recurse
    if ( eval { $ref->can('TO_JSON') } ) {
      my $data = $ref->TO_JSON;
      return ref $data ? _dclone( $data ) : $data;
    }
  
    # Just stringify everything else
    return "$ref";
  }
  
  my %known_specs = (
      '2'   => 'http://search.cpan.org/perldoc?CPAN::Meta::Spec',
      '1.4' => 'http://module-build.sourceforge.net/META-spec-v1.4.html',
      '1.3' => 'http://module-build.sourceforge.net/META-spec-v1.3.html',
      '1.2' => 'http://module-build.sourceforge.net/META-spec-v1.2.html',
      '1.1' => 'http://module-build.sourceforge.net/META-spec-v1.1.html',
      '1.0' => 'http://module-build.sourceforge.net/META-spec-v1.0.html'
  );
  
  my @spec_list = sort { $a <=> $b } keys %known_specs;
  my ($LOWEST, $HIGHEST) = @spec_list[0,-1];
  
  #--------------------------------------------------------------------------#
  # converters
  #
  # called as $converter->($element, $field_name, $full_meta, $to_version)
  #
  # defined return value used for field
  # undef return value means field is skipped
  #--------------------------------------------------------------------------#
  
  sub _keep { $_[0] }
  
  sub _keep_or_one { defined($_[0]) ? $_[0] : 1 }
  
  sub _keep_or_zero { defined($_[0]) ? $_[0] : 0 }
  
  sub _keep_or_unknown { defined($_[0]) && length($_[0]) ? $_[0] : "unknown" }
  
  sub _generated_by {
    my $gen = shift;
    my $sig = __PACKAGE__ . " version " . (__PACKAGE__->VERSION || "<dev>");
  
    return $sig unless defined $gen and length $gen;
    return $gen if $gen =~ /\Q$sig/;
    return "$gen, $sig";
  }
  
  sub _listify { ! defined $_[0] ? undef : ref $_[0] eq 'ARRAY' ? $_[0] : [$_[0]] }
  
  sub _prefix_custom {
    my $key = shift;
    $key =~ s/^(?!x_)   # Unless it already starts with x_
               (?:x-?)? # Remove leading x- or x (if present)
             /x_/ix;    # and prepend x_
    return $key;
  }
  
  sub _ucfirst_custom {
    my $key = shift;
    $key = ucfirst $key unless $key =~ /[A-Z]/;
    return $key;
  }
  
  sub _no_prefix_ucfirst_custom {
    my $key = shift;
    $key =~ s/^x_//;
    return _ucfirst_custom($key);
  }
  
  sub _change_meta_spec {
    my ($element, undef, undef, $version) = @_;
    return {
      version => $version,
      url => $known_specs{$version},
    };
  }
  
  my @open_source = (
    'perl',
    'gpl',
    'apache',
    'artistic',
    'artistic_2',
    'lgpl',
    'bsd',
    'gpl',
    'mit',
    'mozilla',
    'open_source',
  );
  
  my %is_open_source = map {; $_ => 1 } @open_source;
  
  my @valid_licenses_1 = (
    @open_source,
    'unrestricted',
    'restrictive',
    'unknown',
  );
  
  my %license_map_1 = (
    ( map { $_ => $_ } @valid_licenses_1 ),
    artistic2 => 'artistic_2',
  );
  
  sub _license_1 {
    my ($element) = @_;
    return 'unknown' unless defined $element;
    if ( $license_map_1{lc $element} ) {
      return $license_map_1{lc $element};
    }
    else {
      return 'unknown';
    }
  }
  
  my @valid_licenses_2 = qw(
    agpl_3
    apache_1_1
    apache_2_0
    artistic_1
    artistic_2
    bsd
    freebsd
    gfdl_1_2
    gfdl_1_3
    gpl_1
    gpl_2
    gpl_3
    lgpl_2_1
    lgpl_3_0
    mit
    mozilla_1_0
    mozilla_1_1
    openssl
    perl_5
    qpl_1_0
    ssleay
    sun
    zlib
    open_source
    restricted
    unrestricted
    unknown
  );
  
  # The "old" values were defined by Module::Build, and were often vague.  I have
  # made the decisions below based on reading Module::Build::API and how clearly
  # it specifies the version of the license.
  my %license_map_2 = (
    (map { $_ => $_ } @valid_licenses_2),
    apache      => 'apache_2_0',  # clearly stated as 2.0
    artistic    => 'artistic_1',  # clearly stated as 1
    artistic2   => 'artistic_2',  # clearly stated as 2
    gpl         => 'open_source', # we don't know which GPL; punt
    lgpl        => 'open_source', # we don't know which LGPL; punt
    mozilla     => 'open_source', # we don't know which MPL; punt
    perl        => 'perl_5',      # clearly Perl 5
    restrictive => 'restricted',
  );
  
  sub _license_2 {
    my ($element) = @_;
    return [ 'unknown' ] unless defined $element;
    $element = [ $element ] unless ref $element eq 'ARRAY';
    my @new_list;
    for my $lic ( @$element ) {
      next unless defined $lic;
      if ( my $new = $license_map_2{lc $lic} ) {
        push @new_list, $new;
      }
    }
    return @new_list ? \@new_list : [ 'unknown' ];
  }
  
  my %license_downgrade_map = qw(
    agpl_3            open_source
    apache_1_1        apache
    apache_2_0        apache
    artistic_1        artistic
    artistic_2        artistic_2
    bsd               bsd
    freebsd           open_source
    gfdl_1_2          open_source
    gfdl_1_3          open_source
    gpl_1             gpl
    gpl_2             gpl
    gpl_3             gpl
    lgpl_2_1          lgpl
    lgpl_3_0          lgpl
    mit               mit
    mozilla_1_0       mozilla
    mozilla_1_1       mozilla
    openssl           open_source
    perl_5            perl
    qpl_1_0           open_source
    ssleay            open_source
    sun               open_source
    zlib              open_source
    open_source       open_source
    restricted        restrictive
    unrestricted      unrestricted
    unknown           unknown
  );
  
  sub _downgrade_license {
    my ($element) = @_;
    if ( ! defined $element ) {
      return "unknown";
    }
    elsif( ref $element eq 'ARRAY' ) {
      if ( @$element > 1) {
        if (grep { !$is_open_source{ $license_downgrade_map{lc $_} || 'unknown' } } @$element) {
          return 'unknown';
        }
        else {
          return 'open_source';
        }
      }
      elsif ( @$element == 1 ) {
        return $license_downgrade_map{lc $element->[0]} || "unknown";
      }
    }
    elsif ( ! ref $element ) {
      return $license_downgrade_map{lc $element} || "unknown";
    }
    return "unknown";
  }
  
  my $no_index_spec_1_2 = {
    'file' => \&_listify,
    'dir' => \&_listify,
    'package' => \&_listify,
    'namespace' => \&_listify,
  };
  
  my $no_index_spec_1_3 = {
    'file' => \&_listify,
    'directory' => \&_listify,
    'package' => \&_listify,
    'namespace' => \&_listify,
  };
  
  my $no_index_spec_2 = {
    'file' => \&_listify,
    'directory' => \&_listify,
    'package' => \&_listify,
    'namespace' => \&_listify,
    ':custom'  => \&_prefix_custom,
  };
  
  sub _no_index_1_2 {
    my (undef, undef, $meta) = @_;
    my $no_index = $meta->{no_index} || $meta->{private};
    return unless $no_index;
  
    # cleanup wrong format
    if ( ! ref $no_index ) {
      my $item = $no_index;
      $no_index = { dir => [ $item ], file => [ $item ] };
    }
    elsif ( ref $no_index eq 'ARRAY' ) {
      my $list = $no_index;
      $no_index = { dir => [ @$list ], file => [ @$list ] };
    }
  
    # common mistake: files -> file
    if ( exists $no_index->{files} ) {
      $no_index->{file} = delete $no_index->{files};
    }
    # common mistake: modules -> module
    if ( exists $no_index->{modules} ) {
      $no_index->{module} = delete $no_index->{modules};
    }
    return _convert($no_index, $no_index_spec_1_2);
  }
  
  sub _no_index_directory {
    my ($element, $key, $meta, $version) = @_;
    return unless $element;
  
    # clean up wrong format
    if ( ! ref $element ) {
      my $item = $element;
      $element = { directory => [ $item ], file => [ $item ] };
    }
    elsif ( ref $element eq 'ARRAY' ) {
      my $list = $element;
      $element = { directory => [ @$list ], file => [ @$list ] };
    }
  
    if ( exists $element->{dir} ) {
      $element->{directory} = delete $element->{dir};
    }
    # common mistake: files -> file
    if ( exists $element->{files} ) {
      $element->{file} = delete $element->{files};
    }
    # common mistake: modules -> module
    if ( exists $element->{modules} ) {
      $element->{module} = delete $element->{modules};
    }
    my $spec = $version == 2 ? $no_index_spec_2 : $no_index_spec_1_3;
    return _convert($element, $spec);
  }
  
  sub _is_module_name {
    my $mod = shift;
    return unless defined $mod && length $mod;
    return $mod =~ m{^[A-Za-z][A-Za-z0-9_]*(?:::[A-Za-z0-9_]+)*$};
  }
  
  sub _clean_version {
    my ($element) = @_;
    return 0 if ! defined $element;
  
    $element =~ s{^\s*}{};
    $element =~ s{\s*$}{};
    $element =~ s{^\.}{0.};
  
    return 0 if ! length $element;
    return 0 if ( $element eq 'undef' || $element eq '<undef>' );
  
    my $v = eval { version->new($element) };
    # XXX check defined $v and not just $v because version objects leak memory
    # in boolean context -- dagolden, 2012-02-03
    if ( defined $v ) {
      return _is_qv($v) ? $v->normal : $element;
    }
    else {
      return 0;
    }
  }
  
  sub _bad_version_hook {
    my ($v) = @_;
    $v =~ s{^\s*}{};
    $v =~ s{\s*$}{};
    $v =~ s{[a-z]+$}{}; # strip trailing alphabetics
    my $vobj = eval { version->new($v) };
    return defined($vobj) ? $vobj : version->new(0); # or give up
  }
  
  sub _version_map {
    my ($element) = @_;
    return unless defined $element;
    if ( ref $element eq 'HASH' ) {
      # XXX turn this into CPAN::Meta::Requirements with bad version hook
      # and then turn it back into a hash
      my $new_map = CPAN::Meta::Requirements->new(
        { bad_version_hook => \&_bad_version_hook } # punt
      );
      while ( my ($k,$v) = each %$element ) {
        next unless _is_module_name($k);
        if ( !defined($v) || !length($v) || $v eq 'undef' || $v eq '<undef>'  ) {
          $v = 0;
        }
        # some weird, old META have bad yml with module => module
        # so check if value is like a module name and not like a version
        if ( _is_module_name($v) && ! version::is_lax($v) ) {
          $new_map->add_minimum($k => 0);
          $new_map->add_minimum($v => 0);
        }
        $new_map->add_string_requirement($k => $v);
      }
      return $new_map->as_string_hash;
    }
    elsif ( ref $element eq 'ARRAY' ) {
      my $hashref = { map { $_ => 0 } @$element };
      return _version_map($hashref); # clean up any weird stuff
    }
    elsif ( ref $element eq '' && length $element ) {
      return { $element => 0 }
    }
    return;
  }
  
  sub _prereqs_from_1 {
    my (undef, undef, $meta) = @_;
    my $prereqs = {};
    for my $phase ( qw/build configure/ ) {
      my $key = "${phase}_requires";
      $prereqs->{$phase}{requires} = _version_map($meta->{$key})
        if $meta->{$key};
    }
    for my $rel ( qw/requires recommends conflicts/ ) {
      $prereqs->{runtime}{$rel} = _version_map($meta->{$rel})
        if $meta->{$rel};
    }
    return $prereqs;
  }
  
  my $prereqs_spec = {
    configure => \&_prereqs_rel,
    build     => \&_prereqs_rel,
    test      => \&_prereqs_rel,
    runtime   => \&_prereqs_rel,
    develop   => \&_prereqs_rel,
    ':custom'  => \&_prefix_custom,
  };
  
  my $relation_spec = {
    requires   => \&_version_map,
    recommends => \&_version_map,
    suggests   => \&_version_map,
    conflicts  => \&_version_map,
    ':custom'  => \&_prefix_custom,
  };
  
  sub _cleanup_prereqs {
    my ($prereqs, $key, $meta, $to_version) = @_;
    return unless $prereqs && ref $prereqs eq 'HASH';
    return _convert( $prereqs, $prereqs_spec, $to_version );
  }
  
  sub _prereqs_rel {
    my ($relation, $key, $meta, $to_version) = @_;
    return unless $relation && ref $relation eq 'HASH';
    return _convert( $relation, $relation_spec, $to_version );
  }
  
  
  BEGIN {
    my @old_prereqs = qw(
      requires
      configure_requires
      recommends
      conflicts
    );
  
    for ( @old_prereqs ) {
      my $sub = "_get_$_";
      my ($phase,$type) = split qr/_/, $_;
      if ( ! defined $type ) {
        $type = $phase;
        $phase = 'runtime';
      }
      no strict 'refs';
      *{$sub} = sub { _extract_prereqs($_[2]->{prereqs},$phase,$type) };
    }
  }
  
  sub _get_build_requires {
    my ($data, $key, $meta) = @_;
  
    my $test_h  = _extract_prereqs($_[2]->{prereqs}, qw(test  requires)) || {};
    my $build_h = _extract_prereqs($_[2]->{prereqs}, qw(build requires)) || {};
  
    my $test_req  = CPAN::Meta::Requirements->from_string_hash($test_h);
    my $build_req = CPAN::Meta::Requirements->from_string_hash($build_h);
  
    $test_req->add_requirements($build_req)->as_string_hash;
  }
  
  sub _extract_prereqs {
    my ($prereqs, $phase, $type) = @_;
    return unless ref $prereqs eq 'HASH';
    return scalar _version_map($prereqs->{$phase}{$type});
  }
  
  sub _downgrade_optional_features {
    my (undef, undef, $meta) = @_;
    return unless exists $meta->{optional_features};
    my $origin = $meta->{optional_features};
    my $features = {};
    for my $name ( keys %$origin ) {
      $features->{$name} = {
        description => $origin->{$name}{description},
        requires => _extract_prereqs($origin->{$name}{prereqs},'runtime','requires'),
        configure_requires => _extract_prereqs($origin->{$name}{prereqs},'runtime','configure_requires'),
        build_requires => _extract_prereqs($origin->{$name}{prereqs},'runtime','build_requires'),
        recommends => _extract_prereqs($origin->{$name}{prereqs},'runtime','recommends'),
        conflicts => _extract_prereqs($origin->{$name}{prereqs},'runtime','conflicts'),
      };
      for my $k (keys %{$features->{$name}} ) {
        delete $features->{$name}{$k} unless defined $features->{$name}{$k};
      }
    }
    return $features;
  }
  
  sub _upgrade_optional_features {
    my (undef, undef, $meta) = @_;
    return unless exists $meta->{optional_features};
    my $origin = $meta->{optional_features};
    my $features = {};
    for my $name ( keys %$origin ) {
      $features->{$name} = {
        description => $origin->{$name}{description},
        prereqs => _prereqs_from_1(undef, undef, $origin->{$name}),
      };
      delete $features->{$name}{prereqs}{configure};
    }
    return $features;
  }
  
  my $optional_features_2_spec = {
    description => \&_keep,
    prereqs => \&_cleanup_prereqs,
    ':custom'  => \&_prefix_custom,
  };
  
  sub _feature_2 {
    my ($element, $key, $meta, $to_version) = @_;
    return unless $element && ref $element eq 'HASH';
    _convert( $element, $optional_features_2_spec, $to_version );
  }
  
  sub _cleanup_optional_features_2 {
    my ($element, $key, $meta, $to_version) = @_;
    return unless $element && ref $element eq 'HASH';
    my $new_data = {};
    for my $k ( keys %$element ) {
      $new_data->{$k} = _feature_2( $element->{$k}, $k, $meta, $to_version );
    }
    return unless keys %$new_data;
    return $new_data;
  }
  
  sub _optional_features_1_4 {
    my ($element) = @_;
    return unless $element;
    $element = _optional_features_as_map($element);
    for my $name ( keys %$element ) {
      for my $drop ( qw/requires_packages requires_os excluded_os/ ) {
        delete $element->{$name}{$drop};
      }
    }
    return $element;
  }
  
  sub _optional_features_as_map {
    my ($element) = @_;
    return unless $element;
    if ( ref $element eq 'ARRAY' ) {
      my %map;
      for my $feature ( @$element ) {
        my (@parts) = %$feature;
        $map{$parts[0]} = $parts[1];
      }
      $element = \%map;
    }
    return $element;
  }
  
  sub _is_urlish { defined $_[0] && $_[0] =~ m{\A[-+.a-z0-9]+:.+}i }
  
  sub _url_or_drop {
    my ($element) = @_;
    return $element if _is_urlish($element);
    return;
  }
  
  sub _url_list {
    my ($element) = @_;
    return unless $element;
    $element = _listify( $element );
    $element = [ grep { _is_urlish($_) } @$element ];
    return unless @$element;
    return $element;
  }
  
  sub _author_list {
    my ($element) = @_;
    return [ 'unknown' ] unless $element;
    $element = _listify( $element );
    $element = [ map { defined $_ && length $_ ? $_ : 'unknown' } @$element ];
    return [ 'unknown' ] unless @$element;
    return $element;
  }
  
  my $resource2_upgrade = {
    license    => sub { return _is_urlish($_[0]) ? _listify( $_[0] ) : undef },
    homepage   => \&_url_or_drop,
    bugtracker => sub {
      my ($item) = @_;
      return unless $item;
      if ( $item =~ m{^mailto:(.*)$} ) { return { mailto => $1 } }
      elsif( _is_urlish($item) ) { return { web => $item } }
      else { return }
    },
    repository => sub { return _is_urlish($_[0]) ? { url => $_[0] } : undef },
    ':custom'  => \&_prefix_custom,
  };
  
  sub _upgrade_resources_2 {
    my (undef, undef, $meta, $version) = @_;
    return unless exists $meta->{resources};
    return _convert($meta->{resources}, $resource2_upgrade);
  }
  
  my $bugtracker2_spec = {
    web => \&_url_or_drop,
    mailto => \&_keep,
    ':custom'  => \&_prefix_custom,
  };
  
  sub _repo_type {
    my ($element, $key, $meta, $to_version) = @_;
    return $element if defined $element;
    return unless exists $meta->{url};
    my $repo_url = $meta->{url};
    for my $type ( qw/git svn/ ) {
      return $type if $repo_url =~ m{\A$type};
    }
    return;
  }
  
  my $repository2_spec = {
    web => \&_url_or_drop,
    url => \&_url_or_drop,
    type => \&_repo_type,
    ':custom'  => \&_prefix_custom,
  };
  
  my $resources2_cleanup = {
    license    => \&_url_list,
    homepage   => \&_url_or_drop,
    bugtracker => sub { ref $_[0] ? _convert( $_[0], $bugtracker2_spec ) : undef },
    repository => sub { my $data = shift; ref $data ? _convert( $data, $repository2_spec ) : undef },
    ':custom'  => \&_prefix_custom,
  };
  
  sub _cleanup_resources_2 {
    my ($resources, $key, $meta, $to_version) = @_;
    return unless $resources && ref $resources eq 'HASH';
    return _convert($resources, $resources2_cleanup, $to_version);
  }
  
  my $resource1_spec = {
    license    => \&_url_or_drop,
    homepage   => \&_url_or_drop,
    bugtracker => \&_url_or_drop,
    repository => \&_url_or_drop,
    ':custom'  => \&_keep,
  };
  
  sub _resources_1_3 {
    my (undef, undef, $meta, $version) = @_;
    return unless exists $meta->{resources};
    return _convert($meta->{resources}, $resource1_spec);
  }
  
  *_resources_1_4 = *_resources_1_3;
  
  sub _resources_1_2 {
    my (undef, undef, $meta) = @_;
    my $resources = $meta->{resources} || {};
    if ( $meta->{license_url} && ! $resources->{license} ) {
      $resources->{license} = $meta->{license_url}
        if _is_urlish($meta->{license_url});
    }
    return unless keys %$resources;
    return _convert($resources, $resource1_spec);
  }
  
  my $resource_downgrade_spec = {
    license    => sub { return ref $_[0] ? $_[0]->[0] : $_[0] },
    homepage   => \&_url_or_drop,
    bugtracker => sub { return $_[0]->{web} },
    repository => sub { return $_[0]->{url} || $_[0]->{web} },
    ':custom'  => \&_no_prefix_ucfirst_custom,
  };
  
  sub _downgrade_resources {
    my (undef, undef, $meta, $version) = @_;
    return unless exists $meta->{resources};
    return _convert($meta->{resources}, $resource_downgrade_spec);
  }
  
  sub _release_status {
    my ($element, undef, $meta) = @_;
    return $element if $element && $element =~ m{\A(?:stable|testing|unstable)\z};
    return _release_status_from_version(undef, undef, $meta);
  }
  
  sub _release_status_from_version {
    my (undef, undef, $meta) = @_;
    my $version = $meta->{version} || '';
    return ( $version =~ /_/ ) ? 'testing' : 'stable';
  }
  
  my $provides_spec = {
    file => \&_keep,
    version => \&_keep,
  };
  
  my $provides_spec_2 = {
    file => \&_keep,
    version => \&_keep,
    ':custom'  => \&_prefix_custom,
  };
  
  sub _provides {
    my ($element, $key, $meta, $to_version) = @_;
    return unless defined $element && ref $element eq 'HASH';
    my $spec = $to_version == 2 ? $provides_spec_2 : $provides_spec;
    my $new_data = {};
    for my $k ( keys %$element ) {
      $new_data->{$k} = _convert($element->{$k}, $spec, $to_version);
      $new_data->{$k}{version} = _clean_version($element->{$k}{version})
        if exists $element->{$k}{version};
    }
    return $new_data;
  }
  
  sub _convert {
    my ($data, $spec, $to_version, $is_fragment) = @_;
  
    my $new_data = {};
    for my $key ( keys %$spec ) {
      next if $key eq ':custom' || $key eq ':drop';
      next unless my $fcn = $spec->{$key};
      if ( $is_fragment && $key eq 'generated_by' ) {
        $fcn = \&_keep;
      }
      die "spec for '$key' is not a coderef"
        unless ref $fcn && ref $fcn eq 'CODE';
      my $new_value = $fcn->($data->{$key}, $key, $data, $to_version);
      $new_data->{$key} = $new_value if defined $new_value;
    }
  
    my $drop_list   = $spec->{':drop'};
    my $customizer  = $spec->{':custom'} || \&_keep;
  
    for my $key ( keys %$data ) {
      next if $drop_list && grep { $key eq $_ } @$drop_list;
      next if exists $spec->{$key}; # we handled it
      $new_data->{ $customizer->($key) } = $data->{$key};
    }
  
    return $new_data;
  }
  
  #--------------------------------------------------------------------------#
  # define converters for each conversion
  #--------------------------------------------------------------------------#
  
  # each converts from prior version
  # special ":custom" field is used for keys not recognized in spec
  my %up_convert = (
    '2-from-1.4' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_2,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # CHANGED TO MANDATORY
      'dynamic_config'      => \&_keep_or_one,
      # ADDED MANDATORY
      'release_status'      => \&_release_status,
      # PRIOR OPTIONAL
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_upgrade_optional_features,
      'provides'            => \&_provides,
      'resources'           => \&_upgrade_resources_2,
      # ADDED OPTIONAL
      'description'         => \&_keep,
      'prereqs'             => \&_prereqs_from_1,
  
      # drop these deprecated fields, but only after we convert
      ':drop' => [ qw(
          build_requires
          configure_requires
          conflicts
          distribution_type
          license_url
          private
          recommends
          requires
      ) ],
  
      # other random keys need x_ prefixing
      ':custom'              => \&_prefix_custom,
    },
    '1.4-from-1.3' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_optional_features_1_4,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_4,
      # ADDED OPTIONAL
      'configure_requires'  => \&_keep,
  
      # drop these deprecated fields, but only after we convert
      ':drop' => [ qw(
        license_url
        private
      )],
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep
    },
    '1.3-from-1.2' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_3,
  
      # drop these deprecated fields, but only after we convert
      ':drop' => [ qw(
        license_url
        private
      )],
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep
    },
    '1.2-from-1.1' => {
      # PRIOR MANDATORY
      'version'             => \&_keep,
      # CHANGED TO MANDATORY
      'license'             => \&_license_1,
      'name'                => \&_keep,
      'generated_by'        => \&_generated_by,
      # ADDED MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'meta-spec'           => \&_change_meta_spec,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      # ADDED OPTIONAL
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_1_2,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'resources'           => \&_resources_1_2,
  
      # drop these deprecated fields, but only after we convert
      ':drop' => [ qw(
        license_url
        private
      )],
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep
    },
    '1.1-from-1.0' => {
      # CHANGED TO MANDATORY
      'version'             => \&_keep,
      # IMPLIED MANDATORY
      'name'                => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      # ADDED OPTIONAL
      'license_url'         => \&_url_or_drop,
      'private'             => \&_keep,
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep
    },
  );
  
  my %down_convert = (
    '1.4-from-2' => {
      # MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_downgrade_license,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # OPTIONAL
      'build_requires'      => \&_get_build_requires,
      'configure_requires'  => \&_get_configure_requires,
      'conflicts'           => \&_get_conflicts,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_downgrade_optional_features,
      'provides'            => \&_provides,
      'recommends'          => \&_get_recommends,
      'requires'            => \&_get_requires,
      'resources'           => \&_downgrade_resources,
  
      # drop these unsupported fields (after conversion)
      ':drop' => [ qw(
        description
        prereqs
        release_status
      )],
  
      # custom keys will be left unchanged
      ':custom'              => \&_keep
    },
    '1.3-from-1.4' => {
      # MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_3,
  
      # drop these unsupported fields, but only after we convert
      ':drop' => [ qw(
        configure_requires
      )],
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep,
    },
    '1.2-from-1.3' => {
      # MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_1_2,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_3,
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep,
    },
    '1.1-from-1.2' => {
      # MANDATORY
      'version'             => \&_keep,
      # IMPLIED MANDATORY
      'name'                => \&_keep,
      'meta-spec'           => \&_change_meta_spec,
      # OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'private'             => \&_keep,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
  
      # drop unsupported fields
      ':drop' => [ qw(
        abstract
        author
        provides
        no_index
        keywords
        resources
      )],
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep,
    },
    '1.0-from-1.1' => {
      # IMPLIED MANDATORY
      'name'                => \&_keep,
      'meta-spec'           => \&_change_meta_spec,
      'version'             => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
  
      # other random keys are OK if already valid
      ':custom'              => \&_keep,
    },
  );
  
  my %cleanup = (
    '2' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_2,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # CHANGED TO MANDATORY
      'dynamic_config'      => \&_keep_or_one,
      # ADDED MANDATORY
      'release_status'      => \&_release_status,
      # PRIOR OPTIONAL
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_cleanup_optional_features_2,
      'provides'            => \&_provides,
      'resources'           => \&_cleanup_resources_2,
      # ADDED OPTIONAL
      'description'         => \&_keep,
      'prereqs'             => \&_cleanup_prereqs,
  
      # drop these deprecated fields, but only after we convert
      ':drop' => [ qw(
          build_requires
          configure_requires
          conflicts
          distribution_type
          license_url
          private
          recommends
          requires
      ) ],
  
      # other random keys need x_ prefixing
      ':custom'              => \&_prefix_custom,
    },
    '1.4' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_optional_features_1_4,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_4,
      # ADDED OPTIONAL
      'configure_requires'  => \&_keep,
  
      # other random keys are OK if already valid
      ':custom'             => \&_keep
    },
    '1.3' => {
      # PRIOR MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'meta-spec'           => \&_change_meta_spec,
      'name'                => \&_keep,
      'version'             => \&_keep,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_directory,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      'resources'           => \&_resources_1_3,
  
      # other random keys are OK if already valid
      ':custom'             => \&_keep
    },
    '1.2' => {
      # PRIOR MANDATORY
      'version'             => \&_keep,
      # CHANGED TO MANDATORY
      'license'             => \&_license_1,
      'name'                => \&_keep,
      'generated_by'        => \&_generated_by,
      # ADDED MANDATORY
      'abstract'            => \&_keep_or_unknown,
      'author'              => \&_author_list,
      'meta-spec'           => \&_change_meta_spec,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      # ADDED OPTIONAL
      'keywords'            => \&_keep,
      'no_index'            => \&_no_index_1_2,
      'optional_features'   => \&_optional_features_as_map,
      'provides'            => \&_provides,
      'resources'           => \&_resources_1_2,
  
      # other random keys are OK if already valid
      ':custom'             => \&_keep
    },
    '1.1' => {
      # CHANGED TO MANDATORY
      'version'             => \&_keep,
      # IMPLIED MANDATORY
      'name'                => \&_keep,
      'meta-spec'           => \&_change_meta_spec,
      # PRIOR OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
      # ADDED OPTIONAL
      'license_url'         => \&_url_or_drop,
      'private'             => \&_keep,
  
      # other random keys are OK if already valid
      ':custom'             => \&_keep
    },
    '1.0' => {
      # IMPLIED MANDATORY
      'name'                => \&_keep,
      'meta-spec'           => \&_change_meta_spec,
      'version'             => \&_keep,
      # IMPLIED OPTIONAL
      'build_requires'      => \&_version_map,
      'conflicts'           => \&_version_map,
      'distribution_type'   => \&_keep,
      'dynamic_config'      => \&_keep_or_one,
      'generated_by'        => \&_generated_by,
      'license'             => \&_license_1,
      'recommends'          => \&_version_map,
      'requires'            => \&_version_map,
  
      # other random keys are OK if already valid
      ':custom'             => \&_keep,
    },
  );
  
  # for a given field in a spec version, what fields will it feed
  # into in the *latest* spec (i.e. v2); meta-spec omitted because
  # we always expect a meta-spec to be generated
  my %fragments_generate = (
    '2' => {
      'abstract'            =>   'abstract',
      'author'              =>   'author',
      'generated_by'        =>   'generated_by',
      'license'             =>   'license',
      'name'                =>   'name',
      'version'             =>   'version',
      'dynamic_config'      =>   'dynamic_config',
      'release_status'      =>   'release_status',
      'keywords'            =>   'keywords',
      'no_index'            =>   'no_index',
      'optional_features'   =>   'optional_features',
      'provides'            =>   'provides',
      'resources'           =>   'resources',
      'description'         =>   'description',
      'prereqs'             =>   'prereqs',
    },
    '1.4' => {
      'abstract'            => 'abstract',
      'author'              => 'author',
      'generated_by'        => 'generated_by',
      'license'             => 'license',
      'name'                => 'name',
      'version'             => 'version',
      'build_requires'      => 'prereqs',
      'conflicts'           => 'prereqs',
      'distribution_type'   => 'distribution_type',
      'dynamic_config'      => 'dynamic_config',
      'keywords'            => 'keywords',
      'no_index'            => 'no_index',
      'optional_features'   => 'optional_features',
      'provides'            => 'provides',
      'recommends'          => 'prereqs',
      'requires'            => 'prereqs',
      'resources'           => 'resources',
      'configure_requires'  => 'prereqs',
    },
  );
  # this is not quite true but will work well enough
  # as 1.4 is a superset of earlier ones
  $fragments_generate{$_} = $fragments_generate{'1.4'} for qw/1.3 1.2 1.1 1.0/;
  
  #--------------------------------------------------------------------------#
  # Code
  #--------------------------------------------------------------------------#
  
  #pod =method new
  #pod
  #pod   my $cmc = CPAN::Meta::Converter->new( $struct );
  #pod
  #pod The constructor should be passed a valid metadata structure but invalid
  #pod structures are accepted.  If no meta-spec version is provided, version 1.0 will
  #pod be assumed.
  #pod
  #pod Optionally, you can provide a C<default_version> argument after C<$struct>:
  #pod
  #pod   my $cmc = CPAN::Meta::Converter->new( $struct, default_version => "1.4" );
  #pod
  #pod This is only needed when converting a metadata fragment that does not include a
  #pod C<meta-spec> field.
  #pod
  #pod =cut
  
  sub new {
    my ($class,$data,%args) = @_;
  
    # create an attributes hash
    my $self = {
      'data'    => $data,
      'spec'    => _extract_spec_version($data, $args{default_version}),
    };
  
    # create the object
    return bless $self, $class;
  }
  
  sub _extract_spec_version {
      my ($data, $default) = @_;
      my $spec = $data->{'meta-spec'};
  
      # is meta-spec there and valid?
      return( $default || "1.0" ) unless defined $spec && ref $spec eq 'HASH'; # before meta-spec?
  
      # does the version key look like a valid version?
      my $v = $spec->{version};
      if ( defined $v && $v =~ /^\d+(?:\.\d+)?$/ ) {
          return $v if defined $v && grep { $v eq $_ } keys %known_specs; # known spec
          return $v+0 if defined $v && grep { $v == $_ } keys %known_specs; # 2.0 => 2
      }
  
      # otherwise, use heuristics: look for 1.x vs 2.0 fields
      return "2" if exists $data->{prereqs};
      return "1.4" if exists $data->{configure_requires};
      return( $default || "1.2" ); # when meta-spec was first defined
  }
  
  #pod =method convert
  #pod
  #pod   my $new_struct = $cmc->convert( version => "2" );
  #pod
  #pod Returns a new hash reference with the metadata converted to a different form.
  #pod C<convert> will die if any conversion/standardization still results in an
  #pod invalid structure.
  #pod
  #pod Valid parameters include:
  #pod
  #pod =over
  #pod
  #pod =item *
  #pod
  #pod C<version> -- Indicates the desired specification version (e.g. "1.0", "1.1" ... "1.4", "2").
  #pod Defaults to the latest version of the CPAN Meta Spec.
  #pod
  #pod =back
  #pod
  #pod Conversion proceeds through each version in turn.  For example, a version 1.2
  #pod structure might be converted to 1.3 then 1.4 then finally to version 2. The
  #pod conversion process attempts to clean-up simple errors and standardize data.
  #pod For example, if C<author> is given as a scalar, it will converted to an array
  #pod reference containing the item. (Converting a structure to its own version will
  #pod also clean-up and standardize.)
  #pod
  #pod When data are cleaned and standardized, missing or invalid fields will be
  #pod replaced with sensible defaults when possible.  This may be lossy or imprecise.
  #pod For example, some badly structured META.yml files on CPAN have prerequisite
  #pod modules listed as both keys and values:
  #pod
  #pod   requires => { 'Foo::Bar' => 'Bam::Baz' }
  #pod
  #pod These would be split and each converted to a prerequisite with a minimum
  #pod version of zero.
  #pod
  #pod When some mandatory fields are missing or invalid, the conversion will attempt
  #pod to provide a sensible default or will fill them with a value of 'unknown'.  For
  #pod example a missing or unrecognized C<license> field will result in a C<license>
  #pod field of 'unknown'.  Fields that may get an 'unknown' include:
  #pod
  #pod =for :list
  #pod * abstract
  #pod * author
  #pod * license
  #pod
  #pod =cut
  
  sub convert {
    my ($self, %args) = @_;
    my $args = { %args };
  
    my $new_version = $args->{version} || $HIGHEST;
    my $is_fragment = $args->{is_fragment};
  
    my ($old_version) = $self->{spec};
    my $converted = _dclone($self->{data});
  
    if ( $old_version == $new_version ) {
      $converted = _convert( $converted, $cleanup{$old_version}, $old_version, $is_fragment );
      unless ( $args->{is_fragment} ) {
        my $cmv = CPAN::Meta::Validator->new( $converted );
        unless ( $cmv->is_valid ) {
          my $errs = join("\n", $cmv->errors);
          die "Failed to clean-up $old_version metadata. Errors:\n$errs\n";
        }
      }
      return $converted;
    }
    elsif ( $old_version > $new_version )  {
      my @vers = sort { $b <=> $a } keys %known_specs;
      for my $i ( 0 .. $#vers-1 ) {
        next if $vers[$i] > $old_version;
        last if $vers[$i+1] < $new_version;
        my $spec_string = "$vers[$i+1]-from-$vers[$i]";
        $converted = _convert( $converted, $down_convert{$spec_string}, $vers[$i+1], $is_fragment );
        unless ( $args->{is_fragment} ) {
          my $cmv = CPAN::Meta::Validator->new( $converted );
          unless ( $cmv->is_valid ) {
            my $errs = join("\n", $cmv->errors);
            die "Failed to downconvert metadata to $vers[$i+1]. Errors:\n$errs\n";
          }
        }
      }
      return $converted;
    }
    else {
      my @vers = sort { $a <=> $b } keys %known_specs;
      for my $i ( 0 .. $#vers-1 ) {
        next if $vers[$i] < $old_version;
        last if $vers[$i+1] > $new_version;
        my $spec_string = "$vers[$i+1]-from-$vers[$i]";
        $converted = _convert( $converted, $up_convert{$spec_string}, $vers[$i+1], $is_fragment );
        unless ( $args->{is_fragment} ) {
          my $cmv = CPAN::Meta::Validator->new( $converted );
          unless ( $cmv->is_valid ) {
            my $errs = join("\n", $cmv->errors);
            die "Failed to upconvert metadata to $vers[$i+1]. Errors:\n$errs\n";
          }
        }
      }
      return $converted;
    }
  }
  
  #pod =method upgrade_fragment
  #pod
  #pod   my $new_struct = $cmc->upgrade_fragment;
  #pod
  #pod Returns a new hash reference with the metadata converted to the latest version
  #pod of the CPAN Meta Spec.  No validation is done on the result -- you must
  #pod validate after merging fragments into a complete metadata document.
  #pod
  #pod Available since version 2.141170.
  #pod
  #pod =cut
  
  sub upgrade_fragment {
    my ($self) = @_;
    my ($old_version) = $self->{spec};
    my %expected =
      map {; $_ => 1 }
      grep { defined }
      map { $fragments_generate{$old_version}{$_} }
      keys %{ $self->{data} };
    my $converted = $self->convert( version => $HIGHEST, is_fragment => 1 );
    for my $key ( keys %$converted ) {
      next if $key =~ /^x_/i || $key eq 'meta-spec';
      delete $converted->{$key} unless $expected{$key};
    }
    return $converted;
  }
  
  1;
  
  # ABSTRACT: Convert CPAN distribution metadata structures
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Converter - Convert CPAN distribution metadata structures
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 SYNOPSIS
  
    my $struct = decode_json_file('META.json');
  
    my $cmc = CPAN::Meta::Converter->new( $struct );
  
    my $new_struct = $cmc->convert( version => "2" );
  
  =head1 DESCRIPTION
  
  This module converts CPAN Meta structures from one form to another.  The
  primary use is to convert older structures to the most modern version of
  the specification, but other transformations may be implemented in the
  future as needed.  (E.g. stripping all custom fields or stripping all
  optional fields.)
  
  =head1 METHODS
  
  =head2 new
  
    my $cmc = CPAN::Meta::Converter->new( $struct );
  
  The constructor should be passed a valid metadata structure but invalid
  structures are accepted.  If no meta-spec version is provided, version 1.0 will
  be assumed.
  
  Optionally, you can provide a C<default_version> argument after C<$struct>:
  
    my $cmc = CPAN::Meta::Converter->new( $struct, default_version => "1.4" );
  
  This is only needed when converting a metadata fragment that does not include a
  C<meta-spec> field.
  
  =head2 convert
  
    my $new_struct = $cmc->convert( version => "2" );
  
  Returns a new hash reference with the metadata converted to a different form.
  C<convert> will die if any conversion/standardization still results in an
  invalid structure.
  
  Valid parameters include:
  
  =over
  
  =item *
  
  C<version> -- Indicates the desired specification version (e.g. "1.0", "1.1" ... "1.4", "2").
  Defaults to the latest version of the CPAN Meta Spec.
  
  =back
  
  Conversion proceeds through each version in turn.  For example, a version 1.2
  structure might be converted to 1.3 then 1.4 then finally to version 2. The
  conversion process attempts to clean-up simple errors and standardize data.
  For example, if C<author> is given as a scalar, it will converted to an array
  reference containing the item. (Converting a structure to its own version will
  also clean-up and standardize.)
  
  When data are cleaned and standardized, missing or invalid fields will be
  replaced with sensible defaults when possible.  This may be lossy or imprecise.
  For example, some badly structured META.yml files on CPAN have prerequisite
  modules listed as both keys and values:
  
    requires => { 'Foo::Bar' => 'Bam::Baz' }
  
  These would be split and each converted to a prerequisite with a minimum
  version of zero.
  
  When some mandatory fields are missing or invalid, the conversion will attempt
  to provide a sensible default or will fill them with a value of 'unknown'.  For
  example a missing or unrecognized C<license> field will result in a C<license>
  field of 'unknown'.  Fields that may get an 'unknown' include:
  
  =over 4
  
  =item *
  
  abstract
  
  =item *
  
  author
  
  =item *
  
  license
  
  =back
  
  =head2 upgrade_fragment
  
    my $new_struct = $cmc->upgrade_fragment;
  
  Returns a new hash reference with the metadata converted to the latest version
  of the CPAN Meta Spec.  No validation is done on the result -- you must
  validate after merging fragments into a complete metadata document.
  
  Available since version 2.141170.
  
  =head1 BUGS
  
  Please report any bugs or feature using the CPAN Request Tracker.
  Bugs can be submitted through the web interface at
  L<http://rt.cpan.org/Dist/Display.html?Queue=CPAN-Meta>
  
  When submitting a bug or request, please include a test-file or a patch to an
  existing test-file that illustrates the bug or desired feature.
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # vim: ts=2 sts=2 sw=2 et :
CPAN_META_CONVERTER

$fatpacked{"CPAN/Meta/Feature.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_FEATURE';
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::Feature;
  
  our $VERSION = '2.150010';
  
  use CPAN::Meta::Prereqs;
  
  #pod =head1 DESCRIPTION
  #pod
  #pod A CPAN::Meta::Feature object describes an optional feature offered by a CPAN
  #pod distribution and specified in the distribution's F<META.json> (or F<META.yml>)
  #pod file.
  #pod
  #pod For the most part, this class will only be used when operating on the result of
  #pod the C<feature> or C<features> methods on a L<CPAN::Meta> object.
  #pod
  #pod =method new
  #pod
  #pod   my $feature = CPAN::Meta::Feature->new( $identifier => \%spec );
  #pod
  #pod This returns a new Feature object.  The C<%spec> argument to the constructor
  #pod should be the same as the value of the C<optional_feature> entry in the
  #pod distmeta.  It must contain entries for C<description> and C<prereqs>.
  #pod
  #pod =cut
  
  sub new {
    my ($class, $identifier, $spec) = @_;
  
    my %guts = (
      identifier  => $identifier,
      description => $spec->{description},
      prereqs     => CPAN::Meta::Prereqs->new($spec->{prereqs}),
    );
  
    bless \%guts => $class;
  }
  
  #pod =method identifier
  #pod
  #pod This method returns the feature's identifier.
  #pod
  #pod =cut
  
  sub identifier  { $_[0]{identifier}  }
  
  #pod =method description
  #pod
  #pod This method returns the feature's long description.
  #pod
  #pod =cut
  
  sub description { $_[0]{description} }
  
  #pod =method prereqs
  #pod
  #pod This method returns the feature's prerequisites as a L<CPAN::Meta::Prereqs>
  #pod object.
  #pod
  #pod =cut
  
  sub prereqs     { $_[0]{prereqs} }
  
  1;
  
  # ABSTRACT: an optional feature provided by a CPAN distribution
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Feature - an optional feature provided by a CPAN distribution
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 DESCRIPTION
  
  A CPAN::Meta::Feature object describes an optional feature offered by a CPAN
  distribution and specified in the distribution's F<META.json> (or F<META.yml>)
  file.
  
  For the most part, this class will only be used when operating on the result of
  the C<feature> or C<features> methods on a L<CPAN::Meta> object.
  
  =head1 METHODS
  
  =head2 new
  
    my $feature = CPAN::Meta::Feature->new( $identifier => \%spec );
  
  This returns a new Feature object.  The C<%spec> argument to the constructor
  should be the same as the value of the C<optional_feature> entry in the
  distmeta.  It must contain entries for C<description> and C<prereqs>.
  
  =head2 identifier
  
  This method returns the feature's identifier.
  
  =head2 description
  
  This method returns the feature's long description.
  
  =head2 prereqs
  
  This method returns the feature's prerequisites as a L<CPAN::Meta::Prereqs>
  object.
  
  =head1 BUGS
  
  Please report any bugs or feature using the CPAN Request Tracker.
  Bugs can be submitted through the web interface at
  L<http://rt.cpan.org/Dist/Display.html?Queue=CPAN-Meta>
  
  When submitting a bug or request, please include a test-file or a patch to an
  existing test-file that illustrates the bug or desired feature.
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # vim: ts=2 sts=2 sw=2 et :
CPAN_META_FEATURE

$fatpacked{"CPAN/Meta/History.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_HISTORY';
  # vi:tw=72
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::History;
  
  our $VERSION = '2.150010';
  
  1;
  
  # ABSTRACT: history of CPAN Meta Spec changes
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::History - history of CPAN Meta Spec changes
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 DESCRIPTION
  
  The CPAN Meta Spec has gone through several iterations.  It was
  originally written in HTML and later revised into POD (though published
  in HTML generated from the POD).  Fields were added, removed or changed,
  sometimes by design and sometimes to reflect real-world usage after the
  fact.
  
  This document reconstructs the history of the CPAN Meta Spec based on
  change logs, repository commit messages and the published HTML files.
  In some cases, particularly prior to version 1.2, the exact version
  when certain fields were introduced or changed is inconsistent between
  sources.  When in doubt, the published HTML files for versions 1.0 to
  1.4 as they existed when version 2 was developed are used as the
  definitive source.
  
  Starting with version 2, the specification document is part of the
  CPAN-Meta distribution and will be published on CPAN as
  L<CPAN::Meta::Spec>.
  
  Going forward, specification version numbers will be integers and
  decimal portions will correspond to a release date for the CPAN::Meta
  library.
  
  =head1 HISTORY
  
  =head2 Version 2
  
  April 2010
  
  =over
  
  =item *
  
  Revised spec examples as perl data structures rather than YAML
  
  =item *
  
  Switched to JSON serialization from YAML
  
  =item *
  
  Specified allowed version number formats
  
  =item *
  
  Replaced 'requires', 'build_requires', 'configure_requires',
  'recommends' and 'conflicts' with new 'prereqs' data structure divided
  by I<phase> (configure, build, test, runtime, etc.) and I<relationship>
  (requires, recommends, suggests, conflicts)
  
  =item *
  
  Added support for 'develop' phase for requirements for maintaining
  a list of authoring tools
  
  =item *
  
  Changed 'license' to a list and revised the set of valid licenses
  
  =item *
  
  Made 'dynamic_config' mandatory to reduce confusion
  
  =item *
  
  Changed 'resources' subkey 'repository' to a hash that clarifies
  repository type, url for browsing and url for checkout
  
  =item *
  
  Changed 'resources' subkey 'bugtracker' to a hash for either web
  or mailto resource
  
  =item *
  
  Changed specification of 'optional_features':
  
  =over
  
  =item *
  
  Added formal specification and usage guide instead of just example
  
  =item *
  
  Changed to use new prereqs data structure instead of individual keys
  
  =back
  
  =item *
  
  Clarified intended use of 'author' as generalized contact list
  
  =item *
  
  Added 'release_status' field to indicate stable, testing or unstable
  status to provide hints to indexers
  
  =item *
  
  Added 'description' field for a longer description of the distribution
  
  =item *
  
  Formalized use of "x_" or "X_" for all custom keys not listed in the
  official spec
  
  =back
  
  =head2 Version 1.4
  
  June 2008
  
  =over
  
  =item *
  
  Noted explicit support for 'perl' in prerequisites
  
  =item *
  
  Added 'configure_requires' prerequisite type
  
  =item *
  
  Changed 'optional_features'
  
  =over
  
  =item *
  
  Example corrected to show map of maps instead of list of maps
  (though descriptive text said 'map' even in v1.3)
  
  =item *
  
  Removed 'requires_packages', 'requires_os' and 'excluded_os'
  as valid subkeys
  
  =back
  
  =back
  
  =head2 Version 1.3
  
  November 2006
  
  =over
  
  =item *
  
  Added 'no_index' subkey 'directory' and removed 'dir' to match actual
  usage in the wild
  
  =item *
  
  Added a 'repository' subkey to 'resources'
  
  =back
  
  =head2 Version 1.2
  
  August 2005
  
  =over
  
  =item *
  
  Re-wrote and restructured spec in POD syntax
  
  =item *
  
  Changed 'name' to be mandatory
  
  =item *
  
  Changed 'generated_by' to be mandatory
  
  =item *
  
  Changed 'license' to be mandatory
  
  =item *
  
  Added version range specifications for prerequisites
  
  =item *
  
  Added required 'abstract' field
  
  =item *
  
  Added required 'author' field
  
  =item *
  
  Added required 'meta-spec' field to define 'version' (and 'url') of the
  CPAN Meta Spec used for metadata
  
  =item *
  
  Added 'provides' field
  
  =item *
  
  Added 'no_index' field and deprecated 'private' field.  'no_index'
  subkeys include 'file', 'dir', 'package' and 'namespace'
  
  =item *
  
  Added 'keywords' field
  
  =item *
  
  Added 'resources' field with subkeys 'homepage', 'license', and
  'bugtracker'
  
  =item *
  
  Added 'optional_features' field as an alternate under 'recommends'.
  Includes 'description', 'requires', 'build_requires', 'conflicts',
  'requires_packages', 'requires_os' and 'excluded_os' as valid subkeys
  
  =item *
  
  Removed 'license_uri' field
  
  =back
  
  =head2 Version 1.1
  
  May 2003
  
  =over
  
  =item *
  
  Changed 'version' to be mandatory
  
  =item *
  
  Added 'private' field
  
  =item *
  
  Added 'license_uri' field
  
  =back
  
  =head2 Version 1.0
  
  March 2003
  
  =over
  
  =item *
  
  Original release (in HTML format only)
  
  =item *
  
  Included 'name', 'version', 'license', 'distribution_type', 'requires',
  'recommends', 'build_requires', 'conflicts', 'dynamic_config',
  'generated_by'
  
  =back
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
CPAN_META_HISTORY

$fatpacked{"CPAN/Meta/Merge.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_MERGE';
  use strict;
  use warnings;
  
  package CPAN::Meta::Merge;
  
  our $VERSION = '2.150010';
  
  use Carp qw/croak/;
  use Scalar::Util qw/blessed/;
  use CPAN::Meta::Converter 2.141170;
  
  sub _is_identical {
    my ($left, $right) = @_;
    return
      (not defined $left and not defined $right)
      # if either of these are references, we compare the serialized value
      || (defined $left and defined $right and $left eq $right);
  }
  
  sub _identical {
    my ($left, $right, $path) = @_;
    croak sprintf "Can't merge attribute %s: '%s' does not equal '%s'", join('.', @{$path}), $left, $right
      unless _is_identical($left, $right);
    return $left;
  }
  
  sub _merge {
    my ($current, $next, $mergers, $path) = @_;
    for my $key (keys %{$next}) {
      if (not exists $current->{$key}) {
        $current->{$key} = $next->{$key};
      }
      elsif (my $merger = $mergers->{$key}) {
        $current->{$key} = $merger->($current->{$key}, $next->{$key}, [ @{$path}, $key ]);
      }
      elsif ($merger = $mergers->{':default'}) {
        $current->{$key} = $merger->($current->{$key}, $next->{$key}, [ @{$path}, $key ]);
      }
      else {
        croak sprintf "Can't merge unknown attribute '%s'", join '.', @{$path}, $key;
      }
    }
    return $current;
  }
  
  sub _uniq {
    my %seen = ();
    return grep { not $seen{$_}++ } @_;
  }
  
  sub _set_addition {
    my ($left, $right) = @_;
    return [ +_uniq(@{$left}, @{$right}) ];
  }
  
  sub _uniq_map {
    my ($left, $right, $path) = @_;
    for my $key (keys %{$right}) {
      if (not exists $left->{$key}) {
        $left->{$key} = $right->{$key};
      }
      # identical strings or references are merged identically
      elsif (_is_identical($left->{$key}, $right->{$key})) {
        1; # do nothing - keep left
      }
      elsif (ref $left->{$key} eq 'HASH' and ref $right->{$key} eq 'HASH') {
        $left->{$key} = _uniq_map($left->{$key}, $right->{$key}, [ @{$path}, $key ]);
      }
      else {
        croak 'Duplication of element ' . join '.', @{$path}, $key;
      }
    }
    return $left;
  }
  
  sub _improvise {
    my ($left, $right, $path) = @_;
    my ($name) = reverse @{$path};
    if ($name =~ /^x_/) {
      if (ref($left) eq 'ARRAY') {
        return _set_addition($left, $right, $path);
      }
      elsif (ref($left) eq 'HASH') {
        return _uniq_map($left, $right, $path);
      }
      else {
        return _identical($left, $right, $path);
      }
    }
    croak sprintf "Can't merge '%s'", join '.', @{$path};
  }
  
  sub _optional_features {
    my ($left, $right, $path) = @_;
  
    for my $key (keys %{$right}) {
      if (not exists $left->{$key}) {
        $left->{$key} = $right->{$key};
      }
      else {
        for my $subkey (keys %{ $right->{$key} }) {
          next if $subkey eq 'prereqs';
          if (not exists $left->{$key}{$subkey}) {
            $left->{$key}{$subkey} = $right->{$key}{$subkey};
          }
          else {
            Carp::croak "Cannot merge two optional_features named '$key' with different '$subkey' values"
              if do { no warnings 'uninitialized'; $left->{$key}{$subkey} ne $right->{$key}{$subkey} };
          }
        }
  
        require CPAN::Meta::Prereqs;
        $left->{$key}{prereqs} =
          CPAN::Meta::Prereqs->new($left->{$key}{prereqs})
            ->with_merged_prereqs(CPAN::Meta::Prereqs->new($right->{$key}{prereqs}))
            ->as_string_hash;
      }
    }
    return $left;
  }
  
  
  my %default = (
    abstract       => \&_identical,
    author         => \&_set_addition,
    dynamic_config => sub {
      my ($left, $right) = @_;
      return $left || $right;
    },
    generated_by => sub {
      my ($left, $right) = @_;
      return join ', ', _uniq(split(/, /, $left), split(/, /, $right));
    },
    license     => \&_set_addition,
    'meta-spec' => {
      version => \&_identical,
      url     => \&_identical
    },
    name              => \&_identical,
    release_status    => \&_identical,
    version           => \&_identical,
    description       => \&_identical,
    keywords          => \&_set_addition,
    no_index          => { map { ($_ => \&_set_addition) } qw/file directory package namespace/ },
    optional_features => \&_optional_features,
    prereqs           => sub {
      require CPAN::Meta::Prereqs;
      my ($left, $right) = map { CPAN::Meta::Prereqs->new($_) } @_[0,1];
      return $left->with_merged_prereqs($right)->as_string_hash;
    },
    provides  => \&_uniq_map,
    resources => {
      license    => \&_set_addition,
      homepage   => \&_identical,
      bugtracker => \&_uniq_map,
      repository => \&_uniq_map,
      ':default' => \&_improvise,
    },
    ':default' => \&_improvise,
  );
  
  sub new {
    my ($class, %arguments) = @_;
    croak 'default version required' if not exists $arguments{default_version};
    my %mapping = %default;
    my %extra = %{ $arguments{extra_mappings} || {} };
    for my $key (keys %extra) {
      if (ref($mapping{$key}) eq 'HASH') {
        $mapping{$key} = { %{ $mapping{$key} }, %{ $extra{$key} } };
      }
      else {
        $mapping{$key} = $extra{$key};
      }
    }
    return bless {
      default_version => $arguments{default_version},
      mapping => _coerce_mapping(\%mapping, []),
    }, $class;
  }
  
  my %coderef_for = (
    set_addition => \&_set_addition,
    uniq_map     => \&_uniq_map,
    identical    => \&_identical,
    improvise    => \&_improvise,
    improvize    => \&_improvise, # [sic] for backwards compatibility
  );
  
  sub _coerce_mapping {
    my ($orig, $map_path) = @_;
    my %ret;
    for my $key (keys %{$orig}) {
      my $value = $orig->{$key};
      if (ref($orig->{$key}) eq 'CODE') {
        $ret{$key} = $value;
      }
      elsif (ref($value) eq 'HASH') {
        my $mapping = _coerce_mapping($value, [ @{$map_path}, $key ]);
        $ret{$key} = sub {
          my ($left, $right, $path) = @_;
          return _merge($left, $right, $mapping, [ @{$path} ]);
        };
      }
      elsif ($coderef_for{$value}) {
        $ret{$key} = $coderef_for{$value};
      }
      else {
        croak "Don't know what to do with " . join '.', @{$map_path}, $key;
      }
    }
    return \%ret;
  }
  
  sub merge {
    my ($self, @items) = @_;
    my $current = {};
    for my $next (@items) {
      if ( blessed($next) && $next->isa('CPAN::Meta') ) {
        $next = $next->as_struct;
      }
      elsif ( ref($next) eq 'HASH' ) {
        my $cmc = CPAN::Meta::Converter->new(
          $next, default_version => $self->{default_version}
        );
        $next = $cmc->upgrade_fragment;
      }
      else {
        croak "Don't know how to merge '$next'";
      }
      $current = _merge($current, $next, $self->{mapping}, []);
    }
    return $current;
  }
  
  1;
  
  # ABSTRACT: Merging CPAN Meta fragments
  
  
  # vim: ts=2 sts=2 sw=2 et :
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Merge - Merging CPAN Meta fragments
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 SYNOPSIS
  
   my $merger = CPAN::Meta::Merge->new(default_version => "2");
   my $meta = $merger->merge($base, @additional);
  
  =head1 DESCRIPTION
  
  =head1 METHODS
  
  =head2 new
  
  This creates a CPAN::Meta::Merge object. It takes one mandatory named
  argument, C<version>, declaring the version of the meta-spec that must be
  used for the merge. It can optionally take an C<extra_mappings> argument
  that allows one to add additional merging functions for specific elements.
  
  The C<extra_mappings> arguments takes a hash ref with the same type of
  structure as described in L<CPAN::Meta::Spec>, except with its values as
  one of the L<defined merge strategies|/"MERGE STRATEGIES"> or a code ref
  to a merging function.
  
    my $merger = CPAN::Meta::Merge->new(
        default_version => '2',
        extra_mappings => {
            'optional_features' => \&custom_merge_function,
            'x_custom' => 'set_addition',
            'x_meta_meta' => {
                name => 'identical',
                tags => 'set_addition',
            }
        }
    );
  
  =head2 merge(@fragments)
  
  Merge all C<@fragments> together. It will accept both CPAN::Meta objects and
  (possibly incomplete) hashrefs of metadata.
  
  =head1 MERGE STRATEGIES
  
  C<merge> uses various strategies to combine different elements of the CPAN::Meta objects.  The following strategies can be used with the extra_mappings argument of C<new>:
  
  =over
  
  =item identical
  
  The elements must be identical
  
  =item set_addition
  
  The union of two array refs
  
    [ a, b ] U [ a, c]  = [ a, b, c ]
  
  =item uniq_map
  
  Key value pairs from the right hash are merged to the left hash.  Key
  collisions are only allowed if their values are the same.  This merge
  function will recurse into nested hash refs following the same merge
  rules.
  
  =item improvise
  
  This merge strategy will try to pick the appropriate predefined strategy
  based on what element type.  Array refs will try to use the
  C<set_addition> strategy,  Hash refs will try to use the C<uniq_map>
  strategy, and everything else will try the C<identical> strategy.
  
  =back
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
CPAN_META_MERGE

$fatpacked{"CPAN/Meta/Prereqs.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_PREREQS';
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::Prereqs;
  
  our $VERSION = '2.150010';
  
  #pod =head1 DESCRIPTION
  #pod
  #pod A CPAN::Meta::Prereqs object represents the prerequisites for a CPAN
  #pod distribution or one of its optional features.  Each set of prereqs is
  #pod organized by phase and type, as described in L<CPAN::Meta::Prereqs>.
  #pod
  #pod =cut
  
  use Carp qw(confess);
  use Scalar::Util qw(blessed);
  use CPAN::Meta::Requirements 2.121;
  
  #pod =method new
  #pod
  #pod   my $prereq = CPAN::Meta::Prereqs->new( \%prereq_spec );
  #pod
  #pod This method returns a new set of Prereqs.  The input should look like the
  #pod contents of the C<prereqs> field described in L<CPAN::Meta::Spec>, meaning
  #pod something more or less like this:
  #pod
  #pod   my $prereq = CPAN::Meta::Prereqs->new({
  #pod     runtime => {
  #pod       requires => {
  #pod         'Some::Module' => '1.234',
  #pod         ...,
  #pod       },
  #pod       ...,
  #pod     },
  #pod     ...,
  #pod   });
  #pod
  #pod You can also construct an empty set of prereqs with:
  #pod
  #pod   my $prereqs = CPAN::Meta::Prereqs->new;
  #pod
  #pod This empty set of prereqs is useful for accumulating new prereqs before finally
  #pod dumping the whole set into a structure or string.
  #pod
  #pod =cut
  
  # note we also accept anything matching /\Ax_/i
  sub __legal_phases { qw(configure build test runtime develop)   }
  sub __legal_types  { qw(requires recommends suggests conflicts) }
  
  # expect a prereq spec from META.json -- rjbs, 2010-04-11
  sub new {
    my ($class, $prereq_spec) = @_;
    $prereq_spec ||= {};
  
    my %is_legal_phase = map {; $_ => 1 } $class->__legal_phases;
    my %is_legal_type  = map {; $_ => 1 } $class->__legal_types;
  
    my %guts;
    PHASE: for my $phase (keys %$prereq_spec) {
      next PHASE unless $phase =~ /\Ax_/i or $is_legal_phase{$phase};
  
      my $phase_spec = $prereq_spec->{ $phase };
      next PHASE unless keys %$phase_spec;
  
      TYPE: for my $type (keys %$phase_spec) {
        next TYPE unless $type =~ /\Ax_/i or $is_legal_type{$type};
  
        my $spec = $phase_spec->{ $type };
  
        next TYPE unless keys %$spec;
  
        $guts{prereqs}{$phase}{$type} = CPAN::Meta::Requirements->from_string_hash(
          $spec
        );
      }
    }
  
    return bless \%guts => $class;
  }
  
  #pod =method requirements_for
  #pod
  #pod   my $requirements = $prereqs->requirements_for( $phase, $type );
  #pod
  #pod This method returns a L<CPAN::Meta::Requirements> object for the given
  #pod phase/type combination.  If no prerequisites are registered for that
  #pod combination, a new CPAN::Meta::Requirements object will be returned, and it may
  #pod be added to as needed.
  #pod
  #pod If C<$phase> or C<$type> are undefined or otherwise invalid, an exception will
  #pod be raised.
  #pod
  #pod =cut
  
  sub requirements_for {
    my ($self, $phase, $type) = @_;
  
    confess "requirements_for called without phase" unless defined $phase;
    confess "requirements_for called without type"  unless defined $type;
  
    unless ($phase =~ /\Ax_/i or grep { $phase eq $_ } $self->__legal_phases) {
      confess "requested requirements for unknown phase: $phase";
    }
  
    unless ($type =~ /\Ax_/i or grep { $type eq $_ } $self->__legal_types) {
      confess "requested requirements for unknown type: $type";
    }
  
    my $req = ($self->{prereqs}{$phase}{$type} ||= CPAN::Meta::Requirements->new);
  
    $req->finalize if $self->is_finalized;
  
    return $req;
  }
  
  #pod =method phases
  #pod
  #pod   my @phases = $prereqs->phases;
  #pod
  #pod This method returns the list of all phases currently populated in the prereqs
  #pod object, suitable for iterating.
  #pod
  #pod =cut
  
  sub phases {
    my ($self) = @_;
  
    my %is_legal_phase = map {; $_ => 1 } $self->__legal_phases;
    grep { /\Ax_/i or $is_legal_phase{$_} } keys %{ $self->{prereqs} };
  }
  
  #pod =method types_in
  #pod
  #pod   my @runtime_types = $prereqs->types_in('runtime');
  #pod
  #pod This method returns the list of all types currently populated in the prereqs
  #pod object for the provided phase, suitable for iterating.
  #pod
  #pod =cut
  
  sub types_in {
    my ($self, $phase) = @_;
  
    return unless $phase =~ /\Ax_/i or grep { $phase eq $_ } $self->__legal_phases;
  
    my %is_legal_type  = map {; $_ => 1 } $self->__legal_types;
    grep { /\Ax_/i or $is_legal_type{$_} } keys %{ $self->{prereqs}{$phase} };
  }
  
  #pod =method with_merged_prereqs
  #pod
  #pod   my $new_prereqs = $prereqs->with_merged_prereqs( $other_prereqs );
  #pod
  #pod   my $new_prereqs = $prereqs->with_merged_prereqs( \@other_prereqs );
  #pod
  #pod This method returns a new CPAN::Meta::Prereqs objects in which all the
  #pod other prerequisites given are merged into the current set.  This is primarily
  #pod provided for combining a distribution's core prereqs with the prereqs of one of
  #pod its optional features.
  #pod
  #pod The new prereqs object has no ties to the originals, and altering it further
  #pod will not alter them.
  #pod
  #pod =cut
  
  sub with_merged_prereqs {
    my ($self, $other) = @_;
  
    my @other = blessed($other) ? $other : @$other;
  
    my @prereq_objs = ($self, @other);
  
    my %new_arg;
  
    for my $phase (__uniq(map { $_->phases } @prereq_objs)) {
      for my $type (__uniq(map { $_->types_in($phase) } @prereq_objs)) {
  
        my $req = CPAN::Meta::Requirements->new;
  
        for my $prereq (@prereq_objs) {
          my $this_req = $prereq->requirements_for($phase, $type);
          next unless $this_req->required_modules;
  
          $req->add_requirements($this_req);
        }
  
        next unless $req->required_modules;
  
        $new_arg{ $phase }{ $type } = $req->as_string_hash;
      }
    }
  
    return (ref $self)->new(\%new_arg);
  }
  
  #pod =method merged_requirements
  #pod
  #pod     my $new_reqs = $prereqs->merged_requirements( \@phases, \@types );
  #pod     my $new_reqs = $prereqs->merged_requirements( \@phases );
  #pod     my $new_reqs = $prereqs->merged_requirements();
  #pod
  #pod This method joins together all requirements across a number of phases
  #pod and types into a new L<CPAN::Meta::Requirements> object.  If arguments
  #pod are omitted, it defaults to "runtime", "build" and "test" for phases
  #pod and "requires" and "recommends" for types.
  #pod
  #pod =cut
  
  sub merged_requirements {
    my ($self, $phases, $types) = @_;
    $phases = [qw/runtime build test/] unless defined $phases;
    $types = [qw/requires recommends/] unless defined $types;
  
    confess "merged_requirements phases argument must be an arrayref"
      unless ref $phases eq 'ARRAY';
    confess "merged_requirements types argument must be an arrayref"
      unless ref $types eq 'ARRAY';
  
    my $req = CPAN::Meta::Requirements->new;
  
    for my $phase ( @$phases ) {
      unless ($phase =~ /\Ax_/i or grep { $phase eq $_ } $self->__legal_phases) {
          confess "requested requirements for unknown phase: $phase";
      }
      for my $type ( @$types ) {
        unless ($type =~ /\Ax_/i or grep { $type eq $_ } $self->__legal_types) {
            confess "requested requirements for unknown type: $type";
        }
        $req->add_requirements( $self->requirements_for($phase, $type) );
      }
    }
  
    $req->finalize if $self->is_finalized;
  
    return $req;
  }
  
  
  #pod =method as_string_hash
  #pod
  #pod This method returns a hashref containing structures suitable for dumping into a
  #pod distmeta data structure.  It is made up of hashes and strings, only; there will
  #pod be no Prereqs, CPAN::Meta::Requirements, or C<version> objects inside it.
  #pod
  #pod =cut
  
  sub as_string_hash {
    my ($self) = @_;
  
    my %hash;
  
    for my $phase ($self->phases) {
      for my $type ($self->types_in($phase)) {
        my $req = $self->requirements_for($phase, $type);
        next unless $req->required_modules;
  
        $hash{ $phase }{ $type } = $req->as_string_hash;
      }
    }
  
    return \%hash;
  }
  
  #pod =method is_finalized
  #pod
  #pod This method returns true if the set of prereqs has been marked "finalized," and
  #pod cannot be altered.
  #pod
  #pod =cut
  
  sub is_finalized { $_[0]{finalized} }
  
  #pod =method finalize
  #pod
  #pod Calling C<finalize> on a Prereqs object will close it for further modification.
  #pod Attempting to make any changes that would actually alter the prereqs will
  #pod result in an exception being thrown.
  #pod
  #pod =cut
  
  sub finalize {
    my ($self) = @_;
  
    $self->{finalized} = 1;
  
    for my $phase (keys %{ $self->{prereqs} }) {
      $_->finalize for values %{ $self->{prereqs}{$phase} };
    }
  }
  
  #pod =method clone
  #pod
  #pod   my $cloned_prereqs = $prereqs->clone;
  #pod
  #pod This method returns a Prereqs object that is identical to the original object,
  #pod but can be altered without affecting the original object.  Finalization does
  #pod not survive cloning, meaning that you may clone a finalized set of prereqs and
  #pod then modify the clone.
  #pod
  #pod =cut
  
  sub clone {
    my ($self) = @_;
  
    my $clone = (ref $self)->new( $self->as_string_hash );
  }
  
  sub __uniq {
    my (%s, $u);
    grep { defined($_) ? !$s{$_}++ : !$u++ } @_;
  }
  
  1;
  
  # ABSTRACT: a set of distribution prerequisites by phase and type
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Prereqs - a set of distribution prerequisites by phase and type
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 DESCRIPTION
  
  A CPAN::Meta::Prereqs object represents the prerequisites for a CPAN
  distribution or one of its optional features.  Each set of prereqs is
  organized by phase and type, as described in L<CPAN::Meta::Prereqs>.
  
  =head1 METHODS
  
  =head2 new
  
    my $prereq = CPAN::Meta::Prereqs->new( \%prereq_spec );
  
  This method returns a new set of Prereqs.  The input should look like the
  contents of the C<prereqs> field described in L<CPAN::Meta::Spec>, meaning
  something more or less like this:
  
    my $prereq = CPAN::Meta::Prereqs->new({
      runtime => {
        requires => {
          'Some::Module' => '1.234',
          ...,
        },
        ...,
      },
      ...,
    });
  
  You can also construct an empty set of prereqs with:
  
    my $prereqs = CPAN::Meta::Prereqs->new;
  
  This empty set of prereqs is useful for accumulating new prereqs before finally
  dumping the whole set into a structure or string.
  
  =head2 requirements_for
  
    my $requirements = $prereqs->requirements_for( $phase, $type );
  
  This method returns a L<CPAN::Meta::Requirements> object for the given
  phase/type combination.  If no prerequisites are registered for that
  combination, a new CPAN::Meta::Requirements object will be returned, and it may
  be added to as needed.
  
  If C<$phase> or C<$type> are undefined or otherwise invalid, an exception will
  be raised.
  
  =head2 phases
  
    my @phases = $prereqs->phases;
  
  This method returns the list of all phases currently populated in the prereqs
  object, suitable for iterating.
  
  =head2 types_in
  
    my @runtime_types = $prereqs->types_in('runtime');
  
  This method returns the list of all types currently populated in the prereqs
  object for the provided phase, suitable for iterating.
  
  =head2 with_merged_prereqs
  
    my $new_prereqs = $prereqs->with_merged_prereqs( $other_prereqs );
  
    my $new_prereqs = $prereqs->with_merged_prereqs( \@other_prereqs );
  
  This method returns a new CPAN::Meta::Prereqs objects in which all the
  other prerequisites given are merged into the current set.  This is primarily
  provided for combining a distribution's core prereqs with the prereqs of one of
  its optional features.
  
  The new prereqs object has no ties to the originals, and altering it further
  will not alter them.
  
  =head2 merged_requirements
  
      my $new_reqs = $prereqs->merged_requirements( \@phases, \@types );
      my $new_reqs = $prereqs->merged_requirements( \@phases );
      my $new_reqs = $prereqs->merged_requirements();
  
  This method joins together all requirements across a number of phases
  and types into a new L<CPAN::Meta::Requirements> object.  If arguments
  are omitted, it defaults to "runtime", "build" and "test" for phases
  and "requires" and "recommends" for types.
  
  =head2 as_string_hash
  
  This method returns a hashref containing structures suitable for dumping into a
  distmeta data structure.  It is made up of hashes and strings, only; there will
  be no Prereqs, CPAN::Meta::Requirements, or C<version> objects inside it.
  
  =head2 is_finalized
  
  This method returns true if the set of prereqs has been marked "finalized," and
  cannot be altered.
  
  =head2 finalize
  
  Calling C<finalize> on a Prereqs object will close it for further modification.
  Attempting to make any changes that would actually alter the prereqs will
  result in an exception being thrown.
  
  =head2 clone
  
    my $cloned_prereqs = $prereqs->clone;
  
  This method returns a Prereqs object that is identical to the original object,
  but can be altered without affecting the original object.  Finalization does
  not survive cloning, meaning that you may clone a finalized set of prereqs and
  then modify the clone.
  
  =head1 BUGS
  
  Please report any bugs or feature using the CPAN Request Tracker.
  Bugs can be submitted through the web interface at
  L<http://rt.cpan.org/Dist/Display.html?Queue=CPAN-Meta>
  
  When submitting a bug or request, please include a test-file or a patch to an
  existing test-file that illustrates the bug or desired feature.
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # vim: ts=2 sts=2 sw=2 et :
CPAN_META_PREREQS

$fatpacked{"CPAN/Meta/Requirements.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_REQUIREMENTS';
  use 5.006; # keep at v5.6 for CPAN.pm
  use strict;
  use warnings;
  package CPAN::Meta::Requirements;
  # ABSTRACT: a set of version requirements for a CPAN dist
  
  our $VERSION = '2.140';
  
  #pod =head1 SYNOPSIS
  #pod
  #pod   use CPAN::Meta::Requirements;
  #pod
  #pod   my $build_requires = CPAN::Meta::Requirements->new;
  #pod
  #pod   $build_requires->add_minimum('Library::Foo' => 1.208);
  #pod
  #pod   $build_requires->add_minimum('Library::Foo' => 2.602);
  #pod
  #pod   $build_requires->add_minimum('Module::Bar'  => 'v1.2.3');
  #pod
  #pod   $METAyml->{build_requires} = $build_requires->as_string_hash;
  #pod
  #pod =head1 DESCRIPTION
  #pod
  #pod A CPAN::Meta::Requirements object models a set of version constraints like
  #pod those specified in the F<META.yml> or F<META.json> files in CPAN distributions,
  #pod and as defined by L<CPAN::Meta::Spec>;
  #pod It can be built up by adding more and more constraints, and it will reduce them
  #pod to the simplest representation.
  #pod
  #pod Logically impossible constraints will be identified immediately by thrown
  #pod exceptions.
  #pod
  #pod =cut
  
  use Carp ();
  
  # To help ExtUtils::MakeMaker bootstrap CPAN::Meta::Requirements on perls
  # before 5.10, we fall back to the EUMM bundled compatibility version module if
  # that's the only thing available.  This shouldn't ever happen in a normal CPAN
  # install of CPAN::Meta::Requirements, as version.pm will be picked up from
  # prereqs and be available at runtime.
  
  BEGIN {
    eval "use version ()"; ## no critic
    if ( my $err = $@ ) {
      eval "use ExtUtils::MakeMaker::version" or die $err; ## no critic
    }
  }
  
  # Perl 5.10.0 didn't have "is_qv" in version.pm
  *_is_qv = version->can('is_qv') ? sub { $_[0]->is_qv } : sub { exists $_[0]->{qv} };
  
  # construct once, reuse many times
  my $V0 = version->new(0);
  
  #pod =method new
  #pod
  #pod   my $req = CPAN::Meta::Requirements->new;
  #pod
  #pod This returns a new CPAN::Meta::Requirements object.  It takes an optional
  #pod hash reference argument.  Currently, only one key is supported:
  #pod
  #pod =for :list
  #pod * C<bad_version_hook> -- if provided, when a version cannot be parsed into
  #pod   a version object, this code reference will be called with the invalid
  #pod   version string as first argument, and the module name as second
  #pod   argument.  It must return a valid version object.
  #pod
  #pod All other keys are ignored.
  #pod
  #pod =cut
  
  my @valid_options = qw( bad_version_hook );
  
  sub new {
    my ($class, $options) = @_;
    $options ||= {};
    Carp::croak "Argument to $class\->new() must be a hash reference"
      unless ref $options eq 'HASH';
    my %self = map {; $_ => $options->{$_}} @valid_options;
  
    return bless \%self => $class;
  }
  
  # from version::vpp
  sub _find_magic_vstring {
    my $value = shift;
    my $tvalue = '';
    require B;
    my $sv = B::svref_2object(\$value);
    my $magic = ref($sv) eq 'B::PVMG' ? $sv->MAGIC : undef;
    while ( $magic ) {
      if ( $magic->TYPE eq 'V' ) {
        $tvalue = $magic->PTR;
        $tvalue =~ s/^v?(.+)$/v$1/;
        last;
      }
      else {
        $magic = $magic->MOREMAGIC;
      }
    }
    return $tvalue;
  }
  
  # safe if given an unblessed reference
  sub _isa_version {
    UNIVERSAL::isa( $_[0], 'UNIVERSAL' ) && $_[0]->isa('version')
  }
  
  sub _version_object {
    my ($self, $module, $version) = @_;
  
    my ($vobj, $err);
  
    if (not defined $version or (!ref($version) && $version eq '0')) {
      return $V0;
    }
    elsif ( ref($version) eq 'version' || ( ref($version) && _isa_version($version) ) ) {
      $vobj = $version;
    }
    else {
      # hack around version::vpp not handling <3 character vstring literals
      if ( $INC{'version/vpp.pm'} || $INC{'ExtUtils/MakeMaker/version/vpp.pm'} ) {
        my $magic = _find_magic_vstring( $version );
        $version = $magic if length $magic;
      }
      # pad to 3 characters if before 5.8.1 and appears to be a v-string
      if ( $] < 5.008001 && $version !~ /\A[0-9]/ && substr($version,0,1) ne 'v' && length($version) < 3 ) {
        $version .= "\0" x (3 - length($version));
      }
      eval {
        local $SIG{__WARN__} = sub { die "Invalid version: $_[0]" };
        # avoid specific segfault on some older version.pm versions
        die "Invalid version: $version" if $version eq 'version';
        $vobj = version->new($version);
      };
      if ( my $err = $@ ) {
        my $hook = $self->{bad_version_hook};
        $vobj = eval { $hook->($version, $module) }
          if ref $hook eq 'CODE';
        unless (eval { $vobj->isa("version") }) {
          $err =~ s{ at .* line \d+.*$}{};
          die "Can't convert '$version': $err";
        }
      }
    }
  
    # ensure no leading '.'
    if ( $vobj =~ m{\A\.} ) {
      $vobj = version->new("0$vobj");
    }
  
    # ensure normal v-string form
    if ( _is_qv($vobj) ) {
      $vobj = version->new($vobj->normal);
    }
  
    return $vobj;
  }
  
  #pod =method add_minimum
  #pod
  #pod   $req->add_minimum( $module => $version );
  #pod
  #pod This adds a new minimum version requirement.  If the new requirement is
  #pod redundant to the existing specification, this has no effect.
  #pod
  #pod Minimum requirements are inclusive.  C<$version> is required, along with any
  #pod greater version number.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =method add_maximum
  #pod
  #pod   $req->add_maximum( $module => $version );
  #pod
  #pod This adds a new maximum version requirement.  If the new requirement is
  #pod redundant to the existing specification, this has no effect.
  #pod
  #pod Maximum requirements are inclusive.  No version strictly greater than the given
  #pod version is allowed.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =method add_exclusion
  #pod
  #pod   $req->add_exclusion( $module => $version );
  #pod
  #pod This adds a new excluded version.  For example, you might use these three
  #pod method calls:
  #pod
  #pod   $req->add_minimum( $module => '1.00' );
  #pod   $req->add_maximum( $module => '1.82' );
  #pod
  #pod   $req->add_exclusion( $module => '1.75' );
  #pod
  #pod Any version between 1.00 and 1.82 inclusive would be acceptable, except for
  #pod 1.75.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =method exact_version
  #pod
  #pod   $req->exact_version( $module => $version );
  #pod
  #pod This sets the version required for the given module to I<exactly> the given
  #pod version.  No other version would be considered acceptable.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =cut
  
  BEGIN {
    for my $type (qw(maximum exclusion exact_version)) {
      my $method = "with_$type";
      my $to_add = $type eq 'exact_version' ? $type : "add_$type";
  
      my $code = sub {
        my ($self, $name, $version) = @_;
  
        $version = $self->_version_object( $name, $version );
  
        $self->__modify_entry_for($name, $method, $version);
  
        return $self;
      };
  
      no strict 'refs';
      *$to_add = $code;
    }
  }
  
  # add_minimum is optimized compared to generated subs above because
  # it is called frequently and with "0" or equivalent input
  sub add_minimum {
    my ($self, $name, $version) = @_;
  
    # stringify $version so that version->new("0.00")->stringify ne "0"
    # which preserves the user's choice of "0.00" as the requirement
    if (not defined $version or "$version" eq '0') {
      return $self if $self->__entry_for($name);
      Carp::confess("can't add new requirements to finalized requirements")
        if $self->is_finalized;
  
      $self->{requirements}{ $name } =
        CPAN::Meta::Requirements::_Range::Range->with_minimum($V0, $name);
    }
    else {
      $version = $self->_version_object( $name, $version );
  
      $self->__modify_entry_for($name, 'with_minimum', $version);
    }
    return $self;
  }
  
  #pod =method add_requirements
  #pod
  #pod   $req->add_requirements( $another_req_object );
  #pod
  #pod This method adds all the requirements in the given CPAN::Meta::Requirements
  #pod object to the requirements object on which it was called.  If there are any
  #pod conflicts, an exception is thrown.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =cut
  
  sub add_requirements {
    my ($self, $req) = @_;
  
    for my $module ($req->required_modules) {
      my $modifiers = $req->__entry_for($module)->as_modifiers;
      for my $modifier (@$modifiers) {
        my ($method, @args) = @$modifier;
        $self->$method($module => @args);
      };
    }
  
    return $self;
  }
  
  #pod =method accepts_module
  #pod
  #pod   my $bool = $req->accepts_module($module => $version);
  #pod
  #pod Given an module and version, this method returns true if the version
  #pod specification for the module accepts the provided version.  In other words,
  #pod given:
  #pod
  #pod   Module => '>= 1.00, < 2.00'
  #pod
  #pod We will accept 1.00 and 1.75 but not 0.50 or 2.00.
  #pod
  #pod For modules that do not appear in the requirements, this method will return
  #pod true.
  #pod
  #pod =cut
  
  sub accepts_module {
    my ($self, $module, $version) = @_;
  
    $version = $self->_version_object( $module, $version );
  
    return 1 unless my $range = $self->__entry_for($module);
    return $range->_accepts($version);
  }
  
  #pod =method clear_requirement
  #pod
  #pod   $req->clear_requirement( $module );
  #pod
  #pod This removes the requirement for a given module from the object.
  #pod
  #pod This method returns the requirements object.
  #pod
  #pod =cut
  
  sub clear_requirement {
    my ($self, $module) = @_;
  
    return $self unless $self->__entry_for($module);
  
    Carp::confess("can't clear requirements on finalized requirements")
      if $self->is_finalized;
  
    delete $self->{requirements}{ $module };
  
    return $self;
  }
  
  #pod =method requirements_for_module
  #pod
  #pod   $req->requirements_for_module( $module );
  #pod
  #pod This returns a string containing the version requirements for a given module in
  #pod the format described in L<CPAN::Meta::Spec> or undef if the given module has no
  #pod requirements. This should only be used for informational purposes such as error
  #pod messages and should not be interpreted or used for comparison (see
  #pod L</accepts_module> instead).
  #pod
  #pod =cut
  
  sub requirements_for_module {
    my ($self, $module) = @_;
    my $entry = $self->__entry_for($module);
    return unless $entry;
    return $entry->as_string;
  }
  
  #pod =method structured_requirements_for_module
  #pod
  #pod   $req->structured_requirements_for_module( $module );
  #pod
  #pod This returns a data structure containing the version requirements for a given
  #pod module or undef if the given module has no requirements.  This should
  #pod not be used for version checks (see L</accepts_module> instead).
  #pod
  #pod Added in version 2.134.
  #pod
  #pod =cut
  
  sub structured_requirements_for_module {
    my ($self, $module) = @_;
    my $entry = $self->__entry_for($module);
    return unless $entry;
    return $entry->as_struct;
  }
  
  #pod =method required_modules
  #pod
  #pod This method returns a list of all the modules for which requirements have been
  #pod specified.
  #pod
  #pod =cut
  
  sub required_modules { keys %{ $_[0]{requirements} } }
  
  #pod =method clone
  #pod
  #pod   $req->clone;
  #pod
  #pod This method returns a clone of the invocant.  The clone and the original object
  #pod can then be changed independent of one another.
  #pod
  #pod =cut
  
  sub clone {
    my ($self) = @_;
    my $new = (ref $self)->new;
  
    return $new->add_requirements($self);
  }
  
  sub __entry_for     { $_[0]{requirements}{ $_[1] } }
  
  sub __modify_entry_for {
    my ($self, $name, $method, $version) = @_;
  
    my $fin = $self->is_finalized;
    my $old = $self->__entry_for($name);
  
    Carp::confess("can't add new requirements to finalized requirements")
      if $fin and not $old;
  
    my $new = ($old || 'CPAN::Meta::Requirements::_Range::Range')
            ->$method($version, $name);
  
    Carp::confess("can't modify finalized requirements")
      if $fin and $old->as_string ne $new->as_string;
  
    $self->{requirements}{ $name } = $new;
  }
  
  #pod =method is_simple
  #pod
  #pod This method returns true if and only if all requirements are inclusive minimums
  #pod -- that is, if their string expression is just the version number.
  #pod
  #pod =cut
  
  sub is_simple {
    my ($self) = @_;
    for my $module ($self->required_modules) {
      # XXX: This is a complete hack, but also entirely correct.
      return if $self->__entry_for($module)->as_string =~ /\s/;
    }
  
    return 1;
  }
  
  #pod =method is_finalized
  #pod
  #pod This method returns true if the requirements have been finalized by having the
  #pod C<finalize> method called on them.
  #pod
  #pod =cut
  
  sub is_finalized { $_[0]{finalized} }
  
  #pod =method finalize
  #pod
  #pod This method marks the requirements finalized.  Subsequent attempts to change
  #pod the requirements will be fatal, I<if> they would result in a change.  If they
  #pod would not alter the requirements, they have no effect.
  #pod
  #pod If a finalized set of requirements is cloned, the cloned requirements are not
  #pod also finalized.
  #pod
  #pod =cut
  
  sub finalize { $_[0]{finalized} = 1 }
  
  #pod =method as_string_hash
  #pod
  #pod This returns a reference to a hash describing the requirements using the
  #pod strings in the L<CPAN::Meta::Spec> specification.
  #pod
  #pod For example after the following program:
  #pod
  #pod   my $req = CPAN::Meta::Requirements->new;
  #pod
  #pod   $req->add_minimum('CPAN::Meta::Requirements' => 0.102);
  #pod
  #pod   $req->add_minimum('Library::Foo' => 1.208);
  #pod
  #pod   $req->add_maximum('Library::Foo' => 2.602);
  #pod
  #pod   $req->add_minimum('Module::Bar'  => 'v1.2.3');
  #pod
  #pod   $req->add_exclusion('Module::Bar'  => 'v1.2.8');
  #pod
  #pod   $req->exact_version('Xyzzy'  => '6.01');
  #pod
  #pod   my $hashref = $req->as_string_hash;
  #pod
  #pod C<$hashref> would contain:
  #pod
  #pod   {
  #pod     'CPAN::Meta::Requirements' => '0.102',
  #pod     'Library::Foo' => '>= 1.208, <= 2.206',
  #pod     'Module::Bar'  => '>= v1.2.3, != v1.2.8',
  #pod     'Xyzzy'        => '== 6.01',
  #pod   }
  #pod
  #pod =cut
  
  sub as_string_hash {
    my ($self) = @_;
  
    my %hash = map {; $_ => $self->{requirements}{$_}->as_string }
               $self->required_modules;
  
    return \%hash;
  }
  
  #pod =method add_string_requirement
  #pod
  #pod   $req->add_string_requirement('Library::Foo' => '>= 1.208, <= 2.206');
  #pod   $req->add_string_requirement('Library::Foo' => v1.208);
  #pod
  #pod This method parses the passed in string and adds the appropriate requirement
  #pod for the given module.  A version can be a Perl "v-string".  It understands
  #pod version ranges as described in the L<CPAN::Meta::Spec/Version Ranges>. For
  #pod example:
  #pod
  #pod =over 4
  #pod
  #pod =item 1.3
  #pod
  #pod =item >= 1.3
  #pod
  #pod =item <= 1.3
  #pod
  #pod =item == 1.3
  #pod
  #pod =item != 1.3
  #pod
  #pod =item > 1.3
  #pod
  #pod =item < 1.3
  #pod
  #pod =item >= 1.3, != 1.5, <= 2.0
  #pod
  #pod A version number without an operator is equivalent to specifying a minimum
  #pod (C<E<gt>=>).  Extra whitespace is allowed.
  #pod
  #pod =back
  #pod
  #pod =cut
  
  my %methods_for_op = (
    '==' => [ qw(exact_version) ],
    '!=' => [ qw(add_exclusion) ],
    '>=' => [ qw(add_minimum)   ],
    '<=' => [ qw(add_maximum)   ],
    '>'  => [ qw(add_minimum add_exclusion) ],
    '<'  => [ qw(add_maximum add_exclusion) ],
  );
  
  sub add_string_requirement {
    my ($self, $module, $req) = @_;
  
    unless ( defined $req && length $req ) {
      $req = 0;
      $self->_blank_carp($module);
    }
  
    my $magic = _find_magic_vstring( $req );
    if (length $magic) {
      $self->add_minimum($module => $magic);
      return;
    }
  
    my @parts = split qr{\s*,\s*}, $req;
  
    for my $part (@parts) {
      my ($op, $ver) = $part =~ m{\A\s*(==|>=|>|<=|<|!=)\s*(.*)\z};
  
      if (! defined $op) {
        $self->add_minimum($module => $part);
      } else {
        Carp::confess("illegal requirement string: $req")
          unless my $methods = $methods_for_op{ $op };
  
        $self->$_($module => $ver) for @$methods;
      }
    }
  }
  
  #pod =method from_string_hash
  #pod
  #pod   my $req = CPAN::Meta::Requirements->from_string_hash( \%hash );
  #pod   my $req = CPAN::Meta::Requirements->from_string_hash( \%hash, \%opts );
  #pod
  #pod This is an alternate constructor for a CPAN::Meta::Requirements
  #pod object. It takes a hash of module names and version requirement
  #pod strings and returns a new CPAN::Meta::Requirements object. As with
  #pod add_string_requirement, a version can be a Perl "v-string". Optionally,
  #pod you can supply a hash-reference of options, exactly as with the L</new>
  #pod method.
  #pod
  #pod =cut
  
  sub _blank_carp {
    my ($self, $module) = @_;
    Carp::carp("Undefined requirement for $module treated as '0'");
  }
  
  sub from_string_hash {
    my ($class, $hash, $options) = @_;
  
    my $self = $class->new($options);
  
    for my $module (keys %$hash) {
      my $req = $hash->{$module};
      unless ( defined $req && length $req ) {
        $req = 0;
        $class->_blank_carp($module);
      }
      $self->add_string_requirement($module, $req);
    }
  
    return $self;
  }
  
  ##############################################################
  
  {
    package
      CPAN::Meta::Requirements::_Range::Exact;
    sub _new     { bless { version => $_[1] } => $_[0] }
  
    sub _accepts { return $_[0]{version} == $_[1] }
  
    sub as_string { return "== $_[0]{version}" }
  
    sub as_struct { return [ [ '==', "$_[0]{version}" ] ] }
  
    sub as_modifiers { return [ [ exact_version => $_[0]{version} ] ] }
  
    sub _reject_requirements {
      my ($self, $module, $error) = @_;
      Carp::confess("illegal requirements for $module: $error")
    }
  
    sub _clone {
      (ref $_[0])->_new( version->new( $_[0]{version} ) )
    }
  
    sub with_exact_version {
      my ($self, $version, $module) = @_;
      $module = 'module' unless defined $module;
  
      return $self->_clone if $self->_accepts($version);
  
      $self->_reject_requirements(
        $module,
        "can't be exactly $version when exact requirement is already $self->{version}",
      );
    }
  
    sub with_minimum {
      my ($self, $minimum, $module) = @_;
      $module = 'module' unless defined $module;
  
      return $self->_clone if $self->{version} >= $minimum;
      $self->_reject_requirements(
        $module,
        "minimum $minimum exceeds exact specification $self->{version}",
      );
    }
  
    sub with_maximum {
      my ($self, $maximum, $module) = @_;
      $module = 'module' unless defined $module;
  
      return $self->_clone if $self->{version} <= $maximum;
      $self->_reject_requirements(
        $module,
        "maximum $maximum below exact specification $self->{version}",
      );
    }
  
    sub with_exclusion {
      my ($self, $exclusion, $module) = @_;
      $module = 'module' unless defined $module;
  
      return $self->_clone unless $exclusion == $self->{version};
      $self->_reject_requirements(
        $module,
        "tried to exclude $exclusion, which is already exactly specified",
      );
    }
  }
  
  ##############################################################
  
  {
    package
      CPAN::Meta::Requirements::_Range::Range;
  
    sub _self { ref($_[0]) ? $_[0] : (bless { } => $_[0]) }
  
    sub _clone {
      return (bless { } => $_[0]) unless ref $_[0];
  
      my ($s) = @_;
      my %guts = (
        (exists $s->{minimum} ? (minimum => version->new($s->{minimum})) : ()),
        (exists $s->{maximum} ? (maximum => version->new($s->{maximum})) : ()),
  
        (exists $s->{exclusions}
          ? (exclusions => [ map { version->new($_) } @{ $s->{exclusions} } ])
          : ()),
      );
  
      bless \%guts => ref($s);
    }
  
    sub as_modifiers {
      my ($self) = @_;
      my @mods;
      push @mods, [ add_minimum => $self->{minimum} ] if exists $self->{minimum};
      push @mods, [ add_maximum => $self->{maximum} ] if exists $self->{maximum};
      push @mods, map {; [ add_exclusion => $_ ] } @{$self->{exclusions} || []};
      return \@mods;
    }
  
    sub as_struct {
      my ($self) = @_;
  
      return 0 if ! keys %$self;
  
      my @exclusions = @{ $self->{exclusions} || [] };
  
      my @parts;
  
      for my $tuple (
        [ qw( >= > minimum ) ],
        [ qw( <= < maximum ) ],
      ) {
        my ($op, $e_op, $k) = @$tuple;
        if (exists $self->{$k}) {
          my @new_exclusions = grep { $_ != $self->{ $k } } @exclusions;
          if (@new_exclusions == @exclusions) {
            push @parts, [ $op, "$self->{ $k }" ];
          } else {
            push @parts, [ $e_op, "$self->{ $k }" ];
            @exclusions = @new_exclusions;
          }
        }
      }
  
      push @parts, map {; [ "!=", "$_" ] } @exclusions;
  
      return \@parts;
    }
  
    sub as_string {
      my ($self) = @_;
  
      my @parts = @{ $self->as_struct };
  
      return $parts[0][1] if @parts == 1 and $parts[0][0] eq '>=';
  
      return join q{, }, map {; join q{ }, @$_ } @parts;
    }
  
    sub _reject_requirements {
      my ($self, $module, $error) = @_;
      Carp::confess("illegal requirements for $module: $error")
    }
  
    sub with_exact_version {
      my ($self, $version, $module) = @_;
      $module = 'module' unless defined $module;
      $self = $self->_clone;
  
      unless ($self->_accepts($version)) {
        $self->_reject_requirements(
          $module,
          "exact specification $version outside of range " . $self->as_string
        );
      }
  
      return CPAN::Meta::Requirements::_Range::Exact->_new($version);
    }
  
    sub _simplify {
      my ($self, $module) = @_;
  
      if (defined $self->{minimum} and defined $self->{maximum}) {
        if ($self->{minimum} == $self->{maximum}) {
          if (grep { $_ == $self->{minimum} } @{ $self->{exclusions} || [] }) {
            $self->_reject_requirements(
              $module,
              "minimum and maximum are both $self->{minimum}, which is excluded",
            );
          }
  
          return CPAN::Meta::Requirements::_Range::Exact->_new($self->{minimum})
        }
  
        if ($self->{minimum} > $self->{maximum}) {
          $self->_reject_requirements(
            $module,
            "minimum $self->{minimum} exceeds maximum $self->{maximum}",
          );
        }
      }
  
      # eliminate irrelevant exclusions
      if ($self->{exclusions}) {
        my %seen;
        @{ $self->{exclusions} } = grep {
          (! defined $self->{minimum} or $_ >= $self->{minimum})
          and
          (! defined $self->{maximum} or $_ <= $self->{maximum})
          and
          ! $seen{$_}++
        } @{ $self->{exclusions} };
      }
  
      return $self;
    }
  
    sub with_minimum {
      my ($self, $minimum, $module) = @_;
      $module = 'module' unless defined $module;
      $self = $self->_clone;
  
      if (defined (my $old_min = $self->{minimum})) {
        $self->{minimum} = (sort { $b cmp $a } ($minimum, $old_min))[0];
      } else {
        $self->{minimum} = $minimum;
      }
  
      return $self->_simplify($module);
    }
  
    sub with_maximum {
      my ($self, $maximum, $module) = @_;
      $module = 'module' unless defined $module;
      $self = $self->_clone;
  
      if (defined (my $old_max = $self->{maximum})) {
        $self->{maximum} = (sort { $a cmp $b } ($maximum, $old_max))[0];
      } else {
        $self->{maximum} = $maximum;
      }
  
      return $self->_simplify($module);
    }
  
    sub with_exclusion {
      my ($self, $exclusion, $module) = @_;
      $module = 'module' unless defined $module;
      $self = $self->_clone;
  
      push @{ $self->{exclusions} ||= [] }, $exclusion;
  
      return $self->_simplify($module);
    }
  
    sub _accepts {
      my ($self, $version) = @_;
  
      return if defined $self->{minimum} and $version < $self->{minimum};
      return if defined $self->{maximum} and $version > $self->{maximum};
      return if defined $self->{exclusions}
            and grep { $version == $_ } @{ $self->{exclusions} };
  
      return 1;
    }
  }
  
  1;
  # vim: ts=2 sts=2 sw=2 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Requirements - a set of version requirements for a CPAN dist
  
  =head1 VERSION
  
  version 2.140
  
  =head1 SYNOPSIS
  
    use CPAN::Meta::Requirements;
  
    my $build_requires = CPAN::Meta::Requirements->new;
  
    $build_requires->add_minimum('Library::Foo' => 1.208);
  
    $build_requires->add_minimum('Library::Foo' => 2.602);
  
    $build_requires->add_minimum('Module::Bar'  => 'v1.2.3');
  
    $METAyml->{build_requires} = $build_requires->as_string_hash;
  
  =head1 DESCRIPTION
  
  A CPAN::Meta::Requirements object models a set of version constraints like
  those specified in the F<META.yml> or F<META.json> files in CPAN distributions,
  and as defined by L<CPAN::Meta::Spec>;
  It can be built up by adding more and more constraints, and it will reduce them
  to the simplest representation.
  
  Logically impossible constraints will be identified immediately by thrown
  exceptions.
  
  =head1 METHODS
  
  =head2 new
  
    my $req = CPAN::Meta::Requirements->new;
  
  This returns a new CPAN::Meta::Requirements object.  It takes an optional
  hash reference argument.  Currently, only one key is supported:
  
  =over 4
  
  =item *
  
  C<bad_version_hook> -- if provided, when a version cannot be parsed into a version object, this code reference will be called with the invalid version string as first argument, and the module name as second argument.  It must return a valid version object.
  
  =back
  
  All other keys are ignored.
  
  =head2 add_minimum
  
    $req->add_minimum( $module => $version );
  
  This adds a new minimum version requirement.  If the new requirement is
  redundant to the existing specification, this has no effect.
  
  Minimum requirements are inclusive.  C<$version> is required, along with any
  greater version number.
  
  This method returns the requirements object.
  
  =head2 add_maximum
  
    $req->add_maximum( $module => $version );
  
  This adds a new maximum version requirement.  If the new requirement is
  redundant to the existing specification, this has no effect.
  
  Maximum requirements are inclusive.  No version strictly greater than the given
  version is allowed.
  
  This method returns the requirements object.
  
  =head2 add_exclusion
  
    $req->add_exclusion( $module => $version );
  
  This adds a new excluded version.  For example, you might use these three
  method calls:
  
    $req->add_minimum( $module => '1.00' );
    $req->add_maximum( $module => '1.82' );
  
    $req->add_exclusion( $module => '1.75' );
  
  Any version between 1.00 and 1.82 inclusive would be acceptable, except for
  1.75.
  
  This method returns the requirements object.
  
  =head2 exact_version
  
    $req->exact_version( $module => $version );
  
  This sets the version required for the given module to I<exactly> the given
  version.  No other version would be considered acceptable.
  
  This method returns the requirements object.
  
  =head2 add_requirements
  
    $req->add_requirements( $another_req_object );
  
  This method adds all the requirements in the given CPAN::Meta::Requirements
  object to the requirements object on which it was called.  If there are any
  conflicts, an exception is thrown.
  
  This method returns the requirements object.
  
  =head2 accepts_module
  
    my $bool = $req->accepts_module($module => $version);
  
  Given an module and version, this method returns true if the version
  specification for the module accepts the provided version.  In other words,
  given:
  
    Module => '>= 1.00, < 2.00'
  
  We will accept 1.00 and 1.75 but not 0.50 or 2.00.
  
  For modules that do not appear in the requirements, this method will return
  true.
  
  =head2 clear_requirement
  
    $req->clear_requirement( $module );
  
  This removes the requirement for a given module from the object.
  
  This method returns the requirements object.
  
  =head2 requirements_for_module
  
    $req->requirements_for_module( $module );
  
  This returns a string containing the version requirements for a given module in
  the format described in L<CPAN::Meta::Spec> or undef if the given module has no
  requirements. This should only be used for informational purposes such as error
  messages and should not be interpreted or used for comparison (see
  L</accepts_module> instead).
  
  =head2 structured_requirements_for_module
  
    $req->structured_requirements_for_module( $module );
  
  This returns a data structure containing the version requirements for a given
  module or undef if the given module has no requirements.  This should
  not be used for version checks (see L</accepts_module> instead).
  
  Added in version 2.134.
  
  =head2 required_modules
  
  This method returns a list of all the modules for which requirements have been
  specified.
  
  =head2 clone
  
    $req->clone;
  
  This method returns a clone of the invocant.  The clone and the original object
  can then be changed independent of one another.
  
  =head2 is_simple
  
  This method returns true if and only if all requirements are inclusive minimums
  -- that is, if their string expression is just the version number.
  
  =head2 is_finalized
  
  This method returns true if the requirements have been finalized by having the
  C<finalize> method called on them.
  
  =head2 finalize
  
  This method marks the requirements finalized.  Subsequent attempts to change
  the requirements will be fatal, I<if> they would result in a change.  If they
  would not alter the requirements, they have no effect.
  
  If a finalized set of requirements is cloned, the cloned requirements are not
  also finalized.
  
  =head2 as_string_hash
  
  This returns a reference to a hash describing the requirements using the
  strings in the L<CPAN::Meta::Spec> specification.
  
  For example after the following program:
  
    my $req = CPAN::Meta::Requirements->new;
  
    $req->add_minimum('CPAN::Meta::Requirements' => 0.102);
  
    $req->add_minimum('Library::Foo' => 1.208);
  
    $req->add_maximum('Library::Foo' => 2.602);
  
    $req->add_minimum('Module::Bar'  => 'v1.2.3');
  
    $req->add_exclusion('Module::Bar'  => 'v1.2.8');
  
    $req->exact_version('Xyzzy'  => '6.01');
  
    my $hashref = $req->as_string_hash;
  
  C<$hashref> would contain:
  
    {
      'CPAN::Meta::Requirements' => '0.102',
      'Library::Foo' => '>= 1.208, <= 2.206',
      'Module::Bar'  => '>= v1.2.3, != v1.2.8',
      'Xyzzy'        => '== 6.01',
    }
  
  =head2 add_string_requirement
  
    $req->add_string_requirement('Library::Foo' => '>= 1.208, <= 2.206');
    $req->add_string_requirement('Library::Foo' => v1.208);
  
  This method parses the passed in string and adds the appropriate requirement
  for the given module.  A version can be a Perl "v-string".  It understands
  version ranges as described in the L<CPAN::Meta::Spec/Version Ranges>. For
  example:
  
  =over 4
  
  =item 1.3
  
  =item >= 1.3
  
  =item <= 1.3
  
  =item == 1.3
  
  =item != 1.3
  
  =item > 1.3
  
  =item < 1.3
  
  =item >= 1.3, != 1.5, <= 2.0
  
  A version number without an operator is equivalent to specifying a minimum
  (C<E<gt>=>).  Extra whitespace is allowed.
  
  =back
  
  =head2 from_string_hash
  
    my $req = CPAN::Meta::Requirements->from_string_hash( \%hash );
    my $req = CPAN::Meta::Requirements->from_string_hash( \%hash, \%opts );
  
  This is an alternate constructor for a CPAN::Meta::Requirements
  object. It takes a hash of module names and version requirement
  strings and returns a new CPAN::Meta::Requirements object. As with
  add_string_requirement, a version can be a Perl "v-string". Optionally,
  you can supply a hash-reference of options, exactly as with the L</new>
  method.
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/Perl-Toolchain-Gang/CPAN-Meta-Requirements/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/Perl-Toolchain-Gang/CPAN-Meta-Requirements>
  
    git clone https://github.com/Perl-Toolchain-Gang/CPAN-Meta-Requirements.git
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =back
  
  =head1 CONTRIBUTORS
  
  =for stopwords Ed J Karen Etheridge Leon Timmermans robario
  
  =over 4
  
  =item *
  
  Ed J <mohawk2@users.noreply.github.com>
  
  =item *
  
  Karen Etheridge <ether@cpan.org>
  
  =item *
  
  Leon Timmermans <fawaka@gmail.com>
  
  =item *
  
  robario <webmaster@robario.com>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden and Ricardo Signes.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
CPAN_META_REQUIREMENTS

$fatpacked{"CPAN/Meta/Spec.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_SPEC';
  # XXX RULES FOR PATCHING THIS FILE XXX
  # Patches that fix typos or formatting are acceptable.  Patches
  # that change semantics are not acceptable without prior approval
  # by David Golden or Ricardo Signes.
  
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::Spec;
  
  our $VERSION = '2.150010';
  
  1;
  
  # ABSTRACT: specification for CPAN distribution metadata
  
  
  # vi:tw=72
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Spec - specification for CPAN distribution metadata
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 SYNOPSIS
  
    my $distmeta = {
      name => 'Module-Build',
      abstract => 'Build and install Perl modules',
      description =>  "Module::Build is a system for "
        . "building, testing, and installing Perl modules. "
        . "It is meant to ... blah blah blah ...",
      version  => '0.36',
      release_status => 'stable',
      author   => [
        'Ken Williams <kwilliams@cpan.org>',
        'Module-Build List <module-build@perl.org>', # additional contact
      ],
      license  => [ 'perl_5' ],
      prereqs => {
        runtime => {
          requires => {
            'perl'   => '5.006',
            'ExtUtils::Install' => '0',
            'File::Basename' => '0',
            'File::Compare'  => '0',
            'IO::File'   => '0',
          },
          recommends => {
            'Archive::Tar' => '1.00',
            'ExtUtils::Install' => '0.3',
            'ExtUtils::ParseXS' => '2.02',
          },
        },
        build => {
          requires => {
            'Test::More' => '0',
          },
        }
      },
      resources => {
        license => ['http://dev.perl.org/licenses/'],
      },
      optional_features => {
        domination => {
          description => 'Take over the world',
          prereqs     => {
            develop => { requires => { 'Genius::Evil'     => '1.234' } },
            runtime => { requires => { 'Machine::Weather' => '2.0'   } },
          },
        },
      },
      dynamic_config => 1,
      keywords => [ qw/ toolchain cpan dual-life / ],
      'meta-spec' => {
        version => '2',
        url     => 'https://metacpan.org/pod/CPAN::Meta::Spec',
      },
      generated_by => 'Module::Build version 0.36',
    };
  
  =head1 DESCRIPTION
  
  This document describes version 2 of the CPAN distribution metadata
  specification, also known as the "CPAN Meta Spec".
  
  Revisions of this specification for typo corrections and prose
  clarifications may be issued as CPAN::Meta::Spec 2.I<x>.  These
  revisions will never change semantics or add or remove specified
  behavior.
  
  Distribution metadata describe important properties of Perl
  distributions. Distribution building tools like Module::Build,
  Module::Install, ExtUtils::MakeMaker or Dist::Zilla should create a
  metadata file in accordance with this specification and include it with
  the distribution for use by automated tools that index, examine, package
  or install Perl distributions.
  
  =head1 TERMINOLOGY
  
  =over 4
  
  =item distribution
  
  This is the primary object described by the metadata. In the context of
  this document it usually refers to a collection of modules, scripts,
  and/or documents that are distributed together for other developers to
  use.  Examples of distributions are C<Class-Container>, C<libwww-perl>,
  or C<DBI>.
  
  =item module
  
  This refers to a reusable library of code contained in a single file.
  Modules usually contain one or more packages and are often referred
  to by the name of a primary package that can be mapped to the file
  name. For example, one might refer to C<File::Spec> instead of
  F<File/Spec.pm>
  
  =item package
  
  This refers to a namespace declared with the Perl C<package> statement.
  In Perl, packages often have a version number property given by the
  C<$VERSION> variable in the namespace.
  
  =item consumer
  
  This refers to code that reads a metadata file, deserializes it into a
  data structure in memory, or interprets a data structure of metadata
  elements.
  
  =item producer
  
  This refers to code that constructs a metadata data structure,
  serializes into a bytestream and/or writes it to disk.
  
  =item must, should, may, etc.
  
  These terms are interpreted as described in IETF RFC 2119.
  
  =back
  
  =head1 DATA TYPES
  
  Fields in the L</STRUCTURE> section describe data elements, each of
  which has an associated data type as described herein.  There are four
  primitive types: Boolean, String, List and Map.  Other types are
  subtypes of primitives and define compound data structures or define
  constraints on the values of a data element.
  
  =head2 Boolean
  
  A I<Boolean> is used to provide a true or false value.  It B<must> be
  represented as a defined value that is either "1" or "0" or stringifies
  to those values.
  
  =head2 String
  
  A I<String> is data element containing a non-zero length sequence of
  Unicode characters, such as an ordinary Perl scalar that is not a
  reference.
  
  =head2 List
  
  A I<List> is an ordered collection of zero or more data elements.
  Elements of a List may be of mixed types.
  
  Producers B<must> represent List elements using a data structure which
  unambiguously indicates that multiple values are possible, such as a
  reference to a Perl array (an "arrayref").
  
  Consumers expecting a List B<must> consider a String as equivalent to a
  List of length 1.
  
  =head2 Map
  
  A I<Map> is an unordered collection of zero or more data elements
  ("values"), indexed by associated String elements ("keys").  The Map's
  value elements may be of mixed types.
  
  =head2 License String
  
  A I<License String> is a subtype of String with a restricted set of
  values.  Valid values are described in detail in the description of
  the L</license> field.
  
  =head2 URL
  
  I<URL> is a subtype of String containing a Uniform Resource Locator or
  Identifier.  [ This type is called URL and not URI for historical reasons. ]
  
  =head2 Version
  
  A I<Version> is a subtype of String containing a value that describes
  the version number of packages or distributions.  Restrictions on format
  are described in detail in the L</Version Formats> section.
  
  =head2 Version Range
  
  The I<Version Range> type is a subtype of String.  It describes a range
  of Versions that may be present or installed to fulfill prerequisites.
  It is specified in detail in the L</Version Ranges> section.
  
  =head1 STRUCTURE
  
  The metadata structure is a data element of type Map.  This section
  describes valid keys within the Map.
  
  Any keys not described in this specification document (whether top-level
  or within compound data structures described herein) are considered
  I<custom keys> and B<must> begin with an "x" or "X" and be followed by an
  underscore; i.e. they must match the pattern: C<< qr{\Ax_}i >>.  If a
  custom key refers to a compound data structure, subkeys within it do not
  need an "x_" or "X_" prefix.
  
  Consumers of metadata may ignore any or all custom keys.  All other keys
  not described herein are invalid and should be ignored by consumers.
  Producers must not generate or output invalid keys.
  
  For each key, an example is provided followed by a description.  The
  description begins with the version of spec in which the key was added
  or in which the definition was modified, whether the key is I<required>
  or I<optional> and the data type of the corresponding data element.
  These items are in parentheses, brackets and braces, respectively.
  
  If a data type is a Map or Map subtype, valid subkeys will be described
  as well.
  
  Some fields are marked I<Deprecated>.  These are shown for historical
  context and must not be produced in or consumed from any metadata structure
  of version 2 or higher.
  
  =head2 REQUIRED FIELDS
  
  =head3 abstract
  
  Example:
  
    abstract => 'Build and install Perl modules'
  
  (Spec 1.2) [required] {String}
  
  This is a short description of the purpose of the distribution.
  
  =head3 author
  
  Example:
  
    author => [ 'Ken Williams <kwilliams@cpan.org>' ]
  
  (Spec 1.2) [required] {List of one or more Strings}
  
  This List indicates the person(s) to contact concerning the
  distribution. The preferred form of the contact string is:
  
    contact-name <email-address>
  
  This field provides a general contact list independent of other
  structured fields provided within the L</resources> field, such as
  C<bugtracker>.  The addressee(s) can be contacted for any purpose
  including but not limited to (security) problems with the distribution,
  questions about the distribution or bugs in the distribution.
  
  A distribution's original author is usually the contact listed within
  this field.  Co-maintainers, successor maintainers or mailing lists
  devoted to the distribution may also be listed in addition to or instead
  of the original author.
  
  =head3 dynamic_config
  
  Example:
  
    dynamic_config => 1
  
  (Spec 2) [required] {Boolean}
  
  A boolean flag indicating whether a F<Build.PL> or F<Makefile.PL> (or
  similar) must be executed to determine prerequisites.
  
  This field should be set to a true value if the distribution performs
  some dynamic configuration (asking questions, sensing the environment,
  etc.) as part of its configuration.  This field should be set to a false
  value to indicate that prerequisites included in metadata may be
  considered final and valid for static analysis.
  
  Note: when this field is true, post-configuration prerequisites are not
  guaranteed to bear any relation whatsoever to those stated in the metadata,
  and relying on them doing so is an error. See also
  L</Prerequisites for dynamically configured distributions> in the implementors'
  notes.
  
  This field explicitly B<does not> indicate whether installation may be
  safely performed without using a Makefile or Build file, as there may be
  special files to install or custom installation targets (e.g. for
  dual-life modules that exist on CPAN as well as in the Perl core).  This
  field only defines whether or not prerequisites are exactly as given in the
  metadata.
  
  =head3 generated_by
  
  Example:
  
    generated_by => 'Module::Build version 0.36'
  
  (Spec 1.0) [required] {String}
  
  This field indicates the tool that was used to create this metadata.
  There are no defined semantics for this field, but it is traditional to
  use a string in the form "Generating::Package version 1.23" or the
  author's name, if the file was generated by hand.
  
  =head3 license
  
  Example:
  
    license => [ 'perl_5' ]
  
    license => [ 'apache_2_0', 'mozilla_1_0' ]
  
  (Spec 2) [required] {List of one or more License Strings}
  
  One or more licenses that apply to some or all of the files in the
  distribution.  If multiple licenses are listed, the distribution
  documentation should be consulted to clarify the interpretation of
  multiple licenses.
  
  The following list of license strings are valid:
  
   string          description
   -------------   -----------------------------------------------
   agpl_3          GNU Affero General Public License, Version 3
   apache_1_1      Apache Software License, Version 1.1
   apache_2_0      Apache License, Version 2.0
   artistic_1      Artistic License, (Version 1)
   artistic_2      Artistic License, Version 2.0
   bsd             BSD License (three-clause)
   freebsd         FreeBSD License (two-clause)
   gfdl_1_2        GNU Free Documentation License, Version 1.2
   gfdl_1_3        GNU Free Documentation License, Version 1.3
   gpl_1           GNU General Public License, Version 1
   gpl_2           GNU General Public License, Version 2
   gpl_3           GNU General Public License, Version 3
   lgpl_2_1        GNU Lesser General Public License, Version 2.1
   lgpl_3_0        GNU Lesser General Public License, Version 3.0
   mit             MIT (aka X11) License
   mozilla_1_0     Mozilla Public License, Version 1.0
   mozilla_1_1     Mozilla Public License, Version 1.1
   openssl         OpenSSL License
   perl_5          The Perl 5 License (Artistic 1 & GPL 1 or later)
   qpl_1_0         Q Public License, Version 1.0
   ssleay          Original SSLeay License
   sun             Sun Internet Standards Source License (SISSL)
   zlib            zlib License
  
  The following license strings are also valid and indicate other
  licensing not described above:
  
   string          description
   -------------   -----------------------------------------------
   open_source     Other Open Source Initiative (OSI) approved license
   restricted      Requires special permission from copyright holder
   unrestricted    Not an OSI approved license, but not restricted
   unknown         License not provided in metadata
  
  All other strings are invalid in the license field.
  
  =head3 meta-spec
  
  Example:
  
    'meta-spec' => {
      version => '2',
      url     => 'http://search.cpan.org/perldoc?CPAN::Meta::Spec',
    }
  
  (Spec 1.2) [required] {Map}
  
  This field indicates the version of the CPAN Meta Spec that should be
  used to interpret the metadata.  Consumers must check this key as soon
  as possible and abort further metadata processing if the meta-spec
  version is not supported by the consumer.
  
  The following keys are valid, but only C<version> is required.
  
  =over
  
  =item version
  
  This subkey gives the integer I<Version> of the CPAN Meta Spec against
  which the document was generated.
  
  =item url
  
  This is a I<URL> of the metadata specification document corresponding to
  the given version.  This is strictly for human-consumption and should
  not impact the interpretation of the document.
  
  For the version 2 spec, either of these are recommended:
  
  =over 4
  
  =item *
  
  C<https://metacpan.org/pod/CPAN::Meta::Spec>
  
  =item *
  
  C<http://search.cpan.org/perldoc?CPAN::Meta::Spec>
  
  =back
  
  =back
  
  =head3 name
  
  Example:
  
    name => 'Module-Build'
  
  (Spec 1.0) [required] {String}
  
  This field is the name of the distribution.  This is often created by
  taking the "main package" in the distribution and changing C<::> to
  C<->, but the name may be completely unrelated to the packages within
  the distribution.  For example, L<LWP::UserAgent> is distributed as part
  of the distribution name "libwww-perl".
  
  =head3 release_status
  
  Example:
  
    release_status => 'stable'
  
  (Spec 2) [required] {String}
  
  This field provides the  release status of this distribution.  If the
  C<version> field contains an underscore character, then
  C<release_status> B<must not> be "stable."
  
  The C<release_status> field B<must> have one of the following values:
  
  =over
  
  =item stable
  
  This indicates an ordinary, "final" release that should be indexed by PAUSE
  or other indexers.
  
  =item testing
  
  This indicates a "beta" release that is substantially complete, but has an
  elevated risk of bugs and requires additional testing.  The distribution
  should not be installed over a stable release without an explicit request
  or other confirmation from a user.  This release status may also be used
  for "release candidate" versions of a distribution.
  
  =item unstable
  
  This indicates an "alpha" release that is under active development, but has
  been released for early feedback or testing and may be missing features or
  may have serious bugs.  The distribution should not be installed over a
  stable release without an explicit request or other confirmation from a
  user.
  
  =back
  
  Consumers B<may> use this field to determine how to index the
  distribution for CPAN or other repositories in addition to or in
  replacement of heuristics based on version number or file name.
  
  =head3 version
  
  Example:
  
    version => '0.36'
  
  (Spec 1.0) [required] {Version}
  
  This field gives the version of the distribution to which the metadata
  structure refers.
  
  =head2 OPTIONAL FIELDS
  
  =head3 description
  
  Example:
  
      description =>  "Module::Build is a system for "
        . "building, testing, and installing Perl modules. "
        . "It is meant to ... blah blah blah ...",
  
  (Spec 2) [optional] {String}
  
  A longer, more complete description of the purpose or intended use of
  the distribution than the one provided by the C<abstract> key.
  
  =head3 keywords
  
  Example:
  
    keywords => [ qw/ toolchain cpan dual-life / ]
  
  (Spec 1.1) [optional] {List of zero or more Strings}
  
  A List of keywords that describe this distribution.  Keywords
  B<must not> include whitespace.
  
  =head3 no_index
  
  Example:
  
    no_index => {
      file      => [ 'My/Module.pm' ],
      directory => [ 'My/Private' ],
      package   => [ 'My::Module::Secret' ],
      namespace => [ 'My::Module::Sample' ],
    }
  
  (Spec 1.2) [optional] {Map}
  
  This Map describes any files, directories, packages, and namespaces that
  are private to the packaging or implementation of the distribution and
  should be ignored by indexing or search tools. Note that this is a list of
  exclusions, and the spec does not define what to I<include> - see
  L</Indexing distributions a la PAUSE> in the implementors notes for more
  information.
  
  Valid subkeys are as follows:
  
  =over
  
  =item file
  
  A I<List> of relative paths to files.  Paths B<must be> specified with
  unix conventions.
  
  =item directory
  
  A I<List> of relative paths to directories.  Paths B<must be> specified
  with unix conventions.
  
  [ Note: previous editions of the spec had C<dir> instead of C<directory> ]
  
  =item package
  
  A I<List> of package names.
  
  =item namespace
  
  A I<List> of package namespaces, where anything below the namespace
  must be ignored, but I<not> the namespace itself.
  
  In the example above for C<no_index>, C<My::Module::Sample::Foo> would
  be ignored, but C<My::Module::Sample> would not.
  
  =back
  
  =head3 optional_features
  
  Example:
  
    optional_features => {
      sqlite => {
        description => 'Provides SQLite support',
        prereqs => {
          runtime => {
            requires => {
              'DBD::SQLite' => '1.25'
            }
          }
        }
      }
    }
  
  (Spec 2) [optional] {Map}
  
  This Map describes optional features with incremental prerequisites.
  Each key of the C<optional_features> Map is a String used to identify
  the feature and each value is a Map with additional information about
  the feature.  Valid subkeys include:
  
  =over
  
  =item description
  
  This is a String describing the feature.  Every optional feature
  should provide a description
  
  =item prereqs
  
  This entry is required and has the same structure as that of the
  C<L</prereqs>> key.  It provides a list of package requirements
  that must be satisfied for the feature to be supported or enabled.
  
  There is one crucial restriction:  the prereqs of an optional feature
  B<must not> include C<configure> phase prereqs.
  
  =back
  
  Consumers B<must not> include optional features as prerequisites without
  explicit instruction from users (whether via interactive prompting,
  a function parameter or a configuration value, etc. ).
  
  If an optional feature is used by a consumer to add additional
  prerequisites, the consumer should merge the optional feature
  prerequisites into those given by the C<prereqs> key using the same
  semantics.  See L</Merging and Resolving Prerequisites> for details on
  merging prerequisites.
  
  I<Suggestion for disuse:> Because there is currently no way for a
  distribution to specify a dependency on an optional feature of another
  dependency, the use of C<optional_feature> is discouraged.  Instead,
  create a separate, installable distribution that ensures the desired
  feature is available.  For example, if C<Foo::Bar> has a C<Baz> feature,
  release a separate C<Foo-Bar-Baz> distribution that satisfies
  requirements for the feature.
  
  =head3 prereqs
  
  Example:
  
    prereqs => {
      runtime => {
        requires => {
          'perl'          => '5.006',
          'File::Spec'    => '0.86',
          'JSON'          => '2.16',
        },
        recommends => {
          'JSON::XS'      => '2.26',
        },
        suggests => {
          'Archive::Tar'  => '0',
        },
      },
      build => {
        requires => {
          'Alien::SDL'    => '1.00',
        },
      },
      test => {
        recommends => {
          'Test::Deep'    => '0.10',
        },
      }
    }
  
  (Spec 2) [optional] {Map}
  
  This is a Map that describes all the prerequisites of the distribution.
  The keys are phases of activity, such as C<configure>, C<build>, C<test>
  or C<runtime>.  Values are Maps in which the keys name the type of
  prerequisite relationship such as C<requires>, C<recommends>, or
  C<suggests> and the value provides a set of prerequisite relations.  The
  set of relations B<must> be specified as a Map of package names to
  version ranges.
  
  The full definition for this field is given in the L</Prereq Spec>
  section.
  
  =head3 provides
  
  Example:
  
    provides => {
      'Foo::Bar' => {
        file    => 'lib/Foo/Bar.pm',
        version => '0.27_02',
      },
      'Foo::Bar::Blah' => {
        file    => 'lib/Foo/Bar/Blah.pm',
      },
      'Foo::Bar::Baz' => {
        file    => 'lib/Foo/Bar/Baz.pm',
        version => '0.3',
      },
    }
  
  (Spec 1.2) [optional] {Map}
  
  This describes all packages provided by this distribution.  This
  information is used by distribution and automation mechanisms like
  PAUSE, CPAN, metacpan.org and search.cpan.org to build indexes saying in
  which distribution various packages can be found.
  
  The keys of C<provides> are package names that can be found within
  the distribution.  If a package name key is provided, it must
  have a Map with the following valid subkeys:
  
  =over
  
  =item file
  
  This field is required.  It must contain a Unix-style relative file path
  from the root of the distribution directory to a file that contains or
  generates the package.  It may be given as C<META.yml> or C<META.json>
  to claim a package for indexing without needing a C<*.pm>.
  
  =item version
  
  If it exists, this field must contains a I<Version> String for the
  package.  If the package does not have a C<$VERSION>, this field must
  be omitted.
  
  =back
  
  =head3 resources
  
  Example:
  
    resources => {
      license     => [ 'http://dev.perl.org/licenses/' ],
      homepage    => 'http://sourceforge.net/projects/module-build',
      bugtracker  => {
        web    => 'http://rt.cpan.org/Public/Dist/Display.html?Name=CPAN-Meta',
        mailto => 'meta-bugs@example.com',
      },
      repository  => {
        url  => 'git://github.com/dagolden/cpan-meta.git',
        web  => 'http://github.com/dagolden/cpan-meta',
        type => 'git',
      },
      x_twitter   => 'http://twitter.com/cpan_linked/',
    }
  
  (Spec 2) [optional] {Map}
  
  This field describes resources related to this distribution.
  
  Valid subkeys include:
  
  =over
  
  =item homepage
  
  The official home of this project on the web.
  
  =item license
  
  A List of I<URL>'s that relate to this distribution's license.  As with the
  top-level C<license> field, distribution documentation should be consulted
  to clarify the interpretation of multiple licenses provided here.
  
  =item bugtracker
  
  This entry describes the bug tracking system for this distribution.  It
  is a Map with the following valid keys:
  
    web    - a URL pointing to a web front-end for the bug tracker
    mailto - an email address to which bugs can be sent
  
  =item repository
  
  This entry describes the source control repository for this distribution.  It
  is a Map with the following valid keys:
  
    url  - a URL pointing to the repository itself
    web  - a URL pointing to a web front-end for the repository
    type - a lowercase string indicating the VCS used
  
  Because a url like C<http://myrepo.example.com/> is ambiguous as to
  type, producers should provide a C<type> whenever a C<url> key is given.
  The C<type> field should be the name of the most common program used
  to work with the repository, e.g. C<git>, C<svn>, C<cvs>, C<darcs>,
  C<bzr> or C<hg>.
  
  =back
  
  =head2 DEPRECATED FIELDS
  
  =head3 build_requires
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  Replaced by C<prereqs>
  
  =head3 configure_requires
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  Replaced by C<prereqs>
  
  =head3 conflicts
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  Replaced by C<prereqs>
  
  =head3 distribution_type
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  This field indicated 'module' or 'script' but was considered
  meaningless, since many distributions are hybrids of several kinds of
  things.
  
  =head3 license_uri
  
  I<(Deprecated in Spec 1.2)> [optional] {URL}
  
  Replaced by C<license> in C<resources>
  
  =head3 private
  
  I<(Deprecated in Spec 1.2)> [optional] {Map}
  
  This field has been renamed to L</"no_index">.
  
  =head3 recommends
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  Replaced by C<prereqs>
  
  =head3 requires
  
  I<(Deprecated in Spec 2)> [optional] {String}
  
  Replaced by C<prereqs>
  
  =head1 VERSION NUMBERS
  
  =head2 Version Formats
  
  This section defines the Version type, used by several fields in the
  CPAN Meta Spec.
  
  Version numbers must be treated as strings, not numbers.  For
  example, C<1.200> B<must not> be serialized as C<1.2>.  Version
  comparison should be delegated to the Perl L<version> module, version
  0.80 or newer.
  
  Unless otherwise specified, version numbers B<must> appear in one of two
  formats:
  
  =over
  
  =item Decimal versions
  
  Decimal versions are regular "decimal numbers", with some limitations.
  They B<must> be non-negative and B<must> begin and end with a digit.  A
  single underscore B<may> be included, but B<must> be between two digits.
  They B<must not> use exponential notation ("1.23e-2").
  
     version => '1.234'       # OK
     version => '1.23_04'     # OK
  
     version => '1.23_04_05'  # Illegal
     version => '1.'          # Illegal
     version => '.1'          # Illegal
  
  =item Dotted-integer versions
  
  Dotted-integer (also known as dotted-decimal) versions consist of
  positive integers separated by full stop characters (i.e. "dots",
  "periods" or "decimal points").  This are equivalent in format to Perl
  "v-strings", with some additional restrictions on form.  They must be
  given in "normal" form, which has a leading "v" character and at least
  three integer components.  To retain a one-to-one mapping with decimal
  versions, all components after the first B<should> be restricted to the
  range 0 to 999.  The final component B<may> be separated by an
  underscore character instead of a period.
  
     version => 'v1.2.3'      # OK
     version => 'v1.2_3'      # OK
     version => 'v1.2.3.4'    # OK
     version => 'v1.2.3_4'    # OK
     version => 'v2009.10.31' # OK
  
     version => 'v1.2'          # Illegal
     version => '1.2.3'         # Illegal
     version => 'v1.2_3_4'      # Illegal
     version => 'v1.2009.10.31' # Not recommended
  
  =back
  
  =head2 Version Ranges
  
  Some fields (prereq, optional_features) indicate the particular
  version(s) of some other module that may be required as a prerequisite.
  This section details the Version Range type used to provide this
  information.
  
  The simplest format for a Version Range is just the version
  number itself, e.g. C<2.4>.  This means that B<at least> version 2.4
  must be present.  To indicate that B<any> version of a prerequisite is
  okay, even if the prerequisite doesn't define a version at all, use
  the version C<0>.
  
  Alternatively, a version range B<may> use the operators E<lt> (less than),
  E<lt>= (less than or equal), E<gt> (greater than), E<gt>= (greater than
  or equal), == (equal), and != (not equal).  For example, the
  specification C<E<lt> 2.0> means that any version of the prerequisite
  less than 2.0 is suitable.
  
  For more complicated situations, version specifications B<may> be AND-ed
  together using commas.  The specification C<E<gt>= 1.2, != 1.5, E<lt>
  2.0> indicates a version that must be B<at least> 1.2, B<less than> 2.0,
  and B<not equal to> 1.5.
  
  =head1 PREREQUISITES
  
  =head2 Prereq Spec
  
  The C<prereqs> key in the top-level metadata and within
  C<optional_features> define the relationship between a distribution and
  other packages.  The prereq spec structure is a hierarchical data
  structure which divides prerequisites into I<Phases> of activity in the
  installation process and I<Relationships> that indicate how
  prerequisites should be resolved.
  
  For example, to specify that C<Data::Dumper> is C<required> during the
  C<test> phase, this entry would appear in the distribution metadata:
  
    prereqs => {
      test => {
        requires => {
          'Data::Dumper' => '2.00'
        }
      }
    }
  
  =head3 Phases
  
  Requirements for regular use must be listed in the C<runtime> phase.
  Other requirements should be listed in the earliest stage in which they
  are required and consumers must accumulate and satisfy requirements
  across phases before executing the activity. For example, C<build>
  requirements must also be available during the C<test> phase.
  
    before action       requirements that must be met
    ----------------    --------------------------------
    perl Build.PL       configure
    perl Makefile.PL
  
    make                configure, runtime, build
    Build
  
    make test           configure, runtime, build, test
    Build test
  
  Consumers that install the distribution must ensure that
  I<runtime> requirements are also installed and may install
  dependencies from other phases.
  
    after action        requirements that must be met
    ----------------    --------------------------------
    make install        runtime
    Build install
  
  =over
  
  =item configure
  
  The configure phase occurs before any dynamic configuration has been
  attempted.  Libraries required by the configure phase B<must> be
  available for use before the distribution building tool has been
  executed.
  
  =item build
  
  The build phase is when the distribution's source code is compiled (if
  necessary) and otherwise made ready for installation.
  
  =item test
  
  The test phase is when the distribution's automated test suite is run.
  Any library that is needed only for testing and not for subsequent use
  should be listed here.
  
  =item runtime
  
  The runtime phase refers not only to when the distribution's contents
  are installed, but also to its continued use.  Any library that is a
  prerequisite for regular use of this distribution should be indicated
  here.
  
  =item develop
  
  The develop phase's prereqs are libraries needed to work on the
  distribution's source code as its author does.  These tools might be
  needed to build a release tarball, to run author-only tests, or to
  perform other tasks related to developing new versions of the
  distribution.
  
  =back
  
  =head3 Relationships
  
  =over
  
  =item requires
  
  These dependencies B<must> be installed for proper completion of the
  phase.
  
  =item recommends
  
  Recommended dependencies are I<strongly> encouraged and should be
  satisfied except in resource constrained environments.
  
  =item suggests
  
  These dependencies are optional, but are suggested for enhanced operation
  of the described distribution.
  
  =item conflicts
  
  These libraries cannot be installed when the phase is in operation.
  This is a very rare situation, and the C<conflicts> relationship should
  be used with great caution, or not at all.
  
  =back
  
  =head2 Merging and Resolving Prerequisites
  
  Whenever metadata consumers merge prerequisites, either from different
  phases or from C<optional_features>, they should merged in a way which
  preserves the intended semantics of the prerequisite structure.  Generally,
  this means concatenating the version specifications using commas, as
  described in the L<Version Ranges> section.
  
  Another subtle error that can occur in resolving prerequisites comes from
  the way that modules in prerequisites are indexed to distribution files on
  CPAN.  When a module is deleted from a distribution, prerequisites calling
  for that module could indicate an older distribution should be installed,
  potentially overwriting files from a newer distribution.
  
  For example, as of Oct 31, 2009, the CPAN index file contained these
  module-distribution mappings:
  
    Class::MOP                   0.94  D/DR/DROLSKY/Class-MOP-0.94.tar.gz
    Class::MOP::Class            0.94  D/DR/DROLSKY/Class-MOP-0.94.tar.gz
    Class::MOP::Class::Immutable 0.04  S/ST/STEVAN/Class-MOP-0.36.tar.gz
  
  Consider the case where "Class::MOP" 0.94 is installed.  If a
  distribution specified "Class::MOP::Class::Immutable" as a prerequisite,
  it could result in Class-MOP-0.36.tar.gz being installed, overwriting
  any files from Class-MOP-0.94.tar.gz.
  
  Consumers of metadata B<should> test whether prerequisites would result
  in installed module files being "downgraded" to an older version and
  B<may> warn users or ignore the prerequisite that would cause such a
  result.
  
  =head1 SERIALIZATION
  
  Distribution metadata should be serialized (as a hashref) as
  JSON-encoded data and packaged with distributions as the file
  F<META.json>.
  
  In the past, the distribution metadata structure had been packed with
  distributions as F<META.yml>, a file in the YAML Tiny format (for which,
  see L<YAML::Tiny>).  Tools that consume distribution metadata from disk
  should be capable of loading F<META.yml>, but should prefer F<META.json>
  if both are found.
  
  =head1 NOTES FOR IMPLEMENTORS
  
  =head2 Extracting Version Numbers from Perl Modules
  
  To get the version number from a Perl module, consumers should use the
  C<< MM->parse_version($file) >> method provided by
  L<ExtUtils::MakeMaker> or L<Module::Metadata>.  For example, for the
  module given by C<$mod>, the version may be retrieved in one of the
  following ways:
  
    # via ExtUtils::MakeMaker
    my $file = MM->_installed_file_for_module($mod);
    my $version = MM->parse_version($file)
  
  The private C<_installed_file_for_module> method may be replaced with
  other methods for locating a module in C<@INC>.
  
    # via Module::Metadata
    my $info = Module::Metadata->new_from_module($mod);
    my $version = $info->version;
  
  If only a filename is available, the following approach may be used:
  
    # via Module::Build
    my $info = Module::Metadata->new_from_file($file);
    my $version = $info->version;
  
  =head2 Comparing Version Numbers
  
  The L<version> module provides the most reliable way to compare version
  numbers in all the various ways they might be provided or might exist
  within modules.  Given two strings containing version numbers, C<$v1> and
  C<$v2>, they should be converted to C<version> objects before using
  ordinary comparison operators.  For example:
  
    use version;
    if ( version->new($v1) <=> version->new($v2) ) {
      print "Versions are not equal\n";
    }
  
  If the only comparison needed is whether an installed module is of a
  sufficiently high version, a direct test may be done using the string
  form of C<eval> and the C<use> function.  For example, for module C<$mod>
  and version prerequisite C<$prereq>:
  
    if ( eval "use $mod $prereq (); 1" ) {
      print "Module $mod version is OK.\n";
    }
  
  If the values of C<$mod> and C<$prereq> have not been scrubbed, however,
  this presents security implications.
  
  =head2 Prerequisites for dynamically configured distributions
  
  When C<dynamic_config> is true, it is an error to presume that the
  prerequisites given in distribution metadata will have any relationship
  whatsoever to the actual prerequisites of the distribution.
  
  In practice, however, one can generally expect such prerequisites to be
  one of two things:
  
  =over 4
  
  =item *
  
  The minimum prerequisites for the distribution, to which dynamic configuration will only add items
  
  =item *
  
  Whatever the distribution configured with on the releaser's machine at release time
  
  =back
  
  The second case often turns out to have identical results to the first case,
  albeit only by accident.
  
  As such, consumers may use this data for informational analysis, but
  presenting it to the user as canonical or relying on it as such is
  invariably the height of folly.
  
  =head2 Indexing distributions a la PAUSE
  
  While no_index tells you what must be ignored when indexing, this spec holds
  no opinion on how you should get your initial candidate list of things to
  possibly index. For "normal" distributions you might consider simply indexing
  the contents of lib/, but there are many fascinating oddities on CPAN and
  many dists from the days when it was normal to put the main .pm file in the
  root of the distribution archive - so PAUSE currently indexes all .pm and .PL
  files that are not either (a) specifically excluded by no_index (b) in
  C<inc>, C<xt>, or C<t> directories, or common 'mistake' directories such as
  C<perl5>.
  
  Or: If you're trying to be PAUSE-like, make sure you skip C<inc>, C<xt> and
  C<t> as well as anything marked as no_index.
  
  Also remember: If the META file contains a provides field, you shouldn't be
  indexing anything in the first place - just use that.
  
  =head1 SEE ALSO
  
  =over 4
  
  =item *
  
  CPAN, L<http://www.cpan.org/>
  
  =item *
  
  JSON, L<http://json.org/>
  
  =item *
  
  YAML, L<http://www.yaml.org/>
  
  =item *
  
  L<CPAN>
  
  =item *
  
  L<CPANPLUS>
  
  =item *
  
  L<ExtUtils::MakeMaker>
  
  =item *
  
  L<Module::Build>
  
  =item *
  
  L<Module::Install>
  
  =item *
  
  L<CPAN::Meta::History::Meta_1_4>
  
  =back
  
  =head1 HISTORY
  
  Ken Williams wrote the original CPAN Meta Spec (also known as the
  "META.yml spec") in 2003 and maintained it through several revisions
  with input from various members of the community.  In 2005, Randy
  Sims redrafted it from HTML to POD for the version 1.2 release.  Ken
  continued to maintain the spec through version 1.4.
  
  In late 2009, David Golden organized the version 2 proposal review
  process.  David and Ricardo Signes drafted the final version 2 spec
  in April 2010 based on the version 1.4 spec and patches contributed
  during the proposal process.
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
CPAN_META_SPEC

$fatpacked{"CPAN/Meta/Validator.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_VALIDATOR';
  use 5.006;
  use strict;
  use warnings;
  package CPAN::Meta::Validator;
  
  our $VERSION = '2.150010';
  
  #pod =head1 SYNOPSIS
  #pod
  #pod   my $struct = decode_json_file('META.json');
  #pod
  #pod   my $cmv = CPAN::Meta::Validator->new( $struct );
  #pod
  #pod   unless ( $cmv->is_valid ) {
  #pod     my $msg = "Invalid META structure.  Errors found:\n";
  #pod     $msg .= join( "\n", $cmv->errors );
  #pod     die $msg;
  #pod   }
  #pod
  #pod =head1 DESCRIPTION
  #pod
  #pod This module validates a CPAN Meta structure against the version of the
  #pod the specification claimed in the C<meta-spec> field of the structure.
  #pod
  #pod =cut
  
  #--------------------------------------------------------------------------#
  # This code copied and adapted from Test::CPAN::Meta
  # by Barbie, <barbie@cpan.org> for Miss Barbell Productions,
  # L<http://www.missbarbell.co.uk>
  #--------------------------------------------------------------------------#
  
  #--------------------------------------------------------------------------#
  # Specification Definitions
  #--------------------------------------------------------------------------#
  
  my %known_specs = (
      '1.4' => 'http://module-build.sourceforge.net/META-spec-v1.4.html',
      '1.3' => 'http://module-build.sourceforge.net/META-spec-v1.3.html',
      '1.2' => 'http://module-build.sourceforge.net/META-spec-v1.2.html',
      '1.1' => 'http://module-build.sourceforge.net/META-spec-v1.1.html',
      '1.0' => 'http://module-build.sourceforge.net/META-spec-v1.0.html'
  );
  my %known_urls = map {$known_specs{$_} => $_} keys %known_specs;
  
  my $module_map1 = { 'map' => { ':key' => { name => \&module, value => \&exversion } } };
  
  my $module_map2 = { 'map' => { ':key' => { name => \&module, value => \&version   } } };
  
  my $no_index_2 = {
      'map'       => { file       => { list => { value => \&string } },
                       directory  => { list => { value => \&string } },
                       'package'  => { list => { value => \&string } },
                       namespace  => { list => { value => \&string } },
                      ':key'      => { name => \&custom_2, value => \&anything },
      }
  };
  
  my $no_index_1_3 = {
      'map'       => { file       => { list => { value => \&string } },
                       directory  => { list => { value => \&string } },
                       'package'  => { list => { value => \&string } },
                       namespace  => { list => { value => \&string } },
                       ':key'     => { name => \&string, value => \&anything },
      }
  };
  
  my $no_index_1_2 = {
      'map'       => { file       => { list => { value => \&string } },
                       dir        => { list => { value => \&string } },
                       'package'  => { list => { value => \&string } },
                       namespace  => { list => { value => \&string } },
                       ':key'     => { name => \&string, value => \&anything },
      }
  };
  
  my $no_index_1_1 = {
      'map'       => { ':key'     => { name => \&string, list => { value => \&string } },
      }
  };
  
  my $prereq_map = {
    map => {
      ':key' => {
        name => \&phase,
        'map' => {
          ':key'  => {
            name => \&relation,
            %$module_map1,
          },
        },
      }
    },
  };
  
  my %definitions = (
    '2' => {
      # REQUIRED
      'abstract'            => { mandatory => 1, value => \&string  },
      'author'              => { mandatory => 1, list => { value => \&string } },
      'dynamic_config'      => { mandatory => 1, value => \&boolean },
      'generated_by'        => { mandatory => 1, value => \&string  },
      'license'             => { mandatory => 1, list => { value => \&license } },
      'meta-spec' => {
        mandatory => 1,
        'map' => {
          version => { mandatory => 1, value => \&version},
          url     => { value => \&url },
          ':key' => { name => \&custom_2, value => \&anything },
        }
      },
      'name'                => { mandatory => 1, value => \&string  },
      'release_status'      => { mandatory => 1, value => \&release_status },
      'version'             => { mandatory => 1, value => \&version },
  
      # OPTIONAL
      'description' => { value => \&string },
      'keywords'    => { list => { value => \&string } },
      'no_index'    => $no_index_2,
      'optional_features'   => {
        'map'       => {
          ':key'  => {
            name => \&string,
            'map'   => {
              description        => { value => \&string },
              prereqs => $prereq_map,
              ':key' => { name => \&custom_2, value => \&anything },
            }
          }
        }
      },
      'prereqs' => $prereq_map,
      'provides'    => {
        'map'       => {
          ':key' => {
            name  => \&module,
            'map' => {
              file    => { mandatory => 1, value => \&file },
              version => { value => \&version },
              ':key' => { name => \&custom_2, value => \&anything },
            }
          }
        }
      },
      'resources'   => {
        'map'       => {
          license    => { list => { value => \&url } },
          homepage   => { value => \&url },
          bugtracker => {
            'map' => {
              web => { value => \&url },
              mailto => { value => \&string},
              ':key' => { name => \&custom_2, value => \&anything },
            }
          },
          repository => {
            'map' => {
              web => { value => \&url },
              url => { value => \&url },
              type => { value => \&string },
              ':key' => { name => \&custom_2, value => \&anything },
            }
          },
          ':key'     => { value => \&string, name => \&custom_2 },
        }
      },
  
      # CUSTOM -- additional user defined key/value pairs
      # note we can only validate the key name, as the structure is user defined
      ':key'        => { name => \&custom_2, value => \&anything },
    },
  
  '1.4' => {
    'meta-spec'           => {
      mandatory => 1,
      'map' => {
        version => { mandatory => 1, value => \&version},
        url     => { mandatory => 1, value => \&urlspec },
        ':key'  => { name => \&string, value => \&anything },
      },
    },
  
    'name'                => { mandatory => 1, value => \&string  },
    'version'             => { mandatory => 1, value => \&version },
    'abstract'            => { mandatory => 1, value => \&string  },
    'author'              => { mandatory => 1, list  => { value => \&string } },
    'license'             => { mandatory => 1, value => \&license },
    'generated_by'        => { mandatory => 1, value => \&string  },
  
    'distribution_type'   => { value => \&string  },
    'dynamic_config'      => { value => \&boolean },
  
    'requires'            => $module_map1,
    'recommends'          => $module_map1,
    'build_requires'      => $module_map1,
    'configure_requires'  => $module_map1,
    'conflicts'           => $module_map2,
  
    'optional_features'   => {
      'map'       => {
          ':key'  => { name => \&string,
              'map'   => { description        => { value => \&string },
                           requires           => $module_map1,
                           recommends         => $module_map1,
                           build_requires     => $module_map1,
                           conflicts          => $module_map2,
                           ':key'  => { name => \&string, value => \&anything },
              }
          }
       }
    },
  
    'provides'    => {
      'map'       => {
        ':key' => { name  => \&module,
          'map' => {
            file    => { mandatory => 1, value => \&file },
            version => { value => \&version },
            ':key'  => { name => \&string, value => \&anything },
          }
        }
      }
    },
  
    'no_index'    => $no_index_1_3,
    'private'     => $no_index_1_3,
  
    'keywords'    => { list => { value => \&string } },
  
    'resources'   => {
      'map'       => { license    => { value => \&url },
                       homepage   => { value => \&url },
                       bugtracker => { value => \&url },
                       repository => { value => \&url },
                       ':key'     => { value => \&string, name => \&custom_1 },
      }
    },
  
    # additional user defined key/value pairs
    # note we can only validate the key name, as the structure is user defined
    ':key'        => { name => \&string, value => \&anything },
  },
  
  '1.3' => {
    'meta-spec'           => {
      mandatory => 1,
      'map' => {
        version => { mandatory => 1, value => \&version},
        url     => { mandatory => 1, value => \&urlspec },
        ':key'  => { name => \&string, value => \&anything },
      },
    },
  
    'name'                => { mandatory => 1, value => \&string  },
    'version'             => { mandatory => 1, value => \&version },
    'abstract'            => { mandatory => 1, value => \&string  },
    'author'              => { mandatory => 1, list  => { value => \&string } },
    'license'             => { mandatory => 1, value => \&license },
    'generated_by'        => { mandatory => 1, value => \&string  },
  
    'distribution_type'   => { value => \&string  },
    'dynamic_config'      => { value => \&boolean },
  
    'requires'            => $module_map1,
    'recommends'          => $module_map1,
    'build_requires'      => $module_map1,
    'conflicts'           => $module_map2,
  
    'optional_features'   => {
      'map'       => {
          ':key'  => { name => \&string,
              'map'   => { description        => { value => \&string },
                           requires           => $module_map1,
                           recommends         => $module_map1,
                           build_requires     => $module_map1,
                           conflicts          => $module_map2,
                           ':key'  => { name => \&string, value => \&anything },
              }
          }
       }
    },
  
    'provides'    => {
      'map'       => {
        ':key' => { name  => \&module,
          'map' => {
            file    => { mandatory => 1, value => \&file },
            version => { value => \&version },
            ':key'  => { name => \&string, value => \&anything },
          }
        }
      }
    },
  
  
    'no_index'    => $no_index_1_3,
    'private'     => $no_index_1_3,
  
    'keywords'    => { list => { value => \&string } },
  
    'resources'   => {
      'map'       => { license    => { value => \&url },
                       homepage   => { value => \&url },
                       bugtracker => { value => \&url },
                       repository => { value => \&url },
                       ':key'     => { value => \&string, name => \&custom_1 },
      }
    },
  
    # additional user defined key/value pairs
    # note we can only validate the key name, as the structure is user defined
    ':key'        => { name => \&string, value => \&anything },
  },
  
  # v1.2 is misleading, it seems to assume that a number of fields where created
  # within v1.1, when they were created within v1.2. This may have been an
  # original mistake, and that a v1.1 was retro fitted into the timeline, when
  # v1.2 was originally slated as v1.1. But I could be wrong ;)
  '1.2' => {
    'meta-spec'           => {
      mandatory => 1,
      'map' => {
        version => { mandatory => 1, value => \&version},
        url     => { mandatory => 1, value => \&urlspec },
        ':key'  => { name => \&string, value => \&anything },
      },
    },
  
  
    'name'                => { mandatory => 1, value => \&string  },
    'version'             => { mandatory => 1, value => \&version },
    'license'             => { mandatory => 1, value => \&license },
    'generated_by'        => { mandatory => 1, value => \&string  },
    'author'              => { mandatory => 1, list => { value => \&string } },
    'abstract'            => { mandatory => 1, value => \&string  },
  
    'distribution_type'   => { value => \&string  },
    'dynamic_config'      => { value => \&boolean },
  
    'keywords'            => { list => { value => \&string } },
  
    'private'             => $no_index_1_2,
    '$no_index'           => $no_index_1_2,
  
    'requires'            => $module_map1,
    'recommends'          => $module_map1,
    'build_requires'      => $module_map1,
    'conflicts'           => $module_map2,
  
    'optional_features'   => {
      'map'       => {
          ':key'  => { name => \&string,
              'map'   => { description        => { value => \&string },
                           requires           => $module_map1,
                           recommends         => $module_map1,
                           build_requires     => $module_map1,
                           conflicts          => $module_map2,
                           ':key'  => { name => \&string, value => \&anything },
              }
          }
       }
    },
  
    'provides'    => {
      'map'       => {
        ':key' => { name  => \&module,
          'map' => {
            file    => { mandatory => 1, value => \&file },
            version => { value => \&version },
            ':key'  => { name => \&string, value => \&anything },
          }
        }
      }
    },
  
    'resources'   => {
      'map'       => { license    => { value => \&url },
                       homepage   => { value => \&url },
                       bugtracker => { value => \&url },
                       repository => { value => \&url },
                       ':key'     => { value => \&string, name => \&custom_1 },
      }
    },
  
    # additional user defined key/value pairs
    # note we can only validate the key name, as the structure is user defined
    ':key'        => { name => \&string, value => \&anything },
  },
  
  # note that the 1.1 spec only specifies 'version' as mandatory
  '1.1' => {
    'name'                => { value => \&string  },
    'version'             => { mandatory => 1, value => \&version },
    'license'             => { value => \&license },
    'generated_by'        => { value => \&string  },
  
    'license_uri'         => { value => \&url },
    'distribution_type'   => { value => \&string  },
    'dynamic_config'      => { value => \&boolean },
  
    'private'             => $no_index_1_1,
  
    'requires'            => $module_map1,
    'recommends'          => $module_map1,
    'build_requires'      => $module_map1,
    'conflicts'           => $module_map2,
  
    # additional user defined key/value pairs
    # note we can only validate the key name, as the structure is user defined
    ':key'        => { name => \&string, value => \&anything },
  },
  
  # note that the 1.0 spec doesn't specify optional or mandatory fields
  # but we will treat version as mandatory since otherwise META 1.0 is
  # completely arbitrary and pointless
  '1.0' => {
    'name'                => { value => \&string  },
    'version'             => { mandatory => 1, value => \&version },
    'license'             => { value => \&license },
    'generated_by'        => { value => \&string  },
  
    'license_uri'         => { value => \&url },
    'distribution_type'   => { value => \&string  },
    'dynamic_config'      => { value => \&boolean },
  
    'requires'            => $module_map1,
    'recommends'          => $module_map1,
    'build_requires'      => $module_map1,
    'conflicts'           => $module_map2,
  
    # additional user defined key/value pairs
    # note we can only validate the key name, as the structure is user defined
    ':key'        => { name => \&string, value => \&anything },
  },
  );
  
  #--------------------------------------------------------------------------#
  # Code
  #--------------------------------------------------------------------------#
  
  #pod =method new
  #pod
  #pod   my $cmv = CPAN::Meta::Validator->new( $struct )
  #pod
  #pod The constructor must be passed a metadata structure.
  #pod
  #pod =cut
  
  sub new {
    my ($class,$data) = @_;
  
    # create an attributes hash
    my $self = {
      'data'    => $data,
      'spec'    => eval { $data->{'meta-spec'}{'version'} } || "1.0",
      'errors'  => undef,
    };
  
    # create the object
    return bless $self, $class;
  }
  
  #pod =method is_valid
  #pod
  #pod   if ( $cmv->is_valid ) {
  #pod     ...
  #pod   }
  #pod
  #pod Returns a boolean value indicating whether the metadata provided
  #pod is valid.
  #pod
  #pod =cut
  
  sub is_valid {
      my $self = shift;
      my $data = $self->{data};
      my $spec_version = $self->{spec};
      $self->check_map($definitions{$spec_version},$data);
      return ! $self->errors;
  }
  
  #pod =method errors
  #pod
  #pod   warn( join "\n", $cmv->errors );
  #pod
  #pod Returns a list of errors seen during validation.
  #pod
  #pod =cut
  
  sub errors {
      my $self = shift;
      return ()   unless(defined $self->{errors});
      return @{$self->{errors}};
  }
  
  #pod =begin :internals
  #pod
  #pod =head2 Check Methods
  #pod
  #pod =over
  #pod
  #pod =item *
  #pod
  #pod check_map($spec,$data)
  #pod
  #pod Checks whether a map (or hash) part of the data structure conforms to the
  #pod appropriate specification definition.
  #pod
  #pod =item *
  #pod
  #pod check_list($spec,$data)
  #pod
  #pod Checks whether a list (or array) part of the data structure conforms to
  #pod the appropriate specification definition.
  #pod
  #pod =item *
  #pod
  #pod =back
  #pod
  #pod =cut
  
  my $spec_error = "Missing validation action in specification. "
    . "Must be one of 'map', 'list', or 'value'";
  
  sub check_map {
      my ($self,$spec,$data) = @_;
  
      if(ref($spec) ne 'HASH') {
          $self->_error( "Unknown META specification, cannot validate." );
          return;
      }
  
      if(ref($data) ne 'HASH') {
          $self->_error( "Expected a map structure from string or file." );
          return;
      }
  
      for my $key (keys %$spec) {
          next    unless($spec->{$key}->{mandatory});
          next    if(defined $data->{$key});
          push @{$self->{stack}}, $key;
          $self->_error( "Missing mandatory field, '$key'" );
          pop @{$self->{stack}};
      }
  
      for my $key (keys %$data) {
          push @{$self->{stack}}, $key;
          if($spec->{$key}) {
              if($spec->{$key}{value}) {
                  $spec->{$key}{value}->($self,$key,$data->{$key});
              } elsif($spec->{$key}{'map'}) {
                  $self->check_map($spec->{$key}{'map'},$data->{$key});
              } elsif($spec->{$key}{'list'}) {
                  $self->check_list($spec->{$key}{'list'},$data->{$key});
              } else {
                  $self->_error( "$spec_error for '$key'" );
              }
  
          } elsif ($spec->{':key'}) {
              $spec->{':key'}{name}->($self,$key,$key);
              if($spec->{':key'}{value}) {
                  $spec->{':key'}{value}->($self,$key,$data->{$key});
              } elsif($spec->{':key'}{'map'}) {
                  $self->check_map($spec->{':key'}{'map'},$data->{$key});
              } elsif($spec->{':key'}{'list'}) {
                  $self->check_list($spec->{':key'}{'list'},$data->{$key});
              } else {
                  $self->_error( "$spec_error for ':key'" );
              }
  
  
          } else {
              $self->_error( "Unknown key, '$key', found in map structure" );
          }
          pop @{$self->{stack}};
      }
  }
  
  sub check_list {
      my ($self,$spec,$data) = @_;
  
      if(ref($data) ne 'ARRAY') {
          $self->_error( "Expected a list structure" );
          return;
      }
  
      if(defined $spec->{mandatory}) {
          if(!defined $data->[0]) {
              $self->_error( "Missing entries from mandatory list" );
          }
      }
  
      for my $value (@$data) {
          push @{$self->{stack}}, $value || "<undef>";
          if(defined $spec->{value}) {
              $spec->{value}->($self,'list',$value);
          } elsif(defined $spec->{'map'}) {
              $self->check_map($spec->{'map'},$value);
          } elsif(defined $spec->{'list'}) {
              $self->check_list($spec->{'list'},$value);
          } elsif ($spec->{':key'}) {
              $self->check_map($spec,$value);
          } else {
            $self->_error( "$spec_error associated with '$self->{stack}[-2]'" );
          }
          pop @{$self->{stack}};
      }
  }
  
  #pod =head2 Validator Methods
  #pod
  #pod =over
  #pod
  #pod =item *
  #pod
  #pod header($self,$key,$value)
  #pod
  #pod Validates that the header is valid.
  #pod
  #pod Note: No longer used as we now read the data structure, not the file.
  #pod
  #pod =item *
  #pod
  #pod url($self,$key,$value)
  #pod
  #pod Validates that a given value is in an acceptable URL format
  #pod
  #pod =item *
  #pod
  #pod urlspec($self,$key,$value)
  #pod
  #pod Validates that the URL to a META specification is a known one.
  #pod
  #pod =item *
  #pod
  #pod string_or_undef($self,$key,$value)
  #pod
  #pod Validates that the value is either a string or an undef value. Bit of a
  #pod catchall function for parts of the data structure that are completely user
  #pod defined.
  #pod
  #pod =item *
  #pod
  #pod string($self,$key,$value)
  #pod
  #pod Validates that a string exists for the given key.
  #pod
  #pod =item *
  #pod
  #pod file($self,$key,$value)
  #pod
  #pod Validate that a file is passed for the given key. This may be made more
  #pod thorough in the future. For now it acts like \&string.
  #pod
  #pod =item *
  #pod
  #pod exversion($self,$key,$value)
  #pod
  #pod Validates a list of versions, e.g. '<= 5, >=2, ==3, !=4, >1, <6, 0'.
  #pod
  #pod =item *
  #pod
  #pod version($self,$key,$value)
  #pod
  #pod Validates a single version string. Versions of the type '5.8.8' and '0.00_00'
  #pod are both valid. A leading 'v' like 'v1.2.3' is also valid.
  #pod
  #pod =item *
  #pod
  #pod boolean($self,$key,$value)
  #pod
  #pod Validates for a boolean value: a defined value that is either "1" or "0" or
  #pod stringifies to those values.
  #pod
  #pod =item *
  #pod
  #pod license($self,$key,$value)
  #pod
  #pod Validates that a value is given for the license. Returns 1 if an known license
  #pod type, or 2 if a value is given but the license type is not a recommended one.
  #pod
  #pod =item *
  #pod
  #pod custom_1($self,$key,$value)
  #pod
  #pod Validates that the given key is in CamelCase, to indicate a user defined
  #pod keyword and only has characters in the class [-_a-zA-Z].  In version 1.X
  #pod of the spec, this was only explicitly stated for 'resources'.
  #pod
  #pod =item *
  #pod
  #pod custom_2($self,$key,$value)
  #pod
  #pod Validates that the given key begins with 'x_' or 'X_', to indicate a user
  #pod defined keyword and only has characters in the class [-_a-zA-Z]
  #pod
  #pod =item *
  #pod
  #pod identifier($self,$key,$value)
  #pod
  #pod Validates that key is in an acceptable format for the META specification,
  #pod for an identifier, i.e. any that matches the regular expression
  #pod qr/[a-z][a-z_]/i.
  #pod
  #pod =item *
  #pod
  #pod module($self,$key,$value)
  #pod
  #pod Validates that a given key is in an acceptable module name format, e.g.
  #pod 'Test::CPAN::Meta::Version'.
  #pod
  #pod =back
  #pod
  #pod =end :internals
  #pod
  #pod =cut
  
  sub header {
      my ($self,$key,$value) = @_;
      if(defined $value) {
          return 1    if($value && $value =~ /^--- #YAML:1.0/);
      }
      $self->_error( "file does not have a valid YAML header." );
      return 0;
  }
  
  sub release_status {
    my ($self,$key,$value) = @_;
    if(defined $value) {
      my $version = $self->{data}{version} || '';
      if ( $version =~ /_/ ) {
        return 1 if ( $value =~ /\A(?:testing|unstable)\z/ );
        $self->_error( "'$value' for '$key' is invalid for version '$version'" );
      }
      else {
        return 1 if ( $value =~ /\A(?:stable|testing|unstable)\z/ );
        $self->_error( "'$value' for '$key' is invalid" );
      }
    }
    else {
      $self->_error( "'$key' is not defined" );
    }
    return 0;
  }
  
  # _uri_split taken from URI::Split by Gisle Aas, Copyright 2003
  sub _uri_split {
       return $_[0] =~ m,(?:([^:/?#]+):)?(?://([^/?#]*))?([^?#]*)(?:\?([^#]*))?(?:#(.*))?,;
  }
  
  sub url {
      my ($self,$key,$value) = @_;
      if(defined $value) {
        my ($scheme, $auth, $path, $query, $frag) = _uri_split($value);
        unless ( defined $scheme && length $scheme ) {
          $self->_error( "'$value' for '$key' does not have a URL scheme" );
          return 0;
        }
        unless ( defined $auth && length $auth ) {
          $self->_error( "'$value' for '$key' does not have a URL authority" );
          return 0;
        }
        return 1;
      }
      $value ||= '';
      $self->_error( "'$value' for '$key' is not a valid URL." );
      return 0;
  }
  
  sub urlspec {
      my ($self,$key,$value) = @_;
      if(defined $value) {
          return 1    if($value && $known_specs{$self->{spec}} eq $value);
          if($value && $known_urls{$value}) {
              $self->_error( 'META specification URL does not match version' );
              return 0;
          }
      }
      $self->_error( 'Unknown META specification' );
      return 0;
  }
  
  sub anything { return 1 }
  
  sub string {
      my ($self,$key,$value) = @_;
      if(defined $value) {
          return 1    if($value || $value =~ /^0$/);
      }
      $self->_error( "value is an undefined string" );
      return 0;
  }
  
  sub string_or_undef {
      my ($self,$key,$value) = @_;
      return 1    unless(defined $value);
      return 1    if($value || $value =~ /^0$/);
      $self->_error( "No string defined for '$key'" );
      return 0;
  }
  
  sub file {
      my ($self,$key,$value) = @_;
      return 1    if(defined $value);
      $self->_error( "No file defined for '$key'" );
      return 0;
  }
  
  sub exversion {
      my ($self,$key,$value) = @_;
      if(defined $value && ($value || $value =~ /0/)) {
          my $pass = 1;
          for(split(",",$value)) { $self->version($key,$_) or ($pass = 0); }
          return $pass;
      }
      $value = '<undef>'  unless(defined $value);
      $self->_error( "'$value' for '$key' is not a valid version." );
      return 0;
  }
  
  sub version {
      my ($self,$key,$value) = @_;
      if(defined $value) {
          return 0    unless($value || $value =~ /0/);
          return 1    if($value =~ /^\s*((<|<=|>=|>|!=|==)\s*)?v?\d+((\.\d+((_|\.)\d+)?)?)/);
      } else {
          $value = '<undef>';
      }
      $self->_error( "'$value' for '$key' is not a valid version." );
      return 0;
  }
  
  sub boolean {
      my ($self,$key,$value) = @_;
      if(defined $value) {
          return 1    if($value =~ /^(0|1)$/);
      } else {
          $value = '<undef>';
      }
      $self->_error( "'$value' for '$key' is not a boolean value." );
      return 0;
  }
  
  my %v1_licenses = (
      'perl'         => 'http://dev.perl.org/licenses/',
      'gpl'          => 'http://www.opensource.org/licenses/gpl-license.php',
      'apache'       => 'http://apache.org/licenses/LICENSE-2.0',
      'artistic'     => 'http://opensource.org/licenses/artistic-license.php',
      'artistic_2'   => 'http://opensource.org/licenses/artistic-license-2.0.php',
      'lgpl'         => 'http://www.opensource.org/licenses/lgpl-license.php',
      'bsd'          => 'http://www.opensource.org/licenses/bsd-license.php',
      'gpl'          => 'http://www.opensource.org/licenses/gpl-license.php',
      'mit'          => 'http://opensource.org/licenses/mit-license.php',
      'mozilla'      => 'http://opensource.org/licenses/mozilla1.1.php',
      'open_source'  => undef,
      'unrestricted' => undef,
      'restrictive'  => undef,
      'unknown'      => undef,
  );
  
  my %v2_licenses = map { $_ => 1 } qw(
    agpl_3
    apache_1_1
    apache_2_0
    artistic_1
    artistic_2
    bsd
    freebsd
    gfdl_1_2
    gfdl_1_3
    gpl_1
    gpl_2
    gpl_3
    lgpl_2_1
    lgpl_3_0
    mit
    mozilla_1_0
    mozilla_1_1
    openssl
    perl_5
    qpl_1_0
    ssleay
    sun
    zlib
    open_source
    restricted
    unrestricted
    unknown
  );
  
  sub license {
      my ($self,$key,$value) = @_;
      my $licenses = $self->{spec} < 2 ? \%v1_licenses : \%v2_licenses;
      if(defined $value) {
          return 1    if($value && exists $licenses->{$value});
      } else {
          $value = '<undef>';
      }
      $self->_error( "License '$value' is invalid" );
      return 0;
  }
  
  sub custom_1 {
      my ($self,$key) = @_;
      if(defined $key) {
          # a valid user defined key should be alphabetic
          # and contain at least one capital case letter.
          return 1    if($key && $key =~ /^[_a-z]+$/i && $key =~ /[A-Z]/);
      } else {
          $key = '<undef>';
      }
      $self->_error( "Custom resource '$key' must be in CamelCase." );
      return 0;
  }
  
  sub custom_2 {
      my ($self,$key) = @_;
      if(defined $key) {
          return 1    if($key && $key =~ /^x_/i);  # user defined
      } else {
          $key = '<undef>';
      }
      $self->_error( "Custom key '$key' must begin with 'x_' or 'X_'." );
      return 0;
  }
  
  sub identifier {
      my ($self,$key) = @_;
      if(defined $key) {
          return 1    if($key && $key =~ /^([a-z][_a-z]+)$/i);    # spec 2.0 defined
      } else {
          $key = '<undef>';
      }
      $self->_error( "Key '$key' is not a legal identifier." );
      return 0;
  }
  
  sub module {
      my ($self,$key) = @_;
      if(defined $key) {
          return 1    if($key && $key =~ /^[A-Za-z0-9_]+(::[A-Za-z0-9_]+)*$/);
      } else {
          $key = '<undef>';
      }
      $self->_error( "Key '$key' is not a legal module name." );
      return 0;
  }
  
  my @valid_phases = qw/ configure build test runtime develop /;
  sub phase {
      my ($self,$key) = @_;
      if(defined $key) {
          return 1 if( length $key && grep { $key eq $_ } @valid_phases );
          return 1 if $key =~ /x_/i;
      } else {
          $key = '<undef>';
      }
      $self->_error( "Key '$key' is not a legal phase." );
      return 0;
  }
  
  my @valid_relations = qw/ requires recommends suggests conflicts /;
  sub relation {
      my ($self,$key) = @_;
      if(defined $key) {
          return 1 if( length $key && grep { $key eq $_ } @valid_relations );
          return 1 if $key =~ /x_/i;
      } else {
          $key = '<undef>';
      }
      $self->_error( "Key '$key' is not a legal prereq relationship." );
      return 0;
  }
  
  sub _error {
      my $self = shift;
      my $mess = shift;
  
      $mess .= ' ('.join(' -> ',@{$self->{stack}}).')'  if($self->{stack});
      $mess .= " [Validation: $self->{spec}]";
  
      push @{$self->{errors}}, $mess;
  }
  
  1;
  
  # ABSTRACT: validate CPAN distribution metadata structures
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::Validator - validate CPAN distribution metadata structures
  
  =head1 VERSION
  
  version 2.150010
  
  =head1 SYNOPSIS
  
    my $struct = decode_json_file('META.json');
  
    my $cmv = CPAN::Meta::Validator->new( $struct );
  
    unless ( $cmv->is_valid ) {
      my $msg = "Invalid META structure.  Errors found:\n";
      $msg .= join( "\n", $cmv->errors );
      die $msg;
    }
  
  =head1 DESCRIPTION
  
  This module validates a CPAN Meta structure against the version of the
  the specification claimed in the C<meta-spec> field of the structure.
  
  =head1 METHODS
  
  =head2 new
  
    my $cmv = CPAN::Meta::Validator->new( $struct )
  
  The constructor must be passed a metadata structure.
  
  =head2 is_valid
  
    if ( $cmv->is_valid ) {
      ...
    }
  
  Returns a boolean value indicating whether the metadata provided
  is valid.
  
  =head2 errors
  
    warn( join "\n", $cmv->errors );
  
  Returns a list of errors seen during validation.
  
  =begin :internals
  
  =head2 Check Methods
  
  =over
  
  =item *
  
  check_map($spec,$data)
  
  Checks whether a map (or hash) part of the data structure conforms to the
  appropriate specification definition.
  
  =item *
  
  check_list($spec,$data)
  
  Checks whether a list (or array) part of the data structure conforms to
  the appropriate specification definition.
  
  =item *
  
  =back
  
  =head2 Validator Methods
  
  =over
  
  =item *
  
  header($self,$key,$value)
  
  Validates that the header is valid.
  
  Note: No longer used as we now read the data structure, not the file.
  
  =item *
  
  url($self,$key,$value)
  
  Validates that a given value is in an acceptable URL format
  
  =item *
  
  urlspec($self,$key,$value)
  
  Validates that the URL to a META specification is a known one.
  
  =item *
  
  string_or_undef($self,$key,$value)
  
  Validates that the value is either a string or an undef value. Bit of a
  catchall function for parts of the data structure that are completely user
  defined.
  
  =item *
  
  string($self,$key,$value)
  
  Validates that a string exists for the given key.
  
  =item *
  
  file($self,$key,$value)
  
  Validate that a file is passed for the given key. This may be made more
  thorough in the future. For now it acts like \&string.
  
  =item *
  
  exversion($self,$key,$value)
  
  Validates a list of versions, e.g. '<= 5, >=2, ==3, !=4, >1, <6, 0'.
  
  =item *
  
  version($self,$key,$value)
  
  Validates a single version string. Versions of the type '5.8.8' and '0.00_00'
  are both valid. A leading 'v' like 'v1.2.3' is also valid.
  
  =item *
  
  boolean($self,$key,$value)
  
  Validates for a boolean value: a defined value that is either "1" or "0" or
  stringifies to those values.
  
  =item *
  
  license($self,$key,$value)
  
  Validates that a value is given for the license. Returns 1 if an known license
  type, or 2 if a value is given but the license type is not a recommended one.
  
  =item *
  
  custom_1($self,$key,$value)
  
  Validates that the given key is in CamelCase, to indicate a user defined
  keyword and only has characters in the class [-_a-zA-Z].  In version 1.X
  of the spec, this was only explicitly stated for 'resources'.
  
  =item *
  
  custom_2($self,$key,$value)
  
  Validates that the given key begins with 'x_' or 'X_', to indicate a user
  defined keyword and only has characters in the class [-_a-zA-Z]
  
  =item *
  
  identifier($self,$key,$value)
  
  Validates that key is in an acceptable format for the META specification,
  for an identifier, i.e. any that matches the regular expression
  qr/[a-z][a-z_]/i.
  
  =item *
  
  module($self,$key,$value)
  
  Validates that a given key is in an acceptable module name format, e.g.
  'Test::CPAN::Meta::Version'.
  
  =back
  
  =end :internals
  
  =for Pod::Coverage anything boolean check_list custom_1 custom_2 exversion file
  identifier license module phase relation release_status string string_or_undef
  url urlspec version header check_map
  
  =head1 BUGS
  
  Please report any bugs or feature using the CPAN Request Tracker.
  Bugs can be submitted through the web interface at
  L<http://rt.cpan.org/Dist/Display.html?Queue=CPAN-Meta>
  
  When submitting a bug or request, please include a test-file or a patch to an
  existing test-file that illustrates the bug or desired feature.
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  Ricardo Signes <rjbs@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by David Golden, Ricardo Signes, Adam Kennedy and Contributors.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # vim: ts=2 sts=2 sw=2 et :
CPAN_META_VALIDATOR

$fatpacked{"CPAN/Meta/YAML.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CPAN_META_YAML';
  use 5.008001; # sane UTF-8 support
  use strict;
  use warnings;
  package CPAN::Meta::YAML; # git description: v1.68-2-gcc5324e
  # XXX-INGY is 5.8.1 too old/broken for utf8?
  # XXX-XDG Lancaster consensus was that it was sufficient until
  # proven otherwise
  $CPAN::Meta::YAML::VERSION = '0.018';
  ; # original $VERSION removed by Doppelgaenger
  
  #####################################################################
  # The CPAN::Meta::YAML API.
  #
  # These are the currently documented API functions/methods and
  # exports:
  
  use Exporter;
  our @ISA       = qw{ Exporter  };
  our @EXPORT    = qw{ Load Dump };
  our @EXPORT_OK = qw{ LoadFile DumpFile freeze thaw };
  
  ###
  # Functional/Export API:
  
  sub Dump {
      return CPAN::Meta::YAML->new(@_)->_dump_string;
  }
  
  # XXX-INGY Returning last document seems a bad behavior.
  # XXX-XDG I think first would seem more natural, but I don't know
  # that it's worth changing now
  sub Load {
      my $self = CPAN::Meta::YAML->_load_string(@_);
      if ( wantarray ) {
          return @$self;
      } else {
          # To match YAML.pm, return the last document
          return $self->[-1];
      }
  }
  
  # XXX-INGY Do we really need freeze and thaw?
  # XXX-XDG I don't think so.  I'd support deprecating them.
  BEGIN {
      *freeze = \&Dump;
      *thaw   = \&Load;
  }
  
  sub DumpFile {
      my $file = shift;
      return CPAN::Meta::YAML->new(@_)->_dump_file($file);
  }
  
  sub LoadFile {
      my $file = shift;
      my $self = CPAN::Meta::YAML->_load_file($file);
      if ( wantarray ) {
          return @$self;
      } else {
          # Return only the last document to match YAML.pm,
          return $self->[-1];
      }
  }
  
  
  ###
  # Object Oriented API:
  
  # Create an empty CPAN::Meta::YAML object
  # XXX-INGY Why do we use ARRAY object?
  # NOTE: I get it now, but I think it's confusing and not needed.
  # Will change it on a branch later, for review.
  #
  # XXX-XDG I don't support changing it yet.  It's a very well-documented
  # "API" of CPAN::Meta::YAML.  I'd support deprecating it, but Adam suggested
  # we not change it until YAML.pm's own OO API is established so that
  # users only have one API change to digest, not two
  sub new {
      my $class = shift;
      bless [ @_ ], $class;
  }
  
  # XXX-INGY It probably doesn't matter, and it's probably too late to
  # change, but 'read/write' are the wrong names. Read and Write
  # are actions that take data from storage to memory
  # characters/strings. These take the data to/from storage to native
  # Perl objects, which the terms dump and load are meant. As long as
  # this is a legacy quirk to CPAN::Meta::YAML it's ok, but I'd prefer not
  # to add new {read,write}_* methods to this API.
  
  sub read_string {
      my $self = shift;
      $self->_load_string(@_);
  }
  
  sub write_string {
      my $self = shift;
      $self->_dump_string(@_);
  }
  
  sub read {
      my $self = shift;
      $self->_load_file(@_);
  }
  
  sub write {
      my $self = shift;
      $self->_dump_file(@_);
  }
  
  
  
  
  #####################################################################
  # Constants
  
  # Printed form of the unprintable characters in the lowest range
  # of ASCII characters, listed by ASCII ordinal position.
  my @UNPRINTABLE = qw(
      0    x01  x02  x03  x04  x05  x06  a
      b    t    n    v    f    r    x0E  x0F
      x10  x11  x12  x13  x14  x15  x16  x17
      x18  x19  x1A  e    x1C  x1D  x1E  x1F
  );
  
  # Printable characters for escapes
  my %UNESCAPES = (
      0 => "\x00", z => "\x00", N    => "\x85",
      a => "\x07", b => "\x08", t    => "\x09",
      n => "\x0a", v => "\x0b", f    => "\x0c",
      r => "\x0d", e => "\x1b", '\\' => '\\',
  );
  
  # XXX-INGY
  # I(ngy) need to decide if these values should be quoted in
  # CPAN::Meta::YAML or not. Probably yes.
  
  # These 3 values have special meaning when unquoted and using the
  # default YAML schema. They need quotes if they are strings.
  my %QUOTE = map { $_ => 1 } qw{
      null true false
  };
  
  # The commented out form is simpler, but overloaded the Perl regex
  # engine due to recursion and backtracking problems on strings
  # larger than 32,000ish characters. Keep it for reference purposes.
  # qr/\"((?:\\.|[^\"])*)\"/
  my $re_capture_double_quoted = qr/\"([^\\"]*(?:\\.[^\\"]*)*)\"/;
  my $re_capture_single_quoted = qr/\'([^\']*(?:\'\'[^\']*)*)\'/;
  # unquoted re gets trailing space that needs to be stripped
  my $re_capture_unquoted_key  = qr/([^:]+(?::+\S(?:[^:]*|.*?(?=:)))*)(?=\s*\:(?:\s+|$))/;
  my $re_trailing_comment      = qr/(?:\s+\#.*)?/;
  my $re_key_value_separator   = qr/\s*:(?:\s+(?:\#.*)?|$)/;
  
  
  
  
  
  #####################################################################
  # CPAN::Meta::YAML Implementation.
  #
  # These are the private methods that do all the work. They may change
  # at any time.
  
  
  ###
  # Loader functions:
  
  # Create an object from a file
  sub _load_file {
      my $class = ref $_[0] ? ref shift : shift;
  
      # Check the file
      my $file = shift or $class->_error( 'You did not specify a file name' );
      $class->_error( "File '$file' does not exist" )
          unless -e $file;
      $class->_error( "'$file' is a directory, not a file" )
          unless -f _;
      $class->_error( "Insufficient permissions to read '$file'" )
          unless -r _;
  
      # Open unbuffered with strict UTF-8 decoding and no translation layers
      open( my $fh, "<:unix:encoding(UTF-8)", $file );
      unless ( $fh ) {
          $class->_error("Failed to open file '$file': $!");
      }
  
      # flock if available (or warn if not possible for OS-specific reasons)
      if ( _can_flock() ) {
          flock( $fh, Fcntl::LOCK_SH() )
              or warn "Couldn't lock '$file' for reading: $!";
      }
  
      # slurp the contents
      my $contents = eval {
          use warnings FATAL => 'utf8';
          local $/;
          <$fh>
      };
      if ( my $err = $@ ) {
          $class->_error("Error reading from file '$file': $err");
      }
  
      # close the file (release the lock)
      unless ( close $fh ) {
          $class->_error("Failed to close file '$file': $!");
      }
  
      $class->_load_string( $contents );
  }
  
  # Create an object from a string
  sub _load_string {
      my $class  = ref $_[0] ? ref shift : shift;
      my $self   = bless [], $class;
      my $string = $_[0];
      eval {
          unless ( defined $string ) {
              die \"Did not provide a string to load";
          }
  
          # Check if Perl has it marked as characters, but it's internally
          # inconsistent.  E.g. maybe latin1 got read on a :utf8 layer
          if ( utf8::is_utf8($string) && ! utf8::valid($string) ) {
              die \<<'...';
  Read an invalid UTF-8 string (maybe mixed UTF-8 and 8-bit character set).
  Did you decode with lax ":utf8" instead of strict ":encoding(UTF-8)"?
  ...
          }
  
          # Ensure Unicode character semantics, even for 0x80-0xff
          utf8::upgrade($string);
  
          # Check for and strip any leading UTF-8 BOM
          $string =~ s/^\x{FEFF}//;
  
          # Check for some special cases
          return $self unless length $string;
  
          # Split the file into lines
          my @lines = grep { ! /^\s*(?:\#.*)?\z/ }
                  split /(?:\015{1,2}\012|\015|\012)/, $string;
  
          # Strip the initial YAML header
          @lines and $lines[0] =~ /^\%YAML[: ][\d\.]+.*\z/ and shift @lines;
  
          # A nibbling parser
          my $in_document = 0;
          while ( @lines ) {
              # Do we have a document header?
              if ( $lines[0] =~ /^---\s*(?:(.+)\s*)?\z/ ) {
                  # Handle scalar documents
                  shift @lines;
                  if ( defined $1 and $1 !~ /^(?:\#.+|\%YAML[: ][\d\.]+)\z/ ) {
                      push @$self,
                          $self->_load_scalar( "$1", [ undef ], \@lines );
                      next;
                  }
                  $in_document = 1;
              }
  
              if ( ! @lines or $lines[0] =~ /^(?:---|\.\.\.)/ ) {
                  # A naked document
                  push @$self, undef;
                  while ( @lines and $lines[0] !~ /^---/ ) {
                      shift @lines;
                  }
                  $in_document = 0;
  
              # XXX The final '-+$' is to look for -- which ends up being an
              # error later.
              } elsif ( ! $in_document && @$self ) {
                  # only the first document can be explicit
                  die \"CPAN::Meta::YAML failed to classify the line '$lines[0]'";
              } elsif ( $lines[0] =~ /^\s*\-(?:\s|$|-+$)/ ) {
                  # An array at the root
                  my $document = [ ];
                  push @$self, $document;
                  $self->_load_array( $document, [ 0 ], \@lines );
  
              } elsif ( $lines[0] =~ /^(\s*)\S/ ) {
                  # A hash at the root
                  my $document = { };
                  push @$self, $document;
                  $self->_load_hash( $document, [ length($1) ], \@lines );
  
              } else {
                  # Shouldn't get here.  @lines have whitespace-only lines
                  # stripped, and previous match is a line with any
                  # non-whitespace.  So this clause should only be reachable via
                  # a perlbug where \s is not symmetric with \S
  
                  # uncoverable statement
                  die \"CPAN::Meta::YAML failed to classify the line '$lines[0]'";
              }
          }
      };
      my $err = $@;
      if ( ref $err eq 'SCALAR' ) {
          $self->_error(${$err});
      } elsif ( $err ) {
          $self->_error($err);
      }
  
      return $self;
  }
  
  sub _unquote_single {
      my ($self, $string) = @_;
      return '' unless length $string;
      $string =~ s/\'\'/\'/g;
      return $string;
  }
  
  sub _unquote_double {
      my ($self, $string) = @_;
      return '' unless length $string;
      $string =~ s/\\"/"/g;
      $string =~
          s{\\([Nnever\\fartz0b]|x([0-9a-fA-F]{2}))}
           {(length($1)>1)?pack("H2",$2):$UNESCAPES{$1}}gex;
      return $string;
  }
  
  # Load a YAML scalar string to the actual Perl scalar
  sub _load_scalar {
      my ($self, $string, $indent, $lines) = @_;
  
      # Trim trailing whitespace
      $string =~ s/\s*\z//;
  
      # Explitic null/undef
      return undef if $string eq '~';
  
      # Single quote
      if ( $string =~ /^$re_capture_single_quoted$re_trailing_comment\z/ ) {
          return $self->_unquote_single($1);
      }
  
      # Double quote.
      if ( $string =~ /^$re_capture_double_quoted$re_trailing_comment\z/ ) {
          return $self->_unquote_double($1);
      }
  
      # Special cases
      if ( $string =~ /^[\'\"!&]/ ) {
          die \"CPAN::Meta::YAML does not support a feature in line '$string'";
      }
      return {} if $string =~ /^{}(?:\s+\#.*)?\z/;
      return [] if $string =~ /^\[\](?:\s+\#.*)?\z/;
  
      # Regular unquoted string
      if ( $string !~ /^[>|]/ ) {
          die \"CPAN::Meta::YAML found illegal characters in plain scalar: '$string'"
              if $string =~ /^(?:-(?:\s|$)|[\@\%\`])/ or
                  $string =~ /:(?:\s|$)/;
          $string =~ s/\s+#.*\z//;
          return $string;
      }
  
      # Error
      die \"CPAN::Meta::YAML failed to find multi-line scalar content" unless @$lines;
  
      # Check the indent depth
      $lines->[0]   =~ /^(\s*)/;
      $indent->[-1] = length("$1");
      if ( defined $indent->[-2] and $indent->[-1] <= $indent->[-2] ) {
          die \"CPAN::Meta::YAML found bad indenting in line '$lines->[0]'";
      }
  
      # Pull the lines
      my @multiline = ();
      while ( @$lines ) {
          $lines->[0] =~ /^(\s*)/;
          last unless length($1) >= $indent->[-1];
          push @multiline, substr(shift(@$lines), length($1));
      }
  
      my $j = (substr($string, 0, 1) eq '>') ? ' ' : "\n";
      my $t = (substr($string, 1, 1) eq '-') ? ''  : "\n";
      return join( $j, @multiline ) . $t;
  }
  
  # Load an array
  sub _load_array {
      my ($self, $array, $indent, $lines) = @_;
  
      while ( @$lines ) {
          # Check for a new document
          if ( $lines->[0] =~ /^(?:---|\.\.\.)/ ) {
              while ( @$lines and $lines->[0] !~ /^---/ ) {
                  shift @$lines;
              }
              return 1;
          }
  
          # Check the indent level
          $lines->[0] =~ /^(\s*)/;
          if ( length($1) < $indent->[-1] ) {
              return 1;
          } elsif ( length($1) > $indent->[-1] ) {
              die \"CPAN::Meta::YAML found bad indenting in line '$lines->[0]'";
          }
  
          if ( $lines->[0] =~ /^(\s*\-\s+)[^\'\"]\S*\s*:(?:\s+|$)/ ) {
              # Inline nested hash
              my $indent2 = length("$1");
              $lines->[0] =~ s/-/ /;
              push @$array, { };
              $self->_load_hash( $array->[-1], [ @$indent, $indent2 ], $lines );
  
          } elsif ( $lines->[0] =~ /^\s*\-\s*\z/ ) {
              shift @$lines;
              unless ( @$lines ) {
                  push @$array, undef;
                  return 1;
              }
              if ( $lines->[0] =~ /^(\s*)\-/ ) {
                  my $indent2 = length("$1");
                  if ( $indent->[-1] == $indent2 ) {
                      # Null array entry
                      push @$array, undef;
                  } else {
                      # Naked indenter
                      push @$array, [ ];
                      $self->_load_array(
                          $array->[-1], [ @$indent, $indent2 ], $lines
                      );
                  }
  
              } elsif ( $lines->[0] =~ /^(\s*)\S/ ) {
                  push @$array, { };
                  $self->_load_hash(
                      $array->[-1], [ @$indent, length("$1") ], $lines
                  );
  
              } else {
                  die \"CPAN::Meta::YAML failed to classify line '$lines->[0]'";
              }
  
          } elsif ( $lines->[0] =~ /^\s*\-(\s*)(.+?)\s*\z/ ) {
              # Array entry with a value
              shift @$lines;
              push @$array, $self->_load_scalar(
                  "$2", [ @$indent, undef ], $lines
              );
  
          } elsif ( defined $indent->[-2] and $indent->[-1] == $indent->[-2] ) {
              # This is probably a structure like the following...
              # ---
              # foo:
              # - list
              # bar: value
              #
              # ... so lets return and let the hash parser handle it
              return 1;
  
          } else {
              die \"CPAN::Meta::YAML failed to classify line '$lines->[0]'";
          }
      }
  
      return 1;
  }
  
  # Load a hash
  sub _load_hash {
      my ($self, $hash, $indent, $lines) = @_;
  
      while ( @$lines ) {
          # Check for a new document
          if ( $lines->[0] =~ /^(?:---|\.\.\.)/ ) {
              while ( @$lines and $lines->[0] !~ /^---/ ) {
                  shift @$lines;
              }
              return 1;
          }
  
          # Check the indent level
          $lines->[0] =~ /^(\s*)/;
          if ( length($1) < $indent->[-1] ) {
              return 1;
          } elsif ( length($1) > $indent->[-1] ) {
              die \"CPAN::Meta::YAML found bad indenting in line '$lines->[0]'";
          }
  
          # Find the key
          my $key;
  
          # Quoted keys
          if ( $lines->[0] =~
              s/^\s*$re_capture_single_quoted$re_key_value_separator//
          ) {
              $key = $self->_unquote_single($1);
          }
          elsif ( $lines->[0] =~
              s/^\s*$re_capture_double_quoted$re_key_value_separator//
          ) {
              $key = $self->_unquote_double($1);
          }
          elsif ( $lines->[0] =~
              s/^\s*$re_capture_unquoted_key$re_key_value_separator//
          ) {
              $key = $1;
              $key =~ s/\s+$//;
          }
          elsif ( $lines->[0] =~ /^\s*\?/ ) {
              die \"CPAN::Meta::YAML does not support a feature in line '$lines->[0]'";
          }
          else {
              die \"CPAN::Meta::YAML failed to classify line '$lines->[0]'";
          }
  
          if ( exists $hash->{$key} ) {
              warn "CPAN::Meta::YAML found a duplicate key '$key' in line '$lines->[0]'";
          }
  
          # Do we have a value?
          if ( length $lines->[0] ) {
              # Yes
              $hash->{$key} = $self->_load_scalar(
                  shift(@$lines), [ @$indent, undef ], $lines
              );
          } else {
              # An indent
              shift @$lines;
              unless ( @$lines ) {
                  $hash->{$key} = undef;
                  return 1;
              }
              if ( $lines->[0] =~ /^(\s*)-/ ) {
                  $hash->{$key} = [];
                  $self->_load_array(
                      $hash->{$key}, [ @$indent, length($1) ], $lines
                  );
              } elsif ( $lines->[0] =~ /^(\s*)./ ) {
                  my $indent2 = length("$1");
                  if ( $indent->[-1] >= $indent2 ) {
                      # Null hash entry
                      $hash->{$key} = undef;
                  } else {
                      $hash->{$key} = {};
                      $self->_load_hash(
                          $hash->{$key}, [ @$indent, length($1) ], $lines
                      );
                  }
              }
          }
      }
  
      return 1;
  }
  
  
  ###
  # Dumper functions:
  
  # Save an object to a file
  sub _dump_file {
      my $self = shift;
  
      require Fcntl;
  
      # Check the file
      my $file = shift or $self->_error( 'You did not specify a file name' );
  
      my $fh;
      # flock if available (or warn if not possible for OS-specific reasons)
      if ( _can_flock() ) {
          # Open without truncation (truncate comes after lock)
          my $flags = Fcntl::O_WRONLY()|Fcntl::O_CREAT();
          sysopen( $fh, $file, $flags );
          unless ( $fh ) {
              $self->_error("Failed to open file '$file' for writing: $!");
          }
  
          # Use no translation and strict UTF-8
          binmode( $fh, ":raw:encoding(UTF-8)");
  
          flock( $fh, Fcntl::LOCK_EX() )
              or warn "Couldn't lock '$file' for reading: $!";
  
          # truncate and spew contents
          truncate $fh, 0;
          seek $fh, 0, 0;
      }
      else {
          open $fh, ">:unix:encoding(UTF-8)", $file;
      }
  
      # serialize and spew to the handle
      print {$fh} $self->_dump_string;
  
      # close the file (release the lock)
      unless ( close $fh ) {
          $self->_error("Failed to close file '$file': $!");
      }
  
      return 1;
  }
  
  # Save an object to a string
  sub _dump_string {
      my $self = shift;
      return '' unless ref $self && @$self;
  
      # Iterate over the documents
      my $indent = 0;
      my @lines  = ();
  
      eval {
          foreach my $cursor ( @$self ) {
              push @lines, '---';
  
              # An empty document
              if ( ! defined $cursor ) {
                  # Do nothing
  
              # A scalar document
              } elsif ( ! ref $cursor ) {
                  $lines[-1] .= ' ' . $self->_dump_scalar( $cursor );
  
              # A list at the root
              } elsif ( ref $cursor eq 'ARRAY' ) {
                  unless ( @$cursor ) {
                      $lines[-1] .= ' []';
                      next;
                  }
                  push @lines, $self->_dump_array( $cursor, $indent, {} );
  
              # A hash at the root
              } elsif ( ref $cursor eq 'HASH' ) {
                  unless ( %$cursor ) {
                      $lines[-1] .= ' {}';
                      next;
                  }
                  push @lines, $self->_dump_hash( $cursor, $indent, {} );
  
              } else {
                  die \("Cannot serialize " . ref($cursor));
              }
          }
      };
      if ( ref $@ eq 'SCALAR' ) {
          $self->_error(${$@});
      } elsif ( $@ ) {
          $self->_error($@);
      }
  
      join '', map { "$_\n" } @lines;
  }
  
  sub _has_internal_string_value {
      my $value = shift;
      my $b_obj = B::svref_2object(\$value);  # for round trip problem
      return $b_obj->FLAGS & B::SVf_POK();
  }
  
  sub _dump_scalar {
      my $string = $_[1];
      my $is_key = $_[2];
      # Check this before checking length or it winds up looking like a string!
      my $has_string_flag = _has_internal_string_value($string);
      return '~'  unless defined $string;
      return "''" unless length  $string;
      if (Scalar::Util::looks_like_number($string)) {
          # keys and values that have been used as strings get quoted
          if ( $is_key || $has_string_flag ) {
              return qq['$string'];
          }
          else {
              return $string;
          }
      }
      if ( $string =~ /[\x00-\x09\x0b-\x0d\x0e-\x1f\x7f-\x9f\'\n]/ ) {
          $string =~ s/\\/\\\\/g;
          $string =~ s/"/\\"/g;
          $string =~ s/\n/\\n/g;
          $string =~ s/[\x85]/\\N/g;
          $string =~ s/([\x00-\x1f])/\\$UNPRINTABLE[ord($1)]/g;
          $string =~ s/([\x7f-\x9f])/'\x' . sprintf("%X",ord($1))/ge;
          return qq|"$string"|;
      }
      if ( $string =~ /(?:^[~!@#%&*|>?:,'"`{}\[\]]|^-+$|\s|:\z)/ or
          $QUOTE{$string}
      ) {
          return "'$string'";
      }
      return $string;
  }
  
  sub _dump_array {
      my ($self, $array, $indent, $seen) = @_;
      if ( $seen->{refaddr($array)}++ ) {
          die \"CPAN::Meta::YAML does not support circular references";
      }
      my @lines  = ();
      foreach my $el ( @$array ) {
          my $line = ('  ' x $indent) . '-';
          my $type = ref $el;
          if ( ! $type ) {
              $line .= ' ' . $self->_dump_scalar( $el );
              push @lines, $line;
  
          } elsif ( $type eq 'ARRAY' ) {
              if ( @$el ) {
                  push @lines, $line;
                  push @lines, $self->_dump_array( $el, $indent + 1, $seen );
              } else {
                  $line .= ' []';
                  push @lines, $line;
              }
  
          } elsif ( $type eq 'HASH' ) {
              if ( keys %$el ) {
                  push @lines, $line;
                  push @lines, $self->_dump_hash( $el, $indent + 1, $seen );
              } else {
                  $line .= ' {}';
                  push @lines, $line;
              }
  
          } else {
              die \"CPAN::Meta::YAML does not support $type references";
          }
      }
  
      @lines;
  }
  
  sub _dump_hash {
      my ($self, $hash, $indent, $seen) = @_;
      if ( $seen->{refaddr($hash)}++ ) {
          die \"CPAN::Meta::YAML does not support circular references";
      }
      my @lines  = ();
      foreach my $name ( sort keys %$hash ) {
          my $el   = $hash->{$name};
          my $line = ('  ' x $indent) . $self->_dump_scalar($name, 1) . ":";
          my $type = ref $el;
          if ( ! $type ) {
              $line .= ' ' . $self->_dump_scalar( $el );
              push @lines, $line;
  
          } elsif ( $type eq 'ARRAY' ) {
              if ( @$el ) {
                  push @lines, $line;
                  push @lines, $self->_dump_array( $el, $indent + 1, $seen );
              } else {
                  $line .= ' []';
                  push @lines, $line;
              }
  
          } elsif ( $type eq 'HASH' ) {
              if ( keys %$el ) {
                  push @lines, $line;
                  push @lines, $self->_dump_hash( $el, $indent + 1, $seen );
              } else {
                  $line .= ' {}';
                  push @lines, $line;
              }
  
          } else {
              die \"CPAN::Meta::YAML does not support $type references";
          }
      }
  
      @lines;
  }
  
  
  
  #####################################################################
  # DEPRECATED API methods:
  
  # Error storage (DEPRECATED as of 1.57)
  our $errstr    = '';
  
  # Set error
  sub _error {
      require Carp;
      $errstr = $_[1];
      $errstr =~ s/ at \S+ line \d+.*//;
      Carp::croak( $errstr );
  }
  
  # Retrieve error
  my $errstr_warned;
  sub errstr {
      require Carp;
      Carp::carp( "CPAN::Meta::YAML->errstr and \$CPAN::Meta::YAML::errstr is deprecated" )
          unless $errstr_warned++;
      $errstr;
  }
  
  
  
  
  #####################################################################
  # Helper functions. Possibly not needed.
  
  
  # Use to detect nv or iv
  use B;
  
  # XXX-INGY Is flock CPAN::Meta::YAML's responsibility?
  # Some platforms can't flock :-(
  # XXX-XDG I think it is.  When reading and writing files, we ought
  # to be locking whenever possible.  People (foolishly) use YAML
  # files for things like session storage, which has race issues.
  my $HAS_FLOCK;
  sub _can_flock {
      if ( defined $HAS_FLOCK ) {
          return $HAS_FLOCK;
      }
      else {
          require Config;
          my $c = \%Config::Config;
          $HAS_FLOCK = grep { $c->{$_} } qw/d_flock d_fcntl_can_lock d_lockf/;
          require Fcntl if $HAS_FLOCK;
          return $HAS_FLOCK;
      }
  }
  
  
  # XXX-INGY Is this core in 5.8.1? Can we remove this?
  # XXX-XDG Scalar::Util 1.18 didn't land until 5.8.8, so we need this
  #####################################################################
  # Use Scalar::Util if possible, otherwise emulate it
  
  use Scalar::Util ();
  BEGIN {
      local $@;
      if ( eval { Scalar::Util->VERSION(1.18); } ) {
          *refaddr = *Scalar::Util::refaddr;
      }
      else {
          eval <<'END_PERL';
  # Scalar::Util failed to load or too old
  sub refaddr {
      my $pkg = ref($_[0]) or return undef;
      if ( !! UNIVERSAL::can($_[0], 'can') ) {
          bless $_[0], 'Scalar::Util::Fake';
      } else {
          $pkg = undef;
      }
      "$_[0]" =~ /0x(\w+)/;
      my $i = do { no warnings 'portable'; hex $1 };
      bless $_[0], $pkg if defined $pkg;
      $i;
  }
  END_PERL
      }
  }
  
  delete $CPAN::Meta::YAML::{refaddr};
  
  1;
  
  # XXX-INGY Doc notes I'm putting up here. Changing the doc when it's wrong
  # but leaving grey area stuff up here.
  #
  # I would like to change Read/Write to Load/Dump below without
  # changing the actual API names.
  #
  # It might be better to put Load/Dump API in the SYNOPSIS instead of the
  # dubious OO API.
  #
  # null and bool explanations may be outdated.
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  CPAN::Meta::YAML - Read and write a subset of YAML for CPAN Meta files
  
  =head1 VERSION
  
  version 0.018
  
  =head1 SYNOPSIS
  
      use CPAN::Meta::YAML;
  
      # reading a META file
      open $fh, "<:utf8", "META.yml";
      $yaml_text = do { local $/; <$fh> };
      $yaml = CPAN::Meta::YAML->read_string($yaml_text)
        or die CPAN::Meta::YAML->errstr;
  
      # finding the metadata
      $meta = $yaml->[0];
  
      # writing a META file
      $yaml_text = $yaml->write_string
        or die CPAN::Meta::YAML->errstr;
      open $fh, ">:utf8", "META.yml";
      print $fh $yaml_text;
  
  =head1 DESCRIPTION
  
  This module implements a subset of the YAML specification for use in reading
  and writing CPAN metadata files like F<META.yml> and F<MYMETA.yml>.  It should
  not be used for any other general YAML parsing or generation task.
  
  NOTE: F<META.yml> (and F<MYMETA.yml>) files should be UTF-8 encoded.  Users are
  responsible for proper encoding and decoding.  In particular, the C<read> and
  C<write> methods do B<not> support UTF-8 and should not be used.
  
  =head1 SUPPORT
  
  This module is currently derived from L<YAML::Tiny> by Adam Kennedy.  If
  there are bugs in how it parses a particular META.yml file, please file
  a bug report in the YAML::Tiny bugtracker:
  L<https://github.com/Perl-Toolchain-Gang/YAML-Tiny/issues>
  
  =head1 SEE ALSO
  
  L<YAML::Tiny>, L<YAML>, L<YAML::XS>
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2010 by Adam Kennedy.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
  
  __END__
  
  
  # ABSTRACT: Read and write a subset of YAML for CPAN Meta files
  
  
CPAN_META_YAML

$fatpacked{"Capture/Tiny.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CAPTURE_TINY';
  use 5.006;
  use strict;
  use warnings;
  package Capture::Tiny;
  # ABSTRACT: Capture STDOUT and STDERR from Perl, XS or external programs
  our $VERSION = '0.46';
  use Carp ();
  use Exporter ();
  use IO::Handle ();
  use File::Spec ();
  use File::Temp qw/tempfile tmpnam/;
  use Scalar::Util qw/reftype blessed/;
  # Get PerlIO or fake it
  BEGIN {
    local $@;
    eval { require PerlIO; PerlIO->can('get_layers') }
      or *PerlIO::get_layers = sub { return () };
  }
  
  #--------------------------------------------------------------------------#
  # create API subroutines and export them
  # [do STDOUT flag, do STDERR flag, do merge flag, do tee flag]
  #--------------------------------------------------------------------------#
  
  my %api = (
    capture         => [1,1,0,0],
    capture_stdout  => [1,0,0,0],
    capture_stderr  => [0,1,0,0],
    capture_merged  => [1,1,1,0],
    tee             => [1,1,0,1],
    tee_stdout      => [1,0,0,1],
    tee_stderr      => [0,1,0,1],
    tee_merged      => [1,1,1,1],
  );
  
  for my $sub ( keys %api ) {
    my $args = join q{, }, @{$api{$sub}};
    eval "sub $sub(&;@) {unshift \@_, $args; goto \\&_capture_tee;}"; ## no critic
  }
  
  our @ISA = qw/Exporter/;
  our @EXPORT_OK = keys %api;
  our %EXPORT_TAGS = ( 'all' => \@EXPORT_OK );
  
  #--------------------------------------------------------------------------#
  # constants and fixtures
  #--------------------------------------------------------------------------#
  
  my $IS_WIN32 = $^O eq 'MSWin32';
  
  ##our $DEBUG = $ENV{PERL_CAPTURE_TINY_DEBUG};
  ##
  ##my $DEBUGFH;
  ##open $DEBUGFH, "> DEBUG" if $DEBUG;
  ##
  ##*_debug = $DEBUG ? sub(@) { print {$DEBUGFH} @_ } : sub(){0};
  
  our $TIMEOUT = 30;
  
  #--------------------------------------------------------------------------#
  # command to tee output -- the argument is a filename that must
  # be opened to signal that the process is ready to receive input.
  # This is annoying, but seems to be the best that can be done
  # as a simple, portable IPC technique
  #--------------------------------------------------------------------------#
  my @cmd = ($^X, '-C0', '-e', <<'HERE');
  use Fcntl;
  $SIG{HUP}=sub{exit};
  if ( my $fn=shift ) {
      sysopen(my $fh, qq{$fn}, O_WRONLY|O_CREAT|O_EXCL) or die $!;
      print {$fh} $$;
      close $fh;
  }
  my $buf; while (sysread(STDIN, $buf, 2048)) {
      syswrite(STDOUT, $buf); syswrite(STDERR, $buf);
  }
  HERE
  
  #--------------------------------------------------------------------------#
  # filehandle manipulation
  #--------------------------------------------------------------------------#
  
  sub _relayer {
    my ($fh, $apply_layers) = @_;
    # _debug("# requested layers (@{$layers}) for @{[fileno $fh]}\n");
  
    # eliminate pseudo-layers
    binmode( $fh, ":raw" );
    # strip off real layers until only :unix is left
    while ( 1 < ( my $layers =()= PerlIO::get_layers( $fh, output => 1 ) ) ) {
        binmode( $fh, ":pop" );
    }
    # apply other layers
    my @to_apply = @$apply_layers;
    shift @to_apply; # eliminate initial :unix
    # _debug("# applying layers  (unix @to_apply) to @{[fileno $fh]}\n");
    binmode($fh, ":" . join(":",@to_apply));
  }
  
  sub _name {
    my $glob = shift;
    no strict 'refs'; ## no critic
    return *{$glob}{NAME};
  }
  
  sub _open {
    open $_[0], $_[1] or Carp::confess "Error from open(" . join(q{, }, @_) . "): $!";
    # _debug( "# open " . join( ", " , map { defined $_ ? _name($_) : 'undef' } @_ ) . " as " . fileno( $_[0] ) . "\n" );
  }
  
  sub _close {
    # _debug( "# closing " . ( defined $_[0] ? _name($_[0]) : 'undef' )  . " on " . fileno( $_[0] ) . "\n" );
    close $_[0] or Carp::confess "Error from close(" . join(q{, }, @_) . "): $!";
  }
  
  my %dup; # cache this so STDIN stays fd0
  my %proxy_count;
  sub _proxy_std {
    my %proxies;
    if ( ! defined fileno STDIN ) {
      $proxy_count{stdin}++;
      if (defined $dup{stdin}) {
        _open \*STDIN, "<&=" . fileno($dup{stdin});
        # _debug( "# restored proxy STDIN as " . (defined fileno STDIN ? fileno STDIN : 'undef' ) . "\n" );
      }
      else {
        _open \*STDIN, "<" . File::Spec->devnull;
        # _debug( "# proxied STDIN as " . (defined fileno STDIN ? fileno STDIN : 'undef' ) . "\n" );
        _open $dup{stdin} = IO::Handle->new, "<&=STDIN";
      }
      $proxies{stdin} = \*STDIN;
      binmode(STDIN, ':utf8') if $] >= 5.008; ## no critic
    }
    if ( ! defined fileno STDOUT ) {
      $proxy_count{stdout}++;
      if (defined $dup{stdout}) {
        _open \*STDOUT, ">&=" . fileno($dup{stdout});
        # _debug( "# restored proxy STDOUT as " . (defined fileno STDOUT ? fileno STDOUT : 'undef' ) . "\n" );
      }
      else {
        _open \*STDOUT, ">" . File::Spec->devnull;
         # _debug( "# proxied STDOUT as " . (defined fileno STDOUT ? fileno STDOUT : 'undef' ) . "\n" );
        _open $dup{stdout} = IO::Handle->new, ">&=STDOUT";
      }
      $proxies{stdout} = \*STDOUT;
      binmode(STDOUT, ':utf8') if $] >= 5.008; ## no critic
    }
    if ( ! defined fileno STDERR ) {
      $proxy_count{stderr}++;
      if (defined $dup{stderr}) {
        _open \*STDERR, ">&=" . fileno($dup{stderr});
         # _debug( "# restored proxy STDERR as " . (defined fileno STDERR ? fileno STDERR : 'undef' ) . "\n" );
      }
      else {
        _open \*STDERR, ">" . File::Spec->devnull;
         # _debug( "# proxied STDERR as " . (defined fileno STDERR ? fileno STDERR : 'undef' ) . "\n" );
        _open $dup{stderr} = IO::Handle->new, ">&=STDERR";
      }
      $proxies{stderr} = \*STDERR;
      binmode(STDERR, ':utf8') if $] >= 5.008; ## no critic
    }
    return %proxies;
  }
  
  sub _unproxy {
    my (%proxies) = @_;
    # _debug( "# unproxying: " . join(" ", keys %proxies) . "\n" );
    for my $p ( keys %proxies ) {
      $proxy_count{$p}--;
      # _debug( "# unproxied " . uc($p) . " ($proxy_count{$p} left)\n" );
      if ( ! $proxy_count{$p} ) {
        _close $proxies{$p};
        _close $dup{$p} unless $] < 5.008; # 5.6 will have already closed this as dup
        delete $dup{$p};
      }
    }
  }
  
  sub _copy_std {
    my %handles;
    for my $h ( qw/stdout stderr stdin/ ) {
      next if $h eq 'stdin' && ! $IS_WIN32; # WIN32 hangs on tee without STDIN copied
      my $redir = $h eq 'stdin' ? "<&" : ">&";
      _open $handles{$h} = IO::Handle->new(), $redir . uc($h); # ">&STDOUT" or "<&STDIN"
    }
    return \%handles;
  }
  
  # In some cases we open all (prior to forking) and in others we only open
  # the output handles (setting up redirection)
  sub _open_std {
    my ($handles) = @_;
    _open \*STDIN, "<&" . fileno $handles->{stdin} if defined $handles->{stdin};
    _open \*STDOUT, ">&" . fileno $handles->{stdout} if defined $handles->{stdout};
    _open \*STDERR, ">&" . fileno $handles->{stderr} if defined $handles->{stderr};
  }
  
  #--------------------------------------------------------------------------#
  # private subs
  #--------------------------------------------------------------------------#
  
  sub _start_tee {
    my ($which, $stash) = @_; # $which is "stdout" or "stderr"
    # setup pipes
    $stash->{$_}{$which} = IO::Handle->new for qw/tee reader/;
    pipe $stash->{reader}{$which}, $stash->{tee}{$which};
    # _debug( "# pipe for $which\: " .  _name($stash->{tee}{$which}) . " " . fileno( $stash->{tee}{$which} ) . " => " . _name($stash->{reader}{$which}) . " " . fileno( $stash->{reader}{$which}) . "\n" );
    select((select($stash->{tee}{$which}), $|=1)[0]); # autoflush
    # setup desired redirection for parent and child
    $stash->{new}{$which} = $stash->{tee}{$which};
    $stash->{child}{$which} = {
      stdin   => $stash->{reader}{$which},
      stdout  => $stash->{old}{$which},
      stderr  => $stash->{capture}{$which},
    };
    # flag file is used to signal the child is ready
    $stash->{flag_files}{$which} = scalar tmpnam();
    # execute @cmd as a separate process
    if ( $IS_WIN32 ) {
      my $old_eval_err=$@;
      undef $@;
  
      eval "use Win32API::File qw/GetOsFHandle SetHandleInformation fileLastError HANDLE_FLAG_INHERIT INVALID_HANDLE_VALUE/ ";
      # _debug( "# Win32API::File loaded\n") unless $@;
      my $os_fhandle = GetOsFHandle( $stash->{tee}{$which} );
      # _debug( "# Couldn't get OS handle: " . fileLastError() . "\n") if ! defined $os_fhandle || $os_fhandle == INVALID_HANDLE_VALUE();
      my $result = SetHandleInformation( $os_fhandle, HANDLE_FLAG_INHERIT(), 0);
      # _debug( $result ? "# set no-inherit flag on $which tee\n" : ("# can't disable tee handle flag inherit: " . fileLastError() . "\n"));
      _open_std( $stash->{child}{$which} );
      $stash->{pid}{$which} = system(1, @cmd, $stash->{flag_files}{$which});
      # not restoring std here as it all gets redirected again shortly anyway
      $@=$old_eval_err;
    }
    else { # use fork
      _fork_exec( $which, $stash );
    }
  }
  
  sub _fork_exec {
    my ($which, $stash) = @_; # $which is "stdout" or "stderr"
    my $pid = fork;
    if ( not defined $pid ) {
      Carp::confess "Couldn't fork(): $!";
    }
    elsif ($pid == 0) { # child
      # _debug( "# in child process ...\n" );
      untie *STDIN; untie *STDOUT; untie *STDERR;
      _close $stash->{tee}{$which};
      # _debug( "# redirecting handles in child ...\n" );
      _open_std( $stash->{child}{$which} );
      # _debug( "# calling exec on command ...\n" );
      exec @cmd, $stash->{flag_files}{$which};
    }
    $stash->{pid}{$which} = $pid
  }
  
  my $have_usleep = eval "use Time::HiRes 'usleep'; 1";
  sub _files_exist {
    return 1 if @_ == grep { -f } @_;
    Time::HiRes::usleep(1000) if $have_usleep;
    return 0;
  }
  
  sub _wait_for_tees {
    my ($stash) = @_;
    my $start = time;
    my @files = values %{$stash->{flag_files}};
    my $timeout = defined $ENV{PERL_CAPTURE_TINY_TIMEOUT}
                ? $ENV{PERL_CAPTURE_TINY_TIMEOUT} : $TIMEOUT;
    1 until _files_exist(@files) || ($timeout && (time - $start > $timeout));
    Carp::confess "Timed out waiting for subprocesses to start" if ! _files_exist(@files);
    unlink $_ for @files;
  }
  
  sub _kill_tees {
    my ($stash) = @_;
    if ( $IS_WIN32 ) {
      # _debug( "# closing handles\n");
      close($_) for values %{ $stash->{tee} };
      # _debug( "# waiting for subprocesses to finish\n");
      my $start = time;
      1 until wait == -1 || (time - $start > 30);
    }
    else {
      _close $_ for values %{ $stash->{tee} };
      waitpid $_, 0 for values %{ $stash->{pid} };
    }
  }
  
  sub _slurp {
    my ($name, $stash) = @_;
    my ($fh, $pos) = map { $stash->{$_}{$name} } qw/capture pos/;
    # _debug( "# slurping captured $name from " . fileno($fh) . " at pos $pos with layers: @{[PerlIO::get_layers($fh)]}\n");
    seek( $fh, $pos, 0 ) or die "Couldn't seek on capture handle for $name\n";
    my $text = do { local $/; scalar readline $fh };
    return defined($text) ? $text : "";
  }
  
  #--------------------------------------------------------------------------#
  # _capture_tee() -- generic main sub for capturing or teeing
  #--------------------------------------------------------------------------#
  
  sub _capture_tee {
    # _debug( "# starting _capture_tee with (@_)...\n" );
    my ($do_stdout, $do_stderr, $do_merge, $do_tee, $code, @opts) = @_;
    my %do = ($do_stdout ? (stdout => 1) : (),  $do_stderr ? (stderr => 1) : ());
    Carp::confess("Custom capture options must be given as key/value pairs\n")
      unless @opts % 2 == 0;
    my $stash = { capture => { @opts } };
    for ( keys %{$stash->{capture}} ) {
      my $fh = $stash->{capture}{$_};
      Carp::confess "Custom handle for $_ must be seekable\n"
        unless ref($fh) eq 'GLOB' || (blessed($fh) && $fh->isa("IO::Seekable"));
    }
    # save existing filehandles and setup captures
    local *CT_ORIG_STDIN  = *STDIN ;
    local *CT_ORIG_STDOUT = *STDOUT;
    local *CT_ORIG_STDERR = *STDERR;
    # find initial layers
    my %layers = (
      stdin   => [PerlIO::get_layers(\*STDIN) ],
      stdout  => [PerlIO::get_layers(\*STDOUT, output => 1)],
      stderr  => [PerlIO::get_layers(\*STDERR, output => 1)],
    );
    # _debug( "# existing layers for $_\: @{$layers{$_}}\n" ) for qw/stdin stdout stderr/;
    # get layers from underlying glob of tied filehandles if we can
    # (this only works for things that work like Tie::StdHandle)
    $layers{stdout} = [PerlIO::get_layers(tied *STDOUT)]
      if tied(*STDOUT) && (reftype tied *STDOUT eq 'GLOB');
    $layers{stderr} = [PerlIO::get_layers(tied *STDERR)]
      if tied(*STDERR) && (reftype tied *STDERR eq 'GLOB');
    # _debug( "# tied object corrected layers for $_\: @{$layers{$_}}\n" ) for qw/stdin stdout stderr/;
    # bypass scalar filehandles and tied handles
    # localize scalar STDIN to get a proxy to pick up FD0, then restore later to CT_ORIG_STDIN
    my %localize;
    $localize{stdin}++,  local(*STDIN)
      if grep { $_ eq 'scalar' } @{$layers{stdin}};
    $localize{stdout}++, local(*STDOUT)
      if $do_stdout && grep { $_ eq 'scalar' } @{$layers{stdout}};
    $localize{stderr}++, local(*STDERR)
      if ($do_stderr || $do_merge) && grep { $_ eq 'scalar' } @{$layers{stderr}};
    $localize{stdin}++, local(*STDIN), _open( \*STDIN, "<&=0")
      if tied *STDIN && $] >= 5.008;
    $localize{stdout}++, local(*STDOUT), _open( \*STDOUT, ">&=1")
      if $do_stdout && tied *STDOUT && $] >= 5.008;
    $localize{stderr}++, local(*STDERR), _open( \*STDERR, ">&=2")
      if ($do_stderr || $do_merge) && tied *STDERR && $] >= 5.008;
    # _debug( "# localized $_\n" ) for keys %localize;
    # proxy any closed/localized handles so we don't use fds 0, 1 or 2
    my %proxy_std = _proxy_std();
    # _debug( "# proxy std: @{ [%proxy_std] }\n" );
    # update layers after any proxying
    $layers{stdout} = [PerlIO::get_layers(\*STDOUT, output => 1)] if $proxy_std{stdout};
    $layers{stderr} = [PerlIO::get_layers(\*STDERR, output => 1)] if $proxy_std{stderr};
    # _debug( "# post-proxy layers for $_\: @{$layers{$_}}\n" ) for qw/stdin stdout stderr/;
    # store old handles and setup handles for capture
    $stash->{old} = _copy_std();
    $stash->{new} = { %{$stash->{old}} }; # default to originals
    for ( keys %do ) {
      $stash->{new}{$_} = ($stash->{capture}{$_} ||= File::Temp->new);
      seek( $stash->{capture}{$_}, 0, 2 ) or die "Could not seek on capture handle for $_\n";
      $stash->{pos}{$_} = tell $stash->{capture}{$_};
      # _debug("# will capture $_ on " . fileno($stash->{capture}{$_})."\n" );
      _start_tee( $_ => $stash ) if $do_tee; # tees may change $stash->{new}
    }
    _wait_for_tees( $stash ) if $do_tee;
    # finalize redirection
    $stash->{new}{stderr} = $stash->{new}{stdout} if $do_merge;
    # _debug( "# redirecting in parent ...\n" );
    _open_std( $stash->{new} );
    # execute user provided code
    my ($exit_code, $inner_error, $outer_error, $orig_pid, @result);
    {
      $orig_pid = $$;
      local *STDIN = *CT_ORIG_STDIN if $localize{stdin}; # get original, not proxy STDIN
      # _debug( "# finalizing layers ...\n" );
      _relayer(\*STDOUT, $layers{stdout}) if $do_stdout;
      _relayer(\*STDERR, $layers{stderr}) if $do_stderr;
      # _debug( "# running code $code ...\n" );
      my $old_eval_err=$@;
      undef $@;
      eval { @result = $code->(); $inner_error = $@ };
      $exit_code = $?; # save this for later
      $outer_error = $@; # save this for later
      STDOUT->flush if $do_stdout;
      STDERR->flush if $do_stderr;
      $@ = $old_eval_err;
    }
    # restore prior filehandles and shut down tees
    # _debug( "# restoring filehandles ...\n" );
    _open_std( $stash->{old} );
    _close( $_ ) for values %{$stash->{old}}; # don't leak fds
    # shouldn't need relayering originals, but see rt.perl.org #114404
    _relayer(\*STDOUT, $layers{stdout}) if $do_stdout;
    _relayer(\*STDERR, $layers{stderr}) if $do_stderr;
    _unproxy( %proxy_std );
    # _debug( "# killing tee subprocesses ...\n" ) if $do_tee;
    _kill_tees( $stash ) if $do_tee;
    # return captured output, but shortcut in void context
    # unless we have to echo output to tied/scalar handles;
    my %got;
    if ( $orig_pid == $$ and ( defined wantarray or ($do_tee && keys %localize) ) ) {
      for ( keys %do ) {
        _relayer($stash->{capture}{$_}, $layers{$_});
        $got{$_} = _slurp($_, $stash);
        # _debug("# slurped " . length($got{$_}) . " bytes from $_\n");
      }
      print CT_ORIG_STDOUT $got{stdout}
        if $do_stdout && $do_tee && $localize{stdout};
      print CT_ORIG_STDERR $got{stderr}
        if $do_stderr && $do_tee && $localize{stderr};
    }
    $? = $exit_code;
    $@ = $inner_error if $inner_error;
    die $outer_error if $outer_error;
    # _debug( "# ending _capture_tee with (@_)...\n" );
    return unless defined wantarray;
    my @return;
    push @return, $got{stdout} if $do_stdout;
    push @return, $got{stderr} if $do_stderr && ! $do_merge;
    push @return, @result;
    return wantarray ? @return : $return[0];
  }
  
  1;
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  Capture::Tiny - Capture STDOUT and STDERR from Perl, XS or external programs
  
  =head1 VERSION
  
  version 0.46
  
  =head1 SYNOPSIS
  
    use Capture::Tiny ':all';
  
    # capture from external command
  
    ($stdout, $stderr, $exit) = capture {
      system( $cmd, @args );
    };
  
    # capture from arbitrary code (Perl or external)
  
    ($stdout, $stderr, @result) = capture {
      # your code here
    };
  
    # capture partial or merged output
  
    $stdout = capture_stdout { ... };
    $stderr = capture_stderr { ... };
    $merged = capture_merged { ... };
  
    # tee output
  
    ($stdout, $stderr) = tee {
      # your code here
    };
  
    $stdout = tee_stdout { ... };
    $stderr = tee_stderr { ... };
    $merged = tee_merged { ... };
  
  =head1 DESCRIPTION
  
  Capture::Tiny provides a simple, portable way to capture almost anything sent
  to STDOUT or STDERR, regardless of whether it comes from Perl, from XS code or
  from an external program.  Optionally, output can be teed so that it is
  captured while being passed through to the original filehandles.  Yes, it even
  works on Windows (usually).  Stop guessing which of a dozen capturing modules
  to use in any particular situation and just use this one.
  
  =head1 USAGE
  
  The following functions are available.  None are exported by default.
  
  =head2 capture
  
    ($stdout, $stderr, @result) = capture \&code;
    $stdout = capture \&code;
  
  The C<capture> function takes a code reference and returns what is sent to
  STDOUT and STDERR as well as any return values from the code reference.  In
  scalar context, it returns only STDOUT.  If no output was received for a
  filehandle, it returns an empty string for that filehandle.  Regardless of calling
  context, all output is captured -- nothing is passed to the existing filehandles.
  
  It is prototyped to take a subroutine reference as an argument. Thus, it
  can be called in block form:
  
    ($stdout, $stderr) = capture {
      # your code here ...
    };
  
  Note that the coderef is evaluated in list context.  If you wish to force
  scalar context on the return value, you must use the C<scalar> keyword.
  
    ($stdout, $stderr, $count) = capture {
      my @list = qw/one two three/;
      return scalar @list; # $count will be 3
    };
  
  Also note that within the coderef, the C<@_> variable will be empty.  So don't
  use arguments from a surrounding subroutine without copying them to an array
  first:
  
    sub wont_work {
      my ($stdout, $stderr) = capture { do_stuff( @_ ) };    # WRONG
      ...
    }
  
    sub will_work {
      my @args = @_;
      my ($stdout, $stderr) = capture { do_stuff( @args ) }; # RIGHT
      ...
    }
  
  Captures are normally done to an anonymous temporary filehandle.  To
  capture via a named file (e.g. to externally monitor a long-running capture),
  provide custom filehandles as a trailing list of option pairs:
  
    my $out_fh = IO::File->new("out.txt", "w+");
    my $err_fh = IO::File->new("out.txt", "w+");
    capture { ... } stdout => $out_fh, stderr => $err_fh;
  
  The filehandles must be read/write and seekable.  Modifying the files or
  filehandles during a capture operation will give unpredictable results.
  Existing IO layers on them may be changed by the capture.
  
  When called in void context, C<capture> saves memory and time by
  not reading back from the capture handles.
  
  =head2 capture_stdout
  
    ($stdout, @result) = capture_stdout \&code;
    $stdout = capture_stdout \&code;
  
  The C<capture_stdout> function works just like C<capture> except only
  STDOUT is captured.  STDERR is not captured.
  
  =head2 capture_stderr
  
    ($stderr, @result) = capture_stderr \&code;
    $stderr = capture_stderr \&code;
  
  The C<capture_stderr> function works just like C<capture> except only
  STDERR is captured.  STDOUT is not captured.
  
  =head2 capture_merged
  
    ($merged, @result) = capture_merged \&code;
    $merged = capture_merged \&code;
  
  The C<capture_merged> function works just like C<capture> except STDOUT and
  STDERR are merged. (Technically, STDERR is redirected to the same capturing
  handle as STDOUT before executing the function.)
  
  Caution: STDOUT and STDERR output in the merged result are not guaranteed to be
  properly ordered due to buffering.
  
  =head2 tee
  
    ($stdout, $stderr, @result) = tee \&code;
    $stdout = tee \&code;
  
  The C<tee> function works just like C<capture>, except that output is captured
  as well as passed on to the original STDOUT and STDERR.
  
  When called in void context, C<tee> saves memory and time by
  not reading back from the capture handles, except when the
  original STDOUT OR STDERR were tied or opened to a scalar
  handle.
  
  =head2 tee_stdout
  
    ($stdout, @result) = tee_stdout \&code;
    $stdout = tee_stdout \&code;
  
  The C<tee_stdout> function works just like C<tee> except only
  STDOUT is teed.  STDERR is not teed (output goes to STDERR as usual).
  
  =head2 tee_stderr
  
    ($stderr, @result) = tee_stderr \&code;
    $stderr = tee_stderr \&code;
  
  The C<tee_stderr> function works just like C<tee> except only
  STDERR is teed.  STDOUT is not teed (output goes to STDOUT as usual).
  
  =head2 tee_merged
  
    ($merged, @result) = tee_merged \&code;
    $merged = tee_merged \&code;
  
  The C<tee_merged> function works just like C<capture_merged> except that output
  is captured as well as passed on to STDOUT.
  
  Caution: STDOUT and STDERR output in the merged result are not guaranteed to be
  properly ordered due to buffering.
  
  =head1 LIMITATIONS
  
  =head2 Portability
  
  Portability is a goal, not a guarantee.  C<tee> requires fork, except on
  Windows where C<system(1, @cmd)> is used instead.  Not tested on any
  particularly esoteric platforms yet.  See the
  L<CPAN Testers Matrix|http://matrix.cpantesters.org/?dist=Capture-Tiny>
  for test result by platform.
  
  =head2 PerlIO layers
  
  Capture::Tiny does its best to preserve PerlIO layers such as ':utf8' or
  ':crlf' when capturing (only for Perl 5.8.1+) .  Layers should be applied to
  STDOUT or STDERR I<before> the call to C<capture> or C<tee>.  This may not work
  for tied filehandles (see below).
  
  =head2 Modifying filehandles before capturing
  
  Generally speaking, you should do little or no manipulation of the standard IO
  filehandles prior to using Capture::Tiny.  In particular, closing, reopening,
  localizing or tying standard filehandles prior to capture may cause a variety of
  unexpected, undesirable and/or unreliable behaviors, as described below.
  Capture::Tiny does its best to compensate for these situations, but the
  results may not be what you desire.
  
  =head3 Closed filehandles
  
  Capture::Tiny will work even if STDIN, STDOUT or STDERR have been previously
  closed.  However, since they will be reopened to capture or tee output, any
  code within the captured block that depends on finding them closed will, of
  course, not find them to be closed.  If they started closed, Capture::Tiny will
  close them again when the capture block finishes.
  
  Note that this reopening will happen even for STDIN or a filehandle not being
  captured to ensure that the filehandle used for capture is not opened to file
  descriptor 0, as this causes problems on various platforms.
  
  Prior to Perl 5.12, closed STDIN combined with PERL_UNICODE=D leaks filehandles
  and also breaks tee() for undiagnosed reasons.  So don't do that.
  
  =head3 Localized filehandles
  
  If code localizes any of Perl's standard filehandles before capturing, the capture
  will affect the localized filehandles and not the original ones.  External system
  calls are not affected by localizing a filehandle in Perl and will continue
  to send output to the original filehandles (which will thus not be captured).
  
  =head3 Scalar filehandles
  
  If STDOUT or STDERR are reopened to scalar filehandles prior to the call to
  C<capture> or C<tee>, then Capture::Tiny will override the output filehandle for
  the duration of the C<capture> or C<tee> call and then, for C<tee>, send captured
  output to the output filehandle after the capture is complete.  (Requires Perl
  5.8)
  
  Capture::Tiny attempts to preserve the semantics of STDIN opened to a scalar
  reference, but note that external processes will not be able to read from such
  a handle.  Capture::Tiny tries to ensure that external processes will read from
  the null device instead, but this is not guaranteed.
  
  =head3 Tied output filehandles
  
  If STDOUT or STDERR are tied prior to the call to C<capture> or C<tee>, then
  Capture::Tiny will attempt to override the tie for the duration of the
  C<capture> or C<tee> call and then send captured output to the tied filehandle after
  the capture is complete.  (Requires Perl 5.8)
  
  Capture::Tiny may not succeed resending UTF-8 encoded data to a tied
  STDOUT or STDERR filehandle.  Characters may appear as bytes.  If the tied filehandle
  is based on L<Tie::StdHandle>, then Capture::Tiny will attempt to determine
  appropriate layers like C<:utf8> from the underlying filehandle and do the right
  thing.
  
  =head3 Tied input filehandle
  
  Capture::Tiny attempts to preserve the semantics of tied STDIN, but this
  requires Perl 5.8 and is not entirely predictable.  External processes
  will not be able to read from such a handle.
  
  Unless having STDIN tied is crucial, it may be safest to localize STDIN when
  capturing:
  
    my ($out, $err) = do { local *STDIN; capture { ... } };
  
  =head2 Modifying filehandles during a capture
  
  Attempting to modify STDIN, STDOUT or STDERR I<during> C<capture> or C<tee> is
  almost certainly going to cause problems.  Don't do that.
  
  =head3 Forking inside a capture
  
  Forks aren't portable.  The behavior of filehandles during a fork is even
  less so.  If Capture::Tiny detects that a fork has occurred within a
  capture, it will shortcut in the child process and return empty strings for
  captures.  Other problems may occur in the child or parent, as well.
  Forking in a capture block is not recommended.
  
  =head3 Using threads
  
  Filehandles are global.  Mixing up I/O and captures in different threads
  without coordination is going to cause problems.  Besides, threads are
  officially discouraged.
  
  =head3 Dropping privileges during a capture
  
  If you drop privileges during a capture, temporary files created to
  facilitate the capture may not be cleaned up afterwards.
  
  =head2 No support for Perl 5.8.0
  
  It's just too buggy when it comes to layers and UTF-8.  Perl 5.8.1 or later
  is recommended.
  
  =head2 Limited support for Perl 5.6
  
  Perl 5.6 predates PerlIO.  UTF-8 data may not be captured correctly.
  
  =head1 ENVIRONMENT
  
  =head2 PERL_CAPTURE_TINY_TIMEOUT
  
  Capture::Tiny uses subprocesses internally for C<tee>.  By default,
  Capture::Tiny will timeout with an error if such subprocesses are not ready to
  receive data within 30 seconds (or whatever is the value of
  C<$Capture::Tiny::TIMEOUT>).  An alternate timeout may be specified by setting
  the C<PERL_CAPTURE_TINY_TIMEOUT> environment variable.  Setting it to zero will
  disable timeouts.  B<NOTE>, this does not timeout the code reference being
  captured -- this only prevents Capture::Tiny itself from hanging your process
  waiting for its child processes to be ready to proceed.
  
  =head1 SEE ALSO
  
  This module was inspired by L<IO::CaptureOutput>, which provides
  similar functionality without the ability to tee output and with more
  complicated code and API.  L<IO::CaptureOutput> does not handle layers
  or most of the unusual cases described in the L</Limitations> section and
  I no longer recommend it.
  
  There are many other CPAN modules that provide some sort of output capture,
  albeit with various limitations that make them appropriate only in particular
  circumstances.  I'm probably missing some.  The long list is provided to show
  why I felt Capture::Tiny was necessary.
  
  =over 4
  
  =item *
  
  L<IO::Capture>
  
  =item *
  
  L<IO::Capture::Extended>
  
  =item *
  
  L<IO::CaptureOutput>
  
  =item *
  
  L<IPC::Capture>
  
  =item *
  
  L<IPC::Cmd>
  
  =item *
  
  L<IPC::Open2>
  
  =item *
  
  L<IPC::Open3>
  
  =item *
  
  L<IPC::Open3::Simple>
  
  =item *
  
  L<IPC::Open3::Utils>
  
  =item *
  
  L<IPC::Run>
  
  =item *
  
  L<IPC::Run::SafeHandles>
  
  =item *
  
  L<IPC::Run::Simple>
  
  =item *
  
  L<IPC::Run3>
  
  =item *
  
  L<IPC::System::Simple>
  
  =item *
  
  L<Tee>
  
  =item *
  
  L<IO::Tee>
  
  =item *
  
  L<File::Tee>
  
  =item *
  
  L<Filter::Handle>
  
  =item *
  
  L<Tie::STDERR>
  
  =item *
  
  L<Tie::STDOUT>
  
  =item *
  
  L<Test::Output>
  
  =back
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/dagolden/Capture-Tiny/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/dagolden/Capture-Tiny>
  
    git clone https://github.com/dagolden/Capture-Tiny.git
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 CONTRIBUTORS
  
  =for stopwords Dagfinn Ilmari Mannsåker David E. Wheeler fecundf Graham Knop Peter Rabbitson
  
  =over 4
  
  =item *
  
  Dagfinn Ilmari Mannsåker <ilmari@ilmari.org>
  
  =item *
  
  David E. Wheeler <david@justatheory.com>
  
  =item *
  
  fecundf <not.com+github@gmail.com>
  
  =item *
  
  Graham Knop <haarg@haarg.org>
  
  =item *
  
  Peter Rabbitson <ribasushi@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2009 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CAPTURE_TINY

$fatpacked{"Class/C3.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CLASS_C3';
  package Class::C3;
  
  use strict;
  use warnings;
  
  our $VERSION = '0.34';
  
  our $C3_IN_CORE;
  our $C3_XS;
  
  BEGIN {
      if($] > 5.009_004) {
          $C3_IN_CORE = 1;
          require mro;
      }
      elsif($C3_XS or not defined $C3_XS) {
          my $error = do {
              local $@;
              eval { require Class::C3::XS };
              $@;
          };
  
          if ($error) {
              die $error if $error !~ /\blocate\b/;
  
              if ($C3_XS) {
                  require Carp;
                  Carp::croak( "XS explicitly requested but Class::C3::XS is not available" );
              }
  
              require Algorithm::C3;
              require Class::C3::next;
          }
          else {
              $C3_XS = 1;
          }
      }
  }
  
  # this is our global stash of both
  # MRO's and method dispatch tables
  # the structure basically looks like
  # this:
  #
  #   $MRO{$class} = {
  #      MRO => [ <class precedence list> ],
  #      methods => {
  #          orig => <original location of method>,
  #          code => \&<ref to original method>
  #      },
  #      has_overload_fallback => (1 | 0)
  #   }
  #
  our %MRO;
  
  # use these for debugging ...
  sub _dump_MRO_table { %MRO }
  our $TURN_OFF_C3 = 0;
  
  # state tracking for initialize()/uninitialize()
  our $_initialized = 0;
  
  sub import {
      my $class = caller();
      # skip if the caller is main::
      # since that is clearly not relevant
      return if $class eq 'main';
  
      return if $TURN_OFF_C3;
      mro::set_mro($class, 'c3') if $C3_IN_CORE;
  
      # make a note to calculate $class
      # during INIT phase
      $MRO{$class} = undef unless exists $MRO{$class};
  }
  
  ## initializers
  
  # This prevents silly warnings when Class::C3 is
  #  used explicitly along with MRO::Compat under 5.9.5+
  
  { no warnings 'redefine';
  
  sub initialize {
      %next::METHOD_CACHE = ();
      # why bother if we don't have anything ...
      return unless keys %MRO;
      if($C3_IN_CORE) {
          mro::set_mro($_, 'c3') for keys %MRO;
      }
      else {
          if($_initialized) {
              uninitialize();
              $MRO{$_} = undef foreach keys %MRO;
          }
          _calculate_method_dispatch_tables();
          _apply_method_dispatch_tables();
          $_initialized = 1;
      }
  }
  
  sub uninitialize {
      # why bother if we don't have anything ...
      %next::METHOD_CACHE = ();
      return unless keys %MRO;
      if($C3_IN_CORE) {
          mro::set_mro($_, 'dfs') for keys %MRO;
      }
      else {
          _remove_method_dispatch_tables();
          $_initialized = 0;
      }
  }
  
  sub reinitialize { goto &initialize }
  
  } # end of "no warnings 'redefine'"
  
  ## functions for applying C3 to classes
  
  sub _calculate_method_dispatch_tables {
      return if $C3_IN_CORE;
      my %merge_cache;
      foreach my $class (keys %MRO) {
          _calculate_method_dispatch_table($class, \%merge_cache);
      }
  }
  
  sub _calculate_method_dispatch_table {
      return if $C3_IN_CORE;
      my ($class, $merge_cache) = @_;
      no strict 'refs';
      my @MRO = calculateMRO($class, $merge_cache);
      $MRO{$class} = { MRO => \@MRO };
      my $has_overload_fallback;
      my %methods;
      # NOTE:
      # we do @MRO[1 .. $#MRO] here because it
      # makes no sense to interrogate the class
      # which you are calculating for.
      foreach my $local (@MRO[1 .. $#MRO]) {
          # if overload has tagged this module to
          # have use "fallback", then we want to
          # grab that value
          $has_overload_fallback = ${"${local}::()"}
              if !defined $has_overload_fallback && defined ${"${local}::()"};
          foreach my $method (grep { defined &{"${local}::$_"} } keys %{"${local}::"}) {
              # skip if already overridden in local class
              next unless !defined *{"${class}::$method"}{CODE};
              $methods{$method} = {
                  orig => "${local}::$method",
                  code => \&{"${local}::$method"}
              } unless exists $methods{$method};
          }
      }
      # now stash them in our %MRO table
      $MRO{$class}->{methods} = \%methods;
      $MRO{$class}->{has_overload_fallback} = $has_overload_fallback;
  }
  
  sub _apply_method_dispatch_tables {
      return if $C3_IN_CORE;
      foreach my $class (keys %MRO) {
          _apply_method_dispatch_table($class);
      }
  }
  
  sub _apply_method_dispatch_table {
      return if $C3_IN_CORE;
      my $class = shift;
      no strict 'refs';
      ${"${class}::()"} = $MRO{$class}->{has_overload_fallback}
          if !defined &{"${class}::()"}
             && defined $MRO{$class}->{has_overload_fallback};
      foreach my $method (keys %{$MRO{$class}->{methods}}) {
          if ( $method =~ /^\(/ ) {
              my $orig = $MRO{$class}->{methods}->{$method}->{orig};
              ${"${class}::$method"} = $$orig if defined $$orig;
          }
          *{"${class}::$method"} = $MRO{$class}->{methods}->{$method}->{code};
      }
  }
  
  sub _remove_method_dispatch_tables {
      return if $C3_IN_CORE;
      foreach my $class (keys %MRO) {
          _remove_method_dispatch_table($class);
      }
  }
  
  sub _remove_method_dispatch_table {
      return if $C3_IN_CORE;
      my $class = shift;
      no strict 'refs';
      delete ${"${class}::"}{"()"} if $MRO{$class}->{has_overload_fallback};
      foreach my $method (keys %{$MRO{$class}->{methods}}) {
          delete ${"${class}::"}{$method}
              if defined *{"${class}::${method}"}{CODE} &&
                 (*{"${class}::${method}"}{CODE} eq $MRO{$class}->{methods}->{$method}->{code});
      }
  }
  
  sub calculateMRO {
      my ($class, $merge_cache) = @_;
  
      return Algorithm::C3::merge($class, sub {
          no strict 'refs';
          @{$_[0] . '::ISA'};
      }, $merge_cache);
  }
  
  # Method overrides to support 5.9.5+ or Class::C3::XS
  
  sub _core_calculateMRO { @{mro::get_linear_isa($_[0], 'c3')} }
  
  if($C3_IN_CORE) {
      no warnings 'redefine';
      *Class::C3::calculateMRO = \&_core_calculateMRO;
  }
  elsif($C3_XS) {
      no warnings 'redefine';
      *Class::C3::calculateMRO = \&Class::C3::XS::calculateMRO;
      *Class::C3::_calculate_method_dispatch_table
          = \&Class::C3::XS::_calculate_method_dispatch_table;
  }
  
  1;
  
  __END__
  
  =pod
  
  =head1 NAME
  
  Class::C3 - A pragma to use the C3 method resolution order algorithm
  
  =head1 SYNOPSIS
  
      # NOTE - DO NOT USE Class::C3 directly as a user, use MRO::Compat instead!
      package ClassA;
      use Class::C3;
      sub hello { 'A::hello' }
  
      package ClassB;
      use base 'ClassA';
      use Class::C3;
  
      package ClassC;
      use base 'ClassA';
      use Class::C3;
  
      sub hello { 'C::hello' }
  
      package ClassD;
      use base ('ClassB', 'ClassC');
      use Class::C3;
  
      # Classic Diamond MI pattern
      #    <A>
      #   /   \
      # <B>   <C>
      #   \   /
      #    <D>
  
      package main;
  
      # initializez the C3 module
      # (formerly called in INIT)
      Class::C3::initialize();
  
      print join ', ' => Class::C3::calculateMRO('ClassD'); # prints ClassD, ClassB, ClassC, ClassA
  
      print ClassD->hello(); # prints 'C::hello' instead of the standard p5 'A::hello'
  
      ClassD->can('hello')->();          # can() also works correctly
      UNIVERSAL::can('ClassD', 'hello'); # as does UNIVERSAL::can()
  
  =head1 DESCRIPTION
  
  This is pragma to change Perl 5's standard method resolution order from depth-first left-to-right
  (a.k.a - pre-order) to the more sophisticated C3 method resolution order.
  
  B<NOTE:> YOU SHOULD NOT USE THIS MODULE DIRECTLY - The feature provided
  is integrated into perl version >= 5.9.5, and you should use L<MRO::Compat>
  instead, which will use the core implementation in newer perls, but fallback
  to using this implementation on older perls.
  
  =head2 What is C3?
  
  C3 is the name of an algorithm which aims to provide a sane method resolution order under multiple
  inheritance. It was first introduced in the language Dylan (see links in the L<SEE ALSO> section),
  and then later adopted as the preferred MRO (Method Resolution Order) for the new-style classes in
  Python 2.3. Most recently it has been adopted as the 'canonical' MRO for Perl 6 classes, and the
  default MRO for Parrot objects as well.
  
  =head2 How does C3 work.
  
  C3 works by always preserving local precedence ordering. This essentially means that no class will
  appear before any of its subclasses. Take the classic diamond inheritance pattern for instance:
  
       <A>
      /   \
    <B>   <C>
      \   /
       <D>
  
  The standard Perl 5 MRO would be (D, B, A, C). The result being that B<A> appears before B<C>, even
  though B<C> is the subclass of B<A>. The C3 MRO algorithm however, produces the following MRO
  (D, B, C, A), which does not have this same issue.
  
  This example is fairly trivial, for more complex examples and a deeper explanation, see the links in
  the L<SEE ALSO> section.
  
  =head2 How does this module work?
  
  This module uses a technique similar to Perl 5's method caching. When C<Class::C3::initialize> is
  called, this module calculates the MRO of all the classes which called C<use Class::C3>. It then
  gathers information from the symbol tables of each of those classes, and builds a set of method
  aliases for the correct dispatch ordering. Once all these C3-based method tables are created, it
  then adds the method aliases into the local classes symbol table.
  
  The end result is actually classes with pre-cached method dispatch. However, this caching does not
  do well if you start changing your C<@ISA> or messing with class symbol tables, so you should consider
  your classes to be effectively closed. See the L<CAVEATS> section for more details.
  
  =head1 OPTIONAL LOWERCASE PRAGMA
  
  This release also includes an optional module B<c3> in the F<opt/> folder. I did not include this in
  the regular install since lowercase module names are considered I<"bad"> by some people. However I
  think that code looks much nicer like this:
  
    package MyClass;
    use c3;
  
  This is more clunky:
  
    package MyClass;
    use Class::C3;
  
  But hey, it's your choice, that's why it is optional.
  
  =head1 FUNCTIONS
  
  =over 4
  
  =item B<calculateMRO ($class)>
  
  Given a C<$class> this will return an array of class names in the proper C3 method resolution order.
  
  =item B<initialize>
  
  This B<must be called> to initialize the C3 method dispatch tables, this module B<will not work> if
  you do not do this. It is advised to do this as soon as possible B<after> loading any classes which
  use C3. Here is a quick code example:
  
    package Foo;
    use Class::C3;
    # ... Foo methods here
  
    package Bar;
    use Class::C3;
    use base 'Foo';
    # ... Bar methods here
  
    package main;
  
    Class::C3::initialize(); # now it is safe to use Foo and Bar
  
  This function used to be called automatically for you in the INIT phase of the perl compiler, but
  that lead to warnings if this module was required at runtime. After discussion with my user base
  (the L<DBIx::Class> folks), we decided that calling this in INIT was more of an annoyance than a
  convenience. I apologize to anyone this causes problems for (although I would be very surprised if I had
  any other users other than the L<DBIx::Class> folks). The simplest solution of course is to define
  your own INIT method which calls this function.
  
  NOTE:
  
  If C<initialize> detects that C<initialize> has already been executed, it will L</uninitialize> and
  clear the MRO cache first.
  
  =item B<uninitialize>
  
  Calling this function results in the removal of all cached methods, and the restoration of the old Perl 5
  style dispatch order (depth-first, left-to-right).
  
  =item B<reinitialize>
  
  This is an alias for L</initialize> above.
  
  =back
  
  =head1 METHOD REDISPATCHING
  
  It is always useful to be able to re-dispatch your method call to the "next most applicable method". This
  module provides a pseudo package along the lines of C<SUPER::> or C<NEXT::> which will re-dispatch the
  method along the C3 linearization. This is best shown with an example.
  
    # a classic diamond MI pattern ...
    #    <A>
    #   /   \
    # <B>   <C>
    #   \   /
    #    <D>
  
    package ClassA;
    use Class::C3;
    sub foo { 'ClassA::foo' }
  
    package ClassB;
    use base 'ClassA';
    use Class::C3;
    sub foo { 'ClassB::foo => ' . (shift)->next::method() }
  
    package ClassC;
    use base 'ClassA';
    use Class::C3;
    sub foo { 'ClassC::foo => ' . (shift)->next::method() }
  
    package ClassD;
    use base ('ClassB', 'ClassC');
    use Class::C3;
    sub foo { 'ClassD::foo => ' . (shift)->next::method() }
  
    print ClassD->foo; # prints out "ClassD::foo => ClassB::foo => ClassC::foo => ClassA::foo"
  
  A few things to note. First, we do not require you to add on the method name to the C<next::method>
  call (this is unlike C<NEXT::> and C<SUPER::> which do require that). This helps to enforce the rule
  that you cannot dispatch to a method of a different name (this is how C<NEXT::> behaves as well).
  
  The next thing to keep in mind is that you will need to pass all arguments to C<next::method>.  It can
  not automatically use the current C<@_>.
  
  If C<next::method> cannot find a next method to re-dispatch the call to, it will throw an exception.
  You can use C<next::can> to see if C<next::method> will succeed before you call it like so:
  
    $self->next::method(@_) if $self->next::can;
  
  Additionally, you can use C<maybe::next::method> as a shortcut to only call the next method if it exists.
  The previous example could be simply written as:
  
    $self->maybe::next::method(@_);
  
  There are some caveats about using C<next::method>, see below for those.
  
  =head1 CAVEATS
  
  This module used to be labeled as I<experimental>, however it has now been pretty heavily tested by
  the good folks over at L<DBIx::Class> and I am confident this module is perfectly usable for
  whatever your needs might be.
  
  But there are still caveats, so here goes ...
  
  =over 4
  
  =item Use of C<SUPER::>.
  
  The idea of C<SUPER::> under multiple inheritance is ambiguous, and generally not recommended anyway.
  However, its use in conjunction with this module is very much not recommended, and in fact very
  discouraged. The recommended approach is to instead use the supplied C<next::method> feature, see
  more details on its usage above.
  
  =item Changing C<@ISA>.
  
  It is the author's opinion that changing C<@ISA> at runtime is pure insanity anyway. However, people
  do it, so I must caveat. Any changes to the C<@ISA> will not be reflected in the MRO calculated by this
  module, and therefore probably won't even show up. If you do this, you will need to call C<reinitialize>
  in order to recalculate B<all> method dispatch tables. See the C<reinitialize> documentation and an example
  in F<t/20_reinitialize.t> for more information.
  
  =item Adding/deleting methods from class symbol tables.
  
  This module calculates the MRO for each requested class by interrogating the symbol tables of said classes.
  So any symbol table manipulation which takes place after our INIT phase is run will not be reflected in
  the calculated MRO. Just as with changing the C<@ISA>, you will need to call C<reinitialize> for any
  changes you make to take effect.
  
  =item Calling C<next::method> from methods defined outside the class
  
  There is an edge case when using C<next::method> from within a subroutine which was created in a different
  module than the one it is called from. It sounds complicated, but it really isn't. Here is an example which
  will not work correctly:
  
    *Foo::foo = sub { (shift)->next::method(@_) };
  
  The problem exists because the anonymous subroutine being assigned to the glob C<*Foo::foo> will show up
  in the call stack as being called C<__ANON__> and not C<foo> as you might expect. Since C<next::method>
  uses C<caller> to find the name of the method it was called in, it will fail in this case.
  
  But fear not, there is a simple solution. The module C<Sub::Name> will reach into the perl internals and
  assign a name to an anonymous subroutine for you. Simply do this:
  
    use Sub::Name 'subname';
    *Foo::foo = subname 'Foo::foo' => sub { (shift)->next::method(@_) };
  
  and things will Just Work. Of course this is not always possible to do, but to be honest, I just can't
  manage to find a workaround for it, so until someone gives me a working patch this will be a known
  limitation of this module.
  
  =back
  
  =head1 COMPATIBILITY
  
  If your software requires Perl 5.9.5 or higher, you do not need L<Class::C3>, you can simply C<use mro 'c3'>, and not worry about C<initialize()>, avoid some of the above caveats, and get the best possible performance.  See L<mro> for more details.
  
  If your software is meant to work on earlier Perls, use L<Class::C3> as documented here.  L<Class::C3> will detect Perl 5.9.5+ and take advantage of the core support when available.
  
  =head1 Class::C3::XS
  
  This module will load L<Class::C3::XS> if it's installed and you are running on a Perl version older than 5.9.5.  The optional module will be automatically installed for you if a C compiler is available, as it results in significant performance improvements (but unlike the 5.9.5+ core support, it still has all of the same caveats as L<Class::C3>).
  
  =head1 CODE COVERAGE
  
  L<Devel::Cover> was reporting 94.4% overall test coverage earlier in this module's life.  Currently, the test suite does things that break under coverage testing, but it is fair to assume the coverage is still close to that value.
  
  =head1 SEE ALSO
  
  =head2 The original Dylan paper
  
  =over 4
  
  =item L<https://web.archive.org/web/20000817033012id_/http://www.webcom.com/haahr/dylan/linearization-oopsla96.html>
  
  =back
  
  =head2 The prototype Perl 6 Object Model uses C3
  
  =over 4
  
  =item L<http://svn.openfoundry.org/pugs/perl5/Perl6-MetaModel/>
  
  =back
  
  =head2 Parrot now uses C3
  
  =over 4
  
  =item L<http://aspn.activestate.com/ASPN/Mail/Message/perl6-internals/2746631>
  
  =item L<http://use.perl.org/~autrijus/journal/25768>
  
  =back
  
  =head2 Python 2.3 MRO related links
  
  =over 4
  
  =item L<http://www.python.org/2.3/mro.html>
  
  =item L<http://www.python.org/2.2.2/descrintro.html#mro>
  
  =back
  
  =head2 C3 for TinyCLOS
  
  =over 4
  
  =item L<http://www.call-with-current-continuation.org/eggs/c3.html>
  
  =back
  
  =head1 ACKNOWLEGEMENTS
  
  =over 4
  
  =item Thanks to Matt S. Trout for using this module in his module L<DBIx::Class>
  and finding many bugs and providing fixes.
  
  =item Thanks to Justin Guenther for making C<next::method> more robust by handling
  calls inside C<eval> and anon-subs.
  
  =item Thanks to Robert Norris for adding support for C<next::can> and
  C<maybe::next::method>.
  
  =back
  
  =head1 AUTHOR
  
  Stevan Little, <stevan@iinteractive.com>
  
  Brandon L. Black, <blblack@gmail.com>
  
  =head1 COPYRIGHT AND LICENSE
  
  Copyright 2005, 2006 by Infinity Interactive, Inc.
  
  L<http://www.iinteractive.com>
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself.
  
  =cut
CLASS_C3

$fatpacked{"Class/C3/next.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CLASS_C3_NEXT';
  package  # hide me from PAUSE
      next;
  
  use strict;
  use warnings;
  no warnings 'redefine'; # for 00load.t w/ core support
  
  use Scalar::Util 'blessed';
  
  our $VERSION = '0.34';
  
  our %METHOD_CACHE;
  
  sub method {
      my $self     = $_[0];
      my $class    = blessed($self) || $self;
      my $indirect = caller() =~ /^(?:next|maybe::next)$/;
      my $level = $indirect ? 2 : 1;
  
      my ($method_caller, $label, @label);
      while ($method_caller = (caller($level++))[3]) {
        @label = (split '::', $method_caller);
        $label = pop @label;
        last unless
          $label eq '(eval)' ||
          $label eq '__ANON__';
      }
  
      my $method;
  
      my $caller   = join '::' => @label;
  
      $method = $METHOD_CACHE{"$class|$caller|$label"} ||= do {
  
          my @MRO = Class::C3::calculateMRO($class);
  
          my $current;
          while ($current = shift @MRO) {
              last if $caller eq $current;
          }
  
          no strict 'refs';
          my $found;
          foreach my $class (@MRO) {
              next if (defined $Class::C3::MRO{$class} &&
                       defined $Class::C3::MRO{$class}{methods}{$label});
              last if (defined ($found = *{$class . '::' . $label}{CODE}));
          }
  
          $found;
      };
  
      return $method if $indirect;
  
      die "No next::method '$label' found for $self" if !$method;
  
      goto &{$method};
  }
  
  sub can { method($_[0]) }
  
  package  # hide me from PAUSE
      maybe::next;
  
  use strict;
  use warnings;
  no warnings 'redefine'; # for 00load.t w/ core support
  
  our $VERSION = '0.34';
  
  sub method { (next::method($_[0]) || return)->(@_) }
  
  1;
  
  __END__
  
  =pod
  
  =head1 NAME
  
  Class::C3::next - Pure-perl next::method and friends
  
  =head1 DESCRIPTION
  
  This module is used internally by L<Class::C3> when
  necessary, and shouldn't be used (or required in
  distribution dependencies) directly.  It
  defines C<next::method>, C<next::can>, and
  C<maybe::next::method> in pure perl.
  
  =head1 AUTHOR
  
  Stevan Little, <stevan@iinteractive.com>
  
  Brandon L. Black, <blblack@gmail.com>
  
  =head1 COPYRIGHT AND LICENSE
  
  Copyright 2005, 2006 by Infinity Interactive, Inc.
  
  L<http://www.iinteractive.com>
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself.
  
  =cut
CLASS_C3_NEXT

$fatpacked{"Class/Tiny.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'CLASS_TINY';
  use 5.006;
  use strict;
  no strict 'refs';
  use warnings;
  
  package Class::Tiny;
  # ABSTRACT: Minimalist class construction
  
  our $VERSION = '1.006';
  
  use Carp ();
  
  # load as .pm to hide from min version scanners
  require( $] >= 5.010 ? "mro.pm" : "MRO/Compat.pm" ); ## no critic:
  
  my %CLASS_ATTRIBUTES;
  
  sub import {
      my $class = shift;
      my $pkg   = caller;
      $class->prepare_class($pkg);
      $class->create_attributes( $pkg, @_ ) if @_;
  }
  
  sub prepare_class {
      my ( $class, $pkg ) = @_;
      @{"${pkg}::ISA"} = "Class::Tiny::Object" unless @{"${pkg}::ISA"};
  }
  
  # adapted from Object::Tiny and Object::Tiny::RW
  sub create_attributes {
      my ( $class, $pkg, @spec ) = @_;
      my %defaults = map { ref $_ eq 'HASH' ? %$_ : ( $_ => undef ) } @spec;
      my @attr = grep {
          defined and !ref and /^[^\W\d]\w*$/s
            or Carp::croak "Invalid accessor name '$_'"
      } keys %defaults;
      $CLASS_ATTRIBUTES{$pkg}{$_} = $defaults{$_} for @attr;
      $class->_gen_accessor( $pkg, $_ ) for grep { !*{"$pkg\::$_"}{CODE} } @attr;
      Carp::croak("Failed to generate attributes for $pkg: $@\n") if $@;
  }
  
  sub _gen_accessor {
      my ( $class, $pkg, $name ) = @_;
      my $outer_default = $CLASS_ATTRIBUTES{$pkg}{$name};
  
      my $sub =
        $class->__gen_sub_body( $name, defined($outer_default), ref($outer_default) );
  
      # default = outer_default avoids "won't stay shared" bug
      eval "package $pkg; my \$default=\$outer_default; $sub"; ## no critic
      Carp::croak("Failed to generate attributes for $pkg: $@\n") if $@;
  }
  
  # NOTE: overriding __gen_sub_body in a subclass of Class::Tiny is risky and
  # could break if the internals of Class::Tiny need to change for any
  # reason.  That said, I currently see no reason why this would be likely to
  # change.
  #
  # The generated sub body should assume that a '$default' variable will be
  # in scope (i.e. when the sub is evaluated) with any default value/coderef
  sub __gen_sub_body {
      my ( $self, $name, $has_default, $default_type ) = @_;
  
      if ( $has_default && $default_type eq 'CODE' ) {
          return << "HERE";
  sub $name {
      return (
            ( \@_ == 1 && exists \$_[0]{$name} )
          ? ( \$_[0]{$name} )
          : ( \$_[0]{$name} = ( \@_ == 2 ) ? \$_[1] : \$default->( \$_[0] ) )
      );
  }
  HERE
      }
      elsif ($has_default) {
          return << "HERE";
  sub $name {
      return (
            ( \@_ == 1 && exists \$_[0]{$name} )
          ? ( \$_[0]{$name} )
          : ( \$_[0]{$name} = ( \@_ == 2 ) ? \$_[1] : \$default )
      );
  }
  HERE
      }
      else {
          return << "HERE";
  sub $name {
      return \@_ == 1 ? \$_[0]{$name} : ( \$_[0]{$name} =  \$_[1] );
  }
  HERE
      }
  }
  
  sub get_all_attributes_for {
      my ( $class, $pkg ) = @_;
      my %attr =
        map { $_ => undef }
        map { keys %{ $CLASS_ATTRIBUTES{$_} || {} } } @{ mro::get_linear_isa($pkg) };
      return keys %attr;
  }
  
  sub get_all_attribute_defaults_for {
      my ( $class, $pkg ) = @_;
      my $defaults = {};
      for my $p ( reverse @{ mro::get_linear_isa($pkg) } ) {
          while ( my ( $k, $v ) = each %{ $CLASS_ATTRIBUTES{$p} || {} } ) {
              $defaults->{$k} = $v;
          }
      }
      return $defaults;
  }
  
  package Class::Tiny::Object;
  # ABSTRACT: Base class for classes built with Class::Tiny
  
  our $VERSION = '1.006';
  
  my ( %HAS_BUILDARGS, %BUILD_CACHE, %DEMOLISH_CACHE, %ATTR_CACHE );
  
  my $_PRECACHE = sub {
      no warnings 'once'; # needed to avoid downstream warnings
      my ($class) = @_;
      my $linear_isa =
        @{"$class\::ISA"} == 1 && ${"$class\::ISA"}[0] eq "Class::Tiny::Object"
        ? [$class]
        : mro::get_linear_isa($class);
      $DEMOLISH_CACHE{$class} = [
          map { ( *{$_}{CODE} ) ? ( *{$_}{CODE} ) : () }
          map { "$_\::DEMOLISH" } @$linear_isa
      ];
      $BUILD_CACHE{$class} = [
          map { ( *{$_}{CODE} ) ? ( *{$_}{CODE} ) : () }
          map { "$_\::BUILD" } reverse @$linear_isa
      ];
      $HAS_BUILDARGS{$class} = $class->can("BUILDARGS");
      return $ATTR_CACHE{$class} =
        { map { $_ => 1 } Class::Tiny->get_all_attributes_for($class) };
  };
  
  sub new {
      my $class = shift;
      my $valid_attrs = $ATTR_CACHE{$class} || $_PRECACHE->($class);
  
      # handle hash ref or key/value arguments
      my $args;
      if ( $HAS_BUILDARGS{$class} ) {
          $args = $class->BUILDARGS(@_);
      }
      else {
          if ( @_ == 1 && ref $_[0] ) {
              my %copy = eval { %{ $_[0] } }; # try shallow copy
              Carp::croak("Argument to $class->new() could not be dereferenced as a hash") if $@;
              $args = \%copy;
          }
          elsif ( @_ % 2 == 0 ) {
              $args = {@_};
          }
          else {
              Carp::croak("$class->new() got an odd number of elements");
          }
      }
  
      # create object and invoke BUILD (unless we were given __no_BUILD__)
      my $self =
        bless { map { $_ => $args->{$_} } grep { exists $valid_attrs->{$_} } keys %$args },
        $class;
      $self->BUILDALL($args) if !delete $args->{__no_BUILD__} && @{ $BUILD_CACHE{$class} };
  
      return $self;
  }
  
  sub BUILDALL { $_->(@_) for @{ $BUILD_CACHE{ ref $_[0] } } }
  
  # Adapted from Moo and its dependencies
  require Devel::GlobalDestruction unless defined ${^GLOBAL_PHASE};
  
  sub DESTROY {
      my $self  = shift;
      my $class = ref $self;
      my $in_global_destruction =
        defined ${^GLOBAL_PHASE}
        ? ${^GLOBAL_PHASE} eq 'DESTRUCT'
        : Devel::GlobalDestruction::in_global_destruction();
      for my $demolisher ( @{ $DEMOLISH_CACHE{$class} } ) {
          my $e = do {
              local ( $?, $@ );
              eval { $demolisher->( $self, $in_global_destruction ) };
              $@;
          };
          no warnings 'misc'; # avoid (in cleanup) warnings
          die $e if $e;       # rethrow
      }
  }
  
  1;
  
  
  # vim: ts=4 sts=4 sw=4 et:
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  Class::Tiny - Minimalist class construction
  
  =head1 VERSION
  
  version 1.006
  
  =head1 SYNOPSIS
  
  In F<Person.pm>:
  
    package Person;
  
    use Class::Tiny qw( name );
  
    1;
  
  In F<Employee.pm>:
  
    package Employee;
    use parent 'Person';
  
    use Class::Tiny qw( ssn ), {
      timestamp => sub { time }   # attribute with default
    };
  
    1;
  
  In F<example.pl>:
  
    use Employee;
  
    my $obj = Employee->new( name => "Larry", ssn => "111-22-3333" );
  
    # unknown attributes are ignored
    my $obj = Employee->new( name => "Larry", OS => "Linux" );
    # $obj->{OS} does not exist
  
  =head1 DESCRIPTION
  
  This module offers a minimalist class construction kit in around 120 lines of
  code.  Here is a list of features:
  
  =over 4
  
  =item *
  
  defines attributes via import arguments
  
  =item *
  
  generates read-write accessors
  
  =item *
  
  supports lazy attribute defaults
  
  =item *
  
  supports custom accessors
  
  =item *
  
  superclass provides a standard C<new> constructor
  
  =item *
  
  C<new> takes a hash reference or list of key/value pairs
  
  =item *
  
  C<new> supports providing C<BUILDARGS> to customize constructor options
  
  =item *
  
  C<new> calls C<BUILD> for each class from parent to child
  
  =item *
  
  superclass provides a C<DESTROY> method
  
  =item *
  
  C<DESTROY> calls C<DEMOLISH> for each class from child to parent
  
  =back
  
  Multiple-inheritance is possible, with superclass order determined via
  L<mro::get_linear_isa|mro/Functions>.
  
  It uses no non-core modules for any recent Perl. On Perls older than v5.10 it
  requires L<MRO::Compat>. On Perls older than v5.14, it requires
  L<Devel::GlobalDestruction>.
  
  =head1 USAGE
  
  =head2 Defining attributes
  
  Define attributes as a list of import arguments:
  
      package Foo::Bar;
  
      use Class::Tiny qw(
          name
          id
          height
          weight
      );
  
  For each attribute, a read-write accessor is created unless a subroutine of that
  name already exists:
  
      $obj->name;               # getter
      $obj->name( "John Doe" ); # setter
  
  Attribute names must be valid subroutine identifiers or an exception will
  be thrown.
  
  You can specify lazy defaults by defining attributes with a hash reference.
  Keys define attribute names and values are constants or code references that
  will be evaluated when the attribute is first accessed if no value has been
  set.  The object is passed as an argument to a code reference.
  
      package Foo::WithDefaults;
  
      use Class::Tiny qw/name id/, {
          title     => 'Peon',
          skills    => sub { [] },
          hire_date => sub { $_[0]->_build_hire_date },
      };
  
  When subclassing, if multiple accessors of the same name exist in different
  classes, any default (or lack of default) is determined by standard
  method resolution order.
  
  To make your own custom accessors, just pre-declare the method name before
  loading Class::Tiny:
  
      package Foo::Bar;
  
      use subs 'id';
  
      use Class::Tiny qw( name id );
  
      sub id { ... }
  
  Even if you pre-declare a method name, you must include it in the attribute
  list for Class::Tiny to register it as a valid attribute.
  
  If you set a default for a custom accessor, your accessor will need to retrieve
  the default and do something with it:
  
      package Foo::Bar;
  
      use subs 'id';
  
      use Class::Tiny qw( name ), { id => sub { int(rand(2*31)) } };
  
      sub id {
          my $self = shift;
          if (@_) {
              return $self->{id} = shift;
          }
          elsif ( exists $self->{id} ) {
              return $self->{id};
          }
          else {
              my $defaults =
                  Class::Tiny->get_all_attribute_defaults_for( ref $self );
              return $self->{id} = $defaults->{id}->();
          }
      }
  
  =head2 Class::Tiny::Object is your base class
  
  If your class B<does not> already inherit from some class, then
  Class::Tiny::Object will be added to your C<@ISA> to provide C<new> and
  C<DESTROY>.
  
  If your class B<does> inherit from something, then no additional inheritance is
  set up.  If the parent subclasses Class::Tiny::Object, then all is well.  If
  not, then you'll get accessors set up but no constructor or destructor. Don't
  do that unless you really have a special need for it.
  
  Define subclasses as normal.  It's best to define them with L<base>, L<parent>
  or L<superclass> before defining attributes with Class::Tiny so the C<@ISA>
  array is already populated at compile-time:
  
      package Foo::Bar::More;
  
      use parent 'Foo::Bar';
  
      use Class::Tiny qw( shoe_size );
  
  =head2 Object construction
  
  If your class inherits from Class::Tiny::Object (as it should if you followed
  the advice above), it provides the C<new> constructor for you.
  
  Objects can be created with attributes given as a hash reference or as a list
  of key/value pairs:
  
      $obj = Foo::Bar->new( name => "David" );
  
      $obj = Foo::Bar->new( { name => "David" } );
  
  If a reference is passed as a single argument, it must be able to be
  dereferenced as a hash or an exception is thrown.
  
  Unknown attributes in the constructor arguments will be ignored.  Prior to
  version 1.000, unknown attributes were an error, but this made it harder for
  people to cleanly subclass Class::Tiny classes so this feature was removed.
  
  You can define a C<BUILDARGS> method to change how arguments to new are
  handled.  It will receive the constructor arguments as they were provided and
  must return a hash reference of key/value pairs (or else throw an
  exception).
  
      sub BUILDARGS {
         my $class = shift;
         my $name = shift || "John Doe";
         return { name => $name };
       };
  
       Foo::Bar->new( "David" );
       Foo::Bar->new(); # "John Doe"
  
  Unknown attributes returned from C<BUILDARGS> will be ignored.
  
  =head2 BUILD
  
  If your class or any superclass defines a C<BUILD> method, it will be called
  by the constructor from the furthest parent class down to the child class after
  the object has been created.
  
  It is passed the constructor arguments as a hash reference.  The return value
  is ignored.  Use C<BUILD> for validation, checking required attributes or
  setting default values that depend on other attributes.
  
      sub BUILD {
          my ($self, $args) = @_;
  
          for my $req ( qw/name age/ ) {
              croak "$req attribute required" unless defined $self->$req;
          }
  
          croak "Age must be non-negative" if $self->age < 0;
  
          $self->msg( "Hello " . $self->name );
      }
  
  The argument reference is a copy, so deleting elements won't affect data in the
  original (but changes will be passed to other BUILD methods in C<@ISA>).
  
  =head2 DEMOLISH
  
  Class::Tiny provides a C<DESTROY> method.  If your class or any superclass
  defines a C<DEMOLISH> method, they will be called from the child class to the
  furthest parent class during object destruction.  It is provided a single
  boolean argument indicating whether Perl is in global destruction.  Return
  values and errors are ignored.
  
      sub DEMOLISH {
          my ($self, $global_destruct) = @_;
          $self->cleanup();
      }
  
  =head2 Introspection and internals
  
  You can retrieve an unsorted list of valid attributes known to Class::Tiny
  for a class and its superclasses with the C<get_all_attributes_for> class
  method.
  
      my @attrs = Class::Tiny->get_all_attributes_for("Employee");
      # returns qw/name ssn timestamp/
  
  Likewise, a hash reference of all valid attributes and default values (or code
  references) may be retrieved with the C<get_all_attribute_defaults_for> class
  method.  Any attributes without a default will be C<undef>.
  
      my $def = Class::Tiny->get_all_attribute_defaults_for("Employee");
      # returns {
      #   name => undef,
      #   ssn => undef
      #   timestamp => $coderef
      # }
  
  The C<import> method uses two class methods, C<prepare_class> and
  C<create_attributes> to set up the C<@ISA> array and attributes.  Anyone
  attempting to extend Class::Tiny itself should use these instead of mocking up
  a call to C<import>.
  
  When the first object is created, linearized C<@ISA>, the valid attribute list
  and various subroutine references are cached for speed.  Ensure that all
  inheritance and methods are in place before creating objects. (You don't want
  to be changing that once you create objects anyway, right?)
  
  =for Pod::Coverage new get_all_attributes_for get_all_attribute_defaults_for
  prepare_class create_attributes
  
  =head1 RATIONALE
  
  =head2 Why this instead of Object::Tiny or Class::Accessor or something else?
  
  I wanted something so simple that it could potentially be used by core Perl
  modules I help maintain (or hope to write), most of which either use
  L<Class::Struct> or roll-their-own OO framework each time.
  
  L<Object::Tiny> and L<Object::Tiny::RW> were close to what I wanted, but
  lacking some features I deemed necessary, and their maintainers have an even
  more strict philosophy against feature creep than I have.
  
  I also considered L<Class::Accessor>, which has been around a long time and is
  heavily used, but it, too, lacked features I wanted and did things in ways I
  considered poor design.
  
  I looked for something else on CPAN, but after checking a dozen class creators
  I realized I could implement exactly what I wanted faster than I could search
  CPAN for something merely sufficient.
  
  In general, compared to most things on CPAN (other than Object::Tiny),
  Class::Tiny is smaller in implementation and simpler in API.
  
  Specifically, here is how Class::Tiny ("C::T") compares to Object::Tiny
  ("O::T") and Class::Accessor ("C::A"):
  
   FEATURE                            C::T    O::T      C::A
   --------------------------------------------------------------
   attributes defined via import      yes     yes       no
   read/write accessors               yes     no        yes
   lazy attribute defaults            yes     no        no
   provides new                       yes     yes       yes
   provides DESTROY                   yes     no        no
   new takes either hashref or list   yes     no (list) no (hash)
   Moo(se)-like BUILD/DEMOLISH        yes     no        no
   Moo(se)-like BUILDARGS             yes     no        no
   no extraneous methods via @ISA     yes     yes       no
  
  =head2 Why this instead of Moose or Moo?
  
  L<Moose> and L<Moo> are both excellent OO frameworks.  Moose offers a powerful
  meta-object protocol (MOP), but is slow to start up and has about 30 non-core
  dependencies including XS modules.  Moo is faster to start up and has about 10
  pure Perl dependencies but provides no true MOP, relying instead on its ability
  to transparently upgrade Moo to Moose when Moose's full feature set is
  required.
  
  By contrast, Class::Tiny has no MOP and has B<zero> non-core dependencies for
  Perls in the L<support window|perlpolicy>.  It has far less code, less
  complexity and no learning curve. If you don't need or can't afford what Moo or
  Moose offer, this is intended to be a reasonable fallback.
  
  That said, Class::Tiny offers Moose-like conventions for things like C<BUILD>
  and C<DEMOLISH> for some minimal interoperability and an easier upgrade path.
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/dagolden/Class-Tiny/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/dagolden/Class-Tiny>
  
    git clone https://github.com/dagolden/Class-Tiny.git
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 CONTRIBUTORS
  
  =for stopwords Dagfinn Ilmari Mannsåker David Golden Gelu Lupas Karen Etheridge Olivier Mengué Toby Inkster
  
  =over 4
  
  =item *
  
  Dagfinn Ilmari Mannsåker <ilmari@ilmari.org>
  
  =item *
  
  David Golden <xdg@xdg.me>
  
  =item *
  
  Gelu Lupas <gelu@devnull.ro>
  
  =item *
  
  Karen Etheridge <ether@cpan.org>
  
  =item *
  
  Olivier Mengué <dolmen@cpan.org>
  
  =item *
  
  Toby Inkster <tobyink@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2013 by David Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
CLASS_TINY

$fatpacked{"Devel/GlobalDestruction.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'DEVEL_GLOBALDESTRUCTION';
  package Devel::GlobalDestruction;
  
  use strict;
  use warnings;
  
  our $VERSION = '0.14';
  
  use Sub::Exporter::Progressive -setup => {
    exports => [ qw(in_global_destruction) ],
    groups  => { default => [ -all ] },
  };
  
  # we run 5.14+ - everything is in core
  #
  if (defined ${^GLOBAL_PHASE}) {
    eval 'sub in_global_destruction () { ${^GLOBAL_PHASE} eq q[DESTRUCT] }; 1'
      or die $@;
  }
  # try to load the xs version if it was compiled
  #
  elsif (eval {
    require Devel::GlobalDestruction::XS;
    no warnings 'once';
    *in_global_destruction = \&Devel::GlobalDestruction::XS::in_global_destruction;
    1;
  }) {
    # the eval already installed everything, nothing to do
  }
  else {
    # internally, PL_main_cv is set to Nullcv immediately before entering
    # global destruction and we can use B to detect that.  B::main_cv will
    # only ever be a B::CV or a B::SPECIAL that is a reference to 0
    require B;
    eval 'sub in_global_destruction () { ${B::main_cv()} == 0 }; 1'
      or die $@;
  }
  
  1;  # keep require happy
  
  
  __END__
  
  =head1 NAME
  
  Devel::GlobalDestruction - Provides function returning the equivalent of
  C<${^GLOBAL_PHASE} eq 'DESTRUCT'> for older perls.
  
  =head1 SYNOPSIS
  
      package Foo;
      use Devel::GlobalDestruction;
  
      use namespace::clean; # to avoid having an "in_global_destruction" method
  
      sub DESTROY {
          return if in_global_destruction;
  
          do_something_a_little_tricky();
      }
  
  =head1 DESCRIPTION
  
  Perl's global destruction is a little tricky to deal with WRT finalizers
  because it's not ordered and objects can sometimes disappear.
  
  Writing defensive destructors is hard and annoying, and usually if global
  destruction is happening you only need the destructors that free up non
  process local resources to actually execute.
  
  For these constructors you can avoid the mess by simply bailing out if global
  destruction is in effect.
  
  =head1 EXPORTS
  
  This module uses L<Sub::Exporter::Progressive> so the exports may be renamed,
  aliased, etc. if L<Sub::Exporter> is present.
  
  =over 4
  
  =item in_global_destruction
  
  Returns true if the interpreter is in global destruction. In perl 5.14+, this
  returns C<${^GLOBAL_PHASE} eq 'DESTRUCT'>, and on earlier perls, detects it using
  the value of C<PL_main_cv> or C<PL_dirty>.
  
  =back
  
  =head1 AUTHORS
  
  Yuval Kogman E<lt>nothingmuch@woobling.orgE<gt>
  
  Florian Ragwitz E<lt>rafl@debian.orgE<gt>
  
  Jesse Luehrs E<lt>doy@tozt.netE<gt>
  
  Peter Rabbitson E<lt>ribasushi@cpan.orgE<gt>
  
  Arthur Axel 'fREW' Schmidt E<lt>frioux@gmail.comE<gt>
  
  Elizabeth Mattijsen E<lt>liz@dijkmat.nlE<gt>
  
  Greham Knop E<lt>haarg@haarg.orgE<gt>
  
  =head1 COPYRIGHT
  
      Copyright (c) 2008 Yuval Kogman. All rights reserved
      This program is free software; you can redistribute
      it and/or modify it under the same terms as Perl itself.
  
  =cut
DEVEL_GLOBALDESTRUCTION

$fatpacked{"Exporter.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'EXPORTER';
  package Exporter;
  
  require 5.006;
  
  # Be lean.
  #use strict;
  #no strict 'refs';
  
  our $Debug = 0;
  our $ExportLevel = 0;
  our $Verbose ||= 0;
  our $VERSION = '5.72';
  our (%Cache);
  
  sub as_heavy {
    require Exporter::Heavy;
    # Unfortunately, this does not work if the caller is aliased as *name = \&foo
    # Thus the need to create a lot of identical subroutines
    my $c = (caller(1))[3];
    $c =~ s/.*:://;
    \&{"Exporter::Heavy::heavy_$c"};
  }
  
  sub export {
    goto &{as_heavy()};
  }
  
  sub import {
    my $pkg = shift;
    my $callpkg = caller($ExportLevel);
  
    if ($pkg eq "Exporter" and @_ and $_[0] eq "import") {
      *{$callpkg."::import"} = \&import;
      return;
    }
  
    # We *need* to treat @{"$pkg\::EXPORT_FAIL"} since Carp uses it :-(
    my $exports = \@{"$pkg\::EXPORT"};
    # But, avoid creating things if they don't exist, which saves a couple of
    # hundred bytes per package processed.
    my $fail = ${$pkg . '::'}{EXPORT_FAIL} && \@{"$pkg\::EXPORT_FAIL"};
    return export $pkg, $callpkg, @_
      if $Verbose or $Debug or $fail && @$fail > 1;
    my $export_cache = ($Cache{$pkg} ||= {});
    my $args = @_ or @_ = @$exports;
  
    if ($args and not %$export_cache) {
      s/^&//, $export_cache->{$_} = 1
        foreach (@$exports, @{"$pkg\::EXPORT_OK"});
    }
    my $heavy;
    # Try very hard not to use {} and hence have to  enter scope on the foreach
    # We bomb out of the loop with last as soon as heavy is set.
    if ($args or $fail) {
      ($heavy = (/\W/ or $args and not exists $export_cache->{$_}
                 or $fail and @$fail and $_ eq $fail->[0])) and last
                   foreach (@_);
    } else {
      ($heavy = /\W/) and last
        foreach (@_);
    }
    return export $pkg, $callpkg, ($args ? @_ : ()) if $heavy;
    local $SIG{__WARN__} = 
  	sub {require Carp; &Carp::carp} if not $SIG{__WARN__};
    # shortcut for the common case of no type character
    *{"$callpkg\::$_"} = \&{"$pkg\::$_"} foreach @_;
  }
  
  # Default methods
  
  sub export_fail {
      my $self = shift;
      @_;
  }
  
  # Unfortunately, caller(1)[3] "does not work" if the caller is aliased as
  # *name = \&foo.  Thus the need to create a lot of identical subroutines
  # Otherwise we could have aliased them to export().
  
  sub export_to_level {
    goto &{as_heavy()};
  }
  
  sub export_tags {
    goto &{as_heavy()};
  }
  
  sub export_ok_tags {
    goto &{as_heavy()};
  }
  
  sub require_version {
    goto &{as_heavy()};
  }
  
  1;
  __END__
  
  =head1 NAME
  
  Exporter - Implements default import method for modules
  
  =head1 SYNOPSIS
  
  In module F<YourModule.pm>:
  
    package YourModule;
    require Exporter;
    @ISA = qw(Exporter);
    @EXPORT_OK = qw(munge frobnicate);  # symbols to export on request
  
  or
  
    package YourModule;
    use Exporter 'import'; # gives you Exporter's import() method directly
    @EXPORT_OK = qw(munge frobnicate);  # symbols to export on request
  
  In other files which wish to use C<YourModule>:
  
    use YourModule qw(frobnicate);      # import listed symbols
    frobnicate ($left, $right)          # calls YourModule::frobnicate
  
  Take a look at L</Good Practices> for some variants
  you will like to use in modern Perl code.
  
  =head1 DESCRIPTION
  
  The Exporter module implements an C<import> method which allows a module
  to export functions and variables to its users' namespaces.  Many modules
  use Exporter rather than implementing their own C<import> method because
  Exporter provides a highly flexible interface, with an implementation optimised
  for the common case.
  
  Perl automatically calls the C<import> method when processing a
  C<use> statement for a module.  Modules and C<use> are documented
  in L<perlfunc> and L<perlmod>.  Understanding the concept of
  modules and how the C<use> statement operates is important to
  understanding the Exporter.
  
  =head2 How to Export
  
  The arrays C<@EXPORT> and C<@EXPORT_OK> in a module hold lists of
  symbols that are going to be exported into the users name space by
  default, or which they can request to be exported, respectively.  The
  symbols can represent functions, scalars, arrays, hashes, or typeglobs.
  The symbols must be given by full name with the exception that the
  ampersand in front of a function is optional, e.g.
  
      @EXPORT    = qw(afunc $scalar @array);   # afunc is a function
      @EXPORT_OK = qw(&bfunc %hash *typeglob); # explicit prefix on &bfunc
  
  If you are only exporting function names it is recommended to omit the
  ampersand, as the implementation is faster this way.
  
  =head2 Selecting What to Export
  
  Do B<not> export method names!
  
  Do B<not> export anything else by default without a good reason!
  
  Exports pollute the namespace of the module user.  If you must export
  try to use C<@EXPORT_OK> in preference to C<@EXPORT> and avoid short or
  common symbol names to reduce the risk of name clashes.
  
  Generally anything not exported is still accessible from outside the
  module using the C<YourModule::item_name> (or C<< $blessed_ref->method >>)
  syntax.  By convention you can use a leading underscore on names to
  informally indicate that they are 'internal' and not for public use.
  
  (It is actually possible to get private functions by saying:
  
    my $subref = sub { ... };
    $subref->(@args);            # Call it as a function
    $obj->$subref(@args);        # Use it as a method
  
  However if you use them for methods it is up to you to figure out
  how to make inheritance work.)
  
  As a general rule, if the module is trying to be object oriented
  then export nothing.  If it's just a collection of functions then
  C<@EXPORT_OK> anything but use C<@EXPORT> with caution.  For function and
  method names use barewords in preference to names prefixed with
  ampersands for the export lists.
  
  Other module design guidelines can be found in L<perlmod>.
  
  =head2 How to Import
  
  In other files which wish to use your module there are three basic ways for
  them to load your module and import its symbols:
  
  =over 4
  
  =item C<use YourModule;>
  
  This imports all the symbols from YourModule's C<@EXPORT> into the namespace
  of the C<use> statement.
  
  =item C<use YourModule ();>
  
  This causes perl to load your module but does not import any symbols.
  
  =item C<use YourModule qw(...);>
  
  This imports only the symbols listed by the caller into their namespace.
  All listed symbols must be in your C<@EXPORT> or C<@EXPORT_OK>, else an error
  occurs.  The advanced export features of Exporter are accessed like this,
  but with list entries that are syntactically distinct from symbol names.
  
  =back
  
  Unless you want to use its advanced features, this is probably all you
  need to know to use Exporter.
  
  =head1 Advanced Features
  
  =head2 Specialised Import Lists
  
  If any of the entries in an import list begins with !, : or / then
  the list is treated as a series of specifications which either add to
  or delete from the list of names to import.  They are processed left to
  right. Specifications are in the form:
  
      [!]name         This name only
      [!]:DEFAULT     All names in @EXPORT
      [!]:tag         All names in $EXPORT_TAGS{tag} anonymous array
      [!]/pattern/    All names in @EXPORT and @EXPORT_OK which match
  
  A leading ! indicates that matching names should be deleted from the
  list of names to import.  If the first specification is a deletion it
  is treated as though preceded by :DEFAULT.  If you just want to import
  extra names in addition to the default set you will still need to
  include :DEFAULT explicitly.
  
  e.g., F<Module.pm> defines:
  
      @EXPORT      = qw(A1 A2 A3 A4 A5);
      @EXPORT_OK   = qw(B1 B2 B3 B4 B5);
      %EXPORT_TAGS = (T1 => [qw(A1 A2 B1 B2)], T2 => [qw(A1 A2 B3 B4)]);
  
  Note that you cannot use tags in @EXPORT or @EXPORT_OK.
  
  Names in EXPORT_TAGS must also appear in @EXPORT or @EXPORT_OK.
  
  An application using Module can say something like:
  
      use Module qw(:DEFAULT :T2 !B3 A3);
  
  Other examples include:
  
      use Socket qw(!/^[AP]F_/ !SOMAXCONN !SOL_SOCKET);
      use POSIX  qw(:errno_h :termios_h !TCSADRAIN !/^EXIT/);
  
  Remember that most patterns (using //) will need to be anchored
  with a leading ^, e.g., C</^EXIT/> rather than C</EXIT/>.
  
  You can say C<BEGIN { $Exporter::Verbose=1 }> to see how the
  specifications are being processed and what is actually being imported
  into modules.
  
  =head2 Exporting Without Using Exporter's import Method
  
  Exporter has a special method, 'export_to_level' which is used in situations
  where you can't directly call Exporter's
  import method.  The export_to_level
  method looks like:
  
      MyPackage->export_to_level(
  	$where_to_export, $package, @what_to_export
      );
  
  where C<$where_to_export> is an integer telling how far up the calling stack
  to export your symbols, and C<@what_to_export> is an array telling what
  symbols *to* export (usually this is C<@_>).  The C<$package> argument is
  currently unused.
  
  For example, suppose that you have a module, A, which already has an
  import function:
  
      package A;
  
      @ISA = qw(Exporter);
      @EXPORT_OK = qw($b);
  
      sub import
      {
  	$A::b = 1;     # not a very useful import method
      }
  
  and you want to Export symbol C<$A::b> back to the module that called 
  package A.  Since Exporter relies on the import method to work, via 
  inheritance, as it stands Exporter::import() will never get called. 
  Instead, say the following:
  
      package A;
      @ISA = qw(Exporter);
      @EXPORT_OK = qw($b);
  
      sub import
      {
  	$A::b = 1;
  	A->export_to_level(1, @_);
      }
  
  This will export the symbols one level 'above' the current package - ie: to 
  the program or module that used package A. 
  
  Note: Be careful not to modify C<@_> at all before you call export_to_level
  - or people using your package will get very unexplained results!
  
  =head2 Exporting Without Inheriting from Exporter
  
  By including Exporter in your C<@ISA> you inherit an Exporter's import() method
  but you also inherit several other helper methods which you probably don't
  want.  To avoid this you can do:
  
    package YourModule;
    use Exporter qw(import);
  
  which will export Exporter's own import() method into YourModule.
  Everything will work as before but you won't need to include Exporter in
  C<@YourModule::ISA>.
  
  Note: This feature was introduced in version 5.57
  of Exporter, released with perl 5.8.3.
  
  =head2 Module Version Checking
  
  The Exporter module will convert an attempt to import a number from a
  module into a call to C<< $module_name->VERSION($value) >>.  This can
  be used to validate that the version of the module being used is
  greater than or equal to the required version.
  
  For historical reasons, Exporter supplies a C<require_version> method that
  simply delegates to C<VERSION>.  Originally, before C<UNIVERSAL::VERSION>
  existed, Exporter would call C<require_version>.
  
  Since the C<UNIVERSAL::VERSION> method treats the C<$VERSION> number as
  a simple numeric value it will regard version 1.10 as lower than
  1.9.  For this reason it is strongly recommended that you use numbers
  with at least two decimal places, e.g., 1.09.
  
  =head2 Managing Unknown Symbols
  
  In some situations you may want to prevent certain symbols from being
  exported.  Typically this applies to extensions which have functions
  or constants that may not exist on some systems.
  
  The names of any symbols that cannot be exported should be listed
  in the C<@EXPORT_FAIL> array.
  
  If a module attempts to import any of these symbols the Exporter
  will give the module an opportunity to handle the situation before
  generating an error.  The Exporter will call an export_fail method
  with a list of the failed symbols:
  
    @failed_symbols = $module_name->export_fail(@failed_symbols);
  
  If the C<export_fail> method returns an empty list then no error is
  recorded and all the requested symbols are exported.  If the returned
  list is not empty then an error is generated for each symbol and the
  export fails.  The Exporter provides a default C<export_fail> method which
  simply returns the list unchanged.
  
  Uses for the C<export_fail> method include giving better error messages
  for some symbols and performing lazy architectural checks (put more
  symbols into C<@EXPORT_FAIL> by default and then take them out if someone
  actually tries to use them and an expensive check shows that they are
  usable on that platform).
  
  =head2 Tag Handling Utility Functions
  
  Since the symbols listed within C<%EXPORT_TAGS> must also appear in either
  C<@EXPORT> or C<@EXPORT_OK>, two utility functions are provided which allow
  you to easily add tagged sets of symbols to C<@EXPORT> or C<@EXPORT_OK>:
  
    %EXPORT_TAGS = (foo => [qw(aa bb cc)], bar => [qw(aa cc dd)]);
  
    Exporter::export_tags('foo');     # add aa, bb and cc to @EXPORT
    Exporter::export_ok_tags('bar');  # add aa, cc and dd to @EXPORT_OK
  
  Any names which are not tags are added to C<@EXPORT> or C<@EXPORT_OK>
  unchanged but will trigger a warning (with C<-w>) to avoid misspelt tags
  names being silently added to C<@EXPORT> or C<@EXPORT_OK>.  Future versions
  may make this a fatal error.
  
  =head2 Generating Combined Tags
  
  If several symbol categories exist in C<%EXPORT_TAGS>, it's usually
  useful to create the utility ":all" to simplify "use" statements.
  
  The simplest way to do this is:
  
    %EXPORT_TAGS = (foo => [qw(aa bb cc)], bar => [qw(aa cc dd)]);
  
    # add all the other ":class" tags to the ":all" class,
    # deleting duplicates
    {
      my %seen;
  
      push @{$EXPORT_TAGS{all}},
        grep {!$seen{$_}++} @{$EXPORT_TAGS{$_}} foreach keys %EXPORT_TAGS;
    }
  
  F<CGI.pm> creates an ":all" tag which contains some (but not really
  all) of its categories.  That could be done with one small
  change:
  
    # add some of the other ":class" tags to the ":all" class,
    # deleting duplicates
    {
      my %seen;
  
      push @{$EXPORT_TAGS{all}},
        grep {!$seen{$_}++} @{$EXPORT_TAGS{$_}}
          foreach qw/html2 html3 netscape form cgi internal/;
    }
  
  Note that the tag names in C<%EXPORT_TAGS> don't have the leading ':'.
  
  =head2 C<AUTOLOAD>ed Constants
  
  Many modules make use of C<AUTOLOAD>ing for constant subroutines to
  avoid having to compile and waste memory on rarely used values (see
  L<perlsub> for details on constant subroutines).  Calls to such
  constant subroutines are not optimized away at compile time because
  they can't be checked at compile time for constancy.
  
  Even if a prototype is available at compile time, the body of the
  subroutine is not (it hasn't been C<AUTOLOAD>ed yet).  perl needs to
  examine both the C<()> prototype and the body of a subroutine at
  compile time to detect that it can safely replace calls to that
  subroutine with the constant value.
  
  A workaround for this is to call the constants once in a C<BEGIN> block:
  
     package My ;
  
     use Socket ;
  
     foo( SO_LINGER );  ## SO_LINGER NOT optimized away; called at runtime
     BEGIN { SO_LINGER }
     foo( SO_LINGER );  ## SO_LINGER optimized away at compile time.
  
  This forces the C<AUTOLOAD> for C<SO_LINGER> to take place before
  SO_LINGER is encountered later in C<My> package.
  
  If you are writing a package that C<AUTOLOAD>s, consider forcing
  an C<AUTOLOAD> for any constants explicitly imported by other packages
  or which are usually used when your package is C<use>d.
  
  =head1 Good Practices
  
  =head2 Declaring C<@EXPORT_OK> and Friends
  
  When using C<Exporter> with the standard C<strict> and C<warnings>
  pragmas, the C<our> keyword is needed to declare the package
  variables C<@EXPORT_OK>, C<@EXPORT>, C<@ISA>, etc.
  
    our @ISA = qw(Exporter);
    our @EXPORT_OK = qw(munge frobnicate);
  
  If backward compatibility for Perls under 5.6 is important,
  one must write instead a C<use vars> statement.
  
    use vars qw(@ISA @EXPORT_OK);
    @ISA = qw(Exporter);
    @EXPORT_OK = qw(munge frobnicate);
  
  =head2 Playing Safe
  
  There are some caveats with the use of runtime statements
  like C<require Exporter> and the assignment to package
  variables, which can be very subtle for the unaware programmer.
  This may happen for instance with mutually recursive
  modules, which are affected by the time the relevant
  constructions are executed.
  
  The ideal (but a bit ugly) way to never have to think
  about that is to use C<BEGIN> blocks.  So the first part
  of the L</SYNOPSIS> code could be rewritten as:
  
    package YourModule;
  
    use strict;
    use warnings;
  
    our (@ISA, @EXPORT_OK);
    BEGIN {
       require Exporter;
       @ISA = qw(Exporter);
       @EXPORT_OK = qw(munge frobnicate);  # symbols to export on request
    }
  
  The C<BEGIN> will assure that the loading of F<Exporter.pm>
  and the assignments to C<@ISA> and C<@EXPORT_OK> happen
  immediately, leaving no room for something to get awry
  or just plain wrong.
  
  With respect to loading C<Exporter> and inheriting, there
  are alternatives with the use of modules like C<base> and C<parent>.
  
    use base qw(Exporter);
    # or
    use parent qw(Exporter);
  
  Any of these statements are nice replacements for
  C<BEGIN { require Exporter; @ISA = qw(Exporter); }>
  with the same compile-time effect.  The basic difference
  is that C<base> code interacts with declared C<fields>
  while C<parent> is a streamlined version of the older
  C<base> code to just establish the IS-A relationship.
  
  For more details, see the documentation and code of
  L<base> and L<parent>.
  
  Another thorough remedy to that runtime
  vs. compile-time trap is to use L<Exporter::Easy>,
  which is a wrapper of Exporter that allows all
  boilerplate code at a single gulp in the
  use statement.
  
     use Exporter::Easy (
         OK => [ qw(munge frobnicate) ],
     );
     # @ISA setup is automatic
     # all assignments happen at compile time
  
  =head2 What Not to Export
  
  You have been warned already in L</Selecting What to Export>
  to not export:
  
  =over 4
  
  =item *
  
  method names (because you don't need to
  and that's likely to not do what you want),
  
  =item *
  
  anything by default (because you don't want to surprise your users...
  badly)
  
  =item *
  
  anything you don't need to (because less is more)
  
  =back
  
  There's one more item to add to this list.  Do B<not>
  export variable names.  Just because C<Exporter> lets you
  do that, it does not mean you should.
  
    @EXPORT_OK = qw($svar @avar %hvar); # DON'T!
  
  Exporting variables is not a good idea.  They can
  change under the hood, provoking horrible
  effects at-a-distance that are too hard to track
  and to fix.  Trust me: they are not worth it.
  
  To provide the capability to set/get class-wide
  settings, it is best instead to provide accessors
  as subroutines or class methods instead.
  
  =head1 SEE ALSO
  
  C<Exporter> is definitely not the only module with
  symbol exporter capabilities.  At CPAN, you may find
  a bunch of them.  Some are lighter.  Some
  provide improved APIs and features.  Pick the one
  that fits your needs.  The following is
  a sample list of such modules.
  
      Exporter::Easy
      Exporter::Lite
      Exporter::Renaming
      Exporter::Tidy
      Sub::Exporter / Sub::Installer
      Perl6::Export / Perl6::Export::Attrs
  
  =head1 LICENSE
  
  This library is free software.  You can redistribute it
  and/or modify it under the same terms as Perl itself.
  
  =cut
  
  
  
EXPORTER

$fatpacked{"Exporter/Heavy.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'EXPORTER_HEAVY';
  package Exporter::Heavy;
  
  use strict;
  no strict 'refs';
  
  # On one line so MakeMaker will see it.
  require Exporter;  our $VERSION = $Exporter::VERSION;
  
  =head1 NAME
  
  Exporter::Heavy - Exporter guts
  
  =head1 SYNOPSIS
  
  (internal use only)
  
  =head1 DESCRIPTION
  
  No user-serviceable parts inside.
  
  =cut
  
  #
  # We go to a lot of trouble not to 'require Carp' at file scope,
  #  because Carp requires Exporter, and something has to give.
  #
  
  sub _rebuild_cache {
      my ($pkg, $exports, $cache) = @_;
      s/^&// foreach @$exports;
      @{$cache}{@$exports} = (1) x @$exports;
      my $ok = \@{"${pkg}::EXPORT_OK"};
      if (@$ok) {
  	s/^&// foreach @$ok;
  	@{$cache}{@$ok} = (1) x @$ok;
      }
  }
  
  sub heavy_export {
  
      # Save the old __WARN__ handler in case it was defined
      my $oldwarn = $SIG{__WARN__};
  
      # First make import warnings look like they're coming from the "use".
      local $SIG{__WARN__} = sub {
  	# restore it back so proper stacking occurs
  	local $SIG{__WARN__} = $oldwarn;
  	my $text = shift;
  	if ($text =~ s/ at \S*Exporter\S*.pm line \d+.*\n//) {
  	    require Carp;
  	    local $Carp::CarpLevel = 1;	# ignore package calling us too.
  	    Carp::carp($text);
  	}
  	else {
  	    warn $text;
  	}
      };
      local $SIG{__DIE__} = sub {
  	require Carp;
  	local $Carp::CarpLevel = 1;	# ignore package calling us too.
  	Carp::croak("$_[0]Illegal null symbol in \@${1}::EXPORT")
  	    if $_[0] =~ /^Unable to create sub named "(.*?)::"/;
      };
  
      my($pkg, $callpkg, @imports) = @_;
      my($type, $sym, $cache_is_current, $oops);
      my($exports, $export_cache) = (\@{"${pkg}::EXPORT"},
                                     $Exporter::Cache{$pkg} ||= {});
  
      if (@imports) {
  	if (!%$export_cache) {
  	    _rebuild_cache ($pkg, $exports, $export_cache);
  	    $cache_is_current = 1;
  	}
  
  	if (grep m{^[/!:]}, @imports) {
  	    my $tagsref = \%{"${pkg}::EXPORT_TAGS"};
  	    my $tagdata;
  	    my %imports;
  	    my($remove, $spec, @names, @allexports);
  	    # negated first item implies starting with default set:
  	    unshift @imports, ':DEFAULT' if $imports[0] =~ m/^!/;
  	    foreach $spec (@imports){
  		$remove = $spec =~ s/^!//;
  
  		if ($spec =~ s/^://){
  		    if ($spec eq 'DEFAULT'){
  			@names = @$exports;
  		    }
  		    elsif ($tagdata = $tagsref->{$spec}) {
  			@names = @$tagdata;
  		    }
  		    else {
  			warn qq["$spec" is not defined in %${pkg}::EXPORT_TAGS];
  			++$oops;
  			next;
  		    }
  		}
  		elsif ($spec =~ m:^/(.*)/$:){
  		    my $patn = $1;
  		    @allexports = keys %$export_cache unless @allexports; # only do keys once
  		    @names = grep(/$patn/, @allexports); # not anchored by default
  		}
  		else {
  		    @names = ($spec); # is a normal symbol name
  		}
  
  		warn "Import ".($remove ? "del":"add").": @names "
  		    if $Exporter::Verbose;
  
  		if ($remove) {
  		   foreach $sym (@names) { delete $imports{$sym} } 
  		}
  		else {
  		    @imports{@names} = (1) x @names;
  		}
  	    }
  	    @imports = keys %imports;
  	}
  
          my @carp;
  	foreach $sym (@imports) {
  	    if (!$export_cache->{$sym}) {
  		if ($sym =~ m/^\d/) {
  		    $pkg->VERSION($sym); # inherit from UNIVERSAL
  		    # If the version number was the only thing specified
  		    # then we should act as if nothing was specified:
  		    if (@imports == 1) {
  			@imports = @$exports;
  			last;
  		    }
  		    # We need a way to emulate 'use Foo ()' but still
  		    # allow an easy version check: "use Foo 1.23, ''";
  		    if (@imports == 2 and !$imports[1]) {
  			@imports = ();
  			last;
  		    }
  		} elsif ($sym !~ s/^&// || !$export_cache->{$sym}) {
  		    # Last chance - see if they've updated EXPORT_OK since we
  		    # cached it.
  
  		    unless ($cache_is_current) {
  			%$export_cache = ();
  			_rebuild_cache ($pkg, $exports, $export_cache);
  			$cache_is_current = 1;
  		    }
  
  		    if (!$export_cache->{$sym}) {
  			# accumulate the non-exports
  			push @carp,
  			  qq["$sym" is not exported by the $pkg module\n];
  			$oops++;
  		    }
  		}
  	    }
  	}
  	if ($oops) {
  	    require Carp;
  	    Carp::croak("@{carp}Can't continue after import errors");
  	}
      }
      else {
  	@imports = @$exports;
      }
  
      my($fail, $fail_cache) = (\@{"${pkg}::EXPORT_FAIL"},
                                $Exporter::FailCache{$pkg} ||= {});
  
      if (@$fail) {
  	if (!%$fail_cache) {
  	    # Build cache of symbols. Optimise the lookup by adding
  	    # barewords twice... both with and without a leading &.
  	    # (Technique could be applied to $export_cache at cost of memory)
  	    my @expanded = map { /^\w/ ? ($_, '&'.$_) : $_ } @$fail;
  	    warn "${pkg}::EXPORT_FAIL cached: @expanded" if $Exporter::Verbose;
  	    @{$fail_cache}{@expanded} = (1) x @expanded;
  	}
  	my @failed;
  	foreach $sym (@imports) { push(@failed, $sym) if $fail_cache->{$sym} }
  	if (@failed) {
  	    @failed = $pkg->export_fail(@failed);
  	    foreach $sym (@failed) {
                  require Carp;
  		Carp::carp(qq["$sym" is not implemented by the $pkg module ],
  			"on this architecture");
  	    }
  	    if (@failed) {
  		require Carp;
  		Carp::croak("Can't continue after import errors");
  	    }
  	}
      }
  
      warn "Importing into $callpkg from $pkg: ",
  		join(", ",sort @imports) if $Exporter::Verbose;
  
      foreach $sym (@imports) {
  	# shortcut for the common case of no type character
  	(*{"${callpkg}::$sym"} = \&{"${pkg}::$sym"}, next)
  	    unless $sym =~ s/^(\W)//;
  	$type = $1;
  	no warnings 'once';
  	*{"${callpkg}::$sym"} =
  	    $type eq '&' ? \&{"${pkg}::$sym"} :
  	    $type eq '$' ? \${"${pkg}::$sym"} :
  	    $type eq '@' ? \@{"${pkg}::$sym"} :
  	    $type eq '%' ? \%{"${pkg}::$sym"} :
  	    $type eq '*' ?  *{"${pkg}::$sym"} :
  	    do { require Carp; Carp::croak("Can't export symbol: $type$sym") };
      }
  }
  
  sub heavy_export_to_level
  {
        my $pkg = shift;
        my $level = shift;
        (undef) = shift;			# XXX redundant arg
        my $callpkg = caller($level);
        $pkg->export($callpkg, @_);
  }
  
  # Utility functions
  
  sub _push_tags {
      my($pkg, $var, $syms) = @_;
      my @nontag = ();
      my $export_tags = \%{"${pkg}::EXPORT_TAGS"};
      push(@{"${pkg}::$var"},
  	map { $export_tags->{$_} ? @{$export_tags->{$_}} 
                                   : scalar(push(@nontag,$_),$_) }
  		(@$syms) ? @$syms : keys %$export_tags);
      if (@nontag and $^W) {
  	# This may change to a die one day
  	require Carp;
  	Carp::carp(join(", ", @nontag)." are not tags of $pkg");
      }
  }
  
  sub heavy_require_version {
      my($self, $wanted) = @_;
      my $pkg = ref $self || $self;
      return ${pkg}->VERSION($wanted);
  }
  
  sub heavy_export_tags {
    _push_tags((caller)[0], "EXPORT",    \@_);
  }
  
  sub heavy_export_ok_tags {
    _push_tags((caller)[0], "EXPORT_OK", \@_);
  }
  
  1;
EXPORTER_HEAVY

$fatpacked{"File/Fetch.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'FILE_FETCH';
  package File::Fetch;
  
  use strict;
  use FileHandle;
  use File::Temp;
  use File::Copy;
  use File::Spec;
  use File::Spec::Unix;
  use File::Basename              qw[dirname];
  
  use Cwd                         qw[cwd];
  use Carp                        qw[carp];
  use IPC::Cmd                    qw[can_run run QUOTE];
  use File::Path                  qw[mkpath];
  use File::Temp                  qw[tempdir];
  use Params::Check               qw[check];
  use Module::Load::Conditional   qw[can_load];
  use Locale::Maketext::Simple    Style => 'gettext';
  
  use vars    qw[ $VERBOSE $PREFER_BIN $FROM_EMAIL $USER_AGENT
                  $BLACKLIST $METHOD_FAIL $VERSION $METHODS
                  $FTP_PASSIVE $TIMEOUT $DEBUG $WARN $FORCEIPV4
              ];
  
  $VERSION        = '0.56';
  $VERSION        = eval $VERSION;    # avoid warnings with development releases
  $PREFER_BIN     = 0;                # XXX TODO implement
  $FROM_EMAIL     = 'File-Fetch@example.com';
  $USER_AGENT     = "File::Fetch/$VERSION";
  $BLACKLIST      = [qw|ftp|];
  push @$BLACKLIST, qw|lftp| if $^O eq 'dragonfly' || $^O eq 'hpux';
  $METHOD_FAIL    = { };
  $FTP_PASSIVE    = 1;
  $TIMEOUT        = 0;
  $DEBUG          = 0;
  $WARN           = 1;
  $FORCEIPV4      = 0;
  
  ### methods available to fetch the file depending on the scheme
  $METHODS = {
      http    => [ qw|lwp httptiny wget curl lftp fetch httplite lynx iosock| ],
      https   => [ qw|lwp wget curl| ],
      ftp     => [ qw|lwp netftp wget curl lftp fetch ncftp ftp| ],
      file    => [ qw|lwp lftp file| ],
      rsync   => [ qw|rsync| ],
      git     => [ qw|git| ],
  };
  
  ### silly warnings ###
  local $Params::Check::VERBOSE               = 1;
  local $Params::Check::VERBOSE               = 1;
  local $Module::Load::Conditional::VERBOSE   = 0;
  local $Module::Load::Conditional::VERBOSE   = 0;
  
  ### Fix CVE-2016-1238 ###
  local $Module::Load::Conditional::FORCE_SAFE_INC = 1;
  
  ### see what OS we are on, important for file:// uris ###
  use constant ON_WIN     => ($^O eq 'MSWin32');
  use constant ON_VMS     => ($^O eq 'VMS');
  use constant ON_UNIX    => (!ON_WIN);
  use constant HAS_VOL    => (ON_WIN);
  use constant HAS_SHARE  => (ON_WIN);
  use constant HAS_FETCH  => ( $^O =~ m!^(freebsd|netbsd|dragonfly)$! );
  
  =pod
  
  =head1 NAME
  
  File::Fetch - A generic file fetching mechanism
  
  =head1 SYNOPSIS
  
      use File::Fetch;
  
      ### build a File::Fetch object ###
      my $ff = File::Fetch->new(uri => 'http://some.where.com/dir/a.txt');
  
      ### fetch the uri to cwd() ###
      my $where = $ff->fetch() or die $ff->error;
  
      ### fetch the uri to /tmp ###
      my $where = $ff->fetch( to => '/tmp' );
  
      ### parsed bits from the uri ###
      $ff->uri;
      $ff->scheme;
      $ff->host;
      $ff->path;
      $ff->file;
  
  =head1 DESCRIPTION
  
  File::Fetch is a generic file fetching mechanism.
  
  It allows you to fetch any file pointed to by a C<ftp>, C<http>,
  C<file>, C<git> or C<rsync> uri by a number of different means.
  
  See the C<HOW IT WORKS> section further down for details.
  
  =head1 ACCESSORS
  
  A C<File::Fetch> object has the following accessors
  
  =over 4
  
  =item $ff->uri
  
  The uri you passed to the constructor
  
  =item $ff->scheme
  
  The scheme from the uri (like 'file', 'http', etc)
  
  =item $ff->host
  
  The hostname in the uri.  Will be empty if host was originally
  'localhost' for a 'file://' url.
  
  =item $ff->vol
  
  On operating systems with the concept of a volume the second element
  of a file:// is considered to the be volume specification for the file.
  Thus on Win32 this routine returns the volume, on other operating
  systems this returns nothing.
  
  On Windows this value may be empty if the uri is to a network share, in
  which case the 'share' property will be defined. Additionally, volume
  specifications that use '|' as ':' will be converted on read to use ':'.
  
  On VMS, which has a volume concept, this field will be empty because VMS
  file specifications are converted to absolute UNIX format and the volume
  information is transparently included.
  
  =item $ff->share
  
  On systems with the concept of a network share (currently only Windows) returns
  the sharename from a file://// url.  On other operating systems returns empty.
  
  =item $ff->path
  
  The path from the uri, will be at least a single '/'.
  
  =item $ff->file
  
  The name of the remote file. For the local file name, the
  result of $ff->output_file will be used.
  
  =item $ff->file_default
  
  The name of the default local file, that $ff->output_file falls back to if
  it would otherwise return no filename. For example when fetching a URI like
  http://www.abc.net.au/ the contents retrieved may be from a remote file called
  'index.html'. The default value of this attribute is literally 'file_default'.
  
  =cut
  
  
  ##########################
  ### Object & Accessors ###
  ##########################
  
  {
      ### template for autogenerated accessors ###
      my $Tmpl = {
          scheme          => { default => 'http' },
          host            => { default => 'localhost' },
          path            => { default => '/' },
          file            => { required => 1 },
          uri             => { required => 1 },
          userinfo        => { default => '' },
          vol             => { default => '' }, # windows for file:// uris
          share           => { default => '' }, # windows for file:// uris
          file_default    => { default => 'file_default' },
          tempdir_root    => { required => 1 }, # Should be lazy-set at ->new()
          _error_msg      => { no_override => 1 },
          _error_msg_long => { no_override => 1 },
      };
  
      for my $method ( keys %$Tmpl ) {
          no strict 'refs';
          *$method = sub {
                          my $self = shift;
                          $self->{$method} = $_[0] if @_;
                          return $self->{$method};
                      }
      }
  
      sub _create {
          my $class = shift;
          my %hash  = @_;
  
          my $args = check( $Tmpl, \%hash ) or return;
  
          bless $args, $class;
  
          if( lc($args->scheme) ne 'file' and not $args->host ) {
              return $class->_error(loc(
                  "Hostname required when fetching from '%1'",$args->scheme));
          }
  
          for (qw[path]) {
              unless( $args->$_() ) { # 5.5.x needs the ()
                  return $class->_error(loc("No '%1' specified",$_));
              }
          }
  
          return $args;
      }
  }
  
  =item $ff->output_file
  
  The name of the output file. This is the same as $ff->file,
  but any query parameters are stripped off. For example:
  
      http://example.com/index.html?x=y
  
  would make the output file be C<index.html> rather than
  C<index.html?x=y>.
  
  =back
  
  =cut
  
  sub output_file {
      my $self = shift;
      my $file = $self->file;
  
      $file =~ s/\?.*$//g;
  
      $file ||= $self->file_default;
  
      return $file;
  }
  
  ### XXX do this or just point to URI::Escape?
  # =head2 $esc_uri = $ff->escaped_uri
  #
  # =cut
  #
  # ### most of this is stolen straight from URI::escape
  # {   ### Build a char->hex map
  #     my %escapes = map { chr($_) => sprintf("%%%02X", $_) } 0..255;
  #
  #     sub escaped_uri {
  #         my $self = shift;
  #         my $uri  = $self->uri;
  #
  #         ### Default unsafe characters.  RFC 2732 ^(uric - reserved)
  #         $uri =~ s/([^A-Za-z0-9\-_.!~*'()])/
  #                     $escapes{$1} || $self->_fail_hi($1)/ge;
  #
  #         return $uri;
  #     }
  #
  #     sub _fail_hi {
  #         my $self = shift;
  #         my $char = shift;
  #
  #         $self->_error(loc(
  #             "Can't escape '%1', try using the '%2' module instead",
  #             sprintf("\\x{%04X}", ord($char)), 'URI::Escape'
  #         ));
  #     }
  #
  #     sub output_file {
  #
  #     }
  #
  #
  # }
  
  =head1 METHODS
  
  =head2 $ff = File::Fetch->new( uri => 'http://some.where.com/dir/file.txt' );
  
  Parses the uri and creates a corresponding File::Fetch::Item object,
  that is ready to be C<fetch>ed and returns it.
  
  Returns false on failure.
  
  =cut
  
  sub new {
      my $class = shift;
      my %hash  = @_;
  
      my ($uri, $file_default, $tempdir_root);
      my $tmpl = {
          uri          => { required => 1, store => \$uri },
          file_default => { required => 0, store => \$file_default },
          tempdir_root => { required => 0, store => \$tempdir_root },
      };
  
      check( $tmpl, \%hash ) or return;
  
      ### parse the uri to usable parts ###
      my $href    = $class->_parse_uri( $uri ) or return;
  
      $href->{file_default} = $file_default if $file_default;
      $href->{tempdir_root} = File::Spec->rel2abs( $tempdir_root ) if $tempdir_root;
      $href->{tempdir_root} = File::Spec->rel2abs( Cwd::cwd      ) if not $href->{tempdir_root};
  
      ### make it into a FFI object ###
      my $ff      = $class->_create( %$href ) or return;
  
  
      ### return the object ###
      return $ff;
  }
  
  ### parses an uri to a hash structure:
  ###
  ### $class->_parse_uri( 'ftp://ftp.cpan.org/pub/mirror/index.txt' )
  ###
  ### becomes:
  ###
  ### $href = {
  ###     scheme  => 'ftp',
  ###     host    => 'ftp.cpan.org',
  ###     path    => '/pub/mirror',
  ###     file    => 'index.html'
  ### };
  ###
  ### In the case of file:// urls there maybe be additional fields
  ###
  ### For systems with volume specifications such as Win32 there will be
  ### a volume specifier provided in the 'vol' field.
  ###
  ###   'vol' => 'volumename'
  ###
  ### For windows file shares there may be a 'share' key specified
  ###
  ###   'share' => 'sharename'
  ###
  ### Note that the rules of what a file:// url means vary by the operating system
  ### of the host being addressed. Thus file:///d|/foo/bar.txt means the obvious
  ### 'D:\foo\bar.txt' on windows, but on unix it means '/d|/foo/bar.txt' and
  ### not '/foo/bar.txt'
  ###
  ### Similarly if the host interpreting the url is VMS then
  ### file:///disk$user/my/notes/note12345.txt' means
  ### 'DISK$USER:[MY.NOTES]NOTE123456.TXT' but will be returned the same as
  ### if it is unix where it means /disk$user/my/notes/note12345.txt'.
  ### Except for some cases in the File::Spec methods, Perl on VMS will generally
  ### handle UNIX format file specifications.
  ###
  ### This means it is impossible to serve certain file:// urls on certain systems.
  ###
  ### Thus are the problems with a protocol-less specification. :-(
  ###
  
  sub _parse_uri {
      my $self = shift;
      my $uri  = shift or return;
  
      my $href = { uri => $uri };
  
      ### find the scheme ###
      $uri            =~ s|^(\w+)://||;
      $href->{scheme} = $1;
  
      ### See rfc 1738 section 3.10
      ### http://www.faqs.org/rfcs/rfc1738.html
      ### And wikipedia for more on windows file:// urls
      ### http://en.wikipedia.org/wiki/File://
      if( $href->{scheme} eq 'file' ) {
  
          my @parts = split '/',$uri;
  
          ### file://hostname/...
          ### file://hostname/...
          ### normalize file://localhost with file:///
          $href->{host} = $parts[0] || '';
  
          ### index in @parts where the path components begin;
          my $index = 1;
  
          ### file:////hostname/sharename/blah.txt
          if ( HAS_SHARE and not length $parts[0] and not length $parts[1] ) {
  
              $href->{host}   = $parts[2] || '';  # avoid warnings
              $href->{share}  = $parts[3] || '';  # avoid warnings
  
              $index          = 4         # index after the share
  
          ### file:///D|/blah.txt
          ### file:///D:/blah.txt
          } elsif (HAS_VOL) {
  
              ### this code comes from dmq's patch, but:
              ### XXX if volume is empty, wouldn't that be an error? --kane
              ### if so, our file://localhost test needs to be fixed as wel
              $href->{vol}    = $parts[1] || '';
  
              ### correct D| style colume descriptors
              $href->{vol}    =~ s/\A([A-Z])\|\z/$1:/i if ON_WIN;
  
              $index          = 2;        # index after the volume
          }
  
          ### rebuild the path from the leftover parts;
          $href->{path} = join '/', '', splice( @parts, $index, $#parts );
  
      } else {
          ### using anything but qw() in hash slices may produce warnings
          ### in older perls :-(
          @{$href}{ qw(userinfo host path) } = $uri =~ m|(?:([^\@:]*:[^\:\@]*)@)?([^/]*)(/.*)$|s;
      }
  
      ### split the path into file + dir ###
      {   my @parts = File::Spec::Unix->splitpath( delete $href->{path} );
          $href->{path} = $parts[1];
          $href->{file} = $parts[2];
      }
  
      ### host will be empty if the target was 'localhost' and the
      ### scheme was 'file'
      $href->{host} = '' if   ($href->{host}      eq 'localhost') and
                              ($href->{scheme}    eq 'file');
  
      return $href;
  }
  
  =head2 $where = $ff->fetch( [to => /my/output/dir/ | \$scalar] )
  
  Fetches the file you requested and returns the full path to the file.
  
  By default it writes to C<cwd()>, but you can override that by specifying
  the C<to> argument:
  
      ### file fetch to /tmp, full path to the file in $where
      $where = $ff->fetch( to => '/tmp' );
  
      ### file slurped into $scalar, full path to the file in $where
      ### file is downloaded to a temp directory and cleaned up at exit time
      $where = $ff->fetch( to => \$scalar );
  
  Returns the full path to the downloaded file on success, and false
  on failure.
  
  =cut
  
  sub fetch {
      my $self = shift or return;
      my %hash = @_;
  
      my $target;
      my $tmpl = {
          to  => { default => cwd(), store => \$target },
      };
  
      check( $tmpl, \%hash ) or return;
  
      my ($to, $fh);
      ### you want us to slurp the contents
      if( ref $target and UNIVERSAL::isa( $target, 'SCALAR' ) ) {
          $to = tempdir( 'FileFetch.XXXXXX', DIR => $self->tempdir_root, CLEANUP => 1 );
  
      ### plain old fetch
      } else {
          $to = $target;
  
          ### On VMS force to VMS format so File::Spec will work.
          $to = VMS::Filespec::vmspath($to) if ON_VMS;
  
          ### create the path if it doesn't exist yet ###
          unless( -d $to ) {
              eval { mkpath( $to ) };
  
              return $self->_error(loc("Could not create path '%1'",$to)) if $@;
          }
      }
  
      ### set passive ftp if required ###
      local $ENV{FTP_PASSIVE} = $FTP_PASSIVE;
  
      ### we dont use catfile on win32 because if we are using a cygwin tool
      ### under cmd.exe they wont understand windows style separators.
      my $out_to = ON_WIN ? $to.'/'.$self->output_file
                          : File::Spec->catfile( $to, $self->output_file );
  
      for my $method ( @{ $METHODS->{$self->scheme} } ) {
          my $sub =  '_'.$method.'_fetch';
  
          unless( __PACKAGE__->can($sub) ) {
              $self->_error(loc("Cannot call method for '%1' -- WEIRD!",
                          $method));
              next;
          }
  
          ### method is blacklisted ###
          next if grep { lc $_ eq $method } @$BLACKLIST;
  
          ### method is known to fail ###
          next if $METHOD_FAIL->{$method};
  
          ### there's serious issues with IPC::Run and quoting of command
          ### line arguments. using quotes in the wrong place breaks things,
          ### and in the case of say,
          ### C:\cygwin\bin\wget.EXE --quiet --passive-ftp --output-document
          ### "index.html" "http://www.cpan.org/index.html?q=1&y=2"
          ### it doesn't matter how you quote, it always fails.
          local $IPC::Cmd::USE_IPC_RUN = 0;
  
          if( my $file = $self->$sub(
                          to => $out_to
          )){
  
              unless( -e $file && -s _ ) {
                  $self->_error(loc("'%1' said it fetched '%2', ".
                       "but it was not created",$method,$file));
  
                  ### mark the failure ###
                  $METHOD_FAIL->{$method} = 1;
  
                  next;
  
              } else {
  
                  ### slurp mode?
                  if( ref $target and UNIVERSAL::isa( $target, 'SCALAR' ) ) {
  
                      ### open the file
                      open my $fh, "<$file" or do {
                          $self->_error(
                              loc("Could not open '%1': %2", $file, $!));
                          return;
                      };
  
                      ### slurp
                      $$target = do { local $/; <$fh> };
  
                  }
  
                  my $abs = File::Spec->rel2abs( $file );
                  return $abs;
  
              }
          }
      }
  
  
      ### if we got here, we looped over all methods, but we weren't able
      ### to fetch it.
      return;
  }
  
  ########################
  ### _*_fetch methods ###
  ########################
  
  ### LWP fetching ###
  sub _lwp_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### modules required to download with lwp ###
      my $use_list = {
          LWP                 => '0.0',
          'LWP::UserAgent'    => '0.0',
          'HTTP::Request'     => '0.0',
          'HTTP::Status'      => '0.0',
          URI                 => '0.0',
  
      };
  
      if ($self->scheme eq 'https') {
          $use_list->{'LWP::Protocol::https'} = '0';
      }
  
      unless( can_load( modules => $use_list ) ) {
          $METHOD_FAIL->{'lwp'} = 1;
          return;
      }
  
      ### setup the uri object
      my $uri = URI->new( File::Spec::Unix->catfile(
                                  $self->path, $self->file
                      ) );
  
      ### special rules apply for file:// uris ###
      $uri->scheme( $self->scheme );
      $uri->host( $self->scheme eq 'file' ? '' : $self->host );
  
      if ($self->userinfo) {
          $uri->userinfo($self->userinfo);
      } elsif ($self->scheme ne 'file') {
          $uri->userinfo("anonymous:$FROM_EMAIL");
      }
  
      ### set up the useragent object
      my $ua = LWP::UserAgent->new();
      $ua->timeout( $TIMEOUT ) if $TIMEOUT;
      $ua->agent( $USER_AGENT );
      $ua->from( $FROM_EMAIL );
      $ua->env_proxy;
  
      my $res = $ua->mirror($uri, $to) or return;
  
      ### uptodate or fetched ok ###
      if ( $res->code == 304 or $res->code == 200 ) {
          return $to;
  
      } else {
          return $self->_error(loc("Fetch failed! HTTP response: %1 %2 [%3]",
                      $res->code, HTTP::Status::status_message($res->code),
                      $res->status_line));
      }
  
  }
  
  ### HTTP::Tiny fetching ###
  sub _httptiny_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      my $use_list = {
          'HTTP::Tiny'    => '0.008',
  
      };
  
      unless( can_load(modules => $use_list) ) {
          $METHOD_FAIL->{'httptiny'} = 1;
          return;
      }
  
      my $uri = $self->uri;
  
      my $http = HTTP::Tiny->new( ( $TIMEOUT ? ( timeout => $TIMEOUT ) : () ) );
  
      my $rc = $http->mirror( $uri, $to );
  
      unless ( $rc->{success} ) {
  
          return $self->_error(loc( "Fetch failed! HTTP response: %1 [%2]",
                      $rc->{status}, $rc->{reason} ) );
  
      }
  
      return $to;
  
  }
  
  ### HTTP::Lite fetching ###
  sub _httplite_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### modules required to download with lwp ###
      my $use_list = {
          'HTTP::Lite'    => '2.2',
          'MIME::Base64'  => '0',
      };
  
      unless( can_load(modules => $use_list) ) {
          $METHOD_FAIL->{'httplite'} = 1;
          return;
      }
  
      my $uri = $self->uri;
      my $retries = 0;
  
      RETRIES: while ( $retries++ < 5 ) {
  
        my $http = HTTP::Lite->new();
        # Naughty naughty but there isn't any accessor/setter
        $http->{timeout} = $TIMEOUT if $TIMEOUT;
        $http->http11_mode(1);
  
        if ($self->userinfo) {
            my $encoded = MIME::Base64::encode($self->userinfo, '');
            $http->add_req_header("Authorization", "Basic $encoded");
        }
  
        my $fh = FileHandle->new;
  
        unless ( $fh->open($to,'>') ) {
          return $self->_error(loc(
               "Could not open '%1' for writing: %2",$to,$!));
        }
  
        $fh->autoflush(1);
  
        binmode $fh;
  
        my $rc = $http->request( $uri, sub { my ($self,$dref,$cbargs) = @_; local $\; print {$cbargs} $$dref }, $fh );
  
        close $fh;
  
        if ( $rc == 301 || $rc == 302 ) {
            my $loc;
            HEADERS: for ($http->headers_array) {
              /Location: (\S+)/ and $loc = $1, last HEADERS;
            }
            #$loc or last; # Think we should squeal here.
            if ($loc =~ m!^/!) {
              $uri =~ s{^(\w+?://[^/]+)/.*$}{$1};
              $uri .= $loc;
            }
            else {
              $uri = $loc;
            }
            next RETRIES;
        }
        elsif ( $rc == 200 ) {
            return $to;
        }
        else {
          return $self->_error(loc("Fetch failed! HTTP response: %1 [%2]",
                      $rc, $http->status_message));
        }
  
      } # Loop for 5 retries.
  
      return $self->_error("Fetch failed! Gave up after 5 tries");
  
  }
  
  ### Simple IO::Socket::INET fetching ###
  sub _iosock_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      my $use_list = {
          'IO::Socket::INET' => '0.0',
          'IO::Select'       => '0.0',
      };
  
      unless( can_load(modules => $use_list) ) {
          $METHOD_FAIL->{'iosock'} = 1;
          return;
      }
  
      my $sock = IO::Socket::INET->new(
          PeerHost => $self->host,
          ( $self->host =~ /:/ ? () : ( PeerPort => 80 ) ),
      );
  
      unless ( $sock ) {
          return $self->_error(loc("Could not open socket to '%1', '%2'",$self->host,$!));
      }
  
      my $fh = FileHandle->new;
  
      # Check open()
  
      unless ( $fh->open($to,'>') ) {
          return $self->_error(loc(
               "Could not open '%1' for writing: %2",$to,$!));
      }
  
      $fh->autoflush(1);
      binmode $fh;
  
      my $path = File::Spec::Unix->catfile( $self->path, $self->file );
      my $req = "GET $path HTTP/1.0\x0d\x0aHost: " . $self->host . "\x0d\x0a\x0d\x0a";
      $sock->send( $req );
  
      my $select = IO::Select->new( $sock );
  
      my $resp = '';
      my $normal = 0;
      while ( $select->can_read( $TIMEOUT || 60 ) ) {
        my $ret = $sock->sysread( $resp, 4096, length($resp) );
        if ( !defined $ret or $ret == 0 ) {
          $select->remove( $sock );
          $normal++;
        }
      }
      close $sock;
  
      unless ( $normal ) {
          return $self->_error(loc("Socket timed out after '%1' seconds", ( $TIMEOUT || 60 )));
      }
  
      # Check the "response"
      # Strip preceding blank lines apparently they are allowed (RFC 2616 4.1)
      $resp =~ s/^(\x0d?\x0a)+//;
      # Check it is an HTTP response
      unless ( $resp =~ m!^HTTP/(\d+)\.(\d+)!i ) {
          return $self->_error(loc("Did not get a HTTP response from '%1'",$self->host));
      }
  
      # Check for OK
      my ($code) = $resp =~ m!^HTTP/\d+\.\d+\s+(\d+)!i;
      unless ( $code eq '200' ) {
          return $self->_error(loc("Got a '%1' from '%2' expected '200'",$code,$self->host));
      }
  
      {
        local $\;
        print $fh +($resp =~ m/\x0d\x0a\x0d\x0a(.*)$/s )[0];
      }
      close $fh;
      return $to;
  }
  
  ### Net::FTP fetching
  sub _netftp_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### required modules ###
      my $use_list = { 'Net::FTP' => 0 };
  
      unless( can_load( modules => $use_list ) ) {
          $METHOD_FAIL->{'netftp'} = 1;
          return;
      }
  
      ### make connection ###
      my $ftp;
      my @options = ($self->host);
      push(@options, Timeout => $TIMEOUT) if $TIMEOUT;
      unless( $ftp = Net::FTP->new( @options ) ) {
          return $self->_error(loc("Ftp creation failed: %1",$@));
      }
  
      ### login ###
      unless( $ftp->login( anonymous => $FROM_EMAIL ) ) {
          return $self->_error(loc("Could not login to '%1'",$self->host));
      }
  
      ### set binary mode, just in case ###
      $ftp->binary;
  
      ### create the remote path
      ### remember remote paths are unix paths! [#11483]
      my $remote = File::Spec::Unix->catfile( $self->path, $self->file );
  
      ### fetch the file ###
      my $target;
      unless( $target = $ftp->get( $remote, $to ) ) {
          return $self->_error(loc("Could not fetch '%1' from '%2'",
                      $remote, $self->host));
      }
  
      ### log out ###
      $ftp->quit;
  
      return $target;
  
  }
  
  ### /bin/wget fetch ###
  sub _wget_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      my $wget;
      ### see if we have a wget binary ###
      unless( $wget = can_run('wget') ) {
          $METHOD_FAIL->{'wget'} = 1;
          return;
      }
  
      ### no verboseness, thanks ###
      my $cmd = [ $wget, '--quiet' ];
  
      ### if a timeout is set, add it ###
      push(@$cmd, '--timeout=' . $TIMEOUT) if $TIMEOUT;
  
      ### run passive if specified ###
      push @$cmd, '--passive-ftp' if $FTP_PASSIVE;
  
      ### set the output document, add the uri ###
      push @$cmd, '--output-document', $to, $self->uri;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
      ### shell out ###
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG
      )) {
          ### wget creates the output document always, even if the fetch
          ### fails.. so unlink it in that case
          1 while unlink $to;
  
          return $self->_error(loc( "Command failed: %1", $captured || '' ));
      }
  
      return $to;
  }
  
  ### /bin/lftp fetch ###
  sub _lftp_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### see if we have a lftp binary ###
      my $lftp;
      unless( $lftp = can_run('lftp') ) {
          $METHOD_FAIL->{'lftp'} = 1;
          return;
      }
  
      ### no verboseness, thanks ###
      my $cmd = [ $lftp, '-f' ];
  
      my $fh = File::Temp->new;
  
      my $str;
  
      ### if a timeout is set, add it ###
      $str .= "set net:timeout $TIMEOUT;\n" if $TIMEOUT;
  
      ### run passive if specified ###
      $str .= "set ftp:passive-mode 1;\n" if $FTP_PASSIVE;
  
      ### set the output document, add the uri ###
      ### quote the URI, because lftp supports certain shell
      ### expansions, most notably & for backgrounding.
      ### ' quote does nto work, must be "
      $str .= q[get ']. $self->uri .q[' -o ]. $to . $/;
  
      if( $DEBUG ) {
          my $pp_str = join ' ', split $/, $str;
          print "# lftp command: $pp_str\n";
      }
  
      ### write straight to the file.
      $fh->autoflush(1);
      print $fh $str;
  
      ### the command needs to be 1 string to be executed
      push @$cmd, $fh->filename;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
  
      ### shell out ###
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG
      )) {
          ### wget creates the output document always, even if the fetch
          ### fails.. so unlink it in that case
          1 while unlink $to;
  
          return $self->_error(loc( "Command failed: %1", $captured || '' ));
      }
  
      return $to;
  }
  
  
  
  ### /bin/ftp fetch ###
  sub _ftp_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### see if we have a ftp binary ###
      my $ftp;
      unless( $ftp = can_run('ftp') ) {
          $METHOD_FAIL->{'ftp'} = 1;
          return;
      }
  
      my $fh = FileHandle->new;
  
      local $SIG{CHLD} = 'IGNORE';
  
      unless ($fh->open("$ftp -n", '|-')) {
          return $self->_error(loc("%1 creation failed: %2", $ftp, $!));
      }
  
      my @dialog = (
          "lcd " . dirname($to),
          "open " . $self->host,
          "user anonymous $FROM_EMAIL",
          "cd /",
          "cd " . $self->path,
          "binary",
          "get " . $self->file . " " . $self->output_file,
          "quit",
      );
  
      foreach (@dialog) { $fh->print($_, "\n") }
      $fh->close or return;
  
      return $to;
  }
  
  ### lynx is stupid - it decompresses any .gz file it finds to be text
  ### use /bin/lynx to fetch files
  sub _lynx_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### see if we have a lynx binary ###
      my $lynx;
      unless ( $lynx = can_run('lynx') ){
          $METHOD_FAIL->{'lynx'} = 1;
          return;
      }
  
      unless( IPC::Cmd->can_capture_buffer ) {
          $METHOD_FAIL->{'lynx'} = 1;
  
          return $self->_error(loc(
              "Can not capture buffers. Can not use '%1' to fetch files",
              'lynx' ));
      }
  
      ### check if the HTTP resource exists ###
      if ($self->uri =~ /^https?:\/\//i) {
          my $cmd = [
              $lynx,
              '-head',
              '-source',
              "-auth=anonymous:$FROM_EMAIL",
          ];
  
          push @$cmd, "-connect_timeout=$TIMEOUT" if $TIMEOUT;
  
          push @$cmd, $self->uri;
  
          ### shell out ###
          my $head;
          unless(run( command => $cmd,
                      buffer  => \$head,
                      verbose => $DEBUG )
          ) {
              return $self->_error(loc("Command failed: %1", $head || ''));
          }
  
          unless($head =~ /^HTTP\/\d+\.\d+ 200\b/) {
              return $self->_error(loc("Command failed: %1", $head || ''));
          }
      }
  
      ### write to the output file ourselves, since lynx ass_u_mes to much
      my $local = FileHandle->new( $to, 'w' )
                      or return $self->_error(loc(
                          "Could not open '%1' for writing: %2",$to,$!));
  
      ### dump to stdout ###
      my $cmd = [
          $lynx,
          '-source',
          "-auth=anonymous:$FROM_EMAIL",
      ];
  
      push @$cmd, "-connect_timeout=$TIMEOUT" if $TIMEOUT;
  
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      push @$cmd, $self->uri;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? $self->uri
      #    : QUOTE. $self->uri .QUOTE;
  
  
      ### shell out ###
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG )
      ) {
          return $self->_error(loc("Command failed: %1", $captured || ''));
      }
  
      ### print to local file ###
      ### XXX on a 404 with a special error page, $captured will actually
      ### hold the contents of that page, and make it *appear* like the
      ### request was a success, when really it wasn't :(
      ### there doesn't seem to be an option for lynx to change the exit
      ### code based on a 4XX status or so.
      ### the closest we can come is using --error_file and parsing that,
      ### which is very unreliable ;(
      $local->print( $captured );
      $local->close or return;
  
      return $to;
  }
  
  ### use /bin/ncftp to fetch files
  sub _ncftp_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### we can only set passive mode in interactive sessions, so bail out
      ### if $FTP_PASSIVE is set
      return if $FTP_PASSIVE;
  
      ### see if we have a ncftp binary ###
      my $ncftp;
      unless( $ncftp = can_run('ncftp') ) {
          $METHOD_FAIL->{'ncftp'} = 1;
          return;
      }
  
      my $cmd = [
          $ncftp,
          '-V',                   # do not be verbose
          '-p', $FROM_EMAIL,      # email as password
          $self->host,            # hostname
          dirname($to),           # local dir for the file
                                  # remote path to the file
          ### DO NOT quote things for IPC::Run, it breaks stuff.
          $IPC::Cmd::USE_IPC_RUN
                      ? File::Spec::Unix->catdir( $self->path, $self->file )
                      : QUOTE. File::Spec::Unix->catdir(
                                      $self->path, $self->file ) .QUOTE
  
      ];
  
      ### shell out ###
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG )
      ) {
          return $self->_error(loc("Command failed: %1", $captured || ''));
      }
  
      return $to;
  
  }
  
  ### use /bin/curl to fetch files
  sub _curl_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
      my $curl;
      unless ( $curl = can_run('curl') ) {
          $METHOD_FAIL->{'curl'} = 1;
          return;
      }
  
      ### these long opts are self explanatory - I like that -jmb
      my $cmd = [ $curl, '-q' ];
  
      push(@$cmd, '-4') if $^O eq 'netbsd' && $FORCEIPV4; # only seen this on NetBSD so far
  
      push(@$cmd, '--connect-timeout', $TIMEOUT) if $TIMEOUT;
  
      push(@$cmd, '--silent') unless $DEBUG;
  
      ### curl does the right thing with passive, regardless ###
      if ($self->scheme eq 'ftp') {
          push(@$cmd, '--user', "anonymous:$FROM_EMAIL");
      }
  
      ### curl doesn't follow 302 (temporarily moved) etc automatically
      ### so we add --location to enable that.
      push @$cmd, '--fail', '--location', '--output', $to, $self->uri;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
  
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG )
      ) {
  
          return $self->_error(loc("Command failed: %1", $captured || ''));
      }
  
      return $to;
  
  }
  
  ### /usr/bin/fetch fetch! ###
  sub _fetch_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
      ### see if we have a fetch binary ###
      my $fetch;
      unless( HAS_FETCH and $fetch = can_run('fetch') ) {
          $METHOD_FAIL->{'fetch'} = 1;
          return;
      }
  
      ### no verboseness, thanks ###
      my $cmd = [ $fetch, '-q' ];
  
      ### if a timeout is set, add it ###
      push(@$cmd, '-T', $TIMEOUT) if $TIMEOUT;
  
      ### run passive if specified ###
      #push @$cmd, '-p' if $FTP_PASSIVE;
      local $ENV{'FTP_PASSIVE_MODE'} = 1 if $FTP_PASSIVE;
  
      ### set the output document, add the uri ###
      push @$cmd, '-o', $to, $self->uri;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
      ### shell out ###
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG
      )) {
          ### wget creates the output document always, even if the fetch
          ### fails.. so unlink it in that case
          1 while unlink $to;
  
          return $self->_error(loc( "Command failed: %1", $captured || '' ));
      }
  
      return $to;
  }
  
  ### use File::Copy for fetching file:// urls ###
  ###
  ### See section 3.10 of RFC 1738 (http://www.faqs.org/rfcs/rfc1738.html)
  ### Also see wikipedia on file:// (http://en.wikipedia.org/wiki/File://)
  ###
  
  sub _file_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
  
  
  
      ### prefix a / on unix systems with a file uri, since it would
      ### look somewhat like this:
      ###     file:///home/kane/file
      ### whereas windows file uris for 'c:\some\dir\file' might look like:
      ###     file:///C:/some/dir/file
      ###     file:///C|/some/dir/file
      ### or for a network share '\\host\share\some\dir\file':
      ###     file:////host/share/some/dir/file
      ###
      ### VMS file uri's for 'DISK$USER:[MY.NOTES]NOTE123456.TXT' might look like:
      ###     file://vms.host.edu/disk$user/my/notes/note12345.txt
      ###
  
      my $path    = $self->path;
      my $vol     = $self->vol;
      my $share   = $self->share;
  
      my $remote;
      if (!$share and $self->host) {
          return $self->_error(loc(
              "Currently %1 cannot handle hosts in %2 urls",
              'File::Fetch', 'file://'
          ));
      }
  
      if( $vol ) {
          $path   = File::Spec->catdir( split /\//, $path );
          $remote = File::Spec->catpath( $vol, $path, $self->file);
  
      } elsif( $share ) {
          ### win32 specific, and a share name, so we wont bother with File::Spec
          $path   =~ s|/+|\\|g;
          $remote = "\\\\".$self->host."\\$share\\$path";
  
      } else {
          ### File::Spec on VMS can not currently handle UNIX syntax.
          my $file_class = ON_VMS
              ? 'File::Spec::Unix'
              : 'File::Spec';
  
          $remote  = $file_class->catfile( $path, $self->file );
      }
  
      ### File::Copy is littered with 'die' statements :( ###
      my $rv = eval { File::Copy::copy( $remote, $to ) };
  
      ### something went wrong ###
      if( !$rv or $@ ) {
          return $self->_error(loc("Could not copy '%1' to '%2': %3 %4",
                               $remote, $to, $!, $@));
      }
  
      return $to;
  }
  
  ### use /usr/bin/rsync to fetch files
  sub _rsync_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
      my $rsync;
      unless ( $rsync = can_run('rsync') ) {
          $METHOD_FAIL->{'rsync'} = 1;
          return;
      }
  
      my $cmd = [ $rsync ];
  
      ### XXX: rsync has no I/O timeouts at all, by default
      push(@$cmd, '--timeout=' . $TIMEOUT) if $TIMEOUT;
  
      push(@$cmd, '--quiet') unless $DEBUG;
  
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      push @$cmd, $self->uri, $to;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG )
      ) {
  
          return $self->_error(loc("Command %1 failed: %2",
              "@$cmd" || '', $captured || ''));
      }
  
      return $to;
  
  }
  
  ### use git to fetch files
  sub _git_fetch {
      my $self = shift;
      my %hash = @_;
  
      my ($to);
      my $tmpl = {
          to  => { required => 1, store => \$to }
      };
      check( $tmpl, \%hash ) or return;
      my $git;
      unless ( $git = can_run('git') ) {
          $METHOD_FAIL->{'git'} = 1;
          return;
      }
  
      my $cmd = [ $git, 'clone' ];
  
      #push(@$cmd, '--timeout=' . $TIMEOUT) if $TIMEOUT;
  
      push(@$cmd, '--quiet') unless $DEBUG;
  
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      push @$cmd, $self->uri, $to;
  
      ### with IPC::Cmd > 0.41, this is fixed in teh library,
      ### and there's no need for special casing any more.
      ### DO NOT quote things for IPC::Run, it breaks stuff.
      # $IPC::Cmd::USE_IPC_RUN
      #    ? ($to, $self->uri)
      #    : (QUOTE. $to .QUOTE, QUOTE. $self->uri .QUOTE);
  
      my $captured;
      unless(run( command => $cmd,
                  buffer  => \$captured,
                  verbose => $DEBUG )
      ) {
  
          return $self->_error(loc("Command %1 failed: %2",
              "@$cmd" || '', $captured || ''));
      }
  
      return $to;
  
  }
  
  #################################
  #
  # Error code
  #
  #################################
  
  =pod
  
  =head2 $ff->error([BOOL])
  
  Returns the last encountered error as string.
  Pass it a true value to get the C<Carp::longmess()> output instead.
  
  =cut
  
  ### error handling the way Archive::Extract does it
  sub _error {
      my $self    = shift;
      my $error   = shift;
  
      $self->_error_msg( $error );
      $self->_error_msg_long( Carp::longmess($error) );
  
      if( $WARN ) {
          carp $DEBUG ? $self->_error_msg_long : $self->_error_msg;
      }
  
      return;
  }
  
  sub error {
      my $self = shift;
      return shift() ? $self->_error_msg_long : $self->_error_msg;
  }
  
  
  1;
  
  =pod
  
  =head1 HOW IT WORKS
  
  File::Fetch is able to fetch a variety of uris, by using several
  external programs and modules.
  
  Below is a mapping of what utilities will be used in what order
  for what schemes, if available:
  
      file    => LWP, lftp, file
      http    => LWP, HTTP::Tiny, wget, curl, lftp, fetch, HTTP::Lite, lynx, iosock
      ftp     => LWP, Net::FTP, wget, curl, lftp, fetch, ncftp, ftp
      rsync   => rsync
      git     => git
  
  If you'd like to disable the use of one or more of these utilities
  and/or modules, see the C<$BLACKLIST> variable further down.
  
  If a utility or module isn't available, it will be marked in a cache
  (see the C<$METHOD_FAIL> variable further down), so it will not be
  tried again. The C<fetch> method will only fail when all options are
  exhausted, and it was not able to retrieve the file.
  
  The C<fetch> utility is available on FreeBSD. NetBSD and Dragonfly BSD
  may also have it from C<pkgsrc>. We only check for C<fetch> on those
  three platforms.
  
  C<iosock> is a very limited L<IO::Socket::INET> based mechanism for
  retrieving C<http> schemed urls. It doesn't follow redirects for instance.
  
  C<git> only supports C<git://> style urls.
  
  A special note about fetching files from an ftp uri:
  
  By default, all ftp connections are done in passive mode. To change
  that, see the C<$FTP_PASSIVE> variable further down.
  
  Furthermore, ftp uris only support anonymous connections, so no
  named user/password pair can be passed along.
  
  C</bin/ftp> is blacklisted by default; see the C<$BLACKLIST> variable
  further down.
  
  =head1 GLOBAL VARIABLES
  
  The behaviour of File::Fetch can be altered by changing the following
  global variables:
  
  =head2 $File::Fetch::FROM_EMAIL
  
  This is the email address that will be sent as your anonymous ftp
  password.
  
  Default is C<File-Fetch@example.com>.
  
  =head2 $File::Fetch::USER_AGENT
  
  This is the useragent as C<LWP> will report it.
  
  Default is C<File::Fetch/$VERSION>.
  
  =head2 $File::Fetch::FTP_PASSIVE
  
  This variable controls whether the environment variable C<FTP_PASSIVE>
  and any passive switches to commandline tools will be set to true.
  
  Default value is 1.
  
  Note: When $FTP_PASSIVE is true, C<ncftp> will not be used to fetch
  files, since passive mode can only be set interactively for this binary
  
  =head2 $File::Fetch::TIMEOUT
  
  When set, controls the network timeout (counted in seconds).
  
  Default value is 0.
  
  =head2 $File::Fetch::WARN
  
  This variable controls whether errors encountered internally by
  C<File::Fetch> should be C<carp>'d or not.
  
  Set to false to silence warnings. Inspect the output of the C<error()>
  method manually to see what went wrong.
  
  Defaults to C<true>.
  
  =head2 $File::Fetch::DEBUG
  
  This enables debugging output when calling commandline utilities to
  fetch files.
  This also enables C<Carp::longmess> errors, instead of the regular
  C<carp> errors.
  
  Good for tracking down why things don't work with your particular
  setup.
  
  Default is 0.
  
  =head2 $File::Fetch::BLACKLIST
  
  This is an array ref holding blacklisted modules/utilities for fetching
  files with.
  
  To disallow the use of, for example, C<LWP> and C<Net::FTP>, you could
  set $File::Fetch::BLACKLIST to:
  
      $File::Fetch::BLACKLIST = [qw|lwp netftp|]
  
  The default blacklist is [qw|ftp|], as C</bin/ftp> is rather unreliable.
  
  See the note on C<MAPPING> below.
  
  =head2 $File::Fetch::METHOD_FAIL
  
  This is a hashref registering what modules/utilities were known to fail
  for fetching files (mostly because they weren't installed).
  
  You can reset this cache by assigning an empty hashref to it, or
  individually remove keys.
  
  See the note on C<MAPPING> below.
  
  =head1 MAPPING
  
  
  Here's a quick mapping for the utilities/modules, and their names for
  the $BLACKLIST, $METHOD_FAIL and other internal functions.
  
      LWP         => lwp
      HTTP::Lite  => httplite
      HTTP::Tiny  => httptiny
      Net::FTP    => netftp
      wget        => wget
      lynx        => lynx
      ncftp       => ncftp
      ftp         => ftp
      curl        => curl
      rsync       => rsync
      lftp        => lftp
      fetch       => fetch
      IO::Socket  => iosock
  
  =head1 FREQUENTLY ASKED QUESTIONS
  
  =head2 So how do I use a proxy with File::Fetch?
  
  C<File::Fetch> currently only supports proxies with LWP::UserAgent.
  You will need to set your environment variables accordingly. For
  example, to use an ftp proxy:
  
      $ENV{ftp_proxy} = 'foo.com';
  
  Refer to the LWP::UserAgent manpage for more details.
  
  =head2 I used 'lynx' to fetch a file, but its contents is all wrong!
  
  C<lynx> can only fetch remote files by dumping its contents to C<STDOUT>,
  which we in turn capture. If that content is a 'custom' error file
  (like, say, a C<404 handler>), you will get that contents instead.
  
  Sadly, C<lynx> doesn't support any options to return a different exit
  code on non-C<200 OK> status, giving us no way to tell the difference
  between a 'successful' fetch and a custom error page.
  
  Therefor, we recommend to only use C<lynx> as a last resort. This is
  why it is at the back of our list of methods to try as well.
  
  =head2 Files I'm trying to fetch have reserved characters or non-ASCII characters in them. What do I do?
  
  C<File::Fetch> is relatively smart about things. When trying to write
  a file to disk, it removes the C<query parameters> (see the
  C<output_file> method for details) from the file name before creating
  it. In most cases this suffices.
  
  If you have any other characters you need to escape, please install
  the C<URI::Escape> module from CPAN, and pre-encode your URI before
  passing it to C<File::Fetch>. You can read about the details of URIs
  and URI encoding here:
  
    http://www.faqs.org/rfcs/rfc2396.html
  
  =head1 TODO
  
  =over 4
  
  =item Implement $PREFER_BIN
  
  To indicate to rather use commandline tools than modules
  
  =back
  
  =head1 BUG REPORTS
  
  Please report bugs or other issues to E<lt>bug-file-fetch@rt.cpan.org<gt>.
  
  =head1 AUTHOR
  
  This module by Jos Boumans E<lt>kane@cpan.orgE<gt>.
  
  =head1 COPYRIGHT
  
  This library is free software; you may redistribute and/or modify it
  under the same terms as Perl itself.
  
  
  =cut
  
  # Local variables:
  # c-indentation-style: bsd
  # c-basic-offset: 4
  # indent-tabs-mode: nil
  # End:
  # vim: expandtab shiftwidth=4:
  
  
  
  
FILE_FETCH

$fatpacked{"File/Path.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'FILE_PATH';
  package File::Path;
  
  use 5.005_04;
  use strict;
  
  use Cwd 'getcwd';
  use File::Basename ();
  use File::Spec     ();
  
  BEGIN {
      if ( $] < 5.006 ) {
  
          # can't say 'opendir my $dh, $dirname'
          # need to initialise $dh
          eval 'use Symbol';
      }
  }
  
  use Exporter ();
  use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);
  $VERSION   = '2.15';
  $VERSION   = eval $VERSION;
  @ISA       = qw(Exporter);
  @EXPORT    = qw(mkpath rmtree);
  @EXPORT_OK = qw(make_path remove_tree);
  
  BEGIN {
    for (qw(VMS MacOS MSWin32 os2)) {
      no strict 'refs';
      *{"_IS_\U$_"} = $^O eq $_ ? sub () { 1 } : sub () { 0 };
    }
  
    # These OSes complain if you want to remove a file that you have no
    # write permission to:
    *_FORCE_WRITABLE = (
      grep { $^O eq $_ } qw(amigaos dos epoc MSWin32 MacOS os2)
    ) ? sub () { 1 } : sub () { 0 };
  
    # Unix-like systems need to stat each directory in order to detect
    # race condition. MS-Windows is immune to this particular attack.
    *_NEED_STAT_CHECK = !(_IS_MSWIN32()) ? sub () { 1 } : sub () { 0 };
  }
  
  sub _carp {
      require Carp;
      goto &Carp::carp;
  }
  
  sub _croak {
      require Carp;
      goto &Carp::croak;
  }
  
  sub _error {
      my $arg     = shift;
      my $message = shift;
      my $object  = shift;
  
      if ( $arg->{error} ) {
          $object = '' unless defined $object;
          $message .= ": $!" if $!;
          push @{ ${ $arg->{error} } }, { $object => $message };
      }
      else {
          _carp( defined($object) ? "$message for $object: $!" : "$message: $!" );
      }
  }
  
  sub __is_arg {
      my ($arg) = @_;
  
      # If client code blessed an array ref to HASH, this will not work
      # properly. We could have done $arg->isa() wrapped in eval, but
      # that would be expensive. This implementation should suffice.
      # We could have also used Scalar::Util:blessed, but we choose not
      # to add this dependency
      return ( ref $arg eq 'HASH' );
  }
  
  sub make_path {
      push @_, {} unless @_ and __is_arg( $_[-1] );
      goto &mkpath;
  }
  
  sub mkpath {
      my $old_style = !( @_ and __is_arg( $_[-1] ) );
  
      my $data;
      my $paths;
  
      if ($old_style) {
          my ( $verbose, $mode );
          ( $paths, $verbose, $mode ) = @_;
          $paths = [$paths] unless UNIVERSAL::isa( $paths, 'ARRAY' );
          $data->{verbose} = $verbose;
          $data->{mode} = defined $mode ? $mode : oct '777';
      }
      else {
          my %args_permitted = map { $_ => 1 } ( qw|
              chmod
              error
              group
              mask
              mode
              owner
              uid
              user
              verbose
          | );
          my %not_on_win32_args = map { $_ => 1 } ( qw|
              group
              owner
              uid
              user
          | );
          my @bad_args = ();
          my @win32_implausible_args = ();
          my $arg = pop @_;
          for my $k (sort keys %{$arg}) {
              if (! $args_permitted{$k}) {
                  push @bad_args, $k;
              }
              elsif ($not_on_win32_args{$k} and _IS_MSWIN32) {
                  push @win32_implausible_args, $k;
              }
              else {
                  $data->{$k} = $arg->{$k};
              }
          }
          _carp("Unrecognized option(s) passed to mkpath() or make_path(): @bad_args")
              if @bad_args;
          _carp("Option(s) implausible on Win32 passed to mkpath() or make_path(): @win32_implausible_args")
              if @win32_implausible_args;
          $data->{mode} = delete $data->{mask} if exists $data->{mask};
          $data->{mode} = oct '777' unless exists $data->{mode};
          ${ $data->{error} } = [] if exists $data->{error};
          unless (@win32_implausible_args) {
              $data->{owner} = delete $data->{user} if exists $data->{user};
              $data->{owner} = delete $data->{uid}  if exists $data->{uid};
              if ( exists $data->{owner} and $data->{owner} =~ /\D/ ) {
                  my $uid = ( getpwnam $data->{owner} )[2];
                  if ( defined $uid ) {
                      $data->{owner} = $uid;
                  }
                  else {
                      _error( $data,
                              "unable to map $data->{owner} to a uid, ownership not changed"
                            );
                      delete $data->{owner};
                  }
              }
              if ( exists $data->{group} and $data->{group} =~ /\D/ ) {
                  my $gid = ( getgrnam $data->{group} )[2];
                  if ( defined $gid ) {
                      $data->{group} = $gid;
                  }
                  else {
                      _error( $data,
                              "unable to map $data->{group} to a gid, group ownership not changed"
                      );
                      delete $data->{group};
                  }
              }
              if ( exists $data->{owner} and not exists $data->{group} ) {
                  $data->{group} = -1;    # chown will leave group unchanged
              }
              if ( exists $data->{group} and not exists $data->{owner} ) {
                  $data->{owner} = -1;    # chown will leave owner unchanged
              }
          }
          $paths = [@_];
      }
      return _mkpath( $data, $paths );
  }
  
  sub _mkpath {
      my $data   = shift;
      my $paths = shift;
  
      my ( @created );
      foreach my $path ( @{$paths} ) {
          next unless defined($path) and length($path);
          $path .= '/' if _IS_OS2 and $path =~ /^\w:\z/s; # feature of CRT
  
          # Logic wants Unix paths, so go with the flow.
          if (_IS_VMS) {
              next if $path eq '/';
              $path = VMS::Filespec::unixify($path);
          }
          next if -d $path;
          my $parent = File::Basename::dirname($path);
          # Coverage note:  It's not clear how we would test the condition:
          # '-d $parent or $path eq $parent'
          unless ( -d $parent or $path eq $parent ) {
              push( @created, _mkpath( $data, [$parent] ) );
          }
          print "mkdir $path\n" if $data->{verbose};
          if ( mkdir( $path, $data->{mode} ) ) {
              push( @created, $path );
              if ( exists $data->{owner} ) {
  
                  # NB: $data->{group} guaranteed to be set during initialisation
                  if ( !chown $data->{owner}, $data->{group}, $path ) {
                      _error( $data,
                          "Cannot change ownership of $path to $data->{owner}:$data->{group}"
                      );
                  }
              }
              if ( exists $data->{chmod} ) {
                  # Coverage note:  It's not clear how we would trigger the next
                  # 'if' block.  Failure of 'chmod' might first result in a
                  # system error: "Permission denied".
                  if ( !chmod $data->{chmod}, $path ) {
                      _error( $data,
                          "Cannot change permissions of $path to $data->{chmod}" );
                  }
              }
          }
          else {
              my $save_bang = $!;
  
              # From 'perldoc perlvar': $EXTENDED_OS_ERROR ($^E) is documented
              # as:
              # Error information specific to the current operating system. At the
              # moment, this differs from "$!" under only VMS, OS/2, and Win32
              # (and for MacPerl). On all other platforms, $^E is always just the
              # same as $!.
  
              my ( $e, $e1 ) = ( $save_bang, $^E );
              $e .= "; $e1" if $e ne $e1;
  
              # allow for another process to have created it meanwhile
              if ( ! -d $path ) {
                  $! = $save_bang;
                  if ( $data->{error} ) {
                      push @{ ${ $data->{error} } }, { $path => $e };
                  }
                  else {
                      _croak("mkdir $path: $e");
                  }
              }
          }
      }
      return @created;
  }
  
  sub remove_tree {
      push @_, {} unless @_ and __is_arg( $_[-1] );
      goto &rmtree;
  }
  
  sub _is_subdir {
      my ( $dir, $test ) = @_;
  
      my ( $dv, $dd ) = File::Spec->splitpath( $dir,  1 );
      my ( $tv, $td ) = File::Spec->splitpath( $test, 1 );
  
      # not on same volume
      return 0 if $dv ne $tv;
  
      my @d = File::Spec->splitdir($dd);
      my @t = File::Spec->splitdir($td);
  
      # @t can't be a subdir if it's shorter than @d
      return 0 if @t < @d;
  
      return join( '/', @d ) eq join( '/', splice @t, 0, +@d );
  }
  
  sub rmtree {
      my $old_style = !( @_ and __is_arg( $_[-1] ) );
  
      my ($arg, $data, $paths);
  
      if ($old_style) {
          my ( $verbose, $safe );
          ( $paths, $verbose, $safe ) = @_;
          $data->{verbose} = $verbose;
          $data->{safe} = defined $safe ? $safe : 0;
  
          if ( defined($paths) and length($paths) ) {
              $paths = [$paths] unless UNIVERSAL::isa( $paths, 'ARRAY' );
          }
          else {
              _carp("No root path(s) specified\n");
              return 0;
          }
      }
      else {
          my %args_permitted = map { $_ => 1 } ( qw|
              error
              keep_root
              result
              safe
              verbose
          | );
          my @bad_args = ();
          my $arg = pop @_;
          for my $k (sort keys %{$arg}) {
              if (! $args_permitted{$k}) {
                  push @bad_args, $k;
              }
              else {
                  $data->{$k} = $arg->{$k};
              }
          }
          _carp("Unrecognized option(s) passed to remove_tree(): @bad_args")
              if @bad_args;
          ${ $data->{error} }  = [] if exists $data->{error};
          ${ $data->{result} } = [] if exists $data->{result};
  
          # Wouldn't it make sense to do some validation on @_ before assigning
          # to $paths here?
          # In the $old_style case we guarantee that each path is both defined
          # and non-empty.  We don't check that here, which means we have to
          # check it later in the first condition in this line:
          #     if ( $ortho_root_length && _is_subdir( $ortho_root, $ortho_cwd ) ) {
          # Granted, that would be a change in behavior for the two
          # non-old-style interfaces.
  
          $paths = [@_];
      }
  
      $data->{prefix} = '';
      $data->{depth}  = 0;
  
      my @clean_path;
      $data->{cwd} = getcwd() or do {
          _error( $data, "cannot fetch initial working directory" );
          return 0;
      };
      for ( $data->{cwd} ) { /\A(.*)\Z/s; $_ = $1 }    # untaint
  
      for my $p (@$paths) {
  
          # need to fixup case and map \ to / on Windows
          my $ortho_root = _IS_MSWIN32 ? _slash_lc($p) : $p;
          my $ortho_cwd =
            _IS_MSWIN32 ? _slash_lc( $data->{cwd} ) : $data->{cwd};
          my $ortho_root_length = length($ortho_root);
          $ortho_root_length-- if _IS_VMS;   # don't compare '.' with ']'
          if ( $ortho_root_length && _is_subdir( $ortho_root, $ortho_cwd ) ) {
              local $! = 0;
              _error( $data, "cannot remove path when cwd is $data->{cwd}", $p );
              next;
          }
  
          if (_IS_MACOS) {
              $p = ":$p" unless $p =~ /:/;
              $p .= ":" unless $p =~ /:\z/;
          }
          elsif ( _IS_MSWIN32 ) {
              $p =~ s{[/\\]\z}{};
          }
          else {
              $p =~ s{/\z}{};
          }
          push @clean_path, $p;
      }
  
      @{$data}{qw(device inode)} = ( lstat $data->{cwd} )[ 0, 1 ] or do {
          _error( $data, "cannot stat initial working directory", $data->{cwd} );
          return 0;
      };
  
      return _rmtree( $data, \@clean_path );
  }
  
  sub _rmtree {
      my $data   = shift;
      my $paths = shift;
  
      my $count  = 0;
      my $curdir = File::Spec->curdir();
      my $updir  = File::Spec->updir();
  
      my ( @files, $root );
    ROOT_DIR:
      foreach my $root (@$paths) {
  
          # since we chdir into each directory, it may not be obvious
          # to figure out where we are if we generate a message about
          # a file name. We therefore construct a semi-canonical
          # filename, anchored from the directory being unlinked (as
          # opposed to being truly canonical, anchored from the root (/).
  
          my $canon =
            $data->{prefix}
            ? File::Spec->catfile( $data->{prefix}, $root )
            : $root;
  
          my ( $ldev, $lino, $perm ) = ( lstat $root )[ 0, 1, 2 ]
            or next ROOT_DIR;
  
          if ( -d _ ) {
              $root = VMS::Filespec::vmspath( VMS::Filespec::pathify($root) )
                if _IS_VMS;
  
              if ( !chdir($root) ) {
  
                  # see if we can escalate privileges to get in
                  # (e.g. funny protection mask such as -w- instead of rwx)
                  # This uses fchmod to avoid traversing outside of the proper
                  # location (CVE-2017-6512)
                  my $root_fh;
                  if (open($root_fh, '<', $root)) {
                      my ($fh_dev, $fh_inode) = (stat $root_fh )[0,1];
                      $perm &= oct '7777';
                      my $nperm = $perm | oct '700';
                      local $@;
                      if (
                          !(
                              $data->{safe}
                             or $nperm == $perm
                             or !-d _
                             or $fh_dev ne $ldev
                             or $fh_inode ne $lino
                             or eval { chmod( $nperm, $root_fh ) }
                          )
                        )
                      {
                          _error( $data,
                              "cannot make child directory read-write-exec", $canon );
                          next ROOT_DIR;
                      }
                      close $root_fh;
                  }
                  if ( !chdir($root) ) {
                      _error( $data, "cannot chdir to child", $canon );
                      next ROOT_DIR;
                  }
              }
  
              my ( $cur_dev, $cur_inode, $perm ) = ( stat $curdir )[ 0, 1, 2 ]
                or do {
                  _error( $data, "cannot stat current working directory", $canon );
                  next ROOT_DIR;
                };
  
              if (_NEED_STAT_CHECK) {
                  ( $ldev eq $cur_dev and $lino eq $cur_inode )
                    or _croak(
  "directory $canon changed before chdir, expected dev=$ldev ino=$lino, actual dev=$cur_dev ino=$cur_inode, aborting."
                    );
              }
  
              $perm &= oct '7777';    # don't forget setuid, setgid, sticky bits
              my $nperm = $perm | oct '700';
  
              # notabene: 0700 is for making readable in the first place,
              # it's also intended to change it to writable in case we have
              # to recurse in which case we are better than rm -rf for
              # subtrees with strange permissions
  
              if (
                  !(
                         $data->{safe}
                      or $nperm == $perm
                      or chmod( $nperm, $curdir )
                  )
                )
              {
                  _error( $data, "cannot make directory read+writeable", $canon );
                  $nperm = $perm;
              }
  
              my $d;
              $d = gensym() if $] < 5.006;
              if ( !opendir $d, $curdir ) {
                  _error( $data, "cannot opendir", $canon );
                  @files = ();
              }
              else {
                  if ( !defined ${^TAINT} or ${^TAINT} ) {
                      # Blindly untaint dir names if taint mode is active
                      @files = map { /\A(.*)\z/s; $1 } readdir $d;
                  }
                  else {
                      @files = readdir $d;
                  }
                  closedir $d;
              }
  
              if (_IS_VMS) {
  
                  # Deleting large numbers of files from VMS Files-11
                  # filesystems is faster if done in reverse ASCIIbetical order.
                  # include '.' to '.;' from blead patch #31775
                  @files = map { $_ eq '.' ? '.;' : $_ } reverse @files;
              }
  
              @files = grep { $_ ne $updir and $_ ne $curdir } @files;
  
              if (@files) {
  
                  # remove the contained files before the directory itself
                  my $narg = {%$data};
                  @{$narg}{qw(device inode cwd prefix depth)} =
                    ( $cur_dev, $cur_inode, $updir, $canon, $data->{depth} + 1 );
                  $count += _rmtree( $narg, \@files );
              }
  
              # restore directory permissions of required now (in case the rmdir
              # below fails), while we are still in the directory and may do so
              # without a race via '.'
              if ( $nperm != $perm and not chmod( $perm, $curdir ) ) {
                  _error( $data, "cannot reset chmod", $canon );
              }
  
              # don't leave the client code in an unexpected directory
              chdir( $data->{cwd} )
                or
                _croak("cannot chdir to $data->{cwd} from $canon: $!, aborting.");
  
              # ensure that a chdir upwards didn't take us somewhere other
              # than we expected (see CVE-2002-0435)
              ( $cur_dev, $cur_inode ) = ( stat $curdir )[ 0, 1 ]
                or _croak(
                  "cannot stat prior working directory $data->{cwd}: $!, aborting."
                );
  
              if (_NEED_STAT_CHECK) {
                  ( $data->{device} eq $cur_dev and $data->{inode} eq $cur_inode )
                    or _croak(  "previous directory $data->{cwd} "
                              . "changed before entering $canon, "
                              . "expected dev=$ldev ino=$lino, "
                              . "actual dev=$cur_dev ino=$cur_inode, aborting."
                    );
              }
  
              if ( $data->{depth} or !$data->{keep_root} ) {
                  if ( $data->{safe}
                      && ( _IS_VMS
                          ? !&VMS::Filespec::candelete($root)
                          : !-w $root ) )
                  {
                      print "skipped $root\n" if $data->{verbose};
                      next ROOT_DIR;
                  }
                  if ( _FORCE_WRITABLE and !chmod $perm | oct '700', $root ) {
                      _error( $data, "cannot make directory writeable", $canon );
                  }
                  print "rmdir $root\n" if $data->{verbose};
                  if ( rmdir $root ) {
                      push @{ ${ $data->{result} } }, $root if $data->{result};
                      ++$count;
                  }
                  else {
                      _error( $data, "cannot remove directory", $canon );
                      if (
                          _FORCE_WRITABLE
                          && !chmod( $perm,
                              ( _IS_VMS ? VMS::Filespec::fileify($root) : $root )
                          )
                        )
                      {
                          _error(
                              $data,
                              sprintf( "cannot restore permissions to 0%o",
                                  $perm ),
                              $canon
                          );
                      }
                  }
              }
          }
          else {
              # not a directory
              $root = VMS::Filespec::vmsify("./$root")
                if _IS_VMS
                && !File::Spec->file_name_is_absolute($root)
                && ( $root !~ m/(?<!\^)[\]>]+/ );    # not already in VMS syntax
  
              if (
                  $data->{safe}
                  && (
                      _IS_VMS
                      ? !&VMS::Filespec::candelete($root)
                      : !( -l $root || -w $root )
                  )
                )
              {
                  print "skipped $root\n" if $data->{verbose};
                  next ROOT_DIR;
              }
  
              my $nperm = $perm & oct '7777' | oct '600';
              if (    _FORCE_WRITABLE
                  and $nperm != $perm
                  and not chmod $nperm, $root )
              {
                  _error( $data, "cannot make file writeable", $canon );
              }
              print "unlink $canon\n" if $data->{verbose};
  
              # delete all versions under VMS
              for ( ; ; ) {
                  if ( unlink $root ) {
                      push @{ ${ $data->{result} } }, $root if $data->{result};
                  }
                  else {
                      _error( $data, "cannot unlink file", $canon );
                      _FORCE_WRITABLE and chmod( $perm, $root )
                        or _error( $data,
                          sprintf( "cannot restore permissions to 0%o", $perm ),
                          $canon );
                      last;
                  }
                  ++$count;
                  last unless _IS_VMS && lstat $root;
              }
          }
      }
      return $count;
  }
  
  sub _slash_lc {
  
      # fix up slashes and case on MSWin32 so that we can determine that
      # c:\path\to\dir is underneath C:/Path/To
      my $path = shift;
      $path =~ tr{\\}{/};
      return lc($path);
  }
  
  1;
  
  __END__
  
  =head1 NAME
  
  File::Path - Create or remove directory trees
  
  =head1 VERSION
  
  2.15 - released June 07 2017.
  
  =head1 SYNOPSIS
  
      use File::Path qw(make_path remove_tree);
  
      @created = make_path('foo/bar/baz', '/zug/zwang');
      @created = make_path('foo/bar/baz', '/zug/zwang', {
          verbose => 1,
          mode => 0711,
      });
      make_path('foo/bar/baz', '/zug/zwang', {
          chmod => 0777,
      });
  
      $removed_count = remove_tree('foo/bar/baz', '/zug/zwang', {
          verbose => 1,
          error  => \my $err_list,
          safe => 1,
      });
  
      # legacy (interface promoted before v2.00)
      @created = mkpath('/foo/bar/baz');
      @created = mkpath('/foo/bar/baz', 1, 0711);
      @created = mkpath(['/foo/bar/baz', 'blurfl/quux'], 1, 0711);
      $removed_count = rmtree('foo/bar/baz', 1, 1);
      $removed_count = rmtree(['foo/bar/baz', 'blurfl/quux'], 1, 1);
  
      # legacy (interface promoted before v2.06)
      @created = mkpath('foo/bar/baz', '/zug/zwang', { verbose => 1, mode => 0711 });
      $removed_count = rmtree('foo/bar/baz', '/zug/zwang', { verbose => 1, mode => 0711 });
  
  =head1 DESCRIPTION
  
  This module provides a convenient way to create directories of
  arbitrary depth and to delete an entire directory subtree from the
  filesystem.
  
  The following functions are provided:
  
  =over
  
  =item make_path( $dir1, $dir2, .... )
  
  =item make_path( $dir1, $dir2, ...., \%opts )
  
  The C<make_path> function creates the given directories if they don't
  exist before, much like the Unix command C<mkdir -p>.
  
  The function accepts a list of directories to be created. Its
  behaviour may be tuned by an optional hashref appearing as the last
  parameter on the call.
  
  The function returns the list of directories actually created during
  the call; in scalar context the number of directories created.
  
  The following keys are recognised in the option hash:
  
  =over
  
  =item mode => $num
  
  The numeric permissions mode to apply to each created directory
  (defaults to C<0777>), to be modified by the current C<umask>. If the
  directory already exists (and thus does not need to be created),
  the permissions will not be modified.
  
  C<mask> is recognised as an alias for this parameter.
  
  =item chmod => $num
  
  Takes a numeric mode to apply to each created directory (not
  modified by the current C<umask>). If the directory already exists
  (and thus does not need to be created), the permissions will
  not be modified.
  
  =item verbose => $bool
  
  If present, will cause C<make_path> to print the name of each directory
  as it is created. By default nothing is printed.
  
  =item error => \$err
  
  If present, it should be a reference to a scalar.
  This scalar will be made to reference an array, which will
  be used to store any errors that are encountered.  See the L</"ERROR
  HANDLING"> section for more information.
  
  If this parameter is not used, certain error conditions may raise
  a fatal error that will cause the program to halt, unless trapped
  in an C<eval> block.
  
  =item owner => $owner
  
  =item user => $owner
  
  =item uid => $owner
  
  If present, will cause any created directory to be owned by C<$owner>.
  If the value is numeric, it will be interpreted as a uid; otherwise a
  username is assumed. An error will be issued if the username cannot be
  mapped to a uid, the uid does not exist or the process lacks the
  privileges to change ownership.
  
  Ownership of directories that already exist will not be changed.
  
  C<user> and C<uid> are aliases of C<owner>.
  
  =item group => $group
  
  If present, will cause any created directory to be owned by the group
  C<$group>.  If the value is numeric, it will be interpreted as a gid;
  otherwise a group name is assumed. An error will be issued if the
  group name cannot be mapped to a gid, the gid does not exist or the
  process lacks the privileges to change group ownership.
  
  Group ownership of directories that already exist will not be changed.
  
      make_path '/var/tmp/webcache', {owner=>'nobody', group=>'nogroup'};
  
  =back
  
  =item mkpath( $dir )
  
  =item mkpath( $dir, $verbose, $mode )
  
  =item mkpath( [$dir1, $dir2,...], $verbose, $mode )
  
  =item mkpath( $dir1, $dir2,..., \%opt )
  
  The C<mkpath()> function provide the legacy interface of
  C<make_path()> with a different interpretation of the arguments
  passed.  The behaviour and return value of the function is otherwise
  identical to C<make_path()>.
  
  =item remove_tree( $dir1, $dir2, .... )
  
  =item remove_tree( $dir1, $dir2, ...., \%opts )
  
  The C<remove_tree> function deletes the given directories and any
  files and subdirectories they might contain, much like the Unix
  command C<rm -rf> or the Windows commands C<rmdir /s> and C<rd /s>.
  
  The function accepts a list of directories to be removed. (In point of fact,
  it will also accept filesystem entries which are not directories, such as
  regular files and symlinks.  But, as its name suggests, its intent is to
  remove trees rather than individual files.)
  
  C<remove_tree()>'s behaviour may be tuned by an optional hashref
  appearing as the last parameter on the call.  If an empty string is
  passed to C<remove_tree>, an error will occur.
  
  B<NOTE:>  For security reasons, we strongly advise use of the
  hashref-as-final-argument syntax -- specifically, with a setting of the C<safe>
  element to a true value.
  
      remove_tree( $dir1, $dir2, ....,
          {
              safe => 1,
              ...         # other key-value pairs
          },
      );
  
  The function returns the number of files successfully deleted.
  
  The following keys are recognised in the option hash:
  
  =over
  
  =item verbose => $bool
  
  If present, will cause C<remove_tree> to print the name of each file as
  it is unlinked. By default nothing is printed.
  
  =item safe => $bool
  
  When set to a true value, will cause C<remove_tree> to skip the files
  for which the process lacks the required privileges needed to delete
  files, such as delete privileges on VMS. In other words, the code
  will make no attempt to alter file permissions. Thus, if the process
  is interrupted, no filesystem object will be left in a more
  permissive mode.
  
  =item keep_root => $bool
  
  When set to a true value, will cause all files and subdirectories
  to be removed, except the initially specified directories. This comes
  in handy when cleaning out an application's scratch directory.
  
      remove_tree( '/tmp', {keep_root => 1} );
  
  =item result => \$res
  
  If present, it should be a reference to a scalar.
  This scalar will be made to reference an array, which will
  be used to store all files and directories unlinked
  during the call. If nothing is unlinked, the array will be empty.
  
      remove_tree( '/tmp', {result => \my $list} );
      print "unlinked $_\n" for @$list;
  
  This is a useful alternative to the C<verbose> key.
  
  =item error => \$err
  
  If present, it should be a reference to a scalar.
  This scalar will be made to reference an array, which will
  be used to store any errors that are encountered.  See the L</"ERROR
  HANDLING"> section for more information.
  
  Removing things is a much more dangerous proposition than
  creating things. As such, there are certain conditions that
  C<remove_tree> may encounter that are so dangerous that the only
  sane action left is to kill the program.
  
  Use C<error> to trap all that is reasonable (problems with
  permissions and the like), and let it die if things get out
  of hand. This is the safest course of action.
  
  =back
  
  =item rmtree( $dir )
  
  =item rmtree( $dir, $verbose, $safe )
  
  =item rmtree( [$dir1, $dir2,...], $verbose, $safe )
  
  =item rmtree( $dir1, $dir2,..., \%opt )
  
  The C<rmtree()> function provide the legacy interface of
  C<remove_tree()> with a different interpretation of the arguments
  passed. The behaviour and return value of the function is otherwise
  identical to C<remove_tree()>.
  
  B<NOTE:>  For security reasons, we strongly advise use of the
  hashref-as-final-argument syntax, specifically with a setting of the C<safe>
  element to a true value.
  
      rmtree( $dir1, $dir2, ....,
          {
              safe => 1,
              ...         # other key-value pairs
          },
      );
  
  =back
  
  =head2 ERROR HANDLING
  
  =over 4
  
  =item B<NOTE:>
  
  The following error handling mechanism is consistent throughout all
  code paths EXCEPT in cases where the ROOT node is nonexistent.  In
  version 2.11 the maintainers attempted to rectify this inconsistency
  but too many downstream modules encountered problems.  In such case,
  if you require root node evaluation or error checking prior to calling
  C<make_path> or C<remove_tree>, you should take additional precautions.
  
  =back
  
  If C<make_path> or C<remove_tree> encounters an error, a diagnostic
  message will be printed to C<STDERR> via C<carp> (for non-fatal
  errors) or via C<croak> (for fatal errors).
  
  If this behaviour is not desirable, the C<error> attribute may be
  used to hold a reference to a variable, which will be used to store
  the diagnostics. The variable is made a reference to an array of hash
  references.  Each hash contain a single key/value pair where the key
  is the name of the file, and the value is the error message (including
  the contents of C<$!> when appropriate).  If a general error is
  encountered the diagnostic key will be empty.
  
  An example usage looks like:
  
    remove_tree( 'foo/bar', 'bar/rat', {error => \my $err} );
    if ($err && @$err) {
        for my $diag (@$err) {
            my ($file, $message) = %$diag;
            if ($file eq '') {
                print "general error: $message\n";
            }
            else {
                print "problem unlinking $file: $message\n";
            }
        }
    }
    else {
        print "No error encountered\n";
    }
  
  Note that if no errors are encountered, C<$err> will reference an
  empty array.  This means that C<$err> will always end up TRUE; so you
  need to test C<@$err> to determine if errors occurred.
  
  =head2 NOTES
  
  C<File::Path> blindly exports C<mkpath> and C<rmtree> into the
  current namespace. These days, this is considered bad style, but
  to change it now would break too much code. Nonetheless, you are
  invited to specify what it is you are expecting to use:
  
    use File::Path 'rmtree';
  
  The routines C<make_path> and C<remove_tree> are B<not> exported
  by default. You must specify which ones you want to use.
  
    use File::Path 'remove_tree';
  
  Note that a side-effect of the above is that C<mkpath> and C<rmtree>
  are no longer exported at all. This is due to the way the C<Exporter>
  module works. If you are migrating a codebase to use the new
  interface, you will have to list everything explicitly. But that's
  just good practice anyway.
  
    use File::Path qw(remove_tree rmtree);
  
  =head3 API CHANGES
  
  The API was changed in the 2.0 branch. For a time, C<mkpath> and
  C<rmtree> tried, unsuccessfully, to deal with the two different
  calling mechanisms. This approach was considered a failure.
  
  The new semantics are now only available with C<make_path> and
  C<remove_tree>. The old semantics are only available through
  C<mkpath> and C<rmtree>. Users are strongly encouraged to upgrade
  to at least 2.08 in order to avoid surprises.
  
  =head3 SECURITY CONSIDERATIONS
  
  There were race conditions in the 1.x implementations of File::Path's
  C<rmtree> function (although sometimes patched depending on the OS
  distribution or platform). The 2.0 version contains code to avoid the
  problem mentioned in CVE-2002-0435.
  
  See the following pages for more information:
  
      http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=286905
      http://www.nntp.perl.org/group/perl.perl5.porters/2005/01/msg97623.html
      http://www.debian.org/security/2005/dsa-696
  
  Additionally, unless the C<safe> parameter is set (or the
  third parameter in the traditional interface is TRUE), should a
  C<remove_tree> be interrupted, files that were originally in read-only
  mode may now have their permissions set to a read-write (or "delete
  OK") mode.
  
  The following CVE reports were previously filed against File-Path and are
  believed to have been addressed:
  
  =over 4
  
  =item * L<http://cve.circl.lu/cve/CVE-2004-0452>
  
  =item * L<http://cve.circl.lu/cve/CVE-2005-0448>
  
  =back
  
  In February 2017 the cPanel Security Team reported an additional vulnerability
  in File-Path.  The C<chmod()> logic to make directories traversable can be
  abused to set the mode on an attacker-chosen file to an attacker-chosen value.
  This is due to the time-of-check-to-time-of-use (TOCTTOU) race condition
  (L<https://en.wikipedia.org/wiki/Time_of_check_to_time_of_use>) between the
  C<stat()> that decides the inode is a directory and the C<chmod()> that tries
  to make it user-rwx.  CPAN versions 2.13 and later incorporate a patch
  provided by John Lightsey to address this problem.  This vulnerability has
  been reported as CVE-2017-6512.
  
  =head1 DIAGNOSTICS
  
  FATAL errors will cause the program to halt (C<croak>), since the
  problem is so severe that it would be dangerous to continue. (This
  can always be trapped with C<eval>, but it's not a good idea. Under
  the circumstances, dying is the best thing to do).
  
  SEVERE errors may be trapped using the modern interface. If the
  they are not trapped, or if the old interface is used, such an error
  will cause the program will halt.
  
  All other errors may be trapped using the modern interface, otherwise
  they will be C<carp>ed about. Program execution will not be halted.
  
  =over 4
  
  =item mkdir [path]: [errmsg] (SEVERE)
  
  C<make_path> was unable to create the path. Probably some sort of
  permissions error at the point of departure or insufficient resources
  (such as free inodes on Unix).
  
  =item No root path(s) specified
  
  C<make_path> was not given any paths to create. This message is only
  emitted if the routine is called with the traditional interface.
  The modern interface will remain silent if given nothing to do.
  
  =item No such file or directory
  
  On Windows, if C<make_path> gives you this warning, it may mean that
  you have exceeded your filesystem's maximum path length.
  
  =item cannot fetch initial working directory: [errmsg]
  
  C<remove_tree> attempted to determine the initial directory by calling
  C<Cwd::getcwd>, but the call failed for some reason. No attempt
  will be made to delete anything.
  
  =item cannot stat initial working directory: [errmsg]
  
  C<remove_tree> attempted to stat the initial directory (after having
  successfully obtained its name via C<getcwd>), however, the call
  failed for some reason. No attempt will be made to delete anything.
  
  =item cannot chdir to [dir]: [errmsg]
  
  C<remove_tree> attempted to set the working directory in order to
  begin deleting the objects therein, but was unsuccessful. This is
  usually a permissions issue. The routine will continue to delete
  other things, but this directory will be left intact.
  
  =item directory [dir] changed before chdir, expected dev=[n] ino=[n], actual dev=[n] ino=[n], aborting. (FATAL)
  
  C<remove_tree> recorded the device and inode of a directory, and then
  moved into it. It then performed a C<stat> on the current directory
  and detected that the device and inode were no longer the same. As
  this is at the heart of the race condition problem, the program
  will die at this point.
  
  =item cannot make directory [dir] read+writeable: [errmsg]
  
  C<remove_tree> attempted to change the permissions on the current directory
  to ensure that subsequent unlinkings would not run into problems,
  but was unable to do so. The permissions remain as they were, and
  the program will carry on, doing the best it can.
  
  =item cannot read [dir]: [errmsg]
  
  C<remove_tree> tried to read the contents of the directory in order
  to acquire the names of the directory entries to be unlinked, but
  was unsuccessful. This is usually a permissions issue. The
  program will continue, but the files in this directory will remain
  after the call.
  
  =item cannot reset chmod [dir]: [errmsg]
  
  C<remove_tree>, after having deleted everything in a directory, attempted
  to restore its permissions to the original state but failed. The
  directory may wind up being left behind.
  
  =item cannot remove [dir] when cwd is [dir]
  
  The current working directory of the program is F</some/path/to/here>
  and you are attempting to remove an ancestor, such as F</some/path>.
  The directory tree is left untouched.
  
  The solution is to C<chdir> out of the child directory to a place
  outside the directory tree to be removed.
  
  =item cannot chdir to [parent-dir] from [child-dir]: [errmsg], aborting. (FATAL)
  
  C<remove_tree>, after having deleted everything and restored the permissions
  of a directory, was unable to chdir back to the parent. The program
  halts to avoid a race condition from occurring.
  
  =item cannot stat prior working directory [dir]: [errmsg], aborting. (FATAL)
  
  C<remove_tree> was unable to stat the parent directory after having returned
  from the child. Since there is no way of knowing if we returned to
  where we think we should be (by comparing device and inode) the only
  way out is to C<croak>.
  
  =item previous directory [parent-dir] changed before entering [child-dir], expected dev=[n] ino=[n], actual dev=[n] ino=[n], aborting. (FATAL)
  
  When C<remove_tree> returned from deleting files in a child directory, a
  check revealed that the parent directory it returned to wasn't the one
  it started out from. This is considered a sign of malicious activity.
  
  =item cannot make directory [dir] writeable: [errmsg]
  
  Just before removing a directory (after having successfully removed
  everything it contained), C<remove_tree> attempted to set the permissions
  on the directory to ensure it could be removed and failed. Program
  execution continues, but the directory may possibly not be deleted.
  
  =item cannot remove directory [dir]: [errmsg]
  
  C<remove_tree> attempted to remove a directory, but failed. This may be because
  some objects that were unable to be removed remain in the directory, or
  it could be a permissions issue. The directory will be left behind.
  
  =item cannot restore permissions of [dir] to [0nnn]: [errmsg]
  
  After having failed to remove a directory, C<remove_tree> was unable to
  restore its permissions from a permissive state back to a possibly
  more restrictive setting. (Permissions given in octal).
  
  =item cannot make file [file] writeable: [errmsg]
  
  C<remove_tree> attempted to force the permissions of a file to ensure it
  could be deleted, but failed to do so. It will, however, still attempt
  to unlink the file.
  
  =item cannot unlink file [file]: [errmsg]
  
  C<remove_tree> failed to remove a file. Probably a permissions issue.
  
  =item cannot restore permissions of [file] to [0nnn]: [errmsg]
  
  After having failed to remove a file, C<remove_tree> was also unable
  to restore the permissions on the file to a possibly less permissive
  setting. (Permissions given in octal).
  
  =item unable to map [owner] to a uid, ownership not changed");
  
  C<make_path> was instructed to give the ownership of created
  directories to the symbolic name [owner], but C<getpwnam> did
  not return the corresponding numeric uid. The directory will
  be created, but ownership will not be changed.
  
  =item unable to map [group] to a gid, group ownership not changed
  
  C<make_path> was instructed to give the group ownership of created
  directories to the symbolic name [group], but C<getgrnam> did
  not return the corresponding numeric gid. The directory will
  be created, but group ownership will not be changed.
  
  =back
  
  =head1 SEE ALSO
  
  =over 4
  
  =item *
  
  L<File::Remove>
  
  Allows files and directories to be moved to the Trashcan/Recycle
  Bin (where they may later be restored if necessary) if the operating
  system supports such functionality. This feature may one day be
  made available directly in C<File::Path>.
  
  =item *
  
  L<File::Find::Rule>
  
  When removing directory trees, if you want to examine each file to
  decide whether to delete it (and possibly leaving large swathes
  alone), F<File::Find::Rule> offers a convenient and flexible approach
  to examining directory trees.
  
  =back
  
  =head1 BUGS AND LIMITATIONS
  
  The following describes F<File::Path> limitations and how to report bugs.
  
  =head2 MULTITHREADED APPLICATIONS
  
  F<File::Path> C<rmtree> and C<remove_tree> will not work with
  multithreaded applications due to its use of C<chdir>.  At this time,
  no warning or error is generated in this situation.  You will
  certainly encounter unexpected results.
  
  The implementation that surfaces this limitation will not be changed. See the
  F<File::Path::Tiny> module for functionality similar to F<File::Path> but which does
  not C<chdir>.
  
  =head2 NFS Mount Points
  
  F<File::Path> is not responsible for triggering the automounts, mirror mounts,
  and the contents of network mounted filesystems.  If your NFS implementation
  requires an action to be performed on the filesystem in order for
  F<File::Path> to perform operations, it is strongly suggested you assure
  filesystem availability by reading the root of the mounted filesystem.
  
  =head2 REPORTING BUGS
  
  Please report all bugs on the RT queue, either via the web interface:
  
  L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=File-Path>
  
  or by email:
  
      bug-File-Path@rt.cpan.org
  
  In either case, please B<attach> patches to the bug report rather than
  including them inline in the web post or the body of the email.
  
  You can also send pull requests to the Github repository:
  
  L<https://github.com/rpcme/File-Path>
  
  =head1 ACKNOWLEDGEMENTS
  
  Paul Szabo identified the race condition originally, and Brendan
  O'Dea wrote an implementation for Debian that addressed the problem.
  That code was used as a basis for the current code. Their efforts
  are greatly appreciated.
  
  Gisle Aas made a number of improvements to the documentation for
  2.07 and his advice and assistance is also greatly appreciated.
  
  =head1 AUTHORS
  
  Prior authors and maintainers: Tim Bunce, Charles Bailey, and
  David Landgren <F<david@landgren.net>>.
  
  Current maintainers are Richard Elberger <F<riche@cpan.org>> and
  James (Jim) Keenan <F<jkeenan@cpan.org>>.
  
  =head1 CONTRIBUTORS
  
  Contributors to File::Path, in alphabetical order by first name.
  
  =over 1
  
  =item <F<bulkdd@cpan.org>>
  
  =item Charlie Gonzalez <F<itcharlie@cpan.org>>
  
  =item Craig A. Berry <F<craigberry@mac.com>>
  
  =item James E Keenan <F<jkeenan@cpan.org>>
  
  =item John Lightsey <F<john@perlsec.org>>
  
  =item Nigel Horne <F<njh@bandsman.co.uk>>
  
  =item Richard Elberger <F<riche@cpan.org>>
  
  =item Ryan Yee <F<ryee@cpan.org>>
  
  =item Skye Shaw <F<shaw@cpan.org>>
  
  =item Tom Lutz <F<tommylutz@gmail.com>>
  
  =item Will Sheppard <F<willsheppard@github>>
  
  =back
  
  =head1 COPYRIGHT
  
  This module is copyright (C) Charles Bailey, Tim Bunce, David Landgren,
  James Keenan and Richard Elberger 1995-2017. All rights reserved.
  
  =head1 LICENSE
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself.
  
  =cut
FILE_PATH

$fatpacked{"File/Temp.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'FILE_TEMP';
  package File::Temp;
  # ABSTRACT: return name and handle of a temporary file safely
  our $VERSION = '0.2304'; # VERSION
  
  
  # Toolchain targets v5.8.1, but we'll try to support back to v5.6 anyway.
  # It might be possible to make this v5.5, but many v5.6isms are creeping
  # into the code and tests.
  use 5.006;
  use strict;
  use Carp;
  use File::Spec 0.8;
  use Cwd ();
  use File::Path 2.06 qw/ rmtree /;
  use Fcntl 1.03;
  use IO::Seekable;               # For SEEK_*
  use Errno;
  use Scalar::Util 'refaddr';
  require VMS::Stdio if $^O eq 'VMS';
  
  # pre-emptively load Carp::Heavy. If we don't when we run out of file
  # handles and attempt to call croak() we get an error message telling
  # us that Carp::Heavy won't load rather than an error telling us we
  # have run out of file handles. We either preload croak() or we
  # switch the calls to croak from _gettemp() to use die.
  eval { require Carp::Heavy; };
  
  # Need the Symbol package if we are running older perl
  require Symbol if $] < 5.006;
  
  ### For the OO interface
  use parent 0.221 qw/ IO::Handle IO::Seekable /;
  use overload '""' => "STRINGIFY", '0+' => "NUMIFY",
    fallback => 1;
  
  # use 'our' on v5.6.0
  use vars qw(@EXPORT_OK %EXPORT_TAGS $DEBUG $KEEP_ALL);
  
  $DEBUG = 0;
  $KEEP_ALL = 0;
  
  # We are exporting functions
  
  use Exporter 5.57 'import';   # 5.57 lets us import 'import'
  
  # Export list - to allow fine tuning of export table
  
  @EXPORT_OK = qw{
                   tempfile
                   tempdir
                   tmpnam
                   tmpfile
                   mktemp
                   mkstemp
                   mkstemps
                   mkdtemp
                   unlink0
                   cleanup
                   SEEK_SET
                   SEEK_CUR
                   SEEK_END
               };
  
  # Groups of functions for export
  
  %EXPORT_TAGS = (
                  'POSIX' => [qw/ tmpnam tmpfile /],
                  'mktemp' => [qw/ mktemp mkstemp mkstemps mkdtemp/],
                  'seekable' => [qw/ SEEK_SET SEEK_CUR SEEK_END /],
                 );
  
  # add contents of these tags to @EXPORT
  Exporter::export_tags('POSIX','mktemp','seekable');
  
  # This is a list of characters that can be used in random filenames
  
  my @CHARS = (qw/ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
                   a b c d e f g h i j k l m n o p q r s t u v w x y z
                   0 1 2 3 4 5 6 7 8 9 _
                 /);
  
  # Maximum number of tries to make a temp file before failing
  
  use constant MAX_TRIES => 1000;
  
  # Minimum number of X characters that should be in a template
  use constant MINX => 4;
  
  # Default template when no template supplied
  
  use constant TEMPXXX => 'X' x 10;
  
  # Constants for the security level
  
  use constant STANDARD => 0;
  use constant MEDIUM   => 1;
  use constant HIGH     => 2;
  
  # OPENFLAGS. If we defined the flag to use with Sysopen here this gives
  # us an optimisation when many temporary files are requested
  
  my $OPENFLAGS = O_CREAT | O_EXCL | O_RDWR;
  my $LOCKFLAG;
  
  unless ($^O eq 'MacOS') {
    for my $oflag (qw/ NOFOLLOW BINARY LARGEFILE NOINHERIT /) {
      my ($bit, $func) = (0, "Fcntl::O_" . $oflag);
      no strict 'refs';
      $OPENFLAGS |= $bit if eval {
        # Make sure that redefined die handlers do not cause problems
        # e.g. CGI::Carp
        local $SIG{__DIE__} = sub {};
        local $SIG{__WARN__} = sub {};
        $bit = &$func();
        1;
      };
    }
    # Special case O_EXLOCK
    $LOCKFLAG = eval {
      local $SIG{__DIE__} = sub {};
      local $SIG{__WARN__} = sub {};
      &Fcntl::O_EXLOCK();
    };
  }
  
  # On some systems the O_TEMPORARY flag can be used to tell the OS
  # to automatically remove the file when it is closed. This is fine
  # in most cases but not if tempfile is called with UNLINK=>0 and
  # the filename is requested -- in the case where the filename is to
  # be passed to another routine. This happens on windows. We overcome
  # this by using a second open flags variable
  
  my $OPENTEMPFLAGS = $OPENFLAGS;
  unless ($^O eq 'MacOS') {
    for my $oflag (qw/ TEMPORARY /) {
      my ($bit, $func) = (0, "Fcntl::O_" . $oflag);
      local($@);
      no strict 'refs';
      $OPENTEMPFLAGS |= $bit if eval {
        # Make sure that redefined die handlers do not cause problems
        # e.g. CGI::Carp
        local $SIG{__DIE__} = sub {};
        local $SIG{__WARN__} = sub {};
        $bit = &$func();
        1;
      };
    }
  }
  
  # Private hash tracking which files have been created by each process id via the OO interface
  my %FILES_CREATED_BY_OBJECT;
  
  # INTERNAL ROUTINES - not to be used outside of package
  
  # Generic routine for getting a temporary filename
  # modelled on OpenBSD _gettemp() in mktemp.c
  
  # The template must contain X's that are to be replaced
  # with the random values
  
  #  Arguments:
  
  #  TEMPLATE   - string containing the XXXXX's that is converted
  #           to a random filename and opened if required
  
  # Optionally, a hash can also be supplied containing specific options
  #   "open" => if true open the temp file, else just return the name
  #             default is 0
  #   "mkdir"=> if true, we are creating a temp directory rather than tempfile
  #             default is 0
  #   "suffixlen" => number of characters at end of PATH to be ignored.
  #                  default is 0.
  #   "unlink_on_close" => indicates that, if possible,  the OS should remove
  #                        the file as soon as it is closed. Usually indicates
  #                        use of the O_TEMPORARY flag to sysopen.
  #                        Usually irrelevant on unix
  #   "use_exlock" => Indicates that O_EXLOCK should be used. Default is true.
  
  # Optionally a reference to a scalar can be passed into the function
  # On error this will be used to store the reason for the error
  #   "ErrStr"  => \$errstr
  
  # "open" and "mkdir" can not both be true
  # "unlink_on_close" is not used when "mkdir" is true.
  
  # The default options are equivalent to mktemp().
  
  # Returns:
  #   filehandle - open file handle (if called with doopen=1, else undef)
  #   temp name  - name of the temp file or directory
  
  # For example:
  #   ($fh, $name) = _gettemp($template, "open" => 1);
  
  # for the current version, failures are associated with
  # stored in an error string and returned to give the reason whilst debugging
  # This routine is not called by any external function
  sub _gettemp {
  
    croak 'Usage: ($fh, $name) = _gettemp($template, OPTIONS);'
      unless scalar(@_) >= 1;
  
    # the internal error string - expect it to be overridden
    # Need this in case the caller decides not to supply us a value
    # need an anonymous scalar
    my $tempErrStr;
  
    # Default options
    my %options = (
                   "open" => 0,
                   "mkdir" => 0,
                   "suffixlen" => 0,
                   "unlink_on_close" => 0,
                   "use_exlock" => 1,
                   "ErrStr" => \$tempErrStr,
                  );
  
    # Read the template
    my $template = shift;
    if (ref($template)) {
      # Use a warning here since we have not yet merged ErrStr
      carp "File::Temp::_gettemp: template must not be a reference";
      return ();
    }
  
    # Check that the number of entries on stack are even
    if (scalar(@_) % 2 != 0) {
      # Use a warning here since we have not yet merged ErrStr
      carp "File::Temp::_gettemp: Must have even number of options";
      return ();
    }
  
    # Read the options and merge with defaults
    %options = (%options, @_)  if @_;
  
    # Make sure the error string is set to undef
    ${$options{ErrStr}} = undef;
  
    # Can not open the file and make a directory in a single call
    if ($options{"open"} && $options{"mkdir"}) {
      ${$options{ErrStr}} = "doopen and domkdir can not both be true\n";
      return ();
    }
  
    # Find the start of the end of the  Xs (position of last X)
    # Substr starts from 0
    my $start = length($template) - 1 - $options{"suffixlen"};
  
    # Check that we have at least MINX x X (e.g. 'XXXX") at the end of the string
    # (taking suffixlen into account). Any fewer is insecure.
  
    # Do it using substr - no reason to use a pattern match since
    # we know where we are looking and what we are looking for
  
    if (substr($template, $start - MINX + 1, MINX) ne 'X' x MINX) {
      ${$options{ErrStr}} = "The template must end with at least ".
        MINX . " 'X' characters\n";
      return ();
    }
  
    # Replace all the X at the end of the substring with a
    # random character or just all the XX at the end of a full string.
    # Do it as an if, since the suffix adjusts which section to replace
    # and suffixlen=0 returns nothing if used in the substr directly
    # and generate a full path from the template
  
    my $path = _replace_XX($template, $options{"suffixlen"});
  
  
    # Split the path into constituent parts - eventually we need to check
    # whether the directory exists
    # We need to know whether we are making a temp directory
    # or a tempfile
  
    my ($volume, $directories, $file);
    my $parent;                   # parent directory
    if ($options{"mkdir"}) {
      # There is no filename at the end
      ($volume, $directories, $file) = File::Spec->splitpath( $path, 1);
  
      # The parent is then $directories without the last directory
      # Split the directory and put it back together again
      my @dirs = File::Spec->splitdir($directories);
  
      # If @dirs only has one entry (i.e. the directory template) that means
      # we are in the current directory
      if ($#dirs == 0) {
        $parent = File::Spec->curdir;
      } else {
  
        if ($^O eq 'VMS') {     # need volume to avoid relative dir spec
          $parent = File::Spec->catdir($volume, @dirs[0..$#dirs-1]);
          $parent = 'sys$disk:[]' if $parent eq '';
        } else {
  
          # Put it back together without the last one
          $parent = File::Spec->catdir(@dirs[0..$#dirs-1]);
  
          # ...and attach the volume (no filename)
          $parent = File::Spec->catpath($volume, $parent, '');
        }
  
      }
  
    } else {
  
      # Get rid of the last filename (use File::Basename for this?)
      ($volume, $directories, $file) = File::Spec->splitpath( $path );
  
      # Join up without the file part
      $parent = File::Spec->catpath($volume,$directories,'');
  
      # If $parent is empty replace with curdir
      $parent = File::Spec->curdir
        unless $directories ne '';
  
    }
  
    # Check that the parent directories exist
    # Do this even for the case where we are simply returning a name
    # not a file -- no point returning a name that includes a directory
    # that does not exist or is not writable
  
    unless (-e $parent) {
      ${$options{ErrStr}} = "Parent directory ($parent) does not exist";
      return ();
    }
    unless (-d $parent) {
      ${$options{ErrStr}} = "Parent directory ($parent) is not a directory";
      return ();
    }
  
    # Check the stickiness of the directory and chown giveaway if required
    # If the directory is world writable the sticky bit
    # must be set
  
    if (File::Temp->safe_level == MEDIUM) {
      my $safeerr;
      unless (_is_safe($parent,\$safeerr)) {
        ${$options{ErrStr}} = "Parent directory ($parent) is not safe ($safeerr)";
        return ();
      }
    } elsif (File::Temp->safe_level == HIGH) {
      my $safeerr;
      unless (_is_verysafe($parent, \$safeerr)) {
        ${$options{ErrStr}} = "Parent directory ($parent) is not safe ($safeerr)";
        return ();
      }
    }
  
  
    # Now try MAX_TRIES time to open the file
    for (my $i = 0; $i < MAX_TRIES; $i++) {
  
      # Try to open the file if requested
      if ($options{"open"}) {
        my $fh;
  
        # If we are running before perl5.6.0 we can not auto-vivify
        if ($] < 5.006) {
          $fh = &Symbol::gensym;
        }
  
        # Try to make sure this will be marked close-on-exec
        # XXX: Win32 doesn't respect this, nor the proper fcntl,
        #      but may have O_NOINHERIT. This may or may not be in Fcntl.
        local $^F = 2;
  
        # Attempt to open the file
        my $open_success = undef;
        if ( $^O eq 'VMS' and $options{"unlink_on_close"} && !$KEEP_ALL) {
          # make it auto delete on close by setting FAB$V_DLT bit
          $fh = VMS::Stdio::vmssysopen($path, $OPENFLAGS, 0600, 'fop=dlt');
          $open_success = $fh;
        } else {
          my $flags = ( ($options{"unlink_on_close"} && !$KEEP_ALL) ?
                        $OPENTEMPFLAGS :
                        $OPENFLAGS );
          $flags |= $LOCKFLAG if (defined $LOCKFLAG && $options{use_exlock});
          $open_success = sysopen($fh, $path, $flags, 0600);
        }
        if ( $open_success ) {
  
          # in case of odd umask force rw
          chmod(0600, $path);
  
          # Opened successfully - return file handle and name
          return ($fh, $path);
  
        } else {
  
          # Error opening file - abort with error
          # if the reason was anything but EEXIST
          unless ($!{EEXIST}) {
            ${$options{ErrStr}} = "Could not create temp file $path: $!";
            return ();
          }
  
          # Loop round for another try
  
        }
      } elsif ($options{"mkdir"}) {
  
        # Open the temp directory
        if (mkdir( $path, 0700)) {
          # in case of odd umask
          chmod(0700, $path);
  
          return undef, $path;
        } else {
  
          # Abort with error if the reason for failure was anything
          # except EEXIST
          unless ($!{EEXIST}) {
            ${$options{ErrStr}} = "Could not create directory $path: $!";
            return ();
          }
  
          # Loop round for another try
  
        }
  
      } else {
  
        # Return true if the file can not be found
        # Directory has been checked previously
  
        return (undef, $path) unless -e $path;
  
        # Try again until MAX_TRIES
  
      }
  
      # Did not successfully open the tempfile/dir
      # so try again with a different set of random letters
      # No point in trying to increment unless we have only
      # 1 X say and the randomness could come up with the same
      # file MAX_TRIES in a row.
  
      # Store current attempt - in principal this implies that the
      # 3rd time around the open attempt that the first temp file
      # name could be generated again. Probably should store each
      # attempt and make sure that none are repeated
  
      my $original = $path;
      my $counter = 0;            # Stop infinite loop
      my $MAX_GUESS = 50;
  
      do {
  
        # Generate new name from original template
        $path = _replace_XX($template, $options{"suffixlen"});
  
        $counter++;
  
      } until ($path ne $original || $counter > $MAX_GUESS);
  
      # Check for out of control looping
      if ($counter > $MAX_GUESS) {
        ${$options{ErrStr}} = "Tried to get a new temp name different to the previous value $MAX_GUESS times.\nSomething wrong with template?? ($template)";
        return ();
      }
  
    }
  
    # If we get here, we have run out of tries
    ${ $options{ErrStr} } = "Have exceeded the maximum number of attempts ("
      . MAX_TRIES . ") to open temp file/dir";
  
    return ();
  
  }
  
  # Internal routine to replace the XXXX... with random characters
  # This has to be done by _gettemp() every time it fails to
  # open a temp file/dir
  
  # Arguments:  $template (the template with XXX),
  #             $ignore   (number of characters at end to ignore)
  
  # Returns:    modified template
  
  sub _replace_XX {
  
    croak 'Usage: _replace_XX($template, $ignore)'
      unless scalar(@_) == 2;
  
    my ($path, $ignore) = @_;
  
    # Do it as an if, since the suffix adjusts which section to replace
    # and suffixlen=0 returns nothing if used in the substr directly
    # Alternatively, could simply set $ignore to length($path)-1
    # Don't want to always use substr when not required though.
    my $end = ( $] >= 5.006 ? "\\z" : "\\Z" );
  
    if ($ignore) {
      substr($path, 0, - $ignore) =~ s/X(?=X*$end)/$CHARS[ int( rand( @CHARS ) ) ]/ge;
    } else {
      $path =~ s/X(?=X*$end)/$CHARS[ int( rand( @CHARS ) ) ]/ge;
    }
    return $path;
  }
  
  # Internal routine to force a temp file to be writable after
  # it is created so that we can unlink it. Windows seems to occasionally
  # force a file to be readonly when written to certain temp locations
  sub _force_writable {
    my $file = shift;
    chmod 0600, $file;
  }
  
  
  # internal routine to check to see if the directory is safe
  # First checks to see if the directory is not owned by the
  # current user or root. Then checks to see if anyone else
  # can write to the directory and if so, checks to see if
  # it has the sticky bit set
  
  # Will not work on systems that do not support sticky bit
  
  #Args:  directory path to check
  #       Optionally: reference to scalar to contain error message
  # Returns true if the path is safe and false otherwise.
  # Returns undef if can not even run stat() on the path
  
  # This routine based on version written by Tom Christiansen
  
  # Presumably, by the time we actually attempt to create the
  # file or directory in this directory, it may not be safe
  # anymore... Have to run _is_safe directly after the open.
  
  sub _is_safe {
  
    my $path = shift;
    my $err_ref = shift;
  
    # Stat path
    my @info = stat($path);
    unless (scalar(@info)) {
      $$err_ref = "stat(path) returned no values";
      return 0;
    }
    ;
    return 1 if $^O eq 'VMS';     # owner delete control at file level
  
    # Check to see whether owner is neither superuser (or a system uid) nor me
    # Use the effective uid from the $> variable
    # UID is in [4]
    if ($info[4] > File::Temp->top_system_uid() && $info[4] != $>) {
  
      Carp::cluck(sprintf "uid=$info[4] topuid=%s euid=$> path='$path'",
                  File::Temp->top_system_uid());
  
      $$err_ref = "Directory owned neither by root nor the current user"
        if ref($err_ref);
      return 0;
    }
  
    # check whether group or other can write file
    # use 066 to detect either reading or writing
    # use 022 to check writability
    # Do it with S_IWOTH and S_IWGRP for portability (maybe)
    # mode is in info[2]
    if (($info[2] & &Fcntl::S_IWGRP) ||  # Is group writable?
        ($info[2] & &Fcntl::S_IWOTH) ) { # Is world writable?
      # Must be a directory
      unless (-d $path) {
        $$err_ref = "Path ($path) is not a directory"
          if ref($err_ref);
        return 0;
      }
      # Must have sticky bit set
      unless (-k $path) {
        $$err_ref = "Sticky bit not set on $path when dir is group|world writable"
          if ref($err_ref);
        return 0;
      }
    }
  
    return 1;
  }
  
  # Internal routine to check whether a directory is safe
  # for temp files. Safer than _is_safe since it checks for
  # the possibility of chown giveaway and if that is a possibility
  # checks each directory in the path to see if it is safe (with _is_safe)
  
  # If _PC_CHOWN_RESTRICTED is not set, does the full test of each
  # directory anyway.
  
  # Takes optional second arg as scalar ref to error reason
  
  sub _is_verysafe {
  
    # Need POSIX - but only want to bother if really necessary due to overhead
    require POSIX;
  
    my $path = shift;
    print "_is_verysafe testing $path\n" if $DEBUG;
    return 1 if $^O eq 'VMS';     # owner delete control at file level
  
    my $err_ref = shift;
  
    # Should Get the value of _PC_CHOWN_RESTRICTED if it is defined
    # and If it is not there do the extensive test
    local($@);
    my $chown_restricted;
    $chown_restricted = &POSIX::_PC_CHOWN_RESTRICTED()
      if eval { &POSIX::_PC_CHOWN_RESTRICTED(); 1};
  
    # If chown_resticted is set to some value we should test it
    if (defined $chown_restricted) {
  
      # Return if the current directory is safe
      return _is_safe($path,$err_ref) if POSIX::sysconf( $chown_restricted );
  
    }
  
    # To reach this point either, the _PC_CHOWN_RESTRICTED symbol
    # was not available or the symbol was there but chown giveaway
    # is allowed. Either way, we now have to test the entire tree for
    # safety.
  
    # Convert path to an absolute directory if required
    unless (File::Spec->file_name_is_absolute($path)) {
      $path = File::Spec->rel2abs($path);
    }
  
    # Split directory into components - assume no file
    my ($volume, $directories, undef) = File::Spec->splitpath( $path, 1);
  
    # Slightly less efficient than having a function in File::Spec
    # to chop off the end of a directory or even a function that
    # can handle ../ in a directory tree
    # Sometimes splitdir() returns a blank at the end
    # so we will probably check the bottom directory twice in some cases
    my @dirs = File::Spec->splitdir($directories);
  
    # Concatenate one less directory each time around
    foreach my $pos (0.. $#dirs) {
      # Get a directory name
      my $dir = File::Spec->catpath($volume,
                                    File::Spec->catdir(@dirs[0.. $#dirs - $pos]),
                                    ''
                                   );
  
      print "TESTING DIR $dir\n" if $DEBUG;
  
      # Check the directory
      return 0 unless _is_safe($dir,$err_ref);
  
    }
  
    return 1;
  }
  
  
  
  # internal routine to determine whether unlink works on this
  # platform for files that are currently open.
  # Returns true if we can, false otherwise.
  
  # Currently WinNT, OS/2 and VMS can not unlink an opened file
  # On VMS this is because the O_EXCL flag is used to open the
  # temporary file. Currently I do not know enough about the issues
  # on VMS to decide whether O_EXCL is a requirement.
  
  sub _can_unlink_opened_file {
  
    if (grep { $^O eq $_ } qw/MSWin32 os2 VMS dos MacOS haiku/) {
      return 0;
    } else {
      return 1;
    }
  
  }
  
  # internal routine to decide which security levels are allowed
  # see safe_level() for more information on this
  
  # Controls whether the supplied security level is allowed
  
  #   $cando = _can_do_level( $level )
  
  sub _can_do_level {
  
    # Get security level
    my $level = shift;
  
    # Always have to be able to do STANDARD
    return 1 if $level == STANDARD;
  
    # Currently, the systems that can do HIGH or MEDIUM are identical
    if ( $^O eq 'MSWin32' || $^O eq 'os2' || $^O eq 'cygwin' || $^O eq 'dos' || $^O eq 'MacOS' || $^O eq 'mpeix') {
      return 0;
    } else {
      return 1;
    }
  
  }
  
  # This routine sets up a deferred unlinking of a specified
  # filename and filehandle. It is used in the following cases:
  #  - Called by unlink0 if an opened file can not be unlinked
  #  - Called by tempfile() if files are to be removed on shutdown
  #  - Called by tempdir() if directories are to be removed on shutdown
  
  # Arguments:
  #   _deferred_unlink( $fh, $fname, $isdir );
  #
  #   - filehandle (so that it can be explicitly closed if open
  #   - filename   (the thing we want to remove)
  #   - isdir      (flag to indicate that we are being given a directory)
  #                 [and hence no filehandle]
  
  # Status is not referred to since all the magic is done with an END block
  
  {
    # Will set up two lexical variables to contain all the files to be
    # removed. One array for files, another for directories They will
    # only exist in this block.
  
    #  This means we only have to set up a single END block to remove
    #  all files. 
  
    # in order to prevent child processes inadvertently deleting the parent
    # temp files we use a hash to store the temp files and directories
    # created by a particular process id.
  
    # %files_to_unlink contains values that are references to an array of
    # array references containing the filehandle and filename associated with
    # the temp file.
    my (%files_to_unlink, %dirs_to_unlink);
  
    # Set up an end block to use these arrays
    END {
      local($., $@, $!, $^E, $?);
      cleanup(at_exit => 1);
    }
  
    # Cleanup function. Always triggered on END (with at_exit => 1) but
    # can be invoked manually.
    sub cleanup {
      my %h = @_;
      my $at_exit = delete $h{at_exit};
      $at_exit = 0 if not defined $at_exit;
      { my @k = sort keys %h; die "unrecognized parameters: @k" if @k }
  
      if (!$KEEP_ALL) {
        # Files
        my @files = (exists $files_to_unlink{$$} ?
                     @{ $files_to_unlink{$$} } : () );
        foreach my $file (@files) {
          # close the filehandle without checking its state
          # in order to make real sure that this is closed
          # if its already closed then I don't care about the answer
          # probably a better way to do this
          close($file->[0]);      # file handle is [0]
  
          if (-f $file->[1]) {       # file name is [1]
            _force_writable( $file->[1] ); # for windows
            unlink $file->[1] or warn "Error removing ".$file->[1];
          }
        }
        # Dirs
        my @dirs = (exists $dirs_to_unlink{$$} ?
                    @{ $dirs_to_unlink{$$} } : () );
        my ($cwd, $cwd_to_remove);
        foreach my $dir (@dirs) {
          if (-d $dir) {
            # Some versions of rmtree will abort if you attempt to remove
            # the directory you are sitting in. For automatic cleanup
            # at program exit, we avoid this by chdir()ing out of the way
            # first. If not at program exit, it's best not to mess with the
            # current directory, so just let it fail with a warning.
            if ($at_exit) {
              $cwd = Cwd::abs_path(File::Spec->curdir) if not defined $cwd;
              my $abs = Cwd::abs_path($dir);
              if ($abs eq $cwd) {
                $cwd_to_remove = $dir;
                next;
              }
            }
            eval { rmtree($dir, $DEBUG, 0); };
            warn $@ if ($@ && $^W);
          }
        }
  
        if (defined $cwd_to_remove) {
          # We do need to clean up the current directory, and everything
          # else is done, so get out of there and remove it.
          chdir $cwd_to_remove or die "cannot chdir to $cwd_to_remove: $!";
          my $updir = File::Spec->updir;
          chdir $updir or die "cannot chdir to $updir: $!";
          eval { rmtree($cwd_to_remove, $DEBUG, 0); };
          warn $@ if ($@ && $^W);
        }
  
        # clear the arrays
        @{ $files_to_unlink{$$} } = ()
          if exists $files_to_unlink{$$};
        @{ $dirs_to_unlink{$$} } = ()
          if exists $dirs_to_unlink{$$};
      }
    }
  
  
    # This is the sub called to register a file for deferred unlinking
    # This could simply store the input parameters and defer everything
    # until the END block. For now we do a bit of checking at this
    # point in order to make sure that (1) we have a file/dir to delete
    # and (2) we have been called with the correct arguments.
    sub _deferred_unlink {
  
      croak 'Usage:  _deferred_unlink($fh, $fname, $isdir)'
        unless scalar(@_) == 3;
  
      my ($fh, $fname, $isdir) = @_;
  
      warn "Setting up deferred removal of $fname\n"
        if $DEBUG;
  
      # make sure we save the absolute path for later cleanup
      # OK to untaint because we only ever use this internally
      # as a file path, never interpolating into the shell
      $fname = Cwd::abs_path($fname);
      ($fname) = $fname =~ /^(.*)$/;
  
      # If we have a directory, check that it is a directory
      if ($isdir) {
  
        if (-d $fname) {
  
          # Directory exists so store it
          # first on VMS turn []foo into [.foo] for rmtree
          $fname = VMS::Filespec::vmspath($fname) if $^O eq 'VMS';
          $dirs_to_unlink{$$} = [] 
            unless exists $dirs_to_unlink{$$};
          push (@{ $dirs_to_unlink{$$} }, $fname);
  
        } else {
          carp "Request to remove directory $fname could not be completed since it does not exist!\n" if $^W;
        }
  
      } else {
  
        if (-f $fname) {
  
          # file exists so store handle and name for later removal
          $files_to_unlink{$$} = []
            unless exists $files_to_unlink{$$};
          push(@{ $files_to_unlink{$$} }, [$fh, $fname]);
  
        } else {
          carp "Request to remove file $fname could not be completed since it is not there!\n" if $^W;
        }
  
      }
  
    }
  
  
  }
  
  # normalize argument keys to upper case and do consistent handling
  # of leading template vs TEMPLATE
  sub _parse_args {
    my $leading_template = (scalar(@_) % 2 == 1 ? shift(@_) : '' );
    my %args = @_;
    %args = map { uc($_), $args{$_} } keys %args;
  
    # template (store it in an array so that it will
    # disappear from the arg list of tempfile)
    my @template = (
      exists $args{TEMPLATE}  ? $args{TEMPLATE} :
      $leading_template       ? $leading_template : ()
    );
    delete $args{TEMPLATE};
  
    return( \@template, \%args );
  }
  
  
  sub new {
    my $proto = shift;
    my $class = ref($proto) || $proto;
  
    my ($maybe_template, $args) = _parse_args(@_);
  
    # see if they are unlinking (defaulting to yes)
    my $unlink = (exists $args->{UNLINK} ? $args->{UNLINK} : 1 );
    delete $args->{UNLINK};
  
    # Protect OPEN
    delete $args->{OPEN};
  
    # Open the file and retain file handle and file name
    my ($fh, $path) = tempfile( @$maybe_template, %$args );
  
    print "Tmp: $fh - $path\n" if $DEBUG;
  
    # Store the filename in the scalar slot
    ${*$fh} = $path;
  
    # Cache the filename by pid so that the destructor can decide whether to remove it
    $FILES_CREATED_BY_OBJECT{$$}{$path} = 1;
  
    # Store unlink information in hash slot (plus other constructor info)
    %{*$fh} = %$args;
  
    # create the object
    bless $fh, $class;
  
    # final method-based configuration
    $fh->unlink_on_destroy( $unlink );
  
    return $fh;
  }
  
  
  sub newdir {
    my $self = shift;
  
    my ($maybe_template, $args) = _parse_args(@_);
  
    # handle CLEANUP without passing CLEANUP to tempdir
    my $cleanup = (exists $args->{CLEANUP} ? $args->{CLEANUP} : 1 );
    delete $args->{CLEANUP};
  
    my $tempdir = tempdir( @$maybe_template, %$args);
  
    # get a safe absolute path for cleanup, just like
    # happens in _deferred_unlink
    my $real_dir = Cwd::abs_path( $tempdir );
    ($real_dir) = $real_dir =~ /^(.*)$/;
  
    return bless { DIRNAME => $tempdir,
                   REALNAME => $real_dir,
                   CLEANUP => $cleanup,
                   LAUNCHPID => $$,
                 }, "File::Temp::Dir";
  }
  
  
  sub filename {
    my $self = shift;
    return ${*$self};
  }
  
  sub STRINGIFY {
    my $self = shift;
    return $self->filename;
  }
  
  # For reference, can't use '0+'=>\&Scalar::Util::refaddr directly because
  # refaddr() demands one parameter only, whereas overload.pm calls with three
  # even for unary operations like '0+'.
  sub NUMIFY {
    return refaddr($_[0]);
  }
  
  
  sub unlink_on_destroy {
    my $self = shift;
    if (@_) {
      ${*$self}{UNLINK} = shift;
    }
    return ${*$self}{UNLINK};
  }
  
  
  sub DESTROY {
    local($., $@, $!, $^E, $?);
    my $self = shift;
  
    # Make sure we always remove the file from the global hash
    # on destruction. This prevents the hash from growing uncontrollably
    # and post-destruction there is no reason to know about the file.
    my $file = $self->filename;
    my $was_created_by_proc;
    if (exists $FILES_CREATED_BY_OBJECT{$$}{$file}) {
      $was_created_by_proc = 1;
      delete $FILES_CREATED_BY_OBJECT{$$}{$file};
    }
  
    if (${*$self}{UNLINK} && !$KEEP_ALL) {
      print "# --------->   Unlinking $self\n" if $DEBUG;
  
      # only delete if this process created it
      return unless $was_created_by_proc;
  
      # The unlink1 may fail if the file has been closed
      # by the caller. This leaves us with the decision
      # of whether to refuse to remove the file or simply
      # do an unlink without test. Seems to be silly
      # to do this when we are trying to be careful
      # about security
      _force_writable( $file ); # for windows
      unlink1( $self, $file )
        or unlink($file);
    }
  }
  
  
  sub tempfile {
    if ( @_ && $_[0] eq 'File::Temp' ) {
        croak "'tempfile' can't be called as a method";
    }
    # Can not check for argument count since we can have any
    # number of args
  
    # Default options
    my %options = (
                   "DIR"    => undef, # Directory prefix
                   "SUFFIX" => '',    # Template suffix
                   "UNLINK" => 0,     # Do not unlink file on exit
                   "OPEN"   => 1,     # Open file
                   "TMPDIR" => 0, # Place tempfile in tempdir if template specified
                   "EXLOCK" => 1, # Open file with O_EXLOCK
                  );
  
    # Check to see whether we have an odd or even number of arguments
    my ($maybe_template, $args) = _parse_args(@_);
    my $template = @$maybe_template ? $maybe_template->[0] : undef;
  
    # Read the options and merge with defaults
    %options = (%options, %$args);
  
    # First decision is whether or not to open the file
    if (! $options{"OPEN"}) {
  
      warn "tempfile(): temporary filename requested but not opened.\nPossibly unsafe, consider using tempfile() with OPEN set to true\n"
        if $^W;
  
    }
  
    if ($options{"DIR"} and $^O eq 'VMS') {
  
      # on VMS turn []foo into [.foo] for concatenation
      $options{"DIR"} = VMS::Filespec::vmspath($options{"DIR"});
    }
  
    # Construct the template
  
    # Have a choice of trying to work around the mkstemp/mktemp/tmpnam etc
    # functions or simply constructing a template and using _gettemp()
    # explicitly. Go for the latter
  
    # First generate a template if not defined and prefix the directory
    # If no template must prefix the temp directory
    if (defined $template) {
      # End up with current directory if neither DIR not TMPDIR are set
      if ($options{"DIR"}) {
  
        $template = File::Spec->catfile($options{"DIR"}, $template);
  
      } elsif ($options{TMPDIR}) {
  
        $template = File::Spec->catfile(File::Spec->tmpdir, $template );
  
      }
  
    } else {
  
      if ($options{"DIR"}) {
  
        $template = File::Spec->catfile($options{"DIR"}, TEMPXXX);
  
      } else {
  
        $template = File::Spec->catfile(File::Spec->tmpdir, TEMPXXX);
  
      }
  
    }
  
    # Now add a suffix
    $template .= $options{"SUFFIX"};
  
    # Determine whether we should tell _gettemp to unlink the file
    # On unix this is irrelevant and can be worked out after the file is
    # opened (simply by unlinking the open filehandle). On Windows or VMS
    # we have to indicate temporary-ness when we open the file. In general
    # we only want a true temporary file if we are returning just the
    # filehandle - if the user wants the filename they probably do not
    # want the file to disappear as soon as they close it (which may be
    # important if they want a child process to use the file)
    # For this reason, tie unlink_on_close to the return context regardless
    # of OS.
    my $unlink_on_close = ( wantarray ? 0 : 1);
  
    # Create the file
    my ($fh, $path, $errstr);
    croak "Error in tempfile() using template $template: $errstr"
      unless (($fh, $path) = _gettemp($template,
                                      "open" => $options{'OPEN'},
                                      "mkdir"=> 0 ,
                                      "unlink_on_close" => $unlink_on_close,
                                      "suffixlen" => length($options{'SUFFIX'}),
                                      "ErrStr" => \$errstr,
                                      "use_exlock" => $options{EXLOCK},
                                     ) );
  
    # Set up an exit handler that can do whatever is right for the
    # system. This removes files at exit when requested explicitly or when
    # system is asked to unlink_on_close but is unable to do so because
    # of OS limitations.
    # The latter should be achieved by using a tied filehandle.
    # Do not check return status since this is all done with END blocks.
    _deferred_unlink($fh, $path, 0) if $options{"UNLINK"};
  
    # Return
    if (wantarray()) {
  
      if ($options{'OPEN'}) {
        return ($fh, $path);
      } else {
        return (undef, $path);
      }
  
    } else {
  
      # Unlink the file. It is up to unlink0 to decide what to do with
      # this (whether to unlink now or to defer until later)
      unlink0($fh, $path) or croak "Error unlinking file $path using unlink0";
  
      # Return just the filehandle.
      return $fh;
    }
  
  
  }
  
  
  # '
  
  sub tempdir  {
    if ( @_ && $_[0] eq 'File::Temp' ) {
        croak "'tempdir' can't be called as a method";
    }
  
    # Can not check for argument count since we can have any
    # number of args
  
    # Default options
    my %options = (
                   "CLEANUP"    => 0, # Remove directory on exit
                   "DIR"        => '', # Root directory
                   "TMPDIR"     => 0,  # Use tempdir with template
                  );
  
    # Check to see whether we have an odd or even number of arguments
    my ($maybe_template, $args) = _parse_args(@_);
    my $template = @$maybe_template ? $maybe_template->[0] : undef;
  
    # Read the options and merge with defaults
    %options = (%options, %$args);
  
    # Modify or generate the template
  
    # Deal with the DIR and TMPDIR options
    if (defined $template) {
  
      # Need to strip directory path if using DIR or TMPDIR
      if ($options{'TMPDIR'} || $options{'DIR'}) {
  
        # Strip parent directory from the filename
        #
        # There is no filename at the end
        $template = VMS::Filespec::vmspath($template) if $^O eq 'VMS';
        my ($volume, $directories, undef) = File::Spec->splitpath( $template, 1);
  
        # Last directory is then our template
        $template = (File::Spec->splitdir($directories))[-1];
  
        # Prepend the supplied directory or temp dir
        if ($options{"DIR"}) {
  
          $template = File::Spec->catdir($options{"DIR"}, $template);
  
        } elsif ($options{TMPDIR}) {
  
          # Prepend tmpdir
          $template = File::Spec->catdir(File::Spec->tmpdir, $template);
  
        }
  
      }
  
    } else {
  
      if ($options{"DIR"}) {
  
        $template = File::Spec->catdir($options{"DIR"}, TEMPXXX);
  
      } else {
  
        $template = File::Spec->catdir(File::Spec->tmpdir, TEMPXXX);
  
      }
  
    }
  
    # Create the directory
    my $tempdir;
    my $suffixlen = 0;
    if ($^O eq 'VMS') {           # dir names can end in delimiters
      $template =~ m/([\.\]:>]+)$/;
      $suffixlen = length($1);
    }
    if ( ($^O eq 'MacOS') && (substr($template, -1) eq ':') ) {
      # dir name has a trailing ':'
      ++$suffixlen;
    }
  
    my $errstr;
    croak "Error in tempdir() using $template: $errstr"
      unless ((undef, $tempdir) = _gettemp($template,
                                           "open" => 0,
                                           "mkdir"=> 1 ,
                                           "suffixlen" => $suffixlen,
                                           "ErrStr" => \$errstr,
                                          ) );
  
    # Install exit handler; must be dynamic to get lexical
    if ( $options{'CLEANUP'} && -d $tempdir) {
      _deferred_unlink(undef, $tempdir, 1);
    }
  
    # Return the dir name
    return $tempdir;
  
  }
  
  
  
  
  sub mkstemp {
  
    croak "Usage: mkstemp(template)"
      if scalar(@_) != 1;
  
    my $template = shift;
  
    my ($fh, $path, $errstr);
    croak "Error in mkstemp using $template: $errstr"
      unless (($fh, $path) = _gettemp($template,
                                      "open" => 1,
                                      "mkdir"=> 0 ,
                                      "suffixlen" => 0,
                                      "ErrStr" => \$errstr,
                                     ) );
  
    if (wantarray()) {
      return ($fh, $path);
    } else {
      return $fh;
    }
  
  }
  
  
  
  sub mkstemps {
  
    croak "Usage: mkstemps(template, suffix)"
      if scalar(@_) != 2;
  
  
    my $template = shift;
    my $suffix   = shift;
  
    $template .= $suffix;
  
    my ($fh, $path, $errstr);
    croak "Error in mkstemps using $template: $errstr"
      unless (($fh, $path) = _gettemp($template,
                                      "open" => 1,
                                      "mkdir"=> 0 ,
                                      "suffixlen" => length($suffix),
                                      "ErrStr" => \$errstr,
                                     ) );
  
    if (wantarray()) {
      return ($fh, $path);
    } else {
      return $fh;
    }
  
  }
  
  
  #' # for emacs
  
  sub mkdtemp {
  
    croak "Usage: mkdtemp(template)"
      if scalar(@_) != 1;
  
    my $template = shift;
    my $suffixlen = 0;
    if ($^O eq 'VMS') {           # dir names can end in delimiters
      $template =~ m/([\.\]:>]+)$/;
      $suffixlen = length($1);
    }
    if ( ($^O eq 'MacOS') && (substr($template, -1) eq ':') ) {
      # dir name has a trailing ':'
      ++$suffixlen;
    }
    my ($junk, $tmpdir, $errstr);
    croak "Error creating temp directory from template $template\: $errstr"
      unless (($junk, $tmpdir) = _gettemp($template,
                                          "open" => 0,
                                          "mkdir"=> 1 ,
                                          "suffixlen" => $suffixlen,
                                          "ErrStr" => \$errstr,
                                         ) );
  
    return $tmpdir;
  
  }
  
  
  sub mktemp {
  
    croak "Usage: mktemp(template)"
      if scalar(@_) != 1;
  
    my $template = shift;
  
    my ($tmpname, $junk, $errstr);
    croak "Error getting name to temp file from template $template: $errstr"
      unless (($junk, $tmpname) = _gettemp($template,
                                           "open" => 0,
                                           "mkdir"=> 0 ,
                                           "suffixlen" => 0,
                                           "ErrStr" => \$errstr,
                                          ) );
  
    return $tmpname;
  }
  
  
  sub tmpnam {
  
    # Retrieve the temporary directory name
    my $tmpdir = File::Spec->tmpdir;
  
    croak "Error temporary directory is not writable"
      if $tmpdir eq '';
  
    # Use a ten character template and append to tmpdir
    my $template = File::Spec->catfile($tmpdir, TEMPXXX);
  
    if (wantarray() ) {
      return mkstemp($template);
    } else {
      return mktemp($template);
    }
  
  }
  
  
  sub tmpfile {
  
    # Simply call tmpnam() in a list context
    my ($fh, $file) = tmpnam();
  
    # Make sure file is removed when filehandle is closed
    # This will fail on NFS
    unlink0($fh, $file)
      or return undef;
  
    return $fh;
  
  }
  
  
  sub tempnam {
  
    croak 'Usage tempnam($dir, $prefix)' unless scalar(@_) == 2;
  
    my ($dir, $prefix) = @_;
  
    # Add a string to the prefix
    $prefix .= 'XXXXXXXX';
  
    # Concatenate the directory to the file
    my $template = File::Spec->catfile($dir, $prefix);
  
    return mktemp($template);
  
  }
  
  
  sub unlink0 {
  
    croak 'Usage: unlink0(filehandle, filename)'
      unless scalar(@_) == 2;
  
    # Read args
    my ($fh, $path) = @_;
  
    cmpstat($fh, $path) or return 0;
  
    # attempt remove the file (does not work on some platforms)
    if (_can_unlink_opened_file()) {
  
      # return early (Without unlink) if we have been instructed to retain files.
      return 1 if $KEEP_ALL;
  
      # XXX: do *not* call this on a directory; possible race
      #      resulting in recursive removal
      croak "unlink0: $path has become a directory!" if -d $path;
      unlink($path) or return 0;
  
      # Stat the filehandle
      my @fh = stat $fh;
  
      print "Link count = $fh[3] \n" if $DEBUG;
  
      # Make sure that the link count is zero
      # - Cygwin provides deferred unlinking, however,
      #   on Win9x the link count remains 1
      # On NFS the link count may still be 1 but we can't know that
      # we are on NFS.  Since we can't be sure, we'll defer it
  
      return 1 if $fh[3] == 0 || $^O eq 'cygwin';
    }
    # fall-through if we can't unlink now
    _deferred_unlink($fh, $path, 0);
    return 1;
  }
  
  
  sub cmpstat {
  
    croak 'Usage: cmpstat(filehandle, filename)'
      unless scalar(@_) == 2;
  
    # Read args
    my ($fh, $path) = @_;
  
    warn "Comparing stat\n"
      if $DEBUG;
  
    # Stat the filehandle - which may be closed if someone has manually
    # closed the file. Can not turn off warnings without using $^W
    # unless we upgrade to 5.006 minimum requirement
    my @fh;
    {
      local ($^W) = 0;
      @fh = stat $fh;
    }
    return unless @fh;
  
    if ($fh[3] > 1 && $^W) {
      carp "unlink0: fstat found too many links; SB=@fh" if $^W;
    }
  
    # Stat the path
    my @path = stat $path;
  
    unless (@path) {
      carp "unlink0: $path is gone already" if $^W;
      return;
    }
  
    # this is no longer a file, but may be a directory, or worse
    unless (-f $path) {
      confess "panic: $path is no longer a file: SB=@fh";
    }
  
    # Do comparison of each member of the array
    # On WinNT dev and rdev seem to be different
    # depending on whether it is a file or a handle.
    # Cannot simply compare all members of the stat return
    # Select the ones we can use
    my @okstat = (0..$#fh);       # Use all by default
    if ($^O eq 'MSWin32') {
      @okstat = (1,2,3,4,5,7,8,9,10);
    } elsif ($^O eq 'os2') {
      @okstat = (0, 2..$#fh);
    } elsif ($^O eq 'VMS') {      # device and file ID are sufficient
      @okstat = (0, 1);
    } elsif ($^O eq 'dos') {
      @okstat = (0,2..7,11..$#fh);
    } elsif ($^O eq 'mpeix') {
      @okstat = (0..4,8..10);
    }
  
    # Now compare each entry explicitly by number
    for (@okstat) {
      print "Comparing: $_ : $fh[$_] and $path[$_]\n" if $DEBUG;
      # Use eq rather than == since rdev, blksize, and blocks (6, 11,
      # and 12) will be '' on platforms that do not support them.  This
      # is fine since we are only comparing integers.
      unless ($fh[$_] eq $path[$_]) {
        warn "Did not match $_ element of stat\n" if $DEBUG;
        return 0;
      }
    }
  
    return 1;
  }
  
  
  sub unlink1 {
    croak 'Usage: unlink1(filehandle, filename)'
      unless scalar(@_) == 2;
  
    # Read args
    my ($fh, $path) = @_;
  
    cmpstat($fh, $path) or return 0;
  
    # Close the file
    close( $fh ) or return 0;
  
    # Make sure the file is writable (for windows)
    _force_writable( $path );
  
    # return early (without unlink) if we have been instructed to retain files.
    return 1 if $KEEP_ALL;
  
    # remove the file
    return unlink($path);
  }
  
  
  {
    # protect from using the variable itself
    my $LEVEL = STANDARD;
    sub safe_level {
      my $self = shift;
      if (@_) {
        my $level = shift;
        if (($level != STANDARD) && ($level != MEDIUM) && ($level != HIGH)) {
          carp "safe_level: Specified level ($level) not STANDARD, MEDIUM or HIGH - ignoring\n" if $^W;
        } else {
          # Don't allow this on perl 5.005 or earlier
          if ($] < 5.006 && $level != STANDARD) {
            # Cant do MEDIUM or HIGH checks
            croak "Currently requires perl 5.006 or newer to do the safe checks";
          }
          # Check that we are allowed to change level
          # Silently ignore if we can not.
          $LEVEL = $level if _can_do_level($level);
        }
      }
      return $LEVEL;
    }
  }
  
  
  {
    my $TopSystemUID = 10;
    $TopSystemUID = 197108 if $^O eq 'interix'; # "Administrator"
    sub top_system_uid {
      my $self = shift;
      if (@_) {
        my $newuid = shift;
        croak "top_system_uid: UIDs should be numeric"
          unless $newuid =~ /^\d+$/s;
        $TopSystemUID = $newuid;
      }
      return $TopSystemUID;
    }
  }
  
  
  package File::Temp::Dir;
  
  use File::Path qw/ rmtree /;
  use strict;
  use overload '""' => "STRINGIFY",
    '0+' => \&File::Temp::NUMIFY,
    fallback => 1;
  
  # private class specifically to support tempdir objects
  # created by File::Temp->newdir
  
  # ostensibly the same method interface as File::Temp but without
  # inheriting all the IO::Seekable methods and other cruft
  
  # Read-only - returns the name of the temp directory
  
  sub dirname {
    my $self = shift;
    return $self->{DIRNAME};
  }
  
  sub STRINGIFY {
    my $self = shift;
    return $self->dirname;
  }
  
  sub unlink_on_destroy {
    my $self = shift;
    if (@_) {
      $self->{CLEANUP} = shift;
    }
    return $self->{CLEANUP};
  }
  
  sub DESTROY {
    my $self = shift;
    local($., $@, $!, $^E, $?);
    if ($self->unlink_on_destroy && 
        $$ == $self->{LAUNCHPID} && !$File::Temp::KEEP_ALL) {
      if (-d $self->{REALNAME}) {
        # Some versions of rmtree will abort if you attempt to remove
        # the directory you are sitting in. We protect that and turn it
        # into a warning. We do this because this occurs during object
        # destruction and so can not be caught by the user.
        eval { rmtree($self->{REALNAME}, $File::Temp::DEBUG, 0); };
        warn $@ if ($@ && $^W);
      }
    }
  }
  
  1;
  
  __END__
  
  =pod
  
  =encoding utf-8
  
  =head1 NAME
  
  File::Temp - return name and handle of a temporary file safely
  
  =head1 VERSION
  
  version 0.2304
  
  =head1 SYNOPSIS
  
    use File::Temp qw/ tempfile tempdir /;
  
    $fh = tempfile();
    ($fh, $filename) = tempfile();
  
    ($fh, $filename) = tempfile( $template, DIR => $dir);
    ($fh, $filename) = tempfile( $template, SUFFIX => '.dat');
    ($fh, $filename) = tempfile( $template, TMPDIR => 1 );
  
    binmode( $fh, ":utf8" );
  
    $dir = tempdir( CLEANUP => 1 );
    ($fh, $filename) = tempfile( DIR => $dir );
  
  Object interface:
  
    require File::Temp;
    use File::Temp ();
    use File::Temp qw/ :seekable /;
  
    $fh = File::Temp->new();
    $fname = $fh->filename;
  
    $fh = File::Temp->new(TEMPLATE => $template);
    $fname = $fh->filename;
  
    $tmp = File::Temp->new( UNLINK => 0, SUFFIX => '.dat' );
    print $tmp "Some data\n";
    print "Filename is $tmp\n";
    $tmp->seek( 0, SEEK_END );
  
  The following interfaces are provided for compatibility with
  existing APIs. They should not be used in new code.
  
  MkTemp family:
  
    use File::Temp qw/ :mktemp  /;
  
    ($fh, $file) = mkstemp( "tmpfileXXXXX" );
    ($fh, $file) = mkstemps( "tmpfileXXXXXX", $suffix);
  
    $tmpdir = mkdtemp( $template );
  
    $unopened_file = mktemp( $template );
  
  POSIX functions:
  
    use File::Temp qw/ :POSIX /;
  
    $file = tmpnam();
    $fh = tmpfile();
  
    ($fh, $file) = tmpnam();
  
  Compatibility functions:
  
    $unopened_file = File::Temp::tempnam( $dir, $pfx );
  
  =head1 DESCRIPTION
  
  C<File::Temp> can be used to create and open temporary files in a safe
  way.  There is both a function interface and an object-oriented
  interface.  The File::Temp constructor or the tempfile() function can
  be used to return the name and the open filehandle of a temporary
  file.  The tempdir() function can be used to create a temporary
  directory.
  
  The security aspect of temporary file creation is emphasized such that
  a filehandle and filename are returned together.  This helps guarantee
  that a race condition can not occur where the temporary file is
  created by another process between checking for the existence of the
  file and its opening.  Additional security levels are provided to
  check, for example, that the sticky bit is set on world writable
  directories.  See L<"safe_level"> for more information.
  
  For compatibility with popular C library functions, Perl implementations of
  the mkstemp() family of functions are provided. These are, mkstemp(),
  mkstemps(), mkdtemp() and mktemp().
  
  Additionally, implementations of the standard L<POSIX|POSIX>
  tmpnam() and tmpfile() functions are provided if required.
  
  Implementations of mktemp(), tmpnam(), and tempnam() are provided,
  but should be used with caution since they return only a filename
  that was valid when function was called, so cannot guarantee
  that the file will not exist by the time the caller opens the filename.
  
  Filehandles returned by these functions support the seekable methods.
  
  =begin __INTERNALS
  
  =head1 PORTABILITY
  
  This section is at the top in order to provide easier access to
  porters.  It is not expected to be rendered by a standard pod
  formatting tool. Please skip straight to the SYNOPSIS section if you
  are not trying to port this module to a new platform.
  
  This module is designed to be portable across operating systems and it
  currently supports Unix, VMS, DOS, OS/2, Windows and Mac OS
  (Classic). When porting to a new OS there are generally three main
  issues that have to be solved:
  =over 4
  
  =item *
  
  Can the OS unlink an open file? If it can not then the
  C<_can_unlink_opened_file> method should be modified.
  
  =item *
  
  Are the return values from C<stat> reliable? By default all the
  return values from C<stat> are compared when unlinking a temporary
  file using the filename and the handle. Operating systems other than
  unix do not always have valid entries in all fields. If utility function
  C<File::Temp::unlink0> fails then the C<stat> comparison should be
  modified accordingly.
  
  =item *
  
  Security. Systems that can not support a test for the sticky bit
  on a directory can not use the MEDIUM and HIGH security tests.
  The C<_can_do_level> method should be modified accordingly.
  
  =back
  
  =end __INTERNALS
  
  =head1 OBJECT-ORIENTED INTERFACE
  
  This is the primary interface for interacting with
  C<File::Temp>. Using the OO interface a temporary file can be created
  when the object is constructed and the file can be removed when the
  object is no longer required.
  
  Note that there is no method to obtain the filehandle from the
  C<File::Temp> object. The object itself acts as a filehandle.  The object
  isa C<IO::Handle> and isa C<IO::Seekable> so all those methods are
  available.
  
  Also, the object is configured such that it stringifies to the name of the
  temporary file and so can be compared to a filename directly.  It numifies
  to the C<refaddr> the same as other handles and so can be compared to other
  handles with C<==>.
  
      $fh eq $filename       # as a string
      $fh != \*STDOUT        # as a number
  
  =over 4
  
  =item B<new>
  
  Create a temporary file object.
  
    my $tmp = File::Temp->new();
  
  by default the object is constructed as if C<tempfile>
  was called without options, but with the additional behaviour
  that the temporary file is removed by the object destructor
  if UNLINK is set to true (the default).
  
  Supported arguments are the same as for C<tempfile>: UNLINK
  (defaulting to true), DIR, EXLOCK and SUFFIX. Additionally, the filename
  template is specified using the TEMPLATE option. The OPEN option
  is not supported (the file is always opened).
  
   $tmp = File::Temp->new( TEMPLATE => 'tempXXXXX',
                          DIR => 'mydir',
                          SUFFIX => '.dat');
  
  Arguments are case insensitive.
  
  Can call croak() if an error occurs.
  
  =item B<newdir>
  
  Create a temporary directory using an object oriented interface.
  
    $dir = File::Temp->newdir();
  
  By default the directory is deleted when the object goes out of scope.
  
  Supports the same options as the C<tempdir> function. Note that directories
  created with this method default to CLEANUP => 1.
  
    $dir = File::Temp->newdir( $template, %options );
  
  A template may be specified either with a leading template or
  with a TEMPLATE argument.
  
  =item B<filename>
  
  Return the name of the temporary file associated with this object
  (if the object was created using the "new" constructor).
  
    $filename = $tmp->filename;
  
  This method is called automatically when the object is used as
  a string.
  
  =item B<dirname>
  
  Return the name of the temporary directory associated with this
  object (if the object was created using the "newdir" constructor).
  
    $dirname = $tmpdir->dirname;
  
  This method is called automatically when the object is used in string context.
  
  =item B<unlink_on_destroy>
  
  Control whether the file is unlinked when the object goes out of scope.
  The file is removed if this value is true and $KEEP_ALL is not.
  
   $fh->unlink_on_destroy( 1 );
  
  Default is for the file to be removed.
  
  =item B<DESTROY>
  
  When the object goes out of scope, the destructor is called. This
  destructor will attempt to unlink the file (using L<unlink1|"unlink1">)
  if the constructor was called with UNLINK set to 1 (the default state
  if UNLINK is not specified).
  
  No error is given if the unlink fails.
  
  If the object has been passed to a child process during a fork, the
  file will be deleted when the object goes out of scope in the parent.
  
  For a temporary directory object the directory will be removed unless
  the CLEANUP argument was used in the constructor (and set to false) or
  C<unlink_on_destroy> was modified after creation.  Note that if a temp
  directory is your current directory, it cannot be removed - a warning
  will be given in this case.  C<chdir()> out of the directory before
  letting the object go out of scope.
  
  If the global variable $KEEP_ALL is true, the file or directory
  will not be removed.
  
  =back
  
  =head1 FUNCTIONS
  
  This section describes the recommended interface for generating
  temporary files and directories.
  
  =over 4
  
  =item B<tempfile>
  
  This is the basic function to generate temporary files.
  The behaviour of the file can be changed using various options:
  
    $fh = tempfile();
    ($fh, $filename) = tempfile();
  
  Create a temporary file in  the directory specified for temporary
  files, as specified by the tmpdir() function in L<File::Spec>.
  
    ($fh, $filename) = tempfile($template);
  
  Create a temporary file in the current directory using the supplied
  template.  Trailing `X' characters are replaced with random letters to
  generate the filename.  At least four `X' characters must be present
  at the end of the template.
  
    ($fh, $filename) = tempfile($template, SUFFIX => $suffix)
  
  Same as previously, except that a suffix is added to the template
  after the `X' translation.  Useful for ensuring that a temporary
  filename has a particular extension when needed by other applications.
  But see the WARNING at the end.
  
    ($fh, $filename) = tempfile($template, DIR => $dir);
  
  Translates the template as before except that a directory name
  is specified.
  
    ($fh, $filename) = tempfile($template, TMPDIR => 1);
  
  Equivalent to specifying a DIR of "File::Spec->tmpdir", writing the file
  into the same temporary directory as would be used if no template was
  specified at all.
  
    ($fh, $filename) = tempfile($template, UNLINK => 1);
  
  Return the filename and filehandle as before except that the file is
  automatically removed when the program exits (dependent on
  $KEEP_ALL). Default is for the file to be removed if a file handle is
  requested and to be kept if the filename is requested. In a scalar
  context (where no filename is returned) the file is always deleted
  either (depending on the operating system) on exit or when it is
  closed (unless $KEEP_ALL is true when the temp file is created).
  
  Use the object-oriented interface if fine-grained control of when
  a file is removed is required.
  
  If the template is not specified, a template is always
  automatically generated. This temporary file is placed in tmpdir()
  (L<File::Spec>) unless a directory is specified explicitly with the
  DIR option.
  
    $fh = tempfile( DIR => $dir );
  
  If called in scalar context, only the filehandle is returned and the
  file will automatically be deleted when closed on operating systems
  that support this (see the description of tmpfile() elsewhere in this
  document).  This is the preferred mode of operation, as if you only
  have a filehandle, you can never create a race condition by fumbling
  with the filename. On systems that can not unlink an open file or can
  not mark a file as temporary when it is opened (for example, Windows
  NT uses the C<O_TEMPORARY> flag) the file is marked for deletion when
  the program ends (equivalent to setting UNLINK to 1). The C<UNLINK>
  flag is ignored if present.
  
    (undef, $filename) = tempfile($template, OPEN => 0);
  
  This will return the filename based on the template but
  will not open this file.  Cannot be used in conjunction with
  UNLINK set to true. Default is to always open the file
  to protect from possible race conditions. A warning is issued
  if warnings are turned on. Consider using the tmpnam()
  and mktemp() functions described elsewhere in this document
  if opening the file is not required.
  
  If the operating system supports it (for example BSD derived systems), the 
  filehandle will be opened with O_EXLOCK (open with exclusive file lock). 
  This can sometimes cause problems if the intention is to pass the filename 
  to another system that expects to take an exclusive lock itself (such as 
  DBD::SQLite) whilst ensuring that the tempfile is not reused. In this 
  situation the "EXLOCK" option can be passed to tempfile. By default EXLOCK 
  will be true (this retains compatibility with earlier releases).
  
    ($fh, $filename) = tempfile($template, EXLOCK => 0);
  
  Options can be combined as required.
  
  Will croak() if there is an error.
  
  =item B<tempdir>
  
  This is the recommended interface for creation of temporary
  directories.  By default the directory will not be removed on exit
  (that is, it won't be temporary; this behaviour can not be changed
  because of issues with backwards compatibility). To enable removal
  either use the CLEANUP option which will trigger removal on program
  exit, or consider using the "newdir" method in the object interface which
  will allow the directory to be cleaned up when the object goes out of
  scope.
  
  The behaviour of the function depends on the arguments:
  
    $tempdir = tempdir();
  
  Create a directory in tmpdir() (see L<File::Spec|File::Spec>).
  
    $tempdir = tempdir( $template );
  
  Create a directory from the supplied template. This template is
  similar to that described for tempfile(). `X' characters at the end
  of the template are replaced with random letters to construct the
  directory name. At least four `X' characters must be in the template.
  
    $tempdir = tempdir ( DIR => $dir );
  
  Specifies the directory to use for the temporary directory.
  The temporary directory name is derived from an internal template.
  
    $tempdir = tempdir ( $template, DIR => $dir );
  
  Prepend the supplied directory name to the template. The template
  should not include parent directory specifications itself. Any parent
  directory specifications are removed from the template before
  prepending the supplied directory.
  
    $tempdir = tempdir ( $template, TMPDIR => 1 );
  
  Using the supplied template, create the temporary directory in
  a standard location for temporary files. Equivalent to doing
  
    $tempdir = tempdir ( $template, DIR => File::Spec->tmpdir);
  
  but shorter. Parent directory specifications are stripped from the
  template itself. The C<TMPDIR> option is ignored if C<DIR> is set
  explicitly.  Additionally, C<TMPDIR> is implied if neither a template
  nor a directory are supplied.
  
    $tempdir = tempdir( $template, CLEANUP => 1);
  
  Create a temporary directory using the supplied template, but
  attempt to remove it (and all files inside it) when the program
  exits. Note that an attempt will be made to remove all files from
  the directory even if they were not created by this module (otherwise
  why ask to clean it up?). The directory removal is made with
  the rmtree() function from the L<File::Path|File::Path> module.
  Of course, if the template is not specified, the temporary directory
  will be created in tmpdir() and will also be removed at program exit.
  
  Will croak() if there is an error.
  
  =back
  
  =head1 MKTEMP FUNCTIONS
  
  The following functions are Perl implementations of the
  mktemp() family of temp file generation system calls.
  
  =over 4
  
  =item B<mkstemp>
  
  Given a template, returns a filehandle to the temporary file and the name
  of the file.
  
    ($fh, $name) = mkstemp( $template );
  
  In scalar context, just the filehandle is returned.
  
  The template may be any filename with some number of X's appended
  to it, for example F</tmp/temp.XXXX>. The trailing X's are replaced
  with unique alphanumeric combinations.
  
  Will croak() if there is an error.
  
  =item B<mkstemps>
  
  Similar to mkstemp(), except that an extra argument can be supplied
  with a suffix to be appended to the template.
  
    ($fh, $name) = mkstemps( $template, $suffix );
  
  For example a template of C<testXXXXXX> and suffix of C<.dat>
  would generate a file similar to F<testhGji_w.dat>.
  
  Returns just the filehandle alone when called in scalar context.
  
  Will croak() if there is an error.
  
  =item B<mkdtemp>
  
  Create a directory from a template. The template must end in
  X's that are replaced by the routine.
  
    $tmpdir_name = mkdtemp($template);
  
  Returns the name of the temporary directory created.
  
  Directory must be removed by the caller.
  
  Will croak() if there is an error.
  
  =item B<mktemp>
  
  Returns a valid temporary filename but does not guarantee
  that the file will not be opened by someone else.
  
    $unopened_file = mktemp($template);
  
  Template is the same as that required by mkstemp().
  
  Will croak() if there is an error.
  
  =back
  
  =head1 POSIX FUNCTIONS
  
  This section describes the re-implementation of the tmpnam()
  and tmpfile() functions described in L<POSIX>
  using the mkstemp() from this module.
  
  Unlike the L<POSIX|POSIX> implementations, the directory used
  for the temporary file is not specified in a system include
  file (C<P_tmpdir>) but simply depends on the choice of tmpdir()
  returned by L<File::Spec|File::Spec>. On some implementations this
  location can be set using the C<TMPDIR> environment variable, which
  may not be secure.
  If this is a problem, simply use mkstemp() and specify a template.
  
  =over 4
  
  =item B<tmpnam>
  
  When called in scalar context, returns the full name (including path)
  of a temporary file (uses mktemp()). The only check is that the file does
  not already exist, but there is no guarantee that that condition will
  continue to apply.
  
    $file = tmpnam();
  
  When called in list context, a filehandle to the open file and
  a filename are returned. This is achieved by calling mkstemp()
  after constructing a suitable template.
  
    ($fh, $file) = tmpnam();
  
  If possible, this form should be used to prevent possible
  race conditions.
  
  See L<File::Spec/tmpdir> for information on the choice of temporary
  directory for a particular operating system.
  
  Will croak() if there is an error.
  
  =item B<tmpfile>
  
  Returns the filehandle of a temporary file.
  
    $fh = tmpfile();
  
  The file is removed when the filehandle is closed or when the program
  exits. No access to the filename is provided.
  
  If the temporary file can not be created undef is returned.
  Currently this command will probably not work when the temporary
  directory is on an NFS file system.
  
  Will croak() if there is an error.
  
  =back
  
  =head1 ADDITIONAL FUNCTIONS
  
  These functions are provided for backwards compatibility
  with common tempfile generation C library functions.
  
  They are not exported and must be addressed using the full package
  name.
  
  =over 4
  
  =item B<tempnam>
  
  Return the name of a temporary file in the specified directory
  using a prefix. The file is guaranteed not to exist at the time
  the function was called, but such guarantees are good for one
  clock tick only.  Always use the proper form of C<sysopen>
  with C<O_CREAT | O_EXCL> if you must open such a filename.
  
    $filename = File::Temp::tempnam( $dir, $prefix );
  
  Equivalent to running mktemp() with $dir/$prefixXXXXXXXX
  (using unix file convention as an example)
  
  Because this function uses mktemp(), it can suffer from race conditions.
  
  Will croak() if there is an error.
  
  =back
  
  =head1 UTILITY FUNCTIONS
  
  Useful functions for dealing with the filehandle and filename.
  
  =over 4
  
  =item B<unlink0>
  
  Given an open filehandle and the associated filename, make a safe
  unlink. This is achieved by first checking that the filename and
  filehandle initially point to the same file and that the number of
  links to the file is 1 (all fields returned by stat() are compared).
  Then the filename is unlinked and the filehandle checked once again to
  verify that the number of links on that file is now 0.  This is the
  closest you can come to making sure that the filename unlinked was the
  same as the file whose descriptor you hold.
  
    unlink0($fh, $path)
       or die "Error unlinking file $path safely";
  
  Returns false on error but croaks() if there is a security
  anomaly. The filehandle is not closed since on some occasions this is
  not required.
  
  On some platforms, for example Windows NT, it is not possible to
  unlink an open file (the file must be closed first). On those
  platforms, the actual unlinking is deferred until the program ends and
  good status is returned. A check is still performed to make sure that
  the filehandle and filename are pointing to the same thing (but not at
  the time the end block is executed since the deferred removal may not
  have access to the filehandle).
  
  Additionally, on Windows NT not all the fields returned by stat() can
  be compared. For example, the C<dev> and C<rdev> fields seem to be
  different.  Also, it seems that the size of the file returned by stat()
  does not always agree, with C<stat(FH)> being more accurate than
  C<stat(filename)>, presumably because of caching issues even when
  using autoflush (this is usually overcome by waiting a while after
  writing to the tempfile before attempting to C<unlink0> it).
  
  Finally, on NFS file systems the link count of the file handle does
  not always go to zero immediately after unlinking. Currently, this
  command is expected to fail on NFS disks.
  
  This function is disabled if the global variable $KEEP_ALL is true
  and an unlink on open file is supported. If the unlink is to be deferred
  to the END block, the file is still registered for removal.
  
  This function should not be called if you are using the object oriented
  interface since the it will interfere with the object destructor deleting
  the file.
  
  =item B<cmpstat>
  
  Compare C<stat> of filehandle with C<stat> of provided filename.  This
  can be used to check that the filename and filehandle initially point
  to the same file and that the number of links to the file is 1 (all
  fields returned by stat() are compared).
  
    cmpstat($fh, $path)
       or die "Error comparing handle with file";
  
  Returns false if the stat information differs or if the link count is
  greater than 1. Calls croak if there is a security anomaly.
  
  On certain platforms, for example Windows, not all the fields returned by stat()
  can be compared. For example, the C<dev> and C<rdev> fields seem to be
  different in Windows.  Also, it seems that the size of the file
  returned by stat() does not always agree, with C<stat(FH)> being more
  accurate than C<stat(filename)>, presumably because of caching issues
  even when using autoflush (this is usually overcome by waiting a while
  after writing to the tempfile before attempting to C<unlink0> it).
  
  Not exported by default.
  
  =item B<unlink1>
  
  Similar to C<unlink0> except after file comparison using cmpstat, the
  filehandle is closed prior to attempting to unlink the file. This
  allows the file to be removed without using an END block, but does
  mean that the post-unlink comparison of the filehandle state provided
  by C<unlink0> is not available.
  
    unlink1($fh, $path)
       or die "Error closing and unlinking file";
  
  Usually called from the object destructor when using the OO interface.
  
  Not exported by default.
  
  This function is disabled if the global variable $KEEP_ALL is true.
  
  Can call croak() if there is a security anomaly during the stat()
  comparison.
  
  =item B<cleanup>
  
  Calling this function will cause any temp files or temp directories
  that are registered for removal to be removed. This happens automatically
  when the process exits but can be triggered manually if the caller is sure
  that none of the temp files are required. This method can be registered as
  an Apache callback.
  
  Note that if a temp directory is your current directory, it cannot be
  removed.  C<chdir()> out of the directory first before calling
  C<cleanup()>. (For the cleanup at program exit when the CLEANUP flag
  is set, this happens automatically.)
  
  On OSes where temp files are automatically removed when the temp file
  is closed, calling this function will have no effect other than to remove
  temporary directories (which may include temporary files).
  
    File::Temp::cleanup();
  
  Not exported by default.
  
  =back
  
  =head1 PACKAGE VARIABLES
  
  These functions control the global state of the package.
  
  =over 4
  
  =item B<safe_level>
  
  Controls the lengths to which the module will go to check the safety of the
  temporary file or directory before proceeding.
  Options are:
  
  =over 8
  
  =item STANDARD
  
  Do the basic security measures to ensure the directory exists and is
  writable, that temporary files are opened only if they do not already
  exist, and that possible race conditions are avoided.  Finally the
  L<unlink0|"unlink0"> function is used to remove files safely.
  
  =item MEDIUM
  
  In addition to the STANDARD security, the output directory is checked
  to make sure that it is owned either by root or the user running the
  program. If the directory is writable by group or by other, it is then
  checked to make sure that the sticky bit is set.
  
  Will not work on platforms that do not support the C<-k> test
  for sticky bit.
  
  =item HIGH
  
  In addition to the MEDIUM security checks, also check for the
  possibility of ``chown() giveaway'' using the L<POSIX|POSIX>
  sysconf() function. If this is a possibility, each directory in the
  path is checked in turn for safeness, recursively walking back to the
  root directory.
  
  For platforms that do not support the L<POSIX|POSIX>
  C<_PC_CHOWN_RESTRICTED> symbol (for example, Windows NT) it is
  assumed that ``chown() giveaway'' is possible and the recursive test
  is performed.
  
  =back
  
  The level can be changed as follows:
  
    File::Temp->safe_level( File::Temp::HIGH );
  
  The level constants are not exported by the module.
  
  Currently, you must be running at least perl v5.6.0 in order to
  run with MEDIUM or HIGH security. This is simply because the
  safety tests use functions from L<Fcntl|Fcntl> that are not
  available in older versions of perl. The problem is that the version
  number for Fcntl is the same in perl 5.6.0 and in 5.005_03 even though
  they are different versions.
  
  On systems that do not support the HIGH or MEDIUM safety levels
  (for example Win NT or OS/2) any attempt to change the level will
  be ignored. The decision to ignore rather than raise an exception
  allows portable programs to be written with high security in mind
  for the systems that can support this without those programs failing
  on systems where the extra tests are irrelevant.
  
  If you really need to see whether the change has been accepted
  simply examine the return value of C<safe_level>.
  
    $newlevel = File::Temp->safe_level( File::Temp::HIGH );
    die "Could not change to high security"
        if $newlevel != File::Temp::HIGH;
  
  =item TopSystemUID
  
  This is the highest UID on the current system that refers to a root
  UID. This is used to make sure that the temporary directory is
  owned by a system UID (C<root>, C<bin>, C<sys> etc) rather than
  simply by root.
  
  This is required since on many unix systems C</tmp> is not owned
  by root.
  
  Default is to assume that any UID less than or equal to 10 is a root
  UID.
  
    File::Temp->top_system_uid(10);
    my $topid = File::Temp->top_system_uid;
  
  This value can be adjusted to reduce security checking if required.
  The value is only relevant when C<safe_level> is set to MEDIUM or higher.
  
  =item B<$KEEP_ALL>
  
  Controls whether temporary files and directories should be retained
  regardless of any instructions in the program to remove them
  automatically.  This is useful for debugging but should not be used in
  production code.
  
    $File::Temp::KEEP_ALL = 1;
  
  Default is for files to be removed as requested by the caller.
  
  In some cases, files will only be retained if this variable is true
  when the file is created. This means that you can not create a temporary
  file, set this variable and expect the temp file to still be around
  when the program exits.
  
  =item B<$DEBUG>
  
  Controls whether debugging messages should be enabled.
  
    $File::Temp::DEBUG = 1;
  
  Default is for debugging mode to be disabled.
  
  =back
  
  =head1 WARNING
  
  For maximum security, endeavour always to avoid ever looking at,
  touching, or even imputing the existence of the filename.  You do not
  know that that filename is connected to the same file as the handle
  you have, and attempts to check this can only trigger more race
  conditions.  It's far more secure to use the filehandle alone and
  dispense with the filename altogether.
  
  If you need to pass the handle to something that expects a filename
  then on a unix system you can use C<"/dev/fd/" . fileno($fh)> for
  arbitrary programs. Perl code that uses the 2-argument version of
  C<< open >> can be passed C<< "+<=&" . fileno($fh) >>. Otherwise you
  will need to pass the filename. You will have to clear the
  close-on-exec bit on that file descriptor before passing it to another
  process.
  
      use Fcntl qw/F_SETFD F_GETFD/;
      fcntl($tmpfh, F_SETFD, 0)
          or die "Can't clear close-on-exec flag on temp fh: $!\n";
  
  =head2 Temporary files and NFS
  
  Some problems are associated with using temporary files that reside
  on NFS file systems and it is recommended that a local filesystem
  is used whenever possible. Some of the security tests will most probably
  fail when the temp file is not local. Additionally, be aware that
  the performance of I/O operations over NFS will not be as good as for
  a local disk.
  
  =head2 Forking
  
  In some cases files created by File::Temp are removed from within an
  END block. Since END blocks are triggered when a child process exits
  (unless C<POSIX::_exit()> is used by the child) File::Temp takes care
  to only remove those temp files created by a particular process ID. This
  means that a child will not attempt to remove temp files created by the
  parent process.
  
  If you are forking many processes in parallel that are all creating
  temporary files, you may need to reset the random number seed using
  srand(EXPR) in each child else all the children will attempt to walk
  through the same set of random file names and may well cause
  themselves to give up if they exceed the number of retry attempts.
  
  =head2 Directory removal
  
  Note that if you have chdir'ed into the temporary directory and it is
  subsequently cleaned up (either in the END block or as part of object
  destruction), then you will get a warning from File::Path::rmtree().
  
  =head2 Taint mode
  
  If you need to run code under taint mode, updating to the latest
  L<File::Spec> is highly recommended.
  
  =head2 BINMODE
  
  The file returned by File::Temp will have been opened in binary mode
  if such a mode is available. If that is not correct, use the C<binmode()>
  function to change the mode of the filehandle.
  
  Note that you can modify the encoding of a file opened by File::Temp
  also by using C<binmode()>.
  
  =head1 HISTORY
  
  Originally began life in May 1999 as an XS interface to the system
  mkstemp() function. In March 2000, the OpenBSD mkstemp() code was
  translated to Perl for total control of the code's
  security checking, to ensure the presence of the function regardless of
  operating system and to help with portability. The module was shipped
  as a standard part of perl from v5.6.1.
  
  Thanks to Tom Christiansen for suggesting that this module
  should be written and providing ideas for code improvements and
  security enhancements.
  
  =head1 SEE ALSO
  
  L<POSIX/tmpnam>, L<POSIX/tmpfile>, L<File::Spec>, L<File::Path>
  
  See L<IO::File> and L<File::MkTemp>, L<Apache::TempFile> for
  different implementations of temporary file handling.
  
  See L<File::Tempdir> for an alternative object-oriented wrapper for
  the C<tempdir> function.
  
  =for Pod::Coverage STRINGIFY NUMIFY top_system_uid
  
  # vim: ts=2 sts=2 sw=2 et:
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<http://rt.cpan.org/Public/Dist/Display.html?Name=File-Temp>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/Perl-Toolchain-Gang/File-Temp>
  
    git clone https://github.com/Perl-Toolchain-Gang/File-Temp.git
  
  =head1 AUTHOR
  
  Tim Jenness <tjenness@cpan.org>
  
  =head1 CONTRIBUTORS
  
  =over 4
  
  =item *
  
  Ben Tilly <btilly@gmail.com>
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =item *
  
  David Steinbrunner <dsteinbrunner@pobox.com>
  
  =item *
  
  Ed Avis <eda@linux01.wcl.local>
  
  =item *
  
  James E. Keenan <jkeen@verizon.net>
  
  =item *
  
  Karen Etheridge <ether@cpan.org>
  
  =item *
  
  Kevin Ryde <user42@zip.com.au>
  
  =item *
  
  Olivier Mengue <dolmen@cpan.org>
  
  =item *
  
  Peter John Acklam <pjacklam@online.no>
  
  =item *
  
  Peter Rabbitson <ribasushi@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2013 by Tim Jenness and the UK Particle Physics and Astronomy Research Council.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
FILE_TEMP

$fatpacked{"File/Which.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'FILE_WHICH';
  package File::Which;
  
  use strict;
  use warnings;
  use Exporter   ();
  use File::Spec ();
  
  # ABSTRACT: Perl implementation of the which utility as an API
  our $VERSION = '1.22'; # VERSION
  
  
  our @ISA       = 'Exporter';
  our @EXPORT    = 'which';
  our @EXPORT_OK = 'where';
  
  use constant IS_VMS => ($^O eq 'VMS');
  use constant IS_MAC => ($^O eq 'MacOS');
  use constant IS_DOS => ($^O eq 'MSWin32' or $^O eq 'dos' or $^O eq 'os2');
  use constant IS_CYG => ($^O eq 'cygwin' || $^O eq 'msys');
  
  # For Win32 systems, stores the extensions used for
  # executable files
  # For others, the empty string is used
  # because 'perl' . '' eq 'perl' => easier
  my @PATHEXT = ('');
  if ( IS_DOS ) {
    # WinNT. PATHEXT might be set on Cygwin, but not used.
    if ( $ENV{PATHEXT} ) {
      push @PATHEXT, split ';', $ENV{PATHEXT};
    } else {
      # Win9X or other: doesn't have PATHEXT, so needs hardcoded.
      push @PATHEXT, qw{.com .exe .bat};
    }
  } elsif ( IS_VMS ) {
    push @PATHEXT, qw{.exe .com};
  } elsif ( IS_CYG ) {
    # See this for more info
    # http://cygwin.com/cygwin-ug-net/using-specialnames.html#pathnames-exe
    push @PATHEXT, qw{.exe .com};
  }
  
  
  sub which {
    my ($exec) = @_;
  
    return undef unless defined $exec;
    return undef if $exec eq '';
  
    my $all = wantarray;
    my @results = ();
  
    # check for aliases first
    if ( IS_VMS ) {
      my $symbol = `SHOW SYMBOL $exec`;
      chomp($symbol);
      unless ( $? ) {
        return $symbol unless $all;
        push @results, $symbol;
      }
    }
    if ( IS_MAC ) {
      my @aliases = split /\,/, $ENV{Aliases};
      foreach my $alias ( @aliases ) {
        # This has not been tested!!
        # PPT which says MPW-Perl cannot resolve `Alias $alias`,
        # let's just hope it's fixed
        if ( lc($alias) eq lc($exec) ) {
          chomp(my $file = `Alias $alias`);
          last unless $file;  # if it failed, just go on the normal way
          return $file unless $all;
          push @results, $file;
          # we can stop this loop as if it finds more aliases matching,
          # it'll just be the same result anyway
          last;
        }
      }
    }
  
    return $exec
            if !IS_VMS and !IS_MAC and !IS_DOS and $exec =~ /\// and -f $exec and -x $exec;
  
    my @path = File::Spec->path;
    if ( IS_DOS or IS_VMS or IS_MAC ) {
      unshift @path, File::Spec->curdir;
    }
  
    foreach my $base ( map { File::Spec->catfile($_, $exec) } @path ) {
      for my $ext ( @PATHEXT ) {
        my $file = $base.$ext;
  
        # We don't want dirs (as they are -x)
        next if -d $file;
  
        if (
          # Executable, normal case
          -x _
          or (
            # MacOS doesn't mark as executable so we check -e
            IS_MAC
            ||
            (
              ( IS_DOS or IS_CYG )
              and
              grep {
                $file =~ /$_\z/i
              } @PATHEXT[1..$#PATHEXT]
            )
            # DOSish systems don't pass -x on
            # non-exe/bat/com files. so we check -e.
            # However, we don't want to pass -e on files
            # that aren't in PATHEXT, like README.
            and -e _
          )
        ) {
          return $file unless $all;
          push @results, $file;
        }
      }
    }
  
    if ( $all ) {
      return @results;
    } else {
      return undef;
    }
  }
  
  
  sub where {
    # force wantarray
    my @res = which($_[0]);
    return @res;
  }
  
  1;
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  File::Which - Perl implementation of the which utility as an API
  
  =head1 VERSION
  
  version 1.22
  
  =head1 SYNOPSIS
  
   use File::Which;                  # exports which()
   use File::Which qw(which where);  # exports which() and where()
   
   my $exe_path = which 'perldoc';
   
   my @paths = where 'perl';
   # Or
   my @paths = which 'perl'; # an array forces search for all of them
  
  =head1 DESCRIPTION
  
  L<File::Which> finds the full or relative paths to executable programs on
  the system.  This is normally the function of C<which> utility.  C<which> is
  typically implemented as either a program or a built in shell command.  On
  some platforms, such as Microsoft Windows it is not provided as part of the
  core operating system.  This module provides a consistent API to this
  functionality regardless of the underlying platform.
  
  The focus of this module is correctness and portability.  As a consequence
  platforms where the current directory is implicitly part of the search path
  such as Microsoft Windows will find executables in the current directory,
  whereas on platforms such as UNIX where this is not the case executables 
  in the current directory will only be found if the current directory is
  explicitly added to the path.
  
  If you need a portable C<which> on the command line in an environment that
  does not provide it, install L<App::pwhich> which provides a command line
  interface to this API.
  
  =head2 Implementations
  
  L<File::Which> searches the directories of the user's C<PATH> (the current
  implementation uses L<File::Spec#path> to determine the correct C<PATH>),
  looking for executable files having the name specified as a parameter to
  L</which>. Under Win32 systems, which do not have a notion of directly
  executable files, but uses special extensions such as C<.exe> and C<.bat>
  to identify them, C<File::Which> takes extra steps to assure that
  you will find the correct file (so for example, you might be searching for
  C<perl>, it'll try F<perl.exe>, F<perl.bat>, etc.)
  
  =head3 Linux, *BSD and other UNIXes
  
  There should not be any surprises here.  The current directory will not be
  searched unless it is explicitly added to the path.
  
  =head3 Modern Windows (including NT, XP, Vista, 7, 8, 10 etc)
  
  Windows NT has a special environment variable called C<PATHEXT>, which is used
  by the shell to look for executable files. Usually, it will contain a list in
  the form C<.EXE;.BAT;.COM;.JS;.VBS> etc. If C<File::Which> finds such an
  environment variable, it parses the list and uses it as the different
  extensions.
  
  =head3 Cygwin
  
  Cygwin provides a Unix-like environment for Microsoft Windows users.  In most
  ways it works like other Unix and Unix-like environments, but in a few key
  aspects it works like Windows.  As with other Unix environments, the current
  directory is not included in the search unless it is explicitly included in
  the search path.  Like on Windows, files with C<.EXE> or <.BAT> extensions will
  be discovered even if they are not part of the query.  C<.COM> or extensions
  specified using the C<PATHEXT> environment variable will NOT be discovered
  without the fully qualified name, however.
  
  =head3 Windows 95, 98, ME, MS-DOS, OS/2
  
  This set of operating systems don't have the C<PATHEXT> variable, and usually
  you will find executable files there with the extensions C<.exe>, C<.bat> and
  (less likely) C<.com>. C<File::Which> uses this hardcoded list if it's running
  under Win32 but does not find a C<PATHEXT> variable.
  
  As of 2015 none of these platforms are tested frequently (or perhaps ever),
  but the current maintainer is determined not to intentionally remove support
  for older operating systems.
  
  =head3 VMS
  
  Same case as Windows 9x: uses C<.exe> and C<.com> (in that order).
  
  As of 2015 the current maintainer does not test on VMS, and is in fact not
  certain it has ever been tested on VMS.  If this platform is important to you
  and you can help me verify and or support it on that platform please contact
  me.
  
  =head1 FUNCTIONS
  
  =head2 which
  
   my $path = which $short_exe_name;
   my @paths = which $short_exe_name;
  
  Exported by default.
  
  C<$short_exe_name> is the name used in the shell to call the program (for
  example, C<perl>).
  
  If it finds an executable with the name you specified, C<which()> will return
  the absolute path leading to this executable (for example, F</usr/bin/perl> or
  F<C:\Perl\Bin\perl.exe>).
  
  If it does I<not> find the executable, it returns C<undef>.
  
  If C<which()> is called in list context, it will return I<all> the
  matches.
  
  =head2 where
  
   my @paths = where $short_exe_name;
  
  Not exported by default.
  
  Same as L</which> in array context. Same as the
  C<where> utility, will return an array containing all the path names
  matching C<$short_exe_name>.
  
  =head1 CAVEATS
  
  This module has no non-core requirements for Perl 5.6.2 and better.
  
  This module is fully supported back to Perl 5.8.1.  It may work on 5.8.0.  
  It should work on Perl 5.6.x and I may even test on 5.6.2.  I will accept
  patches to maintain compatibility for such older Perls, but you may
  need to fix it on 5.6.x / 5.8.0 and send me a patch.
  
  Not tested on VMS although there is platform specific code
  for those. Anyone who haves a second would be very kind to send me a
  report of how it went.
  
  =head1 SUPPORT
  
  Bugs should be reported via the GitHub issue tracker
  
  L<https://github.com/plicease/File-Which/issues>
  
  For other issues, contact the maintainer.
  
  =head1 SEE ALSO
  
  =over 4
  
  =item L<pwhich>, L<App::pwhich>
  
  Command line interface to this module.
  
  =item L<IPC::Cmd>
  
  Comes with a C<can_run> function with slightly different semantics that
  the traditional UNIX where.  It will find executables in the current
  directory, even though the current directory is not searched for by
  default on Unix.
  
  =item L<Devel::CheckBin>
  
  This module purports to "check that a command is available", but does not
  provide any documentation on how you might use it.
  
  =back
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  Per Einar Ellefsen <pereinar@cpan.org>
  
  =item *
  
  Adam Kennedy <adamk@cpan.org>
  
  =item *
  
  Graham Ollis <plicease@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2002 by Per Einar Ellefsen <pereinar@cpan.org>.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
FILE_WHICH

$fatpacked{"File/pushd.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'FILE_PUSHD';
  use strict;
  use warnings;
  
  package File::pushd;
  # ABSTRACT: change directory temporarily for a limited scope
  
  our $VERSION = '1.014';
  
  our @EXPORT = qw( pushd tempd );
  our @ISA    = qw( Exporter );
  
  use Exporter;
  use Carp;
  use Cwd qw( getcwd abs_path );
  use File::Path qw( rmtree );
  use File::Temp qw();
  use File::Spec;
  
  use overload
    q{""}    => sub { File::Spec->canonpath( $_[0]->{_pushd} ) },
    fallback => 1;
  
  #--------------------------------------------------------------------------#
  # pushd()
  #--------------------------------------------------------------------------#
  
  sub pushd {
      # Called in void context?
      unless (defined wantarray) {
          warnings::warnif(void => 'Useless use of File::pushd::pushd in void context');
          return
      }
  
      my ( $target_dir, $options ) = @_;
      $options->{untaint_pattern} ||= qr{^([-+@\w./]+)$};
  
      $target_dir = "." unless defined $target_dir;
      croak "Can't locate directory $target_dir" unless -d $target_dir;
  
      my $tainted_orig = getcwd;
      my $orig;
      if ( $tainted_orig =~ $options->{untaint_pattern} ) {
          $orig = $1;
      }
      else {
          $orig = $tainted_orig;
      }
  
      my $tainted_dest;
      eval { $tainted_dest = $target_dir ? abs_path($target_dir) : $orig };
      croak "Can't locate absolute path for $target_dir: $@" if $@;
  
      my $dest;
      if ( $tainted_dest =~ $options->{untaint_pattern} ) {
          $dest = $1;
      }
      else {
          $dest = $tainted_dest;
      }
  
      if ( $dest ne $orig ) {
          chdir $dest or croak "Can't chdir to $dest\: $!";
      }
  
      my $self = bless {
          _pushd    => $dest,
          _original => $orig
        },
        __PACKAGE__;
  
      return $self;
  }
  
  #--------------------------------------------------------------------------#
  # tempd()
  #--------------------------------------------------------------------------#
  
  sub tempd {
      # Called in void context?
      unless (defined wantarray) {
          warnings::warnif(void => 'Useless use of File::pushd::tempd in void context');
          return
      }
  
      my ($options) = @_;
      my $dir;
      eval { $dir = pushd( File::Temp::tempdir( CLEANUP => 0 ), $options ) };
      croak $@ if $@;
      $dir->{_tempd} = 1;
      return $dir;
  }
  
  #--------------------------------------------------------------------------#
  # preserve()
  #--------------------------------------------------------------------------#
  
  sub preserve {
      my $self = shift;
      return 1 if !$self->{"_tempd"};
      if ( @_ == 0 ) {
          return $self->{_preserve} = 1;
      }
      else {
          return $self->{_preserve} = $_[0] ? 1 : 0;
      }
  }
  
  #--------------------------------------------------------------------------#
  # DESTROY()
  # Revert to original directory as object is destroyed and cleanup
  # if necessary
  #--------------------------------------------------------------------------#
  
  sub DESTROY {
      my ($self) = @_;
      my $orig = $self->{_original};
      chdir $orig if $orig; # should always be so, but just in case...
      if ( $self->{_tempd}
          && !$self->{_preserve} )
      {
          # don't destroy existing $@ if there is no error.
          my $err = do {
              local $@;
              eval { rmtree( $self->{_pushd} ) };
              $@;
          };
          carp $err if $err;
      }
  }
  
  1;
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  File::pushd - change directory temporarily for a limited scope
  
  =head1 VERSION
  
  version 1.014
  
  =head1 SYNOPSIS
  
   use File::pushd;
  
   chdir $ENV{HOME};
  
   # change directory again for a limited scope
   {
       my $dir = pushd( '/tmp' );
       # working directory changed to /tmp
   }
   # working directory has reverted to $ENV{HOME}
  
   # tempd() is equivalent to pushd( File::Temp::tempdir )
   {
       my $dir = tempd();
   }
  
   # object stringifies naturally as an absolute path
   {
      my $dir = pushd( '/tmp' );
      my $filename = File::Spec->catfile( $dir, "somefile.txt" );
      # gives /tmp/somefile.txt
   }
  
  =head1 DESCRIPTION
  
  File::pushd does a temporary C<chdir> that is easily and automatically
  reverted, similar to C<pushd> in some Unix command shells.  It works by
  creating an object that caches the original working directory.  When the object
  is destroyed, the destructor calls C<chdir> to revert to the original working
  directory.  By storing the object in a lexical variable with a limited scope,
  this happens automatically at the end of the scope.
  
  This is very handy when working with temporary directories for tasks like
  testing; a function is provided to streamline getting a temporary
  directory from L<File::Temp>.
  
  For convenience, the object stringifies as the canonical form of the absolute
  pathname of the directory entered.
  
  B<Warning>: if you create multiple C<pushd> objects in the same lexical scope,
  their destruction order is not guaranteed and you might not wind up in the
  directory you expect.
  
  =head1 USAGE
  
   use File::pushd;
  
  Using File::pushd automatically imports the C<pushd> and C<tempd> functions.
  
  =head2 pushd
  
   {
       my $dir = pushd( $target_directory );
   }
  
  Caches the current working directory, calls C<chdir> to change to the target
  directory, and returns a File::pushd object.  When the object is
  destroyed, the working directory reverts to the original directory.
  
  The provided target directory can be a relative or absolute path. If
  called with no arguments, it uses the current directory as its target and
  returns to the current directory when the object is destroyed.
  
  If the target directory does not exist or if the directory change fails
  for some reason, C<pushd> will die with an error message.
  
  Can be given a hashref as an optional second argument.  The only supported
  option is C<untaint_pattern>, which is used to untaint file paths involved.
  It defaults to {qr{^(L<-+@\w./>+)$}}, which is reasonably restrictive (e.g.
  it does not even allow spaces in the path).  Change this to suit your
  circumstances and security needs if running under taint mode. *Note*: you
  must include the parentheses in the pattern to capture the untainted
  portion of the path.
  
  =head2 tempd
  
   {
       my $dir = tempd();
   }
  
  This function is like C<pushd> but automatically creates and calls C<chdir> to
  a temporary directory created by L<File::Temp>. Unlike normal L<File::Temp>
  cleanup which happens at the end of the program, this temporary directory is
  removed when the object is destroyed. (But also see C<preserve>.)  A warning
  will be issued if the directory cannot be removed.
  
  As with C<pushd>, C<tempd> will die if C<chdir> fails.
  
  It may be given a single options hash that will be passed internally
  to C<pushd>.
  
  =head2 preserve
  
   {
       my $dir = tempd();
       $dir->preserve;      # mark to preserve at end of scope
       $dir->preserve(0);   # mark to delete at end of scope
   }
  
  Controls whether a temporary directory will be cleaned up when the object is
  destroyed.  With no arguments, C<preserve> sets the directory to be preserved.
  With an argument, the directory will be preserved if the argument is true, or
  marked for cleanup if the argument is false.  Only C<tempd> objects may be
  marked for cleanup.  (Target directories to C<pushd> are always preserved.)
  C<preserve> returns true if the directory will be preserved, and false
  otherwise.
  
  =head1 DIAGNOSTICS
  
  C<pushd> and C<tempd> warn with message
  C<"Useless use of File::pushd::I<%s> in void context"> if called in
  void context and the warnings category C<void> is enabled.
  
    {
      use warnings 'void';
  
      pushd();
    }
  
  =head1 SEE ALSO
  
  =over 4
  
  =item *
  
  L<File::chdir>
  
  =back
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/dagolden/File-pushd/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/dagolden/File-pushd>
  
    git clone https://github.com/dagolden/File-pushd.git
  
  =head1 AUTHOR
  
  David Golden <dagolden@cpan.org>
  
  =head1 CONTRIBUTORS
  
  =for stopwords Diab Jerius Graham Ollis Olivier Mengué
  
  =over 4
  
  =item *
  
  Diab Jerius <djerius@cfa.harvard.edu>
  
  =item *
  
  Graham Ollis <plicease@cpan.org>
  
  =item *
  
  Olivier Mengué <dolmen@cpan.org>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is Copyright (c) 2016 by David A Golden.
  
  This is free software, licensed under:
  
    The Apache License, Version 2.0, January 2004
  
  =cut
  
  __END__
  
  
  # vim: ts=4 sts=4 sw=4 et:
FILE_PUSHD

$fatpacked{"HTTP/Tiny.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINY';
  # vim: ts=4 sts=4 sw=4 et:
  package HTTP::Tiny;
  use strict;
  use warnings;
  # ABSTRACT: A small, simple, correct HTTP/1.1 client
  
  our $VERSION = '0.070';
  
  sub _croak { require Carp; Carp::croak(@_) }
  
  #pod =method new
  #pod
  #pod     $http = HTTP::Tiny->new( %attributes );
  #pod
  #pod This constructor returns a new HTTP::Tiny object.  Valid attributes include:
  #pod
  #pod =for :list
  #pod * C<agent> — A user-agent string (defaults to 'HTTP-Tiny/$VERSION'). If
  #pod   C<agent> — ends in a space character, the default user-agent string is
  #pod   appended.
  #pod * C<cookie_jar> — An instance of L<HTTP::CookieJar> — or equivalent class
  #pod   that supports the C<add> and C<cookie_header> methods
  #pod * C<default_headers> — A hashref of default headers to apply to requests
  #pod * C<local_address> — The local IP address to bind to
  #pod * C<keep_alive> — Whether to reuse the last connection (if for the same
  #pod   scheme, host and port) (defaults to 1)
  #pod * C<max_redirect> — Maximum number of redirects allowed (defaults to 5)
  #pod * C<max_size> — Maximum response size in bytes (only when not using a data
  #pod   callback).  If defined, responses larger than this will return an
  #pod   exception.
  #pod * C<http_proxy> — URL of a proxy server to use for HTTP connections
  #pod   (default is C<$ENV{http_proxy}> — if set)
  #pod * C<https_proxy> — URL of a proxy server to use for HTTPS connections
  #pod   (default is C<$ENV{https_proxy}> — if set)
  #pod * C<proxy> — URL of a generic proxy server for both HTTP and HTTPS
  #pod   connections (default is C<$ENV{all_proxy}> — if set)
  #pod * C<no_proxy> — List of domain suffixes that should not be proxied.  Must
  #pod   be a comma-separated string or an array reference. (default is
  #pod   C<$ENV{no_proxy}> —)
  #pod * C<timeout> — Request timeout in seconds (default is 60) If a socket open,
  #pod   read or write takes longer than the timeout, an exception is thrown.
  #pod * C<verify_SSL> — A boolean that indicates whether to validate the SSL
  #pod   certificate of an C<https> — connection (default is false)
  #pod * C<SSL_options> — A hashref of C<SSL_*> — options to pass through to
  #pod   L<IO::Socket::SSL>
  #pod
  #pod Passing an explicit C<undef> for C<proxy>, C<http_proxy> or C<https_proxy> will
  #pod prevent getting the corresponding proxies from the environment.
  #pod
  #pod Exceptions from C<max_size>, C<timeout> or other errors will result in a
  #pod pseudo-HTTP status code of 599 and a reason of "Internal Exception". The
  #pod content field in the response will contain the text of the exception.
  #pod
  #pod The C<keep_alive> parameter enables a persistent connection, but only to a
  #pod single destination scheme, host and port.  Also, if any connection-relevant
  #pod attributes are modified, or if the process ID or thread ID change, the
  #pod persistent connection will be dropped.  If you want persistent connections
  #pod across multiple destinations, use multiple HTTP::Tiny objects.
  #pod
  #pod See L</SSL SUPPORT> for more on the C<verify_SSL> and C<SSL_options> attributes.
  #pod
  #pod =cut
  
  my @attributes;
  BEGIN {
      @attributes = qw(
          cookie_jar default_headers http_proxy https_proxy keep_alive
          local_address max_redirect max_size proxy no_proxy
          SSL_options verify_SSL
      );
      my %persist_ok = map {; $_ => 1 } qw(
          cookie_jar default_headers max_redirect max_size
      );
      no strict 'refs';
      no warnings 'uninitialized';
      for my $accessor ( @attributes ) {
          *{$accessor} = sub {
              @_ > 1
                  ? do {
                      delete $_[0]->{handle} if !$persist_ok{$accessor} && $_[1] ne $_[0]->{$accessor};
                      $_[0]->{$accessor} = $_[1]
                  }
                  : $_[0]->{$accessor};
          };
      }
  }
  
  sub agent {
      my($self, $agent) = @_;
      if( @_ > 1 ){
          $self->{agent} =
              (defined $agent && $agent =~ / $/) ? $agent . $self->_agent : $agent;
      }
      return $self->{agent};
  }
  
  sub timeout {
      my ($self, $timeout) = @_;
      if ( @_ > 1 ) {
          $self->{timeout} = $timeout;
          if ($self->{handle}) {
              $self->{handle}->timeout($timeout);
          }
      }
      return $self->{timeout};
  }
  
  sub new {
      my($class, %args) = @_;
  
      my $self = {
          max_redirect => 5,
          timeout      => defined $args{timeout} ? $args{timeout} : 60,
          keep_alive   => 1,
          verify_SSL   => $args{verify_SSL} || $args{verify_ssl} || 0, # no verification by default
          no_proxy     => $ENV{no_proxy},
      };
  
      bless $self, $class;
  
      $class->_validate_cookie_jar( $args{cookie_jar} ) if $args{cookie_jar};
  
      for my $key ( @attributes ) {
          $self->{$key} = $args{$key} if exists $args{$key}
      }
  
      $self->agent( exists $args{agent} ? $args{agent} : $class->_agent );
  
      $self->_set_proxies;
  
      return $self;
  }
  
  sub _set_proxies {
      my ($self) = @_;
  
      # get proxies from %ENV only if not provided; explicit undef will disable
      # getting proxies from the environment
  
      # generic proxy
      if (! exists $self->{proxy} ) {
          $self->{proxy} = $ENV{all_proxy} || $ENV{ALL_PROXY};
      }
  
      if ( defined $self->{proxy} ) {
          $self->_split_proxy( 'generic proxy' => $self->{proxy} ); # validate
      }
      else {
          delete $self->{proxy};
      }
  
      # http proxy
      if (! exists $self->{http_proxy} ) {
          # under CGI, bypass HTTP_PROXY as request sets it from Proxy header
          local $ENV{HTTP_PROXY} if $ENV{REQUEST_METHOD};
          $self->{http_proxy} = $ENV{http_proxy} || $ENV{HTTP_PROXY} || $self->{proxy};
      }
  
      if ( defined $self->{http_proxy} ) {
          $self->_split_proxy( http_proxy => $self->{http_proxy} ); # validate
          $self->{_has_proxy}{http} = 1;
      }
      else {
          delete $self->{http_proxy};
      }
  
      # https proxy
      if (! exists $self->{https_proxy} ) {
          $self->{https_proxy} = $ENV{https_proxy} || $ENV{HTTPS_PROXY} || $self->{proxy};
      }
  
      if ( $self->{https_proxy} ) {
          $self->_split_proxy( https_proxy => $self->{https_proxy} ); # validate
          $self->{_has_proxy}{https} = 1;
      }
      else {
          delete $self->{https_proxy};
      }
  
      # Split no_proxy to array reference if not provided as such
      unless ( ref $self->{no_proxy} eq 'ARRAY' ) {
          $self->{no_proxy} =
              (defined $self->{no_proxy}) ? [ split /\s*,\s*/, $self->{no_proxy} ] : [];
      }
  
      return;
  }
  
  #pod =method get|head|put|post|delete
  #pod
  #pod     $response = $http->get($url);
  #pod     $response = $http->get($url, \%options);
  #pod     $response = $http->head($url);
  #pod
  #pod These methods are shorthand for calling C<request()> for the given method.  The
  #pod URL must have unsafe characters escaped and international domain names encoded.
  #pod See C<request()> for valid options and a description of the response.
  #pod
  #pod The C<success> field of the response will be true if the status code is 2XX.
  #pod
  #pod =cut
  
  for my $sub_name ( qw/get head put post delete/ ) {
      my $req_method = uc $sub_name;
      no strict 'refs';
      eval <<"HERE"; ## no critic
      sub $sub_name {
          my (\$self, \$url, \$args) = \@_;
          \@_ == 2 || (\@_ == 3 && ref \$args eq 'HASH')
          or _croak(q/Usage: \$http->$sub_name(URL, [HASHREF])/ . "\n");
          return \$self->request('$req_method', \$url, \$args || {});
      }
  HERE
  }
  
  #pod =method post_form
  #pod
  #pod     $response = $http->post_form($url, $form_data);
  #pod     $response = $http->post_form($url, $form_data, \%options);
  #pod
  #pod This method executes a C<POST> request and sends the key/value pairs from a
  #pod form data hash or array reference to the given URL with a C<content-type> of
  #pod C<application/x-www-form-urlencoded>.  If data is provided as an array
  #pod reference, the order is preserved; if provided as a hash reference, the terms
  #pod are sorted on key and value for consistency.  See documentation for the
  #pod C<www_form_urlencode> method for details on the encoding.
  #pod
  #pod The URL must have unsafe characters escaped and international domain names
  #pod encoded.  See C<request()> for valid options and a description of the response.
  #pod Any C<content-type> header or content in the options hashref will be ignored.
  #pod
  #pod The C<success> field of the response will be true if the status code is 2XX.
  #pod
  #pod =cut
  
  sub post_form {
      my ($self, $url, $data, $args) = @_;
      (@_ == 3 || @_ == 4 && ref $args eq 'HASH')
          or _croak(q/Usage: $http->post_form(URL, DATAREF, [HASHREF])/ . "\n");
  
      my $headers = {};
      while ( my ($key, $value) = each %{$args->{headers} || {}} ) {
          $headers->{lc $key} = $value;
      }
      delete $args->{headers};
  
      return $self->request('POST', $url, {
              %$args,
              content => $self->www_form_urlencode($data),
              headers => {
                  %$headers,
                  'content-type' => 'application/x-www-form-urlencoded'
              },
          }
      );
  }
  
  #pod =method mirror
  #pod
  #pod     $response = $http->mirror($url, $file, \%options)
  #pod     if ( $response->{success} ) {
  #pod         print "$file is up to date\n";
  #pod     }
  #pod
  #pod Executes a C<GET> request for the URL and saves the response body to the file
  #pod name provided.  The URL must have unsafe characters escaped and international
  #pod domain names encoded.  If the file already exists, the request will include an
  #pod C<If-Modified-Since> header with the modification timestamp of the file.  You
  #pod may specify a different C<If-Modified-Since> header yourself in the C<<
  #pod $options->{headers} >> hash.
  #pod
  #pod The C<success> field of the response will be true if the status code is 2XX
  #pod or if the status code is 304 (unmodified).
  #pod
  #pod If the file was modified and the server response includes a properly
  #pod formatted C<Last-Modified> header, the file modification time will
  #pod be updated accordingly.
  #pod
  #pod =cut
  
  sub mirror {
      my ($self, $url, $file, $args) = @_;
      @_ == 3 || (@_ == 4 && ref $args eq 'HASH')
        or _croak(q/Usage: $http->mirror(URL, FILE, [HASHREF])/ . "\n");
  
      if ( exists $args->{headers} ) {
          my $headers = {};
          while ( my ($key, $value) = each %{$args->{headers} || {}} ) {
              $headers->{lc $key} = $value;
          }
          $args->{headers} = $headers;
      }
  
      if ( -e $file and my $mtime = (stat($file))[9] ) {
          $args->{headers}{'if-modified-since'} ||= $self->_http_date($mtime);
      }
      my $tempfile = $file . int(rand(2**31));
  
      require Fcntl;
      sysopen my $fh, $tempfile, Fcntl::O_CREAT()|Fcntl::O_EXCL()|Fcntl::O_WRONLY()
         or _croak(qq/Error: Could not create temporary file $tempfile for downloading: $!\n/);
      binmode $fh;
      $args->{data_callback} = sub { print {$fh} $_[0] };
      my $response = $self->request('GET', $url, $args);
      close $fh
          or _croak(qq/Error: Caught error closing temporary file $tempfile: $!\n/);
  
      if ( $response->{success} ) {
          rename $tempfile, $file
              or _croak(qq/Error replacing $file with $tempfile: $!\n/);
          my $lm = $response->{headers}{'last-modified'};
          if ( $lm and my $mtime = $self->_parse_http_date($lm) ) {
              utime $mtime, $mtime, $file;
          }
      }
      $response->{success} ||= $response->{status} eq '304';
      unlink $tempfile;
      return $response;
  }
  
  #pod =method request
  #pod
  #pod     $response = $http->request($method, $url);
  #pod     $response = $http->request($method, $url, \%options);
  #pod
  #pod Executes an HTTP request of the given method type ('GET', 'HEAD', 'POST',
  #pod 'PUT', etc.) on the given URL.  The URL must have unsafe characters escaped and
  #pod international domain names encoded.
  #pod
  #pod If the URL includes a "user:password" stanza, they will be used for Basic-style
  #pod authorization headers.  (Authorization headers will not be included in a
  #pod redirected request.) For example:
  #pod
  #pod     $http->request('GET', 'http://Aladdin:open sesame@example.com/');
  #pod
  #pod If the "user:password" stanza contains reserved characters, they must
  #pod be percent-escaped:
  #pod
  #pod     $http->request('GET', 'http://john%40example.com:password@example.com/');
  #pod
  #pod A hashref of options may be appended to modify the request.
  #pod
  #pod Valid options are:
  #pod
  #pod =for :list
  #pod * C<headers> —
  #pod     A hashref containing headers to include with the request.  If the value for
  #pod     a header is an array reference, the header will be output multiple times with
  #pod     each value in the array.  These headers over-write any default headers.
  #pod * C<content> —
  #pod     A scalar to include as the body of the request OR a code reference
  #pod     that will be called iteratively to produce the body of the request
  #pod * C<trailer_callback> —
  #pod     A code reference that will be called if it exists to provide a hashref
  #pod     of trailing headers (only used with chunked transfer-encoding)
  #pod * C<data_callback> —
  #pod     A code reference that will be called for each chunks of the response
  #pod     body received.
  #pod * C<peer> —
  #pod     Override host resolution and force all connections to go only to a
  #pod     specific peer address, regardless of the URL of the request.  This will
  #pod     include any redirections!  This options should be used with extreme
  #pod     caution (e.g. debugging or very special circumstances).
  #pod
  #pod The C<Host> header is generated from the URL in accordance with RFC 2616.  It
  #pod is a fatal error to specify C<Host> in the C<headers> option.  Other headers
  #pod may be ignored or overwritten if necessary for transport compliance.
  #pod
  #pod If the C<content> option is a code reference, it will be called iteratively
  #pod to provide the content body of the request.  It should return the empty
  #pod string or undef when the iterator is exhausted.
  #pod
  #pod If the C<content> option is the empty string, no C<content-type> or
  #pod C<content-length> headers will be generated.
  #pod
  #pod If the C<data_callback> option is provided, it will be called iteratively until
  #pod the entire response body is received.  The first argument will be a string
  #pod containing a chunk of the response body, the second argument will be the
  #pod in-progress response hash reference, as described below.  (This allows
  #pod customizing the action of the callback based on the C<status> or C<headers>
  #pod received prior to the content body.)
  #pod
  #pod The C<request> method returns a hashref containing the response.  The hashref
  #pod will have the following keys:
  #pod
  #pod =for :list
  #pod * C<success> —
  #pod     Boolean indicating whether the operation returned a 2XX status code
  #pod * C<url> —
  #pod     URL that provided the response. This is the URL of the request unless
  #pod     there were redirections, in which case it is the last URL queried
  #pod     in a redirection chain
  #pod * C<status> —
  #pod     The HTTP status code of the response
  #pod * C<reason> —
  #pod     The response phrase returned by the server
  #pod * C<content> —
  #pod     The body of the response.  If the response does not have any content
  #pod     or if a data callback is provided to consume the response body,
  #pod     this will be the empty string
  #pod * C<headers> —
  #pod     A hashref of header fields.  All header field names will be normalized
  #pod     to be lower case. If a header is repeated, the value will be an arrayref;
  #pod     it will otherwise be a scalar string containing the value
  #pod * C<redirects>
  #pod     If this field exists, it is an arrayref of response hash references from
  #pod     redirects in the same order that redirections occurred.  If it does
  #pod     not exist, then no redirections occurred.
  #pod
  #pod On an exception during the execution of the request, the C<status> field will
  #pod contain 599, and the C<content> field will contain the text of the exception.
  #pod
  #pod =cut
  
  my %idempotent = map { $_ => 1 } qw/GET HEAD PUT DELETE OPTIONS TRACE/;
  
  sub request {
      my ($self, $method, $url, $args) = @_;
      @_ == 3 || (@_ == 4 && ref $args eq 'HASH')
        or _croak(q/Usage: $http->request(METHOD, URL, [HASHREF])/ . "\n");
      $args ||= {}; # we keep some state in this during _request
  
      # RFC 2616 Section 8.1.4 mandates a single retry on broken socket
      my $response;
      for ( 0 .. 1 ) {
          $response = eval { $self->_request($method, $url, $args) };
          last unless $@ && $idempotent{$method}
              && $@ =~ m{^(?:Socket closed|Unexpected end)};
      }
  
      if (my $e = $@) {
          # maybe we got a response hash thrown from somewhere deep
          if ( ref $e eq 'HASH' && exists $e->{status} ) {
              $e->{redirects} = delete $args->{_redirects} if @{ $args->{_redirects} || []};
              return $e;
          }
  
          # otherwise, stringify it
          $e = "$e";
          $response = {
              url     => $url,
              success => q{},
              status  => 599,
              reason  => 'Internal Exception',
              content => $e,
              headers => {
                  'content-type'   => 'text/plain',
                  'content-length' => length $e,
              },
              ( @{$args->{_redirects} || []} ? (redirects => delete $args->{_redirects}) : () ),
          };
      }
      return $response;
  }
  
  #pod =method www_form_urlencode
  #pod
  #pod     $params = $http->www_form_urlencode( $data );
  #pod     $response = $http->get("http://example.com/query?$params");
  #pod
  #pod This method converts the key/value pairs from a data hash or array reference
  #pod into a C<x-www-form-urlencoded> string.  The keys and values from the data
  #pod reference will be UTF-8 encoded and escaped per RFC 3986.  If a value is an
  #pod array reference, the key will be repeated with each of the values of the array
  #pod reference.  If data is provided as a hash reference, the key/value pairs in the
  #pod resulting string will be sorted by key and value for consistent ordering.
  #pod
  #pod =cut
  
  sub www_form_urlencode {
      my ($self, $data) = @_;
      (@_ == 2 && ref $data)
          or _croak(q/Usage: $http->www_form_urlencode(DATAREF)/ . "\n");
      (ref $data eq 'HASH' || ref $data eq 'ARRAY')
          or _croak("form data must be a hash or array reference\n");
  
      my @params = ref $data eq 'HASH' ? %$data : @$data;
      @params % 2 == 0
          or _croak("form data reference must have an even number of terms\n");
  
      my @terms;
      while( @params ) {
          my ($key, $value) = splice(@params, 0, 2);
          if ( ref $value eq 'ARRAY' ) {
              unshift @params, map { $key => $_ } @$value;
          }
          else {
              push @terms, join("=", map { $self->_uri_escape($_) } $key, $value);
          }
      }
  
      return join("&", (ref $data eq 'ARRAY') ? (@terms) : (sort @terms) );
  }
  
  #pod =method can_ssl
  #pod
  #pod     $ok         = HTTP::Tiny->can_ssl;
  #pod     ($ok, $why) = HTTP::Tiny->can_ssl;
  #pod     ($ok, $why) = $http->can_ssl;
  #pod
  #pod Indicates if SSL support is available.  When called as a class object, it
  #pod checks for the correct version of L<Net::SSLeay> and L<IO::Socket::SSL>.
  #pod When called as an object methods, if C<SSL_verify> is true or if C<SSL_verify_mode>
  #pod is set in C<SSL_options>, it checks that a CA file is available.
  #pod
  #pod In scalar context, returns a boolean indicating if SSL is available.
  #pod In list context, returns the boolean and a (possibly multi-line) string of
  #pod errors indicating why SSL isn't available.
  #pod
  #pod =cut
  
  sub can_ssl {
      my ($self) = @_;
  
      my($ok, $reason) = (1, '');
  
      # Need IO::Socket::SSL 1.42 for SSL_create_ctx_callback
      local @INC = @INC;
      pop @INC if $INC[-1] eq '.';
      unless (eval {require IO::Socket::SSL; IO::Socket::SSL->VERSION(1.42)}) {
          $ok = 0;
          $reason .= qq/IO::Socket::SSL 1.42 must be installed for https support\n/;
      }
  
      # Need Net::SSLeay 1.49 for MODE_AUTO_RETRY
      unless (eval {require Net::SSLeay; Net::SSLeay->VERSION(1.49)}) {
          $ok = 0;
          $reason .= qq/Net::SSLeay 1.49 must be installed for https support\n/;
      }
  
      # If an object, check that SSL config lets us get a CA if necessary
      if ( ref($self) && ( $self->{verify_SSL} || $self->{SSL_options}{SSL_verify_mode} ) ) {
          my $handle = HTTP::Tiny::Handle->new(
              SSL_options => $self->{SSL_options},
              verify_SSL  => $self->{verify_SSL},
          );
          unless ( eval { $handle->_find_CA_file; 1 } ) {
              $ok = 0;
              $reason .= "$@";
          }
      }
  
      wantarray ? ($ok, $reason) : $ok;
  }
  
  #pod =method connected
  #pod
  #pod     $host = $http->connected;
  #pod     ($host, $port) = $http->connected;
  #pod
  #pod Indicates if a connection to a peer is being kept alive, per the C<keep_alive>
  #pod option.
  #pod
  #pod In scalar context, returns the peer host and port, joined with a colon, or
  #pod C<undef> (if no peer is connected).
  #pod In list context, returns the peer host and port or an empty list (if no peer
  #pod is connected).
  #pod
  #pod B<Note>: This method cannot reliably be used to discover whether the remote
  #pod host has closed its end of the socket.
  #pod
  #pod =cut
  
  sub connected {
      my ($self) = @_;
  
      # If a socket exists...
      if ($self->{handle} && $self->{handle}{fh}) {
          my $socket = $self->{handle}{fh};
  
          # ...and is connected, return the peer host and port.
          if ($socket->connected) {
              return wantarray
                  ? ($socket->peerhost, $socket->peerport)
                  : join(':', $socket->peerhost, $socket->peerport);
          }
      }
      return;
  }
  
  #--------------------------------------------------------------------------#
  # private methods
  #--------------------------------------------------------------------------#
  
  my %DefaultPort = (
      http => 80,
      https => 443,
  );
  
  sub _agent {
      my $class = ref($_[0]) || $_[0];
      (my $default_agent = $class) =~ s{::}{-}g;
      return $default_agent . "/" . $class->VERSION;
  }
  
  sub _request {
      my ($self, $method, $url, $args) = @_;
  
      my ($scheme, $host, $port, $path_query, $auth) = $self->_split_url($url);
  
      my $request = {
          method    => $method,
          scheme    => $scheme,
          host      => $host,
          port      => $port,
          host_port => ($port == $DefaultPort{$scheme} ? $host : "$host:$port"),
          uri       => $path_query,
          headers   => {},
      };
  
      my $peer = $args->{peer} || $host;
  
      # We remove the cached handle so it is not reused in the case of redirect.
      # If all is well, it will be recached at the end of _request.  We only
      # reuse for the same scheme, host and port
      my $handle = delete $self->{handle};
      if ( $handle ) {
          unless ( $handle->can_reuse( $scheme, $host, $port, $peer ) ) {
              $handle->close;
              undef $handle;
          }
      }
      $handle ||= $self->_open_handle( $request, $scheme, $host, $port, $peer );
  
      $self->_prepare_headers_and_cb($request, $args, $url, $auth);
      $handle->write_request($request);
  
      my $response;
      do { $response = $handle->read_response_header }
          until (substr($response->{status},0,1) ne '1');
  
      $self->_update_cookie_jar( $url, $response ) if $self->{cookie_jar};
      my @redir_args = $self->_maybe_redirect($request, $response, $args);
  
      my $known_message_length;
      if ($method eq 'HEAD' || $response->{status} =~ /^[23]04/) {
          # response has no message body
          $known_message_length = 1;
      }
      else {
          # Ignore any data callbacks during redirection.
          my $cb_args = @redir_args ? +{} : $args;
          my $data_cb = $self->_prepare_data_cb($response, $cb_args);
          $known_message_length = $handle->read_body($data_cb, $response);
      }
  
      if ( $self->{keep_alive}
          && $known_message_length
          && $response->{protocol} eq 'HTTP/1.1'
          && ($response->{headers}{connection} || '') ne 'close'
      ) {
          $self->{handle} = $handle;
      }
      else {
          $handle->close;
      }
  
      $response->{success} = substr( $response->{status}, 0, 1 ) eq '2';
      $response->{url} = $url;
  
      # Push the current response onto the stack of redirects if redirecting.
      if (@redir_args) {
          push @{$args->{_redirects}}, $response;
          return $self->_request(@redir_args, $args);
      }
  
      # Copy the stack of redirects into the response before returning.
      $response->{redirects} = delete $args->{_redirects}
        if @{$args->{_redirects}};
      return $response;
  }
  
  sub _open_handle {
      my ($self, $request, $scheme, $host, $port, $peer) = @_;
  
      my $handle  = HTTP::Tiny::Handle->new(
          timeout         => $self->{timeout},
          SSL_options     => $self->{SSL_options},
          verify_SSL      => $self->{verify_SSL},
          local_address   => $self->{local_address},
          keep_alive      => $self->{keep_alive}
      );
  
      if ($self->{_has_proxy}{$scheme} && ! grep { $host =~ /\Q$_\E$/ } @{$self->{no_proxy}}) {
          return $self->_proxy_connect( $request, $handle );
      }
      else {
          return $handle->connect($scheme, $host, $port, $peer);
      }
  }
  
  sub _proxy_connect {
      my ($self, $request, $handle) = @_;
  
      my @proxy_vars;
      if ( $request->{scheme} eq 'https' ) {
          _croak(qq{No https_proxy defined}) unless $self->{https_proxy};
          @proxy_vars = $self->_split_proxy( https_proxy => $self->{https_proxy} );
          if ( $proxy_vars[0] eq 'https' ) {
              _croak(qq{Can't proxy https over https: $request->{uri} via $self->{https_proxy}});
          }
      }
      else {
          _croak(qq{No http_proxy defined}) unless $self->{http_proxy};
          @proxy_vars = $self->_split_proxy( http_proxy => $self->{http_proxy} );
      }
  
      my ($p_scheme, $p_host, $p_port, $p_auth) = @proxy_vars;
  
      if ( length $p_auth && ! defined $request->{headers}{'proxy-authorization'} ) {
          $self->_add_basic_auth_header( $request, 'proxy-authorization' => $p_auth );
      }
  
      $handle->connect($p_scheme, $p_host, $p_port, $p_host);
  
      if ($request->{scheme} eq 'https') {
          $self->_create_proxy_tunnel( $request, $handle );
      }
      else {
          # non-tunneled proxy requires absolute URI
          $request->{uri} = "$request->{scheme}://$request->{host_port}$request->{uri}";
      }
  
      return $handle;
  }
  
  sub _split_proxy {
      my ($self, $type, $proxy) = @_;
  
      my ($scheme, $host, $port, $path_query, $auth) = eval { $self->_split_url($proxy) };
  
      unless(
          defined($scheme) && length($scheme) && length($host) && length($port)
          && $path_query eq '/'
      ) {
          _croak(qq{$type URL must be in format http[s]://[auth@]<host>:<port>/\n});
      }
  
      return ($scheme, $host, $port, $auth);
  }
  
  sub _create_proxy_tunnel {
      my ($self, $request, $handle) = @_;
  
      $handle->_assert_ssl;
  
      my $agent = exists($request->{headers}{'user-agent'})
          ? $request->{headers}{'user-agent'} : $self->{agent};
  
      my $connect_request = {
          method    => 'CONNECT',
          uri       => "$request->{host}:$request->{port}",
          headers   => {
              host => "$request->{host}:$request->{port}",
              'user-agent' => $agent,
          }
      };
  
      if ( $request->{headers}{'proxy-authorization'} ) {
          $connect_request->{headers}{'proxy-authorization'} =
              delete $request->{headers}{'proxy-authorization'};
      }
  
      $handle->write_request($connect_request);
      my $response;
      do { $response = $handle->read_response_header }
          until (substr($response->{status},0,1) ne '1');
  
      # if CONNECT failed, throw the response so it will be
      # returned from the original request() method;
      unless (substr($response->{status},0,1) eq '2') {
          die $response;
      }
  
      # tunnel established, so start SSL handshake
      $handle->start_ssl( $request->{host} );
  
      return;
  }
  
  sub _prepare_headers_and_cb {
      my ($self, $request, $args, $url, $auth) = @_;
  
      for ($self->{default_headers}, $args->{headers}) {
          next unless defined;
          while (my ($k, $v) = each %$_) {
              $request->{headers}{lc $k} = $v;
              $request->{header_case}{lc $k} = $k;
          }
      }
  
      if (exists $request->{headers}{'host'}) {
          die(qq/The 'Host' header must not be provided as header option\n/);
      }
  
      $request->{headers}{'host'}         = $request->{host_port};
      $request->{headers}{'user-agent'} ||= $self->{agent};
      $request->{headers}{'connection'}   = "close"
          unless $self->{keep_alive};
  
      if ( defined $args->{content} ) {
          if (ref $args->{content} eq 'CODE') {
              $request->{headers}{'content-type'} ||= "application/octet-stream";
              $request->{headers}{'transfer-encoding'} = 'chunked'
                unless $request->{headers}{'content-length'}
                    || $request->{headers}{'transfer-encoding'};
              $request->{cb} = $args->{content};
          }
          elsif ( length $args->{content} ) {
              my $content = $args->{content};
              if ( $] ge '5.008' ) {
                  utf8::downgrade($content, 1)
                      or die(qq/Wide character in request message body\n/);
              }
              $request->{headers}{'content-type'} ||= "application/octet-stream";
              $request->{headers}{'content-length'} = length $content
                unless $request->{headers}{'content-length'}
                    || $request->{headers}{'transfer-encoding'};
              $request->{cb} = sub { substr $content, 0, length $content, '' };
          }
          $request->{trailer_cb} = $args->{trailer_callback}
              if ref $args->{trailer_callback} eq 'CODE';
      }
  
      ### If we have a cookie jar, then maybe add relevant cookies
      if ( $self->{cookie_jar} ) {
          my $cookies = $self->cookie_jar->cookie_header( $url );
          $request->{headers}{cookie} = $cookies if length $cookies;
      }
  
      # if we have Basic auth parameters, add them
      if ( length $auth && ! defined $request->{headers}{authorization} ) {
          $self->_add_basic_auth_header( $request, 'authorization' => $auth );
      }
  
      return;
  }
  
  sub _add_basic_auth_header {
      my ($self, $request, $header, $auth) = @_;
      require MIME::Base64;
      $request->{headers}{$header} =
          "Basic " . MIME::Base64::encode_base64($auth, "");
      return;
  }
  
  sub _prepare_data_cb {
      my ($self, $response, $args) = @_;
      my $data_cb = $args->{data_callback};
      $response->{content} = '';
  
      if (!$data_cb || $response->{status} !~ /^2/) {
          if (defined $self->{max_size}) {
              $data_cb = sub {
                  $_[1]->{content} .= $_[0];
                  die(qq/Size of response body exceeds the maximum allowed of $self->{max_size}\n/)
                    if length $_[1]->{content} > $self->{max_size};
              };
          }
          else {
              $data_cb = sub { $_[1]->{content} .= $_[0] };
          }
      }
      return $data_cb;
  }
  
  sub _update_cookie_jar {
      my ($self, $url, $response) = @_;
  
      my $cookies = $response->{headers}->{'set-cookie'};
      return unless defined $cookies;
  
      my @cookies = ref $cookies ? @$cookies : $cookies;
  
      $self->cookie_jar->add( $url, $_ ) for @cookies;
  
      return;
  }
  
  sub _validate_cookie_jar {
      my ($class, $jar) = @_;
  
      # duck typing
      for my $method ( qw/add cookie_header/ ) {
          _croak(qq/Cookie jar must provide the '$method' method\n/)
              unless ref($jar) && ref($jar)->can($method);
      }
  
      return;
  }
  
  sub _maybe_redirect {
      my ($self, $request, $response, $args) = @_;
      my $headers = $response->{headers};
      my ($status, $method) = ($response->{status}, $request->{method});
      $args->{_redirects} ||= [];
  
      if (($status eq '303' or ($status =~ /^30[1278]/ && $method =~ /^GET|HEAD$/))
          and $headers->{location}
          and @{$args->{_redirects}} < $self->{max_redirect}
      ) {
          my $location = ($headers->{location} =~ /^\//)
              ? "$request->{scheme}://$request->{host_port}$headers->{location}"
              : $headers->{location} ;
          return (($status eq '303' ? 'GET' : $method), $location);
      }
      return;
  }
  
  sub _split_url {
      my $url = pop;
  
      # URI regex adapted from the URI module
      my ($scheme, $host, $path_query) = $url =~ m<\A([^:/?#]+)://([^/?#]*)([^#]*)>
        or die(qq/Cannot parse URL: '$url'\n/);
  
      $scheme     = lc $scheme;
      $path_query = "/$path_query" unless $path_query =~ m<\A/>;
  
      my $auth = '';
      if ( (my $i = index $host, '@') != -1 ) {
          # user:pass@host
          $auth = substr $host, 0, $i, ''; # take up to the @ for auth
          substr $host, 0, 1, '';          # knock the @ off the host
  
          # userinfo might be percent escaped, so recover real auth info
          $auth =~ s/%([0-9A-Fa-f]{2})/chr(hex($1))/eg;
      }
      my $port = $host =~ s/:(\d*)\z// && length $1 ? $1
               : $scheme eq 'http'                  ? 80
               : $scheme eq 'https'                 ? 443
               : undef;
  
      return ($scheme, (length $host ? lc $host : "localhost") , $port, $path_query, $auth);
  }
  
  # Date conversions adapted from HTTP::Date
  my $DoW = "Sun|Mon|Tue|Wed|Thu|Fri|Sat";
  my $MoY = "Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec";
  sub _http_date {
      my ($sec, $min, $hour, $mday, $mon, $year, $wday) = gmtime($_[1]);
      return sprintf("%s, %02d %s %04d %02d:%02d:%02d GMT",
          substr($DoW,$wday*4,3),
          $mday, substr($MoY,$mon*4,3), $year+1900,
          $hour, $min, $sec
      );
  }
  
  sub _parse_http_date {
      my ($self, $str) = @_;
      require Time::Local;
      my @tl_parts;
      if ($str =~ /^[SMTWF][a-z]+, +(\d{1,2}) ($MoY) +(\d\d\d\d) +(\d\d):(\d\d):(\d\d) +GMT$/) {
          @tl_parts = ($6, $5, $4, $1, (index($MoY,$2)/4), $3);
      }
      elsif ($str =~ /^[SMTWF][a-z]+, +(\d\d)-($MoY)-(\d{2,4}) +(\d\d):(\d\d):(\d\d) +GMT$/ ) {
          @tl_parts = ($6, $5, $4, $1, (index($MoY,$2)/4), $3);
      }
      elsif ($str =~ /^[SMTWF][a-z]+ +($MoY) +(\d{1,2}) +(\d\d):(\d\d):(\d\d) +(?:[^0-9]+ +)?(\d\d\d\d)$/ ) {
          @tl_parts = ($5, $4, $3, $2, (index($MoY,$1)/4), $6);
      }
      return eval {
          my $t = @tl_parts ? Time::Local::timegm(@tl_parts) : -1;
          $t < 0 ? undef : $t;
      };
  }
  
  # URI escaping adapted from URI::Escape
  # c.f. http://www.w3.org/TR/html4/interact/forms.html#h-17.13.4.1
  # perl 5.6 ready UTF-8 encoding adapted from JSON::PP
  my %escapes = map { chr($_) => sprintf("%%%02X", $_) } 0..255;
  $escapes{' '}="+";
  my $unsafe_char = qr/[^A-Za-z0-9\-\._~]/;
  
  sub _uri_escape {
      my ($self, $str) = @_;
      if ( $] ge '5.008' ) {
          utf8::encode($str);
      }
      else {
          $str = pack("U*", unpack("C*", $str)) # UTF-8 encode a byte string
              if ( length $str == do { use bytes; length $str } );
          $str = pack("C*", unpack("C*", $str)); # clear UTF-8 flag
      }
      $str =~ s/($unsafe_char)/$escapes{$1}/ge;
      return $str;
  }
  
  package
      HTTP::Tiny::Handle; # hide from PAUSE/indexers
  use strict;
  use warnings;
  
  use Errno      qw[EINTR EPIPE];
  use IO::Socket qw[SOCK_STREAM];
  use Socket     qw[SOL_SOCKET SO_KEEPALIVE];
  
  # PERL_HTTP_TINY_IPV4_ONLY is a private environment variable to force old
  # behavior if someone is unable to boostrap CPAN from a new perl install; it is
  # not intended for general, per-client use and may be removed in the future
  my $SOCKET_CLASS =
      $ENV{PERL_HTTP_TINY_IPV4_ONLY} ? 'IO::Socket::INET' :
      eval { require IO::Socket::IP; IO::Socket::IP->VERSION(0.25) } ? 'IO::Socket::IP' :
      'IO::Socket::INET';
  
  sub BUFSIZE () { 32768 } ## no critic
  
  my $Printable = sub {
      local $_ = shift;
      s/\r/\\r/g;
      s/\n/\\n/g;
      s/\t/\\t/g;
      s/([^\x20-\x7E])/sprintf('\\x%.2X', ord($1))/ge;
      $_;
  };
  
  my $Token = qr/[\x21\x23-\x27\x2A\x2B\x2D\x2E\x30-\x39\x41-\x5A\x5E-\x7A\x7C\x7E]/;
  my $Field_Content = qr/[[:print:]]+ (?: [\x20\x09]+ [[:print:]]+ )*/x;
  
  sub new {
      my ($class, %args) = @_;
      return bless {
          rbuf             => '',
          timeout          => 60,
          max_line_size    => 16384,
          max_header_lines => 64,
          verify_SSL       => 0,
          SSL_options      => {},
          %args
      }, $class;
  }
  
  sub timeout {
      my ($self, $timeout) = @_;
      if ( @_ > 1 ) {
          $self->{timeout} = $timeout;
          if ( $self->{fh} && $self->{fh}->can('timeout') ) {
              $self->{fh}->timeout($timeout);
          }
      }
      return $self->{timeout};
  }
  
  sub connect {
      @_ == 5 || die(q/Usage: $handle->connect(scheme, host, port, peer)/ . "\n");
      my ($self, $scheme, $host, $port, $peer) = @_;
  
      if ( $scheme eq 'https' ) {
          $self->_assert_ssl;
      }
      elsif ( $scheme ne 'http' ) {
        die(qq/Unsupported URL scheme '$scheme'\n/);
      }
      $self->{fh} = $SOCKET_CLASS->new(
          PeerHost  => $peer,
          PeerPort  => $port,
          $self->{local_address} ?
              ( LocalAddr => $self->{local_address} ) : (),
          Proto     => 'tcp',
          Type      => SOCK_STREAM,
          Timeout   => $self->{timeout},
      ) or die(qq/Could not connect to '$host:$port': $@\n/);
  
      binmode($self->{fh})
        or die(qq/Could not binmode() socket: '$!'\n/);
  
      if ( $self->{keep_alive} ) {
          unless ( defined( $self->{fh}->setsockopt( SOL_SOCKET, SO_KEEPALIVE, 1 ) ) ) {
              CORE::close($self->{fh});
              die(qq/Could not set SO_KEEPALIVE on socket: '$!'\n/);
          }
      }
  
      $self->start_ssl($host) if $scheme eq 'https';
  
      $self->{scheme} = $scheme;
      $self->{host} = $host;
      $self->{peer} = $peer;
      $self->{port} = $port;
      $self->{pid} = $$;
      $self->{tid} = _get_tid();
  
      return $self;
  }
  
  sub start_ssl {
      my ($self, $host) = @_;
  
      # As this might be used via CONNECT after an SSL session
      # to a proxy, we shut down any existing SSL before attempting
      # the handshake
      if ( ref($self->{fh}) eq 'IO::Socket::SSL' ) {
          unless ( $self->{fh}->stop_SSL ) {
              my $ssl_err = IO::Socket::SSL->errstr;
              die(qq/Error halting prior SSL connection: $ssl_err/);
          }
      }
  
      my $ssl_args = $self->_ssl_args($host);
      IO::Socket::SSL->start_SSL(
          $self->{fh},
          %$ssl_args,
          SSL_create_ctx_callback => sub {
              my $ctx = shift;
              Net::SSLeay::CTX_set_mode($ctx, Net::SSLeay::MODE_AUTO_RETRY());
          },
      );
  
      unless ( ref($self->{fh}) eq 'IO::Socket::SSL' ) {
          my $ssl_err = IO::Socket::SSL->errstr;
          die(qq/SSL connection failed for $host: $ssl_err\n/);
      }
  }
  
  sub close {
      @_ == 1 || die(q/Usage: $handle->close()/ . "\n");
      my ($self) = @_;
      CORE::close($self->{fh})
        or die(qq/Could not close socket: '$!'\n/);
  }
  
  sub write {
      @_ == 2 || die(q/Usage: $handle->write(buf)/ . "\n");
      my ($self, $buf) = @_;
  
      if ( $] ge '5.008' ) {
          utf8::downgrade($buf, 1)
              or die(qq/Wide character in write()\n/);
      }
  
      my $len = length $buf;
      my $off = 0;
  
      local $SIG{PIPE} = 'IGNORE';
  
      while () {
          $self->can_write
            or die(qq/Timed out while waiting for socket to become ready for writing\n/);
          my $r = syswrite($self->{fh}, $buf, $len, $off);
          if (defined $r) {
              $len -= $r;
              $off += $r;
              last unless $len > 0;
          }
          elsif ($! == EPIPE) {
              die(qq/Socket closed by remote server: $!\n/);
          }
          elsif ($! != EINTR) {
              if ($self->{fh}->can('errstr')){
                  my $err = $self->{fh}->errstr();
                  die (qq/Could not write to SSL socket: '$err'\n /);
              }
              else {
                  die(qq/Could not write to socket: '$!'\n/);
              }
  
          }
      }
      return $off;
  }
  
  sub read {
      @_ == 2 || @_ == 3 || die(q/Usage: $handle->read(len [, allow_partial])/ . "\n");
      my ($self, $len, $allow_partial) = @_;
  
      my $buf  = '';
      my $got = length $self->{rbuf};
  
      if ($got) {
          my $take = ($got < $len) ? $got : $len;
          $buf  = substr($self->{rbuf}, 0, $take, '');
          $len -= $take;
      }
  
      while ($len > 0) {
          $self->can_read
            or die(q/Timed out while waiting for socket to become ready for reading/ . "\n");
          my $r = sysread($self->{fh}, $buf, $len, length $buf);
          if (defined $r) {
              last unless $r;
              $len -= $r;
          }
          elsif ($! != EINTR) {
              if ($self->{fh}->can('errstr')){
                  my $err = $self->{fh}->errstr();
                  die (qq/Could not read from SSL socket: '$err'\n /);
              }
              else {
                  die(qq/Could not read from socket: '$!'\n/);
              }
          }
      }
      if ($len && !$allow_partial) {
          die(qq/Unexpected end of stream\n/);
      }
      return $buf;
  }
  
  sub readline {
      @_ == 1 || die(q/Usage: $handle->readline()/ . "\n");
      my ($self) = @_;
  
      while () {
          if ($self->{rbuf} =~ s/\A ([^\x0D\x0A]* \x0D?\x0A)//x) {
              return $1;
          }
          if (length $self->{rbuf} >= $self->{max_line_size}) {
              die(qq/Line size exceeds the maximum allowed size of $self->{max_line_size}\n/);
          }
          $self->can_read
            or die(qq/Timed out while waiting for socket to become ready for reading\n/);
          my $r = sysread($self->{fh}, $self->{rbuf}, BUFSIZE, length $self->{rbuf});
          if (defined $r) {
              last unless $r;
          }
          elsif ($! != EINTR) {
              if ($self->{fh}->can('errstr')){
                  my $err = $self->{fh}->errstr();
                  die (qq/Could not read from SSL socket: '$err'\n /);
              }
              else {
                  die(qq/Could not read from socket: '$!'\n/);
              }
          }
      }
      die(qq/Unexpected end of stream while looking for line\n/);
  }
  
  sub read_header_lines {
      @_ == 1 || @_ == 2 || die(q/Usage: $handle->read_header_lines([headers])/ . "\n");
      my ($self, $headers) = @_;
      $headers ||= {};
      my $lines   = 0;
      my $val;
  
      while () {
           my $line = $self->readline;
  
           if (++$lines >= $self->{max_header_lines}) {
               die(qq/Header lines exceeds maximum number allowed of $self->{max_header_lines}\n/);
           }
           elsif ($line =~ /\A ([^\x00-\x1F\x7F:]+) : [\x09\x20]* ([^\x0D\x0A]*)/x) {
               my ($field_name) = lc $1;
               if (exists $headers->{$field_name}) {
                   for ($headers->{$field_name}) {
                       $_ = [$_] unless ref $_ eq "ARRAY";
                       push @$_, $2;
                       $val = \$_->[-1];
                   }
               }
               else {
                   $val = \($headers->{$field_name} = $2);
               }
           }
           elsif ($line =~ /\A [\x09\x20]+ ([^\x0D\x0A]*)/x) {
               $val
                 or die(qq/Unexpected header continuation line\n/);
               next unless length $1;
               $$val .= ' ' if length $$val;
               $$val .= $1;
           }
           elsif ($line =~ /\A \x0D?\x0A \z/x) {
              last;
           }
           else {
              die(q/Malformed header line: / . $Printable->($line) . "\n");
           }
      }
      return $headers;
  }
  
  sub write_request {
      @_ == 2 || die(q/Usage: $handle->write_request(request)/ . "\n");
      my($self, $request) = @_;
      $self->write_request_header(@{$request}{qw/method uri headers header_case/});
      $self->write_body($request) if $request->{cb};
      return;
  }
  
  # Standard request header names/case from HTTP/1.1 RFCs
  my @rfc_request_headers = qw(
    Accept Accept-Charset Accept-Encoding Accept-Language Authorization
    Cache-Control Connection Content-Length Expect From Host
    If-Match If-Modified-Since If-None-Match If-Range If-Unmodified-Since
    Max-Forwards Pragma Proxy-Authorization Range Referer TE Trailer
    Transfer-Encoding Upgrade User-Agent Via
  );
  
  my @other_request_headers = qw(
    Content-Encoding Content-MD5 Content-Type Cookie DNT Date Origin
    X-XSS-Protection
  );
  
  my %HeaderCase = map { lc($_) => $_ } @rfc_request_headers, @other_request_headers;
  
  # to avoid multiple small writes and hence nagle, you can pass the method line or anything else to
  # combine writes.
  sub write_header_lines {
      (@_ >= 2 && @_ <= 4 && ref $_[1] eq 'HASH') || die(q/Usage: $handle->write_header_lines(headers, [header_case, prefix])/ . "\n");
      my($self, $headers, $header_case, $prefix_data) = @_;
      $header_case ||= {};
  
      my $buf = (defined $prefix_data ? $prefix_data : '');
  
      # Per RFC, control fields should be listed first
      my %seen;
      for my $k ( qw/host cache-control expect max-forwards pragma range te/ ) {
          next unless exists $headers->{$k};
          $seen{$k}++;
          my $field_name = $HeaderCase{$k};
          my $v = $headers->{$k};
          for (ref $v eq 'ARRAY' ? @$v : $v) {
              $_ = '' unless defined $_;
              $buf .= "$field_name: $_\x0D\x0A";
          }
      }
  
      # Other headers sent in arbitrary order
      while (my ($k, $v) = each %$headers) {
          my $field_name = lc $k;
          next if $seen{$field_name};
          if (exists $HeaderCase{$field_name}) {
              $field_name = $HeaderCase{$field_name};
          }
          else {
              if (exists $header_case->{$field_name}) {
                  $field_name = $header_case->{$field_name};
              }
              else {
                  $field_name =~ s/\b(\w)/\u$1/g;
              }
              $field_name =~ /\A $Token+ \z/xo
                or die(q/Invalid HTTP header field name: / . $Printable->($field_name) . "\n");
              $HeaderCase{lc $field_name} = $field_name;
          }
          for (ref $v eq 'ARRAY' ? @$v : $v) {
              # unwrap a field value if pre-wrapped by user
              s/\x0D?\x0A\s+/ /g;
              die(qq/Invalid HTTP header field value ($field_name): / . $Printable->($_). "\n")
                unless $_ eq '' || /\A $Field_Content \z/xo;
              $_ = '' unless defined $_;
              $buf .= "$field_name: $_\x0D\x0A";
          }
      }
      $buf .= "\x0D\x0A";
      return $self->write($buf);
  }
  
  # return value indicates whether message length was defined; this is generally
  # true unless there was no content-length header and we just read until EOF.
  # Other message length errors are thrown as exceptions
  sub read_body {
      @_ == 3 || die(q/Usage: $handle->read_body(callback, response)/ . "\n");
      my ($self, $cb, $response) = @_;
      my $te = $response->{headers}{'transfer-encoding'} || '';
      my $chunked = grep { /chunked/i } ( ref $te eq 'ARRAY' ? @$te : $te ) ;
      return $chunked
          ? $self->read_chunked_body($cb, $response)
          : $self->read_content_body($cb, $response);
  }
  
  sub write_body {
      @_ == 2 || die(q/Usage: $handle->write_body(request)/ . "\n");
      my ($self, $request) = @_;
      if ($request->{headers}{'content-length'}) {
          return $self->write_content_body($request);
      }
      else {
          return $self->write_chunked_body($request);
      }
  }
  
  sub read_content_body {
      @_ == 3 || @_ == 4 || die(q/Usage: $handle->read_content_body(callback, response, [read_length])/ . "\n");
      my ($self, $cb, $response, $content_length) = @_;
      $content_length ||= $response->{headers}{'content-length'};
  
      if ( defined $content_length ) {
          my $len = $content_length;
          while ($len > 0) {
              my $read = ($len > BUFSIZE) ? BUFSIZE : $len;
              $cb->($self->read($read, 0), $response);
              $len -= $read;
          }
          return length($self->{rbuf}) == 0;
      }
  
      my $chunk;
      $cb->($chunk, $response) while length( $chunk = $self->read(BUFSIZE, 1) );
  
      return;
  }
  
  sub write_content_body {
      @_ == 2 || die(q/Usage: $handle->write_content_body(request)/ . "\n");
      my ($self, $request) = @_;
  
      my ($len, $content_length) = (0, $request->{headers}{'content-length'});
      while () {
          my $data = $request->{cb}->();
  
          defined $data && length $data
            or last;
  
          if ( $] ge '5.008' ) {
              utf8::downgrade($data, 1)
                  or die(qq/Wide character in write_content()\n/);
          }
  
          $len += $self->write($data);
      }
  
      $len == $content_length
        or die(qq/Content-Length mismatch (got: $len expected: $content_length)\n/);
  
      return $len;
  }
  
  sub read_chunked_body {
      @_ == 3 || die(q/Usage: $handle->read_chunked_body(callback, $response)/ . "\n");
      my ($self, $cb, $response) = @_;
  
      while () {
          my $head = $self->readline;
  
          $head =~ /\A ([A-Fa-f0-9]+)/x
            or die(q/Malformed chunk head: / . $Printable->($head) . "\n");
  
          my $len = hex($1)
            or last;
  
          $self->read_content_body($cb, $response, $len);
  
          $self->read(2) eq "\x0D\x0A"
            or die(qq/Malformed chunk: missing CRLF after chunk data\n/);
      }
      $self->read_header_lines($response->{headers});
      return 1;
  }
  
  sub write_chunked_body {
      @_ == 2 || die(q/Usage: $handle->write_chunked_body(request)/ . "\n");
      my ($self, $request) = @_;
  
      my $len = 0;
      while () {
          my $data = $request->{cb}->();
  
          defined $data && length $data
            or last;
  
          if ( $] ge '5.008' ) {
              utf8::downgrade($data, 1)
                  or die(qq/Wide character in write_chunked_body()\n/);
          }
  
          $len += length $data;
  
          my $chunk  = sprintf '%X', length $data;
             $chunk .= "\x0D\x0A";
             $chunk .= $data;
             $chunk .= "\x0D\x0A";
  
          $self->write($chunk);
      }
      $self->write("0\x0D\x0A");
      if ( ref $request->{trailer_cb} eq 'CODE' ) {
          $self->write_header_lines($request->{trailer_cb}->())
      }
      else {
          $self->write("\x0D\x0A");
      }
      return $len;
  }
  
  sub read_response_header {
      @_ == 1 || die(q/Usage: $handle->read_response_header()/ . "\n");
      my ($self) = @_;
  
      my $line = $self->readline;
  
      $line =~ /\A (HTTP\/(0*\d+\.0*\d+)) [\x09\x20]+ ([0-9]{3}) [\x09\x20]+ ([^\x0D\x0A]*) \x0D?\x0A/x
        or die(q/Malformed Status-Line: / . $Printable->($line). "\n");
  
      my ($protocol, $version, $status, $reason) = ($1, $2, $3, $4);
  
      die (qq/Unsupported HTTP protocol: $protocol\n/)
          unless $version =~ /0*1\.0*[01]/;
  
      return {
          status       => $status,
          reason       => $reason,
          headers      => $self->read_header_lines,
          protocol     => $protocol,
      };
  }
  
  sub write_request_header {
      @_ == 5 || die(q/Usage: $handle->write_request_header(method, request_uri, headers, header_case)/ . "\n");
      my ($self, $method, $request_uri, $headers, $header_case) = @_;
  
      return $self->write_header_lines($headers, $header_case, "$method $request_uri HTTP/1.1\x0D\x0A");
  }
  
  sub _do_timeout {
      my ($self, $type, $timeout) = @_;
      $timeout = $self->{timeout}
          unless defined $timeout && $timeout >= 0;
  
      my $fd = fileno $self->{fh};
      defined $fd && $fd >= 0
        or die(qq/select(2): 'Bad file descriptor'\n/);
  
      my $initial = time;
      my $pending = $timeout;
      my $nfound;
  
      vec(my $fdset = '', $fd, 1) = 1;
  
      while () {
          $nfound = ($type eq 'read')
              ? select($fdset, undef, undef, $pending)
              : select(undef, $fdset, undef, $pending) ;
          if ($nfound == -1) {
              $! == EINTR
                or die(qq/select(2): '$!'\n/);
              redo if !$timeout || ($pending = $timeout - (time - $initial)) > 0;
              $nfound = 0;
          }
          last;
      }
      $! = 0;
      return $nfound;
  }
  
  sub can_read {
      @_ == 1 || @_ == 2 || die(q/Usage: $handle->can_read([timeout])/ . "\n");
      my $self = shift;
      if ( ref($self->{fh}) eq 'IO::Socket::SSL' ) {
          return 1 if $self->{fh}->pending;
      }
      return $self->_do_timeout('read', @_)
  }
  
  sub can_write {
      @_ == 1 || @_ == 2 || die(q/Usage: $handle->can_write([timeout])/ . "\n");
      my $self = shift;
      return $self->_do_timeout('write', @_)
  }
  
  sub _assert_ssl {
      my($ok, $reason) = HTTP::Tiny->can_ssl();
      die $reason unless $ok;
  }
  
  sub can_reuse {
      my ($self,$scheme,$host,$port,$peer) = @_;
      return 0 if
          $self->{pid} != $$
          || $self->{tid} != _get_tid()
          || length($self->{rbuf})
          || $scheme ne $self->{scheme}
          || $host ne $self->{host}
          || $port ne $self->{port}
          || $peer ne $self->{peer}
          || eval { $self->can_read(0) }
          || $@ ;
          return 1;
  }
  
  # Try to find a CA bundle to validate the SSL cert,
  # prefer Mozilla::CA or fallback to a system file
  sub _find_CA_file {
      my $self = shift();
  
      my $ca_file =
        defined( $self->{SSL_options}->{SSL_ca_file} )
        ? $self->{SSL_options}->{SSL_ca_file}
        : $ENV{SSL_CERT_FILE};
  
      if ( defined $ca_file ) {
          unless ( -r $ca_file ) {
              die qq/SSL_ca_file '$ca_file' not found or not readable\n/;
          }
          return $ca_file;
      }
  
      local @INC = @INC;
      pop @INC if $INC[-1] eq '.';
      return Mozilla::CA::SSL_ca_file()
          if eval { require Mozilla::CA; 1 };
  
      # cert list copied from golang src/crypto/x509/root_unix.go
      foreach my $ca_bundle (
          "/etc/ssl/certs/ca-certificates.crt",     # Debian/Ubuntu/Gentoo etc.
          "/etc/pki/tls/certs/ca-bundle.crt",       # Fedora/RHEL
          "/etc/ssl/ca-bundle.pem",                 # OpenSUSE
          "/etc/openssl/certs/ca-certificates.crt", # NetBSD
          "/etc/ssl/cert.pem",                      # OpenBSD
          "/usr/local/share/certs/ca-root-nss.crt", # FreeBSD/DragonFly
          "/etc/pki/tls/cacert.pem",                # OpenELEC
          "/etc/certs/ca-certificates.crt",         # Solaris 11.2+
      ) {
          return $ca_bundle if -e $ca_bundle;
      }
  
      die qq/Couldn't find a CA bundle with which to verify the SSL certificate.\n/
        . qq/Try installing Mozilla::CA from CPAN\n/;
  }
  
  # for thread safety, we need to know thread id if threads are loaded
  sub _get_tid {
      no warnings 'reserved'; # for 'threads'
      return threads->can("tid") ? threads->tid : 0;
  }
  
  sub _ssl_args {
      my ($self, $host) = @_;
  
      my %ssl_args;
  
      # This test reimplements IO::Socket::SSL::can_client_sni(), which wasn't
      # added until IO::Socket::SSL 1.84
      if ( Net::SSLeay::OPENSSL_VERSION_NUMBER() >= 0x01000000 ) {
          $ssl_args{SSL_hostname} = $host,          # Sane SNI support
      }
  
      if ($self->{verify_SSL}) {
          $ssl_args{SSL_verifycn_scheme}  = 'http'; # enable CN validation
          $ssl_args{SSL_verifycn_name}    = $host;  # set validation hostname
          $ssl_args{SSL_verify_mode}      = 0x01;   # enable cert validation
          $ssl_args{SSL_ca_file}          = $self->_find_CA_file;
      }
      else {
          $ssl_args{SSL_verifycn_scheme}  = 'none'; # disable CN validation
          $ssl_args{SSL_verify_mode}      = 0x00;   # disable cert validation
      }
  
      # user options override settings from verify_SSL
      for my $k ( keys %{$self->{SSL_options}} ) {
          $ssl_args{$k} = $self->{SSL_options}{$k} if $k =~ m/^SSL_/;
      }
  
      return \%ssl_args;
  }
  
  1;
  
  __END__
  
  =pod
  
  =encoding UTF-8
  
  =head1 NAME
  
  HTTP::Tiny - A small, simple, correct HTTP/1.1 client
  
  =head1 VERSION
  
  version 0.070
  
  =head1 SYNOPSIS
  
      use HTTP::Tiny;
  
      my $response = HTTP::Tiny->new->get('http://example.com/');
  
      die "Failed!\n" unless $response->{success};
  
      print "$response->{status} $response->{reason}\n";
  
      while (my ($k, $v) = each %{$response->{headers}}) {
          for (ref $v eq 'ARRAY' ? @$v : $v) {
              print "$k: $_\n";
          }
      }
  
      print $response->{content} if length $response->{content};
  
  =head1 DESCRIPTION
  
  This is a very simple HTTP/1.1 client, designed for doing simple
  requests without the overhead of a large framework like L<LWP::UserAgent>.
  
  It is more correct and more complete than L<HTTP::Lite>.  It supports
  proxies and redirection.  It also correctly resumes after EINTR.
  
  If L<IO::Socket::IP> 0.25 or later is installed, HTTP::Tiny will use it instead
  of L<IO::Socket::INET> for transparent support for both IPv4 and IPv6.
  
  Cookie support requires L<HTTP::CookieJar> or an equivalent class.
  
  =head1 METHODS
  
  =head2 new
  
      $http = HTTP::Tiny->new( %attributes );
  
  This constructor returns a new HTTP::Tiny object.  Valid attributes include:
  
  =over 4
  
  =item *
  
  C<agent> — A user-agent string (defaults to 'HTTP-Tiny/$VERSION'). If C<agent> — ends in a space character, the default user-agent string is appended.
  
  =item *
  
  C<cookie_jar> — An instance of L<HTTP::CookieJar> — or equivalent class that supports the C<add> and C<cookie_header> methods
  
  =item *
  
  C<default_headers> — A hashref of default headers to apply to requests
  
  =item *
  
  C<local_address> — The local IP address to bind to
  
  =item *
  
  C<keep_alive> — Whether to reuse the last connection (if for the same scheme, host and port) (defaults to 1)
  
  =item *
  
  C<max_redirect> — Maximum number of redirects allowed (defaults to 5)
  
  =item *
  
  C<max_size> — Maximum response size in bytes (only when not using a data callback).  If defined, responses larger than this will return an exception.
  
  =item *
  
  C<http_proxy> — URL of a proxy server to use for HTTP connections (default is C<$ENV{http_proxy}> — if set)
  
  =item *
  
  C<https_proxy> — URL of a proxy server to use for HTTPS connections (default is C<$ENV{https_proxy}> — if set)
  
  =item *
  
  C<proxy> — URL of a generic proxy server for both HTTP and HTTPS connections (default is C<$ENV{all_proxy}> — if set)
  
  =item *
  
  C<no_proxy> — List of domain suffixes that should not be proxied.  Must be a comma-separated string or an array reference. (default is C<$ENV{no_proxy}> —)
  
  =item *
  
  C<timeout> — Request timeout in seconds (default is 60) If a socket open, read or write takes longer than the timeout, an exception is thrown.
  
  =item *
  
  C<verify_SSL> — A boolean that indicates whether to validate the SSL certificate of an C<https> — connection (default is false)
  
  =item *
  
  C<SSL_options> — A hashref of C<SSL_*> — options to pass through to L<IO::Socket::SSL>
  
  =back
  
  Passing an explicit C<undef> for C<proxy>, C<http_proxy> or C<https_proxy> will
  prevent getting the corresponding proxies from the environment.
  
  Exceptions from C<max_size>, C<timeout> or other errors will result in a
  pseudo-HTTP status code of 599 and a reason of "Internal Exception". The
  content field in the response will contain the text of the exception.
  
  The C<keep_alive> parameter enables a persistent connection, but only to a
  single destination scheme, host and port.  Also, if any connection-relevant
  attributes are modified, or if the process ID or thread ID change, the
  persistent connection will be dropped.  If you want persistent connections
  across multiple destinations, use multiple HTTP::Tiny objects.
  
  See L</SSL SUPPORT> for more on the C<verify_SSL> and C<SSL_options> attributes.
  
  =head2 get|head|put|post|delete
  
      $response = $http->get($url);
      $response = $http->get($url, \%options);
      $response = $http->head($url);
  
  These methods are shorthand for calling C<request()> for the given method.  The
  URL must have unsafe characters escaped and international domain names encoded.
  See C<request()> for valid options and a description of the response.
  
  The C<success> field of the response will be true if the status code is 2XX.
  
  =head2 post_form
  
      $response = $http->post_form($url, $form_data);
      $response = $http->post_form($url, $form_data, \%options);
  
  This method executes a C<POST> request and sends the key/value pairs from a
  form data hash or array reference to the given URL with a C<content-type> of
  C<application/x-www-form-urlencoded>.  If data is provided as an array
  reference, the order is preserved; if provided as a hash reference, the terms
  are sorted on key and value for consistency.  See documentation for the
  C<www_form_urlencode> method for details on the encoding.
  
  The URL must have unsafe characters escaped and international domain names
  encoded.  See C<request()> for valid options and a description of the response.
  Any C<content-type> header or content in the options hashref will be ignored.
  
  The C<success> field of the response will be true if the status code is 2XX.
  
  =head2 mirror
  
      $response = $http->mirror($url, $file, \%options)
      if ( $response->{success} ) {
          print "$file is up to date\n";
      }
  
  Executes a C<GET> request for the URL and saves the response body to the file
  name provided.  The URL must have unsafe characters escaped and international
  domain names encoded.  If the file already exists, the request will include an
  C<If-Modified-Since> header with the modification timestamp of the file.  You
  may specify a different C<If-Modified-Since> header yourself in the C<<
  $options->{headers} >> hash.
  
  The C<success> field of the response will be true if the status code is 2XX
  or if the status code is 304 (unmodified).
  
  If the file was modified and the server response includes a properly
  formatted C<Last-Modified> header, the file modification time will
  be updated accordingly.
  
  =head2 request
  
      $response = $http->request($method, $url);
      $response = $http->request($method, $url, \%options);
  
  Executes an HTTP request of the given method type ('GET', 'HEAD', 'POST',
  'PUT', etc.) on the given URL.  The URL must have unsafe characters escaped and
  international domain names encoded.
  
  If the URL includes a "user:password" stanza, they will be used for Basic-style
  authorization headers.  (Authorization headers will not be included in a
  redirected request.) For example:
  
      $http->request('GET', 'http://Aladdin:open sesame@example.com/');
  
  If the "user:password" stanza contains reserved characters, they must
  be percent-escaped:
  
      $http->request('GET', 'http://john%40example.com:password@example.com/');
  
  A hashref of options may be appended to modify the request.
  
  Valid options are:
  
  =over 4
  
  =item *
  
  C<headers> — A hashref containing headers to include with the request.  If the value for a header is an array reference, the header will be output multiple times with each value in the array.  These headers over-write any default headers.
  
  =item *
  
  C<content> — A scalar to include as the body of the request OR a code reference that will be called iteratively to produce the body of the request
  
  =item *
  
  C<trailer_callback> — A code reference that will be called if it exists to provide a hashref of trailing headers (only used with chunked transfer-encoding)
  
  =item *
  
  C<data_callback> — A code reference that will be called for each chunks of the response body received.
  
  =item *
  
  C<peer> — Override host resolution and force all connections to go only to a specific peer address, regardless of the URL of the request.  This will include any redirections!  This options should be used with extreme caution (e.g. debugging or very special circumstances).
  
  =back
  
  The C<Host> header is generated from the URL in accordance with RFC 2616.  It
  is a fatal error to specify C<Host> in the C<headers> option.  Other headers
  may be ignored or overwritten if necessary for transport compliance.
  
  If the C<content> option is a code reference, it will be called iteratively
  to provide the content body of the request.  It should return the empty
  string or undef when the iterator is exhausted.
  
  If the C<content> option is the empty string, no C<content-type> or
  C<content-length> headers will be generated.
  
  If the C<data_callback> option is provided, it will be called iteratively until
  the entire response body is received.  The first argument will be a string
  containing a chunk of the response body, the second argument will be the
  in-progress response hash reference, as described below.  (This allows
  customizing the action of the callback based on the C<status> or C<headers>
  received prior to the content body.)
  
  The C<request> method returns a hashref containing the response.  The hashref
  will have the following keys:
  
  =over 4
  
  =item *
  
  C<success> — Boolean indicating whether the operation returned a 2XX status code
  
  =item *
  
  C<url> — URL that provided the response. This is the URL of the request unless there were redirections, in which case it is the last URL queried in a redirection chain
  
  =item *
  
  C<status> — The HTTP status code of the response
  
  =item *
  
  C<reason> — The response phrase returned by the server
  
  =item *
  
  C<content> — The body of the response.  If the response does not have any content or if a data callback is provided to consume the response body, this will be the empty string
  
  =item *
  
  C<headers> — A hashref of header fields.  All header field names will be normalized to be lower case. If a header is repeated, the value will be an arrayref; it will otherwise be a scalar string containing the value
  
  =item *
  
  C<redirects> If this field exists, it is an arrayref of response hash references from redirects in the same order that redirections occurred.  If it does not exist, then no redirections occurred.
  
  =back
  
  On an exception during the execution of the request, the C<status> field will
  contain 599, and the C<content> field will contain the text of the exception.
  
  =head2 www_form_urlencode
  
      $params = $http->www_form_urlencode( $data );
      $response = $http->get("http://example.com/query?$params");
  
  This method converts the key/value pairs from a data hash or array reference
  into a C<x-www-form-urlencoded> string.  The keys and values from the data
  reference will be UTF-8 encoded and escaped per RFC 3986.  If a value is an
  array reference, the key will be repeated with each of the values of the array
  reference.  If data is provided as a hash reference, the key/value pairs in the
  resulting string will be sorted by key and value for consistent ordering.
  
  =head2 can_ssl
  
      $ok         = HTTP::Tiny->can_ssl;
      ($ok, $why) = HTTP::Tiny->can_ssl;
      ($ok, $why) = $http->can_ssl;
  
  Indicates if SSL support is available.  When called as a class object, it
  checks for the correct version of L<Net::SSLeay> and L<IO::Socket::SSL>.
  When called as an object methods, if C<SSL_verify> is true or if C<SSL_verify_mode>
  is set in C<SSL_options>, it checks that a CA file is available.
  
  In scalar context, returns a boolean indicating if SSL is available.
  In list context, returns the boolean and a (possibly multi-line) string of
  errors indicating why SSL isn't available.
  
  =head2 connected
  
      $host = $http->connected;
      ($host, $port) = $http->connected;
  
  Indicates if a connection to a peer is being kept alive, per the C<keep_alive>
  option.
  
  In scalar context, returns the peer host and port, joined with a colon, or
  C<undef> (if no peer is connected).
  In list context, returns the peer host and port or an empty list (if no peer
  is connected).
  
  B<Note>: This method cannot reliably be used to discover whether the remote
  host has closed its end of the socket.
  
  =for Pod::Coverage SSL_options
  agent
  cookie_jar
  default_headers
  http_proxy
  https_proxy
  keep_alive
  local_address
  max_redirect
  max_size
  no_proxy
  proxy
  timeout
  verify_SSL
  
  =head1 SSL SUPPORT
  
  Direct C<https> connections are supported only if L<IO::Socket::SSL> 1.56 or
  greater and L<Net::SSLeay> 1.49 or greater are installed. An exception will be
  thrown if new enough versions of these modules are not installed or if the SSL
  encryption fails. You can also use C<HTTP::Tiny::can_ssl()> utility function
  that returns boolean to see if the required modules are installed.
  
  An C<https> connection may be made via an C<http> proxy that supports the CONNECT
  command (i.e. RFC 2817).  You may not proxy C<https> via a proxy that itself
  requires C<https> to communicate.
  
  SSL provides two distinct capabilities:
  
  =over 4
  
  =item *
  
  Encrypted communication channel
  
  =item *
  
  Verification of server identity
  
  =back
  
  B<By default, HTTP::Tiny does not verify server identity>.
  
  Server identity verification is controversial and potentially tricky because it
  depends on a (usually paid) third-party Certificate Authority (CA) trust model
  to validate a certificate as legitimate.  This discriminates against servers
  with self-signed certificates or certificates signed by free, community-driven
  CA's such as L<CAcert.org|http://cacert.org>.
  
  By default, HTTP::Tiny does not make any assumptions about your trust model,
  threat level or risk tolerance.  It just aims to give you an encrypted channel
  when you need one.
  
  Setting the C<verify_SSL> attribute to a true value will make HTTP::Tiny verify
  that an SSL connection has a valid SSL certificate corresponding to the host
  name of the connection and that the SSL certificate has been verified by a CA.
  Assuming you trust the CA, this will protect against a L<man-in-the-middle
  attack|http://en.wikipedia.org/wiki/Man-in-the-middle_attack>.  If you are
  concerned about security, you should enable this option.
  
  Certificate verification requires a file containing trusted CA certificates.
  
  If the environment variable C<SSL_CERT_FILE> is present, HTTP::Tiny
  will try to find a CA certificate file in that location.
  
  If the L<Mozilla::CA> module is installed, HTTP::Tiny will use the CA file
  included with it as a source of trusted CA's.  (This means you trust Mozilla,
  the author of Mozilla::CA, the CPAN mirror where you got Mozilla::CA, the
  toolchain used to install it, and your operating system security, right?)
  
  If that module is not available, then HTTP::Tiny will search several
  system-specific default locations for a CA certificate file:
  
  =over 4
  
  =item *
  
  /etc/ssl/certs/ca-certificates.crt
  
  =item *
  
  /etc/pki/tls/certs/ca-bundle.crt
  
  =item *
  
  /etc/ssl/ca-bundle.pem
  
  =back
  
  An exception will be raised if C<verify_SSL> is true and no CA certificate file
  is available.
  
  If you desire complete control over SSL connections, the C<SSL_options> attribute
  lets you provide a hash reference that will be passed through to
  C<IO::Socket::SSL::start_SSL()>, overriding any options set by HTTP::Tiny. For
  example, to provide your own trusted CA file:
  
      SSL_options => {
          SSL_ca_file => $file_path,
      }
  
  The C<SSL_options> attribute could also be used for such things as providing a
  client certificate for authentication to a server or controlling the choice of
  cipher used for the SSL connection. See L<IO::Socket::SSL> documentation for
  details.
  
  =head1 PROXY SUPPORT
  
  HTTP::Tiny can proxy both C<http> and C<https> requests.  Only Basic proxy
  authorization is supported and it must be provided as part of the proxy URL:
  C<http://user:pass@proxy.example.com/>.
  
  HTTP::Tiny supports the following proxy environment variables:
  
  =over 4
  
  =item *
  
  http_proxy or HTTP_PROXY
  
  =item *
  
  https_proxy or HTTPS_PROXY
  
  =item *
  
  all_proxy or ALL_PROXY
  
  =back
  
  If the C<REQUEST_METHOD> environment variable is set, then this might be a CGI
  process and C<HTTP_PROXY> would be set from the C<Proxy:> header, which is a
  security risk.  If C<REQUEST_METHOD> is set, C<HTTP_PROXY> (the upper case
  variant only) is ignored.
  
  Tunnelling C<https> over an C<http> proxy using the CONNECT method is
  supported.  If your proxy uses C<https> itself, you can not tunnel C<https>
  over it.
  
  Be warned that proxying an C<https> connection opens you to the risk of a
  man-in-the-middle attack by the proxy server.
  
  The C<no_proxy> environment variable is supported in the format of a
  comma-separated list of domain extensions proxy should not be used for.
  
  Proxy arguments passed to C<new> will override their corresponding
  environment variables.
  
  =head1 LIMITATIONS
  
  HTTP::Tiny is I<conditionally compliant> with the
  L<HTTP/1.1 specifications|http://www.w3.org/Protocols/>:
  
  =over 4
  
  =item *
  
  "Message Syntax and Routing" [RFC7230]
  
  =item *
  
  "Semantics and Content" [RFC7231]
  
  =item *
  
  "Conditional Requests" [RFC7232]
  
  =item *
  
  "Range Requests" [RFC7233]
  
  =item *
  
  "Caching" [RFC7234]
  
  =item *
  
  "Authentication" [RFC7235]
  
  =back
  
  It attempts to meet all "MUST" requirements of the specification, but does not
  implement all "SHOULD" requirements.  (Note: it was developed against the
  earlier RFC 2616 specification and may not yet meet the revised RFC 7230-7235
  spec.)
  
  Some particular limitations of note include:
  
  =over
  
  =item *
  
  HTTP::Tiny focuses on correct transport.  Users are responsible for ensuring
  that user-defined headers and content are compliant with the HTTP/1.1
  specification.
  
  =item *
  
  Users must ensure that URLs are properly escaped for unsafe characters and that
  international domain names are properly encoded to ASCII. See L<URI::Escape>,
  L<URI::_punycode> and L<Net::IDN::Encode>.
  
  =item *
  
  Redirection is very strict against the specification.  Redirection is only
  automatic for response codes 301, 302, 307 and 308 if the request method is
  'GET' or 'HEAD'.  Response code 303 is always converted into a 'GET'
  redirection, as mandated by the specification.  There is no automatic support
  for status 305 ("Use proxy") redirections.
  
  =item *
  
  There is no provision for delaying a request body using an C<Expect> header.
  Unexpected C<1XX> responses are silently ignored as per the specification.
  
  =item *
  
  Only 'chunked' C<Transfer-Encoding> is supported.
  
  =item *
  
  There is no support for a Request-URI of '*' for the 'OPTIONS' request.
  
  =item *
  
  Headers mentioned in the RFCs and some other, well-known headers are
  generated with their canonical case.  Other headers are sent in the
  case provided by the user.  Except for control headers (which are sent first),
  headers are sent in arbitrary order.
  
  =back
  
  Despite the limitations listed above, HTTP::Tiny is considered
  feature-complete.  New feature requests should be directed to
  L<HTTP::Tiny::UA>.
  
  =head1 SEE ALSO
  
  =over 4
  
  =item *
  
  L<HTTP::Tiny::UA> - Higher level UA features for HTTP::Tiny
  
  =item *
  
  L<HTTP::Thin> - HTTP::Tiny wrapper with L<HTTP::Request>/L<HTTP::Response> compatibility
  
  =item *
  
  L<HTTP::Tiny::Mech> - Wrap L<WWW::Mechanize> instance in HTTP::Tiny compatible interface
  
  =item *
  
  L<IO::Socket::IP> - Required for IPv6 support
  
  =item *
  
  L<IO::Socket::SSL> - Required for SSL support
  
  =item *
  
  L<LWP::UserAgent> - If HTTP::Tiny isn't enough for you, this is the "standard" way to do things
  
  =item *
  
  L<Mozilla::CA> - Required if you want to validate SSL certificates
  
  =item *
  
  L<Net::SSLeay> - Required for SSL support
  
  =back
  
  =for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan
  
  =head1 SUPPORT
  
  =head2 Bugs / Feature Requests
  
  Please report any bugs or feature requests through the issue tracker
  at L<https://github.com/chansen/p5-http-tiny/issues>.
  You will be notified automatically of any progress on your issue.
  
  =head2 Source Code
  
  This is open source software.  The code repository is available for
  public review and contribution under the terms of the license.
  
  L<https://github.com/chansen/p5-http-tiny>
  
    git clone https://github.com/chansen/p5-http-tiny.git
  
  =head1 AUTHORS
  
  =over 4
  
  =item *
  
  Christian Hansen <chansen@cpan.org>
  
  =item *
  
  David Golden <dagolden@cpan.org>
  
  =back
  
  =head1 CONTRIBUTORS
  
  =for stopwords Alan Gardner Alessandro Ghedini A. Sinan Unur Brad Gilbert brian m. carlson Chris Nehren Weyl Claes Jakobsson Clinton Gormley Craig Berry David Golden Dean Pearce Edward Zborowski James Raspass Jeremy Mates Jess Robinson Karen Etheridge Lukas Eklund Martin J. Evans Martin-Louis Bright Mike Doherty Nicolas Rochelemagne Olaf Alders Olivier Mengué Petr Písař SkyMarshal Sören Kornetzki Steve Grazzini Syohei YOSHIDA Tatsuhiko Miyagawa Tom Hukins Tony Cook
  
  =over 4
  
  =item *
  
  Alan Gardner <gardner@pythian.com>
  
  =item *
  
  Alessandro Ghedini <al3xbio@gmail.com>
  
  =item *
  
  A. Sinan Unur <nanis@cpan.org>
  
  =item *
  
  Brad Gilbert <bgills@cpan.org>
  
  =item *
  
  brian m. carlson <sandals@crustytoothpaste.net>
  
  =item *
  
  Chris Nehren <apeiron@cpan.org>
  
  =item *
  
  Chris Weyl <cweyl@alumni.drew.edu>
  
  =item *
  
  Claes Jakobsson <claes@surfar.nu>
  
  =item *
  
  Clinton Gormley <clint@traveljury.com>
  
  =item *
  
  Craig A. Berry <craigberry@mac.com>
  
  =item *
  
  David Golden <xdg@xdg.me>
  
  =item *
  
  Dean Pearce <pearce@pythian.com>
  
  =item *
  
  Edward Zborowski <ed@rubensteintech.com>
  
  =item *
  
  James Raspass <jraspass@gmail.com>
  
  =item *
  
  Jeremy Mates <jmates@cpan.org>
  
  =item *
  
  Jess Robinson <castaway@desert-island.me.uk>
  
  =item *
  
  Karen Etheridge <ether@cpan.org>
  
  =item *
  
  Lukas Eklund <leklund@gmail.com>
  
  =item *
  
  Martin J. Evans <mjegh@ntlworld.com>
  
  =item *
  
  Martin-Louis Bright <mlbright@gmail.com>
  
  =item *
  
  Mike Doherty <doherty@cpan.org>
  
  =item *
  
  Nicolas Rochelemagne <rochelemagne@cpanel.net>
  
  =item *
  
  Olaf Alders <olaf@wundersolutions.com>
  
  =item *
  
  Olivier Mengué <dolmen@cpan.org>
  
  =item *
  
  Petr Písař <ppisar@redhat.com>
  
  =item *
  
  SkyMarshal <skymarshal1729@gmail.com>
  
  =item *
  
  Sören Kornetzki <soeren.kornetzki@delti.com>
  
  =item *
  
  Steve Grazzini <steve.grazzini@grantstreet.com>
  
  =item *
  
  Syohei YOSHIDA <syohex@gmail.com>
  
  =item *
  
  Tatsuhiko Miyagawa <miyagawa@bulknews.net>
  
  =item *
  
  Tom Hukins <tom@eborcom.com>
  
  =item *
  
  Tony Cook <tony@develop-help.com>
  
  =back
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2016 by Christian Hansen.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
HTTP_TINY

$fatpacked{"HTTP/Tinyish.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH';
  package HTTP::Tinyish;
  use strict;
  use warnings;
  use Carp ();
  
  our $VERSION = '0.14';
  
  our $PreferredBackend; # for tests
  our @Backends = map "HTTP::Tinyish::$_", qw( LWP HTTPTiny Curl Wget );
  my %configured;
  
  sub new {
      my($class, %attr) = @_;
      bless \%attr, $class;
  }
  
  for my $method (qw/get head put post delete mirror/) {
      no strict 'refs';
      eval <<"HERE";
      sub $method {
          my \$self = shift;
          \$self->_backend_for(\$_[0])->$method(\@_);
      }
  HERE
  }
  
  sub request {
      my $self = shift;
      $self->_backend_for($_[1])->request(@_);
  }
  
  sub _backend_for {
      my($self, $url) = @_;
  
      my($scheme) = $url =~ m!^(https?):!;
      Carp::croak "URL Scheme '$url' not supported." unless $scheme;
  
      for my $backend ($self->backends) {
          $self->configure_backend($backend) or next;
          if ($backend->supports($scheme)) {
              return $backend->new(%$self);
          }
      }
  
      Carp::croak "No backend configured for scheme $scheme";
  }
  
  sub backends {
      $PreferredBackend ? ($PreferredBackend) : @Backends;
  }
  
  sub configure_backend {
      my($self, $backend) = @_;
      unless (exists $configured{$backend}) {
          $configured{$backend} =
            eval { require_module($backend); $backend->configure };
      }
      $configured{$backend};
  }
  
  sub require_module {
      local $_ = shift;
      s!::!/!g;
      require "$_.pm";
  }
  
  1;
  
  __END__
  
  =head1 NAME
  
  HTTP::Tinyish - HTTP::Tiny compatible HTTP client wrappers
  
  =head1 SYNOPSIS
  
    my $http = HTTP::Tinyish->new(agent => "Mozilla/4.0");
  
    my $res = $http->get("http://www.cpan.org/");
    warn $res->{status};
  
    $http->post("http://example.com/post", {
        headers => { "Content-Type" => "application/x-www-form-urlencoded" },
        content => "foo=bar&baz=quux",
    });
  
    $http->mirror("http://www.cpan.org/modules/02packages.details.txt.gz", "./02packages.details.txt.gz");
  
  =head1 DESCRIPTION
  
  HTTP::Tinyish is a wrapper module for HTTP client modules
  L<LWP>, L<HTTP::Tiny> and HTTP client software C<curl> and C<wget>.
  
  It provides an API compatible to HTTP::Tiny, and the implementation
  has been extracted out of L<App::cpanminus>. This module can be useful
  in a restrictive environment where you need to be able to download
  CPAN modules without an HTTPS support in built-in HTTP library.
  
  =head1 BACKEND SELECTION
  
  Backends are searched in the order of: C<LWP>, L<HTTP::Tiny>, L<Curl>
  and L<Wget>. HTTP::Tinyish will auto-detect if the backend also
  supports HTTPS, and use the appropriate backend based on the given
  URL to the request methods.
  
  For example, if you only have HTTP::Tiny but without SSL related
  modules, it is possible that:
  
    my $http = HTTP::Tinyish->new;
  
    $http->get("http://example.com");  # uses HTTP::Tiny
    $http->get("https://example.com"); # uses curl
  
  =head1 COMPATIBILITIES
  
  All request related methods such as C<get>, C<post>, C<put>,
  C<delete>, C<request> and C<mirror> are supported.
  
  =head2 LWP
  
  =over 4
  
  =item *
  
  L<LWP> backend requires L<LWP> 5.802 or over to be functional, and L<LWP::Protocol::https> to send HTTPS requests.
  
  =item *
  
  C<mirror> method doesn't consider third options hash into account (i.e. you can't override the HTTP headers).
  
  =item *
  
  proxy is automatically detected from environment variables.
  
  =item *
  
  C<timeout>, C<max_redirect>, C<agent>, C<default_headers> and C<verify_SSL> are translated.
  
  =back
  
  =head2 HTTP::Tiny
  
  Because the actual HTTP::Tiny backend is used, all APIs are supported.
  
  =head2 Curl
  
  =over
  
  =item *
  
  This module has been tested with curl 7.22 and later.
  
  =item *
  
  HTTPS support is automatically detected by running C<curl --version> and see its protocol output.
  
  =item *
  
  C<timeout>, C<max_redirect>, C<agent>, C<default_headers> and C<verify_SSL> are supported.
  
  =back
  
  =head2 Wget
  
  =over 4
  
  =item *
  
  This module requires Wget 1.12 and later.
  
  =item *
  
  Wget prior to 1.15 doesn't support sending custom HTTP methods, so if you use C<< $http->put >> for example, you'll get an internal error response (599).
  
  =item *
  
  HTTPS support is automatically detected.
  
  =item *
  
  C<mirror()> method doesn't send C<If-Modified-Since> header to the server, which will result in full-download every time because C<wget> doesn't support C<--timestamping> combined with C<-O> option.
  
  =item *
  
  C<timeout>, C<max_redirect>, C<agent>, C<default_headers> and C<verify_SSL> are supported.
  
  =back
  
  =head1 SIMILAR MODULES
  
  =over 4
  
  =item *
  
  L<File::Fetch> - is core since 5.10. Has support for non-HTTP protocols such as ftp and git. Does not support HTTPS or basic authentication as of this writing.
  
  =item *
  
  L<Plient> - provides more complete runtime API, but seems only compatible on Unix environments. Does not support mirror() method.
  
  =back
  
  =head1 AUTHOR
  
  Tatsuhiko Miyagawa
  
  =head1 COPYRIGHT
  
  Tatsuhiko Miyagawa, 2015-
  
  =head1 LICENSE
  
  This module is licensed under the same terms as Perl itself.
  
  =cut
  
HTTP_TINYISH

$fatpacked{"HTTP/Tinyish/Base.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH_BASE';
  package HTTP::Tinyish::Base;
  use strict;
  use warnings;
  
  for my $sub_name ( qw/get head put post delete/ ) {
      my $req_method = uc $sub_name;
      eval <<"HERE";
      sub $sub_name {
          my (\$self, \$url, \$args) = \@_;
          \@_ == 2 || (\@_ == 3 && ref \$args eq 'HASH')
          or Carp::croak(q/Usage: \$http->$sub_name(URL, [HASHREF])/ . "\n");
          return \$self->request('$req_method', \$url, \$args || {});
      }
  
  HERE
  }
  
  sub parse_http_header {
      my($self, $header, $res) = @_;
  
      # it might have multiple headers in it because of redirects
      $header =~ s/.*^(HTTP\/\d(?:\.\d)?)/$1/ms;
  
      # grab the first chunk until the line break
      if ($header =~ /^(.*?\x0d?\x0a\x0d?\x0a)/) {
          $header = $1;
      }
  
      # parse into lines
      my @header = split /\x0d?\x0a/,$header;
      my $status_line = shift @header;
  
      # join folded lines
      my @out;
      for (@header) {
          if(/^[ \t]+/) {
              return -1 unless @out;
              $out[-1] .= $_;
          } else {
              push @out, $_;
          }
      }
  
      my($proto, $status, $reason) = split / /, $status_line, 3;
      return unless $proto and $proto =~ /^HTTP\/(\d+)(\.(\d+))?$/i;
  
      $res->{status} = $status;
      $res->{reason} = $reason;
      $res->{success} = $status =~ /^(?:2|304)/;
      $res->{protocol} = $proto;
  
      # import headers
      my $token = qr/[^][\x00-\x1f\x7f()<>@,;:\\"\/?={} \t]+/;
      my $k;
      for my $header (@out) {
          if ( $header =~ s/^($token): ?// ) {
              $k = lc $1;
          } elsif ( $header =~ /^\s+/) {
              # multiline header
          } else {
              return -1;
          }
  
          if (exists $res->{headers}{$k}) {
              $res->{headers}{$k} = [$res->{headers}{$k}]
                unless ref $res->{headers}{$k};
              push @{$res->{headers}{$k}}, $header;
          } else {
              $res->{headers}{$k} = $header;
          }
      }
  }
  
  sub internal_error {
      my($self, $url, $message) = @_;
  
      return {
          content => $message,
          headers => { "content-length" => length($message), "content-type" => "text/plain" },
          reason  => "Internal Exception",
          status  => 599,
          success => "",
          url     => $url,
      };
  }
  
  1;
HTTP_TINYISH_BASE

$fatpacked{"HTTP/Tinyish/Curl.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH_CURL';
  package HTTP::Tinyish::Curl;
  use strict;
  use warnings;
  use parent qw(HTTP::Tinyish::Base);
  
  use IPC::Run3 qw(run3);
  use File::Which qw(which);
  use File::Temp ();
  
  my %supports;
  my $curl;
  
  sub _slurp {
      open my $fh, "<", shift or die $!;
      local $/;
      <$fh>;
  }
  
  sub configure {
      my $class = shift;
  
      my %meta;
      $curl = which('curl');
  
      eval {
          run3([$curl, '--version'], \undef, \my $version, \my $error);
          if ($version =~ /^Protocols: (.*)/m) {
              my %protocols = map { $_ => 1 } split /\s/, $1;
              $supports{http}  = 1 if $protocols{http};
              $supports{https} = 1 if $protocols{https};
          }
  
          $meta{$curl} = $version;
      };
  
      \%meta;
  }
  
  sub supports { $supports{$_[1]} }
  
  sub new {
      my($class, %attr) = @_;
      bless \%attr, $class;
  }
  
  sub request {
      my($self, $method, $url, $opts) = @_;
      $opts ||= {};
  
      my(undef, $temp) = File::Temp::tempfile(UNLINK => 1);
  
      my($output, $error);
      eval {
          run3 [
              $curl,
              '-X', $method,
              ($method eq 'HEAD' ? ('--head') : ()),
              $self->build_options($url, $opts),
              '--dump-header', $temp,
              $url,
          ], \undef, \$output, \$error;
      };
  
      if ($@ or $?) {
          return $self->internal_error($url, $@ || $error);
      }
  
      my $res = { url => $url, content => $output };
      $self->parse_http_header( _slurp($temp), $res );
      $res;
  }
  
  sub mirror {
      my($self, $url, $file, $opts) = @_;
      $opts ||= {};
  
      my(undef, $temp) = File::Temp::tempfile(UNLINK => 1);
  
      my($output, $error);
      eval {
          run3 [
              $curl,
              $self->build_options($url, $opts),
              '-z', $file,
              '-o', $file,
              '--dump-header', $temp,
              '--remote-time',
              $url,
          ], \undef, \$output, \$error;
      };
  
      if ($@ or $?) {
          return $self->internal_error($url, $@ || $error);
      }
  
      my $res = { url => $url, content => $output };
      $self->parse_http_header( _slurp($temp), $res );
      $res;
  }
  
  sub build_options {
      my($self, $url, $opts) = @_;
  
      my @options = (
          '--location',
          '--silent',
          '--max-time', ($self->{timeout} || 60),
          '--max-redirs', ($self->{max_redirect} || 5),
          '--user-agent', ($self->{agent} || "HTTP-Tinyish/$HTTP::Tinyish::VERSION"),
      );
  
      my %headers;
      if ($self->{default_headers}) {
          %headers = %{$self->{default_headers}};
      }
      if ($opts->{headers}) {
          %headers = (%headers, %{$opts->{headers}});
      }
      $self->_translate_headers(\%headers, \@options);
  
      unless ($self->{verify_SSL}) {
          push @options, '--insecure';
      }
  
      if ($opts->{content}) {
          my $content;
          if (ref $opts->{content} eq 'CODE') {
              while (my $chunk = $opts->{content}->()) {
                  $content .= $chunk;
              }
          } else {
              $content = $opts->{content};
          }
          push @options, '--data', $content;
      }
  
      @options;
  }
  
  sub _translate_headers {
      my($self, $headers, $options) = @_;
  
      for my $field (keys %$headers) {
          my $value = $headers->{$field};
          if (ref $value eq 'ARRAY') {
              push @$options, map { ('-H', "$field:$_") } @$value;
          } else {
              push @$options, '-H', "$field:$value";
          }
      }
  }
  
  1;
HTTP_TINYISH_CURL

$fatpacked{"HTTP/Tinyish/HTTPTiny.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH_HTTPTINY';
  package HTTP::Tinyish::HTTPTiny;
  use strict;
  use parent qw(HTTP::Tinyish::Base);
  use HTTP::Tiny;
  
  my %supports = (http => 1);
  
  sub configure {
      my %meta = ("HTTP::Tiny" => $HTTP::Tiny::VERSION);
  
      $supports{https} = HTTP::Tiny->can_ssl;
  
      \%meta;
  }
  
  sub supports { $supports{$_[1]} }
  
  sub new {
      my($class, %attrs) = @_;
      bless {
          tiny => HTTP::Tiny->new(%attrs),
      }, $class;
  }
  
  sub request {
      my $self = shift;
      $self->{tiny}->request(@_);
  }
  
  sub mirror {
      my $self = shift;
      $self->{tiny}->mirror(@_);
  }
  
  1;
  
HTTP_TINYISH_HTTPTINY

$fatpacked{"HTTP/Tinyish/LWP.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH_LWP';
  package HTTP::Tinyish::LWP;
  use strict;
  use parent qw(HTTP::Tinyish::Base);
  
  use LWP 5.802;
  use LWP::UserAgent;
  
  my %supports = (http => 1);
  
  sub configure {
      my %meta = (
          LWP => $LWP::VERSION,
      );
  
      if (eval { require LWP::Protocol::https; 1 }) {
          $supports{https} = 1;
          $meta{"LWP::Protocol::https"} = $LWP::Protocol::https::VERSION;
      }
  
      \%meta;
  }
  
  sub supports {
      $supports{$_[1]};
  }
  
  sub new {
      my($class, %attr) = @_;
  
      my $ua = LWP::UserAgent->new;
      
      bless {
          ua => $class->translate_lwp($ua, %attr),
      }, $class;
  }
  
  sub _headers_to_hashref {
      my($self, $hdrs) = @_;
  
      my %headers;
      for my $field ($hdrs->header_field_names) {
          $headers{lc $field} = $hdrs->header($field); # could be an array ref
      }
  
      \%headers;
  }
  
  sub request {
      my($self, $method, $url, $opts) = @_;
      $opts ||= {};
  
      my $req = HTTP::Request->new($method => $url);
  
      if ($opts->{headers}) {
          $req->header(%{$opts->{headers}});
      }
  
      if ($opts->{content}) {
          $req->content($opts->{content});
      }
  
      my $res = $self->{ua}->request($req);
  
      if ($self->is_internal_response($res)) {
          return $self->internal_error($url, $res->content);
      }
  
      return {
          url      => $url,
          content  => $res->decoded_content(charset => 'none'),
          success  => $res->is_success,
          status   => $res->code,
          reason   => $res->message,
          headers  => $self->_headers_to_hashref($res->headers),
          protocol => $res->protocol,
      };
  }
  
  sub mirror {
      my($self, $url, $file) = @_;
  
      # TODO support optional headers
      my $res = $self->{ua}->mirror($url, $file);
  
      if ($self->is_internal_response($res)) {
          return $self->internal_error($url, $res->content);
      }
  
      return {
          url      => $url,
          content  => $res->decoded_content,
          success  => $res->is_success || $res->code == 304,
          status   => $res->code,
          reason   => $res->message,
          headers  => $self->_headers_to_hashref($res->headers),
          protocol => $res->protocol,
      };
  }
  
  sub translate_lwp {
      my($class, $agent, %attr) = @_;
  
      $agent->parse_head(0);
      $agent->env_proxy;
      $agent->timeout(delete $attr{timeout} || 60);
      $agent->max_redirect(delete $attr{max_redirect} || 5);
      $agent->agent(delete $attr{agent} || "HTTP-Tinyish/$HTTP::Tinyish::VERSION");
  
      # LWP default is to verify, HTTP::Tiny isn't
      unless ($attr{verify_SSL}) {
          if ($agent->can("ssl_opts")) {
              $agent->ssl_opts(verify_hostname => 0);
          }
      }
  
      if ($attr{default_headers}) {
          $agent->default_headers( HTTP::Headers->new(%{$attr{default_headers}}) );
      }
  
      $agent;
  }
  
  sub is_internal_response {
      my($self, $res) = @_;
  
      $res->code == 500 &&
        ( $res->header('Client-Warning') || '' ) eq 'Internal response';
  }
  
  1;
HTTP_TINYISH_LWP

$fatpacked{"HTTP/Tinyish/Wget.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'HTTP_TINYISH_WGET';
  package HTTP::Tinyish::Wget;
  use strict;
  use warnings;
  use parent qw(HTTP::Tinyish::Base);
  
  use IPC::Run3 qw(run3);
  use File::Which qw(which);
  
  my %supports;
  my $wget;
  my $method_supported;
  
  sub _run_wget {
      run3([$wget, @_], \undef, \my $out, \my $err);
      wantarray ? ($out, $err) : $out;
  }
  
  sub configure {
      my $class = shift;
      my %meta;
  
      $wget = which('wget');
  
      eval {
          local $ENV{LC_ALL} = 'en_US';
  
          $meta{$wget} = _run_wget('--version');
          unless ($meta{$wget} =~ /GNU Wget 1\.(\d+)/ and $1 >= 12) {
              die "Wget version is too old. $meta{$wget}";
          }
  
          my $config = $class->new(agent => __PACKAGE__);
          my @options = grep { $_ ne '--quiet' } $config->build_options("GET");
  
          my(undef, $err) = _run_wget(@options, 'https://');
          if ($err && $err =~ /HTTPS support not compiled/) {
              $supports{http} = 1;
          } elsif ($err && $err =~ /Invalid host/) {
              $supports{http} = $supports{https} = 1;
          }
  
          (undef, $err) = _run_wget('--method', 'GET', 'http://');
          if ($err && $err =~ /Invalid host/) {
              $method_supported = $meta{method_supported} = 1;
          }
  
      };
  
      \%meta;
  }
  
  sub supports { $supports{$_[1]} }
  
  sub new {
      my($class, %attr) = @_;
      bless \%attr, $class;
  }
  
  sub request {
      my($self, $method, $url, $opts) = @_;
      $opts ||= {};
  
      my($stdout, $stderr);
      eval {
          run3 [
              $wget,
              $self->build_options($method, $url, $opts),
              $url,
              '-O', '-',
          ], \undef, \$stdout, \$stderr;
      };
  
      # wget exit codes: (man wget)
      # 4   Network failure.
      # 5   SSL verification failure.
      # 6   Username/password authentication failure.
      # 7   Protocol errors.
      # 8   Server issued an error response.
      if ($@ or $? && ($? >> 8) <= 5) {
          return $self->internal_error($url, $@ || $stderr);
      }
  
      my $header = '';
      $stderr =~ s{^  (\S.*)$}{ $header .= $1."\n" }gem;
  
      my $res = { url => $url, content => $stdout };
      $self->parse_http_header($header, $res);
      $res;
  }
  
  sub mirror {
      my($self, $url, $file, $opts) = @_;
      $opts ||= {};
  
      # This doesn't send If-Modified-Since because -O and -N are mutually exclusive :(
      my($stdout, $stderr);
      eval {
          run3 [$wget, $self->build_options("GET", $url, $opts), $url, '-O', $file], \undef, \$stdout, \$stderr;
      };
  
      if ($@ or $?) {
          return $self->internal_error($url, $@ || $stderr);
      }
  
      $stderr =~ s/^  //gm;
  
      my $res = { url => $url, content => $stdout };
      $self->parse_http_header($stderr, $res);
      $res;
  }
  
  sub build_options {
      my($self, $method, $url, $opts) = @_;
  
      my @options = (
          '--retry-connrefused',
          '--server-response',
          '--timeout', ($self->{timeout} || 60),
          '--tries', 1,
          '--max-redirect', ($self->{max_redirect} || 5),
          '--user-agent', ($self->{agent} || "HTTP-Tinyish/$HTTP::Tinyish::VERSION"),
      );
  
      if ($method_supported) {
          push @options, "--method", $method;
      } else {
          if ($method eq 'GET' or $method eq 'POST') {
              # OK
          } elsif ($method eq 'HEAD') {
              push @options, '--spider';
          } else {
              die "This version of wget doesn't support specifying HTTP method '$method'";
          }
      }
  
      if ($self->{agent}) {
          push @options, '--user-agent', $self->{agent};
      }
  
      my %headers;
      if ($self->{default_headers}) {
          %headers = %{$self->{default_headers}};
      }
      if ($opts->{headers}) {
          %headers = (%headers, %{$opts->{headers}});
      }
      $self->_translate_headers(\%headers, \@options);
  
      if ($supports{https} && !$self->{verify_SSL}) {
          push @options, '--no-check-certificate';
      }
  
      if ($opts->{content}) {
          my $content;
          if (ref $opts->{content} eq 'CODE') {
              while (my $chunk = $opts->{content}->()) {
                  $content .= $chunk;
              }
          } else {
              $content = $opts->{content};
          }
  
          if ($method_supported) {
              push @options, '--body-data', $content;
          } else {
              push @options, '--post-data', $content;
          }
      }
  
      @options;
  }
  
  sub _translate_headers {
      my($self, $headers, $options) = @_;
  
      for my $field (keys %$headers) {
          my $value = $headers->{$field};
          if (ref $value eq 'ARRAY') {
              # wget doesn't honor multiple header fields
              push @$options, '--header', "$field:" . join(",", @$value);
          } else {
              push @$options, '--header', "$field:$value";
          }
      }
  }
  
  1;
HTTP_TINYISH_WGET

$fatpacked{"IPC/Cmd.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_CMD';
  package IPC::Cmd;
  
  use strict;
  
  BEGIN {
  
      use constant IS_VMS         => $^O eq 'VMS'                       ? 1 : 0;
      use constant IS_WIN32       => $^O eq 'MSWin32'                   ? 1 : 0;
      use constant IS_WIN98       => (IS_WIN32 and !Win32::IsWinNT())   ? 1 : 0;
      use constant ALARM_CLASS    => __PACKAGE__ . '::TimeOut';
      use constant SPECIAL_CHARS  => qw[< > | &];
      use constant QUOTE          => do { IS_WIN32 ? q["] : q['] };
  
      use Exporter    ();
      use vars        qw[ @ISA $VERSION @EXPORT_OK $VERBOSE $DEBUG
                          $USE_IPC_RUN $USE_IPC_OPEN3 $CAN_USE_RUN_FORKED $WARN
                          $INSTANCES $ALLOW_NULL_ARGS
                          $HAVE_MONOTONIC
                      ];
  
      $VERSION        = '1.00';
      $VERBOSE        = 0;
      $DEBUG          = 0;
      $WARN           = 1;
      $USE_IPC_RUN    = IS_WIN32 && !IS_WIN98;
      $USE_IPC_OPEN3  = not IS_VMS;
      $ALLOW_NULL_ARGS = 0;
  
      $CAN_USE_RUN_FORKED = 0;
      eval {
          require POSIX; POSIX->import();
          require IPC::Open3; IPC::Open3->import();
          require IO::Select; IO::Select->import();
          require IO::Handle; IO::Handle->import();
          require FileHandle; FileHandle->import();
          require Socket;
          require Time::HiRes; Time::HiRes->import();
          require Win32 if IS_WIN32;
      };
      $CAN_USE_RUN_FORKED = $@ || !IS_VMS && !IS_WIN32;
  
      eval {
          my $wait_start_time = Time::HiRes::clock_gettime(&Time::HiRes::CLOCK_MONOTONIC);
      };
      if ($@) {
          $HAVE_MONOTONIC = 0;
      }
      else {
          $HAVE_MONOTONIC = 1;
      }
  
      @ISA            = qw[Exporter];
      @EXPORT_OK      = qw[can_run run run_forked QUOTE];
  }
  
  require Carp;
  use File::Spec;
  use Params::Check               qw[check];
  use Text::ParseWords            ();             # import ONLY if needed!
  use Module::Load::Conditional   qw[can_load];
  use Locale::Maketext::Simple    Style => 'gettext';
  
  local $Module::Load::Conditional::FORCE_SAFE_INC = 1;
  
  =pod
  
  =head1 NAME
  
  IPC::Cmd - finding and running system commands made easy
  
  =head1 SYNOPSIS
  
      use IPC::Cmd qw[can_run run run_forked];
  
      my $full_path = can_run('wget') or warn 'wget is not installed!';
  
      ### commands can be arrayrefs or strings ###
      my $cmd = "$full_path -b theregister.co.uk";
      my $cmd = [$full_path, '-b', 'theregister.co.uk'];
  
      ### in scalar context ###
      my $buffer;
      if( scalar run( command => $cmd,
                      verbose => 0,
                      buffer  => \$buffer,
                      timeout => 20 )
      ) {
          print "fetched webpage successfully: $buffer\n";
      }
  
  
      ### in list context ###
      my( $success, $error_message, $full_buf, $stdout_buf, $stderr_buf ) =
              run( command => $cmd, verbose => 0 );
  
      if( $success ) {
          print "this is what the command printed:\n";
          print join "", @$full_buf;
      }
  
      ### run_forked example ###
      my $result = run_forked("$full_path -q -O - theregister.co.uk", {'timeout' => 20});
      if ($result->{'exit_code'} eq 0 && !$result->{'timeout'}) {
          print "this is what wget returned:\n";
          print $result->{'stdout'};
      }
  
      ### check for features
      print "IPC::Open3 available: "  . IPC::Cmd->can_use_ipc_open3;
      print "IPC::Run available: "    . IPC::Cmd->can_use_ipc_run;
      print "Can capture buffer: "    . IPC::Cmd->can_capture_buffer;
  
      ### don't have IPC::Cmd be verbose, ie don't print to stdout or
      ### stderr when running commands -- default is '0'
      $IPC::Cmd::VERBOSE = 0;
  
  
  =head1 DESCRIPTION
  
  IPC::Cmd allows you to run commands platform independently,
  interactively if desired, but have them still work.
  
  The C<can_run> function can tell you if a certain binary is installed
  and if so where, whereas the C<run> function can actually execute any
  of the commands you give it and give you a clear return value, as well
  as adhere to your verbosity settings.
  
  =head1 CLASS METHODS
  
  =head2 $ipc_run_version = IPC::Cmd->can_use_ipc_run( [VERBOSE] )
  
  Utility function that tells you if C<IPC::Run> is available.
  If the C<verbose> flag is passed, it will print diagnostic messages
  if L<IPC::Run> can not be found or loaded.
  
  =cut
  
  
  sub can_use_ipc_run     {
      my $self    = shift;
      my $verbose = shift || 0;
  
      ### IPC::Run doesn't run on win98
      return if IS_WIN98;
  
      ### if we don't have ipc::run, we obviously can't use it.
      return unless can_load(
                          modules => { 'IPC::Run' => '0.55' },
                          verbose => ($WARN && $verbose),
                      );
  
      ### otherwise, we're good to go
      return $IPC::Run::VERSION;
  }
  
  =head2 $ipc_open3_version = IPC::Cmd->can_use_ipc_open3( [VERBOSE] )
  
  Utility function that tells you if C<IPC::Open3> is available.
  If the verbose flag is passed, it will print diagnostic messages
  if C<IPC::Open3> can not be found or loaded.
  
  =cut
  
  
  sub can_use_ipc_open3   {
      my $self    = shift;
      my $verbose = shift || 0;
  
      ### IPC::Open3 is not working on VMS because of a lack of fork.
      return if IS_VMS;
  
      ### IPC::Open3 works on every non-VMS platform, but it can't
      ### capture buffers on win32 :(
      return unless can_load(
          modules => { map {$_ => '0.0'} qw|IPC::Open3 IO::Select Symbol| },
          verbose => ($WARN && $verbose),
      );
  
      return $IPC::Open3::VERSION;
  }
  
  =head2 $bool = IPC::Cmd->can_capture_buffer
  
  Utility function that tells you if C<IPC::Cmd> is capable of
  capturing buffers in it's current configuration.
  
  =cut
  
  sub can_capture_buffer {
      my $self    = shift;
  
      return 1 if $USE_IPC_RUN    && $self->can_use_ipc_run;
      return 1 if $USE_IPC_OPEN3  && $self->can_use_ipc_open3;
      return;
  }
  
  =head2 $bool = IPC::Cmd->can_use_run_forked
  
  Utility function that tells you if C<IPC::Cmd> is capable of
  providing C<run_forked> on the current platform.
  
  =head1 FUNCTIONS
  
  =head2 $path = can_run( PROGRAM );
  
  C<can_run> takes only one argument: the name of a binary you wish
  to locate. C<can_run> works much like the unix binary C<which> or the bash
  command C<type>, which scans through your path, looking for the requested
  binary.
  
  Unlike C<which> and C<type>, this function is platform independent and
  will also work on, for example, Win32.
  
  If called in a scalar context it will return the full path to the binary
  you asked for if it was found, or C<undef> if it was not.
  
  If called in a list context and the global variable C<$INSTANCES> is a true
  value, it will return a list of the full paths to instances
  of the binary where found in C<PATH>, or an empty list if it was not found.
  
  =cut
  
  sub can_run {
      my $command = shift;
  
      # a lot of VMS executables have a symbol defined
      # check those first
      if ( $^O eq 'VMS' ) {
          require VMS::DCLsym;
          my $syms = VMS::DCLsym->new;
          return $command if scalar $syms->getsym( uc $command );
      }
  
      require File::Spec;
      require ExtUtils::MakeMaker;
  
      my @possibles;
  
      if( File::Spec->file_name_is_absolute($command) ) {
          return MM->maybe_command($command);
  
      } else {
          for my $dir (
              File::Spec->path,
              ( IS_WIN32 ? File::Spec->curdir : () )
          ) {
              next if ! $dir || ! -d $dir;
              my $abs = File::Spec->catfile( IS_WIN32 ? Win32::GetShortPathName( $dir ) : $dir, $command);
              push @possibles, $abs if $abs = MM->maybe_command($abs);
          }
      }
      return @possibles if wantarray and $INSTANCES;
      return shift @possibles;
  }
  
  =head2 $ok | ($ok, $err, $full_buf, $stdout_buff, $stderr_buff) = run( command => COMMAND, [verbose => BOOL, buffer => \$SCALAR, timeout => DIGIT] );
  
  C<run> takes 4 arguments:
  
  =over 4
  
  =item command
  
  This is the command to execute. It may be either a string or an array
  reference.
  This is a required argument.
  
  See L<"Caveats"> for remarks on how commands are parsed and their
  limitations.
  
  =item verbose
  
  This controls whether all output of a command should also be printed
  to STDOUT/STDERR or should only be trapped in buffers (NOTE: buffers
  require L<IPC::Run> to be installed, or your system able to work with
  L<IPC::Open3>).
  
  It will default to the global setting of C<$IPC::Cmd::VERBOSE>,
  which by default is 0.
  
  =item buffer
  
  This will hold all the output of a command. It needs to be a reference
  to a scalar.
  Note that this will hold both the STDOUT and STDERR messages, and you
  have no way of telling which is which.
  If you require this distinction, run the C<run> command in list context
  and inspect the individual buffers.
  
  Of course, this requires that the underlying call supports buffers. See
  the note on buffers above.
  
  =item timeout
  
  Sets the maximum time the command is allowed to run before aborting,
  using the built-in C<alarm()> call. If the timeout is triggered, the
  C<errorcode> in the return value will be set to an object of the
  C<IPC::Cmd::TimeOut> class. See the L<"error message"> section below for
  details.
  
  Defaults to C<0>, meaning no timeout is set.
  
  =back
  
  C<run> will return a simple C<true> or C<false> when called in scalar
  context.
  In list context, you will be returned a list of the following items:
  
  =over 4
  
  =item success
  
  A simple boolean indicating if the command executed without errors or
  not.
  
  =item error message
  
  If the first element of the return value (C<success>) was 0, then some
  error occurred. This second element is the error message the command
  you requested exited with, if available. This is generally a pretty
  printed value of C<$?> or C<$@>. See C<perldoc perlvar> for details on
  what they can contain.
  If the error was a timeout, the C<error message> will be prefixed with
  the string C<IPC::Cmd::TimeOut>, the timeout class.
  
  =item full_buffer
  
  This is an array reference containing all the output the command
  generated.
  Note that buffers are only available if you have L<IPC::Run> installed,
  or if your system is able to work with L<IPC::Open3> -- see below).
  Otherwise, this element will be C<undef>.
  
  =item out_buffer
  
  This is an array reference containing all the output sent to STDOUT the
  command generated. The notes from L<"full_buffer"> apply.
  
  =item error_buffer
  
  This is an arrayreference containing all the output sent to STDERR the
  command generated. The notes from L<"full_buffer"> apply.
  
  
  =back
  
  See the L<"HOW IT WORKS"> section below to see how C<IPC::Cmd> decides
  what modules or function calls to use when issuing a command.
  
  =cut
  
  {   my @acc = qw[ok error _fds];
  
      ### autogenerate accessors ###
      for my $key ( @acc ) {
          no strict 'refs';
          *{__PACKAGE__."::$key"} = sub {
              $_[0]->{$key} = $_[1] if @_ > 1;
              return $_[0]->{$key};
          }
      }
  }
  
  sub can_use_run_forked {
      return $CAN_USE_RUN_FORKED eq "1";
  }
  
  sub get_monotonic_time {
      if ($HAVE_MONOTONIC) {
          return Time::HiRes::clock_gettime(&Time::HiRes::CLOCK_MONOTONIC);
      }
      else {
          return time();
      }
  }
  
  sub adjust_monotonic_start_time {
      my ($ref_vars, $now, $previous) = @_;
  
      # workaround only for those systems which don't have
      # Time::HiRes::CLOCK_MONOTONIC (Mac OSX in particular)
      return if $HAVE_MONOTONIC;
  
      # don't have previous monotonic value (only happens once
      # in the beginning of the program execution)
      return unless $previous;
  
      my $time_diff = $now - $previous;
  
      # adjust previously saved time with the skew value which is
      # either negative when clock moved back or more than 5 seconds --
      # assuming that event loop does happen more often than once
      # per five seconds, which might not be always true (!) but
      # hopefully that's ok, because it's just a workaround
      if ($time_diff > 5 || $time_diff < 0) {
          foreach my $ref_var (@{$ref_vars}) {
              if (defined($$ref_var)) {
                  $$ref_var = $$ref_var + $time_diff;
              }
          }
      }
  }
  
  sub uninstall_signals {
  		return unless defined($IPC::Cmd::{'__old_signals'});
  
  		foreach my $sig_name (keys %{$IPC::Cmd::{'__old_signals'}}) {
  				$SIG{$sig_name} = $IPC::Cmd::{'__old_signals'}->{$sig_name};
  		}
  }
  
  # incompatible with POSIX::SigAction
  #
  sub install_layered_signal {
    my ($s, $handler_code) = @_;
  
    my %available_signals = map {$_ => 1} keys %SIG;
  
    Carp::confess("install_layered_signal got nonexistent signal name [$s]")
      unless defined($available_signals{$s});
    Carp::confess("install_layered_signal expects coderef")
      if !ref($handler_code) || ref($handler_code) ne 'CODE';
  
    $IPC::Cmd::{'__old_signals'} = {}
    		unless defined($IPC::Cmd::{'__old_signals'});
  	$IPC::Cmd::{'__old_signals'}->{$s} = $SIG{$s};
  
    my $previous_handler = $SIG{$s};
  
    my $sig_handler = sub {
      my ($called_sig_name, @sig_param) = @_;
  
      # $s is a closure referring to real signal name
      # for which this handler is being installed.
      # it is used to distinguish between
      # real signal handlers and aliased signal handlers
      my $signal_name = $s;
  
      # $called_sig_name is a signal name which
      # was passed to this signal handler;
      # it doesn't equal $signal_name in case
      # some signal handlers in %SIG point
      # to other signal handler (CHLD and CLD,
      # ABRT and IOT)
      #
      # initial signal handler for aliased signal
      # calls some other signal handler which
      # should not execute the same handler_code again
      if ($called_sig_name eq $signal_name) {
        $handler_code->($signal_name);
      }
  
      # run original signal handler if any (including aliased)
      #
      if (ref($previous_handler)) {
        $previous_handler->($called_sig_name, @sig_param);
      }
    };
  
    $SIG{$s} = $sig_handler;
  }
  
  # give process a chance sending TERM,
  # waiting for a while (2 seconds)
  # and killing it with KILL
  sub kill_gently {
    my ($pid, $opts) = @_;
  
    require POSIX;
  
    $opts = {} unless $opts;
    $opts->{'wait_time'} = 2 unless defined($opts->{'wait_time'});
    $opts->{'first_kill_type'} = 'just_process' unless $opts->{'first_kill_type'};
    $opts->{'final_kill_type'} = 'just_process' unless $opts->{'final_kill_type'};
  
    if ($opts->{'first_kill_type'} eq 'just_process') {
      kill(15, $pid);
    }
    elsif ($opts->{'first_kill_type'} eq 'process_group') {
      kill(-15, $pid);
    }
  
    my $do_wait = 1;
    my $child_finished = 0;
  
    my $wait_start_time = get_monotonic_time();
    my $now;
    my $previous_monotonic_value;
  
    while ($do_wait) {
      $previous_monotonic_value = $now;
      $now = get_monotonic_time();
      
      adjust_monotonic_start_time([\$wait_start_time], $now, $previous_monotonic_value);
  
      if ($now > $wait_start_time + $opts->{'wait_time'}) {
          $do_wait = 0;
          next;
      }
  
      my $waitpid = waitpid($pid, POSIX::WNOHANG);
  
      if ($waitpid eq -1) {
          $child_finished = 1;
          $do_wait = 0;
          next;
      }
      
      Time::HiRes::usleep(250000); # quarter of a second
    }
  
    if (!$child_finished) {
      if ($opts->{'final_kill_type'} eq 'just_process') {
        kill(9, $pid);
      }
      elsif ($opts->{'final_kill_type'} eq 'process_group') {
        kill(-9, $pid);
      }
    }
  }
  
  sub open3_run {
      my ($cmd, $opts) = @_;
  
      $opts = {} unless $opts;
  
      my $child_in = FileHandle->new;
      my $child_out = FileHandle->new;
      my $child_err = FileHandle->new;
      $child_out->autoflush(1);
      $child_err->autoflush(1);
  
      my $pid = open3($child_in, $child_out, $child_err, $cmd);
      Time::HiRes::usleep(1);
  
      # push my child's pid to our parent
      # so in case i am killed parent
      # could stop my child (search for
      # child_child_pid in parent code)
      if ($opts->{'parent_info'}) {
        my $ps = $opts->{'parent_info'};
        print $ps "spawned $pid\n";
      }
  
      if ($child_in && $child_out->opened && $opts->{'child_stdin'}) {
          # If the child process dies for any reason,
          # the next write to CHLD_IN is likely to generate
          # a SIGPIPE in the parent, which is fatal by default.
          # So you may wish to handle this signal.
          #
          # from http://perldoc.perl.org/IPC/Open3.html,
          # absolutely needed to catch piped commands errors.
          #
          local $SIG{'PIPE'} = sub { 1; };
  
          print $child_in $opts->{'child_stdin'};
      }
      close($child_in);
  
      my $child_output = {
          'out' => $child_out->fileno,
          'err' => $child_err->fileno,
          $child_out->fileno => {
              'parent_socket' => $opts->{'parent_stdout'},
              'scalar_buffer' => "",
              'child_handle' => $child_out,
              'block_size' => ($child_out->stat)[11] || 1024,
            },
          $child_err->fileno => {
              'parent_socket' => $opts->{'parent_stderr'},
              'scalar_buffer' => "",
              'child_handle' => $child_err,
              'block_size' => ($child_err->stat)[11] || 1024,
            },
          };
  
      my $select = IO::Select->new();
      $select->add($child_out, $child_err);
  
      # pass any signal to the child
      # effectively creating process
      # strongly attached to the child:
      # it will terminate only after child
      # has terminated (except for SIGKILL,
      # which is specially handled)
      SIGNAL: foreach my $s (keys %SIG) {
          next SIGNAL if $s eq '__WARN__' or $s eq '__DIE__'; # Skip and don't clobber __DIE__ & __WARN__
          my $sig_handler;
          $sig_handler = sub {
              kill("$s", $pid);
              $SIG{$s} = $sig_handler;
          };
          $SIG{$s} = $sig_handler;
      }
  
      my $child_finished = 0;
  
      my $real_exit;
      my $exit_value;
  
      while(!$child_finished) {
  
          # parent was killed otherwise we would have got
          # the same signal as parent and process it same way
          if (getppid() eq "1") {
  
            # end my process group with all the children
            # (i am the process group leader, so my pid
            # equals to the process group id)
            #
            # same thing which is done
            # with $opts->{'clean_up_children'}
            # in run_forked
            #
            kill(-9, $$);
  
            POSIX::_exit 1;
          }
  
          my $waitpid = waitpid($pid, POSIX::WNOHANG);
  
          # child finished, catch it's exit status
          if ($waitpid ne 0 && $waitpid ne -1) {
            $real_exit = $?;
            $exit_value = $? >> 8;
          }
  
          if ($waitpid eq -1) {
            $child_finished = 1;
          }
  
  
          my $ready_fds = [];
          push @{$ready_fds}, $select->can_read(1/100);
  
          READY_FDS: while (scalar(@{$ready_fds})) {
              my $fd = shift @{$ready_fds};
              $ready_fds = [grep {$_ ne $fd} @{$ready_fds}];
  
              my $str = $child_output->{$fd->fileno};
              Carp::confess("child stream not found: $fd") unless $str;
  
              my $data;
              my $count = $fd->sysread($data, $str->{'block_size'});
  
              if ($count) {
                  if ($str->{'parent_socket'}) {
                      my $ph = $str->{'parent_socket'};
                      print $ph $data;
                  }
                  else {
                      $str->{'scalar_buffer'} .= $data;
                  }
              }
              elsif ($count eq 0) {
                  $select->remove($fd);
                  $fd->close();
              }
              else {
                  Carp::confess("error during sysread: " . $!);
              }
  
              push @{$ready_fds}, $select->can_read(1/100) if $child_finished;
          }
  
          Time::HiRes::usleep(1);
      }
  
      # since we've successfully reaped the child,
      # let our parent know about this.
      #
      if ($opts->{'parent_info'}) {
          my $ps = $opts->{'parent_info'};
  
          # child was killed, inform parent
          if ($real_exit & 127) {
            print $ps "$pid killed with " . ($real_exit & 127) . "\n";
          }
  
          print $ps "reaped $pid\n";
      }
  
      if ($opts->{'parent_stdout'} || $opts->{'parent_stderr'}) {
          return $exit_value;
      }
      else {
          return {
              'stdout' => $child_output->{$child_output->{'out'}}->{'scalar_buffer'},
              'stderr' => $child_output->{$child_output->{'err'}}->{'scalar_buffer'},
              'exit_code' => $exit_value,
              };
      }
  }
  
  =head2 $hashref = run_forked( COMMAND, { child_stdin => SCALAR, timeout => DIGIT, stdout_handler => CODEREF, stderr_handler => CODEREF} );
  
  C<run_forked> is used to execute some program or a coderef,
  optionally feed it with some input, get its return code
  and output (both stdout and stderr into separate buffers).
  In addition, it allows to terminate the program
  if it takes too long to finish.
  
  The important and distinguishing feature of run_forked
  is execution timeout which at first seems to be
  quite a simple task but if you think
  that the program which you're spawning
  might spawn some children itself (which
  in their turn could do the same and so on)
  it turns out to be not a simple issue.
  
  C<run_forked> is designed to survive and
  successfully terminate almost any long running task,
  even a fork bomb in case your system has the resources
  to survive during given timeout.
  
  This is achieved by creating separate watchdog process
  which spawns the specified program in a separate
  process session and supervises it: optionally
  feeds it with input, stores its exit code,
  stdout and stderr, terminates it in case
  it runs longer than specified.
  
  Invocation requires the command to be executed or a coderef and optionally a hashref of options:
  
  =over
  
  =item C<timeout>
  
  Specify in seconds how long to run the command before it is killed with SIG_KILL (9),
  which effectively terminates it and all of its children (direct or indirect).
  
  =item C<child_stdin>
  
  Specify some text that will be passed into the C<STDIN> of the executed program.
  
  =item C<stdout_handler>
  
  Coderef of a subroutine to call when a portion of data is received on
  STDOUT from the executing program.
  
  =item C<stderr_handler>
  
  Coderef of a subroutine to call when a portion of data is received on
  STDERR from the executing program.
  
  =item C<wait_loop_callback>
  
  Coderef of a subroutine to call inside of the main waiting loop
  (while C<run_forked> waits for the external to finish or fail).
  It is useful to stop running external process before it ends
  by itself, e.g.
  
    my $r = run_forked("some external command", {
  	  'wait_loop_callback' => sub {
            if (condition) {
                kill(1, $$);
            }
  	  },
  	  'terminate_on_signal' => 'HUP',
  	  });
  
  Combined with C<stdout_handler> and C<stderr_handler> allows terminating
  external command based on its output. Could also be used as a timer
  without engaging with L<alarm> (signals).
  
  Remember that this code could be called every millisecond (depending
  on the output which external command generates), so try to make it
  as lightweight as possible.
  
  =item C<discard_output>
  
  Discards the buffering of the standard output and standard errors for return by run_forked().
  With this option you have to use the std*_handlers to read what the command outputs.
  Useful for commands that send a lot of output.
  
  =item C<terminate_on_parent_sudden_death>
  
  Enable this option if you wish all spawned processes to be killed if the initially spawned
  process (the parent) is killed or dies without waiting for child processes.
  
  =back
  
  C<run_forked> will return a HASHREF with the following keys:
  
  =over
  
  =item C<exit_code>
  
  The exit code of the executed program.
  
  =item C<timeout>
  
  The number of seconds the program ran for before being terminated, or 0 if no timeout occurred.
  
  =item C<stdout>
  
  Holds the standard output of the executed command (or empty string if
  there was no STDOUT output or if C<discard_output> was used; it's always defined!)
  
  =item C<stderr>
  
  Holds the standard error of the executed command (or empty string if
  there was no STDERR output or if C<discard_output> was used; it's always defined!)
  
  =item C<merged>
  
  Holds the standard output and error of the executed command merged into one stream
  (or empty string if there was no output at all or if C<discard_output> was used; it's always defined!)
  
  =item C<err_msg>
  
  Holds some explanation in the case of an error.
  
  =back
  
  =cut
  
  sub run_forked {
      ### container to store things in
      my $self = bless {}, __PACKAGE__;
  
      if (!can_use_run_forked()) {
          Carp::carp("run_forked is not available: $CAN_USE_RUN_FORKED");
          return;
      }
  
      require POSIX;
  
      my ($cmd, $opts) = @_;
      if (ref($cmd) eq 'ARRAY') {
          $cmd = join(" ", @{$cmd});
      }
  
      if (!$cmd) {
          Carp::carp("run_forked expects command to run");
          return;
      }
  
      $opts = {} unless $opts;
      $opts->{'timeout'} = 0 unless $opts->{'timeout'};
      $opts->{'terminate_wait_time'} = 2 unless defined($opts->{'terminate_wait_time'});
  
      # turned on by default
      $opts->{'clean_up_children'} = 1 unless defined($opts->{'clean_up_children'});
  
      # sockets to pass child stdout to parent
      my $child_stdout_socket;
      my $parent_stdout_socket;
  
      # sockets to pass child stderr to parent
      my $child_stderr_socket;
      my $parent_stderr_socket;
  
      # sockets for child -> parent internal communication
      my $child_info_socket;
      my $parent_info_socket;
  
      socketpair($child_stdout_socket, $parent_stdout_socket, &Socket::AF_UNIX, &Socket::SOCK_STREAM, &Socket::PF_UNSPEC) ||
        Carp::confess ("socketpair: $!");
      socketpair($child_stderr_socket, $parent_stderr_socket, &Socket::AF_UNIX, &Socket::SOCK_STREAM, &Socket::PF_UNSPEC) ||
        Carp::confess ("socketpair: $!");
      socketpair($child_info_socket, $parent_info_socket, &Socket::AF_UNIX, &Socket::SOCK_STREAM, &Socket::PF_UNSPEC) ||
        Carp::confess ("socketpair: $!");
  
      $child_stdout_socket->autoflush(1);
      $parent_stdout_socket->autoflush(1);
      $child_stderr_socket->autoflush(1);
      $parent_stderr_socket->autoflush(1);
      $child_info_socket->autoflush(1);
      $parent_info_socket->autoflush(1);
  
      my $start_time = get_monotonic_time();
  
      my $pid;
      if ($pid = fork) {
  
        # we are a parent
        close($parent_stdout_socket);
        close($parent_stderr_socket);
        close($parent_info_socket);
  
        my $flags;
  
        # prepare sockets to read from child
  
        $flags = fcntl($child_stdout_socket, POSIX::F_GETFL, 0) || Carp::confess "can't fnctl F_GETFL: $!";
        $flags |= POSIX::O_NONBLOCK;
        fcntl($child_stdout_socket, POSIX::F_SETFL, $flags) || Carp::confess "can't fnctl F_SETFL: $!";
  
        $flags = fcntl($child_stderr_socket, POSIX::F_GETFL, 0) || Carp::confess "can't fnctl F_GETFL: $!";
        $flags |= POSIX::O_NONBLOCK;
        fcntl($child_stderr_socket, POSIX::F_SETFL, $flags) || Carp::confess "can't fnctl F_SETFL: $!";
  
        $flags = fcntl($child_info_socket, POSIX::F_GETFL, 0) || Carp::confess "can't fnctl F_GETFL: $!";
        $flags |= POSIX::O_NONBLOCK;
        fcntl($child_info_socket, POSIX::F_SETFL, $flags) || Carp::confess "can't fnctl F_SETFL: $!";
  
    #    print "child $pid started\n";
  
        my $child_output = {
          $child_stdout_socket->fileno => {
            'scalar_buffer' => "",
            'child_handle' => $child_stdout_socket,
            'block_size' => ($child_stdout_socket->stat)[11] || 1024,
            'protocol' => 'stdout',
            },
          $child_stderr_socket->fileno => {
            'scalar_buffer' => "",
            'child_handle' => $child_stderr_socket,
            'block_size' => ($child_stderr_socket->stat)[11] || 1024,
            'protocol' => 'stderr',
            },
          $child_info_socket->fileno => {
            'scalar_buffer' => "",
            'child_handle' => $child_info_socket,
            'block_size' => ($child_info_socket->stat)[11] || 1024,
            'protocol' => 'info',
            },
          };
  
        my $select = IO::Select->new();
        $select->add($child_stdout_socket, $child_stderr_socket, $child_info_socket);
  
        my $child_timedout = 0;
        my $child_finished = 0;
        my $child_stdout = '';
        my $child_stderr = '';
        my $child_merged = '';
        my $child_exit_code = 0;
        my $child_killed_by_signal = 0;
        my $parent_died = 0;
  
        my $last_parent_check = 0;
        my $got_sig_child = 0;
        my $got_sig_quit = 0;
        my $orig_sig_child = $SIG{'CHLD'};
  
        $SIG{'CHLD'} = sub { $got_sig_child = get_monotonic_time(); };
  
        if ($opts->{'terminate_on_signal'}) {
          install_layered_signal($opts->{'terminate_on_signal'}, sub { $got_sig_quit = time(); });
        }
  
        my $child_child_pid;
        my $now;
        my $previous_monotonic_value;
  
        while (!$child_finished) {
          $previous_monotonic_value = $now;
          $now = get_monotonic_time();
  
          adjust_monotonic_start_time([\$start_time, \$last_parent_check, \$got_sig_child], $now, $previous_monotonic_value);
  
          if ($opts->{'terminate_on_parent_sudden_death'}) {
            # check for parent once each five seconds
            if ($now > $last_parent_check + 5) {
              if (getppid() eq "1") {
                kill_gently ($pid, {
                  'first_kill_type' => 'process_group',
                  'final_kill_type' => 'process_group',
                  'wait_time' => $opts->{'terminate_wait_time'}
                  });
                $parent_died = 1;
              }
  
              $last_parent_check = $now;
            }
          }
  
          # user specified timeout
          if ($opts->{'timeout'}) {
            if ($now > $start_time + $opts->{'timeout'}) {
              kill_gently ($pid, {
                'first_kill_type' => 'process_group',
                'final_kill_type' => 'process_group',
                'wait_time' => $opts->{'terminate_wait_time'}
                });
              $child_timedout = 1;
            }
          }
  
          # give OS 10 seconds for correct return of waitpid,
          # kill process after that and finish wait loop;
          # shouldn't ever happen -- remove this code?
          if ($got_sig_child) {
            if ($now > $got_sig_child + 10) {
              print STDERR "waitpid did not return -1 for 10 seconds after SIG_CHLD, killing [$pid]\n";
              kill (-9, $pid);
              $child_finished = 1;
            }
          }
  
          if ($got_sig_quit) {
            kill_gently ($pid, {
              'first_kill_type' => 'process_group',
              'final_kill_type' => 'process_group',
              'wait_time' => $opts->{'terminate_wait_time'}
              });
            $child_finished = 1;
          }
  
          my $waitpid = waitpid($pid, POSIX::WNOHANG);
  
          # child finished, catch it's exit status
          if ($waitpid ne 0 && $waitpid ne -1) {
            $child_exit_code = $? >> 8;
          }
  
          if ($waitpid eq -1) {
            $child_finished = 1;
          }
  
          my $ready_fds = [];
          push @{$ready_fds}, $select->can_read(1/100);
  
          READY_FDS: while (scalar(@{$ready_fds})) {
            my $fd = shift @{$ready_fds};
            $ready_fds = [grep {$_ ne $fd} @{$ready_fds}];
  
            my $str = $child_output->{$fd->fileno};
            Carp::confess("child stream not found: $fd") unless $str;
  
            my $data = "";
            my $count = $fd->sysread($data, $str->{'block_size'});
  
            if ($count) {
                # extract all the available lines and store the rest in temporary buffer
                if ($data =~ /(.+\n)([^\n]*)/so) {
                    $data = $str->{'scalar_buffer'} . $1;
                    $str->{'scalar_buffer'} = $2 || "";
                }
                else {
                    $str->{'scalar_buffer'} .= $data;
                    $data = "";
                }
            }
            elsif ($count eq 0) {
              $select->remove($fd);
              $fd->close();
              if ($str->{'scalar_buffer'}) {
                  $data = $str->{'scalar_buffer'} . "\n";
              }
            }
            else {
              Carp::confess("error during sysread on [$fd]: " . $!);
            }
  
            # $data contains only full lines (or last line if it was unfinished read
            # or now new-line in the output of the child); dat is processed
            # according to the "protocol" of socket
            if ($str->{'protocol'} eq 'info') {
              if ($data =~ /^spawned ([0-9]+?)\n(.*?)/so) {
                $child_child_pid = $1;
                $data = $2;
              }
              if ($data =~ /^reaped ([0-9]+?)\n(.*?)/so) {
                $child_child_pid = undef;
                $data = $2;
              }
              if ($data =~ /^[\d]+ killed with ([0-9]+?)\n(.*?)/so) {
                $child_killed_by_signal = $1;
                $data = $2;
              }
  
              # we don't expect any other data in info socket, so it's
              # some strange violation of protocol, better know about this
              if ($data) {
                Carp::confess("info protocol violation: [$data]");
              }
            }
            if ($str->{'protocol'} eq 'stdout') {
              if (!$opts->{'discard_output'}) {
                $child_stdout .= $data;
                $child_merged .= $data;
              }
  
              if ($opts->{'stdout_handler'} && ref($opts->{'stdout_handler'}) eq 'CODE') {
                $opts->{'stdout_handler'}->($data);
              }
            }
            if ($str->{'protocol'} eq 'stderr') {
              if (!$opts->{'discard_output'}) {
                $child_stderr .= $data;
                $child_merged .= $data;
              }
  
              if ($opts->{'stderr_handler'} && ref($opts->{'stderr_handler'}) eq 'CODE') {
                $opts->{'stderr_handler'}->($data);
              }
            }
   
            # process may finish (waitpid returns -1) before
            # we've read all of its output because of buffering;
            # so try to read all the way it is possible to read
            # in such case - this shouldn't be too much (unless
            # the buffer size is HUGE -- should introduce
            # another counter in such case, maybe later)
            #
            push @{$ready_fds}, $select->can_read(1/100) if $child_finished;
          }
  
          if ($opts->{'wait_loop_callback'} && ref($opts->{'wait_loop_callback'}) eq 'CODE') {
            $opts->{'wait_loop_callback'}->();
          }
  
          Time::HiRes::usleep(1);
        }
  
        # $child_pid_pid is not defined in two cases:
        #  * when our child was killed before
        #    it had chance to tell us the pid
        #    of the child it spawned. we can do
        #    nothing in this case :(
        #  * our child successfully reaped its child,
        #    we have nothing left to do in this case
        #
        # defined $child_pid_pid means child's child
        # has not died but nobody is waiting for it,
        # killing it brutally.
        #
        if ($child_child_pid) {
          kill_gently($child_child_pid);
        }
  
        # in case there are forks in child which
        # do not forward or process signals (TERM) correctly
        # kill whole child process group, effectively trying
        # not to return with some children or their parts still running
        #
        # to be more accurate -- we need to be sure
        # that this is process group created by our child
        # (and not some other process group with the same pgid,
        # created just after death of our child) -- fortunately
        # this might happen only when process group ids
        # are reused quickly (there are lots of processes
        # spawning new process groups for example)
        #
        if ($opts->{'clean_up_children'}) {
          kill(-9, $pid);
        }
  
    #    print "child $pid finished\n";
  
        close($child_stdout_socket);
        close($child_stderr_socket);
        close($child_info_socket);
  
        my $o = {
          'stdout' => $child_stdout,
          'stderr' => $child_stderr,
          'merged' => $child_merged,
          'timeout' => $child_timedout ? $opts->{'timeout'} : 0,
          'exit_code' => $child_exit_code,
          'parent_died' => $parent_died,
          'killed_by_signal' => $child_killed_by_signal,
          'child_pgid' => $pid,
          'cmd' => $cmd,
          };
  
        my $err_msg = '';
        if ($o->{'exit_code'}) {
          $err_msg .= "exited with code [$o->{'exit_code'}]\n";
        }
        if ($o->{'timeout'}) {
          $err_msg .= "ran more than [$o->{'timeout'}] seconds\n";
        }
        if ($o->{'parent_died'}) {
          $err_msg .= "parent died\n";
        }
        if ($o->{'stdout'} && !$opts->{'non_empty_stdout_ok'}) {
          $err_msg .= "stdout:\n" . $o->{'stdout'} . "\n";
        }
        if ($o->{'stderr'}) {
          $err_msg .= "stderr:\n" . $o->{'stderr'} . "\n";
        }
        if ($o->{'killed_by_signal'}) {
          $err_msg .= "killed by signal [" . $o->{'killed_by_signal'} . "]\n";
        }
        $o->{'err_msg'} = $err_msg;
  
        if ($orig_sig_child) {
          $SIG{'CHLD'} = $orig_sig_child;
        }
        else {
          delete($SIG{'CHLD'});
        }
  
        uninstall_signals();
  
        return $o;
      }
      else {
        Carp::confess("cannot fork: $!") unless defined($pid);
  
        # create new process session for open3 call,
        # so we hopefully can kill all the subprocesses
        # which might be spawned in it (except for those
        # which do setsid theirselves -- can't do anything
        # with those)
  
        POSIX::setsid() || Carp::confess("Error running setsid: " . $!);
  
        if ($opts->{'child_BEGIN'} && ref($opts->{'child_BEGIN'}) eq 'CODE') {
          $opts->{'child_BEGIN'}->();
        }
  
        close($child_stdout_socket);
        close($child_stderr_socket);
        close($child_info_socket);
  
        my $child_exit_code;
  
        # allow both external programs
        # and internal perl calls
        if (!ref($cmd)) {
          $child_exit_code = open3_run($cmd, {
            'parent_info' => $parent_info_socket,
            'parent_stdout' => $parent_stdout_socket,
            'parent_stderr' => $parent_stderr_socket,
            'child_stdin' => $opts->{'child_stdin'},
            });
        }
        elsif (ref($cmd) eq 'CODE') {
          # reopen STDOUT and STDERR for child code:
          # https://rt.cpan.org/Ticket/Display.html?id=85912
          open STDOUT, '>&', $parent_stdout_socket || Carp::confess("Unable to reopen STDOUT: $!\n");
          open STDERR, '>&', $parent_stderr_socket || Carp::confess("Unable to reopen STDERR: $!\n");
  
          $child_exit_code = $cmd->({
            'opts' => $opts,
            'parent_info' => $parent_info_socket,
            'parent_stdout' => $parent_stdout_socket,
            'parent_stderr' => $parent_stderr_socket,
            'child_stdin' => $opts->{'child_stdin'},
            });
        }
        else {
          print $parent_stderr_socket "Invalid command reference: " . ref($cmd) . "\n";
          $child_exit_code = 1;
        }
  
        close($parent_stdout_socket);
        close($parent_stderr_socket);
        close($parent_info_socket);
  
        if ($opts->{'child_END'} && ref($opts->{'child_END'}) eq 'CODE') {
          $opts->{'child_END'}->();
        }
  
        $| = 1;
        POSIX::_exit $child_exit_code;
      }
  }
  
  sub run {
      ### container to store things in
      my $self = bless {}, __PACKAGE__;
  
      my %hash = @_;
  
      ### if the user didn't provide a buffer, we'll store it here.
      my $def_buf = '';
  
      my($verbose,$cmd,$buffer,$timeout);
      my $tmpl = {
          verbose => { default  => $VERBOSE,  store => \$verbose },
          buffer  => { default  => \$def_buf, store => \$buffer },
          command => { required => 1,         store => \$cmd,
                       allow    => sub { !ref($_[0]) or ref($_[0]) eq 'ARRAY' },
          },
          timeout => { default  => 0,         store => \$timeout },
      };
  
      unless( check( $tmpl, \%hash, $VERBOSE ) ) {
          Carp::carp( loc( "Could not validate input: %1",
                           Params::Check->last_error ) );
          return;
      };
  
      $cmd = _quote_args_vms( $cmd ) if IS_VMS;
  
      ### strip any empty elements from $cmd if present
      if ( $ALLOW_NULL_ARGS ) {
        $cmd = [ grep { defined } @$cmd ] if ref $cmd;
      }
      else {
        $cmd = [ grep { defined && length } @$cmd ] if ref $cmd;
      }
  
      my $pp_cmd = (ref $cmd ? "@$cmd" : $cmd);
      print loc("Running [%1]...\n", $pp_cmd ) if $verbose;
  
      ### did the user pass us a buffer to fill or not? if so, set this
      ### flag so we know what is expected of us
      ### XXX this is now being ignored. in the future, we could add diagnostic
      ### messages based on this logic
      #my $user_provided_buffer = $buffer == \$def_buf ? 0 : 1;
  
      ### buffers that are to be captured
      my( @buffer, @buff_err, @buff_out );
  
      ### capture STDOUT
      my $_out_handler = sub {
          my $buf = shift;
          return unless defined $buf;
  
          print STDOUT $buf if $verbose;
          push @buffer,   $buf;
          push @buff_out, $buf;
      };
  
      ### capture STDERR
      my $_err_handler = sub {
          my $buf = shift;
          return unless defined $buf;
  
          print STDERR $buf if $verbose;
          push @buffer,   $buf;
          push @buff_err, $buf;
      };
  
  
      ### flag to indicate we have a buffer captured
      my $have_buffer = $self->can_capture_buffer ? 1 : 0;
  
      ### flag indicating if the subcall went ok
      my $ok;
  
      ### don't look at previous errors:
      local $?;
      local $@;
      local $!;
  
      ### we might be having a timeout set
      eval {
          local $SIG{ALRM} = sub { die bless sub {
              ALARM_CLASS .
              qq[: Command '$pp_cmd' aborted by alarm after $timeout seconds]
          }, ALARM_CLASS } if $timeout;
          alarm $timeout || 0;
  
          ### IPC::Run is first choice if $USE_IPC_RUN is set.
          if( !IS_WIN32 and $USE_IPC_RUN and $self->can_use_ipc_run( 1 ) ) {
              ### ipc::run handlers needs the command as a string or an array ref
  
              $self->_debug( "# Using IPC::Run. Have buffer: $have_buffer" )
                  if $DEBUG;
  
              $ok = $self->_ipc_run( $cmd, $_out_handler, $_err_handler );
  
          ### since IPC::Open3 works on all platforms, and just fails on
          ### win32 for capturing buffers, do that ideally
          } elsif ( $USE_IPC_OPEN3 and $self->can_use_ipc_open3( 1 ) ) {
  
              $self->_debug("# Using IPC::Open3. Have buffer: $have_buffer")
                  if $DEBUG;
  
              ### in case there are pipes in there;
              ### IPC::Open3 will call exec and exec will do the right thing
  
              my $method = IS_WIN32 ? '_open3_run_win32' : '_open3_run';
  
              $ok = $self->$method(
                                      $cmd, $_out_handler, $_err_handler, $verbose
                                  );
  
          ### if we are allowed to run verbose, just dispatch the system command
          } else {
              $self->_debug( "# Using system(). Have buffer: $have_buffer" )
                  if $DEBUG;
              $ok = $self->_system_run( $cmd, $verbose );
          }
  
          alarm 0;
      };
  
      ### restore STDIN after duping, or STDIN will be closed for
      ### this current perl process!
      $self->__reopen_fds( @{ $self->_fds} ) if $self->_fds;
  
      my $err;
      unless( $ok ) {
          ### alarm happened
          if ( $@ and ref $@ and $@->isa( ALARM_CLASS ) ) {
              $err = $@->();  # the error code is an expired alarm
  
          ### another error happened, set by the dispatchub
          } else {
              $err = $self->error;
          }
      }
  
      ### fill the buffer;
      $$buffer = join '', @buffer if @buffer;
  
      ### return a list of flags and buffers (if available) in list
      ### context, or just a simple 'ok' in scalar
      return wantarray
                  ? $have_buffer
                      ? ($ok, $err, \@buffer, \@buff_out, \@buff_err)
                      : ($ok, $err )
                  : $ok
  
  
  }
  
  sub _open3_run_win32 {
    my $self    = shift;
    my $cmd     = shift;
    my $outhand = shift;
    my $errhand = shift;
  
    require Socket;
  
    my $pipe = sub {
      socketpair($_[0], $_[1], &Socket::AF_UNIX, &Socket::SOCK_STREAM, &Socket::PF_UNSPEC)
          or return undef;
      shutdown($_[0], 1);  # No more writing for reader
      shutdown($_[1], 0);  # No more reading for writer
      return 1;
    };
  
    my $open3 = sub {
      local (*TO_CHLD_R,     *TO_CHLD_W);
      local (*FR_CHLD_R,     *FR_CHLD_W);
      local (*FR_CHLD_ERR_R, *FR_CHLD_ERR_W);
  
      $pipe->(*TO_CHLD_R,     *TO_CHLD_W    ) or die $^E;
      $pipe->(*FR_CHLD_R,     *FR_CHLD_W    ) or die $^E;
      $pipe->(*FR_CHLD_ERR_R, *FR_CHLD_ERR_W) or die $^E;
  
      my $pid = IPC::Open3::open3('>&TO_CHLD_R', '<&FR_CHLD_W', '<&FR_CHLD_ERR_W', @_);
  
      return ( $pid, *TO_CHLD_W, *FR_CHLD_R, *FR_CHLD_ERR_R );
    };
  
    $cmd = [ grep { defined && length } @$cmd ] if ref $cmd;
    $cmd = $self->__fix_cmd_whitespace_and_special_chars( $cmd );
  
    my ($pid, $to_chld, $fr_chld, $fr_chld_err) =
      $open3->( ( ref $cmd ? @$cmd : $cmd ) );
  
    my $in_sel  = IO::Select->new();
    my $out_sel = IO::Select->new();
  
    my %objs;
  
    $objs{ fileno( $fr_chld ) } = $outhand;
    $objs{ fileno( $fr_chld_err ) } = $errhand;
    $in_sel->add( $fr_chld );
    $in_sel->add( $fr_chld_err );
  
    close($to_chld);
  
    while ($in_sel->count() + $out_sel->count()) {
      my ($ins, $outs) = IO::Select::select($in_sel, $out_sel, undef);
  
      for my $fh (@$ins) {
          my $obj = $objs{ fileno($fh) };
          my $buf;
          my $bytes_read = sysread($fh, $buf, 64*1024 ); #, length($buf));
          if (!$bytes_read) {
              $in_sel->remove($fh);
          }
          else {
              $obj->( "$buf" );
          }
        }
  
        for my $fh (@$outs) {
        }
    }
  
    waitpid($pid, 0);
  
    ### some error occurred
    if( $? ) {
          $self->error( $self->_pp_child_error( $cmd, $? ) );
          $self->ok( 0 );
          return;
    } else {
          return $self->ok( 1 );
    }
  }
  
  sub _open3_run {
      my $self            = shift;
      my $cmd             = shift;
      my $_out_handler    = shift;
      my $_err_handler    = shift;
      my $verbose         = shift || 0;
  
      ### Following code are adapted from Friar 'abstracts' in the
      ### Perl Monastery (http://www.perlmonks.org/index.pl?node_id=151886).
      ### XXX that code didn't work.
      ### we now use the following code, thanks to theorbtwo
  
      ### define them beforehand, so we always have defined FH's
      ### to read from.
      use Symbol;
      my $kidout      = Symbol::gensym();
      my $kiderror    = Symbol::gensym();
  
      ### Dup the filehandle so we can pass 'our' STDIN to the
      ### child process. This stops us from having to pump input
      ### from ourselves to the childprocess. However, we will need
      ### to revive the FH afterwards, as IPC::Open3 closes it.
      ### We'll do the same for STDOUT and STDERR. It works without
      ### duping them on non-unix derivatives, but not on win32.
      my @fds_to_dup = ( IS_WIN32 && !$verbose
                              ? qw[STDIN STDOUT STDERR]
                              : qw[STDIN]
                          );
      $self->_fds( \@fds_to_dup );
      $self->__dup_fds( @fds_to_dup );
  
      ### pipes have to come in a quoted string, and that clashes with
      ### whitespace. This sub fixes up such commands so they run properly
      $cmd = $self->__fix_cmd_whitespace_and_special_chars( $cmd );
  
      ### don't stringify @$cmd, so spaces in filenames/paths are
      ### treated properly
      my $pid = eval {
          IPC::Open3::open3(
                      '<&STDIN',
                      (IS_WIN32 ? '>&STDOUT' : $kidout),
                      (IS_WIN32 ? '>&STDERR' : $kiderror),
                      ( ref $cmd ? @$cmd : $cmd ),
                  );
      };
  
      ### open3 error occurred
      if( $@ and $@ =~ /^open3:/ ) {
          $self->ok( 0 );
          $self->error( $@ );
          return;
      };
  
      ### use OUR stdin, not $kidin. Somehow,
      ### we never get the input.. so jump through
      ### some hoops to do it :(
      my $selector = IO::Select->new(
                          (IS_WIN32 ? \*STDERR : $kiderror),
                          \*STDIN,
                          (IS_WIN32 ? \*STDOUT : $kidout)
                      );
  
      STDOUT->autoflush(1);   STDERR->autoflush(1);   STDIN->autoflush(1);
      $kidout->autoflush(1)   if UNIVERSAL::can($kidout,   'autoflush');
      $kiderror->autoflush(1) if UNIVERSAL::can($kiderror, 'autoflush');
  
      ### add an explicit break statement
      ### code courtesy of theorbtwo from #london.pm
      my $stdout_done = 0;
      my $stderr_done = 0;
      OUTER: while ( my @ready = $selector->can_read ) {
  
          for my $h ( @ready ) {
              my $buf;
  
              ### $len is the amount of bytes read
              my $len = sysread( $h, $buf, 4096 );    # try to read 4096 bytes
  
              ### see perldoc -f sysread: it returns undef on error,
              ### so bail out.
              if( not defined $len ) {
                  warn(loc("Error reading from process: %1", $!));
                  last OUTER;
              }
  
              ### check for $len. it may be 0, at which point we're
              ### done reading, so don't try to process it.
              ### if we would print anyway, we'd provide bogus information
              $_out_handler->( "$buf" ) if $len && $h == $kidout;
              $_err_handler->( "$buf" ) if $len && $h == $kiderror;
  
              ### Wait till child process is done printing to both
              ### stdout and stderr.
              $stdout_done = 1 if $h == $kidout   and $len == 0;
              $stderr_done = 1 if $h == $kiderror and $len == 0;
              last OUTER if ($stdout_done && $stderr_done);
          }
      }
  
      waitpid $pid, 0; # wait for it to die
  
      ### restore STDIN after duping, or STDIN will be closed for
      ### this current perl process!
      ### done in the parent call now
      # $self->__reopen_fds( @fds_to_dup );
  
      ### some error occurred
      if( $? ) {
          $self->error( $self->_pp_child_error( $cmd, $? ) );
          $self->ok( 0 );
          return;
      } else {
          return $self->ok( 1 );
      }
  }
  
  ### Text::ParseWords::shellwords() uses unix semantics. that will break
  ### on win32
  {   my $parse_sub = IS_WIN32
                          ? __PACKAGE__->can('_split_like_shell_win32')
                          : Text::ParseWords->can('shellwords');
  
      sub _ipc_run {
          my $self            = shift;
          my $cmd             = shift;
          my $_out_handler    = shift;
          my $_err_handler    = shift;
  
          STDOUT->autoflush(1); STDERR->autoflush(1);
  
          ### a command like:
          # [
          #     '/usr/bin/gzip',
          #     '-cdf',
          #     '/Users/kane/sources/p4/other/archive-extract/t/src/x.tgz',
          #     '|',
          #     '/usr/bin/tar',
          #     '-tf -'
          # ]
          ### needs to become:
          # [
          #     ['/usr/bin/gzip', '-cdf',
          #       '/Users/kane/sources/p4/other/archive-extract/t/src/x.tgz']
          #     '|',
          #     ['/usr/bin/tar', '-tf -']
          # ]
  
  
          my @command;
          my $special_chars;
  
          my $re = do { my $x = join '', SPECIAL_CHARS; qr/([$x])/ };
          if( ref $cmd ) {
              my $aref = [];
              for my $item (@$cmd) {
                  if( $item =~ $re ) {
                      push @command, $aref, $item;
                      $aref = [];
                      $special_chars .= $1;
                  } else {
                      push @$aref, $item;
                  }
              }
              push @command, $aref;
          } else {
              @command = map { if( $_ =~ $re ) {
                                  $special_chars .= $1; $_;
                               } else {
  #                                [ split /\s+/ ]
                                   [ map { m/[ ]/ ? qq{'$_'} : $_ } $parse_sub->($_) ]
                               }
                          } split( /\s*$re\s*/, $cmd );
          }
  
          ### if there's a pipe in the command, *STDIN needs to
          ### be inserted *BEFORE* the pipe, to work on win32
          ### this also works on *nix, so we should do it when possible
          ### this should *also* work on multiple pipes in the command
          ### if there's no pipe in the command, append STDIN to the back
          ### of the command instead.
          ### XXX seems IPC::Run works it out for itself if you just
          ### don't pass STDIN at all.
          #     if( $special_chars and $special_chars =~ /\|/ ) {
          #         ### only add STDIN the first time..
          #         my $i;
          #         @command = map { ($_ eq '|' && not $i++)
          #                             ? ( \*STDIN, $_ )
          #                             : $_
          #                         } @command;
          #     } else {
          #         push @command, \*STDIN;
          #     }
  
          # \*STDIN is already included in the @command, see a few lines up
          my $ok = eval { IPC::Run::run(   @command,
                                  fileno(STDOUT).'>',
                                  $_out_handler,
                                  fileno(STDERR).'>',
                                  $_err_handler
                              )
                          };
  
          ### all is well
          if( $ok ) {
              return $self->ok( $ok );
  
          ### some error occurred
          } else {
              $self->ok( 0 );
  
              ### if the eval fails due to an exception, deal with it
              ### unless it's an alarm
              if( $@ and not UNIVERSAL::isa( $@, ALARM_CLASS ) ) {
                  $self->error( $@ );
  
              ### if it *is* an alarm, propagate
              } elsif( $@ ) {
                  die $@;
  
              ### some error in the sub command
              } else {
                  $self->error( $self->_pp_child_error( $cmd, $? ) );
              }
  
              return;
          }
      }
  }
  
  sub _system_run {
      my $self    = shift;
      my $cmd     = shift;
      my $verbose = shift || 0;
  
      ### pipes have to come in a quoted string, and that clashes with
      ### whitespace. This sub fixes up such commands so they run properly
      $cmd = $self->__fix_cmd_whitespace_and_special_chars( $cmd );
  
      my @fds_to_dup = $verbose ? () : qw[STDOUT STDERR];
      $self->_fds( \@fds_to_dup );
      $self->__dup_fds( @fds_to_dup );
  
      ### system returns 'true' on failure -- the exit code of the cmd
      $self->ok( 1 );
      system( ref $cmd ? @$cmd : $cmd ) == 0 or do {
          $self->error( $self->_pp_child_error( $cmd, $? ) );
          $self->ok( 0 );
      };
  
      ### done in the parent call now
      #$self->__reopen_fds( @fds_to_dup );
  
      return unless $self->ok;
      return $self->ok;
  }
  
  {   my %sc_lookup = map { $_ => $_ } SPECIAL_CHARS;
  
  
      sub __fix_cmd_whitespace_and_special_chars {
          my $self = shift;
          my $cmd  = shift;
  
          ### command has a special char in it
          if( ref $cmd and grep { $sc_lookup{$_} } @$cmd ) {
  
              ### since we have special chars, we have to quote white space
              ### this *may* conflict with the parsing :(
              my $fixed;
              my @cmd = map { / / ? do { $fixed++; QUOTE.$_.QUOTE } : $_ } @$cmd;
  
              $self->_debug( "# Quoted $fixed arguments containing whitespace" )
                      if $DEBUG && $fixed;
  
              ### stringify it, so the special char isn't escaped as argument
              ### to the program
              $cmd = join ' ', @cmd;
          }
  
          return $cmd;
      }
  }
  
  ### Command-line arguments (but not the command itself) must be quoted
  ### to ensure case preservation. Borrowed from Module::Build with adaptations.
  ### Patch for this supplied by Craig Berry, see RT #46288: [PATCH] Add argument
  ### quoting for run() on VMS
  sub _quote_args_vms {
    ### Returns a command string with proper quoting so that the subprocess
    ### sees this same list of args, or if we get a single arg that is an
    ### array reference, quote the elements of it (except for the first)
    ### and return the reference.
    my @args = @_;
    my $got_arrayref = (scalar(@args) == 1
                        && UNIVERSAL::isa($args[0], 'ARRAY'))
                     ? 1
                     : 0;
  
    @args = split(/\s+/, $args[0]) unless $got_arrayref || scalar(@args) > 1;
  
    my $cmd = $got_arrayref ? shift @{$args[0]} : shift @args;
  
    ### Do not quote qualifiers that begin with '/' or previously quoted args.
    map { if (/^[^\/\"]/) {
            $_ =~ s/\"/""/g;     # escape C<"> by doubling
            $_ = q(").$_.q(");
          }
    }
      ($got_arrayref ? @{$args[0]}
                     : @args
      );
  
    $got_arrayref ? unshift(@{$args[0]}, $cmd) : unshift(@args, $cmd);
  
    return $got_arrayref ? $args[0]
                         : join(' ', @args);
  }
  
  
  ### XXX this is cribbed STRAIGHT from M::B 0.30 here:
  ### http://search.cpan.org/src/KWILLIAMS/Module-Build-0.30/lib/Module/Build/Platform/Windows.pm:split_like_shell
  ### XXX this *should* be integrated into text::parsewords
  sub _split_like_shell_win32 {
    # As it turns out, Windows command-parsing is very different from
    # Unix command-parsing.  Double-quotes mean different things,
    # backslashes don't necessarily mean escapes, and so on.  So we
    # can't use Text::ParseWords::shellwords() to break a command string
    # into words.  The algorithm below was bashed out by Randy and Ken
    # (mostly Randy), and there are a lot of regression tests, so we
    # should feel free to adjust if desired.
  
    local $_ = shift;
  
    my @argv;
    return @argv unless defined() && length();
  
    my $arg = '';
    my( $i, $quote_mode ) = ( 0, 0 );
  
    while ( $i < length() ) {
  
      my $ch      = substr( $_, $i  , 1 );
      my $next_ch = substr( $_, $i+1, 1 );
  
      if ( $ch eq '\\' && $next_ch eq '"' ) {
        $arg .= '"';
        $i++;
      } elsif ( $ch eq '\\' && $next_ch eq '\\' ) {
        $arg .= '\\';
        $i++;
      } elsif ( $ch eq '"' && $next_ch eq '"' && $quote_mode ) {
        $quote_mode = !$quote_mode;
        $arg .= '"';
        $i++;
      } elsif ( $ch eq '"' && $next_ch eq '"' && !$quote_mode &&
            ( $i + 2 == length()  ||
          substr( $_, $i + 2, 1 ) eq ' ' )
          ) { # for cases like: a"" => [ 'a' ]
        push( @argv, $arg );
        $arg = '';
        $i += 2;
      } elsif ( $ch eq '"' ) {
        $quote_mode = !$quote_mode;
      } elsif ( $ch eq ' ' && !$quote_mode ) {
        push( @argv, $arg ) if defined( $arg ) && length( $arg );
        $arg = '';
        ++$i while substr( $_, $i + 1, 1 ) eq ' ';
      } else {
        $arg .= $ch;
      }
  
      $i++;
    }
  
    push( @argv, $arg ) if defined( $arg ) && length( $arg );
    return @argv;
  }
  
  
  
  {   use File::Spec;
      use Symbol;
  
      my %Map = (
          STDOUT => [qw|>&|, \*STDOUT, Symbol::gensym() ],
          STDERR => [qw|>&|, \*STDERR, Symbol::gensym() ],
          STDIN  => [qw|<&|, \*STDIN,  Symbol::gensym() ],
      );
  
      ### dups FDs and stores them in a cache
      sub __dup_fds {
          my $self    = shift;
          my @fds     = @_;
  
          __PACKAGE__->_debug( "# Closing the following fds: @fds" ) if $DEBUG;
  
          for my $name ( @fds ) {
              my($redir, $fh, $glob) = @{$Map{$name}} or (
                  Carp::carp(loc("No such FD: '%1'", $name)), next );
  
              ### MUST use the 2-arg version of open for dup'ing for
              ### 5.6.x compatibility. 5.8.x can use 3-arg open
              ### see perldoc5.6.2 -f open for details
              open $glob, $redir . fileno($fh) or (
                          Carp::carp(loc("Could not dup '$name': %1", $!)),
                          return
                      );
  
              ### we should re-open this filehandle right now, not
              ### just dup it
              ### Use 2-arg version of open, as 5.5.x doesn't support
              ### 3-arg version =/
              if( $redir eq '>&' ) {
                  open( $fh, '>' . File::Spec->devnull ) or (
                      Carp::carp(loc("Could not reopen '$name': %1", $!)),
                      return
                  );
              }
          }
  
          return 1;
      }
  
      ### reopens FDs from the cache
      sub __reopen_fds {
          my $self    = shift;
          my @fds     = @_;
  
          __PACKAGE__->_debug( "# Reopening the following fds: @fds" ) if $DEBUG;
  
          for my $name ( @fds ) {
              my($redir, $fh, $glob) = @{$Map{$name}} or (
                  Carp::carp(loc("No such FD: '%1'", $name)), next );
  
              ### MUST use the 2-arg version of open for dup'ing for
              ### 5.6.x compatibility. 5.8.x can use 3-arg open
              ### see perldoc5.6.2 -f open for details
              open( $fh, $redir . fileno($glob) ) or (
                      Carp::carp(loc("Could not restore '$name': %1", $!)),
                      return
                  );
  
              ### close this FD, we're not using it anymore
              close $glob;
          }
          return 1;
  
      }
  }
  
  sub _debug {
      my $self    = shift;
      my $msg     = shift or return;
      my $level   = shift || 0;
  
      local $Carp::CarpLevel += $level;
      Carp::carp($msg);
  
      return 1;
  }
  
  sub _pp_child_error {
      my $self    = shift;
      my $cmd     = shift or return;
      my $ce      = shift or return;
      my $pp_cmd  = ref $cmd ? "@$cmd" : $cmd;
  
  
      my $str;
      if( $ce == -1 ) {
          ### Include $! in the error message, so that the user can
          ### see 'No such file or directory' versus 'Permission denied'
          ### versus 'Cannot fork' or whatever the cause was.
          $str = "Failed to execute '$pp_cmd': $!";
  
      } elsif ( $ce & 127 ) {
          ### some signal
          $str = loc( "'%1' died with signal %2, %3 coredump",
                 $pp_cmd, ($ce & 127), ($ce & 128) ? 'with' : 'without');
  
      } else {
          ### Otherwise, the command run but gave error status.
          $str = "'$pp_cmd' exited with value " . ($ce >> 8);
      }
  
      $self->_debug( "# Child error '$ce' translated to: $str" ) if $DEBUG;
  
      return $str;
  }
  
  1;
  
  __END__
  
  =head2 $q = QUOTE
  
  Returns the character used for quoting strings on this platform. This is
  usually a C<'> (single quote) on most systems, but some systems use different
  quotes. For example, C<Win32> uses C<"> (double quote).
  
  You can use it as follows:
  
    use IPC::Cmd qw[run QUOTE];
    my $cmd = q[echo ] . QUOTE . q[foo bar] . QUOTE;
  
  This makes sure that C<foo bar> is treated as a string, rather than two
  separate arguments to the C<echo> function.
  
  =head1 HOW IT WORKS
  
  C<run> will try to execute your command using the following logic:
  
  =over 4
  
  =item *
  
  If you have C<IPC::Run> installed, and the variable C<$IPC::Cmd::USE_IPC_RUN>
  is set to true (See the L<"Global Variables"> section) use that to execute
  the command. You will have the full output available in buffers, interactive commands
  are sure to work  and you are guaranteed to have your verbosity
  settings honored cleanly.
  
  =item *
  
  Otherwise, if the variable C<$IPC::Cmd::USE_IPC_OPEN3> is set to true
  (See the L<"Global Variables"> section), try to execute the command using
  L<IPC::Open3>. Buffers will be available on all platforms,
  interactive commands will still execute cleanly, and also your verbosity
  settings will be adhered to nicely;
  
  =item *
  
  Otherwise, if you have the C<verbose> argument set to true, we fall back
  to a simple C<system()> call. We cannot capture any buffers, but
  interactive commands will still work.
  
  =item *
  
  Otherwise we will try and temporarily redirect STDERR and STDOUT, do a
  C<system()> call with your command and then re-open STDERR and STDOUT.
  This is the method of last resort and will still allow you to execute
  your commands cleanly. However, no buffers will be available.
  
  =back
  
  =head1 Global Variables
  
  The behaviour of IPC::Cmd can be altered by changing the following
  global variables:
  
  =head2 $IPC::Cmd::VERBOSE
  
  This controls whether IPC::Cmd will print any output from the
  commands to the screen or not. The default is 0.
  
  =head2 $IPC::Cmd::USE_IPC_RUN
  
  This variable controls whether IPC::Cmd will try to use L<IPC::Run>
  when available and suitable.
  
  =head2 $IPC::Cmd::USE_IPC_OPEN3
  
  This variable controls whether IPC::Cmd will try to use L<IPC::Open3>
  when available and suitable. Defaults to true.
  
  =head2 $IPC::Cmd::WARN
  
  This variable controls whether run-time warnings should be issued, like
  the failure to load an C<IPC::*> module you explicitly requested.
  
  Defaults to true. Turn this off at your own risk.
  
  =head2 $IPC::Cmd::INSTANCES
  
  This variable controls whether C<can_run> will return all instances of
  the binary it finds in the C<PATH> when called in a list context.
  
  Defaults to false, set to true to enable the described behaviour.
  
  =head2 $IPC::Cmd::ALLOW_NULL_ARGS
  
  This variable controls whether C<run> will remove any empty/null arguments
  it finds in command arguments.
  
  Defaults to false, so it will remove null arguments. Set to true to allow
  them.
  
  =head1 Caveats
  
  =over 4
  
  =item Whitespace and IPC::Open3 / system()
  
  When using C<IPC::Open3> or C<system>, if you provide a string as the
  C<command> argument, it is assumed to be appropriately escaped. You can
  use the C<QUOTE> constant to use as a portable quote character (see above).
  However, if you provide an array reference, special rules apply:
  
  If your command contains B<special characters> (< > | &), it will
  be internally stringified before executing the command, to avoid that these
  special characters are escaped and passed as arguments instead of retaining
  their special meaning.
  
  However, if the command contained arguments that contained whitespace,
  stringifying the command would lose the significance of the whitespace.
  Therefore, C<IPC::Cmd> will quote any arguments containing whitespace in your
  command if the command is passed as an arrayref and contains special characters.
  
  =item Whitespace and IPC::Run
  
  When using C<IPC::Run>, if you provide a string as the C<command> argument,
  the string will be split on whitespace to determine the individual elements
  of your command. Although this will usually just Do What You Mean, it may
  break if you have files or commands with whitespace in them.
  
  If you do not wish this to happen, you should provide an array
  reference, where all parts of your command are already separated out.
  Note however, if there are extra or spurious whitespaces in these parts,
  the parser or underlying code may not interpret it correctly, and
  cause an error.
  
  Example:
  The following code
  
      gzip -cdf foo.tar.gz | tar -xf -
  
  should either be passed as
  
      "gzip -cdf foo.tar.gz | tar -xf -"
  
  or as
  
      ['gzip', '-cdf', 'foo.tar.gz', '|', 'tar', '-xf', '-']
  
  But take care not to pass it as, for example
  
      ['gzip -cdf foo.tar.gz', '|', 'tar -xf -']
  
  Since this will lead to issues as described above.
  
  
  =item IO Redirect
  
  Currently it is too complicated to parse your command for IO
  redirections. For capturing STDOUT or STDERR there is a work around
  however, since you can just inspect your buffers for the contents.
  
  =item Interleaving STDOUT/STDERR
  
  Neither IPC::Run nor IPC::Open3 can interleave STDOUT and STDERR. For short
  bursts of output from a program, e.g. this sample,
  
      for ( 1..4 ) {
          $_ % 2 ? print STDOUT $_ : print STDERR $_;
      }
  
  IPC::[Run|Open3] will first read all of STDOUT, then all of STDERR, meaning
  the output looks like '13' on STDOUT and '24' on STDERR, instead of
  
      1
      2
      3
      4
  
  This has been recorded in L<rt.cpan.org> as bug #37532: Unable to interleave
  STDOUT and STDERR.
  
  =back
  
  =head1 See Also
  
  L<IPC::Run>, L<IPC::Open3>
  
  =head1 ACKNOWLEDGEMENTS
  
  Thanks to James Mastros and Martijn van der Streek for their
  help in getting L<IPC::Open3> to behave nicely.
  
  Thanks to Petya Kohts for the C<run_forked> code.
  
  =head1 BUG REPORTS
  
  Please report bugs or other issues to E<lt>bug-ipc-cmd@rt.cpan.orgE<gt>.
  
  =head1 AUTHOR
  
  Original author: Jos Boumans E<lt>kane@cpan.orgE<gt>.
  Current maintainer: Chris Williams E<lt>bingos@cpan.orgE<gt>.
  
  =head1 COPYRIGHT
  
  This library is free software; you may redistribute and/or modify it
  under the same terms as Perl itself.
  
  =cut
IPC_CMD

$fatpacked{"IPC/Run3.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3';
  package IPC::Run3;
  BEGIN { require 5.006_000; } # i.e. 5.6.0
  use strict;
  
  =head1 NAME
  
  IPC::Run3 - run a subprocess with input/ouput redirection
  
  =head1 VERSION
  
  version 0.048
  
  =cut
  
  our $VERSION = '0.048';
  
  =head1 SYNOPSIS
  
      use IPC::Run3;    # Exports run3() by default
  
      run3 \@cmd, \$in, \$out, \$err;
  
  =head1 DESCRIPTION
  
  This module allows you to run a subprocess and redirect stdin, stdout,
  and/or stderr to files and perl data structures.  It aims to satisfy 99% of the
  need for using C<system>, C<qx>, and C<open3>
  with a simple, extremely Perlish API.
  
  Speed, simplicity, and portability are paramount.  (That's speed of Perl code;
  which is often much slower than the kind of buffered I/O that this module uses
  to spool input to and output from the child command.)
  
  =cut
  
  use Exporter;
  our @ISA = qw(Exporter);
  our @EXPORT = qw( run3 );
  our %EXPORT_TAGS = ( all => \@EXPORT );
  
  use constant debugging => $ENV{IPCRUN3DEBUG} || $ENV{IPCRUNDEBUG} || 0;
  use constant profiling => $ENV{IPCRUN3PROFILE} || $ENV{IPCRUNPROFILE} || 0;
  use constant is_win32  => 0 <= index $^O, "Win32";
  
  BEGIN {
     if ( is_win32 ) {
        eval "use Win32 qw( GetOSName ); use Win32::ShellQuote qw(quote_native); 1" or die $@;
     }
  }
  
  #use constant is_win2k => is_win32 && GetOSName() =~ /Win2000/i;
  #use constant is_winXP => is_win32 && GetOSName() =~ /WinXP/i;
  
  use Carp qw( croak );
  use File::Temp qw( tempfile );
  use POSIX qw( dup dup2 );
  
  # We cache the handles of our temp files in order to
  # keep from having to incur the (largish) overhead of File::Temp
  my %fh_cache;
  my $fh_cache_pid = $$;
  
  my $profiler;
  
  sub _profiler { $profiler } # test suite access
  
  BEGIN {
      if ( profiling ) {
          eval "use Time::HiRes qw( gettimeofday ); 1" or die $@;
          if ( $ENV{IPCRUN3PROFILE} =~ /\A\d+\z/ ) {
              require IPC::Run3::ProfPP;
              IPC::Run3::ProfPP->import;
              $profiler = IPC::Run3::ProfPP->new(Level => $ENV{IPCRUN3PROFILE});
          } else {
              my ( $dest, undef, $class ) =
                 reverse split /(=)/, $ENV{IPCRUN3PROFILE}, 2;
              $class = "IPC::Run3::ProfLogger"
                  unless defined $class && length $class;
              if ( not eval "require $class" ) {
                  my $e = $@;
                  $class = "IPC::Run3::$class";
                  eval "require IPC::Run3::$class" or die $e;
              }
              $profiler = $class->new( Destination => $dest );
          }
          $profiler->app_call( [ $0, @ARGV ], scalar gettimeofday() );
      }
  }
  
  
  END {
      $profiler->app_exit( scalar gettimeofday() ) if profiling;
  }
  
  sub _binmode {
      my ( $fh, $mode, $what ) = @_;
      # if $mode is not given, then default to ":raw", except on Windows,
      # where we default to ":crlf";
      # otherwise if a proper layer string was given, use that,
      # else use ":raw"
      my $layer = !$mode
         ? (is_win32 ? ":crlf" : ":raw")
         : ($mode =~ /^:/ ? $mode : ":raw");
      warn "binmode $what, $layer\n" if debugging >= 2;
  
      binmode $fh, ":raw" unless $layer eq ":raw";      # remove all layers first
      binmode $fh, $layer or croak "binmode $layer failed: $!";
  }
  
  sub _spool_data_to_child {
      my ( $type, $source, $binmode_it ) = @_;
  
      # If undef (not \undef) passed, they want the child to inherit
      # the parent's STDIN.
      return undef unless defined $source;
  
      my $fh;
      if ( ! $type ) {
          open $fh, "<", $source or croak "$!: $source";
         _binmode($fh, $binmode_it, "STDIN");
          warn "run3(): feeding file '$source' to child STDIN\n"
              if debugging >= 2;
      } elsif ( $type eq "FH" ) {
          $fh = $source;
          warn "run3(): feeding filehandle '$source' to child STDIN\n"
              if debugging >= 2;
      } else {
          $fh = $fh_cache{in} ||= tempfile;
          truncate $fh, 0;
          seek $fh, 0, 0;
         _binmode($fh, $binmode_it, "STDIN");
          my $seekit;
          if ( $type eq "SCALAR" ) {
  
              # When the run3()'s caller asks to feed an empty file
              # to the child's stdin, we want to pass a live file
              # descriptor to an empty file (like /dev/null) so that
              # they don't get surprised by invalid fd errors and get
              # normal EOF behaviors.
              return $fh unless defined $$source;  # \undef passed
  
              warn "run3(): feeding SCALAR to child STDIN",
                  debugging >= 3
                     ? ( ": '", $$source, "' (", length $$source, " chars)" )
                     : (),
                  "\n"
                  if debugging >= 2;
  
              $seekit = length $$source;
              print $fh $$source or die "$! writing to temp file";
  
          } elsif ( $type eq "ARRAY" ) {
              warn "run3(): feeding ARRAY to child STDIN",
                  debugging >= 3 ? ( ": '", @$source, "'" ) : (),
                  "\n"
              if debugging >= 2;
  
              print $fh @$source or die "$! writing to temp file";
              $seekit = grep length, @$source;
          } elsif ( $type eq "CODE" ) {
              warn "run3(): feeding output of CODE ref '$source' to child STDIN\n"
                  if debugging >= 2;
              my $parms = [];  # TODO: get these from $options
              while (1) {
                  my $data = $source->( @$parms );
                  last unless defined $data;
                  print $fh $data or die "$! writing to temp file";
                  $seekit = length $data;
              }
          }
  
          seek $fh, 0, 0 or croak "$! seeking on temp file for child's stdin"
              if $seekit;
      }
  
      croak "run3() can't redirect $type to child stdin"
          unless defined $fh;
  
      return $fh;
  }
  
  sub _fh_for_child_output {
      my ( $what, $type, $dest, $options ) = @_;
  
      my $fh;
      if ( $type eq "SCALAR" && $dest == \undef ) {
          warn "run3(): redirecting child $what to oblivion\n"
              if debugging >= 2;
  
          $fh = $fh_cache{nul} ||= do {
              open $fh, ">", File::Spec->devnull;
             $fh;
          };
      } elsif ( $type eq "FH" ) {
          $fh = $dest;
          warn "run3(): redirecting $what to filehandle '$dest'\n"
              if debugging >= 3;
      } elsif ( !$type ) {
          warn "run3(): feeding child $what to file '$dest'\n"
              if debugging >= 2;
  
          open $fh, $options->{"append_$what"} ? ">>" : ">", $dest
             or croak "$!: $dest";
      } else {
          warn "run3(): capturing child $what\n"
              if debugging >= 2;
  
          $fh = $fh_cache{$what} ||= tempfile;
          seek $fh, 0, 0;
          truncate $fh, 0;
      }
  
      my $binmode_it = $options->{"binmode_$what"};
      _binmode($fh, $binmode_it, uc $what);
  
      return $fh;
  }
  
  sub _read_child_output_fh {
      my ( $what, $type, $dest, $fh, $options ) = @_;
  
      return if $type eq "SCALAR" && $dest == \undef;
  
      seek $fh, 0, 0 or croak "$! seeking on temp file for child $what";
  
      if ( $type eq "SCALAR" ) {
          warn "run3(): reading child $what to SCALAR\n"
              if debugging >= 3;
  
          # two read()s are used instead of 1 so that the first will be
          # logged even it reads 0 bytes; the second won't.
          my $count = read $fh, $$dest, 10_000,
             $options->{"append_$what"} ? length $$dest : 0;
          while (1) {
              croak "$! reading child $what from temp file"
                  unless defined $count;
  
              last unless $count;
  
              warn "run3(): read $count bytes from child $what",
                  debugging >= 3 ? ( ": '", substr( $$dest, -$count ), "'" ) : (),
                  "\n"
                  if debugging >= 2;
  
              $count = read $fh, $$dest, 10_000, length $$dest;
          }
      } elsif ( $type eq "ARRAY" ) {
         if ($options->{"append_$what"}) {
             push @$dest, <$fh>;
         } else {
             @$dest = <$fh>;
         }
          if ( debugging >= 2 ) {
              my $count = 0;
              $count += length for @$dest;
              warn
                  "run3(): read ",
                  scalar @$dest,
                  " records, $count bytes from child $what",
                  debugging >= 3 ? ( ": '", @$dest, "'" ) : (),
                  "\n";
          }
      } elsif ( $type eq "CODE" ) {
          warn "run3(): capturing child $what to CODE ref\n"
              if debugging >= 3;
  
          local $_;
          while ( <$fh> ) {
              warn
                  "run3(): read ",
                  length,
                  " bytes from child $what",
                  debugging >= 3 ? ( ": '", $_, "'" ) : (),
                  "\n"
                  if debugging >= 2;
  
              $dest->( $_ );
          }
      } else {
          croak "run3() can't redirect child $what to a $type";
      }
  
  }
  
  sub _type {
      my ( $redir ) = @_;
  
      return "FH" if eval {
          local $SIG{'__DIE__'};
          $redir->isa("IO::Handle")
      };
  
      my $type = ref $redir;
      return $type eq "GLOB" ? "FH" : $type;
  }
  
  sub _max_fd {
      my $fd = dup(0);
      POSIX::close $fd;
      return $fd;
  }
  
  my $run_call_time;
  my $sys_call_time;
  my $sys_exit_time;
  
  sub run3 {
      $run_call_time = gettimeofday() if profiling;
  
      my $options = @_ && ref $_[-1] eq "HASH" ? pop : {};
  
      my ( $cmd, $stdin, $stdout, $stderr ) = @_;
  
      print STDERR "run3(): running ",
         join( " ", map "'$_'", ref $cmd ? @$cmd : $cmd ),
         "\n"
         if debugging;
  
      if ( ref $cmd ) {
          croak "run3(): empty command"     unless @$cmd;
          croak "run3(): undefined command" unless defined $cmd->[0];
          croak "run3(): command name ('')" unless length  $cmd->[0];
      } else {
          croak "run3(): missing command" unless @_;
          croak "run3(): undefined command" unless defined $cmd;
          croak "run3(): command ('')" unless length  $cmd;
      }
  
      foreach (qw/binmode_stdin binmode_stdout binmode_stderr/) {
         if (my $mode = $options->{$_}) {
             croak qq[option $_ must be a number or a proper layer string: "$mode"]
                unless $mode =~ /^(:|\d+$)/;
         }
      }
  
      my $in_type  = _type $stdin;
      my $out_type = _type $stdout;
      my $err_type = _type $stderr;
  
      if ($fh_cache_pid != $$) {
         # fork detected, close all cached filehandles and clear the cache
         close $_ foreach values %fh_cache;
         %fh_cache = ();
         $fh_cache_pid = $$;
      }
  
      # This routine proceeds in stages so that a failure in an early
      # stage prevents later stages from running, and thus from needing
      # cleanup.
  
      my $in_fh  = _spool_data_to_child $in_type, $stdin,
          $options->{binmode_stdin} if defined $stdin;
  
      my $out_fh = _fh_for_child_output "stdout", $out_type, $stdout,
          $options if defined $stdout;
  
      my $tie_err_to_out =
          defined $stderr && defined $stdout && $stderr eq $stdout;
  
      my $err_fh = $tie_err_to_out
          ? $out_fh
          : _fh_for_child_output "stderr", $err_type, $stderr,
              $options if defined $stderr;
  
      # this should make perl close these on exceptions
  #    local *STDIN_SAVE;
      local *STDOUT_SAVE;
      local *STDERR_SAVE;
  
      my $saved_fd0 = dup( 0 ) if defined $in_fh;
  
  #    open STDIN_SAVE,  "<&STDIN"#  or croak "run3(): $! saving STDIN"
  #        if defined $in_fh;
      open STDOUT_SAVE, ">&STDOUT" or croak "run3(): $! saving STDOUT"
          if defined $out_fh;
      open STDERR_SAVE, ">&STDERR" or croak "run3(): $! saving STDERR"
          if defined $err_fh;
  
      my $errno;
      my $ok = eval {
          # The open() call here seems to not force fd 0 in some cases;
          # I ran in to trouble when using this in VCP, not sure why.
          # the dup2() seems to work.
          dup2( fileno $in_fh, 0 )
  #        open STDIN,  "<&=" . fileno $in_fh
              or croak "run3(): $! redirecting STDIN"
              if defined $in_fh;
  
  #        close $in_fh or croak "$! closing STDIN temp file"
  #            if ref $stdin;
  
          open STDOUT, ">&" . fileno $out_fh
              or croak "run3(): $! redirecting STDOUT"
              if defined $out_fh;
  
          open STDERR, ">&" . fileno $err_fh
              or croak "run3(): $! redirecting STDERR"
              if defined $err_fh;
  
          $sys_call_time = gettimeofday() if profiling;
  
          my $r = ref $cmd
                ? system { $cmd->[0] } is_win32 ? quote_native( @$cmd ) : @$cmd
                : system $cmd;
  
         $errno = $!;              # save $!, because later failures will overwrite it
          $sys_exit_time = gettimeofday() if profiling;
          if ( debugging ) {
              my $err_fh = defined $err_fh ? \*STDERR_SAVE : \*STDERR;
             if ( defined $r && $r != -1 ) {
                print $err_fh "run3(): \$? is $?\n";
             } else {
                print $err_fh "run3(): \$? is $?, \$! is $errno\n";
             }
          }
  
          if (
              defined $r
              && ( $r == -1 || ( is_win32 && $r == 0xFF00 ) )
              && !$options->{return_if_system_error}
          ) {
              croak( $errno );
          }
  
          1;
      };
      my $x = $@;
  
      my @errs;
  
      if ( defined $saved_fd0 ) {
          dup2( $saved_fd0, 0 );
          POSIX::close( $saved_fd0 );
      }
  
  #    open STDIN,  "<&STDIN_SAVE"#  or push @errs, "run3(): $! restoring STDIN"
  #        if defined $in_fh;
      open STDOUT, ">&STDOUT_SAVE" or push @errs, "run3(): $! restoring STDOUT"
          if defined $out_fh;
      open STDERR, ">&STDERR_SAVE" or push @errs, "run3(): $! restoring STDERR"
          if defined $err_fh;
  
      croak join ", ", @errs if @errs;
  
      die $x unless $ok;
  
      _read_child_output_fh "stdout", $out_type, $stdout, $out_fh, $options
          if defined $out_fh && $out_type && $out_type ne "FH";
      _read_child_output_fh "stderr", $err_type, $stderr, $err_fh, $options
          if defined $err_fh && $err_type && $err_type ne "FH" && !$tie_err_to_out;
      $profiler->run_exit(
         $cmd,
         $run_call_time,
         $sys_call_time,
         $sys_exit_time,
         scalar gettimeofday()
      ) if profiling;
  
      $! = $errno;              # restore $! from system()
  
      return 1;
  }
  
  1;
  
  __END__
  
  =head2 C<< run3($cmd, $stdin, $stdout, $stderr, \%options) >>
  
  All parameters after C<$cmd> are optional.
  
  The parameters C<$stdin>, C<$stdout> and C<$stderr> indicate how the child's
  corresponding filehandle (C<STDIN>, C<STDOUT> and C<STDERR>, resp.) will be
  redirected.  Because the redirects come last, this allows C<STDOUT> and
  C<STDERR> to default to the parent's by just not specifying them -- a common
  use case.
  
  C<run3> throws an exception if the wrapped C<system> call returned -1 or
  anything went wrong with C<run3>'s processing of filehandles.  Otherwise it
  returns true.  It leaves C<$?> intact for inspection of exit and wait status.
  
  Note that a true return value from C<run3> doesn't mean that the command had a
  successful exit code. Hence you should always check C<$?>.
  
  See L</%options> for an option to handle the case of C<system> returning -1
  yourself.
  
  =head3 C<$cmd>
  
  Usually C<$cmd> will be an ARRAY reference and the child is invoked via
  
    system @$cmd;
  
  But C<$cmd> may also be a string in which case the child is invoked via
  
    system $cmd;
  
  (cf. L<perlfunc/system> for the difference and the pitfalls of using
  the latter form).
  
  =head3 C<$stdin>, C<$stdout>, C<$stderr>
  
  The parameters C<$stdin>, C<$stdout> and C<$stderr> can take one of the
  following forms:
  
  =over 4
  
  =item C<undef> (or not specified at all)
  
  The child inherits the corresponding filehandle from the parent.
  
    run3 \@cmd, $stdin;                   # child writes to same STDOUT and STDERR as parent
    run3 \@cmd, undef, $stdout, $stderr;  # child reads from same STDIN as parent
  
  =item C<\undef>
  
  The child's filehandle is redirected from or to the local equivalent of
  C</dev/null> (as returned by C<< File::Spec->devnull() >>).
  
    run3 \@cmd, \undef, $stdout, $stderr; # child reads from /dev/null
  
  =item a simple scalar
  
  The parameter is taken to be the name of a file to read from
  or write to. In the latter case, the file will be opened via
  
    open FH, ">", ...
  
  i.e. it is created if it doesn't exist and truncated otherwise.
  Note that the file is opened by the parent which will L<croak|Carp/croak>
  in case of failure.
  
    run3 \@cmd, \undef, "out.txt";        # child writes to file "out.txt"
  
  =item a filehandle (either a reference to a GLOB or an C<IO::Handle>)
  
  The filehandle is inherited by the child.
  
    open my $fh, ">", "out.txt";
    print $fh "prologue\n";
    ...
    run3 \@cmd, \undef, $fh;              # child writes to $fh
    ...
    print $fh "epilogue\n";
    close $fh;
  
  =item a SCALAR reference
  
  The referenced scalar is treated as a string to be read from or
  written to. In the latter case, the previous content of the string
  is overwritten.
  
    my $out;
    run3 \@cmd, \undef, \$out;           # child writes into string
    run3 \@cmd, \<<EOF;                  # child reads from string (can use "here" notation)
    Input
    to
    child
    EOF
  
  =item an ARRAY reference
  
  For C<$stdin>, the elements of C<@$stdin> are simply spooled to the child.
  
  For C<$stdout> or C<$stderr>, the child's corresponding file descriptor
  is read line by line (as determined by the current setting of C<$/>)
  into C<@$stdout> or C<@$stderr>, resp. The previous content of the array
  is overwritten.
  
    my @lines;
    run3 \@cmd, \undef, \@lines;         # child writes into array
  
  =item a CODE reference
  
  For C<$stdin>, C<&$stdin> will be called repeatedly (with no arguments) and
  the return values are spooled to the child. C<&$stdin> must signal the end of
  input by returning C<undef>.
  
  For C<$stdout> or C<$stderr>, the child's corresponding file descriptor
  is read line by line (as determined by the current setting of C<$/>)
  and C<&$stdout> or C<&$stderr>, resp., is called with the contents of the line.
  Note that there's no end-of-file indication.
  
    my $i = 0;
    sub producer {
      return $i < 10 ? "line".$i++."\n" : undef;
    }
  
    run3 \@cmd, \&producer;              # child reads 10 lines
  
  Note that this form of redirecting the child's I/O doesn't imply
  any form of concurrency between parent and child - run3()'s method of
  operation is the same no matter which form of redirection you specify.
  
  =back
  
  If the same value is passed for C<$stdout> and C<$stderr>, then the child
  will write both C<STDOUT> and C<STDERR> to the same filehandle.
  In general, this means that
  
      run3 \@cmd, \undef, "foo.txt", "foo.txt";
      run3 \@cmd, \undef, \$both, \$both;
  
  will DWIM and pass a single file handle to the child for both C<STDOUT> and
  C<STDERR>, collecting all into file "foo.txt" or C<$both>.
  
  =head3 C<\%options>
  
  The last parameter, C<\%options>, must be a hash reference if present.
  
  Currently the following keys are supported:
  
  =over 4
  
  =item C<binmode_stdin>, C<binmode_stdout>, C<binmode_stderr>
  
  The value must a "layer" as described in L<perlfunc/binmode>.  If specified the
  corresponding parameter C<$stdin>, C<$stdout> or C<$stderr>, resp., operates
  with the given layer.
  
  For backward compatibility, a true value that doesn't start with ":"
  (e.g. a number) is interpreted as ":raw". If the value is false
  or not specified, the default is ":crlf" on Windows and ":raw" otherwise.
  
  Don't expect that values other than the built-in layers ":raw", ":crlf",
  and (on newer Perls) ":bytes", ":utf8", ":encoding(...)" will work.
  
  =item C<append_stdout>, C<append_stderr>
  
  If their value is true then the corresponding parameter C<$stdout> or
  C<$stderr>, resp., will append the child's output to the existing "contents" of
  the redirector. This only makes sense if the redirector is a simple scalar (the
  corresponding file is opened in append mode), a SCALAR reference (the output is
  appended to the previous contents of the string) or an ARRAY reference (the
  output is C<push>ed onto the previous contents of the array).
  
  =item C<return_if_system_error>
  
  If this is true C<run3> does B<not> throw an exception if C<system> returns -1
  (cf. L<perlfunc/system> for possible failure scenarios.), but returns true
  instead.  In this case C<$?> has the value -1 and C<$!> contains the errno of
  the failing C<system> call.
  
  =back
  
  =head1 HOW IT WORKS
  
  =over 4
  
  =item (1)
  
  For each redirector C<$stdin>, C<$stdout>, and C<$stderr>, C<run3()> furnishes
  a filehandle:
  
  =over 4
  
  =item *
  
  if the redirector already specifies a filehandle it just uses that
  
  =item *
  
  if the redirector specifies a filename, C<run3()> opens the file
  in the appropriate mode
  
  =item *
  
  in all other cases, C<run3()> opens a temporary file (using
  L<tempfile|Temp/tempfile>)
  
  =back
  
  =item (2)
  
  If C<run3()> opened a temporary file for C<$stdin> in step (1),
  it writes the data using the specified method (either
  from a string, an array or returned by a function) to the temporary file and rewinds it.
  
  =item (3)
  
  C<run3()> saves the parent's C<STDIN>, C<STDOUT> and C<STDERR> by duplicating
  them to new filehandles. It duplicates the filehandles from step (1)
  to C<STDIN>, C<STDOUT> and C<STDERR>, resp.
  
  =item (4)
  
  C<run3()> runs the child by invoking L<system|perlfunc/system> with C<$cmd> as
  specified above.
  
  =item (5)
  
  C<run3()> restores the parent's C<STDIN>, C<STDOUT> and C<STDERR> saved in step (3).
  
  =item (6)
  
  If C<run3()> opened a temporary file for C<$stdout> or C<$stderr> in step (1),
  it rewinds it and reads back its contents using the specified method (either to
  a string, an array or by calling a function).
  
  =item (7)
  
  C<run3()> closes all filehandles that it opened explicitly in step (1).
  
  =back
  
  Note that when using temporary files, C<run3()> tries to amortize the overhead
  by reusing them (i.e. it keeps them open and rewinds and truncates them
  before the next operation).
  
  =head1 LIMITATIONS
  
  Often uses intermediate files (determined by File::Temp, and thus by the
  File::Spec defaults and the TMPDIR env. variable) for speed, portability and
  simplicity.
  
  Use extreme caution when using C<run3> in a threaded environment if concurrent
  calls of C<run3> are possible. Most likely, I/O from different invocations will
  get mixed up. The reason is that in most thread implementations all threads in
  a process share the same STDIN/STDOUT/STDERR.  Known failures are Perl ithreads
  on Linux and Win32. Note that C<fork> on Win32 is emulated via Win32 threads
  and hence I/O mix up is possible between forked children here (C<run3> is "fork
  safe" on Unix, though).
  
  =head1 DEBUGGING
  
  To enable debugging use the IPCRUN3DEBUG environment variable to
  a non-zero integer value:
  
    $ IPCRUN3DEBUG=1 myapp
  
  =head1 PROFILING
  
  To enable profiling, set IPCRUN3PROFILE to a number to enable emitting profile
  information to STDERR (1 to get timestamps, 2 to get a summary report at the
  END of the program, 3 to get mini reports after each run) or to a filename to
  emit raw data to a file for later analysis.
  
  =head1 COMPARISON
  
  Here's how it stacks up to existing APIs:
  
  =head2 compared to C<system()>, C<qx''>, C<open "...|">, C<open "|...">
  
  =over
  
  =item *
  
  better: redirects more than one file descriptor
  
  =item *
  
  better: returns TRUE on success, FALSE on failure
  
  =item *
  
  better: throws an error if problems occur in the parent process (or the
  pre-exec child)
  
  =item *
  
  better: allows a very perlish interface to Perl data structures and subroutines
  
  =item *
  
  better: allows 1 word invocations to avoid the shell easily:
  
   run3 ["foo"];  # does not invoke shell
  
  =item *
  
  worse: does not return the exit code, leaves it in $?
  
  =back
  
  =head2 compared to C<open2()>, C<open3()>
  
  =over
  
  =item *
  
  better: no lengthy, error prone polling/select loop needed
  
  =item *
  
  better: hides OS dependencies
  
  =item *
  
  better: allows SCALAR, ARRAY, and CODE references to source and sink I/O
  
  =item *
  
  better: I/O parameter order is like C<open3()>  (not like C<open2()>).
  
  =item *
  
  worse: does not allow interaction with the subprocess
  
  =back
  
  =head2 compared to L<IPC::Run::run()|IPC::Run/run>
  
  =over
  
  =item *
  
  better: smaller, lower overhead, simpler, more portable
  
  =item *
  
  better: no select() loop portability issues
  
  =item *
  
  better: does not fall prey to Perl closure leaks
  
  =item *
  
  worse: does not allow interaction with the subprocess (which IPC::Run::run()
  allows by redirecting subroutines)
  
  =item *
  
  worse: lacks many features of C<IPC::Run::run()> (filters, pipes, redirects,
  pty support)
  
  =back
  
  =head1 COPYRIGHT
  
  Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker E<lt>C<barries@slaysys.com>E<gt>
  
  Ricardo SIGNES E<lt>C<rjbs@cpan.org>E<gt> performed routine maintenance since
  2010, thanks to help from the following ticket and/or patch submitters: Jody
  Belka, Roderich Schupp, David Morel, Jeff Lavallee, and anonymous others.
  
  =cut
IPC_RUN3

$fatpacked{"IPC/Run3/ProfArrayBuffer.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3_PROFARRAYBUFFER';
  package IPC::Run3::ProfArrayBuffer;
  
  $VERSION = 0.048;
  
  =head1 NAME
  
  IPC::Run3::ProfArrayBuffer - Store profile events in RAM in an array
  
  =head1 SYNOPSIS
  
  =head1 DESCRIPTION
  
  =cut
  
  use strict;
  
  =head1 METHODS
  
  =over
  
  =item C<< IPC::Run3::ProfArrayBuffer->new() >>
  
  =cut
  
  sub new {
      my $class = ref $_[0] ? ref shift : shift;
  
      my $self = bless { @_ }, $class;
  
      $self->{Events} = [];
  
      return $self;
  }
  
  =item C<< $buffer->app_call(@events) >>
  
  =item C<< $buffer->app_exit(@events) >>
  
  =item C<< $buffer->run_exit(@events) >>
  
  The three above methods push the given events onto the stack of recorded
  events.
  
  =cut
  
  for my $subname ( qw(app_call app_exit run_exit) ) {
    no strict 'refs';
    *{$subname} = sub {
        push @{shift->{Events}}, [ $subname => @_ ];
    };
  }
  
  =item get_events
  
  Returns a list of all the events.  Each event is an ARRAY reference
  like:
  
     [ "app_call", 1.1, ... ];
  
  =cut
  
  sub get_events {
      my $self = shift;
      @{$self->{Events}};
  }
  
  =back
  
  =head1 LIMITATIONS
  
  =head1 COPYRIGHT
  
  Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker E<lt>barries@slaysys.comE<gt>
  
  =cut
  
  1;
IPC_RUN3_PROFARRAYBUFFER

$fatpacked{"IPC/Run3/ProfLogReader.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3_PROFLOGREADER';
  package IPC::Run3::ProfLogReader;
  
  $VERSION = 0.048;
  
  =head1 NAME
  
  IPC::Run3::ProfLogReader -  read and process a ProfLogger file
  
  =head1 SYNOPSIS
  
   use IPC::Run3::ProfLogReader;
  
   my $reader = IPC::Run3::ProfLogReader->new; ## use "run3.out"
   my $reader = IPC::Run3::ProfLogReader->new( Source => $fn );
  
   my $profiler = IPC::Run3::ProfPP;   ## For example
   my $reader   = IPC::Run3::ProfLogReader->new( ..., Handler => $p );
  
   $reader->read;
   $eaderr->read_all;
  
  =head1 DESCRIPTION
  
  Reads a log file.  Use the filename "-" to read from STDIN.
  
  =cut
  
  use strict;
  
  =head1 METHODS
  
  =head2 C<< IPC::Run3::ProfLogReader->new( ... ) >>
  
  =cut
  
  sub new {
      my $class = ref $_[0] ? ref shift : shift;
      my $self = bless { @_ }, $class;
      
      $self->{Source} = "run3.out"
          unless defined $self->{Source} && length $self->{Source};
  
      my $source = $self->{Source};
  
      if ( ref $source eq "GLOB" || UNIVERSAL::isa( $source, "IO::Handle" ) ) {
          $self->{FH} = $source;
      }
      elsif ( $source eq "-" ) {
          $self->{FH} = \*STDIN;
      }
      else {
          open PROFILE, "<$self->{Source}" or die "$!: $self->{Source}\n";
          $self->{FH} = *PROFILE{IO};
      }
      return $self;
  }
  
  
  =head2 C<< $reader->set_handler( $handler ) >>
  
  =cut
  
  sub set_handler { $_[0]->{Handler} = $_[1] }
  
  =head2 C<< $reader->get_handler() >>
  
  =cut
  
  sub get_handler { $_[0]->{Handler} }
  
  =head2 C<< $reader->read() >>
  
  =cut
  
  sub read {
      my $self = shift;
  
      my $fh = $self->{FH};
      my @ln = split / /, <$fh>;
  
      return 0 unless @ln;
      return 1 unless $self->{Handler};
  
      chomp $ln[-1];
  
      ## Ignore blank and comment lines.
      return 1 if @ln == 1 && ! length $ln[0] || 0 == index $ln[0], "#";
  
      if ( $ln[0] eq "\\app_call" ) {
          shift @ln;
          my @times = split /,/, pop @ln;
          $self->{Handler}->app_call(
              [
                  map {
                      s/\\\\/\\/g;
                      s/\\_/ /g;
                      $_;
                  } @ln
              ],
              @times
          );
      }
      elsif ( $ln[0] eq "\\app_exit" ) {
          shift @ln;
          $self->{Handler}->app_exit( pop @ln, @ln );
      }
      else {
          my @times = split /,/, pop @ln;
          $self->{Handler}->run_exit(
              [
                  map {
                      s/\\\\/\\/g;
                      s/\\_/ /g;
                      $_;
                  } @ln
              ],
              @times
          );
      }
  
      return 1;
  }
  
  
  =head2 C<< $reader->read_all() >>
  
  This method reads until there is nothing left to read, and then returns true.
  
  =cut
  
  sub read_all {
      my $self = shift;
  
      1 while $self->read;
  
      return 1;
  }
  
  
  =head1 LIMITATIONS
  
  =head1 COPYRIGHT
  
      Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker E<lt>barries@slaysys.comE<gt>
  
  =cut
  
  1;
IPC_RUN3_PROFLOGREADER

$fatpacked{"IPC/Run3/ProfLogger.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3_PROFLOGGER';
  package IPC::Run3::ProfLogger;
  
  $VERSION = 0.048;
  
  =head1 NAME
  
  IPC::Run3::ProfLogger - write profiling data to a log file
  
  =head1 SYNOPSIS
  
   use IPC::Run3::ProfLogger;
  
   my $logger = IPC::Run3::ProfLogger->new;  ## write to "run3.out"
   my $logger = IPC::Run3::ProfLogger->new( Destination => $fn );
  
   $logger->app_call( \@cmd, $time );
  
   $logger->run_exit( \@cmd1, @times1 );
   $logger->run_exit( \@cmd1, @times1 );
  
   $logger->app_exit( $time );
  
  =head1 DESCRIPTION
  
  Used by IPC::Run3 to write a profiling log file.  Does not
  generate reports or maintain statistics; its meant to have minimal
  overhead.
  
  Its API is compatible with a tiny subset of the other IPC::Run profiling
  classes.
  
  =cut
  
  use strict;
  
  =head1 METHODS
  
  =head2 C<< IPC::Run3::ProfLogger->new( ... ) >>
  
  =cut
  
  sub new {
      my $class = ref $_[0] ? ref shift : shift;
      my $self = bless { @_ }, $class;
      
      $self->{Destination} = "run3.out"
          unless defined $self->{Destination} && length $self->{Destination};
  
      open PROFILE, ">$self->{Destination}"
          or die "$!: $self->{Destination}\n";
      binmode PROFILE;
      $self->{FH} = *PROFILE{IO};
  
      $self->{times} = [];
      return $self;
  }
  
  =head2 C<< $logger->run_exit( ... ) >>
  
  =cut
  
  sub run_exit {
      my $self = shift;
      my $fh = $self->{FH};
      print( $fh
          join(
              " ",
              (
                  map {
                      my $s = $_;
                      $s =~ s/\\/\\\\/g;
                      $s =~ s/ /_/g;
                      $s;
                  } @{shift()}
              ),
              join(
                  ",",
                  @{$self->{times}},
                  @_,
              ),
          ),
          "\n"
      );
  }
  
  =head2 C<< $logger->app_exit( $arg ) >>
  
  =cut
  
  sub app_exit {
      my $self = shift;
      my $fh = $self->{FH};
      print $fh "\\app_exit ", shift, "\n";
  }
  
  =head2 C<< $logger->app_call( $t, @args) >>
  
  =cut
  
  sub app_call {
      my $self = shift;
      my $fh = $self->{FH};
      my $t = shift;
      print( $fh
          join(
              " ",
              "\\app_call",
              (
                  map {
                      my $s = $_;
                      $s =~ s/\\\\/\\/g;
                      $s =~ s/ /\\_/g;
                      $s;
                  } @_
              ),
              $t,
          ),
          "\n"
      );
  }
  
  =head1 LIMITATIONS
  
  =head1 COPYRIGHT
  
  Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker E<lt>barries@slaysys.comE<gt>
  
  =cut
  
  1;
IPC_RUN3_PROFLOGGER

$fatpacked{"IPC/Run3/ProfPP.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3_PROFPP';
  package IPC::Run3::ProfPP;
  
  $VERSION = 0.048;
  
  =head1 NAME
  
  IPC::Run3::ProfPP - Generate reports from IPC::Run3 profiling data
  
  =head1 SYNOPSIS
  
  =head1 DESCRIPTION
  
  Used by IPC::Run3 and/or run3profpp to print out profiling reports for
  human readers.  Use other classes for extracting data in other ways.
  
  The output methods are plain text, override these (see the source for
  now) to provide other formats.
  
  This class generates reports on each run3_exit() and app_exit() call.
  
  =cut
  
  require IPC::Run3::ProfReporter;
  @ISA = qw( IPC::Run3::ProfReporter );
  
  use strict;
  use POSIX qw( floor );
  
  =head1 METHODS
  
  =head2 C<< IPC::Run3::ProfPP->new() >>
  
  Returns a new profile reporting object.
  
  =cut
  
  sub _emit { shift; warn @_ }
  
  sub _t {
      sprintf "%10.6f secs", @_;
  }
  
  sub _r {
      my ( $num, $denom ) = @_;
      return () unless $denom;
      sprintf "%10.6f", $num / $denom;
  }
  
  sub _pct {
      my ( $num, $denom ) = @_;
      return () unless $denom;
      sprintf  " (%3d%%)", floor( 100 * $num / $denom + 0.5 );
  }
  
  =head2 C<< $profpp->handle_app_call() >>
  
  =cut
  
  sub handle_app_call {
      my $self = shift;
      $self->_emit("IPC::Run3 parent: ",
          join( " ", @{$self->get_app_cmd} ),
          "\n",
      );
  
      $self->{NeedNL} = 1;
  }
  
  =head2 C<< $profpp->handle_app_exit() >>
  
  =cut
  
  sub handle_app_exit {
      my $self = shift;
  
      $self->_emit("\n") if $self->{NeedNL} && $self->{NeedNL} != 1;
  
      $self->_emit( "IPC::Run3 total elapsed:             ",
          _t( $self->get_app_cumulative_time ),
          "\n");
      $self->_emit( "IPC::Run3 calls to run3():    ",
          sprintf( "%10d", $self->get_run_count ),
          "\n");
      $self->_emit( "IPC::Run3 total spent in run3():     ",
          _t( $self->get_run_cumulative_time ),
          _pct( $self->get_run_cumulative_time, $self->get_app_cumulative_time ),
          ", ",
          _r( $self->get_run_cumulative_time, $self->get_run_count ),
          " per call",
          "\n");
      my $exclusive = 
          $self->get_app_cumulative_time - $self->get_run_cumulative_time;
      $self->_emit( "IPC::Run3 total spent not in run3(): ",
          _t( $exclusive ),
          _pct( $exclusive, $self->get_app_cumulative_time ),
          "\n");
      $self->_emit( "IPC::Run3 total spent in children:   ",
          _t( $self->get_sys_cumulative_time ),
          _pct( $self->get_sys_cumulative_time, $self->get_app_cumulative_time ),
          ", ",
          _r( $self->get_sys_cumulative_time, $self->get_run_count ),
          " per call",
          "\n");
      my $overhead =
          $self->get_run_cumulative_time - $self->get_sys_cumulative_time;
      $self->_emit( "IPC::Run3 total overhead:            ",
          _t( $overhead ),
          _pct(
              $overhead,
              $self->get_sys_cumulative_time
          ),
          ", ",
          _r( $overhead, $self->get_run_count ),
          " per call",
          "\n");
  }
  
  =head2 C<< $profpp->handle_run_exit() >>
  
  =cut
  
  sub handle_run_exit {
      my $self = shift;
      my $overhead = $self->get_run_time - $self->get_sys_time;
  
      $self->_emit("\n") if $self->{NeedNL} && $self->{NeedNL} != 2;
      $self->{NeedNL} = 3;
  
      $self->_emit( "IPC::Run3 child: ",
          join( " ", @{$self->get_run_cmd} ),
          "\n");
      $self->_emit( "IPC::Run3 run3()  : ", _t( $self->get_run_time ), "\n",
           "IPC::Run3 child   : ", _t( $self->get_sys_time ), "\n",
           "IPC::Run3 overhead: ", _t( $overhead ),
               _pct( $overhead, $self->get_sys_time ),
               "\n");
  }
  
  =head1 LIMITATIONS
  
  =head1 COPYRIGHT
  
      Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker E<lt>barries@slaysys.comE<gt>
  
  =cut
  
  1;
IPC_RUN3_PROFPP

$fatpacked{"IPC/Run3/ProfReporter.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'IPC_RUN3_PROFREPORTER';
  package IPC::Run3::ProfReporter;
  
  $VERSION = 0.048;
  
  =head1 NAME
  
  IPC::Run3::ProfReporter - base class for handling profiling data
  
  =head1 SYNOPSIS
  
  =head1 DESCRIPTION
  
  See L<IPC::Run3::ProfPP|IPC::Run3::ProfPP> and for an example subclass.
  
  This class just notes and accumulates times; subclasses use methods like
  "handle_app_call", "handle_run_exit" and "handle_app_exit" to emit reports on
  it.  The default methods for these handlers are noops.
  
  If run from the command line, a reporter will be created and run on
  each logfile given as a command line parameter or on run3.out if none
  are given.
  
  This allows reports to be run like:
  
      perl -MIPC::Run3::ProfPP -e1
      perl -MIPC::Run3::ProfPP -e1 foo.out bar.out
  
  Use "-" to read from STDIN (the log file format is meant to be moderately
  greppable):
  
      grep "^cvs " run3.out perl -MIPC::Run3::ProfPP -e1 -
  
  Use --app to show only application level statistics (ie don't emit
  a report section for each command run).
  
  =cut
  
  use strict;
  
  my $loaded_by;
  
  sub import {
      $loaded_by = shift;
  }
  
  END {
      my @caller;
      for ( my $i = 0;; ++$i ) {
          my @c = caller $i;
          last unless @c;
          @caller = @c;
      }
  
      if ( $caller[0] eq "main"
          && $caller[1] eq "-e"
      ) {
          require IPC::Run3::ProfLogReader;
          require Getopt::Long;
          my ( $app, $run );
  
          Getopt::Long::GetOptions(
              "app" => \$app,
              "run" => \$run,
          );
  
          $app = 1, $run = 1 unless $app || $run;
  
          for ( @ARGV ? @ARGV : "" ) {
              my $r = IPC::Run3::ProfLogReader->new(
                  Source  => $_,
                  Handler => $loaded_by->new(
                      Source => $_,
                      app_report => $app,
                      run_report => $run,
                  ),
              );
              $r->read_all;
          }
      }
  }
  
  =head1 METHODS
  
  =over
  
  =item C<< IPC::Run3::ProfReporter->new >>
  
  Returns a new profile reporting object.
  
  =cut
  
  sub new {
      my $class = ref $_[0] ? ref shift : shift;
      my $self = bless { @_ }, $class;
      $self->{app_report} = 1, $self->{run_report} = 1
          unless $self->{app_report} || $self->{run_report};
  
      return $self;
  }
  
  =item C<< $reporter->handle_app_call( ... ) >>
  
  =item C<< $reporter->handle_app_exit( ... ) >>
  
  =item C<< $reporter->handle_run_exit( ... ) >>
  
  These methods are called by the handled events (see below).
  
  =cut
  
  sub handle_app_call {}
  sub handle_app_exit {}
  
  sub handle_run_exit {}
  
  =item C<< $reporter->app_call(\@cmd, $time) >>
  
  =item C<< $reporter->app_exit($time) >>
  
  =item C<< $reporter->run_exit(@times) >>
  
     $self->app_call( $time );
     my $time = $self->get_app_call_time;
  
  Sets the time (in floating point seconds) when the application, run3(),
  or system() was called or exited.  If no time parameter is passed, uses
  IPC::Run3's time routine.
  
  Use get_...() to retrieve these values (and _accum values, too).  This
  is a separate method to speed the execution time of the setters just a
  bit.
  
  =cut
  
  sub app_call {
      my $self = shift;
      ( $self->{app_cmd}, $self->{app_call_time} ) = @_;
      $self->handle_app_call if $self->{app_report};
  }
  
  sub app_exit {
      my $self = shift;
      $self->{app_exit_time} = shift;
      $self->handle_app_exit if $self->{app_report};
  }
  
  sub run_exit {
      my $self = shift;
      @{$self}{qw(
          run_cmd run_call_time sys_call_time sys_exit_time run_exit_time
      )} = @_;
  
      ++$self->{run_count};
      $self->{run_cumulative_time} += $self->get_run_time;
      $self->{sys_cumulative_time} += $self->get_sys_time;
      $self->handle_run_exit if $self->{run_report};
  }
  
  =item C<< $reporter->get_run_count() >>
  
  =item C<< $reporter->get_app_call_time() >>
  
  =item C<< $reporter->get_app_exit_time() >>
  
  =item C<< $reporter->get_app_cmd() >>
  
  =item C<< $reporter->get_app_time() >>
  
  =cut
  
  sub get_run_count     { shift->{run_count} }
  sub get_app_call_time { shift->{app_call_time} }
  sub get_app_exit_time { shift->{app_exit_time} }
  sub get_app_cmd       { shift->{app_cmd}       }
  sub get_app_time {
      my $self = shift;
      $self->get_app_exit_time - $self->get_app_call_time;
  }
  
  =item C<< $reporter->get_app_cumulative_time() >>
  
  =cut
  
  sub get_app_cumulative_time {
      my $self = shift;
      $self->get_app_exit_time - $self->get_app_call_time;
  }
  
  =item C<< $reporter->get_run_call_time() >>
  
  =item C<< $reporter->get_run_exit_time() >>
  
  =item C<< $reporter->get_run_time() >>
  
  =cut
  
  sub get_run_call_time { shift->{run_call_time} }
  sub get_run_exit_time { shift->{run_exit_time} }
  sub get_run_time {
      my $self = shift;
      $self->get_run_exit_time - $self->get_run_call_time;
  }
  
  =item C<< $reporter->get_run_cumulative_time() >>
  
  =cut
  
  sub get_run_cumulative_time { shift->{run_cumulative_time} }
  
  =item C<< $reporter->get_sys_call_time() >>
  
  =item C<< $reporter->get_sys_exit_time() >>
  
  =item C<< $reporter->get_sys_time() >>
  
  =cut
  
  sub get_sys_call_time { shift->{sys_call_time} }
  sub get_sys_exit_time { shift->{sys_exit_time} }
  sub get_sys_time {
      my $self = shift;
      $self->get_sys_exit_time - $self->get_sys_call_time;
  }
  
  =item C<< $reporter->get_sys_cumulative_time() >>
  
  =cut
  
  sub get_sys_cumulative_time { shift->{sys_cumulative_time} }
  
  =item C<< $reporter->get_run_cmd() >>
  
  =cut
  
  sub get_run_cmd { shift->{run_cmd} }
  
  =back
  
  =head1 LIMITATIONS
  
  =head1 COPYRIGHT
  
      Copyright 2003, R. Barrie Slaymaker, Jr., All Rights Reserved
  
  =head1 LICENSE
  
  You may use this module under the terms of the BSD, Artistic, or GPL licenses,
  any version.
  
  =head1 AUTHOR
  
  Barrie Slaymaker <barries@slaysys.com>
  
  =cut
  
  1;
IPC_RUN3_PROFREPORTER

$fatpacked{"JSON/PP.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'JSON_PP';
  package JSON::PP;
  
  # JSON-2.0
  
  use 5.005;
  use strict;
  
  use Exporter ();
  BEGIN { @JSON::PP::ISA = ('Exporter') }
  
  use overload ();
  use JSON::PP::Boolean;
  
  use Carp ();
  #use Devel::Peek;
  
  $JSON::PP::VERSION = '2.97001';
  
  @JSON::PP::EXPORT = qw(encode_json decode_json from_json to_json);
  
  # instead of hash-access, i tried index-access for speed.
  # but this method is not faster than what i expected. so it will be changed.
  
  use constant P_ASCII                => 0;
  use constant P_LATIN1               => 1;
  use constant P_UTF8                 => 2;
  use constant P_INDENT               => 3;
  use constant P_CANONICAL            => 4;
  use constant P_SPACE_BEFORE         => 5;
  use constant P_SPACE_AFTER          => 6;
  use constant P_ALLOW_NONREF         => 7;
  use constant P_SHRINK               => 8;
  use constant P_ALLOW_BLESSED        => 9;
  use constant P_CONVERT_BLESSED      => 10;
  use constant P_RELAXED              => 11;
  
  use constant P_LOOSE                => 12;
  use constant P_ALLOW_BIGNUM         => 13;
  use constant P_ALLOW_BAREKEY        => 14;
  use constant P_ALLOW_SINGLEQUOTE    => 15;
  use constant P_ESCAPE_SLASH         => 16;
  use constant P_AS_NONBLESSED        => 17;
  
  use constant P_ALLOW_UNKNOWN        => 18;
  
  use constant OLD_PERL => $] < 5.008 ? 1 : 0;
  use constant USE_B => 0;
  
  BEGIN {
  if (USE_B) {
      require B;
  }
  }
  
  BEGIN {
      my @xs_compati_bit_properties = qw(
              latin1 ascii utf8 indent canonical space_before space_after allow_nonref shrink
              allow_blessed convert_blessed relaxed allow_unknown
      );
      my @pp_bit_properties = qw(
              allow_singlequote allow_bignum loose
              allow_barekey escape_slash as_nonblessed
      );
  
      # Perl version check, Unicode handling is enabled?
      # Helper module sets @JSON::PP::_properties.
      if ( OLD_PERL ) {
          my $helper = $] >= 5.006 ? 'JSON::PP::Compat5006' : 'JSON::PP::Compat5005';
          eval qq| require $helper |;
          if ($@) { Carp::croak $@; }
      }
  
      for my $name (@xs_compati_bit_properties, @pp_bit_properties) {
          my $property_id = 'P_' . uc($name);
  
          eval qq/
              sub $name {
                  my \$enable = defined \$_[1] ? \$_[1] : 1;
  
                  if (\$enable) {
                      \$_[0]->{PROPS}->[$property_id] = 1;
                  }
                  else {
                      \$_[0]->{PROPS}->[$property_id] = 0;
                  }
  
                  \$_[0];
              }
  
              sub get_$name {
                  \$_[0]->{PROPS}->[$property_id] ? 1 : '';
              }
          /;
      }
  
  }
  
  
  
  # Functions
  
  my $JSON; # cache
  
  sub encode_json ($) { # encode
      ($JSON ||= __PACKAGE__->new->utf8)->encode(@_);
  }
  
  
  sub decode_json { # decode
      ($JSON ||= __PACKAGE__->new->utf8)->decode(@_);
  }
  
  # Obsoleted
  
  sub to_json($) {
     Carp::croak ("JSON::PP::to_json has been renamed to encode_json.");
  }
  
  
  sub from_json($) {
     Carp::croak ("JSON::PP::from_json has been renamed to decode_json.");
  }
  
  
  # Methods
  
  sub new {
      my $class = shift;
      my $self  = {
          max_depth   => 512,
          max_size    => 0,
          indent_length => 3,
      };
  
      bless $self, $class;
  }
  
  
  sub encode {
      return $_[0]->PP_encode_json($_[1]);
  }
  
  
  sub decode {
      return $_[0]->PP_decode_json($_[1], 0x00000000);
  }
  
  
  sub decode_prefix {
      return $_[0]->PP_decode_json($_[1], 0x00000001);
  }
  
  
  # accessor
  
  
  # pretty printing
  
  sub pretty {
      my ($self, $v) = @_;
      my $enable = defined $v ? $v : 1;
  
      if ($enable) { # indent_length(3) for JSON::XS compatibility
          $self->indent(1)->space_before(1)->space_after(1);
      }
      else {
          $self->indent(0)->space_before(0)->space_after(0);
      }
  
      $self;
  }
  
  # etc
  
  sub max_depth {
      my $max  = defined $_[1] ? $_[1] : 0x80000000;
      $_[0]->{max_depth} = $max;
      $_[0];
  }
  
  
  sub get_max_depth { $_[0]->{max_depth}; }
  
  
  sub max_size {
      my $max  = defined $_[1] ? $_[1] : 0;
      $_[0]->{max_size} = $max;
      $_[0];
  }
  
  
  sub get_max_size { $_[0]->{max_size}; }
  
  
  sub filter_json_object {
      if (defined $_[1] and ref $_[1] eq 'CODE') {
          $_[0]->{cb_object} = $_[1];
      } else {
          delete $_[0]->{cb_object};
      }
      $_[0]->{F_HOOK} = ($_[0]->{cb_object} or $_[0]->{cb_sk_object}) ? 1 : 0;
      $_[0];
  }
  
  sub filter_json_single_key_object {
      if (@_ == 1 or @_ > 3) {
          Carp::croak("Usage: JSON::PP::filter_json_single_key_object(self, key, callback = undef)");
      }
      if (defined $_[2] and ref $_[2] eq 'CODE') {
          $_[0]->{cb_sk_object}->{$_[1]} = $_[2];
      } else {
          delete $_[0]->{cb_sk_object}->{$_[1]};
          delete $_[0]->{cb_sk_object} unless %{$_[0]->{cb_sk_object} || {}};
      }
      $_[0]->{F_HOOK} = ($_[0]->{cb_object} or $_[0]->{cb_sk_object}) ? 1 : 0;
      $_[0];
  }
  
  sub indent_length {
      if (!defined $_[1] or $_[1] > 15 or $_[1] < 0) {
          Carp::carp "The acceptable range of indent_length() is 0 to 15.";
      }
      else {
          $_[0]->{indent_length} = $_[1];
      }
      $_[0];
  }
  
  sub get_indent_length {
      $_[0]->{indent_length};
  }
  
  sub sort_by {
      $_[0]->{sort_by} = defined $_[1] ? $_[1] : 1;
      $_[0];
  }
  
  sub allow_bigint {
      Carp::carp("allow_bigint() is obsoleted. use allow_bignum() instead.");
      $_[0]->allow_bignum;
  }
  
  ###############################
  
  ###
  ### Perl => JSON
  ###
  
  
  { # Convert
  
      my $max_depth;
      my $indent;
      my $ascii;
      my $latin1;
      my $utf8;
      my $space_before;
      my $space_after;
      my $canonical;
      my $allow_blessed;
      my $convert_blessed;
  
      my $indent_length;
      my $escape_slash;
      my $bignum;
      my $as_nonblessed;
  
      my $depth;
      my $indent_count;
      my $keysort;
  
  
      sub PP_encode_json {
          my $self = shift;
          my $obj  = shift;
  
          $indent_count = 0;
          $depth        = 0;
  
          my $props = $self->{PROPS};
  
          ($ascii, $latin1, $utf8, $indent, $canonical, $space_before, $space_after, $allow_blessed,
              $convert_blessed, $escape_slash, $bignum, $as_nonblessed)
           = @{$props}[P_ASCII .. P_SPACE_AFTER, P_ALLOW_BLESSED, P_CONVERT_BLESSED,
                      P_ESCAPE_SLASH, P_ALLOW_BIGNUM, P_AS_NONBLESSED];
  
          ($max_depth, $indent_length) = @{$self}{qw/max_depth indent_length/};
  
          $keysort = $canonical ? sub { $a cmp $b } : undef;
  
          if ($self->{sort_by}) {
              $keysort = ref($self->{sort_by}) eq 'CODE' ? $self->{sort_by}
                       : $self->{sort_by} =~ /\D+/       ? $self->{sort_by}
                       : sub { $a cmp $b };
          }
  
          encode_error("hash- or arrayref expected (not a simple scalar, use allow_nonref to allow this)")
               if(!ref $obj and !$props->[ P_ALLOW_NONREF ]);
  
          my $str  = $self->object_to_json($obj);
  
          $str .= "\n" if ( $indent ); # JSON::XS 2.26 compatible
  
          unless ($ascii or $latin1 or $utf8) {
              utf8::upgrade($str);
          }
  
          if ($props->[ P_SHRINK ]) {
              utf8::downgrade($str, 1);
          }
  
          return $str;
      }
  
  
      sub object_to_json {
          my ($self, $obj) = @_;
          my $type = ref($obj);
  
          if($type eq 'HASH'){
              return $self->hash_to_json($obj);
          }
          elsif($type eq 'ARRAY'){
              return $self->array_to_json($obj);
          }
          elsif ($type) { # blessed object?
              if (blessed($obj)) {
  
                  return $self->value_to_json($obj) if ( $obj->isa('JSON::PP::Boolean') );
  
                  if ( $convert_blessed and $obj->can('TO_JSON') ) {
                      my $result = $obj->TO_JSON();
                      if ( defined $result and ref( $result ) ) {
                          if ( refaddr( $obj ) eq refaddr( $result ) ) {
                              encode_error( sprintf(
                                  "%s::TO_JSON method returned same object as was passed instead of a new one",
                                  ref $obj
                              ) );
                          }
                      }
  
                      return $self->object_to_json( $result );
                  }
  
                  return "$obj" if ( $bignum and _is_bignum($obj) );
  
                  if ($allow_blessed) {
                      return $self->blessed_to_json($obj) if ($as_nonblessed); # will be removed.
                      return 'null';
                  }
                  encode_error( sprintf("encountered object '%s', but neither allow_blessed "
                      . "nor convert_blessed settings are enabled", $obj)
                  );
              }
              else {
                  return $self->value_to_json($obj);
              }
          }
          else{
              return $self->value_to_json($obj);
          }
      }
  
  
      sub hash_to_json {
          my ($self, $obj) = @_;
          my @res;
  
          encode_error("json text or perl structure exceeds maximum nesting level (max_depth set too low?)")
                                           if (++$depth > $max_depth);
  
          my ($pre, $post) = $indent ? $self->_up_indent() : ('', '');
          my $del = ($space_before ? ' ' : '') . ':' . ($space_after ? ' ' : '');
  
          for my $k ( _sort( $obj ) ) {
              if ( OLD_PERL ) { utf8::decode($k) } # key for Perl 5.6 / be optimized
              push @res, $self->string_to_json( $k )
                            .  $del
                            . ( ref $obj->{$k} ? $self->object_to_json( $obj->{$k} ) : $self->value_to_json( $obj->{$k} ) );
          }
  
          --$depth;
          $self->_down_indent() if ($indent);
  
          return '{}' unless @res;
          return '{' . $pre . join( ",$pre", @res ) . $post . '}';
      }
  
  
      sub array_to_json {
          my ($self, $obj) = @_;
          my @res;
  
          encode_error("json text or perl structure exceeds maximum nesting level (max_depth set too low?)")
                                           if (++$depth > $max_depth);
  
          my ($pre, $post) = $indent ? $self->_up_indent() : ('', '');
  
          for my $v (@$obj){
              push @res, ref($v) ? $self->object_to_json($v) : $self->value_to_json($v);
          }
  
          --$depth;
          $self->_down_indent() if ($indent);
  
          return '[]' unless @res;
          return '[' . $pre . join( ",$pre", @res ) . $post . ']';
      }
  
      sub _looks_like_number {
          my $value = shift;
          if (USE_B) {
              my $b_obj = B::svref_2object(\$value);
              my $flags = $b_obj->FLAGS;
              return 1 if $flags & ( B::SVp_IOK() | B::SVp_NOK() ) and !( $flags & B::SVp_POK() );
              return;
          } else {
              no warnings 'numeric';
              # if the utf8 flag is on, it almost certainly started as a string
              return if utf8::is_utf8($value);
              # detect numbers
              # string & "" -> ""
              # number & "" -> 0 (with warning)
              # nan and inf can detect as numbers, so check with * 0
              return unless length((my $dummy = "") & $value);
              return unless 0 + $value eq $value;
              return 1 if $value * 0 == 0;
              return -1; # inf/nan
          }
      }
  
      sub value_to_json {
          my ($self, $value) = @_;
  
          return 'null' if(!defined $value);
  
          my $type = ref($value);
  
          if (!$type) {
              if (_looks_like_number($value)) {
                  return $value;
              }
              return $self->string_to_json($value);
          }
          elsif( blessed($value) and  $value->isa('JSON::PP::Boolean') ){
              return $$value == 1 ? 'true' : 'false';
          }
          else {
              if ((overload::StrVal($value) =~ /=(\w+)/)[0]) {
                  return $self->value_to_json("$value");
              }
  
              if ($type eq 'SCALAR' and defined $$value) {
                  return   $$value eq '1' ? 'true'
                         : $$value eq '0' ? 'false'
                         : $self->{PROPS}->[ P_ALLOW_UNKNOWN ] ? 'null'
                         : encode_error("cannot encode reference to scalar");
              }
  
              if ( $self->{PROPS}->[ P_ALLOW_UNKNOWN ] ) {
                  return 'null';
              }
              else {
                  if ( $type eq 'SCALAR' or $type eq 'REF' ) {
                      encode_error("cannot encode reference to scalar");
                  }
                  else {
                      encode_error("encountered $value, but JSON can only represent references to arrays or hashes");
                  }
              }
  
          }
      }
  
  
      my %esc = (
          "\n" => '\n',
          "\r" => '\r',
          "\t" => '\t',
          "\f" => '\f',
          "\b" => '\b',
          "\"" => '\"',
          "\\" => '\\\\',
          "\'" => '\\\'',
      );
  
  
      sub string_to_json {
          my ($self, $arg) = @_;
  
          $arg =~ s/([\x22\x5c\n\r\t\f\b])/$esc{$1}/g;
          $arg =~ s/\//\\\//g if ($escape_slash);
          $arg =~ s/([\x00-\x08\x0b\x0e-\x1f])/'\\u00' . unpack('H2', $1)/eg;
  
          if ($ascii) {
              $arg = JSON_PP_encode_ascii($arg);
          }
  
          if ($latin1) {
              $arg = JSON_PP_encode_latin1($arg);
          }
  
          if ($utf8) {
              utf8::encode($arg);
          }
  
          return '"' . $arg . '"';
      }
  
  
      sub blessed_to_json {
          my $reftype = reftype($_[1]) || '';
          if ($reftype eq 'HASH') {
              return $_[0]->hash_to_json($_[1]);
          }
          elsif ($reftype eq 'ARRAY') {
              return $_[0]->array_to_json($_[1]);
          }
          else {
              return 'null';
          }
      }
  
  
      sub encode_error {
          my $error  = shift;
          Carp::croak "$error";
      }
  
  
      sub _sort {
          defined $keysort ? (sort $keysort (keys %{$_[0]})) : keys %{$_[0]};
      }
  
  
      sub _up_indent {
          my $self  = shift;
          my $space = ' ' x $indent_length;
  
          my ($pre,$post) = ('','');
  
          $post = "\n" . $space x $indent_count;
  
          $indent_count++;
  
          $pre = "\n" . $space x $indent_count;
  
          return ($pre,$post);
      }
  
  
      sub _down_indent { $indent_count--; }
  
  
      sub PP_encode_box {
          {
              depth        => $depth,
              indent_count => $indent_count,
          };
      }
  
  } # Convert
  
  
  sub _encode_ascii {
      join('',
          map {
              $_ <= 127 ?
                  chr($_) :
              $_ <= 65535 ?
                  sprintf('\u%04x', $_) : sprintf('\u%x\u%x', _encode_surrogates($_));
          } unpack('U*', $_[0])
      );
  }
  
  
  sub _encode_latin1 {
      join('',
          map {
              $_ <= 255 ?
                  chr($_) :
              $_ <= 65535 ?
                  sprintf('\u%04x', $_) : sprintf('\u%x\u%x', _encode_surrogates($_));
          } unpack('U*', $_[0])
      );
  }
  
  
  sub _encode_surrogates { # from perlunicode
      my $uni = $_[0] - 0x10000;
      return ($uni / 0x400 + 0xD800, $uni % 0x400 + 0xDC00);
  }
  
  
  sub _is_bignum {
      $_[0]->isa('Math::BigInt') or $_[0]->isa('Math::BigFloat');
  }
  
  
  
  #
  # JSON => Perl
  #
  
  my $max_intsize;
  
  BEGIN {
      my $checkint = 1111;
      for my $d (5..64) {
          $checkint .= 1;
          my $int   = eval qq| $checkint |;
          if ($int =~ /[eE]/) {
              $max_intsize = $d - 1;
              last;
          }
      }
  }
  
  { # PARSE 
  
      my %escapes = ( #  by Jeremy Muhlich <jmuhlich [at] bitflood.org>
          b    => "\x8",
          t    => "\x9",
          n    => "\xA",
          f    => "\xC",
          r    => "\xD",
          '\\' => '\\',
          '"'  => '"',
          '/'  => '/',
      );
  
      my $text; # json data
      my $at;   # offset
      my $ch;   # first character
      my $len;  # text length (changed according to UTF8 or NON UTF8)
      # INTERNAL
      my $depth;          # nest counter
      my $encoding;       # json text encoding
      my $is_valid_utf8;  # temp variable
      my $utf8_len;       # utf8 byte length
      # FLAGS
      my $utf8;           # must be utf8
      my $max_depth;      # max nest number of objects and arrays
      my $max_size;
      my $relaxed;
      my $cb_object;
      my $cb_sk_object;
  
      my $F_HOOK;
  
      my $allow_bignum;   # using Math::BigInt/BigFloat
      my $singlequote;    # loosely quoting
      my $loose;          # 
      my $allow_barekey;  # bareKey
  
      sub _detect_utf_encoding {
          my $text = shift;
          my @octets = unpack('C4', $text);
          return 'unknown' unless defined $octets[3];
          return ( $octets[0] and  $octets[1]) ? 'UTF-8'
               : (!$octets[0] and  $octets[1]) ? 'UTF-16BE'
               : (!$octets[0] and !$octets[1]) ? 'UTF-32BE'
               : ( $octets[2]                ) ? 'UTF-16LE'
               : (!$octets[2]                ) ? 'UTF-32LE'
               : 'unknown';
      }
  
      sub PP_decode_json {
          my ($self, $want_offset);
  
          ($self, $text, $want_offset) = @_;
  
          ($at, $ch, $depth) = (0, '', 0);
  
          if ( !defined $text or ref $text ) {
              decode_error("malformed JSON string, neither array, object, number, string or atom");
          }
  
          my $props = $self->{PROPS};
  
          ($utf8, $relaxed, $loose, $allow_bignum, $allow_barekey, $singlequote)
              = @{$props}[P_UTF8, P_RELAXED, P_LOOSE .. P_ALLOW_SINGLEQUOTE];
  
          if ( $utf8 ) {
              $encoding = _detect_utf_encoding($text);
              if ($encoding ne 'UTF-8' and $encoding ne 'unknown') {
                  require Encode;
                  Encode::from_to($text, $encoding, 'utf-8');
              } else {
                  utf8::downgrade( $text, 1 ) or Carp::croak("Wide character in subroutine entry");
              }
          }
          else {
              utf8::upgrade( $text );
              utf8::encode( $text );
          }
  
          $len = length $text;
  
          ($max_depth, $max_size, $cb_object, $cb_sk_object, $F_HOOK)
               = @{$self}{qw/max_depth  max_size cb_object cb_sk_object F_HOOK/};
  
          if ($max_size > 1) {
              use bytes;
              my $bytes = length $text;
              decode_error(
                  sprintf("attempted decode of JSON text of %s bytes size, but max_size is set to %s"
                      , $bytes, $max_size), 1
              ) if ($bytes > $max_size);
          }
  
          white(); # remove head white space
  
          decode_error("malformed JSON string, neither array, object, number, string or atom") unless defined $ch; # Is there a first character for JSON structure?
  
          my $result = value();
  
          if ( !$props->[ P_ALLOW_NONREF ] and !ref $result ) {
                  decode_error(
                  'JSON text must be an object or array (but found number, string, true, false or null,'
                         . ' use allow_nonref to allow this)', 1);
          }
  
          Carp::croak('something wrong.') if $len < $at; # we won't arrive here.
  
          my $consumed = defined $ch ? $at - 1 : $at; # consumed JSON text length
  
          white(); # remove tail white space
  
          return ( $result, $consumed ) if $want_offset; # all right if decode_prefix
  
          decode_error("garbage after JSON object") if defined $ch;
  
          $result;
      }
  
  
      sub next_chr {
          return $ch = undef if($at >= $len);
          $ch = substr($text, $at++, 1);
      }
  
  
      sub value {
          white();
          return          if(!defined $ch);
          return object() if($ch eq '{');
          return array()  if($ch eq '[');
          return string() if($ch eq '"' or ($singlequote and $ch eq "'"));
          return number() if($ch =~ /[0-9]/ or $ch eq '-');
          return word();
      }
  
      sub string {
          my $utf16;
          my $is_utf8;
  
          ($is_valid_utf8, $utf8_len) = ('', 0);
  
          my $s = ''; # basically UTF8 flag on
  
          if($ch eq '"' or ($singlequote and $ch eq "'")){
              my $boundChar = $ch;
  
              OUTER: while( defined(next_chr()) ){
  
                  if($ch eq $boundChar){
                      next_chr();
  
                      if ($utf16) {
                          decode_error("missing low surrogate character in surrogate pair");
                      }
  
                      utf8::decode($s) if($is_utf8);
  
                      return $s;
                  }
                  elsif($ch eq '\\'){
                      next_chr();
                      if(exists $escapes{$ch}){
                          $s .= $escapes{$ch};
                      }
                      elsif($ch eq 'u'){ # UNICODE handling
                          my $u = '';
  
                          for(1..4){
                              $ch = next_chr();
                              last OUTER if($ch !~ /[0-9a-fA-F]/);
                              $u .= $ch;
                          }
  
                          # U+D800 - U+DBFF
                          if ($u =~ /^[dD][89abAB][0-9a-fA-F]{2}/) { # UTF-16 high surrogate?
                              $utf16 = $u;
                          }
                          # U+DC00 - U+DFFF
                          elsif ($u =~ /^[dD][c-fC-F][0-9a-fA-F]{2}/) { # UTF-16 low surrogate?
                              unless (defined $utf16) {
                                  decode_error("missing high surrogate character in surrogate pair");
                              }
                              $is_utf8 = 1;
                              $s .= JSON_PP_decode_surrogates($utf16, $u) || next;
                              $utf16 = undef;
                          }
                          else {
                              if (defined $utf16) {
                                  decode_error("surrogate pair expected");
                              }
  
                              if ( ( my $hex = hex( $u ) ) > 127 ) {
                                  $is_utf8 = 1;
                                  $s .= JSON_PP_decode_unicode($u) || next;
                              }
                              else {
                                  $s .= chr $hex;
                              }
                          }
  
                      }
                      else{
                          unless ($loose) {
                              $at -= 2;
                              decode_error('illegal backslash escape sequence in string');
                          }
                          $s .= $ch;
                      }
                  }
                  else{
  
                      if ( ord $ch  > 127 ) {
                          unless( $ch = is_valid_utf8($ch) ) {
                              $at -= 1;
                              decode_error("malformed UTF-8 character in JSON string");
                          }
                          else {
                              $at += $utf8_len - 1;
                          }
  
                          $is_utf8 = 1;
                      }
  
                      if (!$loose) {
                          if ($ch =~ /[\x00-\x1f\x22\x5c]/)  { # '/' ok
                              $at--;
                              decode_error('invalid character encountered while parsing JSON string');
                          }
                      }
  
                      $s .= $ch;
                  }
              }
          }
  
          decode_error("unexpected end of string while parsing JSON string");
      }
  
  
      sub white {
          while( defined $ch  ){
              if($ch eq '' or $ch =~ /\A[ \t\r\n]\z/){
                  next_chr();
              }
              elsif($relaxed and $ch eq '/'){
                  next_chr();
                  if(defined $ch and $ch eq '/'){
                      1 while(defined(next_chr()) and $ch ne "\n" and $ch ne "\r");
                  }
                  elsif(defined $ch and $ch eq '*'){
                      next_chr();
                      while(1){
                          if(defined $ch){
                              if($ch eq '*'){
                                  if(defined(next_chr()) and $ch eq '/'){
                                      next_chr();
                                      last;
                                  }
                              }
                              else{
                                  next_chr();
                              }
                          }
                          else{
                              decode_error("Unterminated comment");
                          }
                      }
                      next;
                  }
                  else{
                      $at--;
                      decode_error("malformed JSON string, neither array, object, number, string or atom");
                  }
              }
              else{
                  if ($relaxed and $ch eq '#') { # correctly?
                      pos($text) = $at;
                      $text =~ /\G([^\n]*(?:\r\n|\r|\n|$))/g;
                      $at = pos($text);
                      next_chr;
                      next;
                  }
  
                  last;
              }
          }
      }
  
  
      sub array {
          my $a  = $_[0] || []; # you can use this code to use another array ref object.
  
          decode_error('json text or perl structure exceeds maximum nesting level (max_depth set too low?)')
                                                      if (++$depth > $max_depth);
  
          next_chr();
          white();
  
          if(defined $ch and $ch eq ']'){
              --$depth;
              next_chr();
              return $a;
          }
          else {
              while(defined($ch)){
                  push @$a, value();
  
                  white();
  
                  if (!defined $ch) {
                      last;
                  }
  
                  if($ch eq ']'){
                      --$depth;
                      next_chr();
                      return $a;
                  }
  
                  if($ch ne ','){
                      last;
                  }
  
                  next_chr();
                  white();
  
                  if ($relaxed and $ch eq ']') {
                      --$depth;
                      next_chr();
                      return $a;
                  }
  
              }
          }
  
          $at-- if defined $ch and $ch ne '';
          decode_error(", or ] expected while parsing array");
      }
  
  
      sub object {
          my $o = $_[0] || {}; # you can use this code to use another hash ref object.
          my $k;
  
          decode_error('json text or perl structure exceeds maximum nesting level (max_depth set too low?)')
                                                  if (++$depth > $max_depth);
          next_chr();
          white();
  
          if(defined $ch and $ch eq '}'){
              --$depth;
              next_chr();
              if ($F_HOOK) {
                  return _json_object_hook($o);
              }
              return $o;
          }
          else {
              while (defined $ch) {
                  $k = ($allow_barekey and $ch ne '"' and $ch ne "'") ? bareKey() : string();
                  white();
  
                  if(!defined $ch or $ch ne ':'){
                      $at--;
                      decode_error("':' expected");
                  }
  
                  next_chr();
                  $o->{$k} = value();
                  white();
  
                  last if (!defined $ch);
  
                  if($ch eq '}'){
                      --$depth;
                      next_chr();
                      if ($F_HOOK) {
                          return _json_object_hook($o);
                      }
                      return $o;
                  }
  
                  if($ch ne ','){
                      last;
                  }
  
                  next_chr();
                  white();
  
                  if ($relaxed and $ch eq '}') {
                      --$depth;
                      next_chr();
                      if ($F_HOOK) {
                          return _json_object_hook($o);
                      }
                      return $o;
                  }
  
              }
  
          }
  
          $at-- if defined $ch and $ch ne '';
          decode_error(", or } expected while parsing object/hash");
      }
  
  
      sub bareKey { # doesn't strictly follow Standard ECMA-262 3rd Edition
          my $key;
          while($ch =~ /[^\x00-\x23\x25-\x2F\x3A-\x40\x5B-\x5E\x60\x7B-\x7F]/){
              $key .= $ch;
              next_chr();
          }
          return $key;
      }
  
  
      sub word {
          my $word =  substr($text,$at-1,4);
  
          if($word eq 'true'){
              $at += 3;
              next_chr;
              return $JSON::PP::true;
          }
          elsif($word eq 'null'){
              $at += 3;
              next_chr;
              return undef;
          }
          elsif($word eq 'fals'){
              $at += 3;
              if(substr($text,$at,1) eq 'e'){
                  $at++;
                  next_chr;
                  return $JSON::PP::false;
              }
          }
  
          $at--; # for decode_error report
  
          decode_error("'null' expected")  if ($word =~ /^n/);
          decode_error("'true' expected")  if ($word =~ /^t/);
          decode_error("'false' expected") if ($word =~ /^f/);
          decode_error("malformed JSON string, neither array, object, number, string or atom");
      }
  
  
      sub number {
          my $n    = '';
          my $v;
          my $is_dec;
          my $is_exp;
  
          if($ch eq '-'){
              $n = '-';
              next_chr;
              if (!defined $ch or $ch !~ /\d/) {
                  decode_error("malformed number (no digits after initial minus)");
              }
          }
  
          # According to RFC4627, hex or oct digits are invalid.
          if($ch eq '0'){
              my $peek = substr($text,$at,1);
              if($peek =~ /^[0-9a-dfA-DF]/){ # e may be valid (exponential)
                  decode_error("malformed number (leading zero must not be followed by another digit)");
              }
              $n .= $ch;
              next_chr;
          }
  
          while(defined $ch and $ch =~ /\d/){
              $n .= $ch;
              next_chr;
          }
  
          if(defined $ch and $ch eq '.'){
              $n .= '.';
              $is_dec = 1;
  
              next_chr;
              if (!defined $ch or $ch !~ /\d/) {
                  decode_error("malformed number (no digits after decimal point)");
              }
              else {
                  $n .= $ch;
              }
  
              while(defined(next_chr) and $ch =~ /\d/){
                  $n .= $ch;
              }
          }
  
          if(defined $ch and ($ch eq 'e' or $ch eq 'E')){
              $n .= $ch;
              $is_exp = 1;
              next_chr;
  
              if(defined($ch) and ($ch eq '+' or $ch eq '-')){
                  $n .= $ch;
                  next_chr;
                  if (!defined $ch or $ch =~ /\D/) {
                      decode_error("malformed number (no digits after exp sign)");
                  }
                  $n .= $ch;
              }
              elsif(defined($ch) and $ch =~ /\d/){
                  $n .= $ch;
              }
              else {
                  decode_error("malformed number (no digits after exp sign)");
              }
  
              while(defined(next_chr) and $ch =~ /\d/){
                  $n .= $ch;
              }
  
          }
  
          $v .= $n;
  
          if ($is_dec or $is_exp) {
              if ($allow_bignum) {
                  require Math::BigFloat;
                  return Math::BigFloat->new($v);
              }
          } else {
              if (length $v > $max_intsize) {
                  if ($allow_bignum) { # from Adam Sussman
                      require Math::BigInt;
                      return Math::BigInt->new($v);
                  }
                  else {
                      return "$v";
                  }
              }
          }
  
          return $is_dec ? $v/1.0 : 0+$v;
      }
  
  
      sub is_valid_utf8 {
  
          $utf8_len = $_[0] =~ /[\x00-\x7F]/  ? 1
                    : $_[0] =~ /[\xC2-\xDF]/  ? 2
                    : $_[0] =~ /[\xE0-\xEF]/  ? 3
                    : $_[0] =~ /[\xF0-\xF4]/  ? 4
                    : 0
                    ;
  
          return unless $utf8_len;
  
          my $is_valid_utf8 = substr($text, $at - 1, $utf8_len);
  
          return ( $is_valid_utf8 =~ /^(?:
               [\x00-\x7F]
              |[\xC2-\xDF][\x80-\xBF]
              |[\xE0][\xA0-\xBF][\x80-\xBF]
              |[\xE1-\xEC][\x80-\xBF][\x80-\xBF]
              |[\xED][\x80-\x9F][\x80-\xBF]
              |[\xEE-\xEF][\x80-\xBF][\x80-\xBF]
              |[\xF0][\x90-\xBF][\x80-\xBF][\x80-\xBF]
              |[\xF1-\xF3][\x80-\xBF][\x80-\xBF][\x80-\xBF]
              |[\xF4][\x80-\x8F][\x80-\xBF][\x80-\xBF]
          )$/x )  ? $is_valid_utf8 : '';
      }
  
  
      sub decode_error {
          my $error  = shift;
          my $no_rep = shift;
          my $str    = defined $text ? substr($text, $at) : '';
          my $mess   = '';
          my $type   = 'U*';
  
          if ( OLD_PERL ) {
              my $type   =  $] <  5.006           ? 'C*'
                          : utf8::is_utf8( $str ) ? 'U*' # 5.6
                          : 'C*'
                          ;
          }
  
          for my $c ( unpack( $type, $str ) ) { # emulate pv_uni_display() ?
              $mess .=  $c == 0x07 ? '\a'
                      : $c == 0x09 ? '\t'
                      : $c == 0x0a ? '\n'
                      : $c == 0x0d ? '\r'
                      : $c == 0x0c ? '\f'
                      : $c <  0x20 ? sprintf('\x{%x}', $c)
                      : $c == 0x5c ? '\\\\'
                      : $c <  0x80 ? chr($c)
                      : sprintf('\x{%x}', $c)
                      ;
              if ( length $mess >= 20 ) {
                  $mess .= '...';
                  last;
              }
          }
  
          unless ( length $mess ) {
              $mess = '(end of string)';
          }
  
          Carp::croak (
              $no_rep ? "$error" : "$error, at character offset $at (before \"$mess\")"
          );
  
      }
  
  
      sub _json_object_hook {
          my $o    = $_[0];
          my @ks = keys %{$o};
  
          if ( $cb_sk_object and @ks == 1 and exists $cb_sk_object->{ $ks[0] } and ref $cb_sk_object->{ $ks[0] } ) {
              my @val = $cb_sk_object->{ $ks[0] }->( $o->{$ks[0]} );
              if (@val == 1) {
                  return $val[0];
              }
          }
  
          my @val = $cb_object->($o) if ($cb_object);
          if (@val == 0 or @val > 1) {
              return $o;
          }
          else {
              return $val[0];
          }
      }
  
  
      sub PP_decode_box {
          {
              text    => $text,
              at      => $at,
              ch      => $ch,
              len     => $len,
              depth   => $depth,
              encoding      => $encoding,
              is_valid_utf8 => $is_valid_utf8,
          };
      }
  
  } # PARSE
  
  
  sub _decode_surrogates { # from perlunicode
      my $uni = 0x10000 + (hex($_[0]) - 0xD800) * 0x400 + (hex($_[1]) - 0xDC00);
      my $un  = pack('U*', $uni);
      utf8::encode( $un );
      return $un;
  }
  
  
  sub _decode_unicode {
      my $un = pack('U', hex shift);
      utf8::encode( $un );
      return $un;
  }
  
  #
  # Setup for various Perl versions (the code from JSON::PP58)
  #
  
  BEGIN {
  
      unless ( defined &utf8::is_utf8 ) {
         require Encode;
         *utf8::is_utf8 = *Encode::is_utf8;
      }
  
      if ( !OLD_PERL ) {
          *JSON::PP::JSON_PP_encode_ascii      = \&_encode_ascii;
          *JSON::PP::JSON_PP_encode_latin1     = \&_encode_latin1;
          *JSON::PP::JSON_PP_decode_surrogates = \&_decode_surrogates;
          *JSON::PP::JSON_PP_decode_unicode    = \&_decode_unicode;
  
          if ($] < 5.008003) { # join() in 5.8.0 - 5.8.2 is broken.
              package JSON::PP;
              require subs;
              subs->import('join');
              eval q|
                  sub join {
                      return '' if (@_ < 2);
                      my $j   = shift;
                      my $str = shift;
                      for (@_) { $str .= $j . $_; }
                      return $str;
                  }
              |;
          }
      }
  
  
      sub JSON::PP::incr_parse {
          local $Carp::CarpLevel = 1;
          ( $_[0]->{_incr_parser} ||= JSON::PP::IncrParser->new )->incr_parse( @_ );
      }
  
  
      sub JSON::PP::incr_skip {
          ( $_[0]->{_incr_parser} ||= JSON::PP::IncrParser->new )->incr_skip;
      }
  
  
      sub JSON::PP::incr_reset {
          ( $_[0]->{_incr_parser} ||= JSON::PP::IncrParser->new )->incr_reset;
      }
  
      eval q{
          sub JSON::PP::incr_text : lvalue {
              $_[0]->{_incr_parser} ||= JSON::PP::IncrParser->new;
  
              if ( $_[0]->{_incr_parser}->{incr_pos} ) {
                  Carp::croak("incr_text cannot be called when the incremental parser already started parsing");
              }
              $_[0]->{_incr_parser}->{incr_text};
          }
      } if ( $] >= 5.006 );
  
  } # Setup for various Perl versions (the code from JSON::PP58)
  
  
  ###############################
  # Utilities
  #
  
  BEGIN {
      eval 'require Scalar::Util';
      unless($@){
          *JSON::PP::blessed = \&Scalar::Util::blessed;
          *JSON::PP::reftype = \&Scalar::Util::reftype;
          *JSON::PP::refaddr = \&Scalar::Util::refaddr;
      }
      else{ # This code is from Scalar::Util.
          # warn $@;
          eval 'sub UNIVERSAL::a_sub_not_likely_to_be_here { ref($_[0]) }';
          *JSON::PP::blessed = sub {
              local($@, $SIG{__DIE__}, $SIG{__WARN__});
              ref($_[0]) ? eval { $_[0]->a_sub_not_likely_to_be_here } : undef;
          };
          require B;
          my %tmap = qw(
              B::NULL   SCALAR
              B::HV     HASH
              B::AV     ARRAY
              B::CV     CODE
              B::IO     IO
              B::GV     GLOB
              B::REGEXP REGEXP
          );
          *JSON::PP::reftype = sub {
              my $r = shift;
  
              return undef unless length(ref($r));
  
              my $t = ref(B::svref_2object($r));
  
              return
                  exists $tmap{$t} ? $tmap{$t}
                : length(ref($$r)) ? 'REF'
                :                    'SCALAR';
          };
          *JSON::PP::refaddr = sub {
            return undef unless length(ref($_[0]));
  
            my $addr;
            if(defined(my $pkg = blessed($_[0]))) {
              $addr .= bless $_[0], 'Scalar::Util::Fake';
              bless $_[0], $pkg;
            }
            else {
              $addr .= $_[0]
            }
  
            $addr =~ /0x(\w+)/;
            local $^W;
            #no warnings 'portable';
            hex($1);
          }
      }
  }
  
  
  # shamelessly copied and modified from JSON::XS code.
  
  $JSON::PP::true  = do { bless \(my $dummy = 1), "JSON::PP::Boolean" };
  $JSON::PP::false = do { bless \(my $dummy = 0), "JSON::PP::Boolean" };
  
  sub is_bool { blessed $_[0] and $_[0]->isa("JSON::PP::Boolean"); }
  
  sub true  { $JSON::PP::true  }
  sub false { $JSON::PP::false }
  sub null  { undef; }
  
  ###############################
  
  package JSON::PP::IncrParser;
  
  use strict;
  
  use constant INCR_M_WS   => 0; # initial whitespace skipping
  use constant INCR_M_STR  => 1; # inside string
  use constant INCR_M_BS   => 2; # inside backslash
  use constant INCR_M_JSON => 3; # outside anything, count nesting
  use constant INCR_M_C0   => 4;
  use constant INCR_M_C1   => 5;
  
  $JSON::PP::IncrParser::VERSION = '1.01';
  
  sub new {
      my ( $class ) = @_;
  
      bless {
          incr_nest    => 0,
          incr_text    => undef,
          incr_pos     => 0,
          incr_mode    => 0,
      }, $class;
  }
  
  
  sub incr_parse {
      my ( $self, $coder, $text ) = @_;
  
      $self->{incr_text} = '' unless ( defined $self->{incr_text} );
  
      if ( defined $text ) {
          if ( utf8::is_utf8( $text ) and !utf8::is_utf8( $self->{incr_text} ) ) {
              utf8::upgrade( $self->{incr_text} ) ;
              utf8::decode( $self->{incr_text} ) ;
          }
          $self->{incr_text} .= $text;
      }
  
      if ( defined wantarray ) {
          my $max_size = $coder->get_max_size;
          my $p = $self->{incr_pos};
          my @ret;
          {
              do {
                  unless ( $self->{incr_nest} <= 0 and $self->{incr_mode} == INCR_M_JSON ) {
                      $self->_incr_parse( $coder );
  
                      if ( $max_size and $self->{incr_pos} > $max_size ) {
                          Carp::croak("attempted decode of JSON text of $self->{incr_pos} bytes size, but max_size is set to $max_size");
                      }
                      unless ( $self->{incr_nest} <= 0 and $self->{incr_mode} == INCR_M_JSON ) {
                          # as an optimisation, do not accumulate white space in the incr buffer
                          if ( $self->{incr_mode} == INCR_M_WS and $self->{incr_pos} ) {
                              $self->{incr_pos} = 0;
                              $self->{incr_text} = '';
                          }
                          last;
                      }
                  }
  
                  my ($obj, $offset) = $coder->PP_decode_json( $self->{incr_text}, 0x00000001 );
                  push @ret, $obj;
                  use bytes;
                  $self->{incr_text} = substr( $self->{incr_text}, $offset || 0 );
                  $self->{incr_pos} = 0;
                  $self->{incr_nest} = 0;
                  $self->{incr_mode} = 0;
                  last unless wantarray;
              } while ( wantarray );
          }
  
          if ( wantarray ) {
              return @ret;
          }
          else { # in scalar context
              return $ret[0] ? $ret[0] : undef;
          }
      }
  }
  
  
  sub _incr_parse {
      my ($self, $coder) = @_;
      my $text = $self->{incr_text};
      my $len = length $text;
      my $p = $self->{incr_pos};
  
  INCR_PARSE:
      while ( $len > $p ) {
          my $s = substr( $text, $p, 1 );
          last INCR_PARSE unless defined $s;
          my $mode = $self->{incr_mode};
  
          if ( $mode == INCR_M_WS ) {
              while ( $len > $p ) {
                  $s = substr( $text, $p, 1 );
                  last INCR_PARSE unless defined $s;
                  if ( ord($s) > 0x20 ) {
                      if ( $s eq '#' ) {
                          $self->{incr_mode} = INCR_M_C0;
                          redo INCR_PARSE;
                      } else {
                          $self->{incr_mode} = INCR_M_JSON;
                          redo INCR_PARSE;
                      }
                  }
                  $p++;
              }
          } elsif ( $mode == INCR_M_BS ) {
              $p++;
              $self->{incr_mode} = INCR_M_STR;
              redo INCR_PARSE;
          } elsif ( $mode == INCR_M_C0 or $mode == INCR_M_C1 ) {
              while ( $len > $p ) {
                  $s = substr( $text, $p, 1 );
                  last INCR_PARSE unless defined $s;
                  if ( $s eq "\n" ) {
                      $self->{incr_mode} = $self->{incr_mode} == INCR_M_C0 ? INCR_M_WS : INCR_M_JSON;
                      last;
                  }
                  $p++;
              }
              next;
          } elsif ( $mode == INCR_M_STR ) {
              while ( $len > $p ) {
                  $s = substr( $text, $p, 1 );
                  last INCR_PARSE unless defined $s;
                  if ( $s eq '"' ) {
                      $p++;
                      $self->{incr_mode} = INCR_M_JSON;
  
                      last INCR_PARSE unless $self->{incr_nest};
                      redo INCR_PARSE;
                  }
                  elsif ( $s eq '\\' ) {
                      $p++;
                      if ( !defined substr($text, $p, 1) ) {
                          $self->{incr_mode} = INCR_M_BS;
                          last INCR_PARSE;
                      }
                  }
                  $p++;
              }
          } elsif ( $mode == INCR_M_JSON ) {
              while ( $len > $p ) {
                  $s = substr( $text, $p++, 1 );
                  if ( $s eq "\x00" ) {
                      $p--;
                      last INCR_PARSE;
                  } elsif ( $s eq "\x09" or $s eq "\x0a" or $s eq "\x0d" or $s eq "\x20" ) {
                      if ( !$self->{incr_nest} ) {
                          $p--; # do not eat the whitespace, let the next round do it
                          last INCR_PARSE;
                      }
                      next;
                  } elsif ( $s eq '"' ) {
                      $self->{incr_mode} = INCR_M_STR;
                      redo INCR_PARSE;
                  } elsif ( $s eq '[' or $s eq '{' ) {
                      if ( ++$self->{incr_nest} > $coder->get_max_depth ) {
                          Carp::croak('json text or perl structure exceeds maximum nesting level (max_depth set too low?)');
                      }
                      next;
                  } elsif ( $s eq ']' or $s eq '}' ) {
                      if ( --$self->{incr_nest} <= 0 ) {
                          last INCR_PARSE;
                      }
                  } elsif ( $s eq '#' ) {
                      $self->{incr_mode} = INCR_M_C1;
                      redo INCR_PARSE;
                  }
              }
          }
      }
  
      $self->{incr_pos} = $p;
      $self->{incr_parsing} = $p ? 1 : 0; # for backward compatibility
  }
  
  
  sub incr_text {
      if ( $_[0]->{incr_pos} ) {
          Carp::croak("incr_text cannot be called when the incremental parser already started parsing");
      }
      $_[0]->{incr_text};
  }
  
  
  sub incr_skip {
      my $self  = shift;
      $self->{incr_text} = substr( $self->{incr_text}, $self->{incr_pos} );
      $self->{incr_pos}     = 0;
      $self->{incr_mode}    = 0;
      $self->{incr_nest}    = 0;
  }
  
  
  sub incr_reset {
      my $self = shift;
      $self->{incr_text}    = undef;
      $self->{incr_pos}     = 0;
      $self->{incr_mode}    = 0;
      $self->{incr_nest}    = 0;
  }
  
  ###############################
  
  
  1;
  __END__
  =pod
  
  =head1 NAME
  
  JSON::PP - JSON::XS compatible pure-Perl module.
  
  =head1 SYNOPSIS
  
   use JSON::PP;
  
   # exported functions, they croak on error
   # and expect/generate UTF-8
  
   $utf8_encoded_json_text = encode_json $perl_hash_or_arrayref;
   $perl_hash_or_arrayref  = decode_json $utf8_encoded_json_text;
  
   # OO-interface
  
   $json = JSON::PP->new->ascii->pretty->allow_nonref;
   
   $pretty_printed_json_text = $json->encode( $perl_scalar );
   $perl_scalar = $json->decode( $json_text );
   
   # Note that JSON version 2.0 and above will automatically use
   # JSON::XS or JSON::PP, so you should be able to just:
   
   use JSON;
  
  
  =head1 VERSION
  
      2.97001
  
  =head1 DESCRIPTION
  
  JSON::PP is a pure perl JSON decoder/encoder (as of RFC4627, which
  we know is obsolete but we still stick to; see below for an option
  to support part of RFC7159), and (almost) compatible to much
  faster L<JSON::XS> written by Marc Lehmann in C. JSON::PP works as
  a fallback module when you use L<JSON> module without having
  installed JSON::XS.
  
  Because of this fallback feature of JSON.pm, JSON::PP tries not to
  be more JavaScript-friendly than JSON::XS (i.e. not to escape extra
  characters such as U+2028 and U+2029 nor support RFC7159/ECMA-404),
  in order for you not to lose such JavaScript-friendliness silently
  when you use JSON.pm and install JSON::XS for speed or by accident.
  If you need JavaScript-friendly RFC7159-compliant pure perl module,
  try L<JSON::Tiny>, which is derived from L<Mojolicious> web
  framework and is also smaller and faster than JSON::PP.
  
  JSON::PP has been in the Perl core since Perl 5.14, mainly for
  CPAN toolchain modules to parse META.json.
  
  =head1 FUNCTIONAL INTERFACE
  
  This section is taken from JSON::XS almost verbatim. C<encode_json>
  and C<decode_json> are exported by default.
  
  =head2 encode_json
  
      $json_text = encode_json $perl_scalar
  
  Converts the given Perl data structure to a UTF-8 encoded, binary string
  (that is, the string contains octets only). Croaks on error.
  
  This function call is functionally identical to:
  
      $json_text = JSON::PP->new->utf8->encode($perl_scalar)
  
  Except being faster.
  
  =head2 decode_json
  
      $perl_scalar = decode_json $json_text
  
  The opposite of C<encode_json>: expects an UTF-8 (binary) string and tries
  to parse that as an UTF-8 encoded JSON text, returning the resulting
  reference. Croaks on error.
  
  This function call is functionally identical to:
  
      $perl_scalar = JSON::PP->new->utf8->decode($json_text)
  
  Except being faster.
  
  =head2 JSON::PP::is_bool
  
      $is_boolean = JSON::PP::is_bool($scalar)
  
  Returns true if the passed scalar represents either JSON::PP::true or
  JSON::PP::false, two constants that act like C<1> and C<0> respectively
  and are also used to represent JSON C<true> and C<false> in Perl strings.
  
  See L<MAPPING>, below, for more information on how JSON values are mapped to
  Perl.
  
  =head1 OBJECT-ORIENTED INTERFACE
  
  This section is also taken from JSON::XS.
  
  The object oriented interface lets you configure your own encoding or
  decoding style, within the limits of supported formats.
  
  =head2 new
  
      $json = JSON::PP->new
  
  Creates a new JSON::PP object that can be used to de/encode JSON
  strings. All boolean flags described below are by default I<disabled>.
  
  The mutators for flags all return the JSON::PP object again and thus calls can
  be chained:
  
     my $json = JSON::PP->new->utf8->space_after->encode({a => [1,2]})
     => {"a": [1, 2]}
  
  =head2 ascii
  
      $json = $json->ascii([$enable])
      
      $enabled = $json->get_ascii
  
  If C<$enable> is true (or missing), then the C<encode> method will not
  generate characters outside the code range C<0..127> (which is ASCII). Any
  Unicode characters outside that range will be escaped using either a
  single \uXXXX (BMP characters) or a double \uHHHH\uLLLLL escape sequence,
  as per RFC4627. The resulting encoded JSON text can be treated as a native
  Unicode string, an ascii-encoded, latin1-encoded or UTF-8 encoded string,
  or any other superset of ASCII.
  
  If C<$enable> is false, then the C<encode> method will not escape Unicode
  characters unless required by the JSON syntax or other flags. This results
  in a faster and more compact format.
  
  See also the section I<ENCODING/CODESET FLAG NOTES> later in this document.
  
  The main use for this flag is to produce JSON texts that can be
  transmitted over a 7-bit channel, as the encoded JSON texts will not
  contain any 8 bit characters.
  
    JSON::PP->new->ascii(1)->encode([chr 0x10401])
    => ["\ud801\udc01"]
  
  =head2 latin1
  
      $json = $json->latin1([$enable])
      
      $enabled = $json->get_latin1
  
  If C<$enable> is true (or missing), then the C<encode> method will encode
  the resulting JSON text as latin1 (or iso-8859-1), escaping any characters
  outside the code range C<0..255>. The resulting string can be treated as a
  latin1-encoded JSON text or a native Unicode string. The C<decode> method
  will not be affected in any way by this flag, as C<decode> by default
  expects Unicode, which is a strict superset of latin1.
  
  If C<$enable> is false, then the C<encode> method will not escape Unicode
  characters unless required by the JSON syntax or other flags.
  
  See also the section I<ENCODING/CODESET FLAG NOTES> later in this document.
  
  The main use for this flag is efficiently encoding binary data as JSON
  text, as most octets will not be escaped, resulting in a smaller encoded
  size. The disadvantage is that the resulting JSON text is encoded
  in latin1 (and must correctly be treated as such when storing and
  transferring), a rare encoding for JSON. It is therefore most useful when
  you want to store data structures known to contain binary data efficiently
  in files or databases, not when talking to other JSON encoders/decoders.
  
    JSON::PP->new->latin1->encode (["\x{89}\x{abc}"]
    => ["\x{89}\\u0abc"]    # (perl syntax, U+abc escaped, U+89 not)
  
  =head2 utf8
  
      $json = $json->utf8([$enable])
      
      $enabled = $json->get_utf8
  
  If C<$enable> is true (or missing), then the C<encode> method will encode
  the JSON result into UTF-8, as required by many protocols, while the
  C<decode> method expects to be handled an UTF-8-encoded string.  Please
  note that UTF-8-encoded strings do not contain any characters outside the
  range C<0..255>, they are thus useful for bytewise/binary I/O. In future
  versions, enabling this option might enable autodetection of the UTF-16
  and UTF-32 encoding families, as described in RFC4627.
  
  If C<$enable> is false, then the C<encode> method will return the JSON
  string as a (non-encoded) Unicode string, while C<decode> expects thus a
  Unicode string.  Any decoding or encoding (e.g. to UTF-8 or UTF-16) needs
  to be done yourself, e.g. using the Encode module.
  
  See also the section I<ENCODING/CODESET FLAG NOTES> later in this document.
  
  Example, output UTF-16BE-encoded JSON:
  
    use Encode;
    $jsontext = encode "UTF-16BE", JSON::PP->new->encode ($object);
  
  Example, decode UTF-32LE-encoded JSON:
  
    use Encode;
    $object = JSON::PP->new->decode (decode "UTF-32LE", $jsontext);
  
  =head2 pretty
  
      $json = $json->pretty([$enable])
  
  This enables (or disables) all of the C<indent>, C<space_before> and
  C<space_after> (and in the future possibly more) flags in one call to
  generate the most readable (or most compact) form possible.
  
  =head2 indent
  
      $json = $json->indent([$enable])
      
      $enabled = $json->get_indent
  
  If C<$enable> is true (or missing), then the C<encode> method will use a multiline
  format as output, putting every array member or object/hash key-value pair
  into its own line, indenting them properly.
  
  If C<$enable> is false, no newlines or indenting will be produced, and the
  resulting JSON text is guaranteed not to contain any C<newlines>.
  
  This setting has no effect when decoding JSON texts.
  
  The default indent space length is three.
  You can use C<indent_length> to change the length.
  
  =head2 space_before
  
      $json = $json->space_before([$enable])
      
      $enabled = $json->get_space_before
  
  If C<$enable> is true (or missing), then the C<encode> method will add an extra
  optional space before the C<:> separating keys from values in JSON objects.
  
  If C<$enable> is false, then the C<encode> method will not add any extra
  space at those places.
  
  This setting has no effect when decoding JSON texts. You will also
  most likely combine this setting with C<space_after>.
  
  Example, space_before enabled, space_after and indent disabled:
  
     {"key" :"value"}
  
  =head2 space_after
  
      $json = $json->space_after([$enable])
      
      $enabled = $json->get_space_after
  
  If C<$enable> is true (or missing), then the C<encode> method will add an extra
  optional space after the C<:> separating keys from values in JSON objects
  and extra whitespace after the C<,> separating key-value pairs and array
  members.
  
  If C<$enable> is false, then the C<encode> method will not add any extra
  space at those places.
  
  This setting has no effect when decoding JSON texts.
  
  Example, space_before and indent disabled, space_after enabled:
  
     {"key": "value"}
  
  =head2 relaxed
  
      $json = $json->relaxed([$enable])
      
      $enabled = $json->get_relaxed
  
  If C<$enable> is true (or missing), then C<decode> will accept some
  extensions to normal JSON syntax (see below). C<encode> will not be
  affected in anyway. I<Be aware that this option makes you accept invalid
  JSON texts as if they were valid!>. I suggest only to use this option to
  parse application-specific files written by humans (configuration files,
  resource files etc.)
  
  If C<$enable> is false (the default), then C<decode> will only accept
  valid JSON texts.
  
  Currently accepted extensions are:
  
  =over 4
  
  =item * list items can have an end-comma
  
  JSON I<separates> array elements and key-value pairs with commas. This
  can be annoying if you write JSON texts manually and want to be able to
  quickly append elements, so this extension accepts comma at the end of
  such items not just between them:
  
     [
        1,
        2, <- this comma not normally allowed
     ]
     {
        "k1": "v1",
        "k2": "v2", <- this comma not normally allowed
     }
  
  =item * shell-style '#'-comments
  
  Whenever JSON allows whitespace, shell-style comments are additionally
  allowed. They are terminated by the first carriage-return or line-feed
  character, after which more white-space and comments are allowed.
  
    [
       1, # this comment not allowed in JSON
          # neither this one...
    ]
  
  =item * C-style multiple-line '/* */'-comments (JSON::PP only)
  
  Whenever JSON allows whitespace, C-style multiple-line comments are additionally
  allowed. Everything between C</*> and C<*/> is a comment, after which
  more white-space and comments are allowed.
  
    [
       1, /* this comment not allowed in JSON */
          /* neither this one... */
    ]
  
  =item * C++-style one-line '//'-comments (JSON::PP only)
  
  Whenever JSON allows whitespace, C++-style one-line comments are additionally
  allowed. They are terminated by the first carriage-return or line-feed
  character, after which more white-space and comments are allowed.
  
    [
       1, // this comment not allowed in JSON
          // neither this one...
    ]
  
  =back
  
  =head2 canonical
  
      $json = $json->canonical([$enable])
      
      $enabled = $json->get_canonical
  
  If C<$enable> is true (or missing), then the C<encode> method will output JSON objects
  by sorting their keys. This is adding a comparatively high overhead.
  
  If C<$enable> is false, then the C<encode> method will output key-value
  pairs in the order Perl stores them (which will likely change between runs
  of the same script, and can change even within the same run from 5.18
  onwards).
  
  This option is useful if you want the same data structure to be encoded as
  the same JSON text (given the same overall settings). If it is disabled,
  the same hash might be encoded differently even if contains the same data,
  as key-value pairs have no inherent ordering in Perl.
  
  This setting has no effect when decoding JSON texts.
  
  This setting has currently no effect on tied hashes.
  
  =head2 allow_nonref
  
      $json = $json->allow_nonref([$enable])
      
      $enabled = $json->get_allow_nonref
  
  If C<$enable> is true (or missing), then the C<encode> method can convert a
  non-reference into its corresponding string, number or null JSON value,
  which is an extension to RFC4627. Likewise, C<decode> will accept those JSON
  values instead of croaking.
  
  If C<$enable> is false, then the C<encode> method will croak if it isn't
  passed an arrayref or hashref, as JSON texts must either be an object
  or array. Likewise, C<decode> will croak if given something that is not a
  JSON object or array.
  
  Example, encode a Perl scalar as JSON value with enabled C<allow_nonref>,
  resulting in an invalid JSON text:
  
     JSON::PP->new->allow_nonref->encode ("Hello, World!")
     => "Hello, World!"
  
  =head2 allow_unknown
  
      $json = $json->allow_unknown ([$enable])
      
      $enabled = $json->get_allow_unknown
  
  If C<$enable> is true (or missing), then C<encode> will I<not> throw an
  exception when it encounters values it cannot represent in JSON (for
  example, filehandles) but instead will encode a JSON C<null> value. Note
  that blessed objects are not included here and are handled separately by
  c<allow_blessed>.
  
  If C<$enable> is false (the default), then C<encode> will throw an
  exception when it encounters anything it cannot encode as JSON.
  
  This option does not affect C<decode> in any way, and it is recommended to
  leave it off unless you know your communications partner.
  
  =head2 allow_blessed
  
      $json = $json->allow_blessed([$enable])
      
      $enabled = $json->get_allow_blessed
  
  See L<OBJECT SERIALISATION> for details.
  
  If C<$enable> is true (or missing), then the C<encode> method will not
  barf when it encounters a blessed reference that it cannot convert
  otherwise. Instead, a JSON C<null> value is encoded instead of the object.
  
  If C<$enable> is false (the default), then C<encode> will throw an
  exception when it encounters a blessed object that it cannot convert
  otherwise.
  
  This setting has no effect on C<decode>.
  
  =head2 convert_blessed
  
      $json = $json->convert_blessed([$enable])
      
      $enabled = $json->get_convert_blessed
  
  See L<OBJECT SERIALISATION> for details.
  
  If C<$enable> is true (or missing), then C<encode>, upon encountering a
  blessed object, will check for the availability of the C<TO_JSON> method
  on the object's class. If found, it will be called in scalar context and
  the resulting scalar will be encoded instead of the object.
  
  The C<TO_JSON> method may safely call die if it wants. If C<TO_JSON>
  returns other blessed objects, those will be handled in the same
  way. C<TO_JSON> must take care of not causing an endless recursion cycle
  (== crash) in this case. The name of C<TO_JSON> was chosen because other
  methods called by the Perl core (== not by the user of the object) are
  usually in upper case letters and to avoid collisions with any C<to_json>
  function or method.
  
  If C<$enable> is false (the default), then C<encode> will not consider
  this type of conversion.
  
  This setting has no effect on C<decode>.
  
  =head2 filter_json_object
  
      $json = $json->filter_json_object([$coderef])
  
  When C<$coderef> is specified, it will be called from C<decode> each
  time it decodes a JSON object. The only argument is a reference to the
  newly-created hash. If the code references returns a single scalar (which
  need not be a reference), this value (i.e. a copy of that scalar to avoid
  aliasing) is inserted into the deserialised data structure. If it returns
  an empty list (NOTE: I<not> C<undef>, which is a valid scalar), the
  original deserialised hash will be inserted. This setting can slow down
  decoding considerably.
  
  When C<$coderef> is omitted or undefined, any existing callback will
  be removed and C<decode> will not change the deserialised hash in any
  way.
  
  Example, convert all JSON objects into the integer 5:
  
     my $js = JSON::PP->new->filter_json_object (sub { 5 });
     # returns [5]
     $js->decode ('[{}]'); # the given subroutine takes a hash reference.
     # throw an exception because allow_nonref is not enabled
     # so a lone 5 is not allowed.
     $js->decode ('{"a":1, "b":2}');
  
  =head2 filter_json_single_key_object
  
      $json = $json->filter_json_single_key_object($key [=> $coderef])
  
  Works remotely similar to C<filter_json_object>, but is only called for
  JSON objects having a single key named C<$key>.
  
  This C<$coderef> is called before the one specified via
  C<filter_json_object>, if any. It gets passed the single value in the JSON
  object. If it returns a single value, it will be inserted into the data
  structure. If it returns nothing (not even C<undef> but the empty list),
  the callback from C<filter_json_object> will be called next, as if no
  single-key callback were specified.
  
  If C<$coderef> is omitted or undefined, the corresponding callback will be
  disabled. There can only ever be one callback for a given key.
  
  As this callback gets called less often then the C<filter_json_object>
  one, decoding speed will not usually suffer as much. Therefore, single-key
  objects make excellent targets to serialise Perl objects into, especially
  as single-key JSON objects are as close to the type-tagged value concept
  as JSON gets (it's basically an ID/VALUE tuple). Of course, JSON does not
  support this in any way, so you need to make sure your data never looks
  like a serialised Perl hash.
  
  Typical names for the single object key are C<__class_whatever__>, or
  C<$__dollars_are_rarely_used__$> or C<}ugly_brace_placement>, or even
  things like C<__class_md5sum(classname)__>, to reduce the risk of clashing
  with real hashes.
  
  Example, decode JSON objects of the form C<< { "__widget__" => <id> } >>
  into the corresponding C<< $WIDGET{<id>} >> object:
  
     # return whatever is in $WIDGET{5}:
     JSON::PP
        ->new
        ->filter_json_single_key_object (__widget__ => sub {
              $WIDGET{ $_[0] }
           })
        ->decode ('{"__widget__": 5')
  
     # this can be used with a TO_JSON method in some "widget" class
     # for serialisation to json:
     sub WidgetBase::TO_JSON {
        my ($self) = @_;
  
        unless ($self->{id}) {
           $self->{id} = ..get..some..id..;
           $WIDGET{$self->{id}} = $self;
        }
  
        { __widget__ => $self->{id} }
     }
  
  =head2 shrink
  
      $json = $json->shrink([$enable])
      
      $enabled = $json->get_shrink
  
  If C<$enable> is true (or missing), the string returned by C<encode> will
  be shrunk (i.e. downgraded if possible).
  
  The actual definition of what shrink does might change in future versions,
  but it will always try to save space at the expense of time.
  
  If C<$enable> is false, then JSON::PP does nothing.
  
  =head2 max_depth
  
      $json = $json->max_depth([$maximum_nesting_depth])
      
      $max_depth = $json->get_max_depth
  
  Sets the maximum nesting level (default C<512>) accepted while encoding
  or decoding. If a higher nesting level is detected in JSON text or a Perl
  data structure, then the encoder and decoder will stop and croak at that
  point.
  
  Nesting level is defined by number of hash- or arrayrefs that the encoder
  needs to traverse to reach a given point or the number of C<{> or C<[>
  characters without their matching closing parenthesis crossed to reach a
  given character in a string.
  
  Setting the maximum depth to one disallows any nesting, so that ensures
  that the object is only a single hash/object or array.
  
  If no argument is given, the highest possible setting will be used, which
  is rarely useful.
  
  See L<JSON::XS/SECURITY CONSIDERATIONS> for more info on why this is useful.
  
  =head2 max_size
  
      $json = $json->max_size([$maximum_string_size])
      
      $max_size = $json->get_max_size
  
  Set the maximum length a JSON text may have (in bytes) where decoding is
  being attempted. The default is C<0>, meaning no limit. When C<decode>
  is called on a string that is longer then this many bytes, it will not
  attempt to decode the string but throw an exception. This setting has no
  effect on C<encode> (yet).
  
  If no argument is given, the limit check will be deactivated (same as when
  C<0> is specified).
  
  See L<JSON::XS/SECURITY CONSIDERATIONS> for more info on why this is useful.
  
  =head2 encode
  
      $json_text = $json->encode($perl_scalar)
  
  Converts the given Perl value or data structure to its JSON
  representation. Croaks on error.
  
  =head2 decode
  
      $perl_scalar = $json->decode($json_text)
  
  The opposite of C<encode>: expects a JSON text and tries to parse it,
  returning the resulting simple scalar or reference. Croaks on error.
  
  =head2 decode_prefix
  
      ($perl_scalar, $characters) = $json->decode_prefix($json_text)
  
  This works like the C<decode> method, but instead of raising an exception
  when there is trailing garbage after the first JSON object, it will
  silently stop parsing there and return the number of characters consumed
  so far.
  
  This is useful if your JSON texts are not delimited by an outer protocol
  and you need to know where the JSON text ends.
  
     JSON::PP->new->decode_prefix ("[1] the tail")
     => ([1], 3)
  
  =head1 FLAGS FOR JSON::PP ONLY
  
  The following flags and properties are for JSON::PP only. If you use
  any of these, you can't make your application run faster by replacing
  JSON::PP with JSON::XS. If you need these and also speed boost,
  try L<Cpanel::JSON::XS>, a fork of JSON::XS by Reini Urban, which
  supports some of these.
  
  =head2 allow_singlequote
  
      $json = $json->allow_singlequote([$enable])
      $enabled = $json->get_allow_singlequote
  
  If C<$enable> is true (or missing), then C<decode> will accept
  invalid JSON texts that contain strings that begin and end with
  single quotation marks. C<encode> will not be affected in anyway.
  I<Be aware that this option makes you accept invalid JSON texts
  as if they were valid!>. I suggest only to use this option to
  parse application-specific files written by humans (configuration
  files, resource files etc.)
  
  If C<$enable> is false (the default), then C<decode> will only accept
  valid JSON texts.
  
      $json->allow_singlequote->decode(qq|{"foo":'bar'}|);
      $json->allow_singlequote->decode(qq|{'foo':"bar"}|);
      $json->allow_singlequote->decode(qq|{'foo':'bar'}|);
  
  =head2 allow_barekey
  
      $json = $json->allow_barekey([$enable])
      $enabled = $json->get_allow_barekey
  
  If C<$enable> is true (or missing), then C<decode> will accept
  invalid JSON texts that contain JSON objects whose names don't
  begin and end with quotation marks. C<encode> will not be affected
  in anyway. I<Be aware that this option makes you accept invalid JSON
  texts as if they were valid!>. I suggest only to use this option to
  parse application-specific files written by humans (configuration
  files, resource files etc.)
  
  If C<$enable> is false (the default), then C<decode> will only accept
  valid JSON texts.
  
      $json->allow_barekey->decode(qq|{foo:"bar"}|);
  
  =head2 allow_bignum
  
      $json = $json->allow_bignum([$enable])
      $enabled = $json->get_allow_bignum
  
  If C<$enable> is true (or missing), then C<decode> will convert
  big integers Perl cannot handle as integer into L<Math::BigInt>
  objects and convert floating numbers into L<Math::BigFloat>
  objects. C<encode> will convert C<Math::BigInt> and C<Math::BigFloat>
  objects into JSON numbers.
  
     $json->allow_nonref->allow_bignum;
     $bigfloat = $json->decode('2.000000000000000000000000001');
     print $json->encode($bigfloat);
     # => 2.000000000000000000000000001
  
  See also L<MAPPING>.
  
  =head2 loose
  
      $json = $json->loose([$enable])
      $enabled = $json->get_loose
  
  If C<$enable> is true (or missing), then C<decode> will accept
  invalid JSON texts that contain unescaped [\x00-\x1f\x22\x5c]
  characters. C<encode> will not be affected in anyway.
  I<Be aware that this option makes you accept invalid JSON texts
  as if they were valid!>. I suggest only to use this option to
  parse application-specific files written by humans (configuration
  files, resource files etc.)
  
  If C<$enable> is false (the default), then C<decode> will only accept
  valid JSON texts.
  
      $json->loose->decode(qq|["abc
                                     def"]|);
  
  =head2 escape_slash
  
      $json = $json->escape_slash([$enable])
      $enabled = $json->get_escape_slash
  
  If C<$enable> is true (or missing), then C<encode> will explicitly
  escape I<slash> (solidus; C<U+002F>) characters to reduce the risk of
  XSS (cross site scripting) that may be caused by C<< </script> >>
  in a JSON text, with the cost of bloating the size of JSON texts.
  
  This option may be useful when you embed JSON in HTML, but embedding
  arbitrary JSON in HTML (by some HTML template toolkit or by string
  interpolation) is risky in general. You must escape necessary
  characters in correct order, depending on the context.
  
  C<decode> will not be affected in anyway.
  
  =head2 indent_length
  
      $json = $json->indent_length($number_of_spaces)
      $length = $json->get_indent_length
  
  This option is only useful when you also enable C<indent> or C<pretty>.
  
  JSON::XS indents with three spaces when you C<encode> (if requested
  by C<indent> or C<pretty>), and the number cannot be changed.
  JSON::PP allows you to change/get the number of indent spaces with these
  mutator/accessor. The default number of spaces is three (the same as
  JSON::XS), and the acceptable range is from C<0> (no indentation;
  it'd be better to disable indentation by C<indent(0)>) to C<15>.
  
  =head2 sort_by
  
      $json = $json->sort_by($code_ref)
      $json = $json->sort_by($subroutine_name)
  
  If you just want to sort keys (names) in JSON objects when you
  C<encode>, enable C<canonical> option (see above) that allows you to
  sort object keys alphabetically.
  
  If you do need to sort non-alphabetically for whatever reasons,
  you can give a code reference (or a subroutine name) to C<sort_by>,
  then the argument will be passed to Perl's C<sort> built-in function.
  
  As the sorting is done in the JSON::PP scope, you usually need to
  prepend C<JSON::PP::> to the subroutine name, and the special variables
  C<$a> and C<$b> used in the subrontine used by C<sort> function.
  
  Example:
  
     my %ORDER = (id => 1, class => 2, name => 3);
     $json->sort_by(sub {
         ($ORDER{$JSON::PP::a} // 999) <=> ($ORDER{$JSON::PP::b} // 999)
         or $JSON::PP::a cmp $JSON::PP::b
     });
     print $json->encode([
         {name => 'CPAN', id => 1, href => 'http://cpan.org'}
     ]);
     # [{"id":1,"name":"CPAN","href":"http://cpan.org"}]
  
  Note that C<sort_by> affects all the plain hashes in the data structure.
  If you need finer control, C<tie> necessary hashes with a module that
  implements ordered hash (such as L<Hash::Ordered> and L<Tie::IxHash>).
  C<canonical> and C<sort_by> don't affect the key order in C<tie>d
  hashes.
  
     use Hash::Ordered;
     tie my %hash, 'Hash::Ordered',
         (name => 'CPAN', id => 1, href => 'http://cpan.org');
     print $json->encode([\%hash]);
     # [{"name":"CPAN","id":1,"href":"http://cpan.org"}] # order is kept
  
  =head1 INCREMENTAL PARSING
  
  This section is also taken from JSON::XS.
  
  In some cases, there is the need for incremental parsing of JSON
  texts. While this module always has to keep both JSON text and resulting
  Perl data structure in memory at one time, it does allow you to parse a
  JSON stream incrementally. It does so by accumulating text until it has
  a full JSON object, which it then can decode. This process is similar to
  using C<decode_prefix> to see if a full JSON object is available, but
  is much more efficient (and can be implemented with a minimum of method
  calls).
  
  JSON::PP will only attempt to parse the JSON text once it is sure it
  has enough text to get a decisive result, using a very simple but
  truly incremental parser. This means that it sometimes won't stop as
  early as the full parser, for example, it doesn't detect mismatched
  parentheses. The only thing it guarantees is that it starts decoding as
  soon as a syntactically valid JSON text has been seen. This means you need
  to set resource limits (e.g. C<max_size>) to ensure the parser will stop
  parsing in the presence if syntax errors.
  
  The following methods implement this incremental parser.
  
  =head2 incr_parse
  
      $json->incr_parse( [$string] ) # void context
      
      $obj_or_undef = $json->incr_parse( [$string] ) # scalar context
      
      @obj_or_empty = $json->incr_parse( [$string] ) # list context
  
  This is the central parsing function. It can both append new text and
  extract objects from the stream accumulated so far (both of these
  functions are optional).
  
  If C<$string> is given, then this string is appended to the already
  existing JSON fragment stored in the C<$json> object.
  
  After that, if the function is called in void context, it will simply
  return without doing anything further. This can be used to add more text
  in as many chunks as you want.
  
  If the method is called in scalar context, then it will try to extract
  exactly I<one> JSON object. If that is successful, it will return this
  object, otherwise it will return C<undef>. If there is a parse error,
  this method will croak just as C<decode> would do (one can then use
  C<incr_skip> to skip the erroneous part). This is the most common way of
  using the method.
  
  And finally, in list context, it will try to extract as many objects
  from the stream as it can find and return them, or the empty list
  otherwise. For this to work, there must be no separators (other than
  whitespace) between the JSON objects or arrays, instead they must be
  concatenated back-to-back. If an error occurs, an exception will be
  raised as in the scalar context case. Note that in this case, any
  previously-parsed JSON texts will be lost.
  
  Example: Parse some JSON arrays/objects in a given string and return
  them.
  
      my @objs = JSON::PP->new->incr_parse ("[5][7][1,2]");
  
  =head2 incr_text
  
      $lvalue_string = $json->incr_text
  
  This method returns the currently stored JSON fragment as an lvalue, that
  is, you can manipulate it. This I<only> works when a preceding call to
  C<incr_parse> in I<scalar context> successfully returned an object. Under
  all other circumstances you must not call this function (I mean it.
  although in simple tests it might actually work, it I<will> fail under
  real world conditions). As a special exception, you can also call this
  method before having parsed anything.
  
  That means you can only use this function to look at or manipulate text
  before or after complete JSON objects, not while the parser is in the
  middle of parsing a JSON object.
  
  This function is useful in two cases: a) finding the trailing text after a
  JSON object or b) parsing multiple JSON objects separated by non-JSON text
  (such as commas).
  
  =head2 incr_skip
  
      $json->incr_skip
  
  This will reset the state of the incremental parser and will remove
  the parsed text from the input buffer so far. This is useful after
  C<incr_parse> died, in which case the input buffer and incremental parser
  state is left unchanged, to skip the text parsed so far and to reset the
  parse state.
  
  The difference to C<incr_reset> is that only text until the parse error
  occurred is removed.
  
  =head2 incr_reset
  
      $json->incr_reset
  
  This completely resets the incremental parser, that is, after this call,
  it will be as if the parser had never parsed anything.
  
  This is useful if you want to repeatedly parse JSON objects and want to
  ignore any trailing data, which means you have to reset the parser after
  each successful decode.
  
  =head1 MAPPING
  
  Most of this section is also taken from JSON::XS.
  
  This section describes how JSON::PP maps Perl values to JSON values and
  vice versa. These mappings are designed to "do the right thing" in most
  circumstances automatically, preserving round-tripping characteristics
  (what you put in comes out as something equivalent).
  
  For the more enlightened: note that in the following descriptions,
  lowercase I<perl> refers to the Perl interpreter, while uppercase I<Perl>
  refers to the abstract Perl language itself.
  
  =head2 JSON -> PERL
  
  =over 4
  
  =item object
  
  A JSON object becomes a reference to a hash in Perl. No ordering of object
  keys is preserved (JSON does not preserve object key ordering itself).
  
  =item array
  
  A JSON array becomes a reference to an array in Perl.
  
  =item string
  
  A JSON string becomes a string scalar in Perl - Unicode codepoints in JSON
  are represented by the same codepoints in the Perl string, so no manual
  decoding is necessary.
  
  =item number
  
  A JSON number becomes either an integer, numeric (floating point) or
  string scalar in perl, depending on its range and any fractional parts. On
  the Perl level, there is no difference between those as Perl handles all
  the conversion details, but an integer may take slightly less memory and
  might represent more values exactly than floating point numbers.
  
  If the number consists of digits only, JSON::PP will try to represent
  it as an integer value. If that fails, it will try to represent it as
  a numeric (floating point) value if that is possible without loss of
  precision. Otherwise it will preserve the number as a string value (in
  which case you lose roundtripping ability, as the JSON number will be
  re-encoded to a JSON string).
  
  Numbers containing a fractional or exponential part will always be
  represented as numeric (floating point) values, possibly at a loss of
  precision (in which case you might lose perfect roundtripping ability, but
  the JSON number will still be re-encoded as a JSON number).
  
  Note that precision is not accuracy - binary floating point values cannot
  represent most decimal fractions exactly, and when converting from and to
  floating point, JSON::PP only guarantees precision up to but not including
  the least significant bit.
  
  When C<allow_bignum> is enabled, big integer values and any numeric
  values will be converted into L<Math::BigInt> and L<Math::BigFloat>
  objects respectively, without becoming string scalars or losing
  precision.
  
  =item true, false
  
  These JSON atoms become C<JSON::PP::true> and C<JSON::PP::false>,
  respectively. They are overloaded to act almost exactly like the numbers
  C<1> and C<0>. You can check whether a scalar is a JSON boolean by using
  the C<JSON::PP::is_bool> function.
  
  =item null
  
  A JSON null atom becomes C<undef> in Perl.
  
  =item shell-style comments (C<< # I<text> >>)
  
  As a nonstandard extension to the JSON syntax that is enabled by the
  C<relaxed> setting, shell-style comments are allowed. They can start
  anywhere outside strings and go till the end of the line.
  
  =back
  
  
  =head2 PERL -> JSON
  
  The mapping from Perl to JSON is slightly more difficult, as Perl is a
  truly typeless language, so we can only guess which JSON type is meant by
  a Perl value.
  
  =over 4
  
  =item hash references
  
  Perl hash references become JSON objects. As there is no inherent
  ordering in hash keys (or JSON objects), they will usually be encoded
  in a pseudo-random order. JSON::PP can optionally sort the hash keys
  (determined by the I<canonical> flag and/or I<sort_by> property), so
  the same data structure will serialise to the same JSON text (given
  same settings and version of JSON::PP), but this incurs a runtime
  overhead and is only rarely useful, e.g. when you want to compare some
  JSON text against another for equality.
  
  =item array references
  
  Perl array references become JSON arrays.
  
  =item other references
  
  Other unblessed references are generally not allowed and will cause an
  exception to be thrown, except for references to the integers C<0> and
  C<1>, which get turned into C<false> and C<true> atoms in JSON. You can
  also use C<JSON::PP::false> and C<JSON::PP::true> to improve
  readability.
  
     to_json [\0, JSON::PP::true]      # yields [false,true]
  
  =item JSON::PP::true, JSON::PP::false
  
  These special values become JSON true and JSON false values,
  respectively. You can also use C<\1> and C<\0> directly if you want.
  
  =item JSON::PP::null
  
  This special value becomes JSON null.
  
  =item blessed objects
  
  Blessed objects are not directly representable in JSON, but C<JSON::PP>
  allows various ways of handling objects. See L<OBJECT SERIALISATION>,
  below, for details.
  
  =item simple scalars
  
  Simple Perl scalars (any scalar that is not a reference) are the most
  difficult objects to encode: JSON::PP will encode undefined scalars as
  JSON C<null> values, scalars that have last been used in a string context
  before encoding as JSON strings, and anything else as number value:
  
     # dump as number
     encode_json [2]                      # yields [2]
     encode_json [-3.0e17]                # yields [-3e+17]
     my $value = 5; encode_json [$value]  # yields [5]
  
     # used as string, so dump as string
     print $value;
     encode_json [$value]                 # yields ["5"]
  
     # undef becomes null
     encode_json [undef]                  # yields [null]
  
  You can force the type to be a string by stringifying it:
  
     my $x = 3.1; # some variable containing a number
     "$x";        # stringified
     $x .= "";    # another, more awkward way to stringify
     print $x;    # perl does it for you, too, quite often
                  # (but for older perls)
  
  You can force the type to be a number by numifying it:
  
     my $x = "3"; # some variable containing a string
     $x += 0;     # numify it, ensuring it will be dumped as a number
     $x *= 1;     # same thing, the choice is yours.
  
  You cannot currently force the type in other, less obscure, ways.
  
  Note that numerical precision has the same meaning as under Perl (so
  binary to decimal conversion follows the same rules as in Perl, which
  can differ to other languages). Also, your perl interpreter might expose
  extensions to the floating point numbers of your platform, such as
  infinities or NaN's - these cannot be represented in JSON, and it is an
  error to pass those in.
  
  JSON::PP (and JSON::XS) trusts what you pass to C<encode> method
  (or C<encode_json> function) is a clean, validated data structure with
  values that can be represented as valid JSON values only, because it's
  not from an external data source (as opposed to JSON texts you pass to
  C<decode> or C<decode_json>, which JSON::PP considers tainted and
  doesn't trust). As JSON::PP doesn't know exactly what you and consumers
  of your JSON texts want the unexpected values to be (you may want to
  convert them into null, or to stringify them with or without
  normalisation (string representation of infinities/NaN may vary
  depending on platforms), or to croak without conversion), you're advised
  to do what you and your consumers need before you encode, and also not
  to numify values that may start with values that look like a number
  (including infinities/NaN), without validating.
  
  =back
  
  =head2 OBJECT SERIALISATION
  
  As for Perl objects, JSON::PP only supports a pure JSON representation (without the ability to deserialise the object automatically again).
  
  =head3 SERIALISATION
  
  What happens when C<JSON::PP> encounters a Perl object depends on the
  C<allow_blessed>, C<convert_blessed> and C<allow_bignum> settings, which are
  used in this order:
  
  =over 4
  
  =item 1. C<convert_blessed> is enabled and the object has a C<TO_JSON> method.
  
  In this case, the C<TO_JSON> method of the object is invoked in scalar
  context. It must return a single scalar that can be directly encoded into
  JSON. This scalar replaces the object in the JSON text.
  
  For example, the following C<TO_JSON> method will convert all L<URI>
  objects to JSON strings when serialised. The fact that these values
  originally were L<URI> objects is lost.
  
     sub URI::TO_JSON {
        my ($uri) = @_;
        $uri->as_string
     }
  
  =item 2. C<allow_bignum> is enabled and the object is a C<Math::BigInt> or C<Math::BigFloat>.
  
  The object will be serialised as a JSON number value.
  
  =item 3. C<allow_blessed> is enabled.
  
  The object will be serialised as a JSON null value.
  
  =item 4. none of the above
  
  If none of the settings are enabled or the respective methods are missing,
  C<JSON::PP> throws an exception.
  
  =back
  
  =head1 ENCODING/CODESET FLAG NOTES
  
  This section is taken from JSON::XS.
  
  The interested reader might have seen a number of flags that signify
  encodings or codesets - C<utf8>, C<latin1> and C<ascii>. There seems to be
  some confusion on what these do, so here is a short comparison:
  
  C<utf8> controls whether the JSON text created by C<encode> (and expected
  by C<decode>) is UTF-8 encoded or not, while C<latin1> and C<ascii> only
  control whether C<encode> escapes character values outside their respective
  codeset range. Neither of these flags conflict with each other, although
  some combinations make less sense than others.
  
  Care has been taken to make all flags symmetrical with respect to
  C<encode> and C<decode>, that is, texts encoded with any combination of
  these flag values will be correctly decoded when the same flags are used
  - in general, if you use different flag settings while encoding vs. when
  decoding you likely have a bug somewhere.
  
  Below comes a verbose discussion of these flags. Note that a "codeset" is
  simply an abstract set of character-codepoint pairs, while an encoding
  takes those codepoint numbers and I<encodes> them, in our case into
  octets. Unicode is (among other things) a codeset, UTF-8 is an encoding,
  and ISO-8859-1 (= latin 1) and ASCII are both codesets I<and> encodings at
  the same time, which can be confusing.
  
  =over 4
  
  =item C<utf8> flag disabled
  
  When C<utf8> is disabled (the default), then C<encode>/C<decode> generate
  and expect Unicode strings, that is, characters with high ordinal Unicode
  values (> 255) will be encoded as such characters, and likewise such
  characters are decoded as-is, no changes to them will be done, except
  "(re-)interpreting" them as Unicode codepoints or Unicode characters,
  respectively (to Perl, these are the same thing in strings unless you do
  funny/weird/dumb stuff).
  
  This is useful when you want to do the encoding yourself (e.g. when you
  want to have UTF-16 encoded JSON texts) or when some other layer does
  the encoding for you (for example, when printing to a terminal using a
  filehandle that transparently encodes to UTF-8 you certainly do NOT want
  to UTF-8 encode your data first and have Perl encode it another time).
  
  =item C<utf8> flag enabled
  
  If the C<utf8>-flag is enabled, C<encode>/C<decode> will encode all
  characters using the corresponding UTF-8 multi-byte sequence, and will
  expect your input strings to be encoded as UTF-8, that is, no "character"
  of the input string must have any value > 255, as UTF-8 does not allow
  that.
  
  The C<utf8> flag therefore switches between two modes: disabled means you
  will get a Unicode string in Perl, enabled means you get an UTF-8 encoded
  octet/binary string in Perl.
  
  =item C<latin1> or C<ascii> flags enabled
  
  With C<latin1> (or C<ascii>) enabled, C<encode> will escape characters
  with ordinal values > 255 (> 127 with C<ascii>) and encode the remaining
  characters as specified by the C<utf8> flag.
  
  If C<utf8> is disabled, then the result is also correctly encoded in those
  character sets (as both are proper subsets of Unicode, meaning that a
  Unicode string with all character values < 256 is the same thing as a
  ISO-8859-1 string, and a Unicode string with all character values < 128 is
  the same thing as an ASCII string in Perl).
  
  If C<utf8> is enabled, you still get a correct UTF-8-encoded string,
  regardless of these flags, just some more characters will be escaped using
  C<\uXXXX> then before.
  
  Note that ISO-8859-1-I<encoded> strings are not compatible with UTF-8
  encoding, while ASCII-encoded strings are. That is because the ISO-8859-1
  encoding is NOT a subset of UTF-8 (despite the ISO-8859-1 I<codeset> being
  a subset of Unicode), while ASCII is.
  
  Surprisingly, C<decode> will ignore these flags and so treat all input
  values as governed by the C<utf8> flag. If it is disabled, this allows you
  to decode ISO-8859-1- and ASCII-encoded strings, as both strict subsets of
  Unicode. If it is enabled, you can correctly decode UTF-8 encoded strings.
  
  So neither C<latin1> nor C<ascii> are incompatible with the C<utf8> flag -
  they only govern when the JSON output engine escapes a character or not.
  
  The main use for C<latin1> is to relatively efficiently store binary data
  as JSON, at the expense of breaking compatibility with most JSON decoders.
  
  The main use for C<ascii> is to force the output to not contain characters
  with values > 127, which means you can interpret the resulting string
  as UTF-8, ISO-8859-1, ASCII, KOI8-R or most about any character set and
  8-bit-encoding, and still get the same data structure back. This is useful
  when your channel for JSON transfer is not 8-bit clean or the encoding
  might be mangled in between (e.g. in mail), and works because ASCII is a
  proper subset of most 8-bit and multibyte encodings in use in the world.
  
  =back
  
  =head1 SEE ALSO
  
  The F<json_pp> command line utility for quick experiments.
  
  L<JSON::XS>, L<Cpanel::JSON::XS>, and L<JSON::Tiny> for faster alternatives.
  L<JSON> and L<JSON::MaybeXS> for easy migration.
  
  L<JSON::PP::Compat5005> and L<JSON::PP::Compat5006> for older perl users.
  
  RFC4627 (L<http://www.ietf.org/rfc/rfc4627.txt>)
  
  =head1 AUTHOR
  
  Makamaka Hannyaharamitu, E<lt>makamaka[at]cpan.orgE<gt>
  
  
  =head1 COPYRIGHT AND LICENSE
  
  Copyright 2007-2016 by Makamaka Hannyaharamitu
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself. 
  
  =cut
JSON_PP

$fatpacked{"JSON/PP/Boolean.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'JSON_PP_BOOLEAN';
  package JSON::PP::Boolean;
  
  use strict;
  use overload (
      "0+"     => sub { ${$_[0]} },
      "++"     => sub { $_[0] = ${$_[0]} + 1 },
      "--"     => sub { $_[0] = ${$_[0]} - 1 },
      fallback => 1,
  );
  
  $JSON::PP::Boolean::VERSION = '2.97001';
  
  1;
  
  __END__
  
  =head1 NAME
  
  JSON::PP::Boolean - dummy module providing JSON::PP::Boolean
  
  =head1 SYNOPSIS
  
   # do not "use" yourself
  
  =head1 DESCRIPTION
  
  This module exists only to provide overload resolution for Storable and similar modules. See
  L<JSON::PP> for more info about this class.
  
  =head1 AUTHOR
  
  This idea is from L<JSON::XS::Boolean> written by Marc Lehmann <schmorp[at]schmorp.de>
  
  =cut
  
JSON_PP_BOOLEAN

$fatpacked{"Locale/Maketext/Simple.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'LOCALE_MAKETEXT_SIMPLE';
  package Locale::Maketext::Simple;
  $Locale::Maketext::Simple::VERSION = '0.21';
  
  use strict;
  use 5.005;
  
  =head1 NAME
  
  Locale::Maketext::Simple - Simple interface to Locale::Maketext::Lexicon
  
  =head1 VERSION
  
  This document describes version 0.18 of Locale::Maketext::Simple,
  released Septermber 8, 2006.
  
  =head1 SYNOPSIS
  
  Minimal setup (looks for F<auto/Foo/*.po> and F<auto/Foo/*.mo>):
  
      package Foo;
      use Locale::Maketext::Simple;	# exports 'loc'
      loc_lang('fr');			# set language to French
      sub hello {
  	print loc("Hello, [_1]!", "World");
      }
  
  More sophisticated example:
  
      package Foo::Bar;
      use Locale::Maketext::Simple (
  	Class	    => 'Foo',	    # search in auto/Foo/
  	Style	    => 'gettext',   # %1 instead of [_1]
  	Export	    => 'maketext',  # maketext() instead of loc()
  	Subclass    => 'L10N',	    # Foo::L10N instead of Foo::I18N
  	Decode	    => 1,	    # decode entries to unicode-strings
  	Encoding    => 'locale',    # but encode lexicons in current locale
  				    # (needs Locale::Maketext::Lexicon 0.36)
      );
      sub japh {
  	print maketext("Just another %1 hacker", "Perl");
      }
  
  =head1 DESCRIPTION
  
  This module is a simple wrapper around B<Locale::Maketext::Lexicon>,
  designed to alleviate the need of creating I<Language Classes> for
  module authors.
  
  The language used is chosen from the loc_lang call. If a lookup is not
  possible, the i-default language will be used. If the lookup is not in the
  i-default language, then the key will be returned.
  
  If B<Locale::Maketext::Lexicon> is not present, it implements a
  minimal localization function by simply interpolating C<[_1]> with
  the first argument, C<[_2]> with the second, etc.  Interpolated
  function like C<[quant,_1]> are treated as C<[_1]>, with the sole
  exception of C<[tense,_1,X]>, which will append C<ing> to C<_1> when
  X is C<present>, or appending C<ed> to <_1> otherwise.
  
  =head1 OPTIONS
  
  All options are passed either via the C<use> statement, or via an
  explicit C<import>.
  
  =head2 Class
  
  By default, B<Locale::Maketext::Simple> draws its source from the
  calling package's F<auto/> directory; you can override this behaviour
  by explicitly specifying another package as C<Class>.
  
  =head2 Path
  
  If your PO and MO files are under a path elsewhere than C<auto/>,
  you may specify it using the C<Path> option.
  
  =head2 Style
  
  By default, this module uses the C<maketext> style of C<[_1]> and
  C<[quant,_1]> for interpolation.  Alternatively, you can specify the
  C<gettext> style, which uses C<%1> and C<%quant(%1)> for interpolation.
  
  This option is case-insensitive.
  
  =head2 Export
  
  By default, this module exports a single function, C<loc>, into its
  caller's namespace.  You can set it to another name, or set it to
  an empty string to disable exporting.
  
  =head2 Subclass
  
  By default, this module creates an C<::I18N> subclass under the
  caller's package (or the package specified by C<Class>), and stores
  lexicon data in its subclasses.  You can assign a name other than
  C<I18N> via this option.
  
  =head2 Decode
  
  If set to a true value, source entries will be converted into
  utf8-strings (available in Perl 5.6.1 or later).  This feature
  needs the B<Encode> or B<Encode::compat> module.
  
  =head2 Encoding
  
  Specifies an encoding to store lexicon entries, instead of
  utf8-strings.  If set to C<locale>, the encoding from the current
  locale setting is used.  Implies a true value for C<Decode>.
  
  =cut
  
  sub import {
      my ($class, %args) = @_;
  
      $args{Class}    ||= caller;
      $args{Style}    ||= 'maketext';
      $args{Export}   ||= 'loc';
      $args{Subclass} ||= 'I18N';
  
      my ($loc, $loc_lang) = $class->load_loc(%args);
      $loc ||= $class->default_loc(%args);
  
      no strict 'refs';
      *{caller(0) . "::$args{Export}"} = $loc if $args{Export};
      *{caller(0) . "::$args{Export}_lang"} = $loc_lang || sub { 1 };
  }
  
  my %Loc;
  
  sub reload_loc { %Loc = () }
  
  sub load_loc {
      my ($class, %args) = @_;
  
      my $pkg = join('::', grep { defined and length } $args{Class}, $args{Subclass});
      return $Loc{$pkg} if exists $Loc{$pkg};
  
      eval { require Locale::Maketext::Lexicon; 1 }   or return;
      $Locale::Maketext::Lexicon::VERSION > 0.20	    or return;
      eval { require File::Spec; 1 }		    or return;
  
      my $path = $args{Path} || $class->auto_path($args{Class}) or return;
      my $pattern = File::Spec->catfile($path, '*.[pm]o');
      my $decode = $args{Decode} || 0;
      my $encoding = $args{Encoding} || undef;
  
      $decode = 1 if $encoding;
  
      $pattern =~ s{\\}{/}g; # to counter win32 paths
  
      eval "
  	package $pkg;
  	use base 'Locale::Maketext';
  	Locale::Maketext::Lexicon->import({
  	    'i-default' => [ 'Auto' ],
  	    '*'	=> [ Gettext => \$pattern ],
  	    _decode => \$decode,
  	    _encoding => \$encoding,
  	});
  	*${pkg}::Lexicon = \\%${pkg}::i_default::Lexicon;
  	*tense = sub { \$_[1] . ((\$_[2] eq 'present') ? 'ing' : 'ed') }
  	    unless defined &tense;
  
  	1;
      " or die $@;
  
      my $lh = eval { $pkg->get_handle } or return;
      my $style = lc($args{Style});
      if ($style eq 'maketext') {
  	$Loc{$pkg} = sub {
  	    $lh->maketext(@_)
  	};
      }
      elsif ($style eq 'gettext') {
  	$Loc{$pkg} = sub {
  	    my $str = shift;
              $str =~ s{([\~\[\]])}{~$1}g;
              $str =~ s{
                  ([%\\]%)                        # 1 - escaped sequence
              |
                  %   (?:
                          ([A-Za-z#*]\w*)         # 2 - function call
                              \(([^\)]*)\)        # 3 - arguments
                      |
                          ([1-9]\d*|\*)           # 4 - variable
                      )
              }{
                  $1 ? $1
                     : $2 ? "\[$2,"._unescape($3)."]"
                          : "[_$4]"
              }egx;
  	    return $lh->maketext($str, @_);
  	};
      }
      else {
  	die "Unknown Style: $style";
      }
  
      return $Loc{$pkg}, sub {
  	$lh = $pkg->get_handle(@_);
      };
  }
  
  sub default_loc {
      my ($self, %args) = @_;
      my $style = lc($args{Style});
      if ($style eq 'maketext') {
  	return sub {
  	    my $str = shift;
              $str =~ s{((?<!~)(?:~~)*)\[_([1-9]\d*|\*)\]}
                       {$1%$2}g;
              $str =~ s{((?<!~)(?:~~)*)\[([A-Za-z#*]\w*),([^\]]+)\]}
                       {"$1%$2(" . _escape($3) . ')'}eg;
  	    _default_gettext($str, @_);
  	};
      }
      elsif ($style eq 'gettext') {
  	return \&_default_gettext;
      }
      else {
  	die "Unknown Style: $style";
      }
  }
  
  sub _default_gettext {
      my $str = shift;
      $str =~ s{
  	%			# leading symbol
  	(?:			# either one of
  	    \d+			#   a digit, like %1
  	    |			#     or
  	    (\w+)\(		#   a function call -- 1
  		(?:		#     either
  		    %\d+	#	an interpolation
  		    |		#     or
  		    ([^,]*)	#	some string -- 2
  		)		#     end either
  		(?:		#     maybe followed
  		    ,		#       by a comma
  		    ([^),]*)	#       and a param -- 3
  		)?		#     end maybe
  		(?:		#     maybe followed
  		    ,		#       by another comma
  		    ([^),]*)	#       and a param -- 4
  		)?		#     end maybe
  		[^)]*		#     and other ignorable params
  	    \)			#   closing function call
  	)			# closing either one of
      }{
  	my $digit = $2 || shift;
  	$digit . (
  	    $1 ? (
  		($1 eq 'tense') ? (($3 eq 'present') ? 'ing' : 'ed') :
  		($1 eq 'quant') ? ' ' . (($digit > 1) ? ($4 || "$3s") : $3) :
  		''
  	    ) : ''
  	);
      }egx;
      return $str;
  };
  
  sub _escape {
      my $text = shift;
      $text =~ s/\b_([1-9]\d*)/%$1/g;
      return $text;
  }
  
  sub _unescape {
      join(',', map {
          /\A(\s*)%([1-9]\d*|\*)(\s*)\z/ ? "$1_$2$3" : $_
      } split(/,/, $_[0]));
  }
  
  sub auto_path {
      my ($self, $calldir) = @_;
      $calldir =~ s#::#/#g;
      my $path = $INC{$calldir . '.pm'} or return;
  
      # Try absolute path name.
      if ($^O eq 'MacOS') {
  	(my $malldir = $calldir) =~ tr#/#:#;
  	$path =~ s#^(.*)$malldir\.pm\z#$1auto:$malldir:#s;
      } else {
  	$path =~ s#^(.*)$calldir\.pm\z#$1auto/$calldir/#;
      }
  
      return $path if -d $path;
  
      # If that failed, try relative path with normal @INC searching.
      $path = "auto/$calldir/";
      foreach my $inc (@INC) {
  	return "$inc/$path" if -d "$inc/$path";
      }
  
      return;
  }
  
  1;
  
  =head1 ACKNOWLEDGMENTS
  
  Thanks to Jos I. Boumans for suggesting this module to be written.
  
  Thanks to Chia-Liang Kao for suggesting C<Path> and C<loc_lang>.
  
  =head1 SEE ALSO
  
  L<Locale::Maketext>, L<Locale::Maketext::Lexicon>
  
  =head1 AUTHORS
  
  Audrey Tang E<lt>cpan@audreyt.orgE<gt>
  
  =head1 COPYRIGHT
  
  Copyright 2003, 2004, 2005, 2006 by Audrey Tang E<lt>cpan@audreyt.orgE<gt>.
  
  This software is released under the MIT license cited below.  Additionally,
  when this software is distributed with B<Perl Kit, Version 5>, you may also
  redistribute it and/or modify it under the same terms as Perl itself.
  
  =head2 The "MIT" License
  
  Permission is hereby granted, free of charge, to any person obtaining a copy
  of this software and associated documentation files (the "Software"), to deal
  in the Software without restriction, including without limitation the rights
  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
  copies of the Software, and to permit persons to whom the Software is
  furnished to do so, subject to the following conditions:
  
  The above copyright notice and this permission notice shall be included in
  all copies or substantial portions of the Software.
  
  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
  OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
  DEALINGS IN THE SOFTWARE.
  
  =cut
LOCALE_MAKETEXT_SIMPLE

$fatpacked{"MRO/Compat.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'MRO_COMPAT';
  package MRO::Compat;
  use strict;
  use warnings;
  require 5.006_000;
  
  # Keep this < 1.00, so people can tell the fake
  #  mro.pm from the real one
  our $VERSION = '0.13';
  
  BEGIN {
      # Alias our private functions over to
      # the mro:: namespace and load
      # Class::C3 if Perl < 5.9.5
      if($] < 5.009_005) {
          $mro::VERSION # to fool Module::Install when generating META.yml
              = $VERSION;
          $INC{'mro.pm'} = __FILE__;
          *mro::import            = \&__import;
          *mro::get_linear_isa    = \&__get_linear_isa;
          *mro::set_mro           = \&__set_mro;
          *mro::get_mro           = \&__get_mro;
          *mro::get_isarev        = \&__get_isarev;
          *mro::is_universal      = \&__is_universal;
          *mro::method_changed_in = \&__method_changed_in;
          *mro::invalidate_all_method_caches
                                  = \&__invalidate_all_method_caches;
          require Class::C3;
          if($Class::C3::XS::VERSION && $Class::C3::XS::VERSION > 0.03) {
              *mro::get_pkg_gen   = \&__get_pkg_gen_c3xs;
          }
          else {
              *mro::get_pkg_gen   = \&__get_pkg_gen_pp;
          }
      }
  
      # Load mro.pm and provide no-op Class::C3::.*initialize() funcs for 5.9.5+
      else {
          require mro;
          no warnings 'redefine';
          *Class::C3::initialize = sub { 1 };
          *Class::C3::reinitialize = sub { 1 };
          *Class::C3::uninitialize = sub { 1 };
      }
  }
  
  =head1 NAME
  
  MRO::Compat - mro::* interface compatibility for Perls < 5.9.5
  
  =head1 SYNOPSIS
  
     package PPP;      use base qw/Exporter/;
     package X;        use base qw/PPP/;
     package Y;        use base qw/PPP/;
     package Z;        use base qw/PPP/;
  
     package FooClass; use base qw/X Y Z/;
  
     package main;
     use MRO::Compat;
     my $linear = mro::get_linear_isa('FooClass');
     print join(q{, }, @$linear);
  
     # Prints: FooClass, X, PPP, Exporter, Y, Z
  
  =head1 DESCRIPTION
  
  The "mro" namespace provides several utilities for dealing
  with method resolution order and method caching in general
  in Perl 5.9.5 and higher.
  
  This module provides those interfaces for
  earlier versions of Perl (back to 5.6.0 anyways).
  
  It is a harmless no-op to use this module on 5.9.5+.  That
  is to say, code which properly uses L<MRO::Compat> will work
  unmodified on both older Perls and 5.9.5+.
  
  If you're writing a piece of software that would like to use
  the parts of 5.9.5+'s mro:: interfaces that are supported
  here, and you want compatibility with older Perls, this
  is the module for you.
  
  Some parts of this code will work better and/or faster with
  L<Class::C3::XS> installed (which is an optional prereq
  of L<Class::C3>, which is in turn a prereq of this
  package), but it's not a requirement.
  
  This module never exports any functions.  All calls must
  be fully qualified with the C<mro::> prefix.
  
  The interface documentation here serves only as a quick
  reference of what the function basically does, and what
  differences between L<MRO::Compat> and 5.9.5+ one should
  look out for.  The main docs in 5.9.5's L<mro> are the real
  interface docs, and contain a lot of other useful information.
  
  =head1 Functions
  
  =head2 mro::get_linear_isa($classname[, $type])
  
  Returns an arrayref which is the linearized "ISA" of the given class.
  Uses whichever MRO is currently in effect for that class by default,
  or the given MRO (either C<c3> or C<dfs> if specified as C<$type>).
  
  The linearized ISA of a class is a single ordered list of all of the
  classes that would be visited in the process of resolving a method
  on the given class, starting with itself.  It does not include any
  duplicate entries.
  
  Note that C<UNIVERSAL> (and any members of C<UNIVERSAL>'s MRO) are not
  part of the MRO of a class, even though all classes implicitly inherit
  methods from C<UNIVERSAL> and its parents.
  
  =cut
  
  sub __get_linear_isa_dfs {
      no strict 'refs';
  
      my $classname = shift;
  
      my @lin = ($classname);
      my %stored;
      foreach my $parent (@{"$classname\::ISA"}) {
          my $plin = __get_linear_isa_dfs($parent);
          foreach (@$plin) {
              next if exists $stored{$_};
              push(@lin, $_);
              $stored{$_} = 1;
          }
      }
      return \@lin;
  }
  
  sub __get_linear_isa {
      my ($classname, $type) = @_;
      die "mro::get_mro requires a classname" if !defined $classname;
  
      $type ||= __get_mro($classname);
      if($type eq 'dfs') {
          return __get_linear_isa_dfs($classname);
      }
      elsif($type eq 'c3') {
          return [Class::C3::calculateMRO($classname)];
      }
      die "type argument must be 'dfs' or 'c3'";
  }
  
  =head2 mro::import
  
  This allows the C<use mro 'dfs'> and
  C<use mro 'c3'> syntaxes, providing you
  L<use MRO::Compat> first.  Please see the
  L</USING C3> section for additional details.
  
  =cut
  
  sub __import {
      if($_[1]) {
          goto &Class::C3::import if $_[1] eq 'c3';
          __set_mro(scalar(caller), $_[1]);
      }
  }
  
  =head2 mro::set_mro($classname, $type)
  
  Sets the mro of C<$classname> to one of the types
  C<dfs> or C<c3>.  Please see the L</USING C3>
  section for additional details.
  
  =cut
  
  sub __set_mro {
      my ($classname, $type) = @_;
  
      if(!defined $classname || !$type) {
          die q{Usage: mro::set_mro($classname, $type)};
      }
  
      if($type eq 'c3') {
          eval "package $classname; use Class::C3";
          die $@ if $@;
      }
      elsif($type eq 'dfs') {
          # In the dfs case, check whether we need to undo C3
          if(defined $Class::C3::MRO{$classname}) {
              Class::C3::_remove_method_dispatch_table($classname);
          }
          delete $Class::C3::MRO{$classname};
      }
      else {
          die qq{Invalid mro type "$type"};
      }
  
      return;
  }
  
  =head2 mro::get_mro($classname)
  
  Returns the MRO of the given class (either C<c3> or C<dfs>).
  
  It considers any Class::C3-using class to have C3 MRO
  even before L<Class::C3::initialize()> is called.
  
  =cut
  
  sub __get_mro {
      my $classname = shift;
      die "mro::get_mro requires a classname" if !defined $classname;
      return 'c3' if exists $Class::C3::MRO{$classname};
      return 'dfs';
  }
  
  =head2 mro::get_isarev($classname)
  
  Returns an arrayref of classes who are subclasses of the
  given classname.  In other words, classes in whose @ISA
  hierarchy we appear, no matter how indirectly.
  
  This is much slower on pre-5.9.5 Perls with MRO::Compat
  than it is on 5.9.5+, as it has to search the entire
  package namespace.
  
  =cut
  
  sub __get_all_pkgs_with_isas {
      no strict 'refs';
      no warnings 'recursion';
  
      my @retval;
  
      my $search = shift;
      my $pfx;
      my $isa;
      if(defined $search) {
          $isa = \@{"$search\::ISA"};
          $pfx = "$search\::";
      }
      else {
          $search = 'main';
          $isa = \@main::ISA;
          $pfx = '';
      }
  
      push(@retval, $search) if scalar(@$isa);
  
      foreach my $cand (keys %{"$search\::"}) {
          if($cand =~ s/::$//) {
              next if $cand eq $search; # skip self-reference (main?)
              push(@retval, @{__get_all_pkgs_with_isas($pfx . $cand)});
          }
      }
  
      return \@retval;
  }
  
  sub __get_isarev_recurse {
      no strict 'refs';
  
      my ($class, $all_isas, $level) = @_;
  
      die "Recursive inheritance detected" if $level > 100;
  
      my %retval;
  
      foreach my $cand (@$all_isas) {
          my $found_me;
          foreach (@{"$cand\::ISA"}) {
              if($_ eq $class) {
                  $found_me = 1;
                  last;
              }
          }
          if($found_me) {
              $retval{$cand} = 1;
              map { $retval{$_} = 1 }
                  @{__get_isarev_recurse($cand, $all_isas, $level+1)};
          }
      }
      return [keys %retval];
  }
  
  sub __get_isarev {
      my $classname = shift;
      die "mro::get_isarev requires a classname" if !defined $classname;
  
      __get_isarev_recurse($classname, __get_all_pkgs_with_isas(), 0);
  }
  
  =head2 mro::is_universal($classname)
  
  Returns a boolean status indicating whether or not
  the given classname is either C<UNIVERSAL> itself,
  or one of C<UNIVERSAL>'s parents by C<@ISA> inheritance.
  
  Any class for which this function returns true is
  "universal" in the sense that all classes potentially
  inherit methods from it.
  
  =cut
  
  sub __is_universal {
      my $classname = shift;
      die "mro::is_universal requires a classname" if !defined $classname;
  
      my $lin = __get_linear_isa('UNIVERSAL');
      foreach (@$lin) {
          return 1 if $classname eq $_;
      }
  
      return 0;
  }
  
  =head2 mro::invalidate_all_method_caches
  
  Increments C<PL_sub_generation>, which invalidates method
  caching in all packages.
  
  Please note that this is rarely necessary, unless you are
  dealing with a situation which is known to confuse Perl's
  method caching.
  
  =cut
  
  sub __invalidate_all_method_caches {
      # Super secret mystery code :)
      @f845a9c1ac41be33::ISA = @f845a9c1ac41be33::ISA;
      return;
  }
  
  =head2 mro::method_changed_in($classname)
  
  Invalidates the method cache of any classes dependent on the
  given class.  In L<MRO::Compat> on pre-5.9.5 Perls, this is
  an alias for C<mro::invalidate_all_method_caches> above, as
  pre-5.9.5 Perls have no other way to do this.  It will still
  enforce the requirement that you pass it a classname, for
  compatibility.
  
  Please note that this is rarely necessary, unless you are
  dealing with a situation which is known to confuse Perl's
  method caching.
  
  =cut
  
  sub __method_changed_in {
      my $classname = shift;
      die "mro::method_changed_in requires a classname" if !defined $classname;
  
      __invalidate_all_method_caches();
  }
  
  =head2 mro::get_pkg_gen($classname)
  
  Returns an integer which is incremented every time a local
  method of or the C<@ISA> of the given package changes on
  Perl 5.9.5+.  On earlier Perls with this L<MRO::Compat> module,
  it will probably increment a lot more often than necessary.
  
  =cut
  
  {
      my $__pkg_gen = 2;
      sub __get_pkg_gen_pp {
          my $classname = shift;
          die "mro::get_pkg_gen requires a classname" if !defined $classname;
          return $__pkg_gen++;
      }
  }
  
  sub __get_pkg_gen_c3xs {
      my $classname = shift;
      die "mro::get_pkg_gen requires a classname" if !defined $classname;
  
      return Class::C3::XS::_plsubgen();
  }
  
  =head1 USING C3
  
  While this module makes the 5.9.5+ syntaxes
  C<use mro 'c3'> and C<mro::set_mro("Foo", 'c3')> available
  on older Perls, it does so merely by passing off the work
  to L<Class::C3>.
  
  It does not remove the need for you to call
  C<Class::C3::initialize()>, C<Class::C3::reinitialize()>, and/or
  C<Class::C3::uninitialize()> at the appropriate times
  as documented in the L<Class::C3> docs.  These three functions
  are always provided by L<MRO::Compat>, either via L<Class::C3>
  itself on older Perls, or directly as no-ops on 5.9.5+.
  
  =head1 SEE ALSO
  
  L<Class::C3>
  
  L<mro>
  
  =head1 AUTHOR
  
  Brandon L. Black, E<lt>blblack@gmail.comE<gt>
  
  =head1 COPYRIGHT AND LICENSE
  
  Copyright 2007-2008 Brandon L. Black E<lt>blblack@gmail.comE<gt>
  
  This library is free software; you can redistribute it and/or modify
  it under the same terms as Perl itself. 
  
  =cut
  
  1;
MRO_COMPAT

$fatpacked{"Menlo.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'MENLO';
  package Menlo;
  our $VERSION = "1.9014";
  
  1;
  
  __END__
  
  =encoding utf8
  
  =head1 NAME
  
  Menlo - A CPAN client
  
  =head1 DESCRIPTION
  
  Menlo is a code name for I<cpanm 2.0>, developed with the goal to
  replace L<cpanm> and its backend with a more flexible, extensible and
  easier to use APIs.
  
  =head1 COMPATIBILITY
  
  Menlo is developed within L<cpanm> git repository at the C<menlo>
  branch. It keeps the developer test suite intact, which means all of
  the features implemented as of cpanm 1.7032 are supposed to work in
  Menlo with C<cpanm-menlo> command line tool and its backend,
  Menlo::CLI::Compat.
  
  Menlo::CLI::Compat started off as a copy of App::cpanminus::script,
  but will go under a big refactoring to extract all the bits out of
  it. Hopefully the end result will be just a shim and translation layer
  to interpret command line options.
  
  A new client, possibly called C<menlo>, and object oriented APIs will
  be added later in the development phase.
  
  =head1 MOTIVATION
  
  cpanm has been a popular choice of CPAN package installer for many
  developers, because it is lightweight, fast, and requires no
  configuration in most environments.
  
  Meanwhile, the way cpanm has been implemented (one God class, and all
  modules are packaged in one script with fatpacker) makes it difficult
  to extend, or modify the behaviors at a runtime, unless you decide to
  fork the code or monkeypatch its hidden backend class.
  
  cpanm also has no scriptable API or hook points, which means you have
  to work around its behavior by writing a shell wrapper, or parsing the
  output of its standard out or a build log file.
  
  Menlo will keep the best aspects of cpanm, which is dependencies free,
  configuration free, lightweight and fast to install CPAN modules. At
  the same time, it's impelmented as a standard perl module, available
  on CPAN, and you can extend its behavior by either using its modular
  interfaces, or writing plugins to hook into its behaviors.
  
  =head1 FAQ
  
  =over 4
  
  =item Dependencies free? I see many prerequisites in Menlo.
  
  Right now, Menlo is in the development phase and is released as a
  standard perl module distribution, and has a few runtime
  dependencies. Actually most of these modules were consumed by cpanm as
  well, and they aren't new.
  
  When I decide it's ready for production and to replace cpanm, I'll
  make a fatpacked version of the script, which will bundle all the
  dependencies into one file, just like cpanm does.
  
  =item Is Menlo a new name for cpanm?
  
  Right now it's just a code name, but I'm comfortable calling this a
  new package name for cpanm 2's backend.
  
  =back
  
  =head1 AUTHOR
  
  Tatsuhiko Miyagawa E<lt>miyagawa@bulknews.netE<gt>
  
  =head1 COPYRIGHT
  
  2010- Tatsuhiko Miyagawa
  
  =head1 LICENSE
  
  This software is licensed under the same terms as Perl.
  
  =head1 SEE ALSO
  
  L<cpanm>
  
  =cut
MENLO

$fatpacked{"Menlo/Builder/Static.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'MENLO_BUILDER_STATIC';
  # This is a fork of:
  #package Module::Build::Tiny;
  #$Module::Build::Tiny::VERSION = '0.039';
  package Menlo::Builder::Static;
  use strict;
  use warnings;
  
  use CPAN::Meta;
  use ExtUtils::Config 0.003;
  use ExtUtils::Helpers 0.020 qw/make_executable split_like_shell man1_pagename man3_pagename detildefy/;
  use ExtUtils::Install qw/pm_to_blib install/;
  use ExtUtils::InstallPaths 0.002;
  use File::Basename qw/basename dirname/;
  use File::Find ();
  use File::Path qw/mkpath rmtree/;
  use File::Spec::Functions qw/catfile catdir rel2abs abs2rel splitdir curdir/;
  use Getopt::Long 2.36 qw/GetOptionsFromArray/;
  use JSON::PP 2 qw/encode_json decode_json/;
  
  sub new {
  	bless {}, shift;
  }
  
  sub get_meta {
  	my ($metafile) = grep { -e $_ } qw/META.json META.yml/ or die "No META information provided\n";
  	return CPAN::Meta->load_file($metafile);
  }
  
  sub manify {
  	my ($input_file, $output_file, $section, $opts) = @_;
  	return if -e $output_file && -M $input_file <= -M $output_file;
  	my $dirname = dirname($output_file);
  	mkpath($dirname, $opts->{verbose}) if not -d $dirname;
  	require Pod::Man;
  	Pod::Man->new(section => $section)->parse_from_file($input_file, $output_file);
  	print "Manifying $output_file\n" if $opts->{verbose} && $opts->{verbose} > 0;
  	return;
  }
  
  sub find {
  	my ($pattern, $dir) = @_;
  	my @ret;
  	File::Find::find(sub { push @ret, $File::Find::name if /$pattern/ && -f }, $dir) if -d $dir;
  	return @ret;
  }
  
  my %actions = (
  	build => sub {
  		my %opt = @_;
  		my %modules = map { $_ => catfile('blib', $_) } find(qr/\.p(?:m|od)$/, 'lib');
  		my %scripts = map { $_ => catfile('blib', $_) } find(qr//, 'script');
  		my %shared  = map { $_ => catfile(qw/blib lib auto share dist/, $opt{meta}->name, abs2rel($_, 'share')) } find(qr//, 'share');
  		pm_to_blib({ %modules, %scripts, %shared }, catdir(qw/blib lib auto/));
  		make_executable($_) for values %scripts;
  		mkpath(catdir(qw/blib arch/), $opt{verbose});
  
  		if ($opt{install_paths}->install_destination('bindoc') && $opt{install_paths}->is_default_installable('bindoc')) {
  			manify($_, catfile('blib', 'bindoc', man1_pagename($_)), $opt{config}->get('man1ext'), \%opt) for keys %scripts;
  		}
  		if ($opt{install_paths}->install_destination('libdoc') && $opt{install_paths}->is_default_installable('libdoc')) {
  			manify($_, catfile('blib', 'libdoc', man3_pagename($_)), $opt{config}->get('man3ext'), \%opt) for keys %modules;
  		}
                  1;
  	},
  	test => sub {
  		my %opt = @_;
  		die "Must run `./Build build` first\n" if not -d 'blib';
  		require TAP::Harness::Env;
  		my %test_args = (
  			(verbosity => $opt{verbose}) x!! exists $opt{verbose},
  			(jobs => $opt{jobs}) x!! exists $opt{jobs},
  			(color => 1) x !!-t STDOUT,
  			lib => [ map { rel2abs(catdir(qw/blib/, $_)) } qw/arch lib/ ],
  		);
  		my $tester = TAP::Harness::Env->create(\%test_args);
  		$tester->runtests(sort +find(qr/\.t$/, 't'))->has_errors and return;
                  1;
  	},
  	install => sub {
  		my %opt = @_;
  		die "Must run `./Build build` first\n" if not -d 'blib';
  		install($opt{install_paths}->install_map, @opt{qw/verbose dry_run uninst/});
                  1;
  	},
  	clean => sub {
  		my %opt = @_;
  		rmtree($_, $opt{verbose}) for qw/blib temp/;
  	},
  	realclean => sub {
  		my %opt = @_;
  		rmtree($_, $opt{verbose}) for qw/blib temp Build _build_params MYMETA.yml MYMETA.json/;
  	},
  );
  
  sub build {
  	my $self = shift;
  	my $action = @_ && $_[0] =~ /\A\w+\z/ ? shift @_ : 'build';
  	die "No such action '$action'\n" if not $actions{$action};
  	my %opt;
  	GetOptionsFromArray([@$_], \%opt, qw/install_base=s install_path=s% installdirs=s destdir=s prefix=s config=s% uninst:1 verbose:1 dry_run:1 pureperl-only:1 create_packlist=i jobs=i/) for ($self->{env}, $self->{configure_args}, \@_);
  	$_ = detildefy($_) for grep { defined } @opt{qw/install_base destdir prefix/}, values %{ $opt{install_path} };
  	@opt{ 'config', 'meta' } = (ExtUtils::Config->new($opt{config}), get_meta());
  	$actions{$action}->(%opt, install_paths => ExtUtils::InstallPaths->new(%opt, dist_name => $opt{meta}->name));
  }
  
  sub configure {
  	my $self = shift;   
  	my $meta = get_meta();
  	$self->{env} = defined $ENV{PERL_MB_OPT} ? [split_like_shell($ENV{PERL_MB_OPT})] : [];
          $self->{configure_args} = [@_];
  	$meta->save(@$_) for ['MYMETA.json'], [ 'MYMETA.yml' => { version => 1.4 } ];
  }
  
  1;
  
  =head1 COPYRIGHT AND LICENSE
  
  This software is copyright (c) 2011 by Leon Timmermans, David Golden.
  
  This is free software; you can redistribute it and/or modify it under
  the same terms as the Perl 5 programming language system itself.
  
  =cut
MENLO_BUILDER_STATIC

$fatpacked{"Menlo/CLI/Compat.pm"} = '#line '.(1+__LINE__).' "'.__FILE__."\"\n".<<'MENLO_CLI_COMPAT';
  package Menlo::CLI::Compat;
  use strict;
  use Config;
  use Cwd ();
  use Menlo;
  use Menlo::Dependency;
  use Menlo::Util qw(WIN32);
  use File::Basename ();
  use File::Find ();
  use File::Path ();
  use File::Spec ();
  use File::Copy ();
  use File::Temp ();
  use File::Which qw(which);
  use Getopt::Long ();
  use Symbol ();
  use version ();
  
  use constant BAD_TAR => ($^O eq 'solaris' || $^O eq 'hpux');
  use constant CAN_SYMLINK => eval { symlink("", ""); 1 };
  
  our $VERSION = $Menlo::VERSION;
  
  if ($INC{"App/FatPacker/Trace.pm"}) {
      require version::vpp;
  }
  
  sub qs($) {
      Menlo::Util::shell_quote($_[0]);
  }
  
  sub agent {
      my $self = shift;
      my $agent = "cpanminus/$VERSION";
      $agent .= " perl/$]" if $self->{report_perl_version};
      $agent;
  }
  
  sub determine_home {
      my $class = shift;
  
      my $homedir = $ENV{HOME}
        || eval { require File::HomeDir; File::HomeDir->my_home }
        || join('', @ENV{qw(HOMEDRIVE HOMEPATH)}); # Win32
  
      if (WIN32) {
          require Win32; # no fatpack
          $homedir = Win32::GetShortPathName($homedir);
      }
  
      return "$homedir/.cpanm";
  }
  
  sub new {
      my $class = shift;
  
      my $self = bless {
          home => $class->determine_home,
          cmd  => 'install',
          seen => {},
          notest => undef,
          test_only => undef,
          installdeps => undef,
          force => undef,
          sudo => undef,
          make  => undef,
          verbose => undef,
          quiet => undef,
          interactive => undef,
          log => undef,
          mirrors => [],
          mirror_only => undef,
          mirror_index => undef,
          cpanmetadb => "http://cpanmetadb.plackperl.org/v1.0/",
          perl => $^X,
          argv => [],
          local_lib => undef,
          self_contained => undef,
          exclude_vendor => undef,
          prompt_timeout => 0,
          prompt => undef,
          configure_timeout => 60,
          build_timeout => 3600,
          test_timeout => 1800,
          try_lwp => 1,
          try_wget => 1,
          try_curl => 1,
          uninstall_shadows => ($] < 5.012),
          skip_installed => 1,
          skip_satisfied => 0,
          auto_cleanup => 7, # days
          pod2man => 1,
          installed_dists => 0,
          install_types => ['requires'],
          with_develop => 0,
          with_configure => 0,
          showdeps => 0,
          scandeps => 0,
          scandeps_tree => [],
          format   => 'tree',
          save_dists => undef,
          skip_configure => 0,
          verify => 0,
          report_perl_version => !$class->maybe_ci,
          build_args => {},
          features => {},
          pure_perl => 0,
          cpanfile_path => 'cpanfile',
          @_,
      }, $class;
  
      $self;
  }
  
  sub env {
      my($self, $key) = @_;
      $ENV{"PERL_CPANM_" . $key};
  }
  
  sub maybe_ci {
      my $class = shift;
      grep $ENV{$_}, qw( TRAVIS CI AUTOMATED_TESTING AUTHOR_TESTING );
  }
  
  sub install_type_handlers {
      my $self = shift;
  
      my @handlers;
      for my $type (qw( recommends suggests )) {
          push @handlers, "with-$type" => sub {
              my %uniq;
              $self->{install_types} = [ grep !$uniq{$_}++, @{$self->{install_types}}, $type ];
          };
          push @handlers, "without-$type" => sub {
              $self->{install_types} = [ grep $_ ne $type, @{$self->{install_types}} ];
          };
      }
  
      @handlers;
  }
  
  sub build_args_handlers {
      my $self = shift;
  
      my @handlers;
      for my $phase (qw( configure build test install )) {
          push @handlers, "$phase-args=s" => \($self->{build_args}{$phase});
      }
  
      @handlers;
  }
  
  sub parse_options {
      my $self = shift;
  
      local @ARGV = @{$self->{argv}};
      push @ARGV, grep length, split /\s+/, $self->env('OPT');
      push @ARGV, @_;
  
      Getopt::Long::Configure("bundling");
      Getopt::Long::GetOptions(
          'f|force'   => sub { $self->{skip_installed} = 0; $self->{force} = 1 },
          'n|notest!' => \$self->{notest},
          'test-only' => sub { $self->{notest} = 0; $self->{skip_installed} = 0; $self->{test_only} = 1 },
          'S|sudo!'   => \$self->{sudo},
          'v|verbose' => \$self->{verbose},
          'verify!'   => \$self->{verify},
          'q|quiet!'  => \$self->{quiet},
          'h|help'    => sub { $self->{action} = 'show_help' },
          'V|version' => sub { $self->{action} = 'show_version' },
          'perl=s'    => sub {
              $self->diag("--perl is deprecated since it's known to be fragile in figuring out dependencies. Run `$_[1] -S cpanm` instead.\n", 1);
              $self->{perl} = $_[1];
          },
          'l|local-lib=s' => sub { $self->{local_lib} = $self->maybe_abs($_[1]) },
          'L|local-lib-contained=s' => sub {
              $self->{local_lib} = $self->maybe_abs($_[1]);
              $self->{self_contained} = 1;
              $self->{pod2man} = undef;
          },
          'self-contained!' => \$self->{self_contained},
          'exclude-vendor!' => \$self->{exclude_vendor},
          'mirror=s@' => $self->{mirrors},
          'mirror-only!' => \$self->{mirror_only},
          'mirror-index=s' => sub { $self->{mirror_index} = $self->maybe_abs($_[1]) },
          'M|from=s' => sub {
              $self->{mirrors}     = [$_[1]];
              $self->{mirror_only} = 1;
          },
          'cpanmetadb=s'    => \$self->{cpanmetadb},
          'cascade-search!' => \$self->{cascade_search},
          'prompt!'   => \$self->{prompt},
          'installdeps' => \$self->{installdeps},
          'skip-installed!' => \$self->{skip_installed},
          'skip-satisfied!' => \$self->{skip_satisfied},
          'reinstall'    => sub { $self->{skip_installed} = 0 },
          'interactive!' => \$self->{interactive},
          'i|install'    => sub { $self->{cmd} = 'install' },
          'info'         => sub { $self->{cmd} = 'info' },
          'look'         => sub { $self->{cmd} = 'look'; $self->{skip_installed} = 0 },
          'U|uninstall'  => sub { $self->{cmd} = 'uninstall' },
          'self-upgrade' => sub { $self->{action} = 'self_upgrade' },
          'uninst-shadows!'  => \$self->{uninstall_shadows},
          'lwp!'    => \$self->{try_lwp},
          'wget!'   => \$self->{try_wget},
          'curl!'   => \$self->{try_curl},
          'auto-cleanup=s' => \$self->{auto_cleanup},
          'man-pages!' => \$self->{pod2man},
          'scandeps'   => \$self->{scandeps},
          'showdeps'   => sub { $self->{showdeps} = 1; $self->{skip_installed} = 0 },
          'format=s'   => \$self->{format},
          'save-dists=s' => sub {
              $self->{save_dists} = $self->maybe_abs($_[1]);
          },
          'skip-configure!' => \$self->{skip_configure},
          'dev!'       => \$self->{dev_release},
          'metacpan!'  => \$self->{metacpan},
          'report-perl-version!' => \$self->{report_perl_version},
          'configure-timeout=i' => \$self->{configure_timeout},
          'build-timeout=i' => \$self->{build_timeout},
          'test-timeout=i' => \$self->{test_timeout},
          'with-develop' => \$self->{with_develop},
          'without-develop' => sub { $self->{with_develop} = 0 },
          'with-configure' => \$self->{with_configure},
          'without-configure' => sub { $self->{with_configure} = 0 },
          'with-feature=s' => sub { $self->{features}{$_[1]} = 1 },
          'without-feature=s' => sub { $self->{features}{$_[1]} = 0 },
          'with-all-features' => sub { $self->{features}{__all} = 1 },
          'pp|pureperl!' => \$self->{pure_perl},
          "cpanfile=s" => \$self->{cpanfile_path},
          $self->install_type_handlers,
          $self->build_args_handlers,
      );
  
      if (!@ARGV && $0 ne '-' && !-t STDIN){ # e.g. # cpanm < author/requires.cpanm
          push @ARGV, $self->load_argv_from_fh(\*STDIN);
          $self->{load_from_stdin} = 1;
      }
  
      $self->{argv} = \@ARGV;
  }
  
  sub check_upgrade {
      my $self = shift;
      my $install_base = $ENV{PERL_LOCAL_LIB_ROOT} ? $self->local_lib_target($ENV{PERL_LOCAL_LIB_ROOT}) : $Config{installsitebin};
      if ($0 eq '-') {
          # run from curl, that's fine
          return;
      } elsif ($0 !~ /^$install_base/) {
          if ($0 =~ m!perlbrew/bin!) {
              die <<DIE;
  It appears your cpanm executable was installed via `perlbrew install-cpanm`.
  cpanm --self-upgrade won't upgrade the version of cpanm you're running.
  
  Run the following command to get it upgraded.
  
    perlbrew install-cpanm
  
  DIE
          } else {
              die <<DIE;
  You are running cpanm from the path where your current perl won't install executables to.
  Because of that, cpanm --self-upgrade won't upgrade the version of cpanm you're running.
  
    cpanm path   : $0
    Install path : $Config{installsitebin}
  
  It means you either installed cpanm globally with system perl, or use distro packages such
  as rpm or apt-get, and you have to use them again to upgrade cpanm.
  DIE
          }
      }
  }
  
  sub check_libs {
      my $self = shift;
      return if $self->{_checked}++;
      $self->bootstrap_local_lib;
  }
  
  sub setup_verify {
      my $self = shift;
  
      my $has_modules = eval { require Module::Signature; require Digest::SHA; 1 };
      $self->{cpansign} = which('cpansign');
  
      unless ($has_modules && $self->{cpansign}) {
          warn "WARNING: Module::Signature and Digest::SHA is required for distribution verifications.\n";
          $self->{verify} = 0;
      }
  }
  
  sub parse_module_args {
      my($self, $module) = @_;
  
      # Plack@1.2 -> Plack~"==1.2"
      # BUT don't expand @ in git URLs
      $module =~ s/^([A-Za-z0-9_:]+)@([v\d\._]+)$/$1~== $2/;
  
      # Plack~1.20, DBI~"> 1.0, <= 2.0"
      if ($module =~ /\~[v\d\._,\!<>= ]+$/) {
          return split '~', $module, 2;
      } else {
          return $module, undef;
      }
  }
  
  sub run {
      my $self = shift;
  
      my $code;
      eval {
          $code = ($self->_doit == 0);
      }; if (my $e = $@) {
          warn $e;
          $code = 1;
      }
  
      $self->{status} = $code;
  }
  
  sub status {
      $_[0]->{status};
  }
  
  sub _doit {
      my $self = shift;
  
      $self->setup_home;
      $self->init_tools;
      $self->setup_verify if $self->{verify};
  
      if (my $action = $self->{action}) {
          $self->$action() and return 1;
      }
  
      return $self->show_help(1)
          unless @{$self->{argv}} or $self->{load_from_stdin};
  
      $self->configure_mirrors;
  
      my $cwd = Cwd::cwd;
  
      my @fail;
      for my $module (@{$self->{argv}}) {
          if ($module =~ s/\.pm$//i) {
              my ($volume, $dirs, $file) = File::Spec->splitpath($module);
              $module = join '::', grep { $_ } File::Spec->splitdir($dirs), $file;
          }
          ($module, my $version) = $self->parse_module_args($module);
  
          $self->chdir($cwd);
          if ($self->{cmd} eq 'uninstall') {
              $self->uninstall_module($module)
                or push @fail, $module;
          } else {
              $self->install_module($module, 0, $version)
                  or push @fail, $module;
          }
      }
  
      if ($self->{base} && $self->{auto_cleanup}) {
          $self->cleanup_workdirs;
      }
  
      if ($self->{installed_dists}) {
          my $dists = $self->{installed_dists} > 1 ? "distributions" : "distribution";
          $self->diag("$self->{installed_dists} $dists installed\n", 1);
      }
  
      if ($self->{scandeps}) {
          $self->dump_scandeps();
      }
      # Workaround for older File::Temp's
      # where creating a tempdir with an implicit $PWD
      # causes tempdir non-cleanup if $PWD changes
      # as paths are stored internally without being resolved
      # absolutely.
      # https://rt.cpan.org/Public/Bug/Display.html?id=44924
      $self->chdir($cwd);
  
      return !@fail;
  }
  
  sub setup_home {
      my $self = shift;
  
      $self->{home} = $self->env('HOME') if $self->env('HOME');
  
      unless (_writable($self->{home})) {
          die "Can't write to cpanm home '$self->{home}': You should fix it with chown/chmod first.\n";
      }
  
      $self->{base} = "$self->{home}/work/" . time . ".$$";
      File::Path::mkpath([ $self->{base} ], 0, 0777);
  
      # native path because we use shell redirect
      $self->{log} = File::Spec->catfile($self->{base}, "build.log");
      my $final_log = "$self->{home}/build.log";
  
      { open my $out, ">$self->{log}" or die "$self->{log}: $!" }
  
      if (CAN_SYMLINK) {
          my $build_link = "$self->{home}/latest-build";
          unlink $build_link;
          symlink $self->{base}, $build_link;
  
          unlink $final_log;
          symlink $self->{log}, $final_log;
      } else {
          my $log = $self->{log}; my $home = $self->{home};
          $self->{at_exit} = sub {
              my $self = shift;
              my $temp_log = "$home/build.log." . time . ".$$";
              File::Copy::copy($log, $temp_log)
                  && unlink($final_log);
              rename($temp_log, $final_log);
          }
      }
  
      $self->chat("cpanm (Menlo) $VERSION on perl $] built for $Config{archname}\n" .
                  "Work directory is $self->{base}\n");
  }
  
  sub search_mirror_index_local {
      my ($self, $local, $module, $version) = @_;
      require CPAN::Common::Index::LocalPackage;
      my $index = CPAN::Common::Index::LocalPackage->new({ source => $local });
      $self->search_common($index, { package => $module }, $version);
  }
  
  sub search_mirror_index {
      my ($self, $mirror, $module, $version) = @_;
      require Menlo::Index::Mirror;
      my $index = Menlo::Index::Mirror->new({
          mirror => $mirror,
          cache => $self->source_for($mirror),
          fetcher => sub { $self->mirror(@_) },
      });
      $self->search_common($index, { package => $module }, $version);
  }
  
  sub search_common {
      my($self, $index, $search_args, $want_version) = @_;
  
      $index->refresh_index;
  
      my $found = $index->search_packages($search_args);
      $found = $self->cpan_module_common($found) if $found;
  
      return $found unless $self->{cascade_search};
  
      if ($found) {
          if ($self->satisfy_version($found->{module}, $found->{module_version}, $want_version)) {
              return $found;
          } else {
              $self->chat("Found $found->{module} $found->{module_version} which doesn't satisfy $want_version.\n");
          }
      }
      
      return;
  }
  
  sub with_version_range {
      my($self, $version) = @_;
      defined($version) && $version =~ /(?:<|!=|==)/;
  }
  
  # version->new("1.00_00")->numify => "1.00_00" :/
  sub numify_ver {
      my($self, $ver) = @_;
      eval version->new($ver)->numify;
  }
  
  sub search_metacpan {
      my($self, $module, $version, $dev_release) = @_;
  
      require Menlo::Index::MetaCPAN;
      $self->chat("Searching $module ($version) on metacpan ...\n");
  
      my $index = Menlo::Index::MetaCPAN->new({ include_dev => $self->{dev_release} });
      my $pkg = $self->search_common($index, { package => $module, version_range => $version }, $version);
      return $pkg if $pkg;
  
      $self->diag_fail("Finding $module ($version) on metacpan failed.");
      return;
  }
  
  sub search_database {
      my($self, $module, $version) = @_;
  
      my $found;
  
      if ($self->{dev_release} or $self->{metacpan}) {
          $found = $self->search_metacpan($module, $version, $self->{dev_release})   and return $found;
          $found = $self->search_cpanmetadb($module, $version, $self->{dev_release}) and return $found;
      } else {
          $found = $self->search_cpanmetadb($module, $version) and return $found;
          $found = $self->search_metacpan($module, $version)   and return $found;
      }
  }
  
  sub search_cpanmetadb {
      my($self, $module, $version, $dev_release) = @_;
  
      require Menlo::Index::MetaDB;
      $self->chat("Searching $module ($version) on cpanmetadb ...\n");
  
      my $args = { package => $module };
      if ($self->with_version_range($version)) {
          $args->{version_range} = $version;
      }
  
      my $index = Menlo::Index::MetaDB->new({ uri => $self->{cpanmetadb} });
      my $pkg = $self->search_common($index, $args, $version);
      return $pkg if $pkg;
  
      $self->diag_fail("Finding $module on cpanmetadb failed.");
      return;
  }
  
  sub search_module {
      my($self, $module, $version) = @_;
  
      if ($self->{mirror_index}) {
          $self->mask_output( chat => "Searching $module on mirror index $self->{mirror_index} ...\n" );
          my $pkg = $self->search_mirror_index_local($self->{mirror_index}, $module, $version);
          return $pkg if $pkg;
  
          unless ($self->{cascade_search}) {
             $self->mask_output( diag_fail => "Finding $module ($version) on mirror index $self->{mirror_index} failed." );
             return;
          }
      }
  
      unless ($self->{mirror_only}) {
          my $found = $self->search_database($module, $version);
          return $found if $found;
      }
  
      MIRROR: for my $mirror (@{ $self->{mirrors} }) {
          $self->mask_output( chat => "Searching $module on mirror $mirror ...\n" );
  
          my $pkg = $self->search_mirror_index($mirror, $module, $version);
          return $pkg if $pkg;
  
          $self->mask_output( diag_fail => "Finding $module ($version) on mirror $mirror failed." );
      }
  
      return;
  }
  
  sub source_for {
      my($self, $mirror) = @_;
      $mirror =~ s/[^\w\.\-]+/%/g;
  
      my $dir = "$self->{home}/sources/$mirror";
      File::Path::mkpath([ $dir ], 0, 0777);
  
      return $dir;
  }
  
  sub load_argv_from_fh {
      my($self, $fh) = @_;
  
      my @argv;
      while(defined(my $line = <$fh>)){
          chomp $line;
          $line =~ s/#.+$//; # comment
          $line =~ s/^\s+//; # trim spaces
          $line =~ s/\s+$//; # trim spaces
  
          push @argv, split ' ', $line if $line;
      }
      return @argv;
  }
  
  sub show_version {
      my $self = shift;
  
      print "cpanm (Menlo) version $VERSION ($0)\n";
      print "perl version $] ($^X)\n\n";
  
      print "  \%Config:\n";
      for my $key (qw( archname installsitelib installsitebin installman1dir installman3dir
                       sitearchexp sitelibexp vendorarch vendorlibexp archlibexp privlibexp )) {
          print "    $key=$Config{$key}\n" if $Config{$key};
      }
  
      print "  \%ENV:\n";
      for my $key (grep /^PERL/, sort keys %ENV) {
          print "    $key=$ENV{$key}\n";
      }
  
      print "  \@INC:\n";
      for my $inc (@INC) {
          print "    $inc\n" unless ref($inc) eq 'CODE';
      }
  
      return 1;
  }
  
  sub show_help {
      my $self = shift;
  
      if ($_[0]) {
          print <<USAGE;
  Usage: cpanm [options] Module [...]
  
  Try `cpanm --help` or `man cpanm` for more options.
  USAGE
          return;
      }
  
      print <<HELP;
  Usage: cpanm [options] Module [...]
  
  Options:
    -v,--verbose              Turns on chatty output
    -q,--quiet                Turns off the most output
    --interactive             Turns on interactive configure (required for Task:: modules)
    -f,--force                force install
    -n,--notest               Do not run unit tests
    --test-only               Run tests only, do not install
    -S,--sudo                 sudo to run install commands
    --installdeps             Only install dependencies
    --showdeps                Only display direct dependencies
    --reinstall               Reinstall the distribution even if you already have the latest version installed
    --mirror                  Specify the base URL for the mirror (e.g. http://cpan.cpantesters.org/)
    --mirror-only             Use the mirror's index file instead of the CPAN Meta DB
    -M,--from                 Use only this mirror base URL and its index file
    --prompt                  Prompt when configure/build/test fails
    -l,--local-lib            Specify the install base to install modules
    -L,--local-lib-contained  Specify the install base to install all non-core modules
    --self-contained          Install all non-core modules, even if they're already installed.
    --auto-cleanup            Number of days that cpanm's work directories expire in. Defaults to 7
  
  Commands:
    --self-upgrade            upgrades itself
    --info                    Displays distribution info on CPAN
    --look                    Opens the distribution with your SHELL
    -U,--uninstall            Uninstalls the modules (EXPERIMENTAL)
    -V,--version              Displays software version
  
  Examples:
  
    cpanm Test::More                                          # install Test::More
    cpanm MIYAGAWA/Plack-0.99_05.tar.gz                       # full distribution path
    cpanm http://example.org/LDS/CGI.pm-3.20.tar.gz           # install from URL
    cpanm ~/dists/MyCompany-Enterprise-1.00.tar.gz            # install from a local file
    cpanm --interactive Task::Kensho                          # Configure interactively
    cpanm .                                                   # install from local directory
    cpanm --installdeps .                                     # install all the deps for the current directory
    cpanm -L extlib Plack                                     # install Plack and all non-core deps into extlib
    cpanm --mirror http://cpan.cpantesters.org/ DBI           # use the fast-syncing mirror
    cpanm -M https://cpan.metacpan.org App::perlbrew          # use only this secure mirror and its index
  
  You can also specify the default options in PERL_CPANM_OPT environment variable in the shell rc:
  
    export PERL_CPANM_OPT="--prompt --reinstall -l ~/perl --mirror http://cpan.cpantesters.org"
  
  Type `man cpanm` or `perldoc cpanm` for the more detailed explanation of the options.
  
  HELP
  
      return 1;
  }
  
  sub _writable {
      my $dir = shift;
      my @dir = File::Spec->splitdir($dir);
      while (@dir) {
          $dir = File::Spec->catdir(@dir);
          if (-e $dir) {
              return -w _;
          }
          pop @dir;
      }
  
      return;
  }
  
  sub maybe_abs {
      my($self, $lib) = @_;
      if ($lib eq '_' or $lib =~ /^~/ or File::Spec->file_name_is_absolute($lib)) {
          return $lib;
      } else {
          return File::Spec->canonpath(File::Spec->catdir(Cwd::cwd(), $lib));
      }
  }
  
  sub local_lib_target {
      my($self, $root) = @_;
      # local::lib 1.008025 changed the order of PERL_LOCAL_LIB_ROOT
      (grep { $_ ne '' } split /\Q$Config{path_sep}/, $root)[0];
  }
  
  sub bootstrap_local_lib {
      my $self = shift;
  
      # If -l is specified, use that.
      if ($self->{local_lib}) {
          return $self->setup_local_lib($self->{local_lib});
      }
  
      # PERL_LOCAL_LIB_ROOT is defined. Run as local::lib mode without overwriting ENV
      if ($ENV{PERL_LOCAL_LIB_ROOT} && $ENV{PERL_MM_OPT}) {
          return $self->setup_local_lib($self->local_lib_target($ENV{PERL_LOCAL_LIB_ROOT}), 1);
      }
  
      # root, locally-installed perl or --sudo: don't care about install_base
      return if $self->{sudo} or (_writable($Config{installsitelib}) and _writable($Config{installsitebin}));
  
      # local::lib is configured in the shell -- yay
      if ($ENV{PERL_MM_OPT} and ($ENV{MODULEBUILDRC} or $ENV{PERL_MB_OPT})) {
          return;
      }
  
      $self->setup_local_lib;
  
      $self->diag(<<DIAG, 1);
  !
  ! Can't write to $Config{installsitelib} and $Config{installsitebin}: Installing modules to $ENV{HOME}/perl5
  ! To turn off this warning, you have to do one of the following:
  !   - run me as a root or with --sudo option (to install to $Config{installsitelib} and $Config{installsitebin})
  !   - Configure local::lib in your existing shell to set PERL_MM_OPT etc.
  !   - Install local::lib by running the following commands
  !
  !         cpanm --local-lib=~/perl5 local::lib && eval \$(perl -I ~/perl5/lib/perl5/ -Mlocal::lib)
  !
  DIAG
      sleep 2;
  }
  
  sub upgrade_toolchain {
      my($self, $config_deps) = @_;
  
      my %deps = map { $_->module => $_ } @$config_deps;
  
      # M::B 0.38 and EUMM 6.58 for MYMETA
      # EU::Install 1.46 for local::lib
      my $reqs = CPAN::Meta::Requirements->from_string_hash({
          'Module::Build' => '0.38',
          'ExtUtils::MakeMaker' => '6.58',
          'ExtUtils::Install' => '1.46',
      });
  
      if ($deps{"ExtUtils::MakeMaker"}) {
          $deps{"ExtUtils::MakeMaker"}->merge_with($reqs);
      } elsif ($deps{"Module::Build"}) {
          $deps{"Module::Build"}->merge_with($reqs);
          $deps{"ExtUtils::Install"} ||= Menlo::Dependency->new("ExtUtils::Install", 0, 'configure');
          $deps{"ExtUtils::Install"}->merge_with($reqs);
      }
  
      @$config_deps = values %deps;
  }
  
  sub _core_only_inc {
      my($self, $base) = @_;
      require local::lib;
      (
          local::lib->resolve_path(local::lib->install_base_arch_path($base)),
          local::lib->resolve_path(local::lib->install_base_perl_path($base)),
          (!$self->{exclude_vendor} ? grep {$_} @Config{qw(vendorarch vendorlibexp)} : ()),
          @Config{qw(archlibexp privlibexp)},
      );
  }
  
  sub _setup_local_lib_env {
      my($self, $base) = @_;
 