# Generated by default/object.tt
package Paws::Route53::DNSSECStatus;
  use Moose;
  has ServeSignature => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Route53::DNSSECStatus

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Route53::DNSSECStatus object:

  $service_obj->Method(Att1 => { ServeSignature => $value, ..., StatusMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Route53::DNSSECStatus object:

  $result = $service_obj->Method(...);
  $result->Att1->ServeSignature

=head1 DESCRIPTION

A string repesenting the status of DNSSEC signing.

=head1 ATTRIBUTES


=head2 ServeSignature => Str

A string that represents the current hosted zone signing status.

Status can have one of the following values:

=over

=item SIGNING

DNSSEC signing is enabled for the hosted zone.

=item NOT_SIGNING

DNSSEC signing is not enabled for the hosted zone.

=item DELETING

DNSSEC signing is in the process of being removed for the hosted zone.

=item ACTION_NEEDED

There is a problem with signing in the hosted zone that requires you to
take action to resolve. For example, the customer managed customer
master key (CMK) might have been deleted, or the permissions for the
customer managed CMK might have been changed.

=item INTERNAL_FAILURE

There was an error during a request. Before you can continue to work
with DNSSEC signing, including with key-signing keys (KSKs), you must
correct the problem by enabling or disabling DNSSEC signing for the
hosted zone.

=back



=head2 StatusMessage => Str

The status message provided for the following DNSSEC signing status:
C<INTERNAL_FAILURE>. The status message includes information about what
the problem might be and steps that you can take to correct the issue.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Route53>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

