package CXC::Astro::Regions;

# ABSTRACT: Astronomical region support

use v5.20;
use strict;
use warnings;

our $VERSION = '0.03';

1;

#
# This file is part of CXC-Astro-Regions
#
# This software is Copyright (c) 2023 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory

=head1 NAME

CXC::Astro::Regions - Astronomical region support

=head1 VERSION

version 0.03

=head1 DESCRIPTION

B<CXC::Astro::Regions> provides support for specifying and
manipulating descriptions of regions used in astronomical software.

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-cxc-astro-regions@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=CXC-Astro-Regions>

=head2 Source

Source is available at

  https://gitlab.com/djerius/cxc-astro-regions

and may be cloned from

  https://gitlab.com/djerius/cxc-astro-regions.git

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<CXC::Astro::Regions::DS9|CXC::Astro::Regions::DS9>

=item *

L<CXC::Astro::Regions::CIAO|CXC::Astro::Regions::CIAO>

=item *

L<CXC::Astro::Regions::CFITSIO|CXC::Astro::Regions::CFITSIO>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2023 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
