use strict;
use warnings;
use Test::More;
use lib "../lib/";
use Finance::Math::IRR;

eval "use Date::Calc qw(Add_Delta_Days);";
plan skip_all => "Date::Calc required for testing continuity" if $@;

plan tests => 173;

#
# this is a real-life cashflow extracted from PPM's production database
#

my %cashflow = (
		"1995-01-28" => 8566.66666666667,
		"1995-02-28" => 8566.66666666667,
		"1995-03-28" => 8566.66666666667,
		"1995-04-28" => 8566.66666666667,
		"1995-05-28" => 8566.66666666667,
		"1995-06-28" => 8566.66666666667,
		"1995-07-28" => 8566.66666666667,
		"1995-08-28" => 8566.66666666667,
		"1995-09-28" => 8566.66666666667,
		"1995-10-28" => 8566.66666666667,
		"1995-11-28" => 8566.66666666667,
		"1995-12-28" => 8566.66666666667,
		"1996-01-28" => 7847.66666666667,
		"1996-02-28" => 7847.66666666667,
		"1996-03-28" => 7847.66666666667,
		"1996-04-28" => 7847.66666666667,
		"1996-05-28" => 7847.66666666667,
		"1996-06-28" => 7847.66666666667,
		"1996-07-28" => 7847.66666666667,
		"1996-08-28" => 7847.66666666667,
		"1996-09-28" => 7847.66666666667,
		"1996-10-28" => 7847.66666666667,
		"1996-11-28" => 7847.66666666667,
		"1996-12-28" => 7847.66666666667,
		"1997-01-28" => 9250,
		"1997-02-28" => 9250,
		"1997-03-28" => 9250,
		"1997-04-28" => 9250,
		"1997-05-28" => 9250,
		"1997-06-28" => 9250,
		"1997-07-28" => 9250,
		"1997-08-28" => 9250,
		"1997-09-28" => 9250,
		"1997-10-28" => 9250,
		"1997-11-28" => 9250,
		"1997-12-28" => 9250,
		"1998-01-28" => 9250,
		"1998-02-28" => 9250,
		"1998-03-28" => 9250,
		"1998-04-28" => 9250,
		"1998-05-28" => 9250,
		"1998-06-28" => 9250,
		"1998-07-28" => 9250,
		"1998-08-28" => 9250,
		"1998-09-28" => 9250,
		"1998-10-28" => 9250,
		"1998-11-28" => 9250,
		"1998-12-28" => 9250,
		"1999-01-28" => 9250,
		"1999-02-28" => 9250,
		"1999-03-28" => 9250,
		"1999-04-28" => 9250,
		"1999-05-28" => 9250,
		"1999-06-28" => 9250,
		"1999-07-28" => 9250,
		"1999-08-28" => 9250,
		"1999-09-28" => 9250,
		"1999-10-28" => 9250,
		"1999-11-28" => 9250,
		"1999-12-28" => 9250,
		"2001-03-15" => -2500,
		"2001-04-19" => -3000,
		"2001-05-17" => -3000,
		"2001-06-14" => -3000,
		);

# last market value and its date
my $mv = -980430;
my $date = '2001-07-12';

my $previous_irr = xirr(%cashflow, $date => $mv, precision => 0.00001);

# compute xirr between 2001-12-31 and 2002-08-18
# those limits are quite arbitrary. change them as you wish.
while ($date lt '2002-01-01') {

    # move on one day into the future
    $date = sprintf("%04d-%02d-%02d", Add_Delta_Days(split(/-/,$date),+1));

    # compute the irr on $date, with the same amount in last transaction
    my $irr = xirr(%cashflow, $date => $mv, precision => 0.00001);
    my $delta = abs($irr-$previous_irr)/$irr;

    ok( $delta < 0.0007, "$date: delta since yesterday is $delta < 0.0007");

    $previous_irr = $irr;
}
