/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.utils.configuration;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Ordering;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.openqa.grid.common.GridConfiguredJson;
import org.openqa.grid.common.exception.GridConfigurationException;
import org.openqa.grid.internal.cli.CommonCliOptions;
import org.openqa.grid.internal.cli.StandaloneCliOptions;
import org.openqa.grid.internal.utils.configuration.json.CommonJsonConfiguration;
import org.openqa.grid.internal.utils.configuration.json.StandaloneJsonConfiguration;
import org.openqa.selenium.grid.config.ConfigValue;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.json.JsonInput;
import org.openqa.selenium.json.TypeCoercer;

public class StandaloneConfiguration {
    public static final String DEFAULT_STANDALONE_CONFIG_FILE = "org/openqa/grid/common/defaults/DefaultStandalone.json";
    private static StandaloneJsonConfiguration DEFAULT_CONFIG_FROM_JSON = StandaloneJsonConfiguration.loadFromResourceOrFile("org/openqa/grid/common/defaults/DefaultStandalone.json");
    @VisibleForTesting
    static final String ROLE = "standalone";
    private boolean avoidProxy;
    private boolean browserSideLog;
    private boolean captureLogsOnQuit;
    public Integer browserTimeout;
    public Boolean debug;
    @ConfigValue(section="server", name="max-threads")
    public Integer jettyMaxThreads;
    public String log;
    @ConfigValue(section="server", name="hostname")
    public String host;
    @ConfigValue(section="server", name="port")
    public Integer port;
    public String role = "standalone";
    public Integer timeout;

    public StandaloneConfiguration() {
        this(DEFAULT_CONFIG_FROM_JSON);
    }

    public StandaloneConfiguration(CommonJsonConfiguration jsonConfig) {
        this.debug = jsonConfig.getDebug();
        this.log = jsonConfig.getLog();
        this.host = Optional.ofNullable(jsonConfig.getHost()).orElse("0.0.0.0");
        this.port = jsonConfig.getPort();
        this.timeout = jsonConfig.getTimeout();
        this.browserTimeout = jsonConfig.getBrowserTimeout();
        this.jettyMaxThreads = jsonConfig.getJettyMaxThreads();
    }

    public StandaloneConfiguration(StandaloneCliOptions cliConfig) {
        this(Optional.ofNullable(cliConfig.getConfigFile()).map(StandaloneJsonConfiguration::loadFromResourceOrFile).orElse(DEFAULT_CONFIG_FROM_JSON));
        this.merge(cliConfig.getCommonOptions());
    }

    void merge(CommonCliOptions cliConfig) {
        Optional.ofNullable(cliConfig.getDebug()).ifPresent(v -> {
            this.debug = v;
        });
        Optional.ofNullable(cliConfig.getLog()).ifPresent(v -> {
            this.log = v;
        });
        Optional.ofNullable(cliConfig.getHost()).ifPresent(v -> {
            this.host = v;
        });
        Optional.ofNullable(cliConfig.getPort()).ifPresent(v -> {
            this.port = v;
        });
        Optional.ofNullable(cliConfig.getTimeout()).ifPresent(v -> {
            this.timeout = v;
        });
        Optional.ofNullable(cliConfig.getBrowserTimeout()).ifPresent(v -> {
            this.browserTimeout = v;
        });
        Optional.ofNullable(cliConfig.getJettyMaxThreads()).ifPresent(v -> {
            this.jettyMaxThreads = v;
        });
    }

    public static <T extends StandaloneConfiguration> T loadFromJson(String resource, Class<T> type) {
        try (JsonInput jsonInput = StandaloneConfiguration.loadJsonFromResourceOrFile(resource);){
            T t = StandaloneConfiguration.loadFromJson(jsonInput, type);
            return t;
        }
    }

    public static <T extends StandaloneConfiguration> T loadFromJson(JsonInput jsonInput, Class<T> type) {
        try {
            return (T)((StandaloneConfiguration)GridConfiguredJson.toType(jsonInput, type));
        }
        catch (GridConfigurationException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new GridConfigurationException(e.getMessage(), e);
        }
    }

    protected Collection<TypeCoercer<?>> getCoercers() {
        return ImmutableSet.of();
    }

    public void merge(StandaloneConfiguration other) {
        if (other == null) {
            return;
        }
        if (this.isMergeAble(Integer.class, other.browserTimeout, this.browserTimeout)) {
            this.browserTimeout = other.browserTimeout;
        }
        if (this.isMergeAble(Integer.class, other.jettyMaxThreads, this.jettyMaxThreads)) {
            this.jettyMaxThreads = other.jettyMaxThreads;
        }
        if (this.isMergeAble(Integer.class, other.timeout, this.timeout)) {
            this.timeout = other.timeout;
        }
    }

    protected boolean isMergeAble(Class<?> targetType, Object other, Object target) {
        if (other == null) {
            return false;
        }
        if (target == null) {
            return true;
        }
        if (!targetType.isAssignableFrom(target.getClass()) || !targetType.isAssignableFrom(other.getClass())) {
            return false;
        }
        if (target instanceof Collection) {
            return !((Collection)other).isEmpty();
        }
        if (target instanceof Map) {
            return !((Map)other).isEmpty();
        }
        return true;
    }

    public String toString(String format) {
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.toString(format, "browserTimeout", this.browserTimeout));
        sb.append((CharSequence)this.toString(format, "debug", this.debug));
        sb.append((CharSequence)this.toString(format, "jettyMaxThreads", this.jettyMaxThreads));
        sb.append((CharSequence)this.toString(format, "log", this.log));
        sb.append((CharSequence)this.toString(format, "host", this.host));
        sb.append((CharSequence)this.toString(format, "port", this.port));
        sb.append((CharSequence)this.toString(format, "role", this.role));
        sb.append((CharSequence)this.toString(format, "timeout", this.timeout));
        return sb.toString();
    }

    public String toString() {
        return this.toString(" -%1$s %2$s");
    }

    public StringBuilder toString(String format, String name, Object value) {
        StringBuilder sb = new StringBuilder();
        List<Object> iterator = value instanceof List ? (List<Object>)value : Arrays.asList(value);
        for (Object e : iterator) {
            if (e == null || e instanceof Map && ((Map)e).isEmpty() || e instanceof Collection && ((Collection)e).isEmpty()) continue;
            sb.append(String.format(format, name, e));
        }
        return sb;
    }

    public Map<String, Object> toJson() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("browserTimeout", this.browserTimeout);
        json.put("debug", this.debug);
        json.put("jettyMaxThreads", this.jettyMaxThreads);
        json.put("log", this.log);
        json.put("host", this.host);
        json.put("port", this.port);
        json.put("role", this.role);
        json.put("timeout", this.timeout);
        this.serializeFields(json);
        return json.entrySet().stream().filter(entry -> entry.getValue() != null).collect(ImmutableSortedMap.toImmutableSortedMap(Ordering.natural(), Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void serializeFields(Map<String, Object> appendTo) {
    }

    protected static JsonInput loadJsonFromResourceOrFile(String resource) {
        try {
            return new Json().newInput(StandaloneConfiguration.readFileOrResource(resource));
        }
        catch (RuntimeException e) {
            throw new GridConfigurationException("Unable to read input", e);
        }
    }

    private static Reader readFileOrResource(String resource) {
        Stream<Function> suppliers = Stream.of(path -> {
            try {
                return new FileInputStream((String)path);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }, path -> Thread.currentThread().getContextClassLoader().getResourceAsStream("org/openqa/grid/common/" + path), path -> Thread.currentThread().getContextClassLoader().getResourceAsStream((String)path), path -> new ByteArrayInputStream(path.getBytes()));
        InputStream in = suppliers.map(supplier -> (InputStream)supplier.apply(resource)).filter(Objects::nonNull).findFirst().orElseThrow(() -> new RuntimeException(resource + " is not a valid resource."));
        return new BufferedReader(new InputStreamReader(in));
    }
}

