#!/usr/bin/env perl

use Test::Most;
use Test::Files;

use autodie;
use Modern::Perl;

use Smart::Comments;

use Path::Class qw(file);

use Bio::MUST::Apps::HmmCleaner;

say 'Note: tests designed for: HMMER 3.3.2 (Nov 2020); http://hmmer.org/';

my $class = 'Bio::MUST::Apps::HmmCleaner::Cleaner';

# Needed elements for cleaner objetc

my $scoreseq = '                                                       gs+g+g++g+g     sggdparpglsqqqrasqrkaqvr+lprakkleklgvfsackane+ckcngwknp+pptaprmdlqqpaa+lse crsc+h+ladhvshlenvse+einrllgmvvdvenlfmsvhkeedtdtkqvyfylfkllrkcilqm++pvvegslgsppfekpnieqgvlnfvqykfshl+p+erqtm+elskmfllclnywkletp+qfrqrsq++dva+ykvnytrwlcychvpqscdslpryett+vfgrsllrsiftvtrrqllekfrvekdklvpekrtlilthfpkflsmleeeiyg nspiwe++ftmp+segtql++rpa vs+++vps+p+fs++++ggs+ss+s+ds g+ep+pgekr lpe+ltledakr+rvmgdipmelvnevmltitdpaamlgpetsllsanaardetarleerrgiiefhvignsl++k+n+++l+wlvglqnvfshqlprmpkeyi+rlvfdpkhktlalikdgrviggicfrmfptqgfteivfcavtsneqvkgygthlmnhlkeyhikhnilyfltyadeyaigyfkkqgfskdikvpksrylgyikdyegatlmecelnpripytelshiikkqkeiikklierkqaqirkvypglscfkegvrqip+es+pgiretgwkplgkekgkelkdpdqly+tlknllaqikshpsawpfmepvkkseapdyyevirfpidlktmterl++ryyvt+klf+adlqrvi+ncreynpp+seyc+ca++lekffyfklke+glidk';

my $seq_id = Bio::MUST::Core::SeqId->new( full_id => 'Homo sapiens@ENSP00000225916');
my $seq = Bio::MUST::Core::Seq->new( seq => 'MAE********PSQAPTPAPAAQPRPLQSPAPAPTPTPAPSPASAPIPTPTPAPAPAPAAAPAGSTGTGGPGVGSGGAG*******SGGDPARPGLSQQQ**RASQRKAQVRGLPRAKKLEKLGVFSACKANETCKCNGWKNPK*****P*PTAPRMDLQQPAANLSELCRSCEHPLA*DHVSH*LENVSEDEINRLLGMVVDVENLFMSV***HKEEDTDTKQVY*FYLFKLLRKCILQMTRPVVEGSLG*SPPFEKPNIEQ**GVLNFVQYKFSHLAPRERQTMFELSKMFLLCLNYWKLETPAQFRQRSQAEDVATYKVNYTRWLCYCHVPQSCDSLPRYETTHVFGRSLLRSIFTVTRRQLLEKFRVEKDKLVPEKRTLILTHFPKFLSMLEEEIYGANSPIWESGFTMPPSEGT*QLVP********RPA**SVSAAVVPSTPIFSPSMGGGSN******SS***LSLDSAGAE****************PMP*******************************GEKRTLPENLTLEDAKRLRVMGDIPMELVNEVMLTITDPAAMLGPE*TSLLSANAARDETARLEERRGIIEFHVIGNSLTPKANRRVLLWLVGLQNVFSHQLPRMPKEYIARLVFDPKHKTLALIKDGRVIGGICFRMFP****TQGFTEIVFCAVTSNEQVKGYGTHLMNHLKEYHIKHNILYFL*TYADEYAIGYFKKQGFSKDIKVPKSRYLGYIKDYEGATLMECELNPRIPYTELSHIIKKQKEIIKKLIERKQAQIRKVYPGLSC*FKEGVRQIPVESVPGI*RETGWKPLGKEKGKELKDPDQLYTTLKNLLAQI*K**SHPSAWPFMEPVKKSEAPDYYEVIRFPI***DLKTMTERLRSRYYVTRKLFVADLQRVIANCREYNPPDSEYCRCASALEKFFYFKLKEGGLIDK', seq_id => $seq_id);

my %costs_values = (
    'default'       => [-0.15, -0.08, 0.15, 0.45],
    'large'         => [-0.175, -0.04, 0.15, 0.4],
    'specificity'   => [-0.125, -0.07, 0.175, 0.4],
    'large_specificity'   => [-0.125, -0.03, 0.15, 0.4],
);

my $cleaner = $class->new(
    'seq'           => $seq,
    'score'         => $scoreseq,
    'costs'         => $costs_values{'default'},
    'threshold'     => 1,
    'delchar'       => ' ',
);

my $expected_result = '                                                                                      SGGDPARPGLSQQQ**RASQRKAQVRGLPRAKKLEKLGVFSACKANETCKCNGWKNPK*****P*PTAPRMDLQQPAANLSELCRSCEHPLA*DHVSH*LENVSEDEINRLLGMVVDVENLFMSV***HKEEDTDTKQVY*FYLFKLLRKCILQMTRPVVEGSLG*SPPFEKPNIEQ**GVLNFVQYKFSHLAPRERQTMFELSKMFLLCLNYWKLETPAQFRQRSQAEDVATYKVNYTRWLCYCHVPQSCDSLPRYETTHVFGRSLLRSIFTVTRRQLLEKFRVEKDKLVPEKRTLILTHFPKFLSMLEEEIYGANSPIWESGFTMPPSEGT*QLVP********RPA**SVSAAVVPSTPIFSPSMGGGSN******SS***LSLDSAGAE****************PMP*******************************GEKRTLPENLTLEDAKRLRVMGDIPMELVNEVMLTITDPAAMLGPE*TSLLSANAARDETARLEERRGIIEFHVIGNSLTPKANRRVLLWLVGLQNVFSHQLPRMPKEYIARLVFDPKHKTLALIKDGRVIGGICFRMFP****TQGFTEIVFCAVTSNEQVKGYGTHLMNHLKEYHIKHNILYFL*TYADEYAIGYFKKQGFSKDIKVPKSRYLGYIKDYEGATLMECELNPRIPYTELSHIIKKQKEIIKKLIERKQAQIRKVYPGLSC*FKEGVRQIPVESVPGI*RETGWKPLGKEKGKELKDPDQLYTTLKNLLAQI*K**SHPSAWPFMEPVKKSEAPDYYEVIRFPI***DLKTMTERLRSRYYVTRKLFVADLQRVIANCREYNPPDSEYCRCASALEKFFYFKLKEGGLIDK';

ok( $cleaner->get_result->seq eq $expected_result, 'Got expected cleaned sequence');

$cleaner->update(1,$costs_values{'specificity'});

my $specificity_expected_result = '                                                               GSTGTGGPGVGSGGAG*******SGGDPARPGLSQQQ**RASQRKAQVRGLPRAKKLEKLGVFSACKANETCKCNGWKNPK*****P*PTAPRMDLQQPAANLSELCRSCEHPLA*DHVSH*LENVSEDEINRLLGMVVDVENLFMSV***HKEEDTDTKQVY*FYLFKLLRKCILQMTRPVVEGSLG*SPPFEKPNIEQ**GVLNFVQYKFSHLAPRERQTMFELSKMFLLCLNYWKLETPAQFRQRSQAEDVATYKVNYTRWLCYCHVPQSCDSLPRYETTHVFGRSLLRSIFTVTRRQLLEKFRVEKDKLVPEKRTLILTHFPKFLSMLEEEIYGANSPIWESGFTMPPSEGT*QLVP********RPA**SVSAAVVPSTPIFSPSMGGGSN******SS***LSLDSAGAE****************PMP*******************************GEKRTLPENLTLEDAKRLRVMGDIPMELVNEVMLTITDPAAMLGPE*TSLLSANAARDETARLEERRGIIEFHVIGNSLTPKANRRVLLWLVGLQNVFSHQLPRMPKEYIARLVFDPKHKTLALIKDGRVIGGICFRMFP****TQGFTEIVFCAVTSNEQVKGYGTHLMNHLKEYHIKHNILYFL*TYADEYAIGYFKKQGFSKDIKVPKSRYLGYIKDYEGATLMECELNPRIPYTELSHIIKKQKEIIKKLIERKQAQIRKVYPGLSC*FKEGVRQIPVESVPGI*RETGWKPLGKEKGKELKDPDQLYTTLKNLLAQI*K**SHPSAWPFMEPVKKSEAPDYYEVIRFPI***DLKTMTERLRSRYYVTRKLFVADLQRVIANCREYNPPDSEYCRCASALEKFFYFKLKEGGLIDK';

ok( $cleaner->get_result->seq eq $specificity_expected_result, 'Got expected cleaned sequence after cleaner update');

done_testing;
