/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntKeyIntValueHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;

final class CompiledStatementManager {
    private Database database;
    private IntKeyHashMap schemaMap;
    private IntKeyHashMap sqlLookup;
    private IntKeyHashMap csidMap;
    private IntKeyHashMap sessionMap;
    private IntKeyIntValueHashMap useMap;
    private int next_cs_id;

    CompiledStatementManager(Database database) {
        this.database = database;
        this.schemaMap = new IntKeyHashMap();
        this.sqlLookup = new IntKeyHashMap();
        this.csidMap = new IntKeyHashMap();
        this.sessionMap = new IntKeyHashMap();
        this.useMap = new IntKeyIntValueHashMap();
        this.next_cs_id = 0;
    }

    synchronized void reset() {
        this.schemaMap.clear();
        this.sqlLookup.clear();
        this.csidMap.clear();
        this.sessionMap.clear();
        this.useMap.clear();
        this.next_cs_id = 0;
    }

    synchronized void resetStatements() {
        Iterator iterator = this.csidMap.values().iterator();
        while (iterator.hasNext()) {
            CompiledStatement compiledStatement = (CompiledStatement)iterator.next();
            compiledStatement.clearVariables();
        }
    }

    private int nextID() {
        ++this.next_cs_id;
        return this.next_cs_id;
    }

    synchronized int getStatementID(HsqlNameManager.HsqlName hsqlName, String string) {
        IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(hsqlName.hashCode());
        if (intValueHashMap == null) {
            return -1;
        }
        return intValueHashMap.get((Object)string, -1);
    }

    synchronized CompiledStatement getStatement(int n) {
        return (CompiledStatement)this.csidMap.get(n);
    }

    synchronized String getSql(int n) {
        return (String)this.sqlLookup.get(n);
    }

    synchronized void linkSession(int n, int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.get(n2);
        if (intKeyIntValueHashMap == null) {
            intKeyIntValueHashMap = new IntKeyIntValueHashMap();
            this.sessionMap.put(n2, intKeyIntValueHashMap);
        }
        int n3 = intKeyIntValueHashMap.get(n, 0);
        intKeyIntValueHashMap.put(n, n3 + 1);
        if (n3 == 0) {
            this.useMap.put(n, this.useMap.get(n, 0) + 1);
        }
    }

    synchronized int registerStatement(int n, CompiledStatement compiledStatement) {
        if (n < 0) {
            n = this.nextID();
            int n2 = compiledStatement.schemaHsqlName.hashCode();
            IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n2);
            if (intValueHashMap == null) {
                intValueHashMap = new IntValueHashMap();
                this.schemaMap.put(n2, intValueHashMap);
            }
            intValueHashMap.put(compiledStatement.sql, n);
            this.sqlLookup.put(n, compiledStatement.sql);
        }
        this.csidMap.put(n, compiledStatement);
        return n;
    }

    synchronized void freeStatement(int n, int n2) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.get(n2);
        int n3 = intKeyIntValueHashMap.get(n) - 1;
        if (n3 != 0) {
            intKeyIntValueHashMap.put(n, n3);
        } else {
            intKeyIntValueHashMap.remove(n);
            int n4 = this.useMap.get(n, 1) - 1;
            if (n4 == 0) {
                CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n);
                if (compiledStatement != null) {
                    int n5 = compiledStatement.schemaHsqlName.hashCode();
                    IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n5);
                    String string = (String)this.sqlLookup.remove(n);
                    intValueHashMap.remove(string);
                }
                this.useMap.remove(n);
            } else {
                this.useMap.put(n, n4);
            }
        }
    }

    synchronized void removeSession(int n) {
        IntKeyIntValueHashMap intKeyIntValueHashMap = (IntKeyIntValueHashMap)this.sessionMap.remove(n);
        if (intKeyIntValueHashMap == null) {
            return;
        }
        Iterator iterator = intKeyIntValueHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n2 = iterator.nextInt();
            int n3 = this.useMap.get(n2, 1) - 1;
            if (n3 == 0) {
                CompiledStatement compiledStatement = (CompiledStatement)this.csidMap.remove(n2);
                if (compiledStatement != null) {
                    int n4 = compiledStatement.schemaHsqlName.hashCode();
                    IntValueHashMap intValueHashMap = (IntValueHashMap)this.schemaMap.get(n4);
                    String string = (String)this.sqlLookup.remove(n2);
                    intValueHashMap.remove(string);
                }
                this.useMap.remove(n2);
                continue;
            }
            this.useMap.put(n2, n3);
        }
    }
}

