#!perl

use strict;
use warnings;
use Test::More tests => 2;

use Pod::Advent;

chdir 'ex';

my $advent = Pod::Advent->new;
isa_ok($advent, 'Pod::Advent');
my $s;
$advent->output_string( \$s );
$advent->parse_file( 'sample.pod' );

my $html = do{ local $/ = undef; open FILE, '<', 'sample.html'; <FILE> };

# Strip the 'Generated by' line before comparison, since that line is time- and system-dependent.
s/^<!-- Generated by Pod::Advent .+? -->$//m for $html, $s;

is($s, $html, "file matches!");

#open FILE, '>', '/tmp/s'; print FILE $s; close FILE;

