######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT -12
package Geo::Location::TimeZone::Y;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude -187.5 to -172.5
	"-12" => {
		# Grid -12:-6 ; 1 records
		"-6" => {
			"15" => {
				"z" => "Antartica/South_Pole",
				"c" => "ESRI",
				"s" => "5,2",
				"p" => [[-172.5,-90],[-180,-90],[-180,-82.5],[-172.5,-82.5],[-172.5,-90],],
			},
		},
		# Grid -12:-5 ; No records found
		# Grid -12:-4 ; No records found
		# Grid -12:-3 ; 2 records
		"-3" => {
			"def_z" => "Etc/GMT+12",
			"439" => {
				"z" => "Pacific/Chatham",
				"c" => "ESRI",
				"s" => "31,1",
				"p" => [[-175.08235168457,-43.0007781982422],[-175.08235168457,-46.5068168640137],[-180,-46.5068168640137],[-180,-43.0007781982422],[-175.08235168457,-43.0007781982422],],
			},
		},
		# Grid -12:-2 ; 2 records
		"-2" => {
			"def_z" => "Etc/GMT+12",
			"410" => {
				"z" => "Etc/GMT+13",
				"c" => "ESRI",
				"s" => "26,1",
				"p" => [[-172.5,-23.5],[-180,-23.5],[-180,-22.5],[-172.5,-22.5],[-172.5,-23.5],],
			},
		},
		# Grid -12:-1 ; 4 records
		"-1" => {
			"def_z" => "Pacific/Wallis",
			"242" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.5,-10.4612655639648],[-172.5,-10.4988364420371],[-172.930679321289,-10.5020990371704],[-172.930679321289,-7.5],[-172.5,-7.5],[-172.5,-22.5],[-172.5,-10.4612655639648],],
			},
			"290" => {
				"z" => "Etc/GMT-11",
				"c" => "ESRI",
				"s" => "18,2",
				"p" => [[-172.5,-15],[-178.125,-7.5],[-172.930679321289,-7.5],[-172.930679321289,-10.5020990371704],[-172.5,-10.4988364420371],[-172.5,-22.5],[-172.5,-15],],
			},
			"411" => {
				"z" => "Pacific/Tongatapu",
				"c" => "ESRI",
				"s" => "26,1",
				"p" => [[-180,-22.5],[-180,-21.8781814575195],[-177,-20.9913902282715],[-177,-15],[-172.5,-15],[-172.5,-22.5],[-180,-22.5],],
			},
		},
		# Grid -12:0 ; 3 records
		"0" => {
			"def_z" => "Etc/GMT-11",
			"243" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.930679321289,-7.5],[-172.930679321289,-7.07195949554443],[-172.5,-7.0735907550118],[-172.5,7.5],[-172.5,-7.5],[-172.930679321289,-7.5],],
			},
			"433" => {
				"z" => "Etc/GMT+12",
				"c" => "ESRI",
				"s" => "28,3",
				"p" => [[-180,-7.5],[-180,-5],[-178.125,-7.5],[-172.5,-7.5],[-180,-7.5],],
			},
		},
		# Grid -12:1 ; 2 records
		"1" => {
			"def_z" => "Etc/GMT-11",
			"244" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.930679321289,7.5],[-172.5,7.5],[-172.5,14.4327389046082],[-174.681884765625,14.4439496994019],[-174.681884765625,22.5],[-172.5,22.5],[-172.5,7.5],[-172.930679321289,7.5],],
			},
		},
		# Grid -12:2 ; 2 records
		"2" => {
			"def_z" => "Pacific/Midway",
			"245" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,4",
				"p" => [[-172.930679321289,22.5],[-174.681884765625,22.5],[-174.681884765625,22.550802230835],[-172.5,22.550802230835],[-172.5,22.5],[-172.930679321289,22.5],],
			},
		},
		# Grid -12:3 ; 2 records
		"3" => {
			"def_z" => "Etc/GMT-11",
			"238" => {
				"z" => "America/Adak",
				"c" => "ESRI",
				"s" => "16,3",
				"p" => [[-172.5,50.0105380809456],[-180,50.0103034973145],[-180,52.5],[-172.5,52.5],[-172.5,50.0105380809456],],
			},
		},
		# Grid -12:4 ; 3 records
		"4" => {
			"def_z" => "Etc/GMT+12",
			"20" => {
				"z" => "America/Anchorage",
				"c" => "ESRI",
				"s" => "6,1",
				"p" => [[-172.5,56.5969390869141],[-172.5,55.0223144913913],[-180,55.0266532897949],[-180,58.9523811340332],[-172.5,63.4166667244651],[-172.5,59.8019332885742],[-172.5,56.5969390869141],],
			},
			"239" => {
				"z" => "Etc/GMT-10",
				"c" => "ESRI",
				"s" => "16,3",
				"p" => [[-172.5,52.5],[-180,52.5],[-180,55.0266532897949],[-172.5,55.0223144913913],[-172.5,52.5],],
			},
		},
		# Grid -12:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT+12",
			"288" => {
				"z" => "Etc/GMT-11",
				"c" => "ESRI",
				"s" => "18,1",
				"p" => [[-172.5,68],[-172.5,70.2272685764976],[-172.509033203125,70.2330169677734],[-172.509033203125,82.5],[-172.5,82.5],[-172.5,68],],
			},
		},
		# Grid -12:6 ; 1 records
		"6" => {
			"289" => {
				"z" => "Etc/GMT-11",
				"c" => "ESRI",
				"s" => "18,1",
				"p" => [[-172.509033203125,82.5],[-172.509033203125,90],[-172.5,90],[-172.5,82.5],[-172.509033203125,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
