/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.TupleFilter;
import org.apache.derby.iapi.types.BooleanDataValue;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;

public class DropDependencyFilter
implements TupleFilter {
    UUID providerID;
    UUIDFactory uuidFactory = null;
    DataValueFactory dataValueFactory = null;
    BooleanDataValue trueValue;
    BooleanDataValue falseValue;

    public DropDependencyFilter(UUID uUID) {
        this.providerID = uUID;
    }

    public void init(ExecRow execRow) throws StandardException {
    }

    public BooleanDataValue execute(ExecRow execRow) throws StandardException {
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(3);
        String string = dataValueDescriptor.getString();
        UUID uUID = this.getUUIDFactory().recreateUUID(string);
        if (this.providerID.equals(uUID)) {
            return this.getTrueValue();
        }
        return this.getFalseValue();
    }

    private UUIDFactory getUUIDFactory() throws StandardException {
        if (this.uuidFactory == null) {
            this.uuidFactory = Monitor.getMonitor().getUUIDFactory();
        }
        return this.uuidFactory;
    }

    private DataValueFactory getDataValueFactory() {
        if (this.dataValueFactory == null) {
            LanguageConnectionContext languageConnectionContext = (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
            this.dataValueFactory = languageConnectionContext.getDataValueFactory();
        }
        return this.dataValueFactory;
    }

    private BooleanDataValue getTrueValue() throws StandardException {
        if (this.trueValue == null) {
            this.trueValue = this.getDataValueFactory().getDataValue(true);
        }
        return this.trueValue;
    }

    private BooleanDataValue getFalseValue() throws StandardException {
        if (this.falseValue == null) {
            this.falseValue = this.getDataValueFactory().getDataValue(false);
        }
        return this.falseValue;
    }
}

