package App::InteractivePerlTutorial::Chapter::Control::IncrementDecrement;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Autoincrement';

1;
__DATA__

=encoding utf-8

=head1 Autoincrement

=over

=item The B<autoincrement> operator (C<++>) adds one to a scalar variable:

  $x=7;
  $x++;  # $x is now 8;

Let's make a program that counts how many times each word appears in a list:

  @numbers= {one two three one two five seven six six two};
  my %number;
  $number{$_}++ foreach @people; #creates new values as needed


=item The B<autodecrement> operator (C<< -- >>) subtracts one from a scalar variable:

  $x=7;
  $x--;  # $x is now 6;


=item B<preincrement> is when you put the C<++> operator in front of the variable name. This increments the variable and returns the B<new> value.

  my $x = 4;
  my $y = ++$x;  # increment $x to 5, and set $y to 5


=item B<predecrement> is when you put the C<< -- >> operator in front of the variable name. This decrements the variable and returns the B<new> value.

  my $x = 4;
  my $y = --$x;  # decrement $x to 3, and set $y to 3


=item B<postincrement> is when you put the C<++> operator after the variable name. This increments the variable and returns the B<old> value.

  my $x = 4;
  my $y = $x++;  # set $y to 4, increment $x to 5


=item B<postdecrement> is when you put the C<< -- >> operator after the variable name. This decrements the variable and returns the B<old> value.

  my $x = 4;
  my $y = $x--;  # set $y to 4, decrement $x to 3

=back


=cut
