/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.plugin;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.management.JMException;
import javax.management.ObjectName;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.activemq.broker.Broker;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.plugin.AbstractRuntimeConfigurationBroker;
import org.apache.activemq.plugin.ConfigurationProcessor;
import org.apache.activemq.plugin.ProcessorFactory;
import org.apache.activemq.plugin.PropertiesPlaceHolderUtil;
import org.apache.activemq.plugin.jmx.RuntimeConfigurationView;
import org.apache.activemq.schema.core.DtoBroker;
import org.apache.activemq.spring.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RuntimeConfigurationBroker
extends AbstractRuntimeConfigurationBroker {
    public static final Logger LOG = LoggerFactory.getLogger(RuntimeConfigurationBroker.class);
    public static final String objectNamePropsAppendage = ",service=RuntimeConfiguration,name=Plugin";
    PropertiesPlaceHolderUtil placeHolderUtil = null;
    private long checkPeriod;
    private long lastModified = -1L;
    private Resource configToMonitor;
    private DtoBroker currentConfiguration;
    private Schema schema;

    public RuntimeConfigurationBroker(Broker next) {
        super(next);
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            BrokerContext brokerContext = this.next.getBrokerService().getBrokerContext();
            if (brokerContext != null) {
                this.configToMonitor = Utils.resourceFromString((String)brokerContext.getConfigurationUrl());
                this.info("Configuration " + String.valueOf(this.configToMonitor));
            } else {
                LOG.error("Null BrokerContext; impossible to determine configuration url resource from broker, updates cannot be tracked");
            }
        }
        catch (Exception error) {
            LOG.error("failed to determine configuration url resource from broker, updates cannot be tracked", (Throwable)error);
        }
        this.currentConfiguration = this.loadConfiguration(this.configToMonitor);
        this.monitorModification(this.configToMonitor);
        this.registerMbean();
    }

    @Override
    protected void registerMbean() {
        if (this.getBrokerService().isUseJmx()) {
            ManagementContext managementContext = this.getBrokerService().getManagementContext();
            try {
                this.objectName = new ObjectName(this.getBrokerService().getBrokerObjectName().toString() + objectNamePropsAppendage);
                managementContext.registerMBean((Object)new RuntimeConfigurationView(this), this.objectName);
            }
            catch (Exception ignored) {
                LOG.debug("failed to register RuntimeConfigurationMBean", (Throwable)ignored);
            }
        }
    }

    @Override
    protected void unregisterMbean() {
        if (this.objectName != null) {
            try {
                this.getBrokerService().getManagementContext().unregisterMBean(this.objectName);
            }
            catch (JMException jMException) {
                // empty catch block
            }
        }
    }

    public String updateNow() {
        LOG.info("Manual configuration update triggered");
        this.infoString = "";
        this.applyModifications(this.configToMonitor);
        String result = this.infoString;
        this.infoString = null;
        return result;
    }

    private void monitorModification(final Resource configToMonitor) {
        this.monitorTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (configToMonitor.lastModified() > RuntimeConfigurationBroker.this.lastModified) {
                        RuntimeConfigurationBroker.this.applyModifications(configToMonitor);
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to determine lastModified time on configuration: " + String.valueOf(configToMonitor), e);
                }
            }
        };
        if (this.lastModified > 0L && this.checkPeriod > 0L) {
            this.getBrokerService().getScheduler().executePeriodically(this.monitorTask, this.checkPeriod);
            this.info("Monitoring for updates (every " + this.checkPeriod + "millis) : " + String.valueOf(configToMonitor) + ", lastUpdate: " + String.valueOf(new Date(this.lastModified)));
        }
    }

    private void applyModifications(Resource configToMonitor) {
        DtoBroker changed = this.loadConfiguration(configToMonitor);
        if (changed != null && !this.currentConfiguration.equals(changed)) {
            LOG.info("change in " + String.valueOf(configToMonitor) + " at: " + String.valueOf(new Date(this.lastModified)));
            LOG.debug("current:" + this.filterPasswords(this.currentConfiguration));
            LOG.debug("new    :" + this.filterPasswords(changed));
            this.processSelectiveChanges(this.currentConfiguration, changed);
            this.currentConfiguration = changed;
        } else {
            this.info("No material change to configuration in " + String.valueOf(configToMonitor) + " at: " + String.valueOf(new Date(this.lastModified)));
        }
    }

    private void processSelectiveChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration) {
        for (Class upDatable : new Class[]{DtoBroker.DestinationPolicy.class, DtoBroker.NetworkConnectors.class, DtoBroker.DestinationInterceptors.class, DtoBroker.Plugins.class, DtoBroker.Destinations.class}) {
            this.processChanges(currentConfiguration, modifiedConfiguration, upDatable);
        }
    }

    private void processChanges(DtoBroker currentConfiguration, DtoBroker modifiedConfiguration, Class upDatable) {
        ConfigurationProcessor processor = ProcessorFactory.createProcessor(this, upDatable);
        processor.processChanges(currentConfiguration, modifiedConfiguration);
    }

    private DtoBroker loadConfiguration(Resource configToMonitor) {
        DtoBroker jaxbConfig = null;
        if (configToMonitor != null) {
            try {
                JAXBContext context = JAXBContext.newInstance((String)DtoBroker.class.getPackageName(), (ClassLoader)DtoBroker.class.getClassLoader());
                Unmarshaller unMarshaller = context.createUnmarshaller();
                unMarshaller.setSchema(this.getSchema());
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document doc = db.parse(configToMonitor.getInputStream());
                Node brokerRootNode = doc.getElementsByTagNameNS("*", "broker").item(0);
                if (brokerRootNode != null) {
                    JAXBElement brokerJAXBElement = unMarshaller.unmarshal(brokerRootNode, DtoBroker.class);
                    jaxbConfig = (DtoBroker)brokerJAXBElement.getValue();
                    this.lastModified = configToMonitor.lastModified();
                    this.loadPropertiesPlaceHolderSupport(doc);
                } else {
                    this.info("Failed to find 'broker' element by tag in: " + String.valueOf(configToMonitor));
                }
            }
            catch (IOException e) {
                this.info("Failed to access: " + String.valueOf(configToMonitor), e);
            }
            catch (JAXBException e) {
                this.info("Failed to parse: " + String.valueOf(configToMonitor), e);
            }
            catch (ParserConfigurationException e) {
                this.info("Failed to document parse: " + String.valueOf(configToMonitor), e);
            }
            catch (SAXException e) {
                this.info("Failed to find broker element in: " + String.valueOf(configToMonitor), e);
            }
            catch (Exception e) {
                this.info("Unexpected exception during load of: " + String.valueOf(configToMonitor), e);
            }
        }
        return jaxbConfig;
    }

    private void loadPropertiesPlaceHolderSupport(Document doc) {
        BrokerContext brokerContext = this.getBrokerService().getBrokerContext();
        if (brokerContext != null) {
            Properties initialProperties = new Properties(System.getProperties());
            this.placeHolderUtil = new PropertiesPlaceHolderUtil(initialProperties);
            this.placeHolderUtil.mergeProperties(doc, initialProperties, brokerContext);
        }
    }

    private Schema getSchema() throws SAXException, IOException {
        if (this.schema == null) {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            ArrayList<StreamSource> schemas = new ArrayList<StreamSource>();
            schemas.add(new StreamSource(((Object)((Object)this)).getClass().getResource("/activemq.xsd").toExternalForm()));
            if (((Object)((Object)this)).getClass().getResource("/org/springframework/beans/factory/xml/spring-beans-3.0.xsd") != null) {
                schemas.add(new StreamSource(((Object)((Object)this)).getClass().getResource("/org/springframework/beans/factory/xml/spring-beans-3.0.xsd").toExternalForm()));
            } else {
                schemas.add(new StreamSource(((Object)((Object)this)).getClass().getResource("/org/springframework/beans/factory/xml/spring-beans.xsd").toExternalForm()));
            }
            this.schema = schemaFactory.newSchema(schemas.toArray(new Source[0]));
        }
        return this.schema;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public Resource getConfigToMonitor() {
        return this.configToMonitor;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }
}

