/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.ServletPathSpec;
import org.eclipse.jetty.rewrite.handler.PatternRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.Name;

public class RewritePatternRule
extends PatternRule
implements Rule.ApplyURI {
    private String _replacement;
    private String _query;

    public RewritePatternRule() {
        this(null, null);
    }

    public RewritePatternRule(@Name(value="pattern") String pattern, @Name(value="replacement") String replacement) {
        super(pattern);
        this._handling = false;
        this._terminating = false;
        this.setReplacement(replacement);
    }

    public void setReplacement(String replacement) {
        if (replacement == null) {
            this._replacement = null;
            this._query = null;
        } else {
            String[] split = replacement.split("\\?", 2);
            this._replacement = split[0];
            this._query = split.length == 2 ? split[1] : null;
        }
    }

    @Override
    public String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        target = URIUtil.addPaths((String)this._replacement, (String)ServletPathSpec.pathInfo((String)this._pattern, (String)target));
        return target;
    }

    @Override
    public void applyURI(Request request, String oldURI, String newURI) throws IOException {
        HttpURI baseURI = request.getHttpURI();
        String query = URIUtil.addQueries((String)baseURI.getQuery(), (String)this._query);
        request.setHttpURI((HttpURI)HttpURI.build((HttpURI)baseURI, (String)newURI, (String)baseURI.getParam(), (String)query));
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this._replacement + "]";
    }
}

