/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.jmx;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.activemq.broker.jmx.Log4JConfigViewMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Log4JConfigView
implements Log4JConfigViewMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Log4JConfigView.class);

    @Override
    public String getRootLogLevel() throws Exception {
        ClassLoader cl = Log4JConfigView.getClassLoader();
        if (!Log4JConfigView.isLog4JAvailable(cl)) {
            return null;
        }
        Class<?> logManagerClass = Log4JConfigView.getLogManagerClass(cl);
        Class<?> loggerClass = Log4JConfigView.getLoggerClass(cl);
        if (logManagerClass == null || loggerClass == null) {
            return null;
        }
        Method getRootLogger = logManagerClass.getMethod("getRootLogger", new Class[0]);
        Method getLevel = loggerClass.getMethod("getLevel", new Class[0]);
        Object rootLogger = getRootLogger.invoke(null, (Object[])null);
        return getLevel.invoke(rootLogger, (Object[])null).toString();
    }

    @Override
    public void setRootLogLevel(String level) throws Exception {
        ClassLoader cl = Log4JConfigView.getClassLoader();
        if (!Log4JConfigView.isLog4JAvailable(cl)) {
            return;
        }
        Class<?> configuratorClass = Log4JConfigView.getConfiguratorClass(cl);
        Class<?> loggerClass = Log4JConfigView.getLoggerClass(cl);
        Class<?> levelClass = Log4JConfigView.getLevelClass(cl);
        if (configuratorClass == null || levelClass == null || loggerClass == null) {
            return;
        }
        String targetLevel = level.toUpperCase(Locale.US);
        Method setRootLevel = configuratorClass.getMethod("setRootLevel", levelClass);
        Method toLevel = levelClass.getMethod("toLevel", String.class);
        Object newLevel = toLevel.invoke(null, targetLevel);
        if (newLevel != null && newLevel.toString().equals(targetLevel)) {
            LOG.debug("Set level {} for root logger.", (Object)level);
            setRootLevel.invoke(configuratorClass, newLevel);
        }
    }

    @Override
    public List<String> getLoggers() throws Exception {
        ClassLoader cl = Log4JConfigView.getClassLoader();
        if (!Log4JConfigView.isLog4JAvailable(cl)) {
            return Collections.emptyList();
        }
        Class<?> logManagerClass = Log4JConfigView.getLogManagerClass(cl);
        Class<?> loggerClass = Log4JConfigView.getLoggerClass(cl);
        Class<?> loggerConfigClass = Log4JConfigView.getLoggerConfigClass(cl);
        if (logManagerClass == null || loggerClass == null || loggerConfigClass == null) {
            return Collections.emptyList();
        }
        Method getContext = logManagerClass.getMethod("getContext", Boolean.TYPE);
        Object logContext = getContext.invoke(logManagerClass, false);
        Method getConfiguration = logContext.getClass().getMethod("getConfiguration", new Class[0]);
        Object configuration = getConfiguration.invoke(logContext, new Object[0]);
        Method getLoggers = configuration.getClass().getMethod("getLoggers", new Class[0]);
        Method getName = loggerConfigClass.getMethod("getName", new Class[0]);
        ArrayList<String> list = new ArrayList<String>();
        Map loggers = (Map)getLoggers.invoke(configuration, new Object[0]);
        for (Object logger : loggers.values()) {
            if (logger == null) continue;
            list.add((String)getName.invoke(logger, (Object[])null));
        }
        LOG.debug("Found {} loggers", (Object)list.size());
        return list;
    }

    @Override
    public String getLogLevel(String loggerName) throws Exception {
        ClassLoader cl = Log4JConfigView.getClassLoader();
        if (!Log4JConfigView.isLog4JAvailable(cl)) {
            return null;
        }
        Class<?> logManagerClass = Log4JConfigView.getLogManagerClass(cl);
        Class<?> loggerClass = Log4JConfigView.getLoggerClass(cl);
        if (logManagerClass == null || loggerClass == null) {
            return null;
        }
        Method getLogger = logManagerClass.getMethod("getLogger", String.class);
        String logLevel = null;
        if (loggerName != null && !loggerName.isEmpty()) {
            Object logger = getLogger.invoke(null, loggerName);
            if (logger != null) {
                LOG.debug("Found level {} for logger: {}", (Object)logLevel, (Object)loggerName);
                Method getLevel = loggerClass.getMethod("getLevel", new Class[0]);
                Object level = getLevel.invoke(logger, (Object[])null);
                if (level != null) {
                    logLevel = level.toString();
                } else {
                    Method getRootLogger = loggerClass.getMethod("getRootLogger", new Class[0]);
                    Object rootLogger = getRootLogger.invoke(null, (Object[])null);
                    logLevel = getLevel.invoke(rootLogger, (Object[])null).toString();
                }
            }
        } else {
            throw new IllegalArgumentException("Logger names cannot be null or empty strings");
        }
        return logLevel;
    }

    @Override
    public void setLogLevel(String loggerName, String level) throws Exception {
        if (loggerName == null || loggerName.isEmpty()) {
            throw new IllegalArgumentException("Logger names cannot be null or empty strings");
        }
        if (level == null || level.isEmpty()) {
            throw new IllegalArgumentException("Level name cannot be null or empty strings");
        }
        ClassLoader cl = Log4JConfigView.getClassLoader();
        if (!Log4JConfigView.isLog4JAvailable(cl)) {
            return;
        }
        Class<?> configuratorClass = Log4JConfigView.getConfiguratorClass(cl);
        Class<?> loggerClass = Log4JConfigView.getLoggerClass(cl);
        Class<?> levelClass = Log4JConfigView.getLevelClass(cl);
        if (configuratorClass == null || loggerClass == null || levelClass == null) {
            return;
        }
        String targetLevel = level.toUpperCase(Locale.US);
        Method setLevel = configuratorClass.getMethod("setLevel", String.class, levelClass);
        Method toLevel = levelClass.getMethod("toLevel", String.class);
        Object newLevel = toLevel.invoke(null, targetLevel);
        if (newLevel != null && newLevel.toString().equals(targetLevel)) {
            LOG.debug("Set level {} for logger: {}", (Object)level, (Object)loggerName);
            setLevel.invoke(configuratorClass, loggerName, newLevel);
        }
    }

    @Override
    public void reloadLog4jProperties() throws Throwable {
        Log4JConfigView.doReloadLog4jProperties();
    }

    public static void doReloadLog4jProperties() throws Throwable {
        try {
            ClassLoader cl = Log4JConfigView.class.getClassLoader();
            Class<?> logManagerClass = Log4JConfigView.getLogManagerClass(cl);
            if (logManagerClass == null) {
                LOG.debug("Could not locate log4j classes on classpath.");
                return;
            }
            Method getContext = logManagerClass.getMethod("getContext", Boolean.TYPE);
            Object logContext = getContext.invoke(logManagerClass, false);
            Method reconfigure = logContext.getClass().getMethod("reconfigure", new Class[0]);
            reconfigure.invoke(logContext, new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static boolean isLog4JAvailable() {
        return Log4JConfigView.isLog4JAvailable(Log4JConfigView.getClassLoader());
    }

    private static ClassLoader getClassLoader() {
        return Log4JConfigView.class.getClassLoader();
    }

    private static boolean isLog4JAvailable(ClassLoader cl) {
        if (Log4JConfigView.getLogManagerClass(cl) != null) {
            return true;
        }
        LOG.debug("Could not locate log4j classes on classpath.");
        return false;
    }

    private static Class<?> getLogManagerClass(ClassLoader cl) {
        return Log4JConfigView.getClass(cl, "org.apache.logging.log4j.LogManager");
    }

    private static Class<?> getLoggerClass(ClassLoader cl) {
        return Log4JConfigView.getClass(cl, "org.apache.logging.log4j.Logger");
    }

    private static Class<?> getLoggerConfigClass(ClassLoader cl) {
        return Log4JConfigView.getClass(cl, "org.apache.logging.log4j.core.config.LoggerConfig");
    }

    private static Class<?> getLevelClass(ClassLoader cl) {
        return Log4JConfigView.getClass(cl, "org.apache.logging.log4j.Level");
    }

    private static Class<?> getConfiguratorClass(ClassLoader cl) {
        return Log4JConfigView.getClass(cl, "org.apache.logging.log4j.core.config.Configurator");
    }

    private static Class<?> getClass(ClassLoader cl, String clazz) {
        Class<?> configuratorClass = null;
        try {
            configuratorClass = cl.loadClass(clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return configuratorClass;
    }
}

