/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.util.StringUtils;

public class LogCapturer
implements BuildListener {
    public static final String REFERENCE_ID = "ant.antunit.log";
    private List events = Collections.synchronizedList(new LinkedList());
    private Project p;

    public LogCapturer(Project p) {
        this.p = p;
        p.addBuildListener((BuildListener)this);
        p.addReference(REFERENCE_ID, (Object)this);
    }

    public String getErrLog() {
        return this.getErrLog(true);
    }

    public String getWarnLog() {
        return this.getWarnLog(true);
    }

    public String getInfoLog() {
        return this.getInfoLog(true);
    }

    public String getVerboseLog() {
        return this.getVerboseLog(true);
    }

    public String getDebugLog() {
        return this.getDebugLog(true);
    }

    public String getErrLog(boolean mergeLines) {
        return this.getLog(0, mergeLines);
    }

    public String getWarnLog(boolean mergeLines) {
        return this.getLog(1, mergeLines);
    }

    public String getInfoLog(boolean mergeLines) {
        return this.getLog(2, mergeLines);
    }

    public String getVerboseLog(boolean mergeLines) {
        return this.getLog(3, mergeLines);
    }

    public String getDebugLog(boolean mergeLines) {
        return this.getLog(4, mergeLines);
    }

    public void buildStarted(BuildEvent event) {
    }

    public void targetStarted(BuildEvent event) {
    }

    public void targetFinished(BuildEvent event) {
    }

    public void taskStarted(BuildEvent event) {
    }

    public void taskFinished(BuildEvent event) {
    }

    public void buildFinished(BuildEvent event) {
        if (this.p != null && event.getProject() == this.p) {
            this.p.removeBuildListener((BuildListener)this);
            this.p.getReferences().remove(REFERENCE_ID);
            this.p = null;
        }
    }

    public void messageLogged(BuildEvent event) {
        this.events.add(event);
    }

    private String getLog(int minPriority, boolean mergeLines) {
        StringBuffer sb = new StringBuffer();
        Iterator it = new LinkedList(this.events).iterator();
        while (it.hasNext()) {
            LogCapturer.append(sb, (BuildEvent)it.next(), minPriority, mergeLines);
        }
        return sb.toString();
    }

    private static void append(StringBuffer sb, BuildEvent event, int minPriority, boolean mergeLines) {
        if (event.getPriority() <= minPriority) {
            sb.append(event.getMessage());
            if (!mergeLines) {
                sb.append(StringUtils.LINE_SEP);
            }
        }
    }
}

